/*	
 *	clipslot.c
 *
 *	XbgQ[pTu[`W
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sun Jun 02 15:09:44 JST 2013 Naoyuki Sawa
 *	- 1st[XB
 *	* Sun Aug 18 17:39:58 JST 2013 Naoyuki Sawa
 *	- Ǘǉ܂B
 *	* Sat Mar 29 15:51:51 JST 2014 Naoyuki Sawa
 *	- epCǉ܂B
 *	* Tue Apr 01 00:42:49 JST 2014 Naoyuki Sawa
 *	- ܔǉ܂B
 *	- [zǉ܂B
 *	* Tue Apr 08 00:24:56 JST 2014 Naoyuki Sawa
 *	- Cǉ܂B
 *	- ǉ܂B
 *	* Sat May 03 23:21:41 JST 2014 Naoyuki Sawa
 *	- ~ǉ܂B
 *	* Mon May 05 15:01:01 JST 2014 Naoyuki Sawa
 *	- ~f[^r_ǉ܂B
 *	  PCŃc[쐬鎞Ɏgp܂BP/ECEł͎gp܂B
 *	* Mon May 12 12:39:59 JST 2014 Naoyuki Sawa
 *	- XybNf[^쐬Eo͂ǉ܂B
 *	  PCŃXybNf[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
 *	* Sat May 31 13:04:14 JST 2014 Naoyuki Sawa
 *	- Slot_PrintStpCtl()AST_Slot_StpCtl\̂o͂悤ɕύX܂B
 *	  ܂ł́ASlot_PrintStpCtl()͌X̃e[uo͂āAAvP[VST_Slot_StpCtl\̂`Ă܂B
 *	  ́ASlot_PrintStpCtl()ST_Slot_StpCtl\̂ɂ܂Ƃ߂ďo͂̂ŁAAvP[VŒ`Kv͂܂B
 *	* Wed Jun 18 20:20:39 JST 2014 Naoyuki Sawa
 *	- Slot_GetLineRow(),Slot_CheckTenpai(),Slot_CheckPrize()A5Cp7CpɊg܂B
 *	  @ɂĕsvȃĆAAvP[VŃ}XNĎgpĂB
 *	* Tue Jun 24 21:30:13 JST 2014 Naoyuki Sawa
 *	- Slot_MakeSpec()clipsl5n.h,clipsl5n.c֕܂B
 *	  W[(clipslot.h,clipslot.c)ɂ́AC^Cvɂ炸ʂ̃Tu[`݂̂c܂B
 *	* Tue Dec 16 21:51:08 JST 2014 Naoyuki Sawa
 *	- ԍt8byte`R}hǉ܂B
 *	* Wed Dec 17 21:50:28 JST 2014 Naoyuki Sawa
 *	- V{'SlotPos_Max'ŁA[ݒł悤ɂ܂B
 *	  ݒ\͈͂́AuSlotPos_Max=20v([=21),,uSlotPos_Max=19v([=20)łB
 *	  L͈̔͊ÓAςKvL̂ŁAݒsłB(4ߑłŃn[hR[fBOĂ邽߁B)
 *	- V{'SlotPos_Max'ύXꍇ́AW[̃rhKvłB
 *	  W[rhɁAAvP[V̐ݒ݂̂ŕύX邱Ƃ͂ł܂B
 *	- uSlotPos_Max=19v͖̓mFłB(܂ł́uSlotPos_Max=20vߑłō쐬Ă߁B)				2014/12/17_ł́TODOłB
 *	  uSlotPos_Max=19v̓mFƁAKvɉď̏CsKvL܂B					I炱̓s폜B
 *	* Sun Jul 24 21:18:15 JST 2016 Naoyuki Sawa
 *	- Slot_BuildStpCtl()ɂāATinyLZ_compress()̌ʂ256ȏɂȂɁA̓G[~ׂÂ܂(unsigned char)zɊi[Ă܂AԈf[^ĂoOC܂B
 *	  C@ƂẮAi[O(n<256)Ăǂ̂łA(unsigned char)z(unsigned short)zɕύXꍇɔāAi[Ɍ̒lƓrČ鎖ɂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	oǗ
 ****************************************************************************/

void SlotDeritu_Init(ST_SlotDeritu* Me) {
	/* SẴtB[h0NAB */
	memset(Me, 0, sizeof(ST_SlotDeritu));
}

/*--------------------------------------------------------------------------*/

void SlotDeritu_Update(ST_SlotDeritu* Me, int In, int Out) {
	/* Z,,̃Q[` */
	static const unsigned short TermLength[3/*0=Z,1=,2=*/] = { 400, 6000, 17500 };
	int iTerm, iLog;
	/* 0`3Ao0`15͈̔͂ł邱ƂmFB */
	if(((unsigned)In > 3) || ((unsigned)Out > 15)) { DIE(); }
	/* Z,,ɂĥ */
	for(iTerm = 0; iTerm < 3/*0=Z,1=,2=*/; iTerm++) {
		/* NQ[O̓(o)i[ĂAR[hCfNX(0`17499)߂B */
		iLog = (unsigned)(Me->GameCount - TermLength[iTerm] + 17500) % (unsigned)17500;
		/* (o)ɁA̓(o)𑫂ANQ[O̓(o)B
		 * - NQ[O̓(o)i[Ȃ΁AR[hl0Ȃ̂ŁAō\ȂB
		 */
		Me->TotalIn[ iTerm] += (In  - ((Me->InLog[ iLog>>2] >> ((iLog&3)<<1)) &  3));
		Me->TotalOut[iTerm] += (Out - ((Me->OutLog[iLog>>1] >> ((iLog&1)<<2)) & 15));
		/*                            NQ[O̓(o)  */
		/* NQ[ȏo߂Ăꍇ̂݁ANQ[Ԃ̏oZo\łB
		 * - ł͂܂o߃Q[i߂ĂȂ̂ŁA(NQ[-1)Ɣr邱ƂɒӂB
		 */
		if((unsigned)Me->GameCount >= (unsigned)(TermLength[iTerm] - 1/*LRgQ*/)) {
			/* o[%]o[][]~100 łB
			 * - ANQ[Ԃ̑0̏ꍇ̂݁Aoo~100 ƂB
			 *   NQ[ԁASčėVZIꍇɁA0ƂȂ邱Ƃ蓾B
			 */
			Me->Deritu[iTerm] = (double)Me->TotalOut[iTerm] * 100.0;
			if(Me->TotalIn[iTerm] != 0) { Me->Deritu[iTerm] /= Me->TotalIn[iTerm]; }
		} else {
			/* NQ[ȏo߂܂ł́ANQ[Ԃ̏oAl(0.0)̂܂܈ێB */
		}
	}
	/* ̓(o)i[AR[hCfNX(0`17499)߂B */
	iLog = Me->GameCount % 17500;
	/* (o)OɁA̓(o)i[B */
	Me->InLog[ iLog>>2] = (Me->InLog[ iLog>>2] & ~( 3 << ((iLog&3)<<1))) | (In  << ((iLog&3)<<1));
	Me->OutLog[iLog>>1] = (Me->OutLog[iLog>>1] & ~(15 << ((iLog&1)<<2))) | (Out << ((iLog&1)<<2));
	/* o߃Q[i߂BI[o[t[AG[~ƂB */
	if(++Me->GameCount == 0) { DIE(); }
}

/****************************************************************************
 *	Ǘ
 ****************************************************************************/

void SlotYakuhi_Init(ST_SlotYakuhi* Me) {
	/* SẴtB[h0NAB */
	memset(Me, 0, sizeof(ST_SlotYakuhi));
}

/*--------------------------------------------------------------------------*/

void SlotYakuhi_Update(ST_SlotYakuhi* Me, int Yak, int Out) {
	int iLog, YakLog, OutLog;
	/* 𕨍쓮tOA0,1̒lɕϊB */
	if(Yak) { Yak = 1; }
	/* o0`15͈̔͂ł邱ƂmFB */
	if((unsigned)Out > 15) { DIE(); }
	/* SoɁA̕o𑫂B */
	Me->AllOut += Out;
	/* 𕨍쓮Ȃ΁A𕨍쓮oɂA̕o𑫂B */
	if(Yak) { Me->YakOut += Out; }
	/* 6000Q[O̖𕨍쓮tO,y,oi[ĂAR[hCfNX(0`5999)߂B */
	iLog = Me->GameCount % 6000;
	/* 6000Q[O̖𕨍쓮tO,y,o擾B */
	YakLog = (Me->YakLog[iLog>>3] >> ((iLog&7)   )) &  1;
	OutLog = (Me->OutLog[iLog>>1] >> ((iLog&1)<<2)) & 15;
	/* OɁA̖𕨍쓮tO,y,oi[B */
	Me->YakLog[iLog>>3] = (Me->YakLog[iLog>>3] & ~( 1 << ((iLog&7)   ))) | (Yak << ((iLog&7)   ));
	Me->OutLog[iLog>>1] = (Me->OutLog[iLog>>1] & ~(15 << ((iLog&1)<<2))) | (Out << ((iLog&1)<<2));
	/* SoA6000Q[O̕oB */
	Me->AllOut -= OutLog;
	/* 6000Q[O𕨍쓮Ȃ΁A𕨍쓮oA6000Q[O̕oB */
	if(YakLog) { Me->YakOut -= OutLog; }
	/* o߃Q[i߂BI[o[t[AG[~ƂB */
	if(++Me->GameCount == 0) { DIE(); }
	/* 6000Q[ȏo߂Ăꍇ̂݁A6000Q[Ԃ̖Zo\łB */
	if(Me->GameCount >= 6000) {
		/* [%]𕨍쓮o[]So[]~100 łB
		 * - A6000Q[Ԃ̑So0̏ꍇ̂݁A䁁𕨍쓮o~100 ƂB
		 *   6000Q[ԁASĂ͂,,ėVZIꍇɁASo0ƂȂ邱Ƃ蓾B
		 */
		Me->Yakuhi = (double)Me->YakOut * 100.0;
		if(Me->AllOut != 0) { Me->Yakuhi /= Me->AllOut; }
	} else {
		/* 6000Q[ȏo߂܂ł́A6000Q[Ԃ̖Al(0.0)̂܂܈ێB */
	}
}

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef PIECE
int Slot_GetOrderReel(int iOrder, int iStop) {
	if(((unsigned)iOrder > 5) || ((unsigned)iStop > 2)) { DIE(); }
	if((iOrder -= 3) < 0) { iOrder += iStop; }	/* LCR,CRL,RLC */	//(-3`1)
	                 else { iOrder -= iStop; }	/* LRC,CLR,RCL */	//(-2`2)(-3`2)
	if(iOrder < 0) { iOrder += 3; }						//         ( 0`2)
	return iOrder;
}
#else //PIECE
int Slot_GetOrderReel(int iOrder, int iStop);
asm("
		.code
		.align		1
		.global		Slot_GetOrderReel
Slot_GetOrderReel:
		cmp		%r12, 5			;// if((unsigned)iOrder > 5) { DIE }
		jrugt		Slot_GetOrderReel_DIE
		cmp		%r13, 2			;// if((unsigned)iStop  > 2) { DIE }
		jrugt		Slot_GetOrderReel_DIE
		sub		%r12, 3			;// %r12 :=   iOrder -= 3
		jrlt.d		4			;// if(iOrder) < 0) {
		add		%r12, %r13		;// %r12 :=   iOrder += iStop } else {	*delay*		%psr(N)=?,%psr(V)=0	̉ZŃI[o[t[͔Ȃ̂ŁA%psr(V)=0ƂȂB
		 sub		%r12, %r13		;//   %r12 := iOrder									
		 sub		%r12, %r13		;//   %r12 := iOrder -= iStop }				%psr(N)=?,%psr(V)=0	̌ZŃI[o[t[͔Ȃ̂ŁA%psr(V)=0ƂȂB
		jrge		2			;// if(iOrder < 0) {					jrge̕(N=V)B%psr(V)=0Ȃ̂ŁA%psr(N)݂̂ŔfB
		 add		%r12, 3			;//   %r12 := iOrder += 3 }
		ret.d					;// return    iOrder
		ld.w		%r10, %r12		;// %r10   := iOrder			*delay*
");
static void __attribute__((noreturn,unused)) Slot_GetOrderReel_DIE() { DIE(); }
#endif//PIECE

//eXgXC[g
//void TestSuite() {
//  if((Slot_GetOrderReel(Slot_Order_LCR,0)!=0)||(Slot_GetOrderReel(Slot_Order_LCR,1)!=1)||(Slot_GetOrderReel(Slot_Order_LCR,2)!=2)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_CRL,0)!=1)||(Slot_GetOrderReel(Slot_Order_CRL,1)!=2)||(Slot_GetOrderReel(Slot_Order_CRL,2)!=0)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_RLC,0)!=2)||(Slot_GetOrderReel(Slot_Order_RLC,1)!=0)||(Slot_GetOrderReel(Slot_Order_RLC,2)!=1)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_LRC,0)!=0)||(Slot_GetOrderReel(Slot_Order_LRC,1)!=2)||(Slot_GetOrderReel(Slot_Order_LRC,2)!=1)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_CLR,0)!=1)||(Slot_GetOrderReel(Slot_Order_CLR,1)!=0)||(Slot_GetOrderReel(Slot_Order_CLR,2)!=2)){DIE();}
//  if((Slot_GetOrderReel(Slot_Order_RCL,0)!=2)||(Slot_GetOrderReel(Slot_Order_RCL,1)!=1)||(Slot_GetOrderReel(Slot_Order_RCL,2)!=0)){DIE();}
//}

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int Slot_FindOrder(int iReel1, int iReel2) {
	if(((unsigned)iReel1 > 2) || ((unsigned)iReel2 > 2) || (iReel1 == iReel2)) { DIE(); }
	if((iReel2 -= iReel1) < 0) { iReel2 += 3; }	//iReel2=1,2
	if(iReel2 != 1) { iReel1 += 3; }		//iReel1=0~5
	return iReel1;
}
#else //PIECE
int Slot_FindOrder(int iReel1, int iReel2);
asm("
		.code
		.align		1
		.global		Slot_FindOrder
Slot_FindOrder:
		cmp		%r12, 2			;// if((unsigned)iReel1 > 2) { DIE }
		jrugt		Slot_FindOrder_DIE
		cmp		%r13, 2			;// if((unsigned)iReel2 > 2) { DIE }
		jrugt		Slot_FindOrder_DIE
		sub		%r13, %r12		;// %r13 := iReel2 -= iReel1
		jrgt		3			;// if(  iReel2 <= 0) {
		 jreq		Slot_FindOrder_DIE	;//   if(iReel2 == 0) { DIE }
		 add		%r13, 3			;//   %r13 := iReel2 += 3 }
		cmp		%r13, 1			;// if(iReel2 != 1) {
		jreq		2
		 add		%r12, 3			;//   %r12 := iReel1 += 3 }
		ret.d					;// return  iReel1
		ld.w		%r10, %r12		;// %r10 := iReel1		*delay*
");
static void __attribute__((noreturn,unused)) Slot_FindOrder_DIE() { DIE(); }
#endif//PIECE

//eXgXC[g
//void TestSuite() {
//  if(Slot_FindOrder(0,1)!=Slot_Order_LCR){DIE();}
//  if(Slot_FindOrder(1,2)!=Slot_Order_CRL){DIE();}
//  if(Slot_FindOrder(2,0)!=Slot_Order_RLC){DIE();}
//  if(Slot_FindOrder(0,2)!=Slot_Order_LRC){DIE();}
//  if(Slot_FindOrder(1,0)!=Slot_Order_CLR){DIE();}
//  if(Slot_FindOrder(2,1)!=Slot_Order_RCL){DIE();}
//}

/****************************************************************************
 *	C
 ****************************************************************************/

#ifndef PIECE
static const unsigned char TBL_Slot_LineRow[7/*㒆~JR*/] = {
#else //PIECE
static const unsigned char TBL_Slot_LineRow[7/*㒆~JR*/] __attribute__((unused))/*asmubNQ*/ = {
#endif//PIECE
	(0/**/<<0)|(0/**/<<2)|(0/**/<<4),// 0 iC
	(1/**/<<0)|(1/**/<<2)|(1/**/<<4),// 1 iC
	(2/**/<<0)|(2/**/<<2)|(2/**/<<4),// 2 iC
	(0/**/<<0)|(1/**/<<2)|(2/**/<<4),// 3 ~΃C
	(2/**/<<0)|(1/**/<<2)|(0/**/<<4),// 4 ΃C
	(0/**/<<0)|(1/**/<<2)|(0/**/<<4),// 5 JC
	(2/**/<<0)|(1/**/<<2)|(2/**/<<4),// 6 RC
};

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int Slot_GetLineRow(int iLine, int iReel) {
	if(((unsigned)iLine > 6) || ((unsigned)iReel > 2)) { DIE(); }
	return (TBL_Slot_LineRow[iLine] >> (iReel * 2)) & 3;
}
#else //PIECE
int Slot_GetLineRow(int iLine, int iReel);
asm("
		.code
		.align		1
		.global		Slot_GetLineRow
Slot_GetLineRow:
		cmp		%r12, 6			;// if(((unsigned)iLine > 6) { DIE }
		jrugt		Slot_GetLineRow_DIE
		cmp		%r13, 2			;// if(((unsigned)iCol  > 2) { DIE }
		jrugt		Slot_GetLineRow_DIE
		ext		TBL_Slot_LineRow@ah	;// %r10 := TBL_Slot_LineRow[iLine]
		ext		TBL_Slot_LineRow@al
		ld.ub		%r10, [%r12]
		add		%r13, %r13		;// %r13 :=                             (iReel * 2)		*anti-interlock*
		srl		%r10, %r13		;// %r10 := (TBL_Slot_LineRow[iLine] >> (iReel * 2))
		ret.d					;// return  (TBL_Slot_LineRow[iLine] >> (iReel * 2)) & 3
		and		%r10, 3			;// %r10 := (TBL_Slot_LineRow[iLine] >> (iReel * 2)) & 3	*delay*
");
static void __attribute__((noreturn,unused)) Slot_GetLineRow_DIE() { DIE(); }
#endif//PIECE

//eXgXC[g
//void TestSuite() {
//  if((Slot_GetLineRow(Slot_Line_T,0)!=0)||(Slot_GetLineRow(Slot_Line_T,1)!=0)||(Slot_GetLineRow(Slot_Line_T,2)!=0)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_M,0)!=1)||(Slot_GetLineRow(Slot_Line_M,1)!=1)||(Slot_GetLineRow(Slot_Line_M,2)!=1)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_B,0)!=2)||(Slot_GetLineRow(Slot_Line_B,1)!=2)||(Slot_GetLineRow(Slot_Line_B,2)!=2)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_F,0)!=0)||(Slot_GetLineRow(Slot_Line_F,1)!=1)||(Slot_GetLineRow(Slot_Line_F,2)!=2)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_Z,0)!=2)||(Slot_GetLineRow(Slot_Line_Z,1)!=1)||(Slot_GetLineRow(Slot_Line_Z,2)!=0)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_V,0)!=0)||(Slot_GetLineRow(Slot_Line_V,1)!=1)||(Slot_GetLineRow(Slot_Line_V,2)!=0)){DIE();}
//  if((Slot_GetLineRow(Slot_Line_A,0)!=2)||(Slot_GetLineRow(Slot_Line_A,1)!=1)||(Slot_GetLineRow(Slot_Line_A,2)!=2)){DIE();}
//}

/****************************************************************************
 *	epC
 ****************************************************************************/

#ifndef PIECE
int Slot_CheckTenpai(const unsigned char aStopPict[3/*㒆*/][3/*E*/], int iPictLCR) {
	int iTenpaiLineMask = 0;
	int iPictL, iPictC, iPictR, iMask, iRow, iStopPict;
	const unsigned char* pRow;
	/* 񓷓ɒ~Ɩ~݂ĂȂƂmFB(=㒆̓ł0,,㒆̓ł0ȊOȂ΃G[B) */
	if(((aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]) == 0) && ((aStopPict[0][0]+aStopPict[1][0]+aStopPict[2][0]) != 0)) { DIE(); }
	if(((aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]) == 0) && ((aStopPict[0][1]+aStopPict[1][1]+aStopPict[2][1]) != 0)) { DIE(); }
	if(((aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]) == 0) && ((aStopPict[0][2]+aStopPict[1][2]+aStopPict[2][2]) != 0)) { DIE(); }
	/* Gg𕪉B */
	iPictL = (iPictLCR>>0) & 15;
	iPictC = (iPictLCR>>4) & 15;
	iPictR = (iPictLCR>>8) & 15;
	/* eCɂāc */
	iMask = (1<<0);				// 0 iC 
	pRow = TBL_Slot_LineRow;
	do {
		iRow = *pRow++;	/* [1:0]=,[3:2]=,[5:4]=E */
		/* 񓷂łuAny,,~ς݂ŁAsvvȂ΁ÃCŃepCł͂ȂB */
		if((iPictL != 0)/*Any*/ && ((iStopPict = aStopPict[(iRow/*>>0*/)  &3  ][0/**/]) != 0)/*~ς*/ && (iPictL != iStopPict)/*sv*/) { continue; }
		if((iPictC != 0)/*Any*/ && ((iStopPict = aStopPict[(iRow  >>2  )  &3  ][1/**/]) != 0)/*~ς*/ && (iPictC != iStopPict)/*sv*/) { continue; }
		if((iPictR != 0)/*Any*/ && ((iStopPict = aStopPict[(iRow  >>4  )/*&3*/][2/*E*/]) != 0)/*~ς*/ && (iPictR != iStopPict)/*sv*/) { continue; }
		/* ̃CŃepCłBepCC̃rbg}XNɁÃC̃rbg}XNǉB */
		iTenpaiLineMask |= iMask;
	} while((iMask <<= 1) <= (1<<6));	// 6 RC ܂
	/* epCC̃rbg}XNԂB */
	return  iTenpaiLineMask;
}
#else //PIECE
int Slot_CheckTenpai(const unsigned char aStopPict[3/*㒆*/][3/*E*/], int iPictLCR);
asm("
		.code
		.align		1
		.global		Slot_CheckTenpai
Slot_CheckTenpai:
		;// %r12 := aStopPict
		;// %r13 := iPictLCR
		ld.ub		%r4,  [%r12]+			;// %r4  := aStopPict[0][0]
		ld.ub		%r5,  [%r12]+			;// %r5  := aStopPict[0][1]
		ld.ub		%r6,  [%r12]+			;// %r6  := aStopPict[0][2]
;//{{eʐߖ
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][0]
;//		mltu.h		%r4,  %r9			;// %alr := aStopPict[0][0]*aStopPict[1][0]
;//		ld.w		%r4,  %alr			;// %r4  := aStopPict[0][0]*aStopPict[1][0]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][1]
;//		mltu.h		%r5,  %r9			;// %alr := aStopPict[0][1]*aStopPict[1][1]
;//		ld.w		%r5,  %alr			;// %r5  := aStopPict[0][1]*aStopPict[1][1]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][2]
;//		mltu.h		%r6,  %r9			;// %alr := aStopPict[0][2]*aStopPict[1][2]
;//		ld.w		%r6,  %alr			;// %r6  := aStopPict[0][2]*aStopPict[1][2]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][0]
;//		mltu.h		%r4,  %r9			;// %alr := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
;//		ld.w		%r4,  %alr			;// %r4  := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
;//		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][1]
;//		mltu.h		%r5,  %r9			;// %alr := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
;//		ld.w		%r5,  %alr			;// %r5  := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
;//		ld.ub		%r9,  [%r12]			;// %r9  :=                                 aStopPict[2][2]
;//		mltu.h		%r6,  %r9			;// %alr := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
;//		ld.w		%r6,  %alr			;// %r6  := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
;//eʐߖ
		ld.w		%r7,  2				;// %r7  := i = 2; do {
		 ld.ub		%r9,  [%r12]+			;//   %r9  :=                 aStopPict[1][0]%r9  :=                                 aStopPict[2][0]
		 mltu.h		%r4,  %r9			;//   %alr := aStopPict[0][0]*aStopPict[1][0]%alr := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
		 ld.w		%r4,  %alr			;//   %r4  := aStopPict[0][0]*aStopPict[1][0]%r4  := aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]
		 ld.ub		%r9,  [%r12]+			;//   %r9  :=                 aStopPict[1][1]%r9  :=                                 aStopPict[2][1]
		 mltu.h		%r5,  %r9			;//   %alr := aStopPict[0][1]*aStopPict[1][1]%alr := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
		 ld.w		%r5,  %alr			;//   %r5  := aStopPict[0][1]*aStopPict[1][1]%r5  := aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]
		 ld.ub		%r9,  [%r12]+			;//   %r9  :=                 aStopPict[1][2]%r9  :=                                 aStopPict[2][2]
		 mltu.h		%r6,  %r9			;//   %alr := aStopPict[0][2]*aStopPict[1][2]%alr := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
		 ld.w		%r6,  %alr			;//   %r6  := aStopPict[0][2]*aStopPict[1][2]%r6  := aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]
		 sub		%r7,  1				;//   %r7  := i--
		jrne		-10				;// } while(i)
;//}}eʐߖ
		sub		%r12, 9				;// %r12 := aStopPict
		ld.ub		%r7,  [%r12]+			;// %r7  := aStopPict[0][0]
		ld.ub		%r10, [%r12]+			;// %r10 := aStopPict[0][1]
		ld.ub		%r11, [%r12]+			;// %r11 := aStopPict[0][2]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][0]
		add		%r7,  %r9			;// %r7  := aStopPict[0][0]+aStopPict[1][0]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][1]
		add		%r10, %r9			;// %r10 := aStopPict[0][1]+aStopPict[1][1]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                 aStopPict[1][2]
		add		%r11, %r9			;// %r11 := aStopPict[0][2]+aStopPict[1][2]
		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][0]
		add		%r7,  %r9			;// %r7  := aStopPict[0][0]+aStopPict[1][0]+aStopPict[2][0]
		jreq.d		4				;//     if((aStopPict[0][0]+aStopPict[1][0]+aStopPict[2][0]) != 0) &&
		 ld.w		%r14, %r13			;// %r14 :=           iPictLCR			*delay*		
		 cmp		%r4,  0				;//        (aStopPict[0][0]*aStopPict[1][0]*aStopPict[2][0]) == 0)) {		
		 jreq		Slot_CheckTenpai_DIE		;//        DIE }								
		ld.ub		%r9,  [%r12]+			;// %r9  :=                                 aStopPict[2][1]			
		add		%r10, %r9			;// %r10 := aStopPict[0][1]+aStopPict[1][1]+aStopPict[2][1]			
		jreq.d		4				;//     if((aStopPict[0][1]+aStopPict[1][1]+aStopPict[2][1]) != 0) &&		
		 ld.w		%r15, %r13			;// %r15 :=           iPictLCR			*delay*		
		 cmp		%r5,  0				;//        (aStopPict[0][1]*aStopPict[1][1]*aStopPict[2][1]) == 0)) {		
		 jreq		Slot_CheckTenpai_DIE		;//        DIE }								
		ld.ub		%r9,  [%r12]			;// %r9  :=                                 aStopPict[2][2]			
		add		%r11, %r9			;// %r11 := aStopPict[0][2]+aStopPict[1][2]+aStopPict[2][2]			
		jreq.d		4				;//     if((aStopPict[0][2]+aStopPict[1][2]+aStopPict[2][2]) != 0) &&		
		 sub		%r12, 8				;// %r12 := aStopPict				*delay*			
		 cmp		%r6,  0				;//        (aStopPict[0][2]*aStopPict[1][2]*aStopPict[2][2]) == 0)) {		
		 jreq		Slot_CheckTenpai_DIE		;//        DIE }								
;//		sub		%r12, 8				;// %r12 := aStopPict							
		;//---------------------------------------------;//										
;//		ld.w		%r14, %r13			;// %r14 :=           iPictLCR					
;//		ld.w		%r15, %r13			;// %r15 :=           iPictLCR					
		sra		%r14, 4				;// %r14 :=          (iPictLCR>>4)
		sra		%r15, 8				;// %r15 :=          (iPictLCR>>8)
		and		%r13, 15			;// %r13 := iPictL = (iPictLCR>>0) & 15
		and		%r14, 15			;// %r14 := iPictC = (iPictLCR>>4) & 15
		and		%r15, 15			;// %r15 := iPictR = (iPictLCR>>8) & 15
		ld.w		%r4,  1				;// %r4  := iMask = (1<<0)
		ld.w		%r5,  3				;// %r5  := sizeof aStopPict[0] = 3
		ld.w		%r10, 0				;// %r10 := iTenpaiLineMask = 0
		xld.w		%r11, TBL_Slot_LineRow		;// %r11 := pRow = TBL_Slot_LineRow
		;// %r4  := iMask
		;// %r5  := sizeof aStopPict[0]
		;// %r10 := iTenpaiLineMask
		;// %r11 := pRow
		;// %r12 := aStopPict
		;// %r13 := iPictL
		;// %r14 := iPictC
		;// %r15 := iPictR
Slot_CheckTenpai_LOOP:						;// do {
		ld.ub		%r7, [%r11]+			;//   %r7  :=           (iRow>>0) = *pRow++
		cmp		%r13, 0				;//   if(iPictL) {
		jreq		11				;//     							 0
		 ld.w		%r6,  %r7			;//     %r6  :=         (iRow>>0)				@ 1
		 and		%r6,  3				;//     %r6  := iRowL = (iRow>>0) & 3				@ 2
		 mlt.h		%r6,  %r5			;//     %alr := iRowL *= 3					@ 3
		 ld.w		%r6,  %alr			;//     %r6  :=                       iRowL			@ 4
		 add		%r6,  %r12			;//     %r6  :=             aStopPict[iRowL]			@ 5
		 ld.ub		%r6,  [%r6]			;//     %r6  := iStopPict = aStopPict[iRowL][0]			@ 6
		 cmp		%r6,  0				;//     if(iStopPict) {				!INTERLOCK!	@ 7
		 jreq		3				;//       							@ 8
		  cmp		%r13, %r6			;//       if(iPictL != iStopPict) { continue }			@ 9
		  jrne		Slot_CheckTenpai_NEXT		;//   } }							@10
		cmp		%r14, 0				;//   if(iPictC) {						11
		jreq		13				;//     							 0
		 ld.w		%r6,  %r7			;//     %r6  :=         (iRow>>0)				@ 1
		 srl		%r6,  2				;//     %r6  :=         (iRow>>2)				@ 2
		 and		%r6,  3				;//     %r6  := iRowC = (iRow>>2) & 3				@ 3
		 mlt.h		%r6,  %r5			;//     %alr := iRowC *= 3					@ 4
		 ld.w		%r6,  %alr			;//     %r6  :=                        iRowC			@ 5
		 add		%r6,  %r12			;//     %r6  :=              aStopPict[iRowC]			@ 6
		 ext		1				;//     							@ 7
		 ld.ub		%r6,  [%r6]			;//     %r6  := iStopPict = aStopPict[iRowC][1]			@ 8
		 cmp		%r6,  0				;//     if(iStopPict) {				!INTERLOCK!	@ 9
		 jreq		3				;//       							@10
		  cmp		%r14, %r6			;//       if(iPictC != iStopPict) { continue }			@11
		  jrne		Slot_CheckTenpai_NEXT		;//   } }							@12
		cmp		%r15, 0				;//   if(iPictR) {						13
		jreq		11				;//     							 0
		 srl		%r7,  4				;//     %r7  := iRowR = (iRow>>4)				@ 1
		 mlt.h		%r7,  %r5			;//     %alr := iRowR *= 3					@ 2
		 ld.w		%r7,  %alr			;//     %r7  :=                        iRowR			@ 3
		 add		%r7,  %r12			;//     %r7  :=              aStopPict[iRowR]			@ 4
		 ext		2				;//     							@ 5
		 ld.ub		%r7,  [%r7]			;//     %r7  := iStopPict = aStopPict[iRowR][2]			@ 6
		 cmp		%r7,  0				;//     if(iStopPict) {				!INTERLOCK!	@ 7
		 jreq		3				;//       							@ 8
		  cmp		%r15, %r7			;//       if(iPictR != iStopPict) { continue }			@ 9
		  jrne		Slot_CheckTenpai_NEXT		;//   } }							@10
		or		%r10, %r4			;//   %r10 := iTenpaiLineMask |= iMask				11
Slot_CheckTenpai_NEXT:						;//
;//{{
;//		sla		%r4,  1				;// } while((iMask <<= 1) <= (1<<6))
;//		xcmp		%r4, 64				;// 
;//		jrle		Slot_CheckTenpai_LOOP		;// 
;//
		xcmp		%r4, 32				;// } while((iMask <<= 1) <= (1<<6))
		jrle.d		Slot_CheckTenpai_LOOP		;// 
		sla		%r4,  1				;// 						*delay*
;//}}
		ret
");
static void __attribute__((noreturn,unused)) Slot_CheckTenpai_DIE() { DIE(); }
#endif//PIECE

/****************************************************************************
 *	ܔ
 ****************************************************************************/

#ifndef PIECE
#if 0
/* PȎBëӐ}cɂ́AQƂĂB */
void Slot_CheckPrize(const unsigned char aStopPict[3/*㒆*/][3/*E*/], const unsigned short aHitFlg[/*nHitFlg*/], int nHitFlg, unsigned char aResult[7/*㒆~JR*/]) {
	int iHitFlg, iMask, iLine;
	/* nHitFlg(Gge[u̗vf)A(1`256)ł邱ƂmFB */
	if((nHitFlg < 1) || (nHitFlg > 256)) { DIE(); }
	/* Gge[ůevfɂāc */
	for(iHitFlg = 0; iHitFlg < nHitFlg; iHitFlg++) {
		/* ̊GgɂāA7C̓ܔsB */
		iMask = Slot_CheckTenpai(aStopPict, aHitFlg[iHitFlg]);
		/* eCɂāc */
		for(iLine = 0; iLine < 7; iLine++) {
			/* ̃Cɓ܂ĂÅGgԍʔz֊i[B */
			if(iMask & (1<<iLine)) { aResult[iLine] = iHitFlg; }
		}
	}
}
#else
/* œKBAZuł́Ax[XɃAZu܂B */
void Slot_CheckPrize(const unsigned char aStopPict[3/*㒆*/][3/*E*/], const unsigned short aHitFlg[/*nHitFlg*/], int nHitFlg, unsigned char aResult[7/*㒆~JR*/]) {
	/* nHitFlg(Gge[u̗vf)A(1`256)ł邱ƂmFBA̓s゠炩(-1)Ă̂ŁA(0`255)ł邱ƂmFB */
	if((unsigned)--nHitFlg > 255) { DIE(); } /* s */
	/* nHitFlg[31:8]=(Gge[u̎cvf-1),nHitFlg[7:0]=(Ggԍ)ƂB[vϐ炷߂̍HvłB */
	nHitFlg <<= 8;
	/* Gge[ůevfɂāc */
	do {
		/* ̊GgɂāA7C̓ܔsB */
		int iMask = Slot_CheckTenpai(aStopPict, *aHitFlg++);
		/* eCɂāc */
		unsigned char* pResult = aResult; /* ŏ̃Cɑ΂Aʔzւ̃|C^ */
		do {
			/* ̃Cɓ܂ĂÅGgԍʔz֊i[B */
			if(iMask & 1) { *pResult = nHitFlg; } /* nHitFlg[7:0]=(Ggԍ) */
			/* ʔzւ̃|C^ÃC֐i߂B */
			pResult++;
		} while(iMask >>= 1); /* ܃tÕC֐i߂B1̃rbgȂIB7CܖłA1[v邱ƂɂȂ邪AQ͖B */
	/* nHitFlg[31:8]=(Gge[u̎cvf-1)(-1),nHitFlg[7:0]=(Ggԍ)(+1)BAnHitFlg[31:0](-255)B */
	/* - [vÍA0**ł͂ȂA0*ȉ*ł邱ƂɒӂB                                                                  */
	/*   ďö(nHitFlg=256)̏ꍇAŌ(nHitFlg[31:8]:00,nHitFlg[7:0]:2550)A(nHitFlg[31:0]:2550)ŏI邩łB */
	} while((nHitFlg -= 255) > 0);
}
#endif
#else //PIECE
void Slot_CheckPrize(const unsigned char aStopPict[3/*㒆*/][3/*E*/], const unsigned short aHitFlg[/*nHitFlg*/], int nHitFlg, unsigned char aResult[7/*㒆~JR*/]);
asm("
		.code
		.align		1
		.global		Slot_CheckPrize
Slot_CheckPrize:
		;// %r12 := aStopPict
		;// %r13 := aHitFlg
		;// %r14 := nHitFlg
		;// %r15 := aResult
		sub		%r14, 1			;// if((unsigned)--nHitFlg > 255) {
		xcmp		%r14, 255		;//   DIE
		jrugt		Slot_CheckPrize_DIE	;// }
		pushn		%r3
		ld.w		%r0, %r12		;// %r0       := aStopPict
		ld.w		%r1, %r13		;// %r1       := aHitFlg
		ld.w		%r2, %r14		;// %r2[31:8] := nHitFlg
		sla		%r2, 8			;// %r2[ 7:0] := iHitFlg = 0
		ld.w		%r3, %r15		;// %r3       := aResult
		;// %r0       := aStopPict
		;// %r1       := aHitFlg
		;// %r2[31:8] := nHitFlg
		;// %r2[ 7:0] := iHitFlg = 0
		;// %r3       := aResult
Slot_CheckPrize_LOOP:					;// do {
		ld.uh		%r13, [%r1]+		;//   %r13 :=                                     *aHitFlg++
		xcall.d		Slot_CheckTenpai	;//   %r10 := iMask = Slot_CheckTenpai(aStopPict, *aHitFlg++)	iMask[ 0] := i, iMask[ 1] := i, iMask[ 2] := i, iMask[ 3] := ~, iMask[ 4] := , iMask[ 5] := J, iMask[ 6] := R
		ld.w		%r12, %r0		;//   %r12 :=                          aStopPict		*delay*
		swap		%r10, %r10		;//   %r10 := iMask =   swap(iMask)				iMask[24] := i, iMask[25] := i, iMask[26] := i, iMask[27] := ~, iMask[28] := , iMask[29] := J, iMask[30] := R
		mirror		%r10, %r10		;//   %r10 := iMask = mirror(iMask)				iMask[31] := i, iMask[30] := i, iMask[29] := i, iMask[28] := ~, iMask[27] := , iMask[26] := J, iMask[25] := R
		ld.w		%r12, %r3		;//   %r12 := pResult = aResult
		add		%r10, %r10		;//   do {
		 jruge		2			;//     %psr(C) := iMask[31], %r10 := iMask <<= 1
		  ld.b		[%r12], %r2		;//     if(%psr(C)) { *pResult = iHitFlg }
		jrne.d		-3			;//   } while(iMask)
		add		%r12, 1			;//   %r12 := pResult++						*delay*
		xsub		%r2, %r2, 255		;//   %r2[31:8] := nHitFlg--, %r2[7:0] := iHitFlg++
		jrgt		Slot_CheckPrize_LOOP	;// } while(((nHitFlg<<8)|iHitFlg) > 0)				ďö(nHitFlg=256)̏ꍇAŌ(nHitFlg:00,iHitFlg:2550)A(%r2:2550)ŏIBeʐߖOƔfႤƂɒӂBjrgełȂjrgtłB
		popn		%r3
		ret
");
static void __attribute__((noreturn,unused)) Slot_CheckPrize_DIE() { DIE(); }
#endif//PIECE

/****************************************************************************
 *	[z
 ****************************************************************************/

#ifndef PIECE
int Slot_GetReelPict(const unsigned short aReel[/*(SlotPos_Max+1)*/], int iPos, int iReel) {
	int iPict;
	/* 񓷔ԍ(0`2)͈̔͂ł邱ƂmFB */
	if((unsigned)iReel > 2) { DIE(); }
	/* Gʒu(0`SlotPos_Max)͈̔͊OȂ΁A(0`SlotPos_Max)͈̔͂ɐ܂ԂB */
	if((iPos %= (SlotPos_Max+1)) < 0) { iPos += (SlotPos_Max+1); }
	/* [źAGʒu̗vf́A񓷔ԍ̊G擾B */
	iPict = (aReel[iPos] >> (iReel << 2)) & 15;
	if(!iPict) { DIE(); }
	return iPict;
}
#else //PIECE
int Slot_GetReelPict(const unsigned short aReel[/*(SlotPos_Max+1)*/], int iPos, int iReel);
#if    (SlotPos_Max == 20)
asm("
		.code
		.align		1
		.global		Slot_GetReelPict
Slot_GetReelPict:
		cmp		%r14, 2				;// if((unsigned)iReel > 2) {
		jrugt		Slot_GetReelPict_DIE		;//   DIE() }
		ld.w		%r15, %r12			;// %r15 := aReel
		ld.w		%r12, %r13			;// %r12 := iPos
		xcall.d		__modsi3			;// %r10 := iPos %= 21
		ld.w		%r13, 21			;// %r13 :=         21		*delay*
		add		%r10, %r10			;// %r10 := iPos *= sizeof aReel[0]
		jrge.d		3				;// if(iPos < 0) {
		 sla		%r14, 2				;// %r14 := iReel *= 4		*delay*
		 add		%r10, 42			;//   %r10 := iPos += (21 * sizeof aReel[0]) }
		add		%r10, %r15			;// %r10 := iPict =  aReel += iPos
		ld.uh		%r10, [%r10]			;// %r10 := iPict = *aReel
		sra		%r10, %r14			;// %r10 := iPict >>= iReel	!INTERLOCK!
		and		%r10, 15			;// %r10 := iPict &= 15
		jreq		Slot_GetReelPict_DIE		;// if(!iPict) { DIE() }
		ret						;// return  iPict
");
#elif  (SlotPos_Max == 19)
asm("
		.code
		.align		1
		.global		Slot_GetReelPict
Slot_GetReelPict:
		cmp		%r14, 2				;// if((unsigned)iReel > 2) {
		jrugt		Slot_GetReelPict_DIE		;//   DIE() }
		ld.w		%r15, %r12			;// %r15 := aReel
		ld.w		%r12, %r13			;// %r12 := iPos
		xcall.d		__modsi3			;// %r10 := iPos %= 20
		ld.w		%r13, 20			;// %r13 :=         20		*delay*
		add		%r10, %r10			;// %r10 := iPos *= sizeof aReel[0]
		jrge.d		3				;// if(iPos < 0) {
		 sla		%r14, 2				;// %r14 := iReel *= 4		*delay*
		 add		%r10, 40			;//   %r10 := iPos += (20 * sizeof aReel[0]) }
		add		%r10, %r15			;// %r10 := iPict =  aReel += iPos
		ld.uh		%r10, [%r10]			;// %r10 := iPict = *aReel
		sra		%r10, %r14			;// %r10 := iPict >>= iReel	!INTERLOCK!
		and		%r10, 15			;// %r10 := iPict &= 15
		jreq		Slot_GetReelPict_DIE		;// if(!iPict) { DIE() }
		ret						;// return  iPict
");
#else //SlotPos_Max
#error  SlotPos_Max̒`słB
#endif//SlotPos_Max
static void __attribute__((noreturn,unused)) Slot_GetReelPict_DIE() { DIE(); }
#endif//PIECE

//
//[zf[^̃rbg12`15͕slō\Ȃ̂ŁAAvP[V̗prɗpč\ȂB
//ۂ̂ƂALȗp@͖낤BÃrbg͖ʂłB
//ŁAGʒu3s2oCgɃpbNĂlĂ݂B͉L̒ʂ:
//
//	int Slot_GetReelPict_Packed(const unsigned char aReel[/*32*/], int iPos, int iReel) {
//		int i, iPict;
//		/* 񓷔ԍ(0`2)͈̔͂ł邱ƂmFB */
//		if((unsigned)iReel > 2) { DIE(); }
//		/* Gʒu(0`SlotPos_Max)͈̔͊OȂ΁A(0`SlotPos_Max)͈̔͂ɐ܂ԂB */
//		if((iPos %= (SlotPos_Max+1)) < 0) { iPos += (SlotPos_Max+1); }
//		/* GʒuƉ񓷔ԍA[zւ̃juPʂ̃CfNX߂B */
//		i = (iPos * 3) + iReel;
//		/* [źAGʒu̗vf́A񓷔ԍ̊G擾B */
//		iPict = (aReel[i>>1] >> ((i&1)<<2)) & 15;
//		if(!iPict) { DIE(); }
//		return iPict;
//	}
//L̃o[WgƁA[zf[^ɖʂȃrbgȂB
//AvZĂ݂ƁA[zf[^̌AR[hTCY̑̕B
//Eް: 4232 10޲Č
//E޻: 1723 12޲đ
//Ƃ킯ŁAL̃o[W͗_̂ŁA̗pȂBꉞAL^܂łɎcĂB

/****************************************************************************
 *	~
 ****************************************************************************/

/*--------------------------------------------------------------------------*
 *	1[~
 *--------------------------------------------------------------------------*/

/* Zbg1ԍ(iHkmSet1)́Aʒu1(iPushPos1)́A擾B
 * [in]
 *	pStpCtl		~f[^
 *	iHkmSet1	Zbg1ԍ		0`(HkmSet1_Size-1)
 *	iPushPos1	ʒu1		0`SlotPos_Max
 * [out]
 *	߂l				0`4
 * [note]
 *	- Zbg1Ƃ́A(~ʒu1)̑gAdo^̂łB
 */
static int GetHkmSet1(const ST_Slot_StpCtl* pStpCtl, int iHkmSet1, int iPushPos1) {
	unsigned char (*Buf/*[HkmSet1_CompUnit]*/)[((SlotPos_Max+1) + 2) / 3] = alloca(pStpCtl->HkmSet1_CompUnit * (((SlotPos_Max+1) + 2) / 3));
	int nHkmCnt, iCompData, iCompSize, nUncompSize;
	if((unsigned)iHkmSet1 >= pStpCtl->HkmSet1_Size) { DIE(); }
	if((unsigned)iPushPos1 > SlotPos_Max) { DIE(); }
	iCompData = 0;
	for(iCompSize = 0;
	    iCompSize < (iHkmSet1 / pStpCtl->HkmSet1_CompUnit);
	    iCompSize++) {
		iCompData += pStpCtl->TBL_HkmSet1_CompSize[iCompSize];
	}
	if((unsigned)iCompData >= pStpCtl->HkmSet1_CompData_Size) { DIE(); }
	nUncompSize = TinyLZ_uncompress(
		Buf, pStpCtl->HkmSet1_CompUnit * (SlotPos_Max+1),
		&pStpCtl->TBL_HkmSet1_CompData[iCompData],
		 pStpCtl->TBL_HkmSet1_CompSize[iCompSize]);
	if(((nUncompSize % (((SlotPos_Max+1) + 2) / 3)) != 0) ||
	   ((nUncompSize / (((SlotPos_Max+1) + 2) / 3)) < (iHkmSet1 % pStpCtl->HkmSet1_CompUnit))) { DIE(); }
	nHkmCnt = Buf[iHkmSet1 % pStpCtl->HkmSet1_CompUnit][iPushPos1 / 3];
	switch(iPushPos1 % 3) {
	case 0: nHkmCnt = nHkmCnt      % 6; break;
	case 1: nHkmCnt = nHkmCnt /  6 % 6; break;
	case 2: nHkmCnt = nHkmCnt / 36    ; break;
	default: DIE();
	}
	if((unsigned)nHkmCnt > 4) { DIE(); }
	return nHkmCnt;
}

/*--------------------------------------------------------------------------*/

int Slot_GetStpCtl1(const ST_Slot_StpCtl* pStpCtl, int iHitCd, int iReel1, int iPushPos1) {
	int iHkmSet1;
	if((unsigned)iHitCd >= pStpCtl->HitCd_Size) { DIE(); }
	if((unsigned)iReel1 > 2) { DIE(); }
	if((unsigned)iPushPos1 > SlotPos_Max) { DIE(); }
	iHkmSet1 = pStpCtl->TBL_StpCtl1[iHitCd][iReel1];
	return GetHkmSet1(pStpCtl, iHkmSet1, iPushPos1);
}

/*--------------------------------------------------------------------------*
 *	2[~
 *--------------------------------------------------------------------------*/

/* Zbg2ԍ(iHkmSet2)́A~ʒu1(iStopPos1),ʒu2(iPushPos2)́A擾B
 * [in]
 *	pStpCtl		~f[^
 *	iHkmSet2	Zbg2ԍ		0`(HkmSet2_Size-1)
 *	iStopPos1	~ʒu1		0`SlotPos_Max
 *	iPushPos2	ʒu2		0`SlotPos_Max
 * [out]
 *	߂l				0`4
 * [note]
 *	- Zbg2Ƃ́A(Zbg1ԍ~~ʒu1)̑gAdo^̂łB
 *	- Zbg2f[^́A(HkmSet2_CompUnit)PʂŁAkĂ܂B
 */
static int GetHkmSet2(const ST_Slot_StpCtl* pStpCtl, int iHkmSet2, int iStopPos1, int iPushPos2) {
	unsigned char (*Buf/*[HkmSet2_CompUnit]*/)[(SlotPos_Max+1)] = alloca(pStpCtl->HkmSet2_CompUnit * (SlotPos_Max+1));
	int iHkmSet1, iCompData, iCompSize, nUncompSize;
	if((unsigned)iHkmSet2 >= pStpCtl->HkmSet2_Size) { DIE(); }
	if((unsigned)iStopPos1 > SlotPos_Max) { DIE(); }
	if((unsigned)iPushPos2 > SlotPos_Max) { DIE(); }
	iCompData = 0;
	for(iCompSize = 0;
	    iCompSize < (iHkmSet2 / pStpCtl->HkmSet2_CompUnit);
	    iCompSize++) {
		iCompData += pStpCtl->TBL_HkmSet2_CompSize[iCompSize];
	}
	if((unsigned)iCompData >= pStpCtl->HkmSet2_CompData_Size) { DIE(); }
	nUncompSize = TinyLZ_uncompress(
		Buf, pStpCtl->HkmSet2_CompUnit * (SlotPos_Max+1),
		&pStpCtl->TBL_HkmSet2_CompData[iCompData],
		 pStpCtl->TBL_HkmSet2_CompSize[iCompSize]);
	if(((nUncompSize % (SlotPos_Max+1)) != 0) ||
	   ((nUncompSize / (SlotPos_Max+1)) < (iHkmSet2 % pStpCtl->HkmSet2_CompUnit))) { DIE(); }
	iHkmSet1 = Buf[iHkmSet2 % pStpCtl->HkmSet2_CompUnit][iStopPos1];
	return GetHkmSet1(pStpCtl, iHkmSet1, iPushPos2);
}

/*--------------------------------------------------------------------------*/

int Slot_GetStpCtl2(const ST_Slot_StpCtl* pStpCtl, int iHitCd, int iReel1, int iReel2, int iStopPos1, int iPushPos2) {
	int iHkmSet2, iOrder;
	if((unsigned)iHitCd >= pStpCtl->HitCd_Size) { DIE(); }
	if((unsigned)iReel1 > 2) { DIE(); }
	if((unsigned)iReel2 > 2) { DIE(); }
	if((unsigned)iStopPos1 > SlotPos_Max) { DIE(); }
	if((unsigned)iPushPos2 > SlotPos_Max) { DIE(); }
	iOrder = Slot_FindOrder(iReel1, iReel2);
	iHkmSet2 = pStpCtl->TBL_StpCtl2[iHitCd][iOrder];
	return GetHkmSet2(pStpCtl, iHkmSet2, iStopPos1, iPushPos2);
}

/*--------------------------------------------------------------------------*
 *	3[~
 *--------------------------------------------------------------------------*/

/* Zbg3ԍ(iHkmSet3)́A~ʒu1(iStopPos1),~ʒu2(iStopPos2),ʒu3(iPushPos3)́A擾B
 * [in]
 *	pStpCtl		~f[^
 *	iHkmSet3	Zbg3ԍ		0`(HkmSet3_Size-1)
 *	iStopPos1	~ʒu1		0`SlotPos_Max
 *	iStopPos2	~ʒu2		0`SlotPos_Max
 *	iPushPos3	ʒu3		0`SlotPos_Max
 * [out]
 *	߂l				0`4
 * [note]
 *	- Zbg3Ƃ́A(Zbg2ԍ~~ʒu1)̑gAdo^̂łB
 *	- Zbg3f[^́A(HkmSet3_CompUnit)PʂŁAkĂ܂B
 */
static int GetHkmSet3(const ST_Slot_StpCtl* pStpCtl, int iHkmSet3, int iStopPos1, int iStopPos2, int iPushPos3) {
	unsigned char (*Buf/*[HkmSet3_CompUnit]*/)[(SlotPos_Max+1)] = alloca(pStpCtl->HkmSet3_CompUnit * (SlotPos_Max+1));
	int iHkmSet2, iCompData, iCompSize, nUncompSize;
	if((unsigned)iHkmSet3 >= pStpCtl->HkmSet3_Size) { DIE(); }
	if((unsigned)iStopPos1 > SlotPos_Max) { DIE(); }
	if((unsigned)iStopPos2 > SlotPos_Max) { DIE(); }
	if((unsigned)iPushPos3 > SlotPos_Max) { DIE(); }
	iCompData = 0;
	for(iCompSize = 0;
	    iCompSize < (iHkmSet3 / pStpCtl->HkmSet3_CompUnit);
	    iCompSize++) {
		iCompData += pStpCtl->TBL_HkmSet3_CompSize[iCompSize];
	}
	if((unsigned)iCompData >= pStpCtl->HkmSet3_CompData_Size) { DIE(); }
	nUncompSize = TinyLZ_uncompress(
		Buf, pStpCtl->HkmSet3_CompUnit * (SlotPos_Max+1),
		&pStpCtl->TBL_HkmSet3_CompData[iCompData],
		 pStpCtl->TBL_HkmSet3_CompSize[iCompSize]);
	if(((nUncompSize % (SlotPos_Max+1)) != 0) ||
	   ((nUncompSize / (SlotPos_Max+1)) < (iHkmSet3 % pStpCtl->HkmSet3_CompUnit))) { DIE(); }
	iHkmSet2 = Buf[iHkmSet3 % pStpCtl->HkmSet3_CompUnit][iStopPos1];
	return GetHkmSet2(pStpCtl, iHkmSet2, iStopPos2, iPushPos3);
}

/*--------------------------------------------------------------------------*/

int Slot_GetStpCtl3(const ST_Slot_StpCtl* pStpCtl, int iHitCd, int iReel1, int iReel2, int iReel3, int iStopPos1, int iStopPos2, int iPushPos3) {
	int iHkmSet3, iOrder;
	if((unsigned)iHitCd >= pStpCtl->HitCd_Size) { DIE(); }
	if((unsigned)iReel1 > 2) { DIE(); }
	if((unsigned)iReel2 > 2) { DIE(); }
	if((unsigned)iReel3 > 2) { DIE(); }
	if((unsigned)iStopPos1 > SlotPos_Max) { DIE(); }
	if((unsigned)iStopPos2 > SlotPos_Max) { DIE(); }
	if((unsigned)iPushPos3 > SlotPos_Max) { DIE(); }
	iOrder = Slot_FindOrder(iReel1, iReel2);
	iHkmSet3 = pStpCtl->TBL_StpCtl3[iHitCd][iOrder];
	return GetHkmSet3(pStpCtl, iHkmSet3, iStopPos1, iStopPos2, iPushPos3);
}

/****************************************************************************
 *	~f[^r_
 ****************************************************************************/
#ifdef  WIN32	//PCŒ~f[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B
/* ~f[^r_ */
typedef struct _ST_Slot_StpCtl_Builder {
	unsigned short HkmSet1_Size;
	unsigned short HkmSet2_Size;
	unsigned short HkmSet3_Size;
	unsigned short HkmSet1_CompData_Size;
	unsigned short HkmSet2_CompData_Size;
	unsigned short HkmSet3_CompData_Size;
	unsigned char (*TBL_StpCtl1/*[HitCd_Size]*/)[3]/*[(SlotPos_Max+1)]*/;					//                                                                                          TBL_HkmSet1
	unsigned char (*TBL_StpCtl2/*[HitCd_Size]*/)[6]/*[(SlotPos_Max+1)][(SlotPos_Max+1)]*/;			//                                             (TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData)TBL_HkmSet1
	unsigned char (*TBL_StpCtl3/*[HitCd_Size]*/)[6]/*[(SlotPos_Max+1)][(SlotPos_Max+1)][(SlotPos_Max+1)]*/;	//(TBL_HkmSet3_CompSize,TBL_HkmSet3_CompData)(TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData)TBL_HkmSet1
	unsigned char TBL_HkmSet1[256/*HkmSet1_Sizȅ*/][(SlotPos_Max+1)];
	unsigned char TBL_HkmSet2[256/*HkmSet2_Sizȅ*/][(SlotPos_Max+1)];
	unsigned char TBL_HkmSet3[256/*HkmSet3_Sizȅ*/][(SlotPos_Max+1)];
	unsigned char TBL_HkmSet1_CompSize[ 256/*[ȃTCY*/];
	unsigned char TBL_HkmSet2_CompSize[ 256/*[ȃTCY*/];
	unsigned char TBL_HkmSet3_CompSize[ 256/*[ȃTCY*/];
	unsigned char TBL_HkmSet1_CompData[8192/*[ȃTCY*/];
	unsigned char TBL_HkmSet2_CompData[8192/*[ȃTCY*/];
	unsigned char TBL_HkmSet3_CompData[8192/*[ȃTCY*/];
	unsigned char (*TBL_StpFlg1/*[HitCd_Size]*/)[/*iPos1*/(SlotPos_Max+1)];					//1[~tOBu(HitCd_Size)ŁA(bit0-5ɑΉ)̎ɁA1~[(iPos1)ɒ~邩B
	unsigned char (*TBL_StpFlg2/*[HitCd_Size]*/)[/*iPos1*/(SlotPos_Max+1)][/*iPos2*/(SlotPos_Max+1)];	//2[~tOBu(HitCd_Size)ŁA(bit0-5ɑΉ)̎ɁA1~[(iPos1),2~[(iPos2)ɒ~邩B
	unsigned char TBL_HkmSet1_Pack[256/*HkmSet1_Sizȅ*/][((SlotPos_Max+1) + 2) / 3];
} ST_Slot_StpCtl_Builder;
/*--------------------------------------------------------------------------*/
static int memcmp21(const void* x, const void* y) { return memcmp(x, y, (SlotPos_Max+1)); }
/*--------------------------------------------------------------------------*/
/* Zbg1do^ */
static int UnionHkmSet1(ST_Slot_StpCtl_Builder* pBuilder, const unsigned char aHkmCnt[(SlotPos_Max+1)]) {
	int iHkmSet1;
	for(iHkmSet1 = 0; iHkmSet1 < pBuilder->HkmSet1_Size; iHkmSet1++) {
		if(!memcmp21(pBuilder->TBL_HkmSet1[iHkmSet1], aHkmCnt)) { return iHkmSet1; }
	}
	if(pBuilder->HkmSet1_Size >= ARRAY_SIZE(pBuilder->TBL_HkmSet1)) { DIE(); }
	memcpy(pBuilder->TBL_HkmSet1[pBuilder->HkmSet1_Size], aHkmCnt, (SlotPos_Max+1));
	return pBuilder->HkmSet1_Size++;
}
/*--------------------------------------------------------------------------*/
/* Zbg2do^ */
static int UnionHkmSet2(ST_Slot_StpCtl_Builder* pBuilder, const unsigned char aHkmSet1[(SlotPos_Max+1)]) {
	int iHkmSet2;
	for(iHkmSet2 = 0; iHkmSet2 < pBuilder->HkmSet2_Size; iHkmSet2++) {
		if(!memcmp21(pBuilder->TBL_HkmSet2[iHkmSet2], aHkmSet1)) { return iHkmSet2; }
	}
	if(pBuilder->HkmSet2_Size >= ARRAY_SIZE(pBuilder->TBL_HkmSet2)) { DIE(); }
	memcpy(pBuilder->TBL_HkmSet2[pBuilder->HkmSet2_Size], aHkmSet1, (SlotPos_Max+1));
	return pBuilder->HkmSet2_Size++;
}
/*--------------------------------------------------------------------------*/
/* Zbg3do^ */
static int UnionHkmSet3(ST_Slot_StpCtl_Builder* pBuilder, const unsigned char aHkmSet2[(SlotPos_Max+1)]) {
	int iHkmSet3;
	for(iHkmSet3 = 0; iHkmSet3 < pBuilder->HkmSet3_Size; iHkmSet3++) {
		if(!memcmp21(pBuilder->TBL_HkmSet3[iHkmSet3], aHkmSet2)) { return iHkmSet3; }
	}
	if(pBuilder->HkmSet3_Size >= ARRAY_SIZE(pBuilder->TBL_HkmSet3)) { DIE(); }
	memcpy(pBuilder->TBL_HkmSet3[pBuilder->HkmSet3_Size], aHkmSet2, (SlotPos_Max+1));
	return pBuilder->HkmSet3_Size++;
}
/*--------------------------------------------------------------------------*/
ST_Slot_StpCtl* Slot_BuildStpCtl(const ST_Slot_StpCtl_BuilderInfo* pInfo) {
	ST_Slot_StpCtl* pStpCtl;
	ST_Slot_StpCtl_Builder* pBuilder;
	int iHitCd, iOrder, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3, i, j, n;
	unsigned char aHkmCnt[(SlotPos_Max+1)], aHkmSet1[(SlotPos_Max+1)], aHkmSet2[(SlotPos_Max+1)];
	unsigned char* p;
	/* kPʂ擾B0w肳ꂽꍇAlgpB */
	int HkmSet1_CompUnit = pInfo->HkmSet1_CompUnit ? pInfo->HkmSet1_CompUnit : 16/*l*/;
	int HkmSet2_CompUnit = pInfo->HkmSet2_CompUnit ? pInfo->HkmSet2_CompUnit : 16/*l*/;
	int HkmSet3_CompUnit = pInfo->HkmSet3_CompUnit ? pInfo->HkmSet3_CompUnit : 16/*l*/;
	/* ~f[^r_̃mۂB(1̃ubNƂĊmۂB1̃ubNƂĊJB) */
	p = calloc(1, sizeof(ST_Slot_StpCtl_Builder) +
		(pInfo->HitCd_Size * 3) +					/* TBL_StpCtl1 */
		(pInfo->HitCd_Size * 6) +					/* TBL_StpCtl2 */
		(pInfo->HitCd_Size * 6) +					/* TBL_StpCtl3 */
		(pInfo->HitCd_Size * (SlotPos_Max+1)) +				/* TBL_StpFlg1 */
		(pInfo->HitCd_Size * (SlotPos_Max+1) * (SlotPos_Max+1)));	/* TBL_StpFlg2 */
	if(!p) { DIE(); }
	pBuilder              = (void*)p;   p += sizeof(ST_Slot_StpCtl_Builder);
	pBuilder->TBL_StpCtl1 = (void*)p;   p += (pInfo->HitCd_Size * 3);
	pBuilder->TBL_StpCtl2 = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pBuilder->TBL_StpCtl3 = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pBuilder->TBL_StpFlg1 = (void*)p;   p += (pInfo->HitCd_Size * (SlotPos_Max+1));
	pBuilder->TBL_StpFlg2 = (void*)p; //p += (pInfo->HitCd_Size * (SlotPos_Max+1) * (SlotPos_Max+1));
	/*--- Zbg1do^ ---*/
	/* 1[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 3; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~[ */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				n = (*pInfo->fnGetStpCtl1)(pInfo->pParam, iHitCd, iReel1, iPos1);
				if((unsigned)n > 4) { DIE(); }
				pBuilder->TBL_StpFlg1[iHitCd][(iPos1 - n + (SlotPos_Max+1)) % (SlotPos_Max+1)] |= (((1<<0)|(1<<3))<<iOrder);		//1[~tOZbgB2~ŉ\̗L2ނ̉ɑ΂ăZbgB
				aHkmCnt[iPos1] = n;
			}
			UnionHkmSet1(pBuilder, aHkmCnt);												//\[g܂ŁAZbg1ԍ͖mBł́Ao^̂ݍsB
		}
	}
	/* 2[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[ */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~[ */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				for(iPos2 = 0; iPos2 < (SlotPos_Max+1); iPos2++) {
					if(pBuilder->TBL_StpFlg1[iHitCd][iPos1] & (1<<iOrder)) {
						n = (*pInfo->fnGetStpCtl2)(pInfo->pParam, iHitCd, iReel1, iReel2, iPos1, iPos2);
						if((unsigned)n > 4) { DIE(); }
						pBuilder->TBL_StpFlg2[iHitCd][iPos1][(iPos2 - n + (SlotPos_Max+1)) % (SlotPos_Max+1)] |= (1<<iOrder);	//2[~tOZbgB
					} else {
						n = 5;
					}
					aHkmCnt[iPos2] = n;
				}
				UnionHkmSet1(pBuilder, aHkmCnt);											//\[g܂ŁAZbg1ԍ͖mBł́Ao^̂ݍsB
			}
		}
	}
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				for(iPos2 = 0; iPos2 < (SlotPos_Max+1); iPos2++) {
					for(iPos3 = 0; iPos3 < (SlotPos_Max+1); iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					UnionHkmSet1(pBuilder, aHkmCnt);										//\[g܂ŁAZbg1ԍ͖mBł́Ao^̂ݍsB
				}
			}
		}
	}
	/* Zbg1\[gB\[gƁAkǂȂB */
	qsort(pBuilder->TBL_HkmSet1, pBuilder->HkmSet1_Size, (SlotPos_Max+1), memcmp21);								//ŁAZbg1ԍm肷B
	/*--- Zbg2do^ ---*/
	/* 2[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[ */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~[ */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				for(iPos2 = 0; iPos2 < (SlotPos_Max+1); iPos2++) {
					if(pBuilder->TBL_StpFlg1[iHitCd][iPos1] & (1<<iOrder)) {
						n = (*pInfo->fnGetStpCtl2)(pInfo->pParam, iHitCd, iReel1, iReel2, iPos1, iPos2);
						if((unsigned)n > 4) { DIE(); }
					} else {
						n = 5;
					}
					aHkmCnt[iPos2] = n;
				}
				aHkmSet1[iPos1] = UnionHkmSet1(pBuilder, aHkmCnt);
			}
			UnionHkmSet2(pBuilder, aHkmSet1);			//\[g܂ŁAZbg2ԍ͖mBł́Ao^̂ݍsB
		}
	}
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				for(iPos2 = 0; iPos2 < (SlotPos_Max+1); iPos2++) {
					for(iPos3 = 0; iPos3 < (SlotPos_Max+1); iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					aHkmSet1[iPos2] = UnionHkmSet1(pBuilder, aHkmCnt);
				}
				UnionHkmSet2(pBuilder, aHkmSet1);		//\[g܂ŁAZbg2ԍ͖mBł́Ao^̂ݍsB
			}
		}
	}
	/* Zbg2\[gB\[gƁAkǂȂB */
	qsort(pBuilder->TBL_HkmSet2, pBuilder->HkmSet2_Size, (SlotPos_Max+1), memcmp21);	//ŁAZbg2ԍm肷B
	/*--- Zbg3do^ ---*/
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				for(iPos2 = 0; iPos2 < (SlotPos_Max+1); iPos2++) {
					for(iPos3 = 0; iPos3 < (SlotPos_Max+1); iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					aHkmSet1[iPos2] = UnionHkmSet1(pBuilder, aHkmCnt);
				}
				aHkmSet2[iPos1] = UnionHkmSet2(pBuilder, aHkmSet1);
			}
			UnionHkmSet3(pBuilder, aHkmSet2);			//\[g܂ŁAZbg3ԍ͖mBł́Ao^̂ݍsB
		}
	}
	/* Zbg3\[gB\[gƁAkǂȂB */
	qsort(pBuilder->TBL_HkmSet2, pBuilder->HkmSet2_Size, (SlotPos_Max+1), memcmp21);	//ŁAZbg3ԍm肷B
	/*--- 1[~f[^,2[~f[^,3[~f[^쐬 ---*/
	/* 1[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 3; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~[ */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				n = (*pInfo->fnGetStpCtl1)(pInfo->pParam, iHitCd, iReel1, iPos1);
				if((unsigned)n > 4) { DIE(); }
				aHkmCnt[iPos1] = n;
			}
			pBuilder->TBL_StpCtl1[iHitCd][iOrder] = UnionHkmSet1(pBuilder, aHkmCnt);
		}
	}
	for(i = 0; i < pBuilder->HkmSet1_Size; i++) {
		for(j = 0; j < (((SlotPos_Max+1) + 2) / 3); j++) {
			pBuilder->TBL_HkmSet1_Pack[i][j] = (pBuilder->TBL_HkmSet1[i][(j * 3) + 0]     ) +
			                                   (pBuilder->TBL_HkmSet1[i][(j * 3) + 1] *  6) +
			                                   (pBuilder->TBL_HkmSet1[i][(j * 3) + 2] * 36);
		}
	}
	for(i = 0; i < pBuilder->HkmSet1_Size; i += HkmSet1_CompUnit) {
		n = pBuilder->HkmSet1_Size - i;
		if(n > HkmSet1_CompUnit) { n = HkmSet1_CompUnit; }
		n = TinyLZ_compress(
			&pBuilder->TBL_HkmSet1_CompData[pBuilder->HkmSet1_CompData_Size],
			ARRAY_SIZE(pBuilder->TBL_HkmSet1_CompData) - pBuilder->HkmSet1_CompData_Size,
			&pBuilder->TBL_HkmSet1_Pack[i], n * (((SlotPos_Max+1) + 2) / 3));
		pBuilder->TBL_HkmSet1_CompSize[i / HkmSet1_CompUnit] = n;
//{{2016/07/24ǉ:Slot_BuildStpCtl()ɂāATinyLZ_compress()̌ʂ256ȏɂȂɁA̓G[~ׂÂ܂(unsigned char)zɊi[Ă܂AԈf[^ĂoOC܂BC@ƂẮAi[O(n<256)Ăǂ̂łA(unsigned char)z(unsigned short)zɕύXꍇɔāAi[Ɍ̒lƓrČ鎖ɂ܂B
		if(pBuilder->TBL_HkmSet1_CompSize[i / HkmSet1_CompUnit] != n) { DIE(); }	//Œ~ꍇ́AHkmSet1_CompUnit炵ĉB
//}}2016/07/24ǉ:Slot_BuildStpCtl()ɂāATinyLZ_compress()̌ʂ256ȏɂȂɁA̓G[~ׂÂ܂(unsigned char)zɊi[Ă܂AԈf[^ĂoOC܂BC@ƂẮAi[O(n<256)Ăǂ̂łA(unsigned char)z(unsigned short)zɕύXꍇɔāAi[Ɍ̒lƓrČ鎖ɂ܂B
		if((pBuilder->HkmSet1_CompData_Size += n) > ARRAY_SIZE(pBuilder->TBL_HkmSet1_CompData)) { DIE(); }
	}
	/* 2[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[ */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~[ */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				for(iPos2 = 0; iPos2 < (SlotPos_Max+1); iPos2++) {
					if(pBuilder->TBL_StpFlg1[iHitCd][iPos1] & (1<<iOrder)) {
						n = (*pInfo->fnGetStpCtl2)(pInfo->pParam, iHitCd, iReel1, iReel2, iPos1, iPos2);
						if((unsigned)n > 4) { DIE(); }
					} else {
						n = 5;
					}
					aHkmCnt[iPos2] = n;
				}
				aHkmSet1[iPos1] = UnionHkmSet1(pBuilder, aHkmCnt);
			}
			pBuilder->TBL_StpCtl2[iHitCd][iOrder] = UnionHkmSet2(pBuilder, aHkmSet1);
		}
	}
	for(i = 0; i < pBuilder->HkmSet2_Size; i += HkmSet2_CompUnit) {
		n = pBuilder->HkmSet2_Size - i;
		if(n > HkmSet2_CompUnit) { n = HkmSet2_CompUnit; }
		n = TinyLZ_compress(
			&pBuilder->TBL_HkmSet2_CompData[pBuilder->HkmSet2_CompData_Size],
			ARRAY_SIZE(pBuilder->TBL_HkmSet2_CompData) - pBuilder->HkmSet2_CompData_Size,
			&pBuilder->TBL_HkmSet2[i], n * (SlotPos_Max+1));
		pBuilder->TBL_HkmSet2_CompSize[i / HkmSet2_CompUnit] = n;
//{{2016/07/24ǉ:Slot_BuildStpCtl()ɂāATinyLZ_compress()̌ʂ256ȏɂȂɁA̓G[~ׂÂ܂(unsigned char)zɊi[Ă܂AԈf[^ĂoOC܂BC@ƂẮAi[O(n<256)Ăǂ̂łA(unsigned char)z(unsigned short)zɕύXꍇɔāAi[Ɍ̒lƓrČ鎖ɂ܂B
		if(pBuilder->TBL_HkmSet2_CompSize[i / HkmSet2_CompUnit] != n) { DIE(); }	//Œ~ꍇ́AHkmSet2_CompUnit炵ĉB
//}}2016/07/24ǉ:Slot_BuildStpCtl()ɂāATinyLZ_compress()̌ʂ256ȏɂȂɁA̓G[~ׂÂ܂(unsigned char)zɊi[Ă܂AԈf[^ĂoOC܂BC@ƂẮAi[O(n<256)Ăǂ̂łA(unsigned char)z(unsigned short)zɕύXꍇɔāAi[Ɍ̒lƓrČ鎖ɂ܂B
		if((pBuilder->HkmSet2_CompData_Size += n) > ARRAY_SIZE(pBuilder->TBL_HkmSet2_CompData)) { DIE(); }
	}
	/* 3[~ */
	for(iHitCd = 0; iHitCd < pInfo->HitCd_Size; iHitCd++) {
		for(iOrder = 0; iOrder < 6; iOrder++) {
			iReel1 = Slot_GetOrderReel(iOrder, 0);		/* ~σ[1 */
			iReel2 = Slot_GetOrderReel(iOrder, 1);		/* ~σ[2 */
			iReel3 = Slot_GetOrderReel(iOrder, 2);		/* ~[  */
			for(iPos1 = 0; iPos1 < (SlotPos_Max+1); iPos1++) {
				for(iPos2 = 0; iPos2 < (SlotPos_Max+1); iPos2++) {
					for(iPos3 = 0; iPos3 < (SlotPos_Max+1); iPos3++) {
						if(pBuilder->TBL_StpFlg2[iHitCd][iPos1][iPos2] & (1<<iOrder)) {
							n = (*pInfo->fnGetStpCtl3)(pInfo->pParam, iHitCd, iReel1, iReel2, iReel3, iPos1, iPos2, iPos3);
							if((unsigned)n > 4) { DIE(); }
						} else {
							n = 5;
						}
						aHkmCnt[iPos3] = n;
					}
					aHkmSet1[iPos2] = UnionHkmSet1(pBuilder, aHkmCnt);
				}
				aHkmSet2[iPos1] = UnionHkmSet2(pBuilder, aHkmSet1);
			}
			pBuilder->TBL_StpCtl3[iHitCd][iOrder] = UnionHkmSet3(pBuilder, aHkmSet2);
		}
	}
	for(i = 0; i < pBuilder->HkmSet3_Size; i += HkmSet3_CompUnit) {
		n = pBuilder->HkmSet3_Size - i;
		if(n > HkmSet3_CompUnit) { n = HkmSet3_CompUnit; }
		n = TinyLZ_compress(
			&pBuilder->TBL_HkmSet3_CompData[pBuilder->HkmSet3_CompData_Size],
			ARRAY_SIZE(pBuilder->TBL_HkmSet3_CompData) - pBuilder->HkmSet3_CompData_Size,
			&pBuilder->TBL_HkmSet3[i], n * (SlotPos_Max+1));
		pBuilder->TBL_HkmSet3_CompSize[i / HkmSet3_CompUnit] = n;
//{{2016/07/24ǉ:Slot_BuildStpCtl()ɂāATinyLZ_compress()̌ʂ256ȏɂȂɁA̓G[~ׂÂ܂(unsigned char)zɊi[Ă܂AԈf[^ĂoOC܂BC@ƂẮAi[O(n<256)Ăǂ̂łA(unsigned char)z(unsigned short)zɕύXꍇɔāAi[Ɍ̒lƓrČ鎖ɂ܂B
		if(pBuilder->TBL_HkmSet3_CompSize[i / HkmSet3_CompUnit] != n) { DIE(); }	//Œ~ꍇ́AHkmSet3_CompUnit炵ĉB
//}}2016/07/24ǉ:Slot_BuildStpCtl()ɂāATinyLZ_compress()̌ʂ256ȏɂȂɁA̓G[~ׂÂ܂(unsigned char)zɊi[Ă܂AԈf[^ĂoOC܂BC@ƂẮAi[O(n<256)Ăǂ̂łA(unsigned char)z(unsigned short)zɕύXꍇɔāAi[Ɍ̒lƓrČ鎖ɂ܂B
		if((pBuilder->HkmSet3_CompData_Size += n) > ARRAY_SIZE(pBuilder->TBL_HkmSet3_CompData)) { DIE(); }
	}
	/* ~f[^̃mۂB(1̃ubNƂĊmۂB1̃ubNƂĊJB) */
	p = calloc(1, sizeof(ST_Slot_StpCtl) +
		(pInfo->HitCd_Size * 3) +						/* TBL_StpCtl1 */
		(pInfo->HitCd_Size * 6) +						/* TBL_StpCtl2 */
		(pInfo->HitCd_Size * 6) +						/* TBL_StpCtl3 */
		((pBuilder->HkmSet1_Size + HkmSet1_CompUnit - 1) / HkmSet1_CompUnit) +	/* TBL_HkmSet1_CompSize */
		((pBuilder->HkmSet2_Size + HkmSet2_CompUnit - 1) / HkmSet2_CompUnit) +	/* TBL_HkmSet2_CompSize */
		((pBuilder->HkmSet3_Size + HkmSet3_CompUnit - 1) / HkmSet3_CompUnit) +	/* TBL_HkmSet3_CompSize */
		pBuilder->HkmSet1_CompData_Size +					/* TBL_HkmSet1_CompData */
		pBuilder->HkmSet2_CompData_Size +					/* TBL_HkmSet2_CompData */
		pBuilder->HkmSet3_CompData_Size);					/* TBL_HkmSet3_CompData */
	if(!p) { DIE(); }
	pStpCtl                       = (void*)p;   p += sizeof(ST_Slot_StpCtl);
	pStpCtl->TBL_StpCtl1          = (void*)p;   p += (pInfo->HitCd_Size * 3);
	pStpCtl->TBL_StpCtl2          = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pStpCtl->TBL_StpCtl3          = (void*)p;   p += (pInfo->HitCd_Size * 6);
	pStpCtl->TBL_HkmSet1_CompSize = (void*)p;   p += ((pBuilder->HkmSet1_Size + HkmSet1_CompUnit - 1) / HkmSet1_CompUnit);
	pStpCtl->TBL_HkmSet2_CompSize = (void*)p;   p += ((pBuilder->HkmSet2_Size + HkmSet2_CompUnit - 1) / HkmSet2_CompUnit);
	pStpCtl->TBL_HkmSet3_CompSize = (void*)p;   p += ((pBuilder->HkmSet3_Size + HkmSet3_CompUnit - 1) / HkmSet3_CompUnit);
	pStpCtl->TBL_HkmSet1_CompData = (void*)p;   p += pBuilder->HkmSet1_CompData_Size;
	pStpCtl->TBL_HkmSet2_CompData = (void*)p;   p += pBuilder->HkmSet2_CompData_Size;
	pStpCtl->TBL_HkmSet3_CompData = (void*)p; //p += pBuilder->HkmSet3_CompData_Size;
	/* ~f[^i[B */
	pStpCtl->HitCd_Size            =    pInfo->HitCd_Size;
	pStpCtl->HkmSet1_CompUnit      =           HkmSet1_CompUnit;
	pStpCtl->HkmSet2_CompUnit      =           HkmSet2_CompUnit;
	pStpCtl->HkmSet3_CompUnit      =           HkmSet3_CompUnit;
	pStpCtl->HkmSet1_Size          = pBuilder->HkmSet1_Size;
	pStpCtl->HkmSet2_Size          = pBuilder->HkmSet2_Size;
	pStpCtl->HkmSet3_Size          = pBuilder->HkmSet3_Size;
	pStpCtl->HkmSet1_CompData_Size = pBuilder->HkmSet1_CompData_Size;
	pStpCtl->HkmSet2_CompData_Size = pBuilder->HkmSet2_CompData_Size;
	pStpCtl->HkmSet3_CompData_Size = pBuilder->HkmSet3_CompData_Size;
	memcpy((void*)pStpCtl->TBL_StpCtl1, pBuilder->TBL_StpCtl1, (pInfo->HitCd_Size * 3));									//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_StpCtl2, pBuilder->TBL_StpCtl2, (pInfo->HitCd_Size * 6));									//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_StpCtl3, pBuilder->TBL_StpCtl3, (pInfo->HitCd_Size * 6));									//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet1_CompSize, pBuilder->TBL_HkmSet1_CompSize, ((pBuilder->HkmSet1_Size + HkmSet1_CompUnit - 1) / HkmSet1_CompUnit));	//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet2_CompSize, pBuilder->TBL_HkmSet2_CompSize, ((pBuilder->HkmSet2_Size + HkmSet2_CompUnit - 1) / HkmSet2_CompUnit));	//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet3_CompSize, pBuilder->TBL_HkmSet3_CompSize, ((pBuilder->HkmSet3_Size + HkmSet3_CompUnit - 1) / HkmSet3_CompUnit));	//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet1_CompData, pBuilder->TBL_HkmSet1_CompData, pBuilder->HkmSet1_CompData_Size);						//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet2_CompData, pBuilder->TBL_HkmSet2_CompData, pBuilder->HkmSet2_CompData_Size);						//LXgconstx}̂
	memcpy((void*)pStpCtl->TBL_HkmSet3_CompData, pBuilder->TBL_HkmSet3_CompData, pBuilder->HkmSet3_CompData_Size);						//LXgconstx}̂
	/* ~f[^r_̃JB */
	free(pBuilder);
	/* ~f[^̃ԂBďoŊJB */
	return pStpCtl;
}
/*--------------------------------------------------------------------------*/
void Slot_PrintStpCtl(const ST_Slot_StpCtl* pStpCtl, FILE* fpH, FILE* fpC) {
	int iHitCd, iOrder, i;
	//1[~f[^o͂B
	fprintf(fpC, "static const unsigned char TBL_StpCtl1[/*HitCd_Size*/][3]/*[(SlotPos_Max+1)]*/={//(TBL_HkmSet1_CompSize,TBL_HkmSet1_CompData)\n");
	for(iHitCd = 0; iHitCd < pStpCtl->HitCd_Size; iHitCd++) {
		fprintf(fpC, "{");
		for(iOrder = 0; iOrder < 3; iOrder++) {
			if(iOrder) { fprintf(fpC, ","); }
			fprintf(fpC, "%3d", pStpCtl->TBL_StpCtl1[iHitCd][iOrder]);
		}
		fprintf(fpC, "},//%2d\n", iHitCd);
	}
	fprintf(fpC, "};\n");
	//2[~f[^o͂B
	fprintf(fpC, "static const unsigned char TBL_StpCtl2[/*HitCd_Size*/][6]/*[(SlotPos_Max+1)][(SlotPos_Max+1)]*/={//{TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData}(TBL_HkmSet1_CompSize,TBL_HkmSet1_CompData)\n");
	for(iHitCd = 0; iHitCd < pStpCtl->HitCd_Size; iHitCd++) {
		fprintf(fpC, "{");
		for(iOrder = 0; iOrder < 6; iOrder++) {
			if(iOrder) { fprintf(fpC, ","); }
			fprintf(fpC, "%3d", pStpCtl->TBL_StpCtl2[iHitCd][iOrder]);
		}
		fprintf(fpC, "},//%2d\n", iHitCd);
	}
	fprintf(fpC, "};\n");
	//3[~f[^o͂B
	fprintf(fpC, "static const unsigned char TBL_StpCtl3[/*HitCd_Size*/][6]/*[(SlotPos_Max+1)][(SlotPos_Max+1)][(SlotPos_Max+1)]*/={//(TBL_HkmSet3_CompSize,TBL_HkmSet3_CompData)(TBL_HkmSet2_CompSize,TBL_HkmSet2_CompData)(TBL_HkmSet1_CompSize,TBL_HkmSet1_CompData)\n");
	for(iHitCd = 0; iHitCd < pStpCtl->HitCd_Size; iHitCd++) {
		fprintf(fpC, "{");
		for(iOrder = 0; iOrder < 6; iOrder++) {
			if(iOrder) { fprintf(fpC, ","); }
			fprintf(fpC, "%3d", pStpCtl->TBL_StpCtl3[iHitCd][iOrder]);
		}
		fprintf(fpC, "},//%2d\n", iHitCd);
	}
	fprintf(fpC, "};\n");
	//Zbg1o͂B
	fprintf(fpC, "static const unsigned char TBL_HkmSet1_CompSize[/*(HkmSet1_Size+HkmSet1_CompUnit-1)/HkmSet1_CompUnit*/]={\n");
	for(i = 0; i < pStpCtl->HkmSet1_Size; i += pStpCtl->HkmSet1_CompUnit) {
		fprintf(fpC, "%3d,//%2d %3d-%3d\n",
			pStpCtl->TBL_HkmSet1_CompSize[i/pStpCtl->HkmSet1_CompUnit],
			                             (i/pStpCtl->HkmSet1_CompUnit),
			i, (((i+pStpCtl->HkmSet1_CompUnit)<pStpCtl->HkmSet1_Size)?(i+pStpCtl->HkmSet1_CompUnit):pStpCtl->HkmSet1_Size)-1);
	}
	fprintf(fpC, "};\n");
	fprintf(fpC, "static const unsigned char TBL_HkmSet1_CompData[/*HkmSet1_CompData_Size*/]={");
	for(i = 0; i < pStpCtl->HkmSet1_CompData_Size; i++) {
		if(!(i&15)) { fprintf(fpC, "\n"); }
		fprintf(fpC, "%3d,", pStpCtl->TBL_HkmSet1_CompData[i]);
		if(((i&15)==15) || (i==(pStpCtl->HkmSet1_CompData_Size-1))) { fprintf(fpC, "//%4d-%4d", (i&~15), i); }
	}
	fprintf(fpC, "\n};\n");
	//Zbg2o͂B
	fprintf(fpC, "static const unsigned char TBL_HkmSet2_CompSize[/*(HkmSet2_Size+HkmSet2_CompUnit-1)/HkmSet2_CompUnit*/]={\n");
	for(i = 0; i < pStpCtl->HkmSet2_Size; i += pStpCtl->HkmSet2_CompUnit) {
		fprintf(fpC, "%3d,//%2d %3d-%3d\n",
			pStpCtl->TBL_HkmSet2_CompSize[i/pStpCtl->HkmSet2_CompUnit],
			                             (i/pStpCtl->HkmSet2_CompUnit),
			i, (((i+pStpCtl->HkmSet2_CompUnit)<pStpCtl->HkmSet2_Size)?(i+pStpCtl->HkmSet2_CompUnit):pStpCtl->HkmSet2_Size)-1);
	}
	fprintf(fpC, "};\n");
	fprintf(fpC, "static const unsigned char TBL_HkmSet2_CompData[/*HkmSet2_CompData_Size*/]={");
	for(i = 0; i < pStpCtl->HkmSet2_CompData_Size; i++) {
		if(!(i&15)) { fprintf(fpC, "\n"); }
		fprintf(fpC, "%3d,", pStpCtl->TBL_HkmSet2_CompData[i]);
		if(((i&15)==15) || (i==(pStpCtl->HkmSet2_CompData_Size-1))) { fprintf(fpC, "//%4d-%4d", (i&~15), i); }
	}
	fprintf(fpC, "\n};\n");
	//Zbg3o͂B
	fprintf(fpC, "static const unsigned char TBL_HkmSet3_CompSize[/*(HkmSet3_Size+HkmSet3_CompUnit-1)/HkmSet3_CompUnit*/]={\n");
	for(i = 0; i < pStpCtl->HkmSet3_Size; i += pStpCtl->HkmSet3_CompUnit) {
		fprintf(fpC, "%3d,//%2d %3d-%3d\n",
			pStpCtl->TBL_HkmSet3_CompSize[i/pStpCtl->HkmSet3_CompUnit],
			                             (i/pStpCtl->HkmSet3_CompUnit),
			i, (((i+pStpCtl->HkmSet3_CompUnit)<pStpCtl->HkmSet3_Size)?(i+pStpCtl->HkmSet3_CompUnit):pStpCtl->HkmSet3_Size)-1);
	}
	fprintf(fpC, "};\n");
	fprintf(fpC, "static const unsigned char TBL_HkmSet3_CompData[/*HkmSet3_CompData_Size*/]={");
	for(i = 0; i < pStpCtl->HkmSet3_CompData_Size; i++) {
		if(!(i&15)) { fprintf(fpC, "\n"); }
		fprintf(fpC, "%3d,", pStpCtl->TBL_HkmSet3_CompData[i]);
		if(((i&15)==15) || (i==(pStpCtl->HkmSet3_CompData_Size-1))) { fprintf(fpC, "//%4d-%4d", (i&~15), i); }
	}
	fprintf(fpC, "\n};\n");
	//~f[^o͂B
	fprintf(fpH, "extern const ST_Slot_StpCtl stStpCtl;\n");
	fprintf(fpC,        "const ST_Slot_StpCtl stStpCtl={\n");
	fprintf(fpC, "%4d,//HitCd_Size\n",            pStpCtl->HitCd_Size);
	fprintf(fpC, "%4d,//HkmSet1_CompUnit\n",      pStpCtl->HkmSet1_CompUnit);
	fprintf(fpC, "%4d,//HkmSet2_CompUnit\n",      pStpCtl->HkmSet2_CompUnit);
	fprintf(fpC, "%4d,//HkmSet3_CompUnit\n",      pStpCtl->HkmSet3_CompUnit);
	fprintf(fpC, "%4d,//HkmSet1_Size\n",          pStpCtl->HkmSet1_Size);
	fprintf(fpC, "%4d,//HkmSet2_Size\n",          pStpCtl->HkmSet2_Size);
	fprintf(fpC, "%4d,//HkmSet3_Size\n",          pStpCtl->HkmSet3_Size);
	fprintf(fpC, "%4d,//HkmSet1_CompData_Size\n", pStpCtl->HkmSet1_CompData_Size);
	fprintf(fpC, "%4d,//HkmSet2_CompData_Size\n", pStpCtl->HkmSet2_CompData_Size);
	fprintf(fpC, "%4d,//HkmSet3_CompData_Size\n", pStpCtl->HkmSet3_CompData_Size);
	fprintf(fpC, "TBL_StpCtl1,\n");
	fprintf(fpC, "TBL_StpCtl2,\n");
	fprintf(fpC, "TBL_StpCtl3,\n");
	fprintf(fpC, "TBL_HkmSet1_CompSize,\n");
	fprintf(fpC, "TBL_HkmSet2_CompSize,\n");
	fprintf(fpC, "TBL_HkmSet3_CompSize,\n");
	fprintf(fpC, "TBL_HkmSet1_CompData,\n");
	fprintf(fpC, "TBL_HkmSet2_CompData,\n");
	fprintf(fpC, "TBL_HkmSet3_CompData,\n");
	fprintf(fpC, "};\n");
}
#endif//WIN32	//PCŒ~f[^쐬鎞Ɏgp܂BP/ECEł͎gp܂B

/****************************************************************************
 *	ԍt8byte`R}h
 ****************************************************************************/

//eXgXC[g
//void TestSuite(){
//  unsigned char Buf[8+1];
//  int sType,sData,rType,rData;
//  for(;;){
//    sType=(unsigned char)rand();
//    sData=(unsigned char)rand()|(unsigned char)rand()<<8|(unsigned char)rand()<<16|(unsigned char)rand()<<24;
//    Buf[8]=0x77;SlotCmd58_Encode(sType,sData,Buf);if(Buf[8]!=0x77){DIE();}
//    if(!SlotCmd58_Decode(&rType,&rData,Buf)||rType!=sType||rData!=sData){DIE();}//ý
//    Buf[rand()&7]^=0x80>>(rand()%3);if(SlotCmd58_Decode(&rType,&rData,Buf)){DIE();}//ُ팟oý
//} }

/*--------------------------------------------------------------------------*/

//i[
//n@@@@
//QPO@@@@
//@@@@
//sc
//VUTSRQPO31302928272625242322212019181716151413121110XWVUTSRQPO
//
//@@@@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//@@@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//@@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//@@@
#ifndef PIECE
void SlotCmd58_Encode(/*[in]*/int Type, /*[in]*/int Data, /*[out]*/void* _pBuf/*[8]*/) {
	unsigned char* pBuf = _pBuf;
	int Order;
	for(Order = 0; Order < 8; Order++) {
		*pBuf++ = (Order << 5) | ((unsigned char)Type >>  3);
		Type    = (Type  << 5) | ((unsigned     )Data >> 27);
		Data  <<=           5;
	}
}
#else //PIECE
void SlotCmd58_Encode(/*[in]*/int Type, /*[in]*/int Data, /*[out]*/void* _pBuf/*[8]*/);
asm("
		.code
		.align		1
		.global		SlotCmd58_Encode
SlotCmd58_Encode:
		ld.w		%r4, 0			;//%r4    :=    Order<<5  = 0<<5
		ld.ub		%r9, %r12		;//  %r9  :=               (unsigned char)Type			
SlotCmd58_Encode_LOOP:					;//do {								@
	;//	ld.ub		%r9, %r12		;//  %r9  :=               (unsigned char)Type			
		sra		%r9, 3			;//  %r9  :=               (unsigned char)Type>>3		@
		or		%r9, %r4		;//  %r9  :=   (Order<<5)|((unsigned char)Type>>3)		@
		ld.b		[%r14]+, %r9		;//  *pBuf++ = (Order<<5)|((unsigned char)Type>>3)		@
		ld.w		%r9, 16			;//  %r9  := i = 1<<4						@	
		 add		%r13, %r13		;//  do {    %r13 := Data<<=1, %psr(C) := Data[31]			@
		 sra		%r9, 1			;//          %psr(Z) := !(i>>=1)				@	%psr(C)ωȂ߂ɁA[vJE^ɃVtgpB
		jrne.d		-2			;//  } while(%psr(Z))						@	
		adc		%r12, %r12		;//          %r12 := (Type<<1)|%psr(C)					*delay*
		add		%r4, 32			;//  %r4  :=    Order<<5 += 1<<5				@
		xcmp		%r4, 224		;//} while(     Order<<5 <= 7<<5)				@
		jrle.d		SlotCmd58_Encode_LOOP	;//  								@
		ld.ub		%r9, %r12		;//  %r9  :=               (unsigned char)Type				*delay*
		ret
");
#endif//PIECE

/*--------------------------------------------------------------------------*/

//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@擾
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@n@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@QPO@@@@
//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//@@@@@^^^^^
//@@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//@@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//@@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//
//VUTSRQPO31302928272625242322212019181716151413121110XWVUTSRQPO
//sc
#ifndef PIECE
int SlotCmd58_Decode(/*[out]*/int* pType, /*[out]*/int* pData, /*[in]*/const void* _pBuf/*[8]*/) {
	const unsigned char* pBuf = _pBuf;
	int Order, Type = 0, Data = 0;				//ۂɂType[7:0],Data[31:0]͎擾rbĝŏsvłBʂi[OType[31:8]̂݃NAΗǂBAsmł͍L̕@ōœKB
	for(Order = 0; Order < 8; Order++) {
		int c = *pBuf++;
		if((c >> 5) != Order) { return 0; }		//ُ팟o
		Type = (Type << 5) | ((unsigned)Data >> 27);
		Data = (Data << 5) | (          c    &  31);
	}
	*pType = Type;
	*pData = Data;
	return 1;						//
}
#else //PIECE
int SlotCmd58_Decode(/*[out]*/int* pType, /*[out]*/int* pData, /*[in]*/const void* _pBuf/*[8]*/);
asm("
		.code
		.align		1
		.global		SlotCmd58_Decode
SlotCmd58_Decode:
		ld.w		%r10, 0			;//%r10   := result = 0
		ld.w		%r4, 0			;//%r4    := Order =  0
SlotCmd58_Decode_LOOP:					;//do {
		ld.ub		%r5, [%r14]+		;//  %r5      := c = *pBuf++
		rr		%r5, 5			;//  %r5[2:0] := c[7:5], %r5[31:27] := c[4:0]
		ld.ub		%r9, %r5		;//  %r9      := c[7:5]
		cmp		%r9, %r4		;//  if(c[7:5] != Order) { return 0 }
		jrne		SlotCmd58_Decode_RET	;//  
		ld.w		%r9, 16			;//  %r9  := i = 1<<4						
		 add		%r5, %r5		;//  do {    %r5  :=    c<<=1,          %psr(C) :=    c[31]	@
		 adc		%r6, %r6		;//          %r6  := (Data<<1)|%psr(C), %psr(C) := Data[31]	@
		 sra		%r9, 1			;//          %psr(Z) := !(i>>=1)				%psr(C)ωȂ߂ɁA[vJE^ɃVtgpB
		jrne.d		-3			;//  } while(%psr(Z))						
		adc		%r7, %r7		;//          %r7  := (Type<<1)|%psr(C)				*delay*
		cmp		%r4, 6			;//} while(  Order <= 6)
		jrle.d		SlotCmd58_Decode_LOOP	;//  
		add		%r4, 1			;//  %r4  := Order++						*delay*
		ld.ub		%r7, %r7		;//%r7    := Type = (unsigned char)Type
		ld.w		[%r12], %r7		;//*pType  = Type
		ld.w		[%r13], %r6		;//*pData  = Data
		ld.w		%r10, 1			;//%r10   := result = 1
SlotCmd58_Decode_RET:
		ret					;//return    result
");
#endif//PIECE
