/*	
 *	clipshya.c
 *
 *	ԏASY
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Wed May 14 22:25:54 JST 2014 Naoyuki Sawa
 *	- 1st[XB
 *	* Wed Jun 22 22:49:18 JST 2016 Naoyuki Sawa
 *	- USE_SHUNTINGYARD_SEHV{`ƁAclipshya.cDIE()SāASEH_throw(ShuntingYardException)ɒu悤ɂ܂B
 *	  [U[͂̃eLXgvZ邽߂ɁÃW[瓖W[ShuntingYard_Eval()𗘗p鎖LA
 *	  ԈĂɂɓW[łɃG[~Ă܂ƁAgÂ炢P[XłB
 *	  L̂悤ȃP[Xł́AShuntingYardExceptionߑ鎖ŁAspo܂B
 *	  ȊÕP[Xł́AShuntingYardExceptionߑȂ΁A܂Œʂ肷ɃG[~܂B
 *	- [Z`FbNǉ܂B
 *	  ܂łCPŨ[ZG[Ă܂Ă܂A̓vOŌoDIE(),,O𓊓܂B
 *	* Fri Jun 24 21:38:01 JST 2016 Naoyuki Sawa
 *	- ShuntingYard()̃oOɋCt̂ŁARgǋL܂B
 *	  ڍׂ́AShuntingYard()́u//{{2016/06/24RgǋL:`vQƂĉB
 *	  ̃oOA'Ԉ͂ꂽɃG[ooȂL'Ƃ̂łAɑ΂鏈͖L܂B
 *	- clipexpr.cW[ł́AL̃oO͏Cς݂łB
 *	  clipshya.cp~clipexpr.c֐؂ւčs\Ȃ̂ŁAclipshya.c͏Cɂ̂܂܂ɂĂɂ܂B
 *	  A܂clipshya.cgL΁A̎ɏCČ؂ĉB
 */
#include "clip.h"

//{{2016/06/22ǉ:USE_SHUNTINGYARD_SEHV{`ƁAclipshya.cDIE()SāASEH_throw(ShuntingYardException)ɒu悤ɂ܂B
#ifdef  USE_SHUNTINGYARD_SEH
//USE_SHUNTINGYARD_SEHV{`ꂽAclipshya.cDIE()SāASEH_throw(ShuntingYardException)ɒu܂B
#undef  DIE
#ifndef PIECE
  #define DIE() SEH_throw(ShuntingYardException)
#else //PIECE
  //P/ECEł̂悤ɒ`Ăǂ̂łAߖ̂߉̂悤ɒ`鎖ɂ܂Bʂ͓ɂȂ܂B
  //ȉ̒`clipseh.hSEH_throw()̒`ɈˑĂ܂BSEH_throw()ύX鎞͈ȉύXĉB
  #define DIE() do { ShuntingYard_throw(__FILE__, __LINE__); } while(0)
  static void __attribute__((noreturn)) ShuntingYard_throw(const char* file, int line) {
    SEH_info.file = file;
    SEH_info.line = line;
    SEH_info.msg  = NULL;
    SEH_longjmp((int)ShuntingYardException); }
#endif//PIECE
const char ShuntingYardException[1/*dummy*/];
#endif//USE_SHUNTINGYARD_SEH
//}}2016/06/22ǉ:USE_SHUNTINGYARD_SEHV{`ƁAclipshya.cDIE()SāASEH_throw(ShuntingYardException)ɒu悤ɂ܂B

/****************************************************************************
 *	ԏASY
 ****************************************************************************/
void ShuntingYard(const ST_ShuntingYard* pShuntingYard, const int* aInput, int* aOutput, void* pParam) {
	/* Ql:uhttp://ja.wikipedia.org/wiki/ԏASYv */
	int aStack[32/**/];
	int iStackTop = -1;
	int iToken;
	/* g[N1ǂݍށB */
	while((iToken = *aInput++)) {
		/* g[N̎ނɂāc */
		switch((*pShuntingYard->fnGetTokenType)(iToken, pParam)) {
		/* l */
		case ShuntingYard_TokenType_Number:
			/* lAo̓L[ɒǉB */
			*aOutput++ = iToken;
			break;
		/* ֐,, */
		case ShuntingYard_TokenType_Function:
		case ShuntingYard_TokenType_LeftParenthesis:
			/* ֐,,ʂAX^bNɃvbVB */
			if(++iStackTop >= ARRAY_SIZE(aStack)) { DIE(); }
			aStack[iStackTop] = iToken;
			break;
		/* ֐̈Zp[^(J}Ȃ) */
		case ShuntingYard_TokenType_FunctionArgumentSeparator:
			/* X^bÑgbvɂg[NʂƂȂ܂ŁAX^bN牉Zq(,֐)|bvďo̓L[ɒǉ铮JԂB	//{{2016/06/24RgǋL:u(,֐)vƂ͎ŔfĂĂ̂AԈႢłBڍׂ͉L̃RgQƂB}}
			 * ʂoĂȂꍇAZp[^̈ʒuAE̊ʂsvƂȂĂ(G[)B */
			for(;;) {
				if(iStackTop < 0) { DIE(); }
				if((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) == ShuntingYard_TokenType_LeftParenthesis) { break; }
				if(((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) != ShuntingYard_TokenType_Function) &&				//{{2016/06/24RgǋL:L̎ł͊֐g[NeĂ邪A͊ԈႢł鎖ɋCtBႦ΁ufunction(1,2)vƏׂufunction 1,2vƏꍇAL̎ł̓G[ooȂBclipexpr.cW[ł͏CBclipshya.cp~clipexpr.c֐؂ւčs\Ȃ̂ŁAclipshya.c͏Cɂ̂܂܂ɂĂA܂clipshya.cgLΏCB(TODO:)}}
				   ((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) != ShuntingYard_TokenType_Operator)) { DIE(); }
				*aOutput++ = aStack[iStackTop--];
			}
			break;
		/* Zq */
		case ShuntingYard_TokenType_Operator:
			/* X^bÑgbvɉZqg[No2Ao1,,D揇ʂo2ƓႢꍇA邢́Ao1̗D揇ʂo2ႢꍇAȉJԂB
			 * - o2X^bN|bvAo̓L[ɒǉB
			 * o1X^bNɃvbVB */
			while((iStackTop >= 0) &&								//X^bÑgbvɉZqg[No2A
			     (((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) == ShuntingYard_TokenType_Operator) &&
			     (((*pShuntingYard->fnIsOpLeftAssoc)(iToken, pParam) &&				//o1,,D揇ʂo2ƓႢꍇA
			     ((*pShuntingYard->fnCompareOpPrec)(iToken, aStack[iStackTop], pParam) <= 0)) ||
			     ((*pShuntingYard->fnCompareOpPrec)(iToken, aStack[iStackTop], pParam) < 0)))) {	//邢́Ao1̗D揇ʂo2ႢꍇA
				*aOutput++ = aStack[iStackTop--];
			}
			if(++iStackTop >= ARRAY_SIZE(aStack)) { DIE(); }
			aStack[iStackTop] = iToken;
			break;
		/* E */
		case ShuntingYard_TokenType_RightParenthesis:
			/* X^bÑgbvɂg[NʂɂȂ܂ŁAX^bN|bvZq(,֐)o̓L[ɒǉ铮JԂB	//{{2016/06/24RgǋL:u(,֐)vƂ͎ŔfĂĂ̂AԈႢłBڍׂ͉L̃RgQƂB}}
			 * ʂX^bN|bv邪Ao͂ɂ͒ǉɎ̂ĂB
			 * X^bÑgbvɂg[N֐g[NȂA|bvďo̓L[ɒǉB
			 * ʂX^bNɌȂꍇAE̊ʂ̕sv(G[)B */
			for(;;) {
				if(iStackTop < 0) { DIE(); }
				if((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) == ShuntingYard_TokenType_LeftParenthesis) { break; }
				if(((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) != ShuntingYard_TokenType_Function) &&				//{{2016/06/24RgǋL:L̎ł͊֐g[NeĂ邪A͊ԈႢł鎖ɋCtBႦ΁ufunction(1,2)vƏׂufunction 1,2)vƏꍇAL̎ł̓G[ooȂBclipexpr.cW[ł͏CBclipshya.cp~clipexpr.c֐؂ւčs\Ȃ̂ŁAclipshya.c͏Cɂ̂܂܂ɂĂA܂clipshya.cgLΏCB(TODO:)}}
				   ((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) != ShuntingYard_TokenType_Operator)) { DIE(); }
				*aOutput++ = aStack[iStackTop--];
			}
			iStackTop--;		//ʂX^bN|bv邪Ao͂ɂ͒ǉɎ̂ĂB
			if((iStackTop >= 0) &&	//X^bÑgbvɂg[N֐g[NȂA|bvďo̓L[ɒǉB
			  ((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) == ShuntingYard_TokenType_Function)) {
				*aOutput++ = aStack[iStackTop--];
			}
			break;
		default:
			DIE();
		}
	}
	/* X^bNɉZqg[NԁAȉJԂB
	 * - X^bÑgbvɂ鉉Zqg[NʂȂAʂ̕sv(G[)B
	 * - ZqX^bN|bvďo̓L[ɒǉB */
	while(iStackTop >= 0) {
		if(((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) == ShuntingYard_TokenType_LeftParenthesis ) ||
		   ((*pShuntingYard->fnGetTokenType)(aStack[iStackTop], pParam) == ShuntingYard_TokenType_RightParenthesis)) { DIE(); }
		*aOutput++ = aStack[iStackTop--];														//{{2016/06/24RgǋL:L̎ł͊֐g[NeĂ邪A͊ԈႢł鎖ɋCtBႦ΁ufunction()vƏׂufunctionvƏꍇAL̎ł̓G[ooȂBclipexpr.cW[ł͏CBclipshya.cp~clipexpr.c֐؂ւčs\Ȃ̂ŁAclipshya.c͏Cɂ̂܂܂ɂĂA܂clipshya.cgLΏCB(TODO:)}}
	}
	*aOutput = 0;	//o̓L[I[
}

/****************************************************************************
 *	Tv
 ****************************************************************************/
/* - ԏASY𗘗pāAeLXǧvZsTvłB
 *   Tvł͂܂A͂ŗplƎv̂ŁAAvP[Vp\ɂ܂B
 * - ̃Tvł́AP̂߁Al̂܂܃g[NlƂ܂B
 *   ۂɂ́AX̃g[Nێ郁mۂāA(int)ɃLXgāAg[NlƂׂłB
 */
/*---------------------------------------------------------------------------*/
/* ̃TvΉĂ鎮̗vf */
enum {
	op_umi=INT_MIN,	//Zq:-(P)
	op_pow,		//Zq:^
	op_add,		//Zq:+
	op_sub,		//Zq:-()
	op_mul,		//Zq:*
	op_div,		//Zq:/
	fn_abs,		//֐:abs
	fn_mod,		//֐:mod
	fn_sep,		//֐̈Zp[^(J}Ȃ):,
	lf_par,		//:(
	ri_par,		//E:)
	nu_min,		//l							//l(0)˃g[N(nu_min)ɃGR[h
};
/*---------------------------------------------------------------------------*/
/* eLXg𒆒uL@̃g[Nтɕϊ */
static void ShuntingYard_PreProcess(const char* pText, int* aInput) {
	int c, n, i = 0;
	while((c = *pText)) {
		if(isspace(c)) {
			pText++;
		} else if(isdigit(c)) {
			n = strtol(pText, (char**)&pText, 0);
			if(n <= nu_min) { DIE(); }
			aInput[i++] = n ? n : nu_min;				//l(0)˃g[N(nu_min)ɃGR[h
		} else if(!strncmp(pText, "abs", 3)) {
			pText += 3;
			aInput[i++] = fn_abs;
			continue;
		} else if(!strncmp(pText, "mod", 3)) {
			pText += 3;
			aInput[i++] = fn_mod;
			continue;
		} else {
			switch(c) {
			case '^': pText++; aInput[i++] = op_pow; break;
			case '+': pText++; aInput[i++] = op_add; break;
			case '-': if(i && (aInput[i-1] >= ri_par)) {
				  pText++; aInput[i++] = op_sub; } else {
				  pText++; aInput[i++] = op_umi; } break;
			case '*': pText++; aInput[i++] = op_mul; break;
			case '/': pText++; aInput[i++] = op_div; break;
			case ',': pText++; aInput[i++] = fn_sep; break;
			case '(': pText++; aInput[i++] = lf_par; break;
			case ')': pText++; aInput[i++] = ri_par; break;
			default: DIE();
			}
		}
	}
	aInput[i] = 0;
}
/*---------------------------------------------------------------------------*/
/* t|[hL@̃g[NтvZ */
static int ShuntingYard_PostProcess(const int* aOutput) {
	int aStack[32/**/];
	int iStackTop = -1;
	int iToken;
	while((iToken = *aOutput++)) {
		switch(iToken) {
		case op_umi:	//Zq:-(P)
			if(iStackTop < 0) { DIE(); }
			aStack[iStackTop] = -aStack[iStackTop];
			break;
		case op_pow:	//Zq:^
			if(iStackTop < 1) { DIE(); }
			aStack[iStackTop - 1] = (int)pow(aStack[iStackTop - 1], aStack[iStackTop]);
			iStackTop--;
			break;
		case op_add:	//Zq:+
			if(iStackTop < 1) { DIE(); }
			aStack[iStackTop - 1] = aStack[iStackTop - 1] + aStack[iStackTop];
			iStackTop--;
			break;
		case op_sub:	//Zq:-()
			if(iStackTop < 1) { DIE(); }
			aStack[iStackTop - 1] = aStack[iStackTop - 1] - aStack[iStackTop];
			iStackTop--;
			break;
		case op_mul:	//Zq:*
			if(iStackTop < 1) { DIE(); }
			aStack[iStackTop - 1] = aStack[iStackTop - 1] * aStack[iStackTop];
			iStackTop--;
			break;
		case op_div:	//Zq:/
			if(iStackTop < 1) { DIE(); }
//{{2016/06/22ǉ:[Z`FbNǉ܂B܂łCPŨ[ZG[Ă܂Ă܂A̓vOŌoDIE(),,O𓊓܂B
			if(!aStack[iStackTop]) { DIE(); }
//}}2016/06/22ǉ:[Z`FbNǉ܂B܂łCPŨ[ZG[Ă܂Ă܂A̓vOŌoDIE(),,O𓊓܂B
			aStack[iStackTop - 1] = aStack[iStackTop - 1] / aStack[iStackTop];
			iStackTop--;
			break;
		case fn_abs:	//֐:abs
			if(iStackTop < 0) { DIE(); }
			aStack[iStackTop] = abs(aStack[iStackTop]);
			break;
		case fn_mod:	//֐:mod
			if((iStackTop < 1) || (aStack[iStackTop] < nu_min) || (aStack[iStackTop - 1] < nu_min)) { DIE(); }
//{{2016/06/22ǉ:[Z`FbNǉ܂B܂łCPŨ[ZG[Ă܂Ă܂A̓vOŌoDIE(),,O𓊓܂B
			if(!aStack[iStackTop]) { DIE(); }
//}}2016/06/22ǉ:[Z`FbNǉ܂B܂łCPŨ[ZG[Ă܂Ă܂A̓vOŌoDIE(),,O𓊓܂B
			aStack[iStackTop - 1] = aStack[iStackTop - 1] % aStack[iStackTop];
			iStackTop--;
			break;
		case fn_sep:	//֐̈Zp[^(J}Ȃ):,
		case lf_par:	//:(
		case ri_par:	//E:)
			DIE();
		//case nu_min:	//l
		default:
			if(++iStackTop >= ARRAY_SIZE(aStack)) { DIE(); }
			aStack[iStackTop] = (iToken == nu_min) ? 0 : iToken;	//g[N(nu_min)ːl(0)ɃfR[h
			break;
		}
	}
	if((iStackTop != 0) || (aStack[iStackTop] < nu_min)) { DIE(); }
	return aStack[iStackTop];
}
/*---------------------------------------------------------------------------*/
/* AvP[V`̊֐:g[N̎ނԂ */
static int ShuntingYard_GetTokenType(int iToken, void* pParam) {
	switch(iToken) {
	case op_umi:	//Zq:-(P)
	case op_pow:	//Zq:^
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		return ShuntingYard_TokenType_Operator;
	case fn_abs:	//֐:abs
	case fn_mod:	//֐:mod
		return ShuntingYard_TokenType_Function;
	case fn_sep:	//֐̈Zp[^(J}Ȃ)
		return ShuntingYard_TokenType_FunctionArgumentSeparator;
	case lf_par:	//
		return ShuntingYard_TokenType_LeftParenthesis;
	case ri_par:	//E
		return ShuntingYard_TokenType_RightParenthesis;
	//case nu_min:	//l
	default:
		return ShuntingYard_TokenType_Number;
	}
}
/*---------------------------------------------------------------------------*/
/* AvP[V`̊֐:ZqԂ */
static int ShuntingYard_IsOpLeftAssoc(int iOpTok, void* pParam) {
	switch(iOpTok) {
	case op_umi:	//Zq:-(P)
	case op_pow:	//Zq:^
		return 0;
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		return 1;
	default: DIE();
	}
}
/*---------------------------------------------------------------------------*/
/* AvP[V`̊֐:Zq̗D揇ʂrׂ */
static int ShuntingYard_CompareOpPrec(int iOpTok1, int iOpTok2, void* pParam) {
	switch(iOpTok1) {
	case op_umi:	//Zq:-(P)
		iOpTok1 = 2; break;
	case op_pow:	//Zq:^
		iOpTok1 = 3; break;
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
		iOpTok1 = 0; break;
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		iOpTok1 = 1; break;
	default: DIE();
	}
	switch(iOpTok2) {
	case op_umi:	//Zq:-(P)
		iOpTok2 = 2; break;
	case op_pow:	//Zq:^
		iOpTok2 = 3; break;
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
		iOpTok2 = 0; break;
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		iOpTok2 = 1; break;
	default: DIE();
	}
	return iOpTok1 - iOpTok2;
}
/*---------------------------------------------------------------------------*/
/* ԏASY𗘗pāAeLXǧvZs */
int ShuntingYard_Eval(const char* pText) {
	static const ST_ShuntingYard stShuntingYard = {
		ShuntingYard_GetTokenType ,
		ShuntingYard_IsOpLeftAssoc,
		ShuntingYard_CompareOpPrec,
	};
	int aInput[64/**/], aOutput[64/**/];
	ShuntingYard_PreProcess(pText, aInput);				//eLXg˒uL@̃g[N
	ShuntingYard(&stShuntingYard, aInput, aOutput, NULL);		//uL@̃g[Nсˋt|[hL@̃g[N
	return ShuntingYard_PostProcess(aOutput);			//t|[hL@̃g[NсˌvZ
}
#if 0
void TestSuite() { //gp
	printf("%d\n", ShuntingYard_Eval("-10 + mod(-9,-abs(-10+5))^2")); //6		cOȂP/ECEŎsƁAʂ6ł͂Ȃ5ɂȂ܂BZ̓rŁApow()̉Z덷̂߂ɁA5^2=24.999...ː؂̂Ă24ɂȂ邩łBframdbl1.s̉Z덷̖łAW[ł͉o܂BŜňvZȂΑ̌덷͋eł̂łÂ̗悤ɐǑvZł͉e傫Ȃ܂B
}
#endif
