/*	
 *	clippky.h
 *
 *	P/ECE POKEY(CO12294) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Jan 26 20:20:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_PKY_H__
#define __CLIP_PKY_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _POKEY POKEY;

/***** Channel *****/
typedef struct _POKEYCHANNEL {
	int period;			/* o͔]TCN */
	int volume;			/* Volume (0`15) */
	int volume_only;		/* VolumeOnly (0:No/1:Yes) */
	int distotion;			/* Distotion (0`7) */
	//
	int progress;			/* TCNisJE^ (_EJE^) */
	int signal;			/* ݂̏o͒l (0:Lo/1:Hi) */
	int output;			/* ݂̏o̓x (-15`15) */
} POKEYCHANNEL;

/***** POKEY Chip *****/
/*typedef*/ struct _POKEY {
	unsigned char reg[16];		/* WX^lۑ */
	//
	POKEYCHANNEL channel[4];	/* `l1`4 */
	unsigned lfsr_progress;		/* LinearFeedbackShiftRegisterisJE^ (AbvJE^) */
	//
	DDA progress;			/* TCNisDDA */
} /*POKEY*/;

short pokey_process(POKEY* pokey, int cycle);
void pokey_channel_process(POKEY* pokey, POKEYCHANNEL* channel, int cycle);
int pokey_lfsr_signal4(POKEY* pokey);
int pokey_lfsr_signal5(POKEY* pokey);
int pokey_lfsr_signal17_9(POKEY* pokey);
void pokey_channel_setup(POKEY* pokey, int i_channel);

/****************************************************************************
 *	LFSRo̓e[u
 ****************************************************************************/

extern const unsigned char pokey_lfsr_table4[0x2/*output=0xf[bits],padding=1[bits]*/];
extern const unsigned char pokey_lfsr_table5[0x4/*output=0x1f[bits],padding=1[bits]*/];
extern const unsigned char pokey_lfsr_table9[0x40/*output=0x1ff[bits],padding=1[bits]*/];
extern const unsigned char pokey_lfsr_table17[0x4000/*output=0x1ffff[bits],padding=1[bits]*/];

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* POKEYRAZbg܂B
 * [in]
 *	pokey		POKEY\́B
 *	clock		̓NbNB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́APOKEYZbgsꍇɁAKvɉČĂяoĂB
 */
void pokey_reset(POKEY* pokey, int clock);

/* WX^lǂݍ݂܂B
 * [in]
 *	pokey		POKEY\́B
 *	regno		WX^ԍB
 */
unsigned char pokey_read(POKEY* pokey, int regno);

/* WX^l݂܂B
 * [in]
 *	pokey		POKEY\́B
 *	regno		WX^ԍB
 *	data		WX^lB
 */
void pokey_write(POKEY* pokey, int regno, unsigned char data);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁAw肳ꂽTṽ~LVOs܂B
 * [in]
 *	pokey		POKEY\́B
 *	wbuff		o̓Tvobt@B
 *	count		o̓TvB
 */
void pokey_mix(POKEY* pokey, short wbuff[/*count*/], int count);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_PKY_H__*/
