/*	
 *	clipn2.c
 *
 *	P/ECE YM2612(OPN2) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Dec 05 03:03:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/*
 *	* NTSCMegaDrivẽNbN\
 *
 *		UNbN = 53693100[Hz]
 *		|
 *		+--( 7)--+--> 68000  }X^NbN = 7.67[MHz]
 *		|	     +--> YM2612 }X^NbN = 7.67[MHz]
 *		+--(15)--+--> Z80    }X^NbN = 3.58[MHz]
 *			     +--> SN76789}X^NbN = 3.58[MHz]
 *
 *	* YM2612̃}X^NbNƔg̊֌W
 *
 *		}X^NbN		fM = 7.67[MHz]
 *		TvOg	fSam = fM(12~12) = 53267[Hz]
 *		g		fMus = (fSam~Fnumber~2^(Block-1))(2^20)
 *
 *		YM2203ƔrƁA}X^NbN{ȕATvOg̕{łB
 *		YM2203̒ʏ\ł́AfM=4MHz, fSam=fM(12~6) łB(̓WX^ݒŕύX)
 *		ǁAYM2612YM2203ATvOgȍ~̌vZɂ͓g݂łB
 *		YM2612̌łȂ߁AYM2203̌QlɂƂӎĂB
 *		(YM2203̌f[^V[gŁAAvP[V}jAȂǁc)
 *
 *		<> Fnumber = 1083, Block = 4
 *			fMus = (fSam~Fnumber~2^(Block-1))(2^20)
 *			     = ((536931007(12~12))~1083~2^(4-1))(2^20)
 *			     = 440[Hz] (A-4)
 *
 *	* g̎ɂ
 *
 *		fOut=SPEAKER_FREQUENCY=16000[Hz]ƂB
 *		PhaseGeneratorTable2^8GgƂƁAfMus=fOut̂Ƃɐisx2^ 8ɂȂ΂B
 *		isx̌Œ菬16bitƂƁA       fMus=fOut̂Ƃɐisx2^24ɂȂ΂B
 *
 *			isx = fMus~2^2416000
 *				 = (fSam~Fnumber~2^(Block-1))2^20~2^24 16000
 *				 = (fSam~Fnumber~2^(Block-1))      ~2^ 4 16000
 *				 = (fSam~Fnumber~2^(      4))2^(1-Block)16000
 *				 = (fSam~Fnumber~2^(     10))2^(7-Block)16000
 *				 = (fSam~Fnumber<<10         )( 16000    <<(7-Block))
 *				 = (fSam~Fnumber<< 3         )((16000>>7)<<(7-Block))
 *				    ~~~~  ~~~~~~~   ~              ~~~~~~~~    ~~~~~~~
 *				    16bit~11bit~3bit = 30bit     7bit~7bit = 14bit
 *
 *		ŌMULlāA
 *
 *			If MUL = 0 Then
 *				isx = isx / 2
 *			Else
 *				isx = isx * MUL
 *			End If
 */

const short ym2612op_pg_table[256] = { /* t9bit */
	+(  0),+(  6),+( 12),+( 18),+( 25),+( 31),+( 37),+( 43),+( 49),+( 55),+( 62),+( 68),+( 74),+( 80),+( 86),+( 91),
	+( 97),+(103),+(109),+(114),+(120),+(125),+(131),+(136),+(141),+(147),+(152),+(157),+(162),+(166),+(171),+(176),
	+(180),+(185),+(189),+(193),+(197),+(201),+(205),+(208),+(212),+(215),+(219),+(222),+(225),+(228),+(230),+(233),
	+(236),+(238),+(240),+(242),+(244),+(246),+(247),+(249),+(250),+(251),+(252),+(253),+(254),+(254),+(255),+(255),
	+(255),+(255),+(255),+(254),+(254),+(253),+(252),+(251),+(250),+(249),+(247),+(246),+(244),+(242),+(240),+(238),
	+(236),+(233),+(230),+(228),+(225),+(222),+(219),+(215),+(212),+(208),+(205),+(201),+(197),+(193),+(189),+(185),
	+(180),+(176),+(171),+(166),+(162),+(157),+(152),+(147),+(141),+(136),+(131),+(125),+(120),+(114),+(109),+(103),
	+( 97),+( 91),+( 86),+( 80),+( 74),+( 68),+( 62),+( 55),+( 49),+( 43),+( 37),+( 31),+( 25),+( 18),+( 12),+(  6),
	-(  0),-(  6),-( 12),-( 18),-( 25),-( 31),-( 37),-( 43),-( 49),-( 55),-( 62),-( 68),-( 74),-( 80),-( 86),-( 91),
	-( 97),-(103),-(109),-(114),-(120),-(125),-(131),-(136),-(141),-(147),-(152),-(157),-(162),-(166),-(171),-(176),
	-(180),-(185),-(189),-(193),-(197),-(201),-(205),-(208),-(212),-(215),-(219),-(222),-(225),-(228),-(230),-(233),
	-(236),-(238),-(240),-(242),-(244),-(246),-(247),-(249),-(250),-(251),-(252),-(253),-(254),-(254),-(255),-(255),
	-(255),-(255),-(255),-(254),-(254),-(253),-(252),-(251),-(250),-(249),-(247),-(246),-(244),-(242),-(240),-(238),
	-(236),-(233),-(230),-(228),-(225),-(222),-(219),-(215),-(212),-(208),-(205),-(201),-(197),-(193),-(189),-(185),
	-(180),-(176),-(171),-(166),-(162),-(157),-(152),-(147),-(141),-(136),-(131),-(125),-(120),-(114),-(109),-(103),
	-( 97),-( 91),-( 86),-( 80),-( 74),-( 68),-( 62),-( 55),-( 49),-( 43),-( 37),-( 31),-( 25),-( 18),-( 12),-(  6),
};

YM2612CH_MIX* const ym2612ch_mix_table[8] = {
	ym2612ch_mix0,
	ym2612ch_mix1,
	ym2612ch_mix2,
	ym2612ch_mix3,
	ym2612ch_mix4,
	ym2612ch_mix5,
	ym2612ch_mix6,
	ym2612ch_mix7,
};

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
ym2612_init(YM2612* ym2612, int f_m)
{
	int i_part;
	int i_reg;
	int i_ch;
	int i_op;

	/* ܂NA܂B */
	memset(ym2612, 0, sizeof(YM2612));

	/* TvOg߂܂B */
	ym2612->f_sam = f_m / (12 * 12);
	if(ym2612->f_sam <= 0) {
		DIE();
	}

	/* SWX^܂B */
	for(i_part = 0; i_part < 2; i_part++) {
		for(i_reg = 0; i_reg < 256; i_reg++) {
			switch(i_reg) {
			case 0x2a: /* DAC */
				/* dv!!
				 * GYMvC[DAC en͏݂܂ADAC͉肵܂B
				 * DACo͂𒆉lɏĂȂƁADACgGYMt@C͏-128̃oCAXĂ܂܂B
				 * (DACݒl͕8bitōŏ:0..128..255:ő A0ŏ-128ƌȂĂ܂B)
				 */
				ym2612_write_reg(ym2612, i_part, i_reg, 128); /* 128lł */
				break;
			case 0xb4: /* L, R, AMS, FMS */
			case 0xb5: /* L, R, AMS, FMS */
			case 0xb6: /* L, R, AMS, FMS */
				ym2612_write_reg(ym2612, i_part, i_reg, 0xc0); /* L,R=On */
				break;
			default:
				ym2612_write_reg(ym2612, i_part, i_reg, 0);
				break;
			}
		}
	}

	/* Gx[v֐܂B
	 * * WX^̏łKey off肳Ȃ߁AGx[v֐܂B
	 *   ̂ݖIɃGx[v֐Kv܂B
	 */
	for(i_part = 0; i_part < 2; i_part++) {
		for(i_ch = 0; i_ch < 3; i_ch++) {
			for(i_op = 0; i_op < 4; i_op++) {
				ym2612->ch[i_part][i_ch].op[i_op].eg_env = ym2612op_env_silent;
			}
		}
	}
}

int
ym2612_read(YM2612* ym2612, int addr)
{
	//int i_part;
	//int i_reg;
	//
	///* A0CɂXe[^Xǂݏo/WX^lǂݏo̐؂ւ́AYM2203̎dlɏ]܂B
	// * YM2612G~[^\[X́AA0C01ɂ炸AɃXe[^Xǂݏo悤łB
	// * MegaDriveŗL̎dlAƂ{YM2612YM2203ƈăWX^lǂݏoȂ̂fłȂ߁A
	// * Ƃ肠YM2203ƓAA0CɂăXe[^Xǂݏo/WX^lǂݏo؂ւ邱Ƃɂ܂B
	// */
	//2004/12/09 Naoyuki Sawa 
	//YM2203œǂݏốA0x00..0x0fPSG݊WX^łBFM̃WX^l͓ǂݏo܂B
	//YM2612PSG݊ĂȂ̂ŁAǂݏo郌WX^͂܂BɃXe[^XǂݏoƂȂ܂B
	//
	///* A0 = 0:Xe[^Xǂݏo */
	//if(!(addr & 1)) {
	//2004/12/09 Naoyuki Sawa 
	//A001ɂ炸AXe[^XǂݏołB

		/* * Xe[^X̍\͎̒ʂłB
		 *
		 *	Bit 76543210
		 *	    |||||||+- Overflow B
		 *	    ||||||+-- Overflow A
		 *	    |+++++--- Unknown
		 *	    +-------- Busy
		 *
		 * - 2004/12/05݁AP/ECE YM2612 EmulatorYM2612^C}T|[gȂ̂ŁAOverflow A,B͏0Ƃ܂B
		 *   ܂@ł́AWX^f[^݌Busy=1ɂȂA莞Ԍ㎟̃f[^t\Busy=0ɖ߂̂łA
		 *   G~[VvOł͂̋ČKvȂ߁ABusy͏0Ƃ܂B
		 *   ȏAYM2612̓ǂݏóAXe[^XƂď0ԂƂɂ܂B
		 */
		return 0;

	//};
	//
	///* A0 = 1:WX^lǂݏo */
	//i_part = (addr >> 1) & 1; /* A1 = Part I/II I */
	//i_reg = ym2612->i_reg[i_part];
	//return ym2612->reg[i_part][i_reg];
	//2004/12/09 Naoyuki Sawa 
	//A001ɂ炸AXe[^XǂݏołB
}

/* Gx[vԊZp̕WfSAM(=fM/(12*12))
 * * OPÑ^C~OȂ̂ŁAOPM̃^C~OQlɂ܂B
 *   OPM̕WfM4MHzłAOPN2͕䂪2{݂Ȃ̂8MHzɂ܂B
 */
#define EG_FSAM_BASE	(8000000 / (12 * 12))
//_͏q̂Ƃ̂͂Ȃ̂łAȂ2`4{炢̕ǂɒ܂B
//ԂA{FM͉ʃJ[uw֐IŌ}ł̂ɑ΂āA
//{hCỏʃJ[u͒Ȃ̂ŁA𑬂߂ǂɒ̂Ǝv܂B
//2004/12/9݂̎1{̂܂܂ƂłAA2`4{̒`ɕς邩m܂B
//#define EG_FSAM_BASE	(4000000 / (12 * 12)) // 2{
//#define EG_FSAM_BASE	(2000000 / (12 * 12)) // 4{

/* g[^xATXeBxݒlA{[vZ܂B
 * [in]
 *	tl		g[^xݒl
 *				(0..127)~0.75[dB]
 *				ő僌x̌
 *	sl		TXeBxݒl (0..15)
 *				(0..14)~3[dB]Asl=15̏ꍇ̂(15)~3+48[dB]
 *				g[^x̌
 * [out]
 *	߂l		{[
 *				ʏ:(0.0)..(127.0):ʑ
 *				(7.16bitŒ菬)
 */
static int
calc_volume(int tl, int sl)
{
#if 0
//
//	/* * wInside X68000xp.288uIy[^𒼗ڑƂ̏o͔g`vp(OPM̎)
//	 *	------------------------------------------------------------------------------------
//	 *	@Iy[^2ɐڑƂSINg`e[ȕoÁA
//	 *
//	 *		A = SIN(t + SIN(t))
//	 *
//	 *	̂悤ɕ\܂BtAt́AvɎgłA͊ȒPɋ߂܂A
//	 *	̋ߕJĂȂ̂ŁÂ܂܂ł͏o͔g`킩܂B̌ʁAe
//	 *	Xbg̏o͂TLŌ܂Ƃ(AR0AD1RAD2RȂǂől̂Ƃ)ɂ́A
//	 *
//	 *		 = 10^(-0.75/20~TL + e/2)
//	 *		     ŁAe͎Rΐ̒(=2.71828...)A'^'ׂ͂
//	 *
//	 *	ƂASIN(t)̌vZʂ̐lWAPʂ̊pxf[^Ƃ݂ȂătƑƁA
//	 *	Ȃ悢ɂȂ邱Ƃ킩܂B
//	 *	@M1̃tB[hobNʂ͂悭킩܂łATL0dB̂Ƃ1(WA)
//	 *	Ƃ݂ȂătB[hobNƂ悢悤łBƂFL=3Ȃ0.7853(=3.14159/4)
//	 *	ZltB[hobNƁA߂g`܂B
//	 *	------------------------------------------------------------------------------------
//	 */
//
//	double db;
//	double a;
//
//	db = tl * 0.75;
//	if(sl < 15) {
//		db += sl * 3;
//	} else {
//		db += sl * 3 + 48;
//	}
//	a = pow(10, -db / 20 + exp(1) / 2);
//
//	a = a * (127 << 16) / (2 * acos(-1));
//	if(a > 127 << 16) {
//		a = 127 << 16;
//	}
//
//	return (int)a;
//
#else	//_͂Ȃ̂łA̒ʂĂ܂肢ɕȂ̂ƁAvZԂ肷邽߁A
	//̂悤Ɋȗ܂B

	/* * {FḾAGx[vo͂w֐Iɕω܂B
	 *   {1TvÂvZȂ΂Ȃ(Ǝv)̂łAP/ECEŏɂ͏d߂܂B
	 *   ̂߂ɁAʐݒ̒iKŎw֐Iɕϊ邾łA܂܂ۂ܂B
	 *
	 *		 = (ʐݒl ~ ʐݒől)^6 ~ʐݒől
	 *
	 *   ʐݒl6悷ƁAǂɂȂ݂łB()
	 *   ׂvZ̓r32bit𒴂Ă܂Ȃ悤AӂĂB
	 */
	int v;

	tl ^= 127;			/* :127..0: => :0..127: */
	tl = tl * tl;			/*  7bit~ 7bit =>   14bit */
	v  = tl * tl;			/* 14bit~14bit =>   28bit */
	v >>= 14;			/* 28bit        =>   14bit */
	v  *= tl;			/* 14bit~14bit =>   28bit */
	v >>= 28 - (7 + 16);		/* 28bit        => 7.16bit */

	//if(sl < 15) {
	//	sl = sl * 3;
	//} else {
	//	sl = sl * 3 + 48;	/* SL=15̓ */
	//}
	//sl = (15 * 3 + 48) - sl;	/* :93..0: => :0..93: */
	//sl = v * sl / (15 * 3 + 48);
	//SL=15̓lȂǂɒ݂łB
	sl ^= 15;			/* :15..0: => :0..15: */
	v = v * sl / 15;

	return v;

#endif
}

/* Iω̉ʐݒlAw֐Iω̎ʂɕϊ܂B
 * [in]
 *	v		ʐݒl (MIN:0..127:MAX)
 * [out]
 *	߂l		s (MIN:(0.0)..(127.0):MAXA7.16bitŒ菬)
 * [note]
 */

void
ym2612_write(YM2612* ym2612, int addr, int data)
{
	int i_part;
	int i_reg;
	int i_ch;
	int i_op;
	YM2612CH* ch;
	YM2612OP* op;
	int mask;
	int rate;
	int block;
	int f_number;
	int pg_spd;

	/* sȏݒlo܂B(vOG[) */
	if((data < 0x00) || (data > 0xff)) {
		DIE();
	}

	/* A1 = Part I/II I */
	i_part = (addr >> 1) & 1;

	/* A0 = 0:WX^AhX */
	if(!(addr & 1)) {
		ym2612->i_reg[i_part] = data;
		return;
	}

	/* ރWX^AhX擾܂B */
	i_reg = ym2612->i_reg[i_part];

	/* WX^0x00..0x2f */
	if(i_reg < 0x30) {

		/* Part IIɂ̓WX^0x00..0x2f͂܂B */
		if(i_part) {
			return; /* WX^s */
		}

		switch(i_reg) {
		//case 0x22: /* LFO enable, LFO frequency */
		//case 0x24: /* Timer A MSBs */
		//case 0x25: /* Timer A LSBs */
		//case 0x26: /* Timer B */

		case 0x27: /* Ch3 mode, Reset B, Reset A, Enable B, Enable A, Load B, Load A */

			/* Channel 3 has 4 separate frequencyi[܂B
			 * * zgCh3 modeύX̒Operator i_oppg_spdXVׂȂ̂łǁA
			 *   ԂCh3 modeύXF-numberBlockύXƎv̂ŁAȗ܂B
			 * * bit7`6`l3̃[hwŁA{00:ʏ,10:ʉ:01:}ƂȂ܂B
			 *   (FM TOWNSeNjJf[^ubN2 p.201 )
			 *   ÃG~[^\[XWeb̎ł́A{00:ʏ,01:ʉ:10:}
			 *   LڂĂ̂Aǂ炪̂fł܂B
			 *   ɂA{00:ʏ}ȊOȂ΃`l3̊eIy[^͌ʂ̎gݒƂȂ܂̂ŁA
			 *   00ȊOȂChannel 3 has 4 separate frequencyȂƂɂ܂B
			 *   ȂA[hTimerƘAKey on/offs[hŁA2004/12/10݂͖łB
			 */
			ym2612->ch3_mode = (data & 0xc0) != 0;

			break;

		case 0x28: /* Operator, Channel */

			/* `l擾܂B */
			i_part = (data >> 2) & 1; /* bit  2 = Part I/II I */
			i_ch = data & 3;          /* bit1-0 = Channel 0..2   */
			if(i_ch == 3) {
				return; /* `ls */
			}
			ch = &ym2612->ch[i_part][i_ch];

			/* Iy[^1..4ɂ... */
			mask = data >> 4;
			for(i_op = 0, op = ch->op;
			    i_op < 4;
			    i_op++, op++, mask >>= 1) {
				if(mask & 1) { /* Key on */

					/* {Attack,Decay,Sustain}ȂΉ܂B */
					if((op->eg_env != ym2612op_env_release) &&
					   (op->eg_env != ym2612op_env_silent)) {
						continue;
					}
					op->eg_env = ym2612op_env_attack;
					op->eg_cnt = 0;

				} else { /* Key off */

					/* {Release,Silent}ȂΉ܂B */
					if((op->eg_env == ym2612op_env_release) ||
					   (op->eg_env == ym2612op_env_silent)) {
						continue;
					}
					op->eg_env = ym2612op_env_release;
					if(op->eg_cnt > op->eg_sl) {
						op->eg_cnt = op->eg_sl;
					}
				}
			}

			break;

		case 0x2a: /* DAC */

			/* DACo͒li[܂B((-127.0)..(127.0)~) */
			ym2612->dac = (data - 128) << (16 + 2/*DACʒ*/);

			break;

		case 0x2b: /* DAC en */

			/* DAC eni[܂B */
			ym2612->dac_en = (data >> 7) & 1;

			break;
		}

		return;
	}

	/* `lI܂B */
	i_ch = i_reg & 3;
	if(i_ch == 3) {
		return; /* `lsBWX^0xa8..0xaf̏ꍇ̓Iy[^s */
	}
	ch = &ym2612->ch[i_part][i_ch];

	/* WX^0x30..0x9f */
	if(i_reg < 0xa0) {

		/* Iy[^I܂B
		 * * WX^0x30..0x9éAIy[^̏Ԃ{1,2,3,4}ł͂Ȃ{1,3,2,4}łB
		 *   (FM TOWNSeNjJf[^ubN2 p.199 )
		 */
		switch((i_reg >> 2) & 3) {
		case 0:       i_op = 0; break; /* 0x?0, 0x?1, 0x?2 = Op1 */
		case 1:       i_op = 2; break; /* 0x?4, 0x?5, 0x?6 = Op3 */
		case 2:       i_op = 1; break; /* 0x?8, 0x?9, 0x?a = Op2 */
		default/*3*/: i_op = 3; break; /* 0x?c, 0x?d, 0x?e = Op4 */
		}
		op = &ch->op[i_op];

		switch(i_reg >> 4) {
		case 0x30 >> 4: /* DT1, MUL */

			/* }`vi[܂B
			 * * zgMULύX̒Operator i_oppg_spdXVׂȂ̂łǁA
			 *   ԂMULύXF-numberBlockύXƎv̂ŁAȗ܂B
			 */
			op->mul = data & 15;

			break;

		case 0x40 >> 4: /* TL */

			/* g[^xݒlۑ܂B */
			op->tl = data & 127;

			/* g[^xݒ肵܂B((0.0)..(127.0)) */
			op->eg_tl = calc_volume(op->tl, 0);

			/* g[^x̕ύXɒǏ]āATXeBxXV܂B((0.0)..(127.0)) */
			op->eg_sl = calc_volume(op->tl, op->sl);
			if((op->eg_env == ym2612op_env_sustain) || (op->eg_env == ym2612op_env_release)) {
				if(op->eg_cnt > op->eg_sl) {
					op->eg_cnt = op->eg_sl;
				}
			}

			break;

		case 0x50 >> 4: /* RS, AR */

			/* A^bN[gݒ肵܂B
			 * * AR={30:0.5[ms], 28:1.0[ms], 26:2.0[ms], ..., 0:INF} @WfSAM 犷Z܂B
			 */
			rate = data & 31;
			if(rate) {
				op->eg_ar = (((127 * ym2612->f_sam / EG_FSAM_BASE) << 16) / (int)(SPEAKER_FREQUENCY * 0.5 / 1000)) >> (15 - (rate >> 1));
				//            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				//                 {[ől~NbNWNbN             0.5[ms]̏o̓Tv     
				if(rate & 1) { /* {31,29,27,...}{30,28,26,...}50%UP */
					op->eg_ar += op->eg_ar >> 1;
				}
			} else {
				op->eg_ar = 0;
			}

			break;

		case 0x60 >> 4: /* AM, D1R */

			/* fBPC[gݒ肵܂B
			 * * DR={30:6.0[ms], 28:12.0[ms], 26:24.0[ms], ..., 0:INF} @WfSAM 犷Z܂B
			 */
			rate = data & 31;
			if(rate) {
				op->eg_dr = (((127 * ym2612->f_sam / EG_FSAM_BASE) << 16) / (int)(SPEAKER_FREQUENCY * 6.0 / 1000)) >> (15 - (rate >> 1));
				//            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				//            {[ől~NbNWNbN    6.0[ms]̏o̓Tv
				if(rate & 1) { /* {31,29,27,...}{30,28,26,...}50%UP */
					op->eg_dr += op->eg_dr >> 1;
				}
			} else {
				op->eg_dr = 0;
			}

			break;

		case 0x70 >> 4: /* D2R */

			/* TXeB[gݒ肵܂B
			 * * SR={30:6.0[ms], 28:12.0[ms], 26:24.0[ms], ..., 0:INF} @WfSAM 犷Z܂B
			 */
			rate = data & 31;
			if(rate) {
				op->eg_sr = (((127 * ym2612->f_sam / EG_FSAM_BASE) << 16) / (int)(SPEAKER_FREQUENCY * 6.0 / 1000)) >> (15 - (rate >> 1));
				//            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				//            {[ől~NbNWNbN    6.0[ms]̏o̓Tv
				if(rate & 1) { /* {31,29,27,...}{30,28,26,...}50%UP */
					op->eg_sr += op->eg_sr >> 1;
				}
			} else {
				op->eg_sr = 0;
			}

			break;

		case 0x80 >> 4: /* D1L, RR */

			/* [X[gݒ肵܂B
			 * * RR={15:6.0[ms], 14:12.0[ms], 13:24.0[ms], ..., 0:INF} @WfSAM 犷Z܂B
			 */
			rate = data & 15;
			if(rate) {
				op->eg_rr = (((127 * ym2612->f_sam / EG_FSAM_BASE) << 16) / (int)(SPEAKER_FREQUENCY * 6.0 / 1000)) >> (15 - rate);
				//            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				//            {[ől~NbNWNbN    6.0[ms]̏o̓Tv
			} else {
				op->eg_rr = 0;
			}

			/* TXeBxݒlۑ܂B */
			op->sl = (data >> 4) & 15;

			/* TXeBxXV܂B((0.0)..(127.0)) */
			op->eg_sl = calc_volume(op->tl, op->sl);
			if((op->eg_env == ym2612op_env_sustain) || (op->eg_env == ym2612op_env_release)) {
				if(op->eg_cnt > op->eg_sl) {
					op->eg_cnt = op->eg_sl;
				}
			}

			break;

		//case 0x90 >> 4: /* SSG-EG */
		}

		return;
	}

	/* WX^0xa0..0xff */
	switch(i_reg >> 2) {
	case 0xa0 >> 2: /* Frequency number LSB */

		/* F-number[7..0]i[܂B */
		ch->f_number_lsb = data;
		data = -1; /* ł̃WX^i[} */

		/* FALLTHRU */

	case 0xa4 >> 2: /* Block, Frequency number MSB */

		/* ォFALLTHRUłȂ΁AF-number[10..8]Blocki[܂B */
		if(data != -1) {
			ch->f_number_msb = data & 7;
			ch->block = (data >> 3) & 7;
		}

		/* x߂܂B */
		f_number = ch->f_number_lsb | (ch->f_number_msb << 8);
		block    = ch->block;
		pg_spd   = (ym2612->f_sam * (f_number << 3)) / ((SPEAKER_FREQUENCY >> 7) << (7 - block));

		/* Iy[^1..4ɂ... */
		for(i_op = 0, op = ch->op;
		    i_op < 4;
		    i_op++, op++) {

			/* Channel 3 has 4 separate frequencyȂ΃Iy[^1..3̓WX^0xa8..0xafɂĐݒ肳̂ŁAł͐ݒ肵܂B
			 * * uSega Genesis Technical Manual - YM2612 sectionvɂ́AChannel 64 separate frequency[hƏĂ܂A
			 *   YM2612G~[^\[XQlɂƁA4 separate frequency[hĂ̂Channel 3łB
			 *   ԂYM2612ł́AChannel 6̓@\ƂāA4 separate frequency̑ɁAADPCM[hĂ̂Ǝv܂B
			 * * uSega Genesis Technical Manual - YM2612 sectionvɂ́AChannel 3 has 4 separate frequency̏ꍇ̃WX^蓖ẮA
			 *	0xa2, 0xa6 = Ch3 Op1
			 *	0xa8, 0xac = Ch3 Op2
			 *	0xa9, 0xad = Ch3 Op3
			 *	0xaa, 0xae = Ch3 Op4
			 *   ƋLڂĂ܂AYM2612G~[^\[XQlɂƁÂ͎悤Ȋ蓖ĂɂȂĂ悤łB
			 *	0xa2, 0xa6 = Ch3 Op4
			 *	0xa8, 0xac = Ch3 Op3
			 *	0xa9, 0xad = Ch3 Op1
			 *	0xaa, 0xae = Ch3 Op2
			 */
			if(ym2612->ch3_mode) {			/* Channel 3 has 4 separate frequency */
				if(!i_part && (i_ch == 2)) {	/* `l3Ȃ                      */
					if(i_op != 3) {		/* Iy[^4ȊO͐ݒ肵ȂB        */
						continue;
					}
				}
			}

			/* }`vKpAxݒ肵܂B */
			if(op->mul) {
				op->pg_spd = pg_spd * op->mul;
			} else {
				op->pg_spd = pg_spd / 2;
			}
		}

		break;

	case 0xa8 >> 2: /* Ch3 supplementary frequency number LSB */

		/* Channel 64 separate frequency[hĂ܂B(̃RgQ)
		 * ]āAPart IIɂ̓WX^0xa8..0xaf͂܂B
		 */
		if(i_part) {
			return;
		}

		/* F-number[7..0]i[܂B */
		ym2612->ch3_f_number_lsb[i_reg & 3] = data;
		data = -1; /* ł̃WX^i[} */

		/* FALLTHRU */

	case 0xac >> 2: /* Ch3 supplementary block, Ch3 supplementary frequency number MSB */

		/* Channel 64 separate frequency[hĂ܂B(̃RgQ)
		 * ]āAPart IIɂ̓WX^0xa8..0xaf͂܂B
		 */
		if(i_part) {
			return;
		}

		/* ォFALLTHRUłȂ΁AF-number[10..8]Blocki[܂B */
		if(data != -1) {
			ym2612->ch3_f_number_msb[i_reg & 3] = data & 7;
			ym2612->ch3_block[i_reg & 3] = (data >> 3) & 7;
		}

		/* Channel 3 has 4 separate frequencyłȂΉ܂B */
		if(!ym2612->ch3_mode) {
			return;
		}

		/* `l3AIy[^1..3I܂B(2..4ł͂Ȃ!!̃RgQ) */
		i_ch = 2;
		ch = &ym2612->ch[i_part][i_ch];
		switch(i_reg & 3) { /* WX^тϑIł (̃RgQ) */
		case 0:       i_op = 2; break; /* 0xa8, 0xac = Ch3 Op3 */
		case 1:       i_op = 0; break; /* 0xa9, 0xad = Ch3 Op1 */
		default/*2*/: i_op = 1; break; /* 0xaa, 0xae = Ch3 Op2 */
		}
		op = &ch->op[i_op];

		/* x߂܂B */
		f_number = ym2612->ch3_f_number_lsb[i_reg & 3] | (ym2612->ch3_f_number_msb[i_reg & 3] << 8);
		block    = ym2612->ch3_block[i_reg & 3];
		pg_spd   = (ym2612->f_sam * (f_number << 3)) / ((SPEAKER_FREQUENCY >> 7) << (7 - block));

		/* }`vKpAxݒ肵܂B */
		if(op->mul) {
			op->pg_spd = pg_spd * op->mul;
		} else {
			op->pg_spd = pg_spd / 2;
		}

		break;

	case 0xb0 >> 2: /* Feedback, Algorithm */

		/* ASYɉ~LVO֐ݒ肵܂B */
		ch->mix = ym2612ch_mix_table[data & 7];

		/* tB[hobNݒ肵܂B */
		ch->fb = (data >> 3) & 7;

		break;

	case 0xb4 >> 2: /* L, R, AMS, FMS */

		/* pݒ肵܂B */
		ch->lr = (data >> 6) & 3;

		break;
	}
}

void
ym2612_mix(YM2612* ym2612, short wbuff[/*count*/], int count)
{
#define MIXBUFLEN 64 /*  */

	static int mixbuf[MIXBUFLEN];
	//
	int dac;
	int dac_en;
	int len;
	int n;
	int* p;
	YM2612CH* ch;

	/* DAC enADAC擾܂B */
	dac_en = ym2612->dac_en;
	if(dac_en) {
		dac = ym2612->dac; /* i[ɃXP[Oς */
	} else {
		dac = 0;
	}

	/* cTvȂȂ܂... */
	while(count > 0) {

		/* cTvMIXBUFLENɕ܂B */
		len = count;
		if(len > MIXBUFLEN) {
			len = MIXBUFLEN;
		}
		count -= len;

		/* ~LVOobt@0܂DACo͒lŃNA܂B */
		n = len;
		p = mixbuf;
		do {
			*p++ = dac;
		} while(--n);

		/* ~LVOs܂B */
		/* * LȐȂƂOnȂ΃~LVOs܂B
		 *   ЕOnłOnł{[ɈႢ͂܂B
		 */
		ch = &ym2612->ch[0][0];
		if(ch->lr) ch->mix(ch, mixbuf, len);	/* Ch1 */
		ch++;
		if(ch->lr) ch->mix(ch, mixbuf, len);	/* Ch2 */
		ch++;
		if(ch->lr) ch->mix(ch, mixbuf, len);	/* Ch3 */
		ch++;
		if(ch->lr) ch->mix(ch, mixbuf, len);	/* Ch4 */
		ch++;
		if(ch->lr) ch->mix(ch, mixbuf, len);	/* Ch5 */
		ch++;
		if(!dac_en) {				/* Ch6 */
			if(ch->lr) ch->mix(ch, mixbuf, len);
		}

		/* ~LVOobt@o̓obt@ցB */
		wbuff = ym2612_copy(wbuff, mixbuf, len);
	}

#undef MIXBUFLEN
}

