
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.code
	.align	2
jpeg_decoder_ecs_zigzag_offset:
	.byte	2
	.byte	16
	.byte	32
	.byte	18
	.byte	4
	.byte	6
	.byte	20
	.byte	34
	.byte	48
	.byte	64
	.byte	50
	.byte	36
	.byte	22
	.byte	8
	.byte	10
	.byte	24
	.byte	38
	.byte	52
	.byte	66
	.byte	80
	.byte	96
	.byte	82
	.byte	68
	.byte	54
	.byte	40
	.byte	26
	.byte	12
	.byte	14
	.byte	28
	.byte	42
	.byte	56
	.byte	70
	.byte	84
	.byte	98
	.byte	112
	.byte	114
	.byte	100
	.byte	86
	.byte	72
	.byte	58
	.byte	44
	.byte	30
	.byte	46
	.byte	60
	.byte	74
	.byte	88
	.byte	102
	.byte	116
	.byte	118
	.byte	104
	.byte	90
	.byte	76
	.byte	62
	.byte	78
	.byte	92
	.byte	106
	.byte	120
	.byte	122
	.byte	108
	.byte	94
	.byte	110
	.byte	124
	.byte	126
; APP

		.code
		.align	1
jpeg_decoder_get_byte:
		ld.w		%r13, [%r12]				;// %r13 := data_ptr = self->data_ptr
		ld.ub		%r10, [%r13]+				;// %r10 := c = *data_ptr++
		ld.w		[%r12], %r13				;// self->data_ptr = data_ptr
		ret


		.code
		.align	1
jpeg_decoder_get_half:
		ld.w		%r13, [%r12]				;// %r13 := data_ptr = self->data_ptr
		ld.ub		%r10, [%r13]+				;// %r10 := hi = *data_ptr++
		ld.ub		%r11, [%r13]+				;// %r10 := lo = *data_ptr++
		ld.w		[%r12], %r13				;// self->data_ptr = data_ptr
		sla		%r10, 8					;// %r10 := hi << 8
		ret.d
		or		%r10, %r11				;// %r10 := hi << 8 | lo					*delay*


		.code
		.align	1
jpeg_decoder_ecs_get_bit:
		ld.w		%r13, [%r12]+				;// %r13 := data_ptr    = self->data_ptr
		ld.h		%r14, [%r12]				;// %r14 := ecs_bit_pos = self->ecs_bit_pos
		ld.b		%r15, [%r13]+				;// %r15 := c = (char)*data_ptr++
		rl		%r15, %r14				;// %r15 := c = ???????? ???????? ???????? b??????? (b = bit)
		add		%r14, 1					;// %r14 :=                  ecs_bit_pos + 1
		and		%r14, 7					;// %r14 :=                 (ecs_bit_pos + 1) & 7
		ld.h		[%r12], %r14				;//     self->ecs_bit_pos = (ecs_bit_pos + 1) & 7
		jrne.d		jpeg_decoder_ecs_get_bit_RET		;// if(!self->ecs_bit_pos) {
		mirror		%r10, %r15				;// %r10 :=     ???????? ???????? ???????? ???????b (b = bit)	*delay*
		add		%r15, 1					;//   %psr(C) := (c == -1) ? 1 : 0
		adc		%r13, %r8				;//   %r13 := data_ptr + %psr(C)
		sub		%r12, 4					;//   %r12 := self
		ld.w		[%r12], %r13				;//   self->data_ptr = data_ptr
jpeg_decoder_ecs_get_bit_RET:						;// }
		ret.d
		and		%r10, 1					;// %r10 :=     00000000 00000000 00000000 0000000b (b = bit)	*delay*


		.code
		.align	1
jpeg_decoder_ecs_get_bits:
		cmp		%r13, 0					;// if(bits) {
		jreq		jpeg_decoder_ecs_get_bits_RET		;//
		pushn		%r2					;//
		ld.w		%r0, %r12				;//   %r0  := self
		call.d		jpeg_decoder_ecs_get_bit		;//   %r10 := v = jpeg_decoder_ecs_get_bit(self)
		ld.w		%r1, %r13				;//   %r1  := bits						*delay*
		sub		%r10, 1					;//   %r10 := v = (1 -> 0     ) or (0 -> -1      )
		xor		%r10, 1					;//   %r10 := v = (1 -> 0 -> 1) or (0 -> -1 -> -2)
		sub		%r1, 1					;//   %r1  := bits--
		jreq.d		jpeg_decoder_ecs_get_bits_L2		;//   if(bits) {
		ld.w		%r2, %r10				;//   %r2  := v							*delay*
jpeg_decoder_ecs_get_bits_L1:						;//     do {
		call.d		jpeg_decoder_ecs_get_bit		;//       %r10 := tmp = jpeg_decoder_ecs_get_bit(self)
		ld.w		%r12, %r0				;//       %r12 := self						*delay*
		sla		%r2, 1					;//       %r2  := v <<= 1
		sub		%r1, 1					;//       %r1  := bits--
		jrne.d		jpeg_decoder_ecs_get_bits_L1		;//     } while(bits)
		or		%r2, %r10				;//       %r2  := v |= tmp					*delay*
jpeg_decoder_ecs_get_bits_L2:						;//   }
		ld.w		%r13, %r2				;//   %r13 := v
		add		%r2, %r2				;//   %psr(C) := (v < 0) ? 1 : 0
		adc		%r13, %r8				;//   %r13 := v += %psr(C)
		popn		%r2					;//
jpeg_decoder_ecs_get_bits_RET:						;// }
		ret.d							;//
		ld.w		%r10, %r13				;// %r10 := v							*delay*


		.code
		.align	1
jpeg_decoder_ecs_decode_huffman:
		pushn		%r3
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4
	ld.w	[%sp+0x0],%r12	; 		xld.w		[%sp], %r12				;// [%sp] := self
		ld.w		%r0, %r13				;// %r0   := Li
	ext	0x10		; 		xadd		%r1, %r13, 16				;// %r1   := Vij
	add	%r1,%r13
		ld.w		%r2, 0					;// %r2   := code
		ld.w		%r3, 0					;// %r3   := code_min
jpeg_decoder_ecs_decode_huffman_L1:					;// for(;;) {
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp]				;//   %r12  := self
		call.d		jpeg_decoder_ecs_get_bit		;//   %r10  :=                    jpeg_decoder_ecs_get_bit(self)
		sla		%r2, 1					;//   %r2   :=        code << 1					*delay
		or		%r2, %r10				;//   %r12  := code = code << 1 | jpeg_decoder_ecs_get_bit(self)
		ld.ub		%r4, [%r0]+				;//   %r4   := code_num = *Li++
		add		%r3, %r4				;//   %r3   := code_max = code_min + code_num
		cmp		%r2, %r3				;//   if(code < code_max)
		jrlt.d		jpeg_decoder_ecs_decode_huffman_RET	;//     break
		add		%r1, %r4				;//   %r1   := Vij += code_num					*delay*
		jp.d		jpeg_decoder_ecs_decode_huffman_L1	;//
		sla		%r3, 1					;//   %r3   := code_min = code_max << 1				*delay*
jpeg_decoder_ecs_decode_huffman_RET:					;// }
		add		%r1, %r2				;// %r1  :=                         &Vij[code + code_num           ]
		sub		%r1, %r3				;// %r1  := &Vij[code - code_min] = &Vij[code + code_num - code_max]
		ld.ub		%r10, [%r1]				;// %r10 :=  Vij[code - code_min]
	add	%sp,0x1		; 		xadd		%sp, %sp, 4
		popn		%r3
		ret


		.code
		.align	1
jpeg_decoder_ecs_decode_block:
		;// %r12    := self
		;// %r13    := Li_dc
		;// %r14    := dc
		;// %r15    := Qk
		;// [%sp+0] := retp
		;// [%sp+4] := Li_ac
		;// [%sp+8] := block
		pushn		%r3
		ld.w		%r0, %r14				;// %r0  := dc
		ld.h		%r1, [%r0]				;// %r1  := *dc
		ld.w		%r2, %r15				;// %r2  := Qk
		;//-----------------------------------------------------;
		;// %r0      := dc
		;// %r1      := *dc
		;// %r2      := Qk
		;// %r12     := self
		;// %r13     := Li_dc
		;// [%sp+0]  := %r1
		;// [%sp+4]  := %r2
		;// [%sp+8]  := %r2
		;// [%sp+12] := %r2
		;// [%sp+16] := retp
		;// [%sp+20] := Li_ac
		;// [%sp+24] := block
		call.d		jpeg_decoder_ecs_decode_huffman		;// %r10 := ssss = jpeg_decoder_ecs_decode_huffman(self, Li_dc)
		ld.w		%r3, %r12				;// %r3  :=                                        self			*delay*
		ld.w		%r13, %r10				;// %r13 :=                                        ssss
		call.d		jpeg_decoder_ecs_get_bits		;// %r10 := diff = jpeg_decoder_ecs_get_bits(self, ssss)
		ld.w		%r12, %r3				;// %r12 :=                                  self			*delay*
		add		%r10, %r1				;// %r10 := *dc + diff
		ld.h		[%r0], %r10				;// *dc  := *dc + diff
		;// %r2  := Qk
		;// %r3  := self
		;// %r10 := *dc + diff
	ld.w	%r4,[%sp+0x6]	; 		xld.w		%r4, [%sp+0x18]				;// %r4  := block
		ld.ub		%r5, [%r2]+				;// %r5  :=                            *Qk++
		mlt.h		%r5, %r10				;// %alr :=             (*dc + diff) * *Qk++
		ld.w		%r5, %alr				;// %r5  :=             (*dc + diff) * *Qk++
		ld.h		[%r4], %r5				;//         block[0] := (*dc + diff) * *Qk++
		;//-----------------------------------------------------;
	ext	0x0		; 		xld.w		%r0, 63					;// %r0  := i = (64 - 1/*DC*/)
	ld.w	%r0,0x3f
	ext	jpeg_decoder_ecs_zigzag_offset+0x0@h	; 		xld.w		%r1, jpeg_decoder_ecs_zigzag_offset	;// %r1  := z = jpeg_decoder_ecs_zigzag_offset
	ext	jpeg_decoder_ecs_zigzag_offset+0x0@m
	ld.w	%r1,jpeg_decoder_ecs_zigzag_offset+0x0@l
jpeg_decoder_ecs_decode_block_L1:					;// do {
		;// %r0  := i
		;// %r1  := z
		;// %r2  := Qk
		;// %r3  := self
	ld.w	%r13,[%sp+0x5]	; 		xld.w		%r13, [%sp+0x14]				;//   %r13 :=                                                  Li_ac
		call.d		jpeg_decoder_ecs_decode_huffman		;//   %r10 := rrrrssss = jpeg_decoder_ecs_decode_huffman(self, Li_ac)
		ld.w		%r12, %r3				;//   %r12 :=                                            self		*delay*
		cmp		%r10, 0					;//   if(!rrrrssss)
		jreq		jpeg_decoder_ecs_decode_block_L2	;//     break
	ext	0xf		; 		xand		%r13, %r10, 15				;//   %r13 := ssss = rrrrssss & 15
	and	%r13,%r10
		sra		%r10, 4					;//   %r10 := rrrr = rrrrssss >> 4
		sub		%r0, %r10				;//   %r0  := i  -= rrrr
		add		%r1, %r10				;//   %r1  := z  += rrrr
		add		%r2, %r10				;//   %r2  := Qk += rrrr
		call.d		jpeg_decoder_ecs_get_bits		;//   %r10 := ac = jpeg_decoder_ecs_get_bits(self, ssss)
		ld.w		%r12, %r3				;//   %r12 :=                                self			*delay*
		;// %r0  := i
		;// %r1  := z
		;// %r2  := Qk
		;// %r3  := self
		;// %r10 := ac
	ld.w	%r4,[%sp+0x6]	; 		xld.w		%r4, [%sp+0x18]				;//   %r4  :=  block
		ld.ub		%r5, [%r1]+				;//   %r5  :=        *z++
		add		%r4, %r5				;//   %r4  := &block[*z++]
		ld.ub		%r5, [%r2]+				;//   %r5  :=                     *Qk++
		mlt.h		%r5, %r10				;//   %alr :=                ac * *Qk++
		ld.w		%r5, %alr				;//   %r5  :=                ac * *Qk++
		ld.h		[%r4], %r5				;//            block[*z++] = ac * *Qk++
		;// %r0  := i
		;// %r1  := z
		;// %r2  := Qk
		;// %r3  := self
		sub		%r0, 1					;//   %r0  := i--
		jrne		jpeg_decoder_ecs_decode_block_L1	;// } while(i)
jpeg_decoder_ecs_decode_block_L2:
		;//-----------------------------------------------------;
		popn		%r3
		ret


		.code
		.align	1
jpeg_decoder_ecs_draw_block:
		;// %r12     := draw_proc
		;// %r13     := user_data
		;// %r14     := sof_X
		;// %r15     := sof_Y
		;// [%sp+0]  := retp
		;// [%sp+4]  := org_x
		;// [%sp+8]  := org_y
		;// [%sp+12] := mag_x
		;// [%sp+16] := mag_y
		;// [%sp+20] := block
		pushn		%r3
	sub	%sp,0x6		; 		xsub		%sp, %sp, 24
	ld.w	[%sp+0x2],%r12	; 		xld.w		[%sp+0x8], %r12				;// [%sp+8]  := draw_proc
	ld.w	[%sp+0x3],%r13	; 		xld.w		[%sp+0xc], %r13				;// [%sp+12] := user_data
	ld.w	[%sp+0x4],%r14	; 		xld.w		[%sp+0x10], %r14				;// [%sp+16] := sof_X
	ld.w	[%sp+0x5],%r15	; 		xld.w		[%sp+0x14], %r15				;// [%sp+20] := sof_Y
		;//-----------------------------------------------------;
		;// [%sp+8]  := draw_proc
		;// [%sp+12] := user_data
		;// [%sp+16] := sof_X
		;// [%sp+20] := sof_Y
		;// [%sp+24] := %r2
		;// [%sp+28] := %r3
		;// [%sp+32] := %r0
		;// [%sp+36] := %r1
		;// [%sp+40] := retp
		;// [%sp+44] := org_x
		;// [%sp+48] := org_y
		;// [%sp+52] := mag_x
		;// [%sp+56] := mag_y
		;// [%sp+60] := block
	ld.w	%r15,[%sp+0xf]	; 		xld.w		%r15, [%sp+0x3c]				;// %r15 := block
	ld.w	%r13,[%sp+0xc]	; 		xld.w		%r13, [%sp+0x30]				;// %r13 := y = org_y
		ld.w		%r1, 8					;// %r1  := src_y = 8
jpeg_decoder_ecs_draw_block_SRC_Y:					;// do {
		;//-----------------------------------------------------;
		;// %r1  := src_y
		;// %r13 := y
		;// %r15 := block
	ld.w	%r12,[%sp+0xb]	; 		xld.w		%r12, [%sp+0x2c]				;//   %r12 := x = org_x
		ld.w		%r0, 8					;//   %r0  := src_x = 8
jpeg_decoder_ecs_draw_block_SRC_X:					;//   do {
		;//-----------------------------------------------------;
		;// %r0  := src_x
		;// %r1  := src_y
		;// %r12 := x
		;// %r13 := y
		;// %r15 := block
		ld.h		%r14, [%r15]+				;//     %r14 := c = [127 .. -128]
	ext	0x1		; 		xsub		%r14, %r14, 127				;//     %r14 := c = [  0 .. -255]
	sub	%r14,0x3f
		jrle		2					;//     if(c > 0)
		 ld.w		%r14, 0					;//       %r14 := c = 0
	ext	0x3		; 		xadd		%r14, %r14, 255				;//     %r14 := c = [255 ..    0]
	add	%r14,0x3f
		jrge		2					;//     if(c < 0)
		 ld.w		%r14, 0					;//       %r14 := c = 0
	ld.w	%r3,[%sp+0xe]	; 		xld.w		%r3, [%sp+0x38]				;//     %r3  := dst_y = mag_y
jpeg_decoder_ecs_draw_block_DST_Y:					;//     do {
		;//-----------------------------------------------------;
		;// %r0  := src_x
		;// %r1  := src_y
		;// %r3  := dst_y
		;// %r12 := x
		;// %r13 := y
		;// %r14 := c
		;// %r15 := block
	ld.w	%r2,[%sp+0xd]	; 		xld.w		%r2, [%sp+0x34]				;//       %r2  := dst_x = mag_x
jpeg_decoder_ecs_draw_block_DST_X:					;//       do {
		;//-----------------------------------------------------;
		;// %r0  := src_x
		;// %r1  := src_y
		;// %r2  := dst_x
		;// %r3  := dst_y
		;// %r12 := x
		;// %r13 := y
		;// %r14 := c
		;// %r15 := block
	ld.w	%r10,[%sp+0x4]	; 		xld.w		%r10, [%sp+0x10]				;//         %r10 := sof_X
	ld.w	%r11,[%sp+0x5]	; 		xld.w		%r11, [%sp+0x14]				;//         %r11 := sof_Y
		cmp		%r12, %r10				;//         if((x < sof_X) &&
		jrge		jpeg_decoder_ecs_draw_block_SKIP
		cmp		%r13, %r11				;//            (y < sof_Y)) {
		jrge		jpeg_decoder_ecs_draw_block_SKIP
	ld.w	[%sp+0x0],%r12	; 		xld.w		[%sp+0x0], %r12				;//           [%sp+0]  := x
	ld.w	[%sp+0x1],%r13	; 		xld.w		[%sp+0x4], %r13				;//           [%sp+4]  := y
	ld.w	[%sp+0xf],%r15	; 		xld.w		[%sp+0x3c], %r15				;//           [%sp+60] := block
	ld.w	%r9,[%sp+0x2]	; 		xld.w		%r9, [%sp+0x8]				;//           %r9  := draw_proc
	ld.w	%r15,[%sp+0x3]	; 		xld.w		%r15, [%sp+0xc]				;//           %r15 := user_data
		call		%r9					;//           draw_proc(x, y, c, user_data)
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp+0x0]				;//           %r12 := x
	ld.w	%r13,[%sp+0x1]	; 		xld.w		%r13, [%sp+0x4]				;//           %r13 := y
	ld.w	%r15,[%sp+0xf]	; 		xld.w		%r15, [%sp+0x3c]				;//           %r15 := block
jpeg_decoder_ecs_draw_block_SKIP:					;//         }
		;//-----------------------------------------------------;
		;// %r0  := src_x
		;// %r1  := src_y
		;// %r2  := dst_x
		;// %r3  := dst_y
		;// %r12 := x
		;// %r13 := y
		;// %r15 := block
		sub		%r2, 1					;//         %r2  := dst_x--
		jrne.d		jpeg_decoder_ecs_draw_block_DST_X	;//       } while(dst_x)
		add		%r12, 1					;//         %r12 := x++				*delay*
		;//-----------------------------------------------------;
		;// %r0  := src_x
		;// %r1  := src_y
		;// %r2  := dst_x
		;// %r3  := dst_y
		;// %r12 := x
		;// %r13 := y
		;// %r15 := block
	ld.w	%r10,[%sp+0xd]	; 		xld.w		%r10, [%sp+0x34]				;//       %r10 := mag_x
		add		%r13, 1					;//       %r13 := y++
		sub		%r3, 1					;//       %r3  := dst_y--
		jrne.d		jpeg_decoder_ecs_draw_block_DST_Y	;//     } while(dst_y)
		sub		%r12, %r10				;//       %r12 := x -= mag_x			*delay*
		;//-----------------------------------------------------;
		;// %r0  := src_x
		;// %r1  := src_y
		;// %r2  := dst_x
		;// %r3  := dst_y
		;// %r10 := mag_x
		;// %r12 := x
		;// %r13 := y
		;// %r15 := block
	ld.w	%r11,[%sp+0xe]	; 		xld.w		%r11, [%sp+0x38]				;//     %r11 := mag_y
		add		%r12, %r10				;//     %r12 := x += mag_x
		sub		%r0, 1					;//     %r0  := src_x--
		jrne.d		jpeg_decoder_ecs_draw_block_SRC_X	;//   } while(src_x)
		sub		%r13, %r11				;//     %r13  := y -= mag_y			*delay*
		;//-----------------------------------------------------;
		;// %r0  := src_x
		;// %r1  := src_y
		;// %r2  := dst_x
		;// %r3  := dst_y
		;// %r11 := mag_y
		;// %r12 := x
		;// %r13 := y
		;// %r15 := block
		sub		%r1, 1					;//   %r1  := src_y--
		jrne.d		jpeg_decoder_ecs_draw_block_SRC_Y	;// } while(src_y)
		add		%r13, %r11				;//   %r13 := y += mag_y			*delay*
		;//-----------------------------------------------------;
	add	%sp,0x6		; 		xadd		%sp, %sp, 24
		popn		%r3
		ret

	.align	2
__LC0:
	.half	0
	.half	0
	.half	0
	.align	2
__LC1:
	.ascii	"clipjpeg.$\000"
; NO_APP
	.code
	.align	1
jpeg_decoder_ecs_decode:
;	.frame	%sp,240,$31		# vars= 200, regs= 5/0, args= 20, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x37	; 	xsub	%sp,%sp,220
	ld.w	%r1,%r12
	ext	0x8		; 	xld.h	%r12,[%r1+0x8]
	ld.h	%r12,[%r1]
	add	%r12,0x7	; 	xadd	%r12,%r12,7
	sra	%r12,0x3	; 	xsra	%r12,3
	sub	%r12,0x1	; 	xsub	%r12,%r12,1
	ext	0x18		; 	xld.h	%r13,[%r1+0x18]
	ld.h	%r13,[%r1]
	add	%r12,%r13
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	[%sp+0x27],%r10	; 	xld.w	[%sp+0x9c],%r10
	ext	0x6		; 	xld.h	%r12,[%r1+0x6]
	ld.h	%r12,[%r1]
	add	%r12,0x7	; 	xadd	%r12,%r12,7
	sra	%r12,0x3	; 	xsra	%r12,3
	sub	%r12,0x1	; 	xsub	%r12,%r12,1
	ext	0x20		; 	xld.h	%r13,[%r1+0x20]
	ld.h	%r13,[%r1]
	add	%r12,%r13
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	[%sp+0x28],%r10	; 	xld.w	[%sp+0xa0],%r10
	ld.w	%r5,0x0
	ld.w	[%sp+0x2a],%r5	; 	xld.w	[%sp+0xa8],%r5
	ld.w	%r6,[%sp+0x2a]	; 	xld.w	%r6,[%sp+0xa8]
	ld.w	[%sp+0x2d],%r6	; 	xld.w	[%sp+0xb4],%r6
	ld.w	%r5,[%sp+0x2a]	; 	xld.w	%r5,[%sp+0xa8]
	ld.w	[%sp+0x2e],%r5	; 	xld.w	[%sp+0xb8],%r5
	ext	0x3ff		; 	xld.w	%r6,0x0000ffd0		; 65488
	ld.w	%r6,0x10
	ld.w	[%sp+0x2f],%r6	; 	xld.w	[%sp+0xbc],%r6
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,20
	add	%r12,0x14
	ext	__LC0+0x0@h	; 	xld.w	%r13,__LC0
	ext	__LC0+0x0@m
	ld.w	%r13,__LC0+0x0@l
	ld.w	%r14,0x6	; 	xld.w	%r14,0x00000006		; 6
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0xa		; 	xld.h	%r10,[%r1+0xa]
	ld.h	%r10,[%r1]
	ext	0x60		; 	xld.w	%r0,[%r1+0x60]
	ld.w	%r0,[%r1]
	cmp	%r0,%r10
	jrge	__LX71		; 	xjrge	__L71
	ext	0x18		; 	xld.h	%r12,[%r1+0x18]
	ld.h	%r12,[%r1]
	sll	%r0,0x1		; 	xsll	%r0,1
	add	%r0,%r1
	ext	0x12		; 	xld.h	%r13,[%r0+0x12]
	ld.h	%r13,[%r0]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	[%sp+0x2d],%r10	; 	xld.w	[%sp+0xb4],%r10
	ext	0x20		; 	xld.h	%r12,[%r1+0x20]
	ld.h	%r12,[%r1]
	ext	0x1a		; 	xld.h	%r13,[%r0+0x1a]
	ld.h	%r13,[%r0]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	[%sp+0x2e],%r10	; 	xld.w	[%sp+0xb8],%r10
__LX71:				; __L71:
	ld.w	%r5,[%sp+0x2a]	; 	xld.w	%r5,[%sp+0xa8]
	ld.w	[%sp+0x2b],%r5	; 	xld.w	[%sp+0xac],%r5
	ld.w	%r6,[%sp+0x2a]	; 	xld.w	%r6,[%sp+0xa8]
	ld.w	[%sp+0x2c],%r6	; 	xld.w	[%sp+0xb0],%r6
	ld.w	%r5,%sp		; 	xadd	%r5,%sp,28
	add	%r5,0x1c
	ld.w	[%sp+0x30],%r5	; 	xld.w	[%sp+0xc0],%r5
__LX72:				; __L72:
	ld.w	%r6,0x0
	ld.w	[%sp+0x29],%r6	; 	xld.w	[%sp+0xa4],%r6
	ld.w	%r3,[%sp+0x29]	; 	xld.w	%r3,[%sp+0xa4]
	ld.w	%r4,%r1
	ld.w	[%sp+0x34],%r1	; 	xld.w	[%sp+0xd0],%r1
	ld.w	%r5,[%sp+0x29]	; 	xld.w	%r5,[%sp+0xa4]
	ld.w	[%sp+0x35],%r5	; 	xld.w	[%sp+0xd4],%r5
__LX75:				; __L75:
	ld.w	%r6,[%sp+0x34]	; 	xld.w	%r6,[%sp+0xd0]
	ext	0xc		; 	xld.h	%r11,[%r6+0xc]
	ld.h	%r11,[%r6]
	ext	0x2a		; 	xld.h	%r10,[%r4+0x2a]
	ld.h	%r10,[%r4]
	cmp	%r11,%r10
	jreq	__LX79		; 	xjreq	__L79
	ld.w	%r13,%r4
	ld.w	%r10,%r3
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r12,%r10
	add	%r12,%r1
__LX80:				; __L80:
	add	%r12,0x2	; 	xadd	%r12,%r12,2
	ld.w	%r5,[%sp+0x34]	; 	xld.w	%r5,[%sp+0xd0]
	add	%r5,0x2		; 	xadd	%r5,%r5,2
	ld.w	[%sp+0x34],%r5	; 	xld.w	[%sp+0xd0],%r5
	ld.w	%r6,[%sp+0x35]	; 	xld.w	%r6,[%sp+0xd4]
	add	%r6,0x2		; 	xadd	%r6,%r6,2
	ld.w	[%sp+0x35],%r6	; 	xld.w	[%sp+0xd4],%r6
	add	%r3,0x1		; 	xadd	%r3,%r3,1
	ext	0xa		; 	xld.h	%r10,[%r1+0xa]
	ld.h	%r10,[%r1]
	cmp	%r3,%r10
	jrne	__LX78		; 	xjrne	__L78
	ext	__LC1+0x0@h	; 	xld.w	%r12,__LC1
	ext	__LC1+0x0@m
	ld.w	%r12,__LC1+0x0@l
	ext	0xa		; 	xld.w	%r13,0x00000295		; 661
	ld.w	%r13,0x15
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX78:				; __L78:
	ext	0xc		; 	xld.h	%r11,[%r12+0xc]
	ld.h	%r11,[%r12]
	ext	0x2a		; 	xld.h	%r10,[%r13+0x2a]
	ld.h	%r10,[%r13]
	cmp	%r11,%r10
	jrne	__LX80		; 	xjrne	__L80
__LX79:				; __L79:
	ld.w	%r2,0x0
	ld.w	%r0,%r2
	ld.w	[%sp+0x31],%r4	; 	xld.w	[%sp+0xc4],%r4
	ld.w	%r5,[%sp+0x35]	; 	xld.w	%r5,[%sp+0xd4]
	ld.w	[%sp+0x32],%r5	; 	xld.w	[%sp+0xc8],%r5
	ld.w	%r6,[%sp+0x34]	; 	xld.w	%r6,[%sp+0xd0]
	ld.w	[%sp+0x33],%r6	; 	xld.w	[%sp+0xcc],%r6
__LX83:				; __L83:
	ld.w	%r12,[%sp+0x30]	; 	xld.w	%r12,[%sp+0xc0]
	ld.w	%r13,0x0
	ext	0x2		; 	xld.w	%r14,0x00000080		; 128
	ld.w	%r14,0x0
	ld.w	[%sp+0x36],%r4	; 	xld.w	[%sp+0xd8],%r4
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r5,[%sp+0x31]	; 	xld.w	%r5,[%sp+0xc4]
	ext	0x30		; 	xld.h	%r13,[%r5+0x30]
	ld.h	%r13,[%r5]
	sll	%r13,0x2	; 	xsll	%r13,2
	add	%r13,%r1
	ld.w	%r14,%sp	; 	xadd	%r14,%sp,20
	add	%r14,0x14
	ld.w	%r6,[%sp+0x33]	; 	xld.w	%r6,[%sp+0xcc]
	ext	0x22		; 	xld.h	%r11,[%r6+0x22]
	ld.h	%r11,[%r6]
	sll	%r11,0x2	; 	xsll	%r11,2
	add	%r11,%r1
	ext	0x36		; 	xld.h	%r10,[%r5+0x36]
	ld.h	%r10,[%r5]
	sll	%r10,0x2	; 	xsll	%r10,2
	add	%r10,%r1
	ext	0x58		; 	xld.w	%r10,[%r10+0x58]
	ld.w	%r10,[%r10]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	%r5,[%sp+0x30]	; 	xld.w	%r5,[%sp+0xc0]
	ld.w	[%sp+0x1],%r5	; 	xld.w	[%sp+0x4],%r5
	ld.w	%r12,%r1
	ext	0x50		; 	xld.w	%r13,[%r13+0x50]
	ld.w	%r13,[%r13]
	ld.w	%r6,[%sp+0x32]	; 	xld.w	%r6,[%sp+0xc8]
	add	%r14,%r6
	ext	0x40		; 	xld.w	%r15,[%r11+0x40]
	ld.w	%r15,[%r11]
	ext	jpeg_decoder_ecs_decode_block@rm	; 	xcall	jpeg_decoder_ecs_decode_block
	call	jpeg_decoder_ecs_decode_block@rl
	ext	0x60		; 	xld.w	%r10,[%r1+0x60]
	ld.w	%r10,[%r1]
	ld.w	%r4,[%sp+0x36]	; 	xld.w	%r4,[%sp+0xd8]
	cmp	%r3,%r10
	jrne	__LX86		; 	xjrne	__L86
	ext	0x68		; 	xld.w	%r10,[%r1+0x68]
	ld.w	%r10,[%r1]
	cmp	%r10,0x0
	jreq	__LX86		; 	xjreq	__L86
	ld.w	%r12,[%sp+0x30]	; 	xld.w	%r12,[%sp+0xc0]
	ld.w	%r13,[%sp+0x30]	; 	xld.w	%r13,[%sp+0xc0]
	ld.w	[%sp+0x36],%r4	; 	xld.w	[%sp+0xd8],%r4
	ext	idct8x8half@rm	; 	xcall	idct8x8half
	call	idct8x8half@rl
	ext	0x68		; 	xld.w	%r12,[%r1+0x68]
	ld.w	%r12,[%r1]
	ext	0x6c		; 	xld.w	%r13,[%r1+0x6c]
	ld.w	%r13,[%r1]
	ext	0x8		; 	xld.h	%r14,[%r1+0x8]
	ld.h	%r14,[%r1]
	ext	0x6		; 	xld.h	%r15,[%r1+0x6]
	ld.h	%r15,[%r1]
	ext	0x18		; 	xld.h	%r10,[%r1+0x18]
	ld.h	%r10,[%r1]
	ld.w	%r5,[%sp+0x2b]	; 	xld.w	%r5,[%sp+0xac]
	mlt.w	%r5,%r10
	ld.w	%r10,%alr
	ld.w	%r5,[%sp+0x2d]	; 	xld.w	%r5,[%sp+0xb4]
	mlt.w	%r0,%r5
	ld.w	%r11,%alr
	add	%r10,%r11
	sll	%r10,0x3	; 	xsll	%r10,3
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ext	0x20		; 	xld.h	%r10,[%r1+0x20]
	ld.h	%r10,[%r1]
	ld.w	%r5,[%sp+0x2c]	; 	xld.w	%r5,[%sp+0xb0]
	mlt.w	%r5,%r10
	ld.w	%r10,%alr
	ld.w	%r5,[%sp+0x2e]	; 	xld.w	%r5,[%sp+0xb8]
	mlt.w	%r2,%r5
	ld.w	%r11,%alr
	add	%r10,%r11
	sll	%r10,0x3	; 	xsll	%r10,3
	ld.w	[%sp+0x1],%r10	; 	xld.w	[%sp+0x4],%r10
	ld.w	%r6,[%sp+0x2d]	; 	xld.w	%r6,[%sp+0xb4]
	ld.w	[%sp+0x2],%r6	; 	xld.w	[%sp+0x8],%r6
	ld.w	[%sp+0x3],%r5	; 	xld.w	[%sp+0xc],%r5
	ld.w	%r5,[%sp+0x30]	; 	xld.w	%r5,[%sp+0xc0]
	ld.w	[%sp+0x4],%r5	; 	xld.w	[%sp+0x10],%r5
	ext	jpeg_decoder_ecs_draw_block@rm	; 	xcall	jpeg_decoder_ecs_draw_block
	call	jpeg_decoder_ecs_draw_block@rl
	ld.w	%r4,[%sp+0x36]	; 	xld.w	%r4,[%sp+0xd8]
__LX86:				; __L86:
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r6,[%sp+0x33]	; 	xld.w	%r6,[%sp+0xcc]
	ext	0x12		; 	xld.h	%r10,[%r6+0x12]
	ld.h	%r10,[%r6]
	cmp	%r0,%r10
	jrne	__LX83		; 	xjrne	__L83
	ld.w	%r0,0x0
	add	%r2,0x1		; 	xadd	%r2,%r2,1
	ext	0x1a		; 	xld.h	%r10,[%r6+0x1a]
	ld.h	%r10,[%r6]
	cmp	%r2,%r10
	jrne	__LX83		; 	xjrne	__L83
	add	%r4,0x2		; 	xadd	%r4,%r4,2
	ld.w	%r5,[%sp+0x29]	; 	xld.w	%r5,[%sp+0xa4]
	add	%r5,0x1		; 	xadd	%r5,%r5,1
	ld.w	[%sp+0x29],%r5	; 	xld.w	[%sp+0xa4],%r5
	ext	0x28		; 	xld.h	%r10,[%r1+0x28]
	ld.h	%r10,[%r1]
	cmp	%r5,%r10
	ext	__LX75@rm	; 	xjrlt	__L75
	jrlt	__LX75@rl
	ld.w	%r6,[%sp+0x2b]	; 	xld.w	%r6,[%sp+0xac]
	add	%r6,0x1		; 	xadd	%r6,%r6,1
	ld.w	[%sp+0x2b],%r6	; 	xld.w	[%sp+0xac],%r6
	ld.w	%r5,[%sp+0x27]	; 	xld.w	%r5,[%sp+0x9c]
	cmp	%r6,%r5
	jrne	__LX90		; 	xjrne	__L90
	ld.w	[%sp+0x2b],%r0	; 	xld.w	[%sp+0xac],%r0
	ld.w	%r6,[%sp+0x2c]	; 	xld.w	%r6,[%sp+0xb0]
	add	%r6,0x1		; 	xadd	%r6,%r6,1
	ld.w	[%sp+0x2c],%r6	; 	xld.w	[%sp+0xb0],%r6
	ld.w	%r5,[%sp+0x28]	; 	xld.w	%r5,[%sp+0xa0]
	cmp	%r6,%r5
	jreq	__LX103		; 	xjreq	__L103
__LX90:				; __L90:
	ld.w	%r6,[%sp+0x2a]	; 	xld.w	%r6,[%sp+0xa8]
	add	%r6,0x1		; 	xadd	%r6,%r6,1
	ld.w	[%sp+0x2a],%r6	; 	xld.w	[%sp+0xa8],%r6
	ext	0x3c		; 	xld.h	%r10,[%r1+0x3c]
	ld.h	%r10,[%r1]
	cmp	%r6,%r10
	ext	__LX72@rm	; 	xjrne	__L72
	jrne	__LX72@rl
	ld.w	[%sp+0x2a],%r0	; 	xld.w	[%sp+0xa8],%r0
	jp	__LX102		; 	xjp	__L102
__LX95:				; __L95:
	ld.w	%r12,%r1
	ext	jpeg_decoder_ecs_get_bit@rm	; 	xcall	jpeg_decoder_ecs_get_bit
	call	jpeg_decoder_ecs_get_bit@rl
__LX102:				; __L102:
	ext	0x4		; 	xld.h	%r10,[%r1+0x4]
	ld.h	%r10,[%r1]
	cmp	%r10,0x0
	jrne	__LX95		; 	xjrne	__L95
	ld.w	%r12,%r1
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ld.w	%r5,[%sp+0x2f]	; 	xld.w	%r5,[%sp+0xbc]
	cmp	%r10,%r5
	jreq	__LX97		; 	xjreq	__L97
	ext	__LC1+0x0@h	; 	xld.w	%r12,__LC1
	ext	__LC1+0x0@m
	ld.w	%r12,__LC1+0x0@l
	ext	0xb		; 	xld.w	%r13,0x000002c4		; 708
	ld.w	%r13,0x4
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX97:				; __L97:
	ld.w	%r10,[%sp+0x2f]	; 	xld.w	%r10,[%sp+0xbc]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%sp+0x2f],%r10	; 	xld.w	[%sp+0xbc],%r10
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,20
	add	%r12,0x14
	ld.w	%r13,0x0
	ld.w	%r14,0x6	; 	xld.w	%r14,0x00000006		; 6
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	__LX72@rm	; 	xjp	__L72
	jp	__LX72@rl
__LX100:				; __L100:
	ld.w	%r12,%r1
	ext	jpeg_decoder_ecs_get_bit@rm	; 	xcall	jpeg_decoder_ecs_get_bit
	call	jpeg_decoder_ecs_get_bit@rl
__LX103:				; __L103:
	ext	0x4		; 	xld.h	%r10,[%r1+0x4]
	ld.h	%r10,[%r1]
	cmp	%r10,0x0
	jrne	__LX100		; 	xjrne	__L100
	add	%sp,0x37	; 	xadd	%sp,%sp,220
	popn	%r3
	ret
	.align	1
jpeg_decoder_decode:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r2,%r12
__LX105:				; __L105:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r0,%r10
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ext	0x3		; 	xcmp	%r0,255
	cmp	%r0,0x3f
	jreq	__LX108		; 	xjreq	__L108
	ext	__LC1+0x0@h	; 	xld.w	%r12,__LC1
	ext	__LC1+0x0@m
	ld.w	%r12,__LC1+0x0@l
	ext	0xb		; 	xld.w	%r13,0x000002d6		; 726
	ld.w	%r13,0x16
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX108:				; __L108:
	ext	0x3		; 	xld.w	%r11,0x000000d9		; 217
	ld.w	%r11,0x19
	cmp	%r10,%r11
	ext	__LX104@rm	; 	xjreq	__L104
	jreq	__LX104@rl
	jrgt	__LX148		; 	xjrgt	__L148
	ext	0x3		; 	xld.w	%r11,0x000000c0		; 192
	ld.w	%r11,0x0
	cmp	%r10,%r11
	jreq	__LX116		; 	xjreq	__L116
	jrgt	__LX149		; 	xjrgt	__L149
	cmp	%r10,0x0
	ext	__LX144@rm	; 	xjreq	__L144
	jreq	__LX144@rl
	ext	__LX146@rm	; 	xjp	__L146
	jp	__LX146@rl
__LX149:				; __L149:
	ext	0x3		; 	xcmp	%r10,196
	cmp	%r10,0x4
	ext	__LX126@rm	; 	xjreq	__L126
	jreq	__LX126@rl
	ext	0x3		; 	xcmp	%r10,216
	cmp	%r10,0x18
	jreq	__LX105		; 	xjreq	__L105
	ext	__LX146@rm	; 	xjp	__L146
	jp	__LX146@rl
__LX148:				; __L148:
	ext	0x3		; 	xld.w	%r11,0x000000db		; 219
	ld.w	%r11,0x1b
	cmp	%r10,%r11
	jreq	__LX111		; 	xjreq	__L111
	ext	__LX137@rm	; 	xjrlt	__L137
	jrlt	__LX137@rl
	ext	0x3		; 	xcmp	%r10,221
	cmp	%r10,0x1d
	ext	__LX136@rm	; 	xjreq	__L136
	jreq	__LX136@rl
	cmp	%r10,%r0
	ext	__LX145@rm	; 	xjreq	__L145
	jreq	__LX145@rl
	ext	__LX146@rm	; 	xjp	__L146
	jp	__LX146@rl
__LX111:				; __L111:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ext	0x2		; 	xsub	%r0,%r10,2
	sub	%r0,%r10
	ext	0x1		; 	xld.w	%r1,0x00000040		; 64
	ld.w	%r1,0x0
__LX112:				; __L112:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	sll	%r10,0x2	; 	xsll	%r10,2
	add	%r10,%r2
	add	%r10,%r1
	ld.w	%r11,[%r2]	; 	xld.w	%r11,[%r2]
	ld.w	[%r10],%r11	; 	xld.w	[%r10],%r11
	ld.w	%r10,[%r2]	; 	xld.w	%r10,[%r2]
	add	%r10,%r1
	ld.w	[%r2],%r10	; 	xld.w	[%r2],%r10
	ext	0x1		; 	xsub	%r0,%r0,65
	sub	%r0,0x1
	jrne	__LX112		; 	xjrne	__L112
	jp	__LX105		; 	xjp	__L105
__LX116:				; __L116:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ext	0x6		; 	xld.h	[%r2+0x6],%r10
	ld.h	[%r2],%r10
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ext	0x8		; 	xld.h	[%r2+0x8],%r10
	ld.h	[%r2],%r10
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ext	0xa		; 	xld.h	[%r2+0xa],%r10
	ld.h	[%r2],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jreq	__LX117		; 	xjreq	__L117
	cmp	%r10,0x3	; 	xcmp	%r10,3
	jreq	__LX117		; 	xjreq	__L117
	ext	__LC1+0x0@h	; 	xld.w	%r12,__LC1
	ext	__LC1+0x0@m
	ld.w	%r12,__LC1+0x0@l
	ext	0xb		; 	xld.w	%r13,0x000002f3		; 755
	ld.w	%r13,0x33
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX117:				; __L117:
	ld.w	%r1,0x0
	ext	0xa		; 	xld.h	%r10,[%r2+0xa]
	ld.h	%r10,[%r2]
	cmp	%r1,%r10
	jrge	__LX119		; 	xjrge	__L119
	ld.w	%r0,%r2
__LX121:				; __L121:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ext	0xc		; 	xld.h	[%r0+0xc],%r10
	ld.h	[%r0],%r10
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r13,%r10
	ld.w	%r12,%r13
	srl	%r12,0x4	; 	xsrl	%r12,4
	ext	0x12		; 	xld.h	[%r0+0x12],%r12
	ld.h	[%r0],%r12
	ld.h	%r11,%r12
	ext	0x18		; 	xld.h	%r10,[%r2+0x18]
	ld.h	%r10,[%r2]
	cmp	%r11,%r10
	jrle	__LX122		; 	xjrle	__L122
	ext	0x18		; 	xld.h	[%r2+0x18],%r12
	ld.h	[%r2],%r12
__LX122:				; __L122:
	ld.w	%r12,%r13
	and	%r12,0xf	; 	xand	%r12,%r12,0x0000000f
	ext	0x1a		; 	xld.h	[%r0+0x1a],%r12
	ld.h	[%r0],%r12
	ld.h	%r11,%r12
	ext	0x20		; 	xld.h	%r10,[%r2+0x20]
	ld.h	%r10,[%r2]
	cmp	%r11,%r10
	jrle	__LX123		; 	xjrle	__L123
	ext	0x20		; 	xld.h	[%r2+0x20],%r12
	ld.h	[%r2],%r12
__LX123:				; __L123:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ext	0x22		; 	xld.h	[%r0+0x22],%r10
	ld.h	[%r0],%r10
	add	%r0,0x2		; 	xadd	%r0,%r0,2
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	ext	0xa		; 	xld.h	%r10,[%r2+0xa]
	ld.h	%r10,[%r2]
	cmp	%r1,%r10
	jrlt	__LX121		; 	xjrlt	__L121
__LX119:				; __L119:
	ext	0x64		; 	xld.w	%r10,[%r2+0x64]
	ld.w	%r10,[%r2]
	cmp	%r10,0x0
	ext	__LX105@rm	; 	xjreq	__L105
	jreq	__LX105@rl
	ext	0x8		; 	xld.h	%r12,[%r2+0x8]
	ld.h	%r12,[%r2]
	ext	0x6		; 	xld.h	%r13,[%r2+0x6]
	ld.h	%r13,[%r2]
	ext	0x6c		; 	xld.w	%r14,[%r2+0x6c]
	ld.w	%r14,[%r2]
	call	%r10
	ext	__LX105@rm	; 	xjp	__L105
	jp	__LX105@rl
__LX126:				; __L126:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ext	0x2		; 	xsub	%r3,%r10,2
	sub	%r3,%r10
__LX127:				; __L127:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r11,%r10
	sra	%r11,0x4	; 	xsra	%r11,4
	sll	%r11,0x3	; 	xsll	%r11,3
	add	%r11,%r2
	ext	0x1		; 	xadd	%r11,%r11,80
	add	%r11,0x10
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	sll	%r10,0x2	; 	xsll	%r10,2
	add	%r10,%r11
	ld.w	%r11,[%r2]	; 	xld.w	%r11,[%r2]
	ld.w	[%r10],%r11	; 	xld.w	[%r10],%r11
	ld.w	%r0,0x0
	ld.w	%r1,%r0
__LX133:				; __L133:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	add	%r0,%r10
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0xf		; 	xcmp	%r1,15
	jrle	__LX133		; 	xjrle	__L133
	ld.w	%r10,[%r2]	; 	xld.w	%r10,[%r2]
	add	%r10,%r0
	ld.w	[%r2],%r10	; 	xld.w	[%r2],%r10
	ext	0x11		; 	xsub	%r10,%r3,17
	sub	%r10,%r3
	ld.w	%r3,%r10
	sub	%r3,%r0
	jrne	__LX127		; 	xjrne	__L127
	ext	__LX105@rm	; 	xjp	__L105
	jp	__LX105@rl
__LX136:				; __L136:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ext	0x3c		; 	xld.h	[%r2+0x3c],%r10
	ld.h	[%r2],%r10
	ext	__LX105@rm	; 	xjp	__L105
	jp	__LX105@rl
__LX137:				; __L137:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ext	0x28		; 	xld.h	[%r2+0x28],%r10
	ld.h	[%r2],%r10
	ld.w	%r1,0x0
	ld.h	%r10,%r10
	cmp	%r1,%r10
	jrge	__LX139		; 	xjrge	__L139
	ld.w	%r0,%r2
__LX141:				; __L141:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ext	0x2a		; 	xld.h	[%r0+0x2a],%r10
	ld.h	[%r0],%r10
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r11,%r10
	sra	%r11,0x4	; 	xsra	%r11,4
	ext	0x30		; 	xld.h	[%r0+0x30],%r11
	ld.h	[%r0],%r11
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	ext	0x36		; 	xld.h	[%r0+0x36],%r10
	ld.h	[%r0],%r10
	add	%r0,0x2		; 	xadd	%r0,%r0,2
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	ext	0x28		; 	xld.h	%r10,[%r2+0x28]
	ld.h	%r10,[%r2]
	cmp	%r1,%r10
	jrlt	__LX141		; 	xjrlt	__L141
__LX139:				; __L139:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_byte@rm	; 	xcall	jpeg_decoder_get_byte
	call	jpeg_decoder_get_byte@rl
	ld.w	%r12,%r2
	ext	jpeg_decoder_ecs_decode@rm	; 	xcall	jpeg_decoder_ecs_decode
	call	jpeg_decoder_ecs_decode@rl
	ext	__LX105@rm	; 	xjp	__L105
	jp	__LX105@rl
__LX144:				; __L144:
	ext	__LC1+0x0@h	; 	xld.w	%r12,__LC1
	ext	__LC1+0x0@m
	ld.w	%r12,__LC1+0x0@l
	ext	0xc		; 	xld.w	%r13,0x00000330		; 816
	ld.w	%r13,0x30
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX145:				; __L145:
	ld.w	%r10,[%r2]	; 	xld.w	%r10,[%r2]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.w	[%r2],%r10	; 	xld.w	[%r2],%r10
	ext	__LX105@rm	; 	xjp	__L105
	jp	__LX105@rl
__LX146:				; __L146:
	ld.w	%r12,%r2
	ext	jpeg_decoder_get_half@rm	; 	xcall	jpeg_decoder_get_half
	call	jpeg_decoder_get_half@rl
	sub	%r10,0x2	; 	xsub	%r10,%r10,2
	ld.w	%r11,[%r2]	; 	xld.w	%r11,[%r2]
	add	%r11,%r10
	ld.w	[%r2],%r11	; 	xld.w	[%r2],%r11
	ext	__LX105@rm	; 	xjp	__L105
	jp	__LX105@rl
__LX104:				; __L104:
	popn	%r3
	ret
	.align	1
	.global	jpeg_decode
jpeg_decode:
;	.frame	%sp,132,$31		# vars= 112, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x1c	; 	xsub	%sp,%sp,112
	ld.w	%r3,%r12
	ld.w	%r0,%r13
	ld.w	%r1,%r14
	ld.w	%r2,%r15
	ld.w	%r12,%sp
	ld.w	%r13,0x0
	ext	0x1		; 	xld.w	%r14,0x00000070		; 112
	ld.w	%r14,0x30
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	[%sp+0x18],%r0	; 	xld.w	[%sp+0x60],%r0
	ld.w	[%sp+0x19],%r1	; 	xld.w	[%sp+0x64],%r1
	ld.w	[%sp+0x1a],%r2	; 	xld.w	[%sp+0x68],%r2
	ld.w	%r11,[%sp+0x22]	; 	xld.w	%r11,[%sp+0x88]
	ld.w	[%sp+0x1b],%r11	; 	xld.w	[%sp+0x6c],%r11
__LX151:				; __L151:
	ld.w	[%sp+0x0],%r3	; 	xld.w	[%sp],%r3
	ld.w	%r12,%sp
	ext	jpeg_decoder_decode@rm	; 	xcall	jpeg_decoder_decode
	call	jpeg_decoder_decode@rl
	ld.w	%r11,[%sp+0x21]	; 	xld.w	%r11,[%sp+0x84]
	cmp	%r11,0x0
	jreq	__LX152		; 	xjreq	__L152
	ld.w	%r12,[%sp+0x0]	; 	xld.w	%r12,[%sp]
	ld.w	%r13,[%sp+0x22]	; 	xld.w	%r13,[%sp+0x88]
	call	%r11
	ld.w	%r3,%r10
	cmp	%r3,0x0
	jrne	__LX151		; 	xjrne	__L151
__LX152:				; __L152:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%sp,0x1c	; 	xadd	%sp,%sp,112
	popn	%r3
	ret
