/*	
 *	clipjpeg.h
 *
 *	JPEG Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Fri Feb 06 22:32:46 JST 2009 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Feb 09 23:11:25 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Jun 07 18:04:03 JST 2009 Naoyuki Sawa
 *	- jpeg_decode()ɁAdata_procǉ܂B
 *	* Thu Sep 03 14:03:54 JST 2009 Naoyuki Sawa
 *	- jpeg_decode()ɁAcomponentǉ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_JPEG_H__
#define __CLIP_JPEG_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	
 ****************************************************************************/

/* JPEGf[^fR[h܂B
 * [in]
 *	data_ptr		JPEGf[^̐擪AhXB
 *	component		draw_procŎ擾R|[lgB(0 = Y, 1 = Cb, 2 = Cr)
 *	size_proc		EʒmR[obNB(NULL)
 *	draw_proc		sNZ`R[obNB(NULL)
 *	data_proc		f[^pR[obNB(NULL) {{2009/06/07:ǉ}}
 *	user_data		Cӂ̃[U[f[^B
 * [out]
 *	߂l			JPEGf[^̏I[AhXB
 *				IɁA[VJPEGɑΉ邽߂̖߂lłB
 *				[VJPEGɂĖ̂߁Aۂɖ𗧂ǂ킩܂B
 * [note]
 *	* fR[h\JPEGf[^́ABaseline DCT`(SOF0)݂̂łB
 *	  Baseline DCT`̎ɂ悭gAProgressive DCT`(SOF2)̓fR[hł܂B
 *	  Progressive DCT`܂߂āǍ`JPEGf[^w肵ꍇ͖̓`łB
 *	* size_procAdraw_proc̗w肵ꍇAKsize_procAdraw_proc̏ɃR[obN܂B
 *	  ]āAsize_procŕEɉWJobt@āAdraw_procŊi[邱Ƃł܂B
 *	  ܂́Adraw_procŒځAʂɕ`sƂł܂B
 *	* ׂẴsNZɑ΂draw_procR[obN邽߁A傫ȉ摜̃fR[hɂ͎Ԃ܂B
 *	  {֐́AfR[hrŒ~@\Ă܂񂪁AsetjmpAlongjmp𗘗pĒ~\łB
 *	  draw_proc̒ŁApcePadGetDirectȂǂgĒ~𔻒fAlongjmpŌĂяo֖߂ĂB
 *	  {֐́AŃ\[XĂsĂ܂̂ŁAlongjmpŒ~Ă\[XR͔܂B
 * [example]
 *	jmp_buf jb;
 *	int width;
 *	int height;
 *	static void my_size_proc(int w, int h, void* user_data) {
 *		width = w;
 *		height = h;
 *	}
 *	static void my_draw_proc(int x, int y, int c, void* user_data) {
 *		render_point(&render, x, y, (c >> 4) ^ 15);
 *		if(pcePadGetDirect()) {
 *			longjmp(jb, 1);
 *		}
 *	}
 *	void example() {
 *		if(!setjmp(jb)) {
 *			jpeg_decode(JPEG_DATA, 0, my_size_proc, my_draw_proc, NULL, NULL);
 *		}
 *		render_printf(&render, 0, 0, 0, 15, "%d x %d", width, height);
 *	}
 * [ǋL]
 *	* Sun Jun 07 16:15:05 JST 2009 Naoyuki Sawa
 *	- data_procǉ܂B
 *	  e[u(DQT,DHT)ƃC[W(SOF0,SOS)Ċi[ꂽf[^́AfR[hɑΉ邽߂łB
 *	- Flash MXȂǂŐAÂSWFt@CJPEGf[^Aȉ̂悤Ɋi[Ă܂B
 *	  - JPEGTables		SOI ` DQT  ` DHT ` EOI
 *	    DefineBits		SOI ` SOF0 ` SOS ` EOI
 *	  - DefineBitsJPEG2(3)	SOI ` DQT  ` DHT ` EOI ` SOI ` SOF0 ` SOS ` EOI
 *	  VFlash(?)ŐSWFt@CJPEGf[^́AʏJPEGt@CƓlɊi[Ă܂B
 *	  - DefineBitsJPEG2(3)	SOI ` DQT  ` DHT ` SOF0 ` SOS ` EOI
 *	- data_proc̎gɂāA܂B
 *	  JPEGTablesDefineBitŝ悤ɁAe[uƃC[WĂ邱Ƃ炩߂킩Ăꍇ́A
 *	  - jpeg_decode()data_ptrɃe[ũAhXnA
 *	  - xڂdata_procR[obNC[W̃AhXԂăf[^pA
 *	  - xڂdata_procR[obNNULLԂĂB
 *	  ÂSWFDefineBitsJPEG2(3)̂悤ɁAAf[^AĂ邩ǂ킩Ȃꍇ́A
 *	  - jpeg_decode()data_ptrɃf[^̐擪AhXnA
 *	  - data_procR[obNɉ摜WJĂȂ΁Adata_ptr̂܂ܕԂăf[^pA
 *	  - data_procR[obNɉ摜WJĂ΁ANULLԂĂB
 *	- ̓Iɂ́Aclipswf.c̃\[XR[hQƂĂB
 *	  ȂAʏJPEGt@C̏ꍇ́Adraw_procNULLw肷΁A܂ł̎gƕςL܂B
 * [ǋL]
 *	* Thu Sep 03 14:03:54 JST 2009 Naoyuki Sawa
 *	- jpeg_decode()ɁAcomponentǉ܂B
 *	  ܂ł́AY擾Ă܂ACb,Cr擾ł悤ɂȂ܂B
 *	- component=0w肷ƁAYɂāAdata_procR[obN܂B
 *	  O[XP[,J[ǂJPEGt@CAKYĂ̂ŁÃR[obN͕ۏ؂܂B
 *	- component=1,2w肷ƁACb,CrɂāAdata_procR[obN܂B
 *	  O[XP[JPEGt@Cɑ΂component=1,2w肵ꍇAdata_proc̃R[obN܂B
 *	- O[XP[,J[ǂJPEGt@Cs̏ꍇɁAJ[JPEGt@CɓȌʂ𓾂ɂ́A
 *	  Cb,Cr̃R|[lgli[obt@A128(=Cb,Cr̒l)ɏĂĂB
 *	  ̓IȃR[h́Ajpegwin/main.cQƂĂB
 *	- Y,Cb,CrR,G,Bւ̕ΐAȉ̂ƂłB(JPEG File Interchange Format Version 1.02 )
 *	    R = Y                        + 1.402   * (Cr - 128)
 *	    G = Y - 0.34414 * (Cb - 128) - 0.71414 * (Cr - 128)
 *	    B = Y + 1.772   * (Cb - 128)
 *	  Y,Cb,CrR,G,Bւ̕ϊʂ́A-1ȉ256ȏɂȂ邱ƂL蓾܂B
 *	  R,G,B𒼐unsigned char^Ɋi[邱Ƃ͊댯łAint^Ɋi[ăNbsOĂB
 */
const void* jpeg_decode(const void* data_ptr,
	int component,
	void (*size_proc)(int w, int h, void* user_data),
	void (*draw_proc)(int x, int y, int c, void* user_data),
	const void* (*data_proc)(const void* data_ptr, void* user_data),
	void* user_data);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_JPEG_H__*/
