/*	
 *	clipgym.h
 *
 *	P/ECE GYM Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Dec 9 18:16:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_GYM_H__
#define __CLIP_GYM_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	GYMt@Cdl
 ****************************************************************************/

/*
 *	GYMt@Cwb_
 */
typedef struct _GYMHEADER {
	char identifier[4];			/* +  0,  4: Identifier: the characters 'G' 'Y' 'M' 'X' */
	char song_title[32];			/* +  4, 32: Song title */
	char game_title[32];			/* + 36, 32: Game title */
	char game_publisher[32];		/* + 68, 32: Game publisher */
	char name_of_emulator[32];		/* +100, 32: Name of emulator used to create the gym file */
	char name_of_person[32];		/* +132, 32: Name of person who created the gym file */
	char miscelaneous_comments[256];	/* +164,256: Miscelaneous comments */
	int  loop_integer;			/* +420,  4: Loop integer (unsigned little endian). */
						/*           Zero if the gym should not loop. */
						/*           Otherwise it specifies the point (1 being the very beginning) at which looping begins in 1/60 seconds. */
	int  uncompressed_size;			/* +424,  4: Specifies the uncompressed size (unsigned little endian) of the raw gym data if the gym data has been compressed with zlib (deflate algorythm). */
						/*           Zero if not compressed. */
} GYMHEADER;					/* =428 */
// ̂Ƃraw gym data܂B

/****************************************************************************
 *	GYMhCo
 ****************************************************************************/

#define GYMFRAME	3	/* datbuf[]ǂݍݎɎԂ̂ŁAt[܂Ƃ߂ďKvB */
				/* ȂƁAdatbuf[]ǂݍ񂾂Ƃĉł܂B     */
				/* t[܂Ƃ߂ď邩͒\łAŒ2t[ȏ͕KvłB  */
				/* A܂傫ƃX^bNꂪ悤łB               */
				/* 荞݂dɂ肷邽߁HsAvłB                     */
				/* ܂BXg[Đ̑d荞݉ߑłB               */
				/*   clippce.cstream_isrύXɊւRg(2004/12/12)QƂĂB  */
#define GYMBUFLEN	320	/* =16000/50 c 1[tick](=1/50[sec])̃Tv */
#define GYMBUFLEN_60	267	/* =16000/60 c 1/60[sec]̃Tv (GYMP) */
#define GYMBUFLEN_DAC	GYMBUFLEN_60 /* 1/60[sec]DACo̓Tv */

/*
 *	GYMhCo
 */
typedef struct _GYMDRIVER {
	YM2612* ym2612;					/* YM2612  chip (RAMɔzu) */
	SN76489* sn76489;				/* SN76489 chip (   SRAMɔzu) ({SN76496łBiH) */

	int loopcnt;					/* [vJnʒu܂ł̎ct[ (loop_integer->-ւ̃_EJE^)                          */
							/* loop_integer0ȂΔ񃋁[vȂłB񃋁[vȂƃ[vȂ̈Ⴂ́Â悤ɏĂ܂B     */
							/*   1. Ԃ loopcnt=loop_integer, looppos=0 ƂB                                          */
							/*   2. 0(1t[o)R}hǂނтɁAloopcnt1炷B                                     */
							/*   3. loopcnt=0ɂȂÄ݂ʒu(=t@Cʒu-obt@f[^)loopposɊi[B */
							/*   4. t@CI[ɒBAAlooppos0łȂ΁AloopposʒuփV[NB                    */
							/* ڈȍ~Aloopcnt-1-֕ω܂AĂ0ɂȂ邱Ƃ͂܂̂ővłB       */
							/* (̂悤ȏ@ɂŔAłR[hāAFRAMzủ\グ邽߂ł)    */
							/* ܂Aloop_integer0(񃋁[v)Ȃ΁Aŏ̕ω0->-1ƂȂA0ɂȂuԂoȂ̂ŁA */
							/* loopposݒ肳邱Ƃ͂Ȃ0̂܂܂ێA񃋁[v̋ł܂B                      */
	int looppos;					/* [vJnt@CʒuB0Ȃ΃[vʒuoBڂ͏̃RgQƂĂB         */

	FILE* fp;					/* t@C|C^ */
	int datlen;					/* datbuf̗LoCg */
	int datpos;					/* datbuf̑ʒu */
	unsigned char datbuf[BLOCKSIZE + 3];		/* t@Cǂݍ݃obt@ */

	int tmpcnt;					/* tmpbuf̎cTv */
	short tmpbuf[3][GYMBUFLEN + GYMBUFLEN_60];	/* 1/601/50ϊp̈ꎞobt@ ([0]=YM2612, [1]=SN76489, [2]=DAC) */
} GYMDRIVER;

/*
 *	GYMhCo֐
 */
int gym_init(GYMDRIVER* driver, const char* fname);
void gym_free(GYMDRIVER* driver);
int gym_mix(GYMDRIVER* driver, short wbuff[/*GYMBUFLEN*/]);
int gym_stream_callback(short* wbuff, int param);
void gym_dacmix(short dst[/*GYMBUFLEN_60*/], const short src[/*daccnt*/], int daccnt);
void gym_copy(const short src1[/*GYMBUFLEN*/], const short src2[/*GYMBUFLEN*/], const short src3[/*GYMBUFLEN*/], short dst[/*GYMBUFLEN*/]);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* GYMt@C̍ĐJn܂B
 * [in]
 *	fname		GYMt@CB
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKgym_stop()ĂŁAxN^𕜌ĂB
 */
int gym_play(const char* fname);

/* GYMt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void gym_stop();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_GYM_H__*/
