/*	
 *	clipexpr.c
 *
 *	ԏASY(ǔ)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Fri Jun 24 21:38:01 JST 2016 Naoyuki Sawa
 *	- 1st[XB
 *	- {Iɂ͊clipshya.cW[̓ƓłAȉ̓_ǂ܂B
 *	  Eclipshya.cShuntingYard()́A̓L[,o̓L[,X^bNʂɐ݂Ă܂B
 *	    ɑ΂āAclipexpr.cexprsort()́A̓L[̂܂܏o̓L[,y,X^bNƂĂgp܂B
 *	    ɂāAƗp̏ʂጸ܂B
 *	  EShuntingYard()́Ag[N(int)ŕ\o܂łB
 *	    exprsort()́ACӂ̃oCg̃f[^ŁAg[N\悤ɂȂ܂B
 *	  EShuntingYard()́A̓L[̏I[0ŎĂ܂B
 *	    exprsort()́A̓L[̗vfAIɈŎ悤ɂȂ܂B
 *	  Eȏ̉ǂɔAexprsort()̈`́Aqsort()̃\[g֐ɋ߂̂ƂȂ܂B
 *	    ۂ̏AԏASỸ͈\[gƌȂ܂̂ŁA֐dlՂȂƎv܂B
 *	  EShuntingYard()ĂoOAexprsort()ł͏C܂B
 *	    ڍׂ́AShuntingYard()́u//{{2016/06/24RgǋL:`vQƂĉB
 *	- {IȊ֐łAexprsort()̉Ǔ_́AȏłB
 *	  ɁA{IȊ֐gp[eBeB֐ɂĂAȉ̉ǂs܂B
 *	  Eclipshya.cShuntingYard_Eval()́A̎܂łB
 *	    ɑ΂āAclipexpr.cexpreval()́A̎悤ɂȂ܂B
 *	    'USE_EXPREVAL_NEWVER'V{`ƁAłexpreval()LɂȂ܂B
 *	  EȂ֐̎ƂāArnd()ǉ܂B
 *	* Fri Jun 24 22:10:38 JST 2016 Naoyuki Sawa
 *	- exprsort(),y,exprsort_r()ɁA֐̎̐ʒmR[obN֐(fnIncrFnNumArgs)ǉ܂B
 *	  gṕAuŁCImۗLvłexpreval()̎QƂĉB
 *	* Sat Jun 25 21:55:36 JST 2016 Naoyuki Sawa
 *	- uŁCImۗLvłexpreval()ɁAAvP[V`ϐ,֐ɑΉ@\ǉ܂B
 *	  Xexpreval()exprsort()̎gp@߂̃TvłAۂ̃AvP[VŔėpIɎgpo邮炢̋@\ɂȂƎv܂B
 *	  AuŁCImۖvłexpreval()ɂ́AL̋@\͒ǉĂ܂B
 */
#include "clip.h"
#ifdef  USE_EXPR_SEH
//USE_EXPR_SEHV{`ꂽAclipexpr.cDIE()SāASEH_throw(ExprException)ɒu܂B
#undef  DIE
#ifndef PIECE
  #define DIE() SEH_throw(ExprException)
#else //PIECE
  //P/ECEł̂悤ɒ`Ăǂ̂łAߖ̂߉̂悤ɒ`鎖ɂ܂Bʂ͓ɂȂ܂B
  //ȉ̒`clipseh.hSEH_throw()̒`ɈˑĂ܂BSEH_throw()ύX鎞͈ȉύXĉB
  #define DIE() do { Expr_throw(__FILE__, __LINE__); } while(0)
  static void __attribute__((noreturn)) Expr_throw(const char* file, int line) {
    SEH_info.file = file;
    SEH_info.line = line;
    SEH_info.msg  = NULL;
    SEH_longjmp((int)ExprException); }
#endif//PIECE
const char ExprException[1/*dummy*/];
#endif//USE_EXPR_SEH
/****************************************************************************
 *	exprsort()̓ɂĐ
 ****************************************************************************/
#if 0
z񑀍̗

	````````````````````````````````````````````````````


			base									num
												nInput
												
			
			@P@@~@@i@@Q@@{@@R@@j@@|@@S@
			
												
												iOutput			̐}ł́A킩₷̂߂iOutputAۂɂiOutput͕svłB
												iStack			iOutputiStacḱA菇ɏɈv邩łB~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	````````````````````````````````````````````````````

			base									num			
											nInput				
															
						
		P	@~@@i@@Q@@{@@R@@j@@|@@S@()			
						
															
											iOutput				
												iStack			
															̐}ł́A킩₷̂߂ɁuPꎞIȕϐɎov悤ɕ`Ă邪A
	````````````````````````````````````````````````````	ۂɂ́AwidthsȂ̂ňꎞIȕϐɎo͏oȂB
															ۂɂ́Abase[0]`base[iStack*width]͈̔͂'memrotate'B
			base									num			
											nInput				
															
						
			@~@@i@@Q@@{@@R@@j@@|@@S@@P@			
						
															
												iOutput			
												iStack			

	````````````````````````````````````````````````````

			base									num			
										nInput					
															
						
		~	@i@@Q@@{@@R@@j@@|@@S@@P@()			
						
															
											iOutput				
												iStack			
															̐}ł́A킩₷̂߂Ɂu~ꎞIȕϐɎov悤ɕ`Ă邪A
	````````````````````````````````````````````````````	ۂɂ́AwidthsȂ̂ňꎞIȕϐɎo͏oȂB
															ۂɂ́Abase[0]`base[iStack*width]͈̔͂'memrotate'B
			base									num			
										nInput					
															
						
			@i@@Q@@{@@R@@j@@|@@S@@P@@~@			
						
															
											iOutput				
											iStack				

	````````````````````````````````````````````````````

			base									num
									nInput			
												
			
		i	@Q@@{@@R@@j@@|@@S@@P@()@~@
			
											
										iOutput	
											iStack

	````````````````````````````````````````````````````

			base									num
									nInput			
												
			
			@Q@@{@@R@@j@@|@@S@@P@@i@@~@
			
										
										iOutput	
										iStack

	````````````````````````````````````````````````````

			base									num
								nInput				
												
			
		Q	@{@@R@@j@@|@@S@@P@()@i@@~@
			
										
									iOutput	
										iStack

	````````````````````````````````````````````````````

			base									num
								nInput				
												
			
			@{@@R@@j@@|@@S@@P@@Q@@i@@~@
			
										
										iOutput
										iStack

	````````````````````````````````````````````````````

			base									num
							nInput					
												
			
		{	@R@@j@@|@@S@@P@@Q@()@i@@~@
			
										
									iOutput	
										iStack

	````````````````````````````````````````````````````

			base									num
							nInput					
												
			
			@R@@j@@|@@S@@P@@Q@@{@@i@@~@
			
									
									iOutput
									iStack

	````````````````````````````````````````````````````

			base									num
						nInput						
												
			
		R	@j@@|@@S@@P@@Q@()@{@@i@@~@
			
									
								iOutput	
									iStack

	````````````````````````````````````````````````````

			base									num
						nInput						
												
			
			@j@@|@@S@@P@@Q@@R@@{@@i@@~@
			
									
									iOutput
									iStack

	````````````````````````````````````````````````````

			base									num			
					nInput										
															
						
		j	@|@@S@@P@@Q@@R@()@{@@i@@~@			
						
															
								iOutput							
									iStack						
															
	````````````````````````````````````````````````````	
															Hv_
			base								num				
					nInput										X̑ԏASYł́AuivujvuCvg[N͒PɎ̂Ă邾Ȃ̂AIgpĂꍇɁA[N鋰ꂪLB
															ł́AAvP[VŁuivujvuCvg[Ño悤ɁAuivujvuCvg[N̂ĂɖɊi[ĂɂB
						
		j	@|@@S@@P@@Q@@R@@{@@i@@~@()			̐}ł́A킩₷̂߂ɁujꎞIȕϐɎov悤ɕ`Ă邪A
						ۂɂ́AwidthsȂ̂ňꎞIȕϐɎo͏oȂB
															ۂɂ́Abase[0]`base[num*width]͈̔͂'memrotate'B
								iOutput							
								iStack							numȍ~̗̈ɂ́AuivujvuCvg[Ni[Ȃ͂łB
															̗̈AgbVobt@ƌĂԎɂB
	````````````````````````````````````````````````````	
															
			base								num				
					nInput										
															
						
			@|@@S@@P@@Q@@R@@{@@i@@~@@j@			
						
															
								iOutput							
								iStack							

	````````````````````````````````````````````````````

			base								num				
					nInput										
															
						
		{	@|@@S@@P@@Q@@R@()@i@@~@@j@			
						
															
								iOutput							
									iStack						
															̐}ł́A킩₷̂߂Ɂu{ꎞIȕϐɎov悤ɕ`Ă邪A
	````````````````````````````````````````````````````	ۂɂ́AwidthsȂ̂ňꎞIȕϐɎo͏oȂB
															ۂɂ́AiStack+1邾łB
			base								num				
					nInput										
															
						
			@|@@S@@P@@Q@@R@@{@@i@@~@@j@			
						
															
									iOutput						
									iStack						

	````````````````````````````````````````````````````

			base								num				
					nInput										
															
						
		i	@|@@S@@P@@Q@@R@@{@()@~@@j@			
						
															
									iOutput						
										iStack					
															
	````````````````````````````````````````````````````	
															
			base							num					
					nInput										
															
						̐}ł́A킩₷̂߂ɁuiꎞIȕϐɎov悤ɕ`Ă邪A
		i	@|@@S@@P@@Q@@R@@{@@~@()@j@			ۂɂ́AwidthsȂ̂ňꎞIȕϐɎo͏oȂB
						ۂɂ́Abase[iStack*width]`base[num*width]͈̔͂'memrotate'B
															
									iOutput						
									iStack						
															
	````````````````````````````````````````````````````	
															
			base							num					
					nInput										
															
						
			@|@@S@@P@@Q@@R@@{@@~@@i@@j@			
						
															
									iOutput						
									iStack						

	````````````````````````````````````````````````````

			base							num					
				nInput											
															
						
		|	@S@@P@@Q@@R@@{@()@~@@i@@j@			
						
															
								iOutput							
									iStack						
															
	````````````````````````````````````````````````````	
															
			base							num					
				nInput											
															̐}ł́A킩₷̂߂Ɂu|ꎞIȕϐɎov悤ɕ`Ă邪A
						ۂɂ́AwidthsȂ̂ňꎞIȕϐɎo͏oȂB
		|	@S@@P@@Q@@R@@{@@~@()@i@@j@			ۂɂ́Aȉ̂悤ɏB
						Zq̗D揇ʂ̔r邩AX^bNɂȂ܂ŁAiStack+1B
															Zq̗D揇ʂ̔rAbase[0]`base[iStack*width]͈̔͂'memrotate'B
									iOutput						
										iStack					
															
	````````````````````````````````````````````````````	
															
			base							num					
				nInput											
															
						
			@S@@P@@Q@@R@@{@@~@@|@@i@@j@			
						
															
									iOutput						
									iStack						

	````````````````````````````````````````````````````

			base							num
			nInput							
										
			
		S	@P@@Q@@R@@{@@~@()@|@@i@@j@
			
									
								iOutput	
									iStack

	````````````````````````````````````````````````````

			base							num
			nInput							
										
			
			@P@@Q@@R@@{@@~@@S@@|@@i@@j@
			
									
									iOutput
									iStack

	````````````````````````````````````````````````````

			base							num
			nInput							
										
			
		|	@P@@Q@@R@@{@@~@@S@()@i@@j@
			
										
									iOutput	
										iStack

	````````````````````````````````````````````````````

			base							num
			nInput							
										
			
			@P@@Q@@R@@{@@~@@S@@|@@i@@j@
			
										
										iOutput
										iStack

	````````````````````````````````````````````````````

܂Ƃ߂ƁAzɑ΂ĎۂɍśAȉ̒ʂłB

	E̓L[łȂ𒲂ׂB

		(nInput)

	EX^bNłȂ𒲂ׂB

		(iStack < num)

	E̓L[̐擪ɗLg[Nւ̃|C^擾B

		base

	EX^bÑgbvɂg[Nւ̃|C^擾B

		&base[iStack * width]

	E̓L[̐擪ɗLg[NAo̓L[ɒǉB

		memrotate(base, -width, iStack * width)
		nInput--

	E̓L[̐擪ɗLg[NAX^bNɃvbVB

		memrotate(base, -width, iStack * width)
		nInput--
		iStack--

	EX^bN牉Zq|bvďo̓L[ɒǉB

		iStack++

	E̓L[̐擪ɗLg[NAgbVobt@ɒǉB

		memrotate(base, -width, num * width)
		nInput--
		iStack--
		num--

	EX^bÑgbvɂg[NAgbVobt@ɒǉB

		memrotate(&base[iStack * width], -width, (num - iStack) * width)
		num--

#endif
/****************************************************************************
 *	{IȊ֐
 ****************************************************************************/
typedef struct _ST_ExprSort {
	char*	const	base;		//z̐擪AhX			Œl
	int		num;		//gbVobt@̊Jnʒu
	int	const	width;		//g[ÑoCg			Œl
	int		nInput;		//̓L[̎cg[N
	int		iStack;		//X^bNgbv̈ʒu
} ST_ExprSort;
/*--------------------------------------------------------------------------*/
//̓L[łȂ΁A̓L[̐擪ɗLg[Nւ̃|C^ԂB
//̓L[Ȃ΁ANULLԂB
static void* exprsort_GetInputToken(ST_ExprSort* pExprSort) {
#ifdef  _DEBUG
	if((pExprSort->num < 0) || (pExprSort->width < 0) || (pExprSort->nInput < 0) || (pExprSort->iStack < 0) ||
	   (pExprSort->nInput > pExprSort->iStack) || (pExprSort->iStack > pExprSort->num)) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
	return pExprSort->nInput ? pExprSort->base : NULL;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//X^bNłȂ΁AX^bÑgbvɗLg[Nւ̃|C^ԂB
//X^bNȂ΁ANULLԂB
static void* exprsort_GetStackToken(ST_ExprSort* pExprSort) {
#ifdef  _DEBUG
	if((pExprSort->num < 0) || (pExprSort->width < 0) || (pExprSort->nInput < 0) || (pExprSort->iStack < 0) ||
	   (pExprSort->nInput > pExprSort->iStack) || (pExprSort->iStack > pExprSort->num)) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
	return (pExprSort->iStack < pExprSort->num) ? &pExprSort->base[pExprSort->iStack * pExprSort->width] : NULL;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̓L[̐擪ɗLg[NAo̓L[ɒǉB
static void exprsort_MoveInputToOutput(ST_ExprSort* pExprSort) {
	memrotate(exprsort_GetInputToken(pExprSort), -pExprSort->width, pExprSort->iStack * pExprSort->width);
	pExprSort->nInput--;
#ifdef  _DEBUG
	if((pExprSort->num < 0) || (pExprSort->width < 0) || (pExprSort->nInput < 0) || (pExprSort->iStack < 0) ||
	   (pExprSort->nInput > pExprSort->iStack) || (pExprSort->iStack > pExprSort->num)) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̓L[̐擪ɗLg[NAX^bNɃvbVB
static void exprsort_MoveInputToStack(ST_ExprSort* pExprSort) {
	exprsort_MoveInputToOutput(pExprSort);	//ʏ
	pExprSort->iStack--;
#ifdef  _DEBUG
	if((pExprSort->num < 0) || (pExprSort->width < 0) || (pExprSort->nInput < 0) || (pExprSort->iStack < 0) ||
	   (pExprSort->nInput > pExprSort->iStack) || (pExprSort->iStack > pExprSort->num)) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//X^bN牉Zq|bvďo̓L[ɒǉB
static void exprsort_MoveStackToOutput(ST_ExprSort* pExprSort) {
	pExprSort->iStack++;
#ifdef  _DEBUG
	if((pExprSort->num < 0) || (pExprSort->width < 0) || (pExprSort->nInput < 0) || (pExprSort->iStack < 0) ||
	   (pExprSort->nInput > pExprSort->iStack) || (pExprSort->iStack > pExprSort->num)) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̓L[̐擪ɗLg[NAgbVobt@ɒǉB
static void exprsort_MoveInputToTrash(ST_ExprSort* pExprSort) {
	memrotate(exprsort_GetInputToken(pExprSort), -pExprSort->width, pExprSort->num * pExprSort->width);
	pExprSort->nInput--;
	pExprSort->iStack--;
	pExprSort->num--;
#ifdef  _DEBUG
	if((pExprSort->num < 0) || (pExprSort->width < 0) || (pExprSort->nInput < 0) || (pExprSort->iStack < 0) ||
	   (pExprSort->nInput > pExprSort->iStack) || (pExprSort->iStack > pExprSort->num)) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//X^bÑgbvɂg[NAgbVobt@ɒǉB
static void exprsort_MoveStackToTrash(ST_ExprSort* pExprSort) {
	memrotate(exprsort_GetStackToken(pExprSort), -pExprSort->width, (pExprSort->num - pExprSort->iStack) * pExprSort->width);
	pExprSort->num--;
#ifdef  _DEBUG
	if((pExprSort->num < 0) || (pExprSort->width < 0) || (pExprSort->nInput < 0) || (pExprSort->iStack < 0) ||
	   (pExprSort->nInput > pExprSort->iStack) || (pExprSort->iStack > pExprSort->num)) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
}
/*--------------------------------------------------------------------------*/
int exprsort(void* base, size_t num, size_t width,
  int (*fnGetTokenType)(const void* pToken),					//AvP[V`̊֐:g[N̎ނԂB		exprsort_TokenType_`̂ꂩ̒lԂĉB
  int (*fnIsOpLeftAssoc)(const void* pOpTok),					//AvP[V`̊֐:ZqԂB		Ȃ0ȊO̒l,EȂ0ԂĉB
  int (*fnCompareOpPrec)(const void* pOpTok1, const void* pOpTok2),		//AvP[V`̊֐:Zq̗D揇ʂrׂB		pOpTok1̗D揇ʂΕ̒l,pOpTok2̗D揇ʂΐ̒l,Ȃ0ԂĉB
  void (*fnIncrFnNumArgs/*NULL*/)(void* pFnTok)) {				//AvP[V`̊֐:֐̎̐ʒmB	̐̉񐔕ĂяoBX̊֐g[NɎ̐L^ĂA̐AψɑΉ鎖oB	̒Ŋ֐gpĂȂ,,֐gpĂĂʒmsvȂ΁ANULLwo܂B
	return exprsort_r(base, num, width,
		(int (*)(const void*, void*))fnGetTokenType,
		(int (*)(const void*, void*))fnIsOpLeftAssoc,
		(int (*)(const void*, const void*, void*))fnCompareOpPrec,
		(void (*)(void*, void*))fnIncrFnNumArgs,
		NULL);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int exprsort_r(void* base, size_t num, size_t width,
  int (*fnGetTokenType)(const void* pToken, void* arg),				//AvP[V`̊֐:g[N̎ނԂB		exprsort_TokenType_`̂ꂩ̒lԂĉB
  int (*fnIsOpLeftAssoc)(const void* pOpTok, void* arg),			//AvP[V`̊֐:ZqԂB		Ȃ0ȊO̒l,EȂ0ԂĉB
  int (*fnCompareOpPrec)(const void* pOpTok1, const void* pOpTok2, void* arg),	//AvP[V`̊֐:Zq̗D揇ʂrׂB		pOpTok1̗D揇ʂΕ̒l,pOpTok2̗D揇ʂΐ̒l,Ȃ0ԂĉB
  void (*fnIncrFnNumArgs/*NULL*/)(void* pFnTok, void* arg),			//AvP[V`̊֐:֐̎̐ʒmB	̐̉񐔕ĂяoBX̊֐g[NɎ̐L^ĂA̐AψɑΉ鎖oB	̒Ŋ֐gpĂȂ,,֐gpĂĂʒmsvȂ΁ANULLwo܂B
  void* arg) {
	ST_ExprSort stExprSort = {
		base,	//base
		num,	//num
		width,	//width
		num,	//nInput
		num,	//iStack
	};
	void *pToken1, *pToken2;
	int iTokenType;
	//QƎ
	//uWikipedia - ԏASYv(https://ja.wikipedia.org/wiki/ԏASY)	(2016/06/24_)
	//ȉ̃RǵAL̃y[ẂuASY̏ڍׁv̐1:1ɑΉĂ܂B
	//ǂݍނׂg[NԁAȉJԂB
	//g[N1ǂݍށB
	while((pToken1 = exprsort_GetInputToken(&stExprSort))) {
		switch((*fnGetTokenType)(pToken1, arg)) {
		default:DIE();	//ŃG[~AvP[V`fnGetTokenType֐̃oOłB
		//g[Nl̏ꍇA
		case exprsort_TokenType_Number:
			//o̓L[ɒǉB
			exprsort_MoveInputToOutput(&stExprSort);
			break;
		//g[N֐̏ꍇA
		case exprsort_TokenType_Function:
			//X^bNɃvbVB
			exprsort_MoveInputToStack(&stExprSort);										//ɂāApToken1͊֐g[NwȂȂĂ̂Łc	@
//{{QƎ̑ԏASYɂ͖Ǝ											//									
			//֐̎̐ʒm֐w肳Ăc								//									
			if(fnIncrFnNumArgs) {												//									
				//̏ŃX^bÑgbvɈړA֐g[ÑAhXĎ擾B				//									
				pToken1 = exprsort_GetStackToken(&stExprSort);								//pToken1֐g[Nw悤ɁAAhXĎ擾ĂB	A
				//֐́AŔ肵ĊB								//									
				// - ֐ʈ闝ŔAufn()vƁufn(1)v͂ǂuCvAX^bNɐςł܂ƌŋʏoȂȂ邩łB					
				//   ֐̎̐ʒm֐w肳ĂȂ΁A҂ʂKv͖̂ŁA֐Ŕ肷Kv͖̂łA					
				//   ֐̎̐ʒm֐w肳Ăꍇ́A̐̉񐔕fnIncrFnNumArgsĂяo߂ɁAŔ肷KvL܂B					
				pToken2 = exprsort_GetInputToken(&stExprSort);								//֐̒̃g[N擾B					
				if(!pToken2 || ((*fnGetTokenType)(pToken2, arg) != exprsort_TokenType_LeftParenthesis)) { DIE(); }	//֐̒ɍʂΓ͎̃G[B				
				exprsort_MoveInputToStack(&stExprSort);									//ʂX^bNɃvbVB						A`B̊ԂɃX^bNŜ悤ȏȂ悤ɒӂB̍sexprsort_MoveInputToStack()̓X^bNgbvω邪AAōĎ擾Ă֐g[N̈ʒu͕ςȂ̂ővłB
				pToken2 = exprsort_GetInputToken(&stExprSort);								//ʂ̒̃g[N擾B					
				if(pToken2 && ((*fnGetTokenType)(pToken2, arg) == exprsort_TokenType_RightParenthesis)) {		//ʂ̒ɉEʂL΁c					
					exprsort_MoveInputToTrash(&stExprSort);								//EʂgbVobt@ɒǉB				
					exprsort_MoveStackToTrash(&stExprSort);								//ʂX^bN|bvăgbVobt@ɒǉB		
					exprsort_MoveStackToOutput(&stExprSort);							//֐X^bN|bvďo̓L[ɒǉB			
				} else {												//L֐Ȃ΁c						
					(*fnIncrFnNumArgs)(pToken1, arg);								//֐ɍŏ̈L鎖ʒmB	B
					//ȍ~́AuCvoėxɁA߂̊֐̎̐𑝂₵čsB
				}
			}
//}}QƎ̑ԏASYɂ͖Ǝ
			break;
		//g[N֐̈Zp[^(J}Ȃ)̏ꍇ
		case exprsort_TokenType_FunctionArgumentSeparator:
			exprsort_MoveInputToTrash(&stExprSort);		//ł́uivujvuCv̂ĂɃgbVobt@ɒǉB
			//X^bÑgbvɂg[NʂƂȂ܂ŁAX^bN牉Zq|bvďo̓L[ɒǉ铮JԂB
			//ʂoĂȂꍇAZp[^̈ʒuAE̊ʂsvƂȂĂ(G[)B
			for(;;) {
				if(!(pToken2 = exprsort_GetStackToken(&stExprSort))) { DIE(); }	//ʂoėOɃX^bNɂȂ͎̃G[BႦ΁u1,2vƏꍇŃG[~B
				iTokenType = (*fnGetTokenType)(pToken2, arg);
				if(iTokenType == exprsort_TokenType_LeftParenthesis) { break; }
				if(iTokenType != exprsort_TokenType_Operator) { DIE(); }	//,,ZqȊOoė͎̃G[B̓Iɂ͊֐oėG[BႦ΁ufunction(1,2)vƏׂufunction 1,2vƏꍇŃG[~B
				exprsort_MoveStackToOutput(&stExprSort);
			}
//{{QƎ̑ԏASYɂ͖Ǝ
			//֐̎̐ʒm֐w肳Ăc
			if(fnIncrFnNumArgs) {
				//X^bÑgbvɂ鍶ʂ́Ãg[N֐g[NȂ΁c
				if((stExprSort.iStack + 1) < stExprSort.num) {
					pToken2 = &stExprSort.base[(stExprSort.iStack + 1) * stExprSort.width];
					if((*fnGetTokenType)(pToken2, arg) == exprsort_TokenType_Function) {
						//֐Ɏ̈L鎖ʒmB
						(*fnIncrFnNumArgs)(pToken2, arg);
					}
				}
			}
//}}QƎ̑ԏASYɂ͖Ǝ
			break;
		//g[NZqo1̏ꍇ:
		case exprsort_TokenType_Operator:
			//X^bÑgbvɉZqg[No2Ao1ŁAD揇ʂo2ƓႢꍇA邢́Ao1̗D揇ʂo2ႢꍇAȉJԂB
			while((pToken2 = exprsort_GetStackToken(&stExprSort)) &&						//X^bÑgbv
			      ((*fnGetTokenType)(pToken2, arg) == exprsort_TokenType_Operator) &&				//Zqg[No2A
			      (((*fnIsOpLeftAssoc)(pToken1, arg) && ((*fnCompareOpPrec)(pToken1, pToken2, arg) <= 0)) ||	//o1ŁAD揇ʂo2ƓႢꍇA
			                                            ((*fnCompareOpPrec)(pToken1, pToken2, arg) <  0))) {	//邢́Ao1̗D揇ʂo2ႢꍇAȉJԂB
				//o2X^bN|bvAo̓L[ɒǉB
				exprsort_MoveStackToOutput(&stExprSort);
			}
			//o1X^bNɃvbVB
			exprsort_MoveInputToStack(&stExprSort);
			break;
		//g[Nʂ̏ꍇA
		case exprsort_TokenType_LeftParenthesis:
			//X^bNɃvbVB
			exprsort_MoveInputToStack(&stExprSort);
			break;
		//g[NEʂ̏ꍇ
		case exprsort_TokenType_RightParenthesis:
			exprsort_MoveInputToTrash(&stExprSort);		//ł́uivujvuCv̂ĂɃgbVobt@ɒǉB
			//X^bÑgbvɂg[NʂɂȂ܂ŁAX^bN|bvZqo̓L[ɒǉ铮JԂB
			//ʂX^bNɌȂꍇAE̊ʂ̕sv(G[)B
			for(;;) {
				if(!(pToken2 = exprsort_GetStackToken(&stExprSort))) { DIE(); }	//ʂoėOɃX^bNɂȂ͎̃G[BႦ΁u1,2vƏꍇŃG[~B
				iTokenType = (*fnGetTokenType)(pToken2, arg);
				if(iTokenType == exprsort_TokenType_LeftParenthesis) { break; }
				if(iTokenType != exprsort_TokenType_Operator) { DIE(); }	//,,ZqȊOoė͎̃G[B̓Iɂ͊֐oėG[BႦ΁ufunction(1,2)vƏׂufunction 1,2)vƏꍇŃG[~B
				exprsort_MoveStackToOutput(&stExprSort);
			}
			//ʂX^bN|bv邪Ao͂ɂ͒ǉɎ̂ĂB
			exprsort_MoveStackToTrash(&stExprSort);		//ł́uivujvuCv̂ĂɃgbVobt@ɒǉB
			//X^bÑgbvɂg[N֐g[NȂA|bvďo̓L[ɒǉB
			if((pToken2 = exprsort_GetStackToken(&stExprSort)) &&
			   ((*fnGetTokenType)(pToken2, arg) == exprsort_TokenType_Function)) {
				exprsort_MoveStackToOutput(&stExprSort);
			}
			break;
		}
	}
	//ǂݍނׂg[NȂꍇ
	//X^bNɉZqg[NԁAȉJԂB
	while((pToken1 = exprsort_GetStackToken(&stExprSort))) {
		//X^bÑgbvɂ鉉Zqg[NʂȂAʂ̕sv(G[)B
		if((*fnGetTokenType)(pToken1, arg) != exprsort_TokenType_Operator) { DIE(); }	//ZqȊOoė͎̃G[B̓Iɂ͍ʂ֐oėG[BႦ΁ufunction()vƏׂufunctionvƏꍇŃG[~B
		//ZqX^bN|bvďo̓L[ɒǉB
		exprsort_MoveStackToOutput(&stExprSort);
	}
	//I
#ifdef  _DEBUG
	if(stExprSort.num != stExprSort.iStack) { DIE(); }	//ŃG[~瓖W[̃oOłB
#endif//_DEBUG
	return stExprSort.num;	//o̓L[ɒǉg[NԂB
}
/****************************************************************************
 *	[eBeB֐̑I
 ****************************************************************************/
#define USE_EXPREVAL_NEWVER	//̃V{`Ȃ΁AuŁCImۖvłexpreval()Lɂ܂B̃V{`΁AuŁCImۗLvłexpreval()Lɂ܂B2016/06/24݂́AuŁCImۗLvłexpreval()LɂĂ܂B
#ifndef USE_EXPREVAL_NEWVER
/****************************************************************************
 *	[eBeB֐	ŁCImۖ
 ****************************************************************************/
//uŁCImۖvłexpreval()́Aclipshya.cShuntingYard_Eval()Aقڂ̂܂܈ڐÂłB
//́AW[̍쐬ɁAmF̂߂ɍ쐬̂łÁuŁCImۗLvłexpreval()ֈڍs\łB
//AImۖł_Aexpreval_PostProcess()ŃX^bN̏ʂ炵Ă_́A̐񂪌ɂ͓KĂ鎖L邩Ǝv̂ŁAR[h͎cĂɂ܂B
/*--------------------------------------------------------------------------*/
#undef  BUFLEN
#define BUFLEN	64	//
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̃TvΉĂ鎮̗vf
enum {
	op_umi=INT_MIN,	//Zq:-(P)
	op_pow,		//Zq:^
	op_add,		//Zq:+
	op_sub,		//Zq:-()
	op_mul,		//Zq:*
	op_div,		//Zq:/
	fn_rnd,		//֐:rnd
	fn_abs,		//֐:abs
	fn_mod,		//֐:mod
	fn_sep,		//֐̈Zp[^(J}Ȃ):,
	lf_par,		//:(
	ri_par,		//E:)
	nu_min,		//l̍ŏl
};
/*--------------------------------------------------------------------------*/
//AvP[V`̊֐:g[N̎ނԂB
static int expreval_GetTokenType(const void* pToken) {
	int iToken = *(int*)pToken;
	switch(iToken) {
	case op_umi:	//Zq:-(P)
	case op_pow:	//Zq:^
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		return exprsort_TokenType_Operator;
	case fn_rnd:	//֐:rnd
	case fn_abs:	//֐:abs
	case fn_mod:	//֐:mod
		return exprsort_TokenType_Function;
	case fn_sep:	//֐̈Zp[^(J}Ȃ)
		return exprsort_TokenType_FunctionArgumentSeparator;
	case lf_par:	//
		return exprsort_TokenType_LeftParenthesis;
	case ri_par:	//E
		return exprsort_TokenType_RightParenthesis;
	//case nu_min:	//l
	default:
		return exprsort_TokenType_Number;
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//AvP[V`̊֐:ZqԂB
static int expreval_IsOpLeftAssoc(const void* pOpTok) {
	int iOpTok = *(int*)pOpTok;
	switch(iOpTok) {
	default:DIE();
	case op_umi:	//Zq:-(P)
	case op_pow:	//Zq:^
		return 0;
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		return 1;
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//AvP[V`̊֐:Zq̗D揇ʂrׂB
static int expreval_CompareOpPrec(const void* pOpTok1, const void* pOpTok2) {
	int iOpTok1 = *(int*)pOpTok1;
	int iOpTok2 = *(int*)pOpTok2;
	switch(iOpTok1) {
	default:DIE();
	case op_umi:	//Zq:-(P)
		iOpTok1 = 2; break;
	case op_pow:	//Zq:^
		iOpTok1 = 3; break;
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
		iOpTok1 = 0; break;
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		iOpTok1 = 1; break;
	}
	switch(iOpTok2) {
	default:DIE();
	case op_umi:	//Zq:-(P)
		iOpTok2 = 2; break;
	case op_pow:	//Zq:^
		iOpTok2 = 3; break;
	case op_add:	//Zq:+
	case op_sub:	//Zq:-()
		iOpTok2 = 0; break;
	case op_mul:	//Zq:*
	case op_div:	//Zq:/
		iOpTok2 = 1; break;
	}
	return iOpTok1 - iOpTok2;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//eLXg𒆒uL@̃g[NтɕϊB
static int expreval_PreProcess(const char* expr, int buf[/*BUFLEN*/]) {
	int c, i = 0;
	while((c = *expr++)) {
		if(!isspace(c)) {
			if(i >= BUFLEN) { DIE(); }
			if(isdigit(c)) {
				buf[i++] = strtoul(expr - 1, (char**)&expr, 0);
			} else if(!strncmp(expr - 1, "rnd", 3)) {
				buf[i++] = fn_rnd;
				expr += (3 - 1);
			} else if(!strncmp(expr - 1, "abs", 3)) {
				buf[i++] = fn_abs;
				expr += (3 - 1);
			} else if(!strncmp(expr - 1, "mod", 3)) {
				buf[i++] = fn_mod;
				expr += (3 - 1);
			} else {
				switch(c) {
				default:DIE();
				case '^': buf[i++] = op_pow;   break;
				case '+': buf[i++] = op_add;   break;
//{{2016/06/24C:ӂ'i++'ƉEӂ'i'̕]͖`ł茋ʂsƂȂoOC܂BCÕR[hł́AVC++6.0ł͉Eӂɕ]悤ŋRʂ̓ɂȂ܂Agcc33.exeł͍ӂɕ]悤ŕsȓɂȂ܂B
//				case '-': buf[i++] = (i && (buf[i-1] >= ri_par)) ? op_sub : op_umi; break;
//2016/06/24C:ӂ'i++'ƉEӂ'i'̕]͖`ł茋ʂsƂȂoOC܂BCÕR[hł́AVC++6.0ł͉Eӂɕ]悤ŋRʂ̓ɂȂ܂Agcc33.exeł͍ӂɕ]悤ŕsȓɂȂ܂B
				case '-': if(i && (buf[i-1] >= ri_par)) {
				          buf[i++] = op_sub; } else {
				          buf[i++] = op_umi; } break;
//}}2016/06/24C:ӂ'i++'ƉEӂ'i'̕]͖`ł茋ʂsƂȂoOC܂BCÕR[hł́AVC++6.0ł͉Eӂɕ]悤ŋRʂ̓ɂȂ܂Agcc33.exeł͍ӂɕ]悤ŕsȓɂȂ܂B
				case '*': buf[i++] = op_mul;   break;
				case '/': buf[i++] = op_div;   break;
				case ',': buf[i++] = fn_sep;   break;
				case '(': buf[i++] = lf_par;   break;
				case ')': buf[i++] = ri_par;   break;
				}
			}
		}
	}
	return i;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//t|[hL@̃g[NтvZB
// - clipshya.cShuntingYard_PostProcess()ł́A[JϐƂēƗX^bN(aStack[])݂Ă܂A
//   ł́Abuf[]̓ǂݏoς݂̗̈X^bNƂėp悤ɂāAX^bN̏ʂ炵܂B
static int expreval_PostProcess(int buf[/*BUFLEN*/], int num) {
	int i, iToken, iStackTop = -1;
	for(i = 0; i < num; i++) {
		iToken = buf[i];
		switch(iToken) {
		case op_umi:	//Zq:-(P)
			if((iStackTop < 0) || (buf[iStackTop] < nu_min)) { DIE(); }
			buf[iStackTop] = -buf[iStackTop];
			break;
		case op_pow:	//Zq:^
			if((iStackTop < 1) || (buf[iStackTop] < nu_min) || (buf[iStackTop - 1] < nu_min)) { DIE(); }
			buf[iStackTop - 1] = (int)pow(buf[iStackTop - 1], buf[iStackTop]);
			iStackTop--;
			break;
		case op_add:	//Zq:+
			if((iStackTop < 1) || (buf[iStackTop] < nu_min) || (buf[iStackTop - 1] < nu_min)) { DIE(); }
			buf[iStackTop - 1] = buf[iStackTop - 1] + buf[iStackTop];
			iStackTop--;
			break;
		case op_sub:	//Zq:-()
			if((iStackTop < 1) || (buf[iStackTop] < nu_min) || (buf[iStackTop - 1] < nu_min)) { DIE(); }
			buf[iStackTop - 1] = buf[iStackTop - 1] - buf[iStackTop];
			iStackTop--;
			break;
		case op_mul:	//Zq:*
			if((iStackTop < 1) || (buf[iStackTop] < nu_min) || (buf[iStackTop - 1] < nu_min)) { DIE(); }
			buf[iStackTop - 1] = buf[iStackTop - 1] * buf[iStackTop];
			iStackTop--;
			break;
		case op_div:	//Zq:/
			if((iStackTop < 1) || (buf[iStackTop] < nu_min) || (buf[iStackTop - 1] < nu_min)) { DIE(); }
			if(!buf[iStackTop]) { DIE(); }
			buf[iStackTop - 1] = buf[iStackTop - 1] / buf[iStackTop];
			iStackTop--;
			break;
		case fn_rnd:	//֐:rnd
			iStackTop++;
			buf[iStackTop] = rand();
			break;
		case fn_abs:	//֐:abs
			if((iStackTop < 0) || (buf[iStackTop] < nu_min)) { DIE(); }
			buf[iStackTop] = abs(buf[iStackTop]);
			break;
		case fn_mod:	//֐:mod
			if((iStackTop < 1) || (buf[iStackTop] < nu_min) || (buf[iStackTop - 1] < nu_min)) { DIE(); }
			if(!buf[iStackTop]) { DIE(); }
			buf[iStackTop - 1] = buf[iStackTop - 1] % buf[iStackTop];
			iStackTop--;
			break;
		case fn_sep:	//֐̈Zp[^(J}Ȃ):,
		case lf_par:	//:(
		case ri_par:	//E:)
			DIE();
		//case nu_min:	//l
		default:
			if(++iStackTop >= num) { DIE(); }
			buf[iStackTop] = iToken;
			break;
		}
	}
	if((iStackTop != 0) || (buf[iStackTop] < nu_min)) { DIE(); }
	return buf[iStackTop];
}
/*--------------------------------------------------------------------------*/
//ԏASY𗘗pāAeLXǧvZsB
double expreval(const char* expr,
  double (*fnGetVar/*NULL*/)(const char* name),							//AvP[V`̊֐:ϐ̒lԂB	̒ŕϐgpĂȂ΁ANULLwo܂B
  double (*fnDoFunc/*NULL*/)(const char* name, int argc, const double* argv/*[argc]*/)) {		//AvP[V`̊֐:֐̌ʂԂB	̒Ŋ֐gpĂȂ΁ANULLwo܂B
	return expreval_r(expr,
		(double (*)(const char*, void*))fnGetVar,
		(double (*)(const char*, int, const double*, void*))fnDoFunc,
		NULL);
}
double expreval_r(const char* expr,
  double (*fnGetVar/*NULL*/)(const char* name, void* arg),						//AvP[V`̊֐:ϐ̒lԂB	̒ŕϐgpĂȂ΁ANULLwo܂B
  double (*fnDoFunc/*NULL*/)(const char* name, int argc, const double* argv/*[argc]*/, void* arg),	//AvP[V`̊֐:֐̌ʂԂB	̒Ŋ֐gpĂȂ΁ANULLwo܂B
  void* arg) {
	int num, buf[64/**/];
	if(fnGetVar || fnDoFunc) { DIE(); }	//uŁCImۖvłexpreval()́AfnGetVarfnDoFunc̎wɑΉĂ܂B
	num = expreval_PreProcess(expr, buf);	//eLXg˒uL@̃g[N
	num = exprsort(buf, num, sizeof(int),	//uL@̃g[Nсˋt|[hL@̃g[N
		expreval_GetTokenType ,
		expreval_IsOpLeftAssoc,
		expreval_CompareOpPrec,
		NULL);
	return expreval_PostProcess(buf, num);	//t|[hL@̃g[NсˌvZ
}
#if 0
void TestSuite() { //gp
	printf("%d\n", (int)expreval("-10 + mod(-9,-abs(-10+5))^2",NULL,NULL)); //6	cOȂP/ECEŎsƁAʂ6ł͂Ȃ5ɂȂ܂BZ̓rŁApow()̉Z덷̂߂ɁA5^2=24.999...ː؂̂Ă24ɂȂ邩łBframdbl1.s̉Z덷̖łAW[ł͉o܂BŜňvZȂΑ̌덷͋eł̂łÂ̗悤ɐǑvZł͉e傫Ȃ܂B
}
#endif
#else //USE_EXPREVAL_NEWVER
/****************************************************************************
 *	[eBeB֐	ŁCImۗL
 ****************************************************************************/
//́AuŁCImۖvłexpreval()ł͂ȂÁuŁCImۗLvłexpreval()x[XɁA@\ǉčs\łB
//_ł́AuŁCImۗLvłقǕGł͂ȂAImۖō쐬鎖\̂łAēImۗLƂ܂B
//ŔAAuŁCImۗLvł@\gčsƋ炭Imۂ͕KvɂȂ邾낤A̓炻ĂƎvC
//yсAgbVobt@삵Ă鎖mF邽߂łB(gbVobt@ɃoOLABoehm GC̃[No@\Ōo܂B)
/*--------------------------------------------------------------------------*/
typedef struct _ST_ExprEval_Token {
	int			type;		//exprsort_TokenType_`
} ST_ExprEval_Token;
static ST_ExprEval_Token* ExprEval_Token_New(int type) {
	ST_ExprEval_Token* pToken = calloc(1, sizeof(ST_ExprEval_Token));
	if(!pToken) { DIE(); }
	pToken->type = type;
	return pToken;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
typedef struct _ST_ExprEval_Token_nu {
	int			type;		//exprsort_TokenType_Number
	double			value;		//l
} ST_ExprEval_Token_nu;
static ST_ExprEval_Token* ExprEval_Token_nu_New(double value) {
	ST_ExprEval_Token_nu* pNuTok = calloc(1, sizeof(ST_ExprEval_Token_nu));
	if(!pNuTok) { DIE(); }
	pNuTok->type = exprsort_TokenType_Number;
	pNuTok->value = value;
	return (ST_ExprEval_Token*)pNuTok;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
typedef struct _ST_ExprEval_Token_op {
	int			type;		//exprsort_TokenType_Operator
	int			name;		//'n'(P-,NegNł),'^'(ׂ),'+','-'(-),'*','/'
} ST_ExprEval_Token_op;
static ST_ExprEval_Token* ExprEval_Token_op_New(int name) {
	ST_ExprEval_Token_op* pOpTok = calloc(1, sizeof(ST_ExprEval_Token_op));
	if(!pOpTok) { DIE(); }
	pOpTok->type = exprsort_TokenType_Operator;
	pOpTok->name = name;
	return (ST_ExprEval_Token*)pOpTok;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
typedef struct _ST_ExprEval_Token_fn {
	int			type;		//exprsort_TokenType_Function
	int			argc;		//̐
	char			name[0];	//֐
} ST_ExprEval_Token_fn;
static ST_ExprEval_Token* ExprEval_Token_fn_New(const char* name) {
	ST_ExprEval_Token_fn* pFnTok = calloc(1, sizeof(ST_ExprEval_Token_fn) + strlen(name) + 1/*nul*/);
	if(!pFnTok) { DIE(); }
	pFnTok->type = exprsort_TokenType_Function;
	strcpy(pFnTok->name, name);
	return (ST_ExprEval_Token*)pFnTok;
}
/*--------------------------------------------------------------------------*/
//AvP[V`̊֐:g[N̎ނԂB
static int expreval_GetTokenType(const void* _pToken) {
	ST_ExprEval_Token* pToken = *(ST_ExprEval_Token**)_pToken;
	return pToken->type;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//AvP[V`̊֐:ZqԂB
static int expreval_IsOpLeftAssoc(const void* _pOpTok) {
	ST_ExprEval_Token_op* pOpTok = *(ST_ExprEval_Token_op**)_pOpTok;
	switch(pOpTok->name) {
	default:DIE();
	case 'n':	//'n'(P-,NegNł)
	case '^':	//'^'(ׂ)
		return 0;	//E
	case '+':	//'+'
	case '-':	//'-'(-)
	case '*':	//'*'
	case '/':	//'/'
		return 1;	//
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//AvP[V`̊֐:Zq̗D揇ʂrׂB
static int expreval_CompareOpPrec(const void* _pOpTok1, const void* _pOpTok2) {
	ST_ExprEval_Token_op* pOpTok[2] = {
		*(ST_ExprEval_Token_op**)_pOpTok1,
		*(ST_ExprEval_Token_op**)_pOpTok2,
	};
	int i, iOpPri[2];
	for(i = 0; i < 2; i++) {
		switch(pOpTok[i]->name) {
		default:DIE();
		case 'n':	//'n'(P-,NegNł)
			iOpPri[i] = 2; break;
		case '^':	//'^'(ׂ)
			iOpPri[i] = 3; break;
		case '+':	//'+'
		case '-':	//'-'(-)
			iOpPri[i] = 0; break;
		case '*':	//'*'
		case '/':	//'/'
			iOpPri[i] = 1; break;
		}
	}
	return iOpPri[0] - iOpPri[1];
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void expreval_IncrFnNumArgs(void* _pFnTok) {
	ST_ExprEval_Token_fn* pFnTok = *(ST_ExprEval_Token_fn**)_pFnTok;
	pFnTok->argc++;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//eLXg𒆒uL@̃g[NтɕϊB
static void expreval_PreProcess(const char* expr, GPtrArray* array,
  double (*fnGetVar)(const char* name, void* arg),
  void* arg) {
	for(;;) {
		ST_ExprEval_Token* pToken;
		double d;
		int c;
		while(isspace(c = *expr)) { expr++; }	//󔒂ǂݔ΂B
		if(!c) { break; }
		if(isdigit(c)) {
			d = strtod(expr, (char**)&expr);
			pToken = ExprEval_Token_nu_New(d);
		} else if(iscsymf(c)) {
			GString* s = g_string_new(NULL);
			while(iscsym(*expr)) { g_string_append_c(s, *expr++); }
			if(*expr == '(') {	//V{̒(󔒂܂)A'('LΊ֐B
				pToken = ExprEval_Token_fn_New(s->str);
			} else {		//łȂΕϐB
				d = (*fnGetVar)(s->str, arg);
				pToken = ExprEval_Token_nu_New(d);
			}
			g_string_free(s, 1/*free_segment*/);
		} else {
			switch(c) {
			default:DIE();
			case '^':	//'^'(ׂ)
			case '+':
			case '-':	//'n'(P-,NegNł),,'-'(-)
			case '*':
			case '/':
				if(c == '-') {
					c = 'n';	//'n'(P-,NegNł)
					if(array->len) {
						ST_ExprEval_Token* pToken2 = (ST_ExprEval_Token*)g_ptr_array_index(array, array->len - 1);
						if((pToken2->type == exprsort_TokenType_Number) ||
						   (pToken2->type == exprsort_TokenType_RightParenthesis)) { c = '-'; }	//'-'(-)
					}
				}
				pToken = ExprEval_Token_op_New(c);
				break;
			case ',':
				pToken = ExprEval_Token_New(exprsort_TokenType_FunctionArgumentSeparator);
				break;
			case '(':
				pToken = ExprEval_Token_New(exprsort_TokenType_LeftParenthesis);
				break;
			case ')':
				pToken = ExprEval_Token_New(exprsort_TokenType_RightParenthesis);
				break;
			}
			expr++;
		}
		g_ptr_array_add(array, pToken);
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//t|[hL@̃g[NтvZB
static double expreval_PostProcess(GPtrArray* array,
  double (*fnDoFunc)(const char* name, int argc, const double* argv/*[argc]*/, void* arg),
  void* arg) {
	GArray* stack = g_array_new(0, 0, sizeof(double));
	double d;
	int i, argc;
	for(i = 0; i < array->len; i++) {
		ST_ExprEval_Token* pToken = g_ptr_array_index(array, i);
		if(pToken->type == exprsort_TokenType_Number) {
			ST_ExprEval_Token_nu* pNuTok = (ST_ExprEval_Token_nu*)pToken;
			argc = 0;
			d = pNuTok->value;
		} else if(pToken->type == exprsort_TokenType_Function) {
			ST_ExprEval_Token_fn* pFnTok = (ST_ExprEval_Token_fn*)pToken;
			argc = pFnTok->argc;
			if(stack->len < argc) { DIE(); }
			d = (*fnDoFunc)(pFnTok->name, argc, &g_array_index(stack, double, stack->len - argc), arg);
		} else if(pToken->type == exprsort_TokenType_Operator) {
			ST_ExprEval_Token_op* pOpTok = (ST_ExprEval_Token_op*)pToken;
			switch(pOpTok->name) {
			default:DIE();
			case 'n':	//'n'(P-,NegNł)
				argc = 1;
				if(stack->len < argc) { DIE(); }
				d = -g_array_index(stack, double, stack->len - argc);
				break;
			case '^':	//'^'(ׂ)
				argc = 2;
				if(stack->len < argc) { DIE(); }
				d = pow(g_array_index(stack, double, stack->len - argc), g_array_index(stack, double, stack->len - argc + 1));
				break;
			case '+':	//'+'
				argc = 2;
				if(stack->len < argc) { DIE(); }
				d = g_array_index(stack, double, stack->len - argc) + g_array_index(stack, double, stack->len - argc + 1);
				break;
			case '-':	//'-'(-)
				argc = 2;
				if(stack->len < argc) { DIE(); }
				d = g_array_index(stack, double, stack->len - argc) - g_array_index(stack, double, stack->len - argc + 1);
				break;
			case '*':	//'*'
				argc = 2;
				if(stack->len < argc) { DIE(); }
				d = g_array_index(stack, double, stack->len - argc) * g_array_index(stack, double, stack->len - argc + 1);
				break;
			case '/':	//'/'
				argc = 2;
				if(stack->len < argc) { DIE(); }
				d = g_array_index(stack, double, stack->len - argc) / g_array_index(stack, double, stack->len - argc + 1);
				break;
			}
		} else {
			DIE();
		}
		g_array_set_size(stack, stack->len - argc);
		g_array_append_val(stack, d);
	}
	if(stack->len != 1) { DIE(); }
	d = g_array_index(stack, double, 0);
	g_array_unref(stack);
	return d;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//g[NJB
static void expreval_FreeToken(void* data) {
	free(data);
}
/*--------------------------------------------------------------------------*/
//fnGetVar̃TvłB{̓AvP[V`ׂłANULLw肳ꂽꍇɂ̃Tvgp܂B
static double expreval_fnGetVar(const char* name, void* arg) {
	double d;
	if(!strcmp(name, "E")) {
		d = M_E;
	} else if(!strcmp(name, "PI")) {
		d = M_PI;
	} else {
		DIE();
	}
	return d;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//fnDoFunc̃TvłB{̓AvP[V`ׂłANULLw肳ꂽꍇɂ̃Tvgp܂B
static double expreval_fnDoFunc(const char* name, int argc, const double* argv/*[argc]*/, void* arg) {
	double d;
	if(!strcmp(name, "rnd")) {
		if(argc != 0) { DIE(); }	//0̗
		d = drand48();
	} else if(!strcmp(name, "abs")) {
		if(argc != 1) { DIE(); }
		d = fabs(argv[0]);
	} else if(!strcmp(name, "mod")) {
		if((argc != 2) || !argv[1]) { DIE(); }
		d = fmod(argv[0], argv[1]);
	} else if(!strcmp(name, "min")) {
		if(!argc) { DIE(); }		//1ȏ̉ψ̗
		d = *argv++;
		while(--argc) {
			double d2 = *argv++;
			d = min(d, d2);
		}
	} else if(!strcmp(name, "max")) {
		if(!argc) { DIE(); }		//1ȏ̉ψ̗
		d = *argv++;
		while(--argc) {
			double d2 = *argv++;
			d = max(d, d2);
		}
	} else {
		DIE();
	}
	return d;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ԏASY𗘗pāAeLXǧvZsB
double expreval(const char* expr,
  double (*fnGetVar/*NULL*/)(const char* name),							//AvP[V`̊֐:ϐ̒lԂB	̒ŕϐgpĂȂ΁ANULLwo܂B
  double (*fnDoFunc/*NULL*/)(const char* name, int argc, const double* argv/*[argc]*/)) {		//AvP[V`̊֐:֐̌ʂԂB	̒Ŋ֐gpĂȂ΁ANULLwo܂B
	return expreval_r(expr,
		(double (*)(const char*, void*))fnGetVar,
		(double (*)(const char*, int, const double*, void*))fnDoFunc,
		NULL);
}
double expreval_r(const char* expr,
  double (*fnGetVar/*NULL*/)(const char* name, void* arg),						//AvP[V`̊֐:ϐ̒lԂB	̒ŕϐgpĂȂ΁ANULLwo܂B
  double (*fnDoFunc/*NULL*/)(const char* name, int argc, const double* argv/*[argc]*/, void* arg),	//AvP[V`̊֐:֐̌ʂԂB	̒Ŋ֐gpĂȂ΁ANULLwo܂B
  void* arg) {
	int n;
	double d;
	//z쐬B
	GPtrArray* array = g_ptr_array_new_with_free_func(expreval_FreeToken);	//freew肵Ă͂ȂBRgarray.cg_array_set_clear_func()̃RgQƂB
	//eLXg𒆒uL@̃g[NтɕϊB
	expreval_PreProcess(expr, array,
	                    fnGetVar ? fnGetVar : expreval_fnGetVar,		//fnGetVar̃TvłB{̓AvP[V`ׂłANULLw肳ꂽꍇɂ̃Tvgp܂B
	                    arg);
	//uL@̃g[Nтt|[hL@̃g[NтɕϊB
	n = exprsort(array->pdata, array->len, sizeof(void*),
	             expreval_GetTokenType,
	             expreval_IsOpLeftAssoc,
	             expreval_CompareOpPrec,
	             expreval_IncrFnNumArgs);
	//ź̖AgbVobt@̕JB
	g_ptr_array_set_size(array, n);
	//t|[hL@̃g[NтvZB
	d = expreval_PostProcess(array,
	                         fnDoFunc ? fnDoFunc : expreval_fnDoFunc,	//fnDoFunc̃TvłB{̓AvP[V`ׂłANULLw肳ꂽꍇɂ̃Tvgp܂B
	                         arg);
	//zB
	g_ptr_array_unref(array);
	return d;
}
#if 0
void TestSuite() { //gp
	printf("%f\n", expreval("-(abs(max(-1.5,0.5,1.5,0.5) - PI) * 10)^2",NULL,NULL)); //-269.482644
}
#endif
#endif//USE_EXPREVAL_NEWVER
