/*
 *	clipdire.c
 *
 *	POSIX̃fBNg䃋[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Wed Jan 26 00:13:38 JST 2011 Naoyuki Sawa
 *	- 1st [XB
 *	- P/ECEJAсAEPSONS1C33Jɂ́APOSIXdirent.hwb_t@C܂܂Ă܂B
 *	  P/ECE APIpceFileFindOpen(),pceFileFindNext(),pceFileFindClose()𒼐ڎgΏ[Ȃ̂ŁAĂȂ̂łA
 *	  Web⏑Ђ̃TvvORpC鎞ɕKvɂȂꍇɔāApӂĂƂɂ܂B
 *	  ̓Iɂ́AuvO~OLuaṽTvvORpC邽߂ɗpӂ܂B
 *	- P/ECEt@CVXeɂ́ATufBNgL܂B
 *	  opendir()֐̈ dirname ͖AɃ[gfBNgJƂ܂B
 *	* Thu Jan 27 00:39:00 JST 2011 Naoyuki Sawa
 *	- rewinddir(),telldir(),seekdir()ǉ܂B
 *	- scandir(),alphasort(),versionsort()̐錾ǉ܂BłBAKvɂȂۂɁA\łB
 *	* Sat Feb 05 01:53:09 JST 2011 Naoyuki Sawa
 *	- scandir(),alphasort()܂B
 *	* Wed May 21 15:29:53 JST 2014 Naoyuki Sawa
 *	- Windowsłopendir(),readdir(),closedir()܂B
 *	* Mon Aug 11 19:48:16 JST 2014 Naoyuki Sawa
 *	- versionsort(),strverscmp()܂B
 *	* Thu Jan 08 21:00:51 JST 2015 Naoyuki Sawa
 *	- Visual C++ 6.0Ńrh鎞̂߂ɁAstrverscmp()̐錾ǉ܂B
 *	  P/ECEŃrh鎞́Ainclude/string.hstrverscmp()錾Ă̂ŖL܂񂪁A
 *	  Visual C++ 6.0Ńrh鎞́AVisual C++ 6.0string.hɂstrverscmp()܂܂ĂȂ̂ŁAversionsort()strverscmp()ւ̑OQƂxɂȂ邽߂łB
 *	  strverscmp()錾邱ƂɂAVisual C++ 6.0Ńrh鎞xoȂȂ܂B
 *	  AP/ECEŃrh鎞Ő錾ĂĂQ͖̂łAŏƂ邽߂ɁAP/ECEŃrh鎞͂ł͐錾ȂƂɂ܂B
 */
#include "clip.h"

#ifdef  _MSC_VER
// * Thu Jan 08 21:00:51 JST 2015 Naoyuki Sawa
// - Visual C++ 6.0Ńrh鎞̂߂ɁAstrverscmp()̐錾ǉ܂B
//   P/ECEŃrh鎞́Ainclude/string.hstrverscmp()錾Ă̂ŖL܂񂪁A
//   Visual C++ 6.0Ńrh鎞́AVisual C++ 6.0string.hɂstrverscmp()܂܂ĂȂ̂ŁAversionsort()strverscmp()ւ̑OQƂxɂȂ邽߂łB
//   strverscmp()錾邱ƂɂAVisual C++ 6.0Ńrh鎞xoȂȂ܂B
//   AP/ECEŃrh鎞Ő錾ĂĂQ͖̂łAŏƂ邽߂ɁAP/ECEŃrh鎞͂ł͐錾ȂƂɂ܂B
int strverscmp(const char* s1, const char* s2);
#endif//_MSC_VER

/****************************************************************************
 *	P/ECE
 ****************************************************************************/
#ifdef  PIECE
/*--------------------------------------------------------------------------*/
DIR* opendir(const char* dirname) {
	FILEINFO* pfi = malloc(sizeof(FILEINFO));
	if(!pfi) DIE();
	pceFileFindOpen(pfi);	/* 0(I) */
	return (DIR*)pfi;
}
/*--------------------------------------------------------------------------*/
struct dirent* readdir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	if(!pceFileFindNext(pfi)) return NULL;	/* 0(t@CȂ) */
	return (struct dirent*)pfi->filename;	/* 1(t@C) */
}
/*--------------------------------------------------------------------------*/
int closedir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	pceFileFindClose(pfi);	/* 0(I) */
	free(pfi);
	return 0;
}
/*--------------------------------------------------------------------------*/
void rewinddir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	pceFileFindClose(pfi);	/* 0(I) */
	pceFileFindOpen(pfi);	/* 0(I) */
}
/*--------------------------------------------------------------------------*/
/*{{C:\usr\PIECE\sysdev\pcekn\file.c*/
typedef struct tagWORKS {
	DIRECTORY *pdir;
} WORKS;
/*}}C:\usr\PIECE\sysdev\pcekn\file.c*/
/*--------------------------------------------------------------------------*/
long telldir(DIR* dirp) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	WORKS* pw = (WORKS*)pfi->works;
	return (long)pw->pdir;
}
/*--------------------------------------------------------------------------*/
void seekdir(DIR* dirp, long offset) {
	FILEINFO* pfi = (FILEINFO*)dirp;
	WORKS* pw = (WORKS*)pfi->works;
	pw->pdir = (DIRECTORY*)offset;
}
/*--------------------------------------------------------------------------*/
#endif/*PIECE*/

/****************************************************************************
 *	Windows
 ****************************************************************************/
#ifdef  WIN32
/*--------------------------------------------------------------------------*/
struct __dirstream {
	int count;			/* readdir()Ă΂ꂽ */
	int handle;			/* findn֐̌nh */
	struct _finddata_t fileinfo;	/* findn֐̃t@Cobt@ */
};
/*--------------------------------------------------------------------------*/
DIR* opendir(const char* dirname) {
	char filespec[_MAX_PATH];
	DIR* dirp = calloc(1, sizeof(DIR));
	if(!dirp) { DIE(); }
	_makepath(filespec, NULL, dirname, "*", NULL);	//ǂłǂBu*vłu*.*vłASẴt@CɈvB
//	_makepath(filespec, NULL, dirname, "*", "*");	//̓Iɂ́Au*vgq̗Lt@CɈv邵Au*.*vgq̖t@CɈvB
	dirp->handle = _findfirst(filespec, &dirp->fileinfo);			/* 1ڂ̈vt@C */
	if(dirp->handle == -1) { DIE(); }
	return dirp;
}
/*--------------------------------------------------------------------------*/
struct dirent* readdir(DIR* dirp) {
	if(dirp->count++) {
		if(_findnext(dirp->handle, &dirp->fileinfo)) { return NULL; }	/* 2ڈȍ~̈vt@C */
	}
	return (struct dirent*)dirp->fileinfo.name;
}
/*--------------------------------------------------------------------------*/
int closedir(DIR* dirp) {
	if(_findclose(dirp->handle)) { DIE(); }
	free(dirp);
	return 0;
}
/*--------------------------------------------------------------------------*/
//void rewinddir(DIR* dirp);		/* Windowsł͖ */
/*--------------------------------------------------------------------------*/
//long telldir(DIR* dirp);		/* Windowsł͖ */
/*--------------------------------------------------------------------------*/
//void seekdir(DIR* dirp, long offset);	/* Windowsł͖ */
/*--------------------------------------------------------------------------*/
#endif/*WIN32*/

/****************************************************************************
 *	P/ECE,Windows()
 ****************************************************************************/
int scandir(const char* dirname, struct dirent*** namelist, int (*filter)(const struct dirent*), int (*compar)(const void* /* struct dirent** */, const void* /* struct dirent** */)) {
	int i = 0;
	DIR* d;
	struct dirent* e;
	/* Ggz܂B */
	*namelist = NULL;
	/* fBNgJ܂B */
	if((d = opendir(dirname)) == NULL) {
		DIE();
	}
	/* fBNg̊eGgɂāc */
	while((e = readdir(d)) != NULL) {
		/* tB^֐w肳ĂȂÁAtB^֐ɂđIꂽc */
		if((filter == NULL) || (filter(e) != 0)) {
			/* Ggzg܂B */
			if((*namelist = realloc(*namelist, sizeof(struct dirent*) * (i + 1))) == NULL) {
				DIE();
			}
			/* Gg𕡐邽߂́Amۂ܂B */
			if(((*namelist)[i] = malloc(sizeof(struct dirent))) == NULL) {
				DIE();
			}
			memcpy((*namelist)[i++], e, sizeof(struct dirent));
		}
	}
	/* fBNg܂B */
	if(closedir(d) != 0) {
		DIE();
	}
	/* Ggr֐w肳ĂAGgr֐gă\[g܂B */
	if(compar != NULL) {
		qsort(*namelist, i, sizeof(struct dirent*), compar);
	}
	/* IꂽGgԂ܂B
	 * - IꂽGg 0 ̏ꍇ́A*namelist=NULL ̂܂܂łB
	 *   ĂяoAfree(*namelist) s܂Afree(NULL) ͈SȂ̂Ŗ肠܂B
	 */
	return i;
}
/*--------------------------------------------------------------------------*/
int alphasort(const void* /* const struct dirent** */ a, const void* /* const struct dirent** */ b) {
	return strcmp((*(const struct dirent**)a)->d_name, (*(const struct dirent**)b)->d_name);
}
/*--------------------------------------------------------------------------*/
int versionsort(const void* /* const struct dirent** */ a, const void* /* const struct dirent** */ b) {
	return strverscmp((*(const struct dirent**)a)->d_name, (*(const struct dirent**)b)->d_name);
}

/****************************************************************************
 *	WCCu̕⏕ (P/ECE,Windows())
 ****************************************************************************/
/* 2̃o[WrB
 * [in,out]
 *	http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/strverscmp.3.htmlvp:
 *	̕񂪓ꍇA0ԂB
 *	ȊȌꍇA̒O܂ł͗̕񂪓A̒̃oCgŗ҂ɈႢ悤ȁAoCg̋ETB
 *	oCgE܂ސ(̕)̍ŒvsB(͋En܂ĂĂAEŏIĂĂ悢)
 *	2̕񂩂瓾ꂽ̈܂͗ł΁Astrcmp()Ԃʂ֐̕ԂlƂĕԂB
 *	Ȃ킿AoCglrʂԂB
 *	ȊO(񂪗ƂłȂ)ꍇA̐𐔎ŔrB
 *	̂ƂAȏ0擪ɂ鐔́AOɏ_Ă̂Ɖ߂B(擪0鐔قǑOɗ邱ƂɂȂ)
 *	̌ʁÂ͎悤ɂȂ:000,00,01,010,09,0,1,9,10
 *	                                        ~~     ~~ ~
 *	u0(=0.0)vAu01(=0.01)vu09(=0.09vA傫ƌȂ_Aςɔ邪Adlł悤B
 *	  u0vꕶ̏ꍇɌAuOɏ_āgȂĥƉ߂v悤łB(ƂĂߑRƂȂc)
 * [note]
 *	- strverscmp()́AGNUɂgłB
 *	- strverscmp()́Aėp̕r֐łAscandir()pł͂ȂB
 *	  Ascandir()ȊOŎgp邱Ƃ͂قږƎv̂ŁAscandir()ƈꏏɓW[Ŏ邱ƂɂB
 *	  strverscmp()PƂŎgpꍇ́AW[̑̊֐N閳ʂ邪Aőɖ낤B
 */
int strverscmp(const char* s1, const char* s2) {	//ː錾string.h
	int c1, c2, f1, f2, n1, n2;
	const char *p1, *p2, *q1, *q2;
	p1 = p2 = q1 = q2 = NULL;
	for(;;) {
		c1 = *s1++;
		c2 = *s2++;
		q1 = isdigit(c1) ? (p1 ? p1 : (p1 = s1 - 1)) : NULL;	//Jn̐؂ւB
		q2 = isdigit(c2) ? (p2 ? p2 : (p2 = s2 - 1)) : NULL;	//
		if(c1 -= c2) {						//ӏ𔭌c
			if(p1 && p2) {					//̕񂩂瓾ꂽ̗łȂ΁c
				f1 = strspn(p1, "0");			//擪0̐߂B
				f2 = strspn(p2, "0");			//
				n1 = strspn(p1, "0123456789");		//̌߂B
				n2 = strspn(p2, "0123456789");		//
				if(n1 == 1) { f1 = 0; }			//ςɔdlɑΉ邽
				if(n2 == 1) { f2 = 0; }			//
				if(f1 || f2) {				//,,̐擪0Lꍇc
					if(f2 -= f1) { return f2; }	//擪0ƌȂB̐擪0̐Ȃ΁Aӏ̕rƂB
				} else {				//̐擪0ꍇc
					if(n1 -= n2) { return n1; }	//̌傫ƌȂB̌Ȃ΁Aӏ̕rƂB
				}
			}
			break;						//ӏ̕rƂB
		}
		if(!c2) { break; }					//̕񂪏I[Ȃ΁Aӏ̕rƂB(=0)
		p1 = q1;						//I̐؂ւB
		p2 = q2;						//
	}
	return c1;							//ӏ̕rƂB
}
//eXgXC[g
//	static int compar_strcmp(    const char** a, const char** b) { return strcmp(    *a, *b); }
//	static int compar_strverscmp(const char** a, const char** b) { return strverscmp(*a, *b); }
//	void TestSuite_strverscmp() {
//		static const char* const org[9]={"000","00","01","010","09","0","1","9","10"};
//		       const char*       tmp[9];
//		memcpy((void*)tmp, org, sizeof org);
//		qsort((void*)tmp, 9, sizeof(char*), compar_strcmp);
//		assert(memcmp(tmp, org, sizeof org) != 0);
//		qsort((void*)tmp, 9, sizeof(char*), compar_strverscmp);
//		assert(memcmp(tmp, org, sizeof org) == 0);
//		//
//		assert(strverscmp ("", "") == 0);
//		assert(strverscmp ("a", "a") == 0);
//		assert(strverscmp ("a", "b") < 0);
//		assert(strverscmp ("b", "a") > 0);
//		assert(strverscmp ("000", "00") < 0);
//		assert(strverscmp ("00", "000") > 0);
//		assert(strverscmp ("a0", "a") > 0);
//		assert(strverscmp ("00", "01") < 0);
//		assert(strverscmp ("01", "010") < 0);
//		assert(strverscmp ("010", "09") < 0);
//		assert(strverscmp ("09", "0") < 0);
//		assert(strverscmp ("9", "10") < 0);
//		assert(strverscmp ("0a", "0") > 0);
//	}

