/*	
 *	clipcoll.c
 *
 *	RNV
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Mon Dec 26 01:25:00 JST 2005 Naoyuki Sawa
 *	- VK쐬B
 *	  R[hTCYߖ̂߂ɁAclipmisc.cclipcoll.c֕܂B
 *	* Sat Mar 14 21:13:42 JST 2009 Naoyuki Sawa
 *	- v[ɁAmێR[obNƉR[obNǉ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	[eBeBFRNṼwp֐
 *****************************************************************************/

void*
ptr_copy(void* a)
{
	/* |C^Ԃ܂B */
	return a;
}

void
ptr_delete(void* a)
{
	/* ܂B */
}

int
ptr_equals(void* a, void* b)
{
	/* |C^r܂B */
	return a == b;
}

void*
str_copy(void* a)
{
	/* 𕡐܂B */
	a = strdup(a);
	if(!a) {
		DIE();
	}
	return a;
}

void
str_delete(void* a)
{
	/* ܂B */
	free(a);
}

int
str_equals(void* a, void* b)
{
	/* r܂B */
	return strcmp(a, b) == 0;
}

void*
unk_copy(void* a)
{
	/* C^[tFCX|C^̎QƃJEg𑝂₵āAԂ܂B */
	UNKNOWN_INTERFACE** _a = a;
	return safe_addref(_a);
}

void
unk_delete(void* a)
{
	/* C^[tFCX|C^̎QƃJEg炵܂B */
	UNKNOWN_INTERFACE** _a = a;
	safe_release(_a);
}

int
unk_equals(void* a, void* b)
{
	/* * abقȂC^[tFCX|C^łĂA
	 *   IuWFNg̃C^[tFCX|C^ł΁AƌȂdlłB
	 * - q̔s߂ɂ́AMAPɊi[ĂUNKNOWN_INTERFACÊ܂ܔr̂łȂA
	 *   IUNKNOWN_INTERFACEvAԂꂽUNKNOWN_INTERFACEmrKv܂B
	 *   ȂȂAIuWFNg̃C^[tFCXĂꍇAeC^[tFCX
	 *   ꂼꂪUNKNOWN_INTERFACEł邽߁AUNKNOWN_INTERFACE݂邩łB
	 *   IUNKNOWN_INTERFACEv邱ƂŁAB̑\UNKNOWN_INTERFACE𓾂܂B
	 *   \UNKNOWN_INTERFACÉAIuWFNgɈӂłA\UNKNOWN_INTERFACEr΁A
	 *   IuWFNgꂩǂr邱Ƃł܂B
	 * - ȂAMAPւ̊i[unk_copy()ɂđ\UNKNOWN_INTERFACE߂Ă@͕słB
	 *   sł闝R̈ڂ́Â悤ȕ@̂ƁAMAPɊi[C^[tFCX|C^
	 *   ɑ\UNKNOWN_INTERFACEɂȂĂ܂Amap_put()map_get()̒lsvƂȂ邩łB
	 *   sł闝R̓ڂ́Aunk_equals()́AMAPɊi[Ălmap_contains()A
	 *   ܂́Amap_get()Ɏw肳ꂽlƂ̔rłAmap_contains()map_get()Ɏw肳ĺA
	 *   K\UNKNOWN_INTERFACEƂ͌ȂłB
	 * * Pȃ|C^rŗǂꍇ́Aunk_equals()̑ptr_equals()gĂB
	 */
	//int result;
	//UNKNOWN_INTERFACE** _a = a;
	//UNKNOWN_INTERFACE** _b = b;
	//_a = safe_query_interface(_a, UNKNOWN_INTERFACE); /* refcnt+1 */
	//_b = safe_query_interface(_b, UNKNOWN_INTERFACE); /* refcnt+1 */
	//result = _a == _b;
	//safe_release(_a); /* refcnt-1 */
	//safe_release(_b); /* refcnt-1 */
	//return result;
	//2005/12/13 reference_equals()}Ng悤ɕύX܂B̓e͓łB
	return reference_equals((UNKNOWN_INTERFACE**)a, (UNKNOWN_INTERFACE**)b);
}

/*****************************************************************************
 *	[eBeBF}bv (RNV)
 *****************************************************************************/

/* }bvvf܂B
 * [in]
 *	map		}bvB
 *	key		L[B
 * [out]
 *	߂l		ꍇ́A}bvvfԂ܂B
 *			Ȃꍇ́ANULLԂ܂B
 */
static MAP_NODE*
map_find(MAP* map, void* key)
{
	LIST_ENTRY* list_head = &map->list_head;
	LIST_ENTRY* list_entry = list_head->Flink;
	MAP_NODE* map_node;

	/* Xg𑖍... */
	while(list_entry != list_head) {
		map_node = CONTAINING_RECORD(list_entry, MAP_NODE, list_entry);
		if(map->map_info.key_equals(map_node->key, key)) {
			/*{{̂߂̏: ̏͏ȗĂvłB*/
			/* ̂߂ɁA}bvvfXg擪ֈړ܂B
			 * ̂悤ȃp^[ł̎gpʓIƁA\邩łB
			 *	if(map_contains(map, key)) {
			 *		val = map_get(map, key);
			 *		...
			 *		free(val); // 2005/12/11̎dlύXɂAl̉KvƂȂ܂B
			 *	}
			 */
			RemoveEntryList(/*&map_node->*/list_entry);
			InsertHeadList(&map->list_head, /*&map_node->*/list_entry);
			/*}}̂߂̏: ̏͏ȗĂvłB*/
			return map_node; /*  */
		}
		list_entry = list_entry->Flink;
	}

	return NULL; /* Ȃ */
}

/*---------------------------------------------------------------------------*/

MAP*
map_create(const MAP_INFO* map_info)
{
	/* \̃mۂ܂B */
	MAP* map = calloc(1, sizeof(MAP));
	if(!map) {
		DIE();
	}

	/* Xgwb_܂B */
	InitializeListHead(&map->list_head);

	/* }bvi[܂B */
	map->map_info = *map_info;

	return map;
}

void
map_delete(MAP* map)
{
	/* cĂ}bvvfׂč폜܂B */
	map_clear(map);

	/* \̃܂B */
	free(map);
}

void
map_clear(MAP* map)
{
	LIST_ENTRY* list_entry;
	MAP_NODE* map_node;

	/* XgɂȂ܂... */
	while(!IsListEmpty(&map->list_head)) {

		/* 擪̃}bvvf擾AXgO܂B */
		list_entry = RemoveHeadList(&map->list_head);
		map_node = CONTAINING_RECORD(list_entry, MAP_NODE, list_entry);

		/* }bvvf폜܂B */
		map->map_info.key_delete(map_node->key); /* L[폜 */
		map->map_info.val_delete(map_node->val); /* l  폜 */
		free(map_node); /* }bvvf̃ */
	}
}

int
map_contains(MAP* map, void* key)
{
	/* }bvvfA1AȂ0Ԃ܂B */
	return map_find(map, key) != NULL;
}

void
map_put(MAP* map, void* key, void* val)
{
	MAP_NODE* map_node;

	/* V}bvvf쐬܂B */
	map_node = calloc(1, sizeof(MAP_NODE)); /* }bvvf̃m */
	if(!map_node) {
		DIE();
	}
	map_node->key = map->map_info.key_copy(key); /* L[𕡐Ċi[ */
	map_node->val = map->map_info.val_copy(val); /* l  𕡐Ċi[ */

	/* L[Ã}bvvf΁A폜܂B */
	if(map_contains(map, key)) {
		map_remove(map, key); /* ̃}bvvf폜 */
	}

	/* V}bvvfAXgɒǉ܂B */
	InsertHeadList(&map->list_head, &map_node->list_entry);
}

void*
map_get(MAP* map, void* key)
{
	MAP_NODE* map_node;

	/* }bvvf܂B */
	map_node = map_find(map, key);
	if(!map_node) {
		DIE(); /* Ȃ */
	}

	///* }bvvf́AlԂ܂B */
	//return map_node->val;
	//2005/12/11 dlύX
	/* }bvvfێĂl̕Ԃ܂B */
	return map->map_info.val_copy(map_node->val);
}

void
map_remove(MAP* map, void* key)
{
	MAP_NODE* map_node;

	/* 폜}bvvf܂B */
	map_node = map_find(map, key);
	if(!map_node) {
		DIE(); /* Ȃ */
	}

	/* 폜}bvvfAXgO܂B */
	RemoveEntryList(&map_node->list_entry);

	/* }bvvf폜܂B */
	map->map_info.key_delete(map_node->key); /* L[폜 */
	map->map_info.val_delete(map_node->val); /* l  폜 */
	free(map_node); /* }bvvf̃ */
}

MAP*
map_duplicate(MAP* map)
{
	LIST_ENTRY* list_head = &map->list_head; /* ̃}bṽXgwb_ */
	LIST_ENTRY* list_entry = list_head->Flink; /* ̃}bṽXgp */
	MAP_NODE* src_map_node; /* ̃}bṽ}bvvf */
	MAP_NODE* dst_map_node; /* ̃}bṽ}bvvf */

	/* ̃}bvƓ}bvÃ}bv쐬܂B
	 * ꂪÃ}bvƂȂ܂B
	 */
	map = map_create(&map->map_info); /* ȍ~Amap͕̃}bvw܂ */

	/* ̃}bv̊evf̒lɂ... */
	while(list_entry != list_head) {
		src_map_node = CONTAINING_RECORD(list_entry, MAP_NODE, list_entry);

		/* key_copy()val_copy()wp֐pĕ... */
		dst_map_node = calloc(1, sizeof(MAP_NODE)); /* }bvvf̃m */
		if(!dst_map_node) {
			DIE();
		}
		dst_map_node->key = map->map_info.key_copy(src_map_node->key); /* L[𕡐Ċi[ */
		dst_map_node->val = map->map_info.val_copy(src_map_node->val); /* l  𕡐Ċi[ */

		/* ̃}bv֒ǉ܂B */
		InsertTailList(&map->list_head, &dst_map_node->list_entry);

		list_entry = list_entry->Flink;
	}

	/* ̃}bvԂ܂B */
	return map;
}

struct _LIST*
map_keys(MAP* map)
{
	LIST_ENTRY* list_head = &map->list_head;
	LIST_ENTRY* list_entry = list_head->Flink;
	MAP_NODE* map_node;
	//
	LIST* list;
	LIST_INFO list_info;

	/* ̃Xg쐬܂B */
	list_info.val_copy = map->map_info.key_copy;
	list_info.val_delete = map->map_info.key_delete;
	list = list_create(&list_info);

	/* }bvvfɊ܂܂ĂAׂẴL[AXgɒǉ܂B */
	while(list_entry != list_head) {
		map_node = CONTAINING_RECORD(list_entry, MAP_NODE, list_entry);
		list_add(list, map_node->key);
		list_entry = list_entry->Flink;
	}

	return list;
}

int
map_empty(MAP* map)
{
	return IsListEmpty(&map->list_head);
}

/*****************************************************************************
 *	[eBeBFXg (RNV)
 *****************************************************************************/

/* CfNXɂĎw肳ꂽʒúAXgvf擾܂B
 * [in]
 *	list		XgB
 *	index		CfNXB
 * [out]
 *	߂l		XgvfB
 * [note]
 *	* CfNX́ALȈʒu(0ȏAzTCY)łȂ΂Ȃ܂B
 *	  ͈̔͊ÕCfNXw肳ꂽꍇ́AAT[g܂B
 *	  ̃Xgɑ΂Ă̊֐Ăяoꍇ́AɃAT[g܂B
 */
static LIST_NODE*
list_get_node(LIST* list, int index)
{
	LIST_ENTRY* list_head = &list->list_head;
	LIST_ENTRY* list_entry = list_head->Flink;
	LIST_NODE* list_node;

	/* Xg𑖍... */
	while(list_entry != list_head) {
		if(!index) { /* CfNXv */
			list_node = CONTAINING_RECORD(list_entry, LIST_NODE, list_entry);
			return list_node;
		}
		index--; /* JEg_E */
		list_entry = list_entry->Flink;
	}

	DIE(); /* CfNXs */
}

/*---------------------------------------------------------------------------*/

LIST*
list_create(const LIST_INFO* list_info)
{
	/* \̃mۂ܂B */
	LIST* list = calloc(1, sizeof(LIST));
	if(!list) {
		DIE();
	}

	/* Xgwb_܂B */
	InitializeListHead(&list->list_head);

	/* Xgi[܂B */
	list->list_info = *list_info;

	return list;
}

void
list_delete(LIST* list)
{
	/* cĂ郊Xgvfׂč폜܂B */
	list_clear(list);

	/* \̃܂B */
	free(list);
}

void
list_clear(LIST* list)
{
	LIST_ENTRY* list_entry;
	LIST_NODE* list_node;

	/* XgɂȂ܂... */
	while(!IsListEmpty(&list->list_head)) {

		/* 擪̃Xgvf擾AXgO܂B */
		list_entry = RemoveHeadList(&list->list_head);
		list_node = CONTAINING_RECORD(list_entry, LIST_NODE, list_entry);

		/* Xgvf폜܂B */
		list->list_info.val_delete(list_node->val); /* l폜 */
		free(list_node); /* Xgvf̃ */
	}
}

int
list_size(LIST* list)
{
	LIST_ENTRY* list_head = &list->list_head;
	LIST_ENTRY* list_entry = list_head->Flink;
	int size = 0;

	/* XgɓB܂... */
	while(list_entry != list_head) {
		size++; /* JEgAbv */
		list_entry = list_entry->Flink;
	}

	return size;
}

void
list_set(LIST* list, int index, void* val)
{
	/* CfNXɂĎw肳ꂽʒúA̒l폜܂B */
	list_remove(list, index);

	/* CfNXɂĎw肳ꂽʒuɁAVlǉ܂B */
	list_insert(list, index, val);
}

void*
list_get(LIST* list, int index)
{
	LIST_NODE* list_node;

	/* Xgvf擾܂B */
	list_node = list_get_node(list, index);

	/* XgvfێĂl̕Ԃ܂B */
	return list->list_info.val_copy(list_node->val);
}

void
list_add(LIST* list, void* val)
{
	/* Xg̖ɁAlǉ܂B */
	list_insert(list, list_size(list), val);
}

void
list_insert(LIST* list, int index, void* val)
{
	int size;
	LIST_NODE* list_node;
	LIST_ENTRY* list_entry;
	LIST_ENTRY* next_list_entry;
	LIST_ENTRY* prev_list_entry;

	/* VXgvfǉʒúAÕXgvf擾܂B */
	size = list_size(list);
	if(index == size) { /* ɒǉꍇ */
		next_list_entry = &list->list_head;
	} else { /* rɒǉꍇ */
		list_node = list_get_node(list, index); /* CfNXsȂ΁AŃAT[g܂ */
		next_list_entry = &list_node->list_entry;
	}
	prev_list_entry = next_list_entry->Blink;

	/* VXgvf쐬܂B */
	list_node = calloc(1, sizeof(LIST_NODE)); /* Xgvf̃m */
	if(!list_node) {
		DIE();
	}
	list_node->val = list->list_info.val_copy(val); /* l𕡐Ċi[ */

	/* VXgvfAXgɒǉ܂B */
	list_entry = &list_node->list_entry;
	list_entry->Flink = next_list_entry;
	list_entry->Blink = prev_list_entry;
	prev_list_entry->Flink = next_list_entry->Blink = list_entry;
}

void
list_remove(LIST* list, int index)
{
	LIST_NODE* list_node;

	/* 폜郊Xgvf擾܂B */
	list_node = list_get_node(list, index);

	/* 폜郊XgvfAXgO܂B */
	RemoveEntryList(&list_node->list_entry);

	/* Xgvf폜܂B */
	list->list_info.val_delete(list_node->val); /* l폜 */
	free(list_node); /* Xgvf̃ */
}

LIST*
list_duplicate(LIST* list)
{
	LIST_ENTRY* list_head = &list->list_head; /* ̃Xg̃Xgwb_ */
	LIST_ENTRY* list_entry = list_head->Flink; /* ̃Xg̃Xgp */
	LIST_NODE* src_list_node; /* ̃Xg̃Xgvf */
	LIST_NODE* dst_list_node; /* ̃Xg̃Xgvf */

	/* ̃XgƓXgÃXg쐬܂B
	 * ꂪÃXgƂȂ܂B
	 */
	list = list_create(&list->list_info); /* ȍ~Alist͕̃Xgw܂ */

	/* ̃Xg̊evf̒lɂ... */
	while(list_entry != list_head) {
		src_list_node = CONTAINING_RECORD(list_entry, LIST_NODE, list_entry);

		/* val_copy()wp֐pĕ... */
		dst_list_node = calloc(1, sizeof(LIST_NODE)); /* Xgvf̃m */
		if(!dst_list_node) {
			DIE();
		}
		dst_list_node->val = list->list_info.val_copy(src_list_node->val); /* l𕡐Ċi[ */

		/* ̃Xg֒ǉ܂B */
		InsertTailList(&list->list_head, &dst_list_node->list_entry);

		list_entry = list_entry->Flink;
	}

	/* ̃XgԂ܂B */
	return list;
}

int
list_empty(LIST* list)
{
	return IsListEmpty(&list->list_head);
}

/*****************************************************************************
 *	[eBeBFv[ (RNV)
 *****************************************************************************/

#if 0 /*{{2006/12/06:pool_free()ԋpv[̈svƂύXɂ폜*/
//void*
//pool_alloc(POOL* pool)
//{
//	POOL_NODE* node;
//
//	/* v[łȂ... */
//	if(pool->first) {
//		/* v[A擪̃ubN擾܂B */
//		node = pool->first;
//		pool->first = node->next;
//
//	/* v[Ȃ... */
//	} else {
//		/* q[vAVubNmۂ܂B */
//		node = malloc(pool->size);
//		if(!node) {
//			DIE();
//		}
//	}
//
//	/* ֐̂߂ɁA[NAĕԂƂɂ܂B */
//	memset(node, 0, pool->size);
//
//	/* 蓖ĉ񐔂𑝂₵܂B */
//	if(pool->cnt < 0) {
//		DIE(); /* pool_alloc()pool_free()̌ĂяoΏ̂łȂ */
//	}
//	pool->cnt++;
//
//	return node;
//}
//
//void
//pool_free(POOL* pool, void* ptr)
//{
//	POOL_NODE* node = ptr;
//
//	/* ԂꂽubNAv[̐擪ɃN܂B */
//	node->next = pool->first;
//	pool->first = node;
//
//	/* 蓖ĉ񐔂炵܂B */
//	pool->cnt--;
//	if(pool->cnt < 0) {
//		DIE(); /* pool_alloc()pool_free()̌ĂяoΏ̂łȂ */
//	}
//
//	/* 蓖ĂubNSăv[ɕԂꂽ... */
//	if(!pool->cnt) {
//		/* ubNۂɊJAq[vɕԂ܂B */
//		while(pool->first) {
//			node = pool->first;
//			pool->first = node->next;
//			free(node);
//		}
//	}
//}
#endif /*}}2006/12/06:pool_free()ԋpv[̈svƂύXɂ폜*/

//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//#define POOL_INIT (('P')|('O'<<8)|('O'<<16)|('L'<<24))
//2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
#define POOL_MARK (('P')|('O'<<8)|('O'<<16)|('L'<<24))
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX

void*
pool_alloc(POOL* pool)
{
	POOL_NODE* node;
//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
	void* data;
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX

	/* v[ĂȂ΁A܂B */
//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//	if(pool->init != POOL_INIT) {
//2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
	if(pool->mark != POOL_MARK) {
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
		if(pool->size <= 0) {
			DIE(); /* POOL.sizetB[h̓[U[ݒ肵Ă */
		}
//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//		pool->init = POOL_INIT; /* σ}[N */
//2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
		pool->mark = POOL_MARK; /* σ}[N */
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
		InitializeListHead(&pool->alloc_list);
		InitializeListHead(&pool->free_list);
	}

	/* XgȂ... */
	if(IsListEmpty(&pool->free_list)) {
		/* q[v烁ubNmۂ܂B */
		node = malloc(sizeof(POOL_NODE) + pool->size);
		if(!node) {
			DIE(); /* s */
		}
		/* 蓖Čv[L܂B */
		node->pool = pool;

	/* XgłȂ... */
	} else {
		/* v[烁ubN擾܂B */
		node = (POOL_NODE*)RemoveHeadList(&pool->free_list);
		if(node->pool != pool) {
			DIE(); /* j */
		}
	}

	/* GC̑ΏۂɂȂȂ悤AubN̐擪`FC܂B */
	InsertHeadList(&pool->alloc_list, &node->list_entry);

	/*{{2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/
	/* ubNmۂ́AQƃJEg̏l1łB */
	node->ref_cnt = 1;
	/*}}2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/

//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//	/* f[^̈[NAAf[^̈̐擪AhXԂ܂B */
//	return memset(node + 1, 0, pool->size);
//2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
	/* f[^̈[NA܂B */
	data = memset(node + 1, 0, pool->size);
	/* mێR[obNݒ肳ĂAmێR[obNĂяo܂B
	 * [note]
	 * - mێR[obN̒ŁApool_free()pool_lock()ĂяoƂ͉\łB
	 * - mێR[obN̒pool_lock()ĂяoꍇApool_alloc()̌Ăяo猩ƁA
	 *   QƃJEg̏l2(ȏ)̃ubNԂ邱ƂɂȂ܂B
	 * - mێR[obN̒pool_free()ĂяoꍇAɃubN܂B
	 *   pool_alloc()̌Ăяo猩ƁAȃubN擾邱ƂɂȂ܂B
	 *   pool_alloc()̌ĂяóA擾ubN̗LA𔻒fłȂ̂ŁA
	 *   oǑɂȂՂ߁AmێR[obN̒pool_free()ĂяoȂSłB
	 */
	if(pool->init) {
		(*pool->init)(data);
		/* ̎_ŊɃubNĂ\܂BLRgQƁB */
	}
	/* f[^̈̐擪AhXԂ܂B */
	return data;
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
}

void
pool_free(void* data/*NULLOK*/)
{
	POOL_NODE* node;
	POOL* pool;

	/* upool_free(NULL);vȂ΁As܂B */
	if(!data) {
		return;
	}

	/* ubN̊Ǘ̈悪σv[wĂ邱ƂmF܂B */
	node = (POOL_NODE*)data - 1;
	pool = node->pool;
//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//	if(pool->init != POOL_INIT) {
//2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
	if(pool->mark != POOL_MARK) {
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
		DIE(); /* pool_alloc()ŊmۂȊOpool_free()ł܂ */
	}

	/*{{2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/
	/* QƃJEg炵A܂QƂcĂ牽ɋA܂B */
	node->ref_cnt--;
	if(node->ref_cnt < 0) {
		DIE(); /* {pool_alloc()+pool_lock()}{pool_free()}̉񐔂Ώ */
	}
	if(node->ref_cnt) {
		return;
	}
	/*}}2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/

//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
	/* R[obNݒ肳ĂAR[obNĂяo܂B
	 * [note]
	 * - R[obN̒ŁApool_free()pool_lock()ĂяoƂ͂ł܂B
	 *   sƁAQƃJEgsƂȂApool_free()pool_lock()̒ŃG[I܂B
	 */
	if(pool->free) {
		(*pool->free)(data);
	}
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX

	/* 蓖ăXgOAXgɃ`FC܂B(t͕s!!) */
	RemoveEntryList(&node->list_entry);
	InsertTailList(&pool->free_list, &node->list_entry);

	/* SẴubN^C~OŁAۂɃq[vɕԋp܂B */
	if(IsListEmpty(&pool->alloc_list)) {
		while(!IsListEmpty(&pool->free_list)) {
			node = (POOL_NODE*)RemoveHeadList(&pool->free_list);
			if(node->pool != pool) {
				DIE(); /* j */
			}
			free(node);
		}
	}
}

/*{{2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/
void
pool_lock(void* data/*NULLOK*/)
{
	POOL_NODE* node;
	POOL* pool;

	/* upool_lock(NULL);vȂ΁As܂B */
	if(!data) {
		return;
	}

	/* ubN̊Ǘ̈悪σv[wĂ邱ƂmF܂B */
	node = (POOL_NODE*)data - 1;
	pool = node->pool;
//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//	if(pool->init != POOL_INIT) {
//2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
	if(pool->mark != POOL_MARK) {
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
		DIE(); /* pool_alloc()ŊmۂȊOpool_lock()ł܂ */
	}

	/* QƃJEg𑝂₵܂B */
	node->ref_cnt++;
//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//	if(node->ref_cnt <= 0) {
//2009/03/14:mȃG[`FbN̂߂ɕύX
//pool_lock()ĂяoO̎QƃJEg1ȏ̂͂Ȃ̂ŁA1₷2ȏɂȂ͂łB
//AQƃJEg0̏Ԃpool_lock()ĂяoAȉDIE()ŃG[IꍇA
//pool_free()oRAR[obN̒pool_lock()Ăяoꂽ\܂B
//R[obN̒ŁApool_free()pool_lock()ĂяoƂ͂ł܂B
	if(node->ref_cnt < 2) {
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
		DIE(); /* pool_lock()̉񐔂I[o[t[?(܂L蓾Ȃ...) */
	}
}
/*}}2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/
