
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.global	s1c17_init_tbl
	.code
	.align	2
s1c17_init_tbl:
	.word	s1c17_bcu_init
	.word	s1c17_iram_init
	.word	s1c17_t16_init
	.word	s1c17_itc_init
	.word	s1c17_osc_init
	.word	s1c17_lcd_init
	.word	s1c17_p_init
	.word	s1c17_misc_init
	.word	s1c17_flash_init
	.word	s1c17_sram_init
	.word	s1c17_dbg_init
	.word	0
	.global	s1c17_exec_tbl
	.align	2
s1c17_exec_tbl:
	.word	s1c17_t16_exec
	.word	s1c17_p_exec
	.word	s1c17_lcd_exec
	.word	0
; APP

		.code
		.align		1
		.global		s1c17_memget
		.global		s1c17_memput
		;//-------------------------------------;//
s1c17_memget:
		add		%r13, %r14		;// %r13 := p = base + ofs
		cmp		%r12, 2
		jreq		s1c17_memget_HALF	;// if(size == 2) goto HALF
		jrgt		s1c17_memget_WORD	;// if(size >  2) goto WORD
;//s1c17_memget_BYTE:
		ld.ub		%r10, [%r13]		;// return *(unsigned  char*)p
		ret
s1c17_memget_HALF:
		ld.uh		%r10, [%r13]		;// return *(unsigned short*)p
		ret
s1c17_memget_WORD:
		ld.w		%r10, [%r13]		;// return *(           int*)p
		ret
		;//-------------------------------------;//
s1c17_memput:
		add		%r13, %r15		;// %r13 := p = base + ofs
		cmp		%r12, 2
		jreq		s1c17_memput_HALF	;// if(size == 2) goto HALF
		jrgt		s1c17_memput_WORD	;// if(size >  2) goto WORD
;//s1c17_memput_BYTE:
		ld.b		[%r13], %r14		;// *(unsigned  char*)p = data
		ret					;// return
s1c17_memput_HALF:
		ld.h		[%r13], %r14		;// *(unsigned short*)p = data
		ret					;// return
s1c17_memput_WORD:
		ld.w		[%r13], %r14		;// *(           int*)p = data
		ret					;// return

; NO_APP
	.global	s1c17_op_tbl
	.data
	.align	2
s1c17_op_tbl:
	.half	64632
	.half	10240
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_ld_b_rd_rs
	.space	4
	.half	64632
	.half	8192
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_b_rd_IrbI
	.space	4
	.half	64632
	.half	8224
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_b_rd_IrbIp
	.space	4
	.half	64632
	.half	8288
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_b_rd_IrbIm
	.space	4
	.half	64632
	.half	8256
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_b_rd_mIrbI
	.space	4
	.half	64512
	.half	57344
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_b_rd_Isp_imm7I
	.space	4
	.half	64512
	.half	49152
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_b_rd_Iimm7I
	.space	4
	.half	64632
	.half	9216
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_b_IrbI_rs
	.space	4
	.half	64632
	.half	9248
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_b_IrbIp_rs
	.space	4
	.half	64632
	.half	9312
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_b_IrbIm_rs
	.space	4
	.half	64632
	.half	9280
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_b_mIrbI_rs
	.space	4
	.half	64512
	.half	61440
	.word	s1c17_x6_rs_imm7
	.word	s1c17_ld_b_Isp_imm7I_rs
	.space	4
	.half	64512
	.half	53248
	.word	s1c17_x6_rs_imm7
	.word	s1c17_ld_b_Iimm7I_rs
	.space	4
	.half	64632
	.half	10248
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_ld_ub_rd_rs
	.space	4
	.half	64632
	.half	8200
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_ub_rd_IrbI
	.space	4
	.half	64632
	.half	8232
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_ub_rd_IrbIp
	.space	4
	.half	64632
	.half	8296
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_ub_rd_IrbIm
	.space	4
	.half	64632
	.half	8264
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_ub_rd_mIrbI
	.space	4
	.half	64512
	.half	58368
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_ub_rd_Isp_imm7I
	.space	4
	.half	64512
	.half	50176
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_ub_rd_Iimm7I
	.space	4
	.half	64632
	.half	10256
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_ld_rd_rs
	.space	4
	.half	64512
	.half	38912
	.word	s1c17_x6_rd_sign7
	.word	s1c17_ld_rd_sign7
	.space	4
	.half	64632
	.half	8208
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_rd_IrbI
	.space	4
	.half	64632
	.half	8240
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_rd_IrbIp
	.space	4
	.half	64632
	.half	8304
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_rd_IrbIm
	.space	4
	.half	64632
	.half	8272
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_rd_mIrbI
	.space	4
	.half	64512
	.half	59392
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_rd_Isp_imm7I
	.space	4
	.half	64512
	.half	51200
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_rd_Iimm7I
	.space	4
	.half	64632
	.half	9232
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_IrbI_rs
	.space	4
	.half	64632
	.half	9264
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_IrbIp_rs
	.space	4
	.half	64632
	.half	9328
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_IrbIm_rs
	.space	4
	.half	64632
	.half	9296
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_mIrbI_rs
	.space	4
	.half	64512
	.half	63488
	.word	s1c17_x6_rs_imm7
	.word	s1c17_ld_Isp_imm7I_rs
	.space	4
	.half	64512
	.half	55296
	.word	s1c17_x6_rs_imm7
	.word	s1c17_ld_Iimm7I_rs
	.space	4
	.half	64632
	.half	10264
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_ld_a_rd_rs
	.space	4
	.half	64512
	.half	39936
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_a_rd_imm7
	.space	4
	.half	64632
	.half	8216
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_a_rd_IrbI
	.space	4
	.half	64632
	.half	8248
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_a_rd_IrbIp
	.space	4
	.half	64632
	.half	8312
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_a_rd_IrbIm
	.space	4
	.half	64632
	.half	8280
	.word	s1c17_x6_rd_x4_rb
	.word	s1c17_ld_a_rd_mIrbI
	.space	4
	.half	64512
	.half	60416
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_a_rd_Isp_imm7I
	.space	4
	.half	64512
	.half	52224
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_a_rd_Iimm7I
	.space	4
	.half	64632
	.half	9240
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_a_IrbI_rs
	.space	4
	.half	64632
	.half	9272
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_a_IrbIp_rs
	.space	4
	.half	64632
	.half	9336
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_a_IrbIm_rs
	.space	4
	.half	64632
	.half	9304
	.word	s1c17_x6_rs_x4_rb
	.word	s1c17_ld_a_mIrbI_rs
	.space	4
	.half	64512
	.half	64512
	.word	s1c17_x6_rs_imm7
	.word	s1c17_ld_a_Isp_imm7I_rs
	.space	4
	.half	64512
	.half	56320
	.word	s1c17_x6_rs_imm7
	.word	s1c17_ld_a_Iimm7I_rs
	.space	4
	.half	64639
	.half	15376
	.word	s1c17_x6_rd_x7
	.word	s1c17_ld_a_rd_sp
	.space	4
	.half	64639
	.half	15408
	.word	s1c17_x6_rd_x7
	.word	s1c17_ld_a_rd_pc
	.space	4
	.half	64639
	.half	15384
	.word	s1c17_x6_rd_x7
	.word	s1c17_ld_a_rd_IspI
	.space	4
	.half	64639
	.half	15416
	.word	s1c17_x6_rd_x7
	.word	s1c17_ld_a_rd_IspIp
	.space	4
	.half	64639
	.half	15480
	.word	s1c17_x6_rd_x7
	.word	s1c17_ld_a_rd_IspIm
	.space	4
	.half	64639
	.half	15448
	.word	s1c17_x6_rd_x7
	.word	s1c17_ld_a_rd_mIspI
	.space	4
	.half	64639
	.half	15388
	.word	s1c17_x6_rs_x7
	.word	s1c17_ld_a_IspI_rs
	.space	4
	.half	64639
	.half	15420
	.word	s1c17_x6_rs_x7
	.word	s1c17_ld_a_IspIp_rs
	.space	4
	.half	64639
	.half	15484
	.word	s1c17_x6_rs_x7
	.word	s1c17_ld_a_IspIm_rs
	.space	4
	.half	64639
	.half	15452
	.word	s1c17_x6_rs_x7
	.word	s1c17_ld_a_mIspI_rs
	.space	4
	.half	64639
	.half	15440
	.word	s1c17_x6_rs_x7
	.word	s1c17_ld_a_sp_rs
	.space	4
	.half	65408
	.half	48128
	.word	s1c17_x9_imm7
	.word	s1c17_ld_a_sp_imm7
	.space	4
	.half	64632
	.half	14400
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_add_rd_rs
	.space	4
	.half	64632
	.half	14336
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_add_c_rd_rs
	.space	4
	.half	64632
	.half	14368
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_add_nc_rd_rs
	.space	4
	.half	64512
	.half	32768
	.word	s1c17_x6_rd_imm7
	.word	s1c17_add_rd_imm7
	.space	4
	.half	64632
	.half	12352
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_add_a_rd_rs
	.space	4
	.half	64632
	.half	12288
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_add_a_c_rd_rs
	.space	4
	.half	64632
	.half	12320
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_add_a_nc_rd_rs
	.space	4
	.half	65528
	.half	12296
	.word	s1c17_x13_rs
	.word	s1c17_add_a_sp_rs
	.space	4
	.half	64512
	.half	24576
	.word	s1c17_x6_rd_imm7
	.word	s1c17_add_a_rd_imm7
	.space	4
	.half	65408
	.half	25600
	.word	s1c17_x9_imm7
	.word	s1c17_add_a_sp_imm7
	.space	4
	.half	64632
	.half	14408
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_adc_rd_rs
	.space	4
	.half	64632
	.half	14344
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_adc_c_rd_rs
	.space	4
	.half	64632
	.half	14376
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_adc_nc_rd_rs
	.space	4
	.half	64512
	.half	33792
	.word	s1c17_x6_rd_imm7
	.word	s1c17_adc_rd_imm7
	.space	4
	.half	64632
	.half	14416
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sub_rd_rs
	.space	4
	.half	64632
	.half	14352
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sub_c_rd_rs
	.space	4
	.half	64632
	.half	14384
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sub_nc_rd_rs
	.space	4
	.half	64512
	.half	34816
	.word	s1c17_x6_rd_imm7
	.word	s1c17_sub_rd_imm7
	.space	4
	.half	64632
	.half	12368
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sub_a_rd_rs
	.space	4
	.half	64632
	.half	12304
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sub_a_c_rd_rs
	.space	4
	.half	64632
	.half	12336
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sub_a_nc_rd_rs
	.space	4
	.half	65528
	.half	12312
	.word	s1c17_x13_rs
	.word	s1c17_sub_a_sp_rs
	.space	4
	.half	64512
	.half	26624
	.word	s1c17_x6_rd_imm7
	.word	s1c17_sub_a_rd_imm7
	.space	4
	.half	65408
	.half	27648
	.word	s1c17_x9_imm7
	.word	s1c17_sub_a_sp_imm7
	.space	4
	.half	64632
	.half	14424
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sbc_rd_rs
	.space	4
	.half	64632
	.half	14360
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sbc_c_rd_rs
	.space	4
	.half	64632
	.half	14392
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sbc_nc_rd_rs
	.space	4
	.half	64512
	.half	35840
	.word	s1c17_x6_rd_imm7
	.word	s1c17_sbc_rd_imm7
	.space	4
	.half	64632
	.half	15424
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmp_rd_rs
	.space	4
	.half	64632
	.half	15360
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmp_c_rd_rs
	.space	4
	.half	64632
	.half	15392
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmp_nc_rd_rs
	.space	4
	.half	64512
	.half	36864
	.word	s1c17_x6_rd_sign7
	.word	s1c17_cmp_rd_sign7
	.space	4
	.half	64632
	.half	13376
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmp_a_rd_rs
	.space	4
	.half	64632
	.half	13312
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmp_a_c_rd_rs
	.space	4
	.half	64632
	.half	13344
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmp_a_nc_rd_rs
	.space	4
	.half	64512
	.half	28672
	.word	s1c17_x6_rd_imm7
	.word	s1c17_cmp_a_rd_imm7
	.space	4
	.half	64632
	.half	15432
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmc_rd_rs
	.space	4
	.half	64632
	.half	15368
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmc_c_rd_rs
	.space	4
	.half	64632
	.half	15400
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cmc_nc_rd_rs
	.space	4
	.half	64512
	.half	37888
	.word	s1c17_x6_rd_sign7
	.word	s1c17_cmc_rd_sign7
	.space	4
	.half	64632
	.half	11328
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_and_rd_rs
	.space	4
	.half	64632
	.half	11264
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_and_c_rd_rs
	.space	4
	.half	64632
	.half	11296
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_and_nc_rd_rs
	.space	4
	.half	64512
	.half	40960
	.word	s1c17_x6_rd_sign7
	.word	s1c17_and_rd_sign7
	.space	4
	.half	64632
	.half	11336
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_or_rd_rs
	.space	4
	.half	64632
	.half	11272
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_or_c_rd_rs
	.space	4
	.half	64632
	.half	11304
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_or_nc_rd_rs
	.space	4
	.half	64512
	.half	41984
	.word	s1c17_x6_rd_sign7
	.word	s1c17_or_rd_sign7
	.space	4
	.half	64632
	.half	11344
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_xor_rd_rs
	.space	4
	.half	64632
	.half	11280
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_xor_c_rd_rs
	.space	4
	.half	64632
	.half	11312
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_xor_nc_rd_rs
	.space	4
	.half	64512
	.half	43008
	.word	s1c17_x6_rd_sign7
	.word	s1c17_xor_rd_sign7
	.space	4
	.half	64632
	.half	11352
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_not_rd_rs
	.space	4
	.half	64632
	.half	11288
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_not_c_rd_rs
	.space	4
	.half	64632
	.half	11320
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_not_nc_rd_rs
	.space	4
	.half	64512
	.half	44032
	.word	s1c17_x6_rd_sign7
	.word	s1c17_not_rd_sign7
	.space	4
	.half	63488
	.half	4096
	.word	s1c17_x5_d_sign10
	.word	s1c17_jpr_sign10
	.space	4
	.half	65400
	.half	320
	.word	s1c17_x8_d_x4_rb
	.word	s1c17_jpr_rb
	.space	4
	.half	65280
	.half	768
	.word	s1c17_x8_d_imm7
	.word	s1c17_jpa_imm7
	.space	4
	.half	65400
	.half	328
	.word	s1c17_x8_d_x4_rb
	.word	s1c17_jpa_rb
	.space	4
	.half	65280
	.half	1536
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrgt_sign7
	.space	4
	.half	65280
	.half	1792
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrge_sign7
	.space	4
	.half	65280
	.half	2048
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrlt_sign7
	.space	4
	.half	65280
	.half	2304
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrle_sign7
	.space	4
	.half	65280
	.half	2560
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrugt_sign7
	.space	4
	.half	65280
	.half	2816
	.word	s1c17_x8_d_sign7
	.word	s1c17_jruge_sign7
	.space	4
	.half	65280
	.half	3072
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrult_sign7
	.space	4
	.half	65280
	.half	3328
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrule_sign7
	.space	4
	.half	65280
	.half	3584
	.word	s1c17_x8_d_sign7
	.word	s1c17_jreq_sign7
	.space	4
	.half	65280
	.half	3840
	.word	s1c17_x8_d_sign7
	.word	s1c17_jrne_sign7
	.space	4
	.half	63488
	.half	6144
	.word	s1c17_x5_d_sign10
	.word	s1c17_call_sign10
	.space	4
	.half	65400
	.half	256
	.word	s1c17_x8_d_x4_rb
	.word	s1c17_call_rb
	.space	4
	.half	65280
	.half	1280
	.word	s1c17_x8_d_imm7
	.word	s1c17_calla_imm7
	.space	4
	.half	65400
	.half	264
	.word	s1c17_x8_d_x4_rb
	.word	s1c17_calla_rb
	.space	4
	.half	65407
	.half	288
	.word	s1c17_x8_d_x7
	.word	s1c17_ret
	.space	4
	.half	65411
	.half	29697
	.word	s1c17_x9_imm5_x2
	.word	s1c17_int_imm5
	.space	4
	.half	64515
	.half	29699
	.word	s1c17_x6_imm3_imm5_x2
	.word	s1c17_intl_imm5_imm3
	.space	4
	.half	65407
	.half	296
	.word	s1c17_x8_d_x7
	.word	s1c17_reti
	.space	4
	.half	65535
	.half	352
	.word	s1c17_x16
	.word	s1c17_brk
	.space	4
	.half	65535
	.half	360
	.word	s1c17_x16
	.word	s1c17_retd
	.space	4
	.half	57344
	.half	16384
	.word	s1c17_x3_imm13
	.word	s1c17_ext_imm13
	.space	4
	.half	64632
	.half	11360
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sr_rd_rs
	.space	4
	.half	64512
	.half	45056
	.word	s1c17_x6_rd_imm7
	.word	s1c17_sr_rd_imm7
	.space	4
	.half	64632
	.half	11368
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sa_rd_rs
	.space	4
	.half	64512
	.half	46080
	.word	s1c17_x6_rd_imm7
	.word	s1c17_sa_rd_imm7
	.space	4
	.half	64632
	.half	11376
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_sl_rd_rs
	.space	4
	.half	64512
	.half	47104
	.word	s1c17_x6_rd_imm7
	.word	s1c17_sl_rd_imm7
	.space	4
	.half	64632
	.half	11384
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_swap_rd_rs
	.space	4
	.half	64632
	.half	10296
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cv_ab_rd_rs
	.space	4
	.half	64632
	.half	10328
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cv_as_rd_rs
	.space	4
	.half	64632
	.half	10360
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cv_al_rd_rs
	.space	4
	.half	64632
	.half	10288
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cv_la_rd_rs
	.space	4
	.half	64632
	.half	10320
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_cv_ls_rd_rs
	.space	4
	.half	65535
	.half	0
	.word	s1c17_x16
	.word	s1c17_nop
	.space	4
	.half	65535
	.half	8
	.word	s1c17_x16
	.word	s1c17_halt
	.space	4
	.half	65535
	.half	16
	.word	s1c17_x16
	.word	s1c17_slp
	.space	4
	.half	65535
	.half	32
	.word	s1c17_x16
	.word	s1c17_ei
	.space	4
	.half	65535
	.half	64
	.word	s1c17_x16
	.word	s1c17_di
	.space	4
	.half	64632
	.half	13328
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_ld_cw_rd_rs
	.space	4
	.half	64512
	.half	30720
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_cw_rd_imm7
	.space	4
	.half	64632
	.half	13336
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_ld_ca_rd_rs
	.space	4
	.half	64512
	.half	31744
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_ca_rd_imm7
	.space	4
	.half	64632
	.half	13320
	.word	s1c17_x6_rd_x4_rs
	.word	s1c17_ld_cf_rd_rs
	.space	4
	.half	64512
	.half	54272
	.word	s1c17_x6_rd_imm7
	.word	s1c17_ld_cf_rd_imm7
	.space	4
	.code
	.align	1
	.global	s1c17_cpu_init
s1c17_cpu_init:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_op_tbl+0x0@h	; 	xld.w	%r10,s1c17_op_tbl
	ext	s1c17_op_tbl+0x0@m
	ld.w	%r10,s1c17_op_tbl+0x0@l
	ext	s1c17_op_root+0x0@ah	; 	xld.w	[s1c17_op_root],%r10
	ext	s1c17_op_root+0x0@al
	ld.w	[%r8],%r10
	ld.w	%r11,0x0
	ext	0x2		; 	xld.w	%r13,0x000000a2		; 162
	ld.w	%r13,0x22
	add	%r10,0x10	; 	xadd	%r10,%r10,16
	ld.w	%r12,%r11
__LX74:				; __L74:
	ext	s1c17_op_tbl+0xc@h	; 	xld.w	[%r12+s1c17_op_tbl+0xc],%r10
	ext	s1c17_op_tbl+0xc@m
	ld.w	%r9,s1c17_op_tbl+0xc@l
	add	%r9,%r12
	ld.w	[%r9],%r10
	add	%r10,0x10	; 	xadd	%r10,%r10,16
	add	%r12,0x10	; 	xadd	%r12,%r12,16
	add	%r11,0x1	; 	xadd	%r11,%r11,1
	cmp	%r11,%r13
	jrle	__LX74		; 	xjrle	__L74
	ld.w	%r10,%r11
	sll	%r10,0x4	; 	xsll	%r10,4
	ld.w	%r15,0x0
	ext	s1c17_op_tbl+0xc@h	; 	xld.w	[%r10+s1c17_op_tbl+0xc],%r15
	ext	s1c17_op_tbl+0xc@m
	ld.w	%r9,s1c17_op_tbl+0xc@l
	add	%r9,%r10
	ld.w	[%r9],%r15
	ext	s1c17_cpu+0x0@h	; 	xld.w	%r0,s1c17_cpu
	ext	s1c17_cpu+0x0@m
	ld.w	%r0,s1c17_cpu+0x0@l
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ext	0x0		; 	xld.w	%r14,0x00000030		; 48
	ld.w	%r14,0x30
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	0x1f		; 	xld.w	%r13,0x00ffff80		; 16777088
	ext	0x1ffe
	ld.w	%r13,0x0
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00fffffe
	ext	0x1fff
	and	%r10,0x3e
	ext	0x28		; 	xld.w	[%r0+0x28],%r10
	ld.w	[%r0],%r10
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
	ext	0x2e		; 	xld.h	[%r0+0x2e],%r10
	ld.h	[%r0],%r10
	ext	0x2c		; 	xld.h	[%r0+0x2c],%r10
	ld.h	[%r0],%r10
	ext	s1c17_coprocessor+0x0@h	; 	xld.w	%r12,s1c17_coprocessor
	ext	s1c17_coprocessor+0x0@m
	ld.w	%r12,s1c17_coprocessor+0x0@l
	ld.w	%r13,0x0
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_rd_rs
s1c17_ld_b_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.b	%r10,[%r13]	; 	xld.b	%r10,[%r13]
	ld.uh	%r10,%r10
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_ld_b_rd_IrbI
s1c17_ld_b_rd_IrbI:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_rb_rb_imm13_rb_imm24@rm	; 	xcall	s1c17_rb_rb_imm13_rb_imm24
	call	s1c17_rb_rb_imm13_rb_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.b	%r10,%r10
	ld.uh	%r10,%r10
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_rd_IrbIp
s1c17_ld_b_rd_IrbIp:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.b	%r10,%r10
	ld.uh	%r10,%r10
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_increment_rb_x_imm13_imm24@rm	; 	xcall	s1c17_increment_rb_x_imm13_imm24
	call	s1c17_increment_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_b_rd_IrbIm
s1c17_ld_b_rd_IrbIm:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.b	%r10,%r10
	ld.uh	%r10,%r10
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_b_rd_mIrbI
s1c17_ld_b_rd_mIrbI:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.b	%r10,%r10
	ld.uh	%r10,%r10
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_b_rd_Isp_imm7I
s1c17_ld_b_rd_Isp_imm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sp_imm7_sp_imm20_sp_imm24@rm	; 	xcall	s1c17_sp_imm7_sp_imm20_sp_imm24
	call	s1c17_sp_imm7_sp_imm20_sp_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.b	%r10,%r10
	ld.uh	%r10,%r10
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_rd_Iimm7I
s1c17_ld_b_rd_Iimm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.b	%r10,%r10
	ld.uh	%r10,%r10
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_IrbI_rs
s1c17_ld_b_IrbI_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_rb_rb_imm13_rb_imm24@rm	; 	xcall	s1c17_rb_rb_imm13_rb_imm24
	call	s1c17_rb_rb_imm13_rb_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_IrbIp_rs
s1c17_ld_b_IrbIp_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r10,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_increment_rb_x_imm13_imm24@rm	; 	xcall	s1c17_increment_rb_x_imm13_imm24
	call	s1c17_increment_rb_x_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_IrbIm_rs
s1c17_ld_b_IrbIm_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r10,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_mIrbI_rs
s1c17_ld_b_mIrbI_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r1]	; 	xld.w	%r14,[%r1]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_b_Isp_imm7I_rs
s1c17_ld_b_Isp_imm7I_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sp_imm7_sp_imm20_sp_imm24@rm	; 	xcall	s1c17_sp_imm7_sp_imm20_sp_imm24
	call	s1c17_sp_imm7_sp_imm20_sp_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_b_Iimm7I_rs
s1c17_ld_b_Iimm7I_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_ub_rd_rs
s1c17_ld_ub_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.ub	%r10,[%r13]	; 	xld.ub	%r10,[%r13]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_ld_ub_rd_IrbI
s1c17_ld_ub_rd_IrbI:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_rb_rb_imm13_rb_imm24@rm	; 	xcall	s1c17_rb_rb_imm13_rb_imm24
	call	s1c17_rb_rb_imm13_rb_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_ub_rd_IrbIp
s1c17_ld_ub_rd_IrbIp:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_increment_rb_x_imm13_imm24@rm	; 	xcall	s1c17_increment_rb_x_imm13_imm24
	call	s1c17_increment_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_ub_rd_IrbIm
s1c17_ld_ub_rd_IrbIm:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_ub_rd_mIrbI
s1c17_ld_ub_rd_mIrbI:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_ub_rd_Isp_imm7I
s1c17_ld_ub_rd_Isp_imm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sp_imm7_sp_imm20_sp_imm24@rm	; 	xcall	s1c17_sp_imm7_sp_imm20_sp_imm24
	call	s1c17_sp_imm7_sp_imm20_sp_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_ub_rd_Iimm7I
s1c17_ld_ub_rd_Iimm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_rd_rs
s1c17_ld_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.uh	%r10,[%r13]	; 	xld.uh	%r10,[%r13]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_ld_rd_sign7
s1c17_ld_rd_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign7_sign16@rm	; 	xcall	s1c17_sign7_sign16
	call	s1c17_sign7_sign16@rl
	ld.uh	%r10,%r10
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_rd_IrbI
s1c17_ld_rd_IrbI:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_rb_rb_imm13_rb_imm24@rm	; 	xcall	s1c17_rb_rb_imm13_rb_imm24
	call	s1c17_rb_rb_imm13_rb_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_rd_IrbIp
s1c17_ld_rd_IrbIp:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x2	; 	xld.w	%r13,0x00000002		; 2
	ext	s1c17_increment_rb_x_imm13_imm24@rm	; 	xcall	s1c17_increment_rb_x_imm13_imm24
	call	s1c17_increment_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_rd_IrbIm
s1c17_ld_rd_IrbIm:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x2	; 	xld.w	%r13,0x00000002		; 2
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_rd_mIrbI
s1c17_ld_rd_mIrbI:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ld.w	%r13,0x2	; 	xld.w	%r13,0x00000002		; 2
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_rd_Isp_imm7I
s1c17_ld_rd_Isp_imm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sp_imm7_sp_imm20_sp_imm24@rm	; 	xcall	s1c17_sp_imm7_sp_imm20_sp_imm24
	call	s1c17_sp_imm7_sp_imm20_sp_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_rd_Iimm7I
s1c17_ld_rd_Iimm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_IrbI_rs
s1c17_ld_IrbI_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_rb_rb_imm13_rb_imm24@rm	; 	xcall	s1c17_rb_rb_imm13_rb_imm24
	call	s1c17_rb_rb_imm13_rb_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_IrbIp_rs
s1c17_ld_IrbIp_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r10,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,%r0
	ld.w	%r13,0x2	; 	xld.w	%r13,0x00000002		; 2
	ext	s1c17_increment_rb_x_imm13_imm24@rm	; 	xcall	s1c17_increment_rb_x_imm13_imm24
	call	s1c17_increment_rb_x_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_IrbIm_rs
s1c17_ld_IrbIm_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r10,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,%r0
	ld.w	%r13,0x2	; 	xld.w	%r13,0x00000002		; 2
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_mIrbI_rs
s1c17_ld_mIrbI_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ld.w	%r13,0x2	; 	xld.w	%r13,0x00000002		; 2
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r1]	; 	xld.w	%r14,[%r1]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_Isp_imm7I_rs
s1c17_ld_Isp_imm7I_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sp_imm7_sp_imm20_sp_imm24@rm	; 	xcall	s1c17_sp_imm7_sp_imm20_sp_imm24
	call	s1c17_sp_imm7_sp_imm20_sp_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_Iimm7I_rs
s1c17_ld_Iimm7I_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_rs
s1c17_ld_a_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,[%r13]	; 	xld.w	%r10,[%r13]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_ld_a_rd_imm7
s1c17_ld_a_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_IrbI
s1c17_ld_a_rd_IrbI:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_rb_rb_imm13_rb_imm24@rm	; 	xcall	s1c17_rb_rb_imm13_rb_imm24
	call	s1c17_rb_rb_imm13_rb_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_IrbIp
s1c17_ld_a_rd_IrbIp:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x4	; 	xld.w	%r13,0x00000004		; 4
	ext	s1c17_increment_rb_x_imm13_imm24@rm	; 	xcall	s1c17_increment_rb_x_imm13_imm24
	call	s1c17_increment_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_a_rd_IrbIm
s1c17_ld_a_rd_IrbIm:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x4	; 	xld.w	%r13,0x00000004		; 4
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_a_rd_mIrbI
s1c17_ld_a_rd_mIrbI:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ld.w	%r13,0x4	; 	xld.w	%r13,0x00000004		; 4
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_a_rd_Isp_imm7I
s1c17_ld_a_rd_Isp_imm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sp_imm7_sp_imm20_sp_imm24@rm	; 	xcall	s1c17_sp_imm7_sp_imm20_sp_imm24
	call	s1c17_sp_imm7_sp_imm20_sp_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_Iimm7I
s1c17_ld_a_rd_Iimm7I:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_IrbI_rs
s1c17_ld_a_IrbI_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_rb_rb_imm13_rb_imm24@rm	; 	xcall	s1c17_rb_rb_imm13_rb_imm24
	call	s1c17_rb_rb_imm13_rb_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_IrbIp_rs
s1c17_ld_a_IrbIp_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r10,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,%r0
	ld.w	%r13,0x4	; 	xld.w	%r13,0x00000004		; 4
	ext	s1c17_increment_rb_x_imm13_imm24@rm	; 	xcall	s1c17_increment_rb_x_imm13_imm24
	call	s1c17_increment_rb_x_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_IrbIm_rs
s1c17_ld_a_IrbIm_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r10,%r12
	ld.w	%r0,%r13
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,%r0
	ld.w	%r13,0x4	; 	xld.w	%r13,0x00000004		; 4
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_mIrbI_rs
s1c17_ld_a_mIrbI_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r12,%r0
	ld.w	%r13,0x4	; 	xld.w	%r13,0x00000004		; 4
	ext	s1c17_decrement_rb_x_imm13_imm24@rm	; 	xcall	s1c17_decrement_rb_x_imm13_imm24
	call	s1c17_decrement_rb_x_imm13_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	ld.w	%r14,[%r1]	; 	xld.w	%r14,[%r1]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_ld_a_Isp_imm7I_rs
s1c17_ld_a_Isp_imm7I_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sp_imm7_sp_imm20_sp_imm24@rm	; 	xcall	s1c17_sp_imm7_sp_imm20_sp_imm24
	call	s1c17_sp_imm7_sp_imm20_sp_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_Iimm7I_rs
s1c17_ld_a_Iimm7I_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_sp
s1c17_ld_a_rd_sp:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x24@ah	; 	xld.w	%r10,[s1c17_cpu+0x24]
	ext	s1c17_cpu+0x24@al
	ld.w	%r10,[%r8]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_ld_a_rd_pc
s1c17_ld_a_rd_pc:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x28@ah	; 	xld.w	%r10,[s1c17_cpu+0x28]
	ext	s1c17_cpu+0x28@al
	ld.w	%r10,[%r8]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_ld_a_rd_IspI
s1c17_ld_a_rd_IspI:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	s1c17_sp_sp_imm13_sp_imm24@rm	; 	xcall	s1c17_sp_sp_imm13_sp_imm24
	call	s1c17_sp_sp_imm13_sp_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_IspIp
s1c17_ld_a_rd_IspIp:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	s1c17_cpu+0x24@ah	; 	xld.w	%r13,[s1c17_cpu+0x24]
	ext	s1c17_cpu+0x24@al
	ld.w	%r13,[%r8]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	ext	s1c17_increment_sp_4_imm13_imm24@rm	; 	xcall	s1c17_increment_sp_4_imm13_imm24
	call	s1c17_increment_sp_4_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_IspIm
s1c17_ld_a_rd_IspIm:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	s1c17_cpu+0x24@ah	; 	xld.w	%r13,[s1c17_cpu+0x24]
	ext	s1c17_cpu+0x24@al
	ld.w	%r13,[%r8]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	ext	s1c17_decrement_sp_4_imm13_imm24@rm	; 	xcall	s1c17_decrement_sp_4_imm13_imm24
	call	s1c17_decrement_sp_4_imm13_imm24@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_rd_mIspI
s1c17_ld_a_rd_mIspI:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	s1c17_decrement_sp_4_imm13_imm24@rm	; 	xcall	s1c17_decrement_sp_4_imm13_imm24
	call	s1c17_decrement_sp_4_imm13_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	s1c17_cpu+0x24@ah	; 	xld.w	%r13,[s1c17_cpu+0x24]
	ext	s1c17_cpu+0x24@al
	ld.w	%r13,[%r8]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_IspI_rs
s1c17_ld_a_IspI_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	s1c17_sp_sp_imm13_sp_imm24@rm	; 	xcall	s1c17_sp_sp_imm13_sp_imm24
	call	s1c17_sp_sp_imm13_sp_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r10
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_IspIp_rs
s1c17_ld_a_IspIp_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,%r12
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	s1c17_cpu+0x24@ah	; 	xld.w	%r13,[s1c17_cpu+0x24]
	ext	s1c17_cpu+0x24@al
	ld.w	%r13,[%r8]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ext	s1c17_increment_sp_4_imm13_imm24@rm	; 	xcall	s1c17_increment_sp_4_imm13_imm24
	call	s1c17_increment_sp_4_imm13_imm24@rl
	ret
	.align	1
	.global	s1c17_ld_a_IspIm_rs
s1c17_ld_a_IspIm_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,%r12
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	s1c17_cpu+0x24@ah	; 	xld.w	%r13,[s1c17_cpu+0x24]
	ext	s1c17_cpu+0x24@al
	ld.w	%r13,[%r8]
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ext	s1c17_decrement_sp_4_imm13_imm24@rm	; 	xcall	s1c17_decrement_sp_4_imm13_imm24
	call	s1c17_decrement_sp_4_imm13_imm24@rl
	ret
	.align	1
	.global	s1c17_ld_a_mIspI_rs
s1c17_ld_a_mIspI_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	s1c17_decrement_sp_4_imm13_imm24@rm	; 	xcall	s1c17_decrement_sp_4_imm13_imm24
	call	s1c17_decrement_sp_4_imm13_imm24@rl
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	s1c17_cpu+0x24@ah	; 	xld.w	%r13,[s1c17_cpu+0x24]
	ext	s1c17_cpu+0x24@al
	ld.w	%r13,[%r8]
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_a_sp_rs
s1c17_ld_a_sp_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ext	s1c17_cpu+0x24@ah	; 	xld.w	[s1c17_cpu+0x24],%r10
	ext	s1c17_cpu+0x24@al
	ld.w	[%r8],%r10
	ret
	.align	1
	.global	s1c17_ld_a_sp_imm7
s1c17_ld_a_sp_imm7:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ext	s1c17_cpu+0x24@ah	; 	xld.w	[s1c17_cpu+0x24],%r10
	ext	s1c17_cpu+0x24@al
	ld.w	[%r8],%r10
	ret
	.align	1
	.global	s1c17_add_rd_rs
s1c17_add_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX137		; 	xjrne	__L137
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX139		; 	xjp	__L139
__LX137:				; __L137:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX139:				; __L139:
	ext	s1c17_add@rm	; 	xcall	s1c17_add
	call	s1c17_add@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_add_c_rd_rs
s1c17_add_c_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX141		; 	xjreq	__L141
	call	s1c17_add_rd_rs	; 	xcall	s1c17_add_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	or	%r10,0x8	; 	xoor	%r10,%r10,0x00000008
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX141:				; __L141:
	popn	%r0
	ret
	.align	1
	.global	s1c17_add_nc_rd_rs
s1c17_add_nc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX143		; 	xjrne	__L143
	call	s1c17_add_rd_rs	; 	xcall	s1c17_add_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX143:				; __L143:
	popn	%r0
	ret
	.align	1
	.global	s1c17_add_rd_imm7
s1c17_add_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm16@rm	; 	xcall	s1c17_imm7_imm16
	call	s1c17_imm7_imm16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_add@rm	; 	xcall	s1c17_add
	call	s1c17_add@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_add_a_rd_rs
s1c17_add_a_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX146		; 	xjrne	__L146
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX148		; 	xjp	__L148
__LX146:				; __L146:
	ext	s1c17_0_imm13_imm24@rm	; 	xcall	s1c17_0_imm13_imm24
	call	s1c17_0_imm13_imm24@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX148:				; __L148:
	ext	s1c17_add_a@rm	; 	xcall	s1c17_add_a
	call	s1c17_add_a@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_add_a_c_rd_rs
s1c17_add_a_c_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX150		; 	xjreq	__L150
	call	s1c17_add_a_rd_rs	; 	xcall	s1c17_add_a_rd_rs
__LX150:				; __L150:
	ret
	.align	1
	.global	s1c17_add_a_nc_rd_rs
s1c17_add_a_nc_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX152		; 	xjrne	__L152
	call	s1c17_add_a_rd_rs	; 	xcall	s1c17_add_a_rd_rs
__LX152:				; __L152:
	ret
	.align	1
	.global	s1c17_add_a_sp_rs
s1c17_add_a_sp_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ext	s1c17_cpu+0x2c@h	; 	xld.w	%r0,s1c17_cpu+0x2c
	ext	s1c17_cpu+0x2c@m
	ld.w	%r0,s1c17_cpu+0x2c@l
	ld.h	%r10,[%r0]	; 	xld.h	%r10,[%r0]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX154		; 	xjrne	__L154
	sub	%r0,0x8		; 	xsub	%r0,%r0,8
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	ext	s1c17_add_a@rm	; 	xcall	s1c17_add_a
	call	s1c17_add_a@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	jp	__LX155		; 	xjp	__L155
__LX154:				; __L154:
	ext	s1c17_0_imm13_imm24@rm	; 	xcall	s1c17_0_imm13_imm24
	call	s1c17_0_imm13_imm24@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
	ext	s1c17_add_a@rm	; 	xcall	s1c17_add_a
	call	s1c17_add_a@rl
	ext	0x8		; 	xsub	%r11,%r0,8
	sub	%r11,%r0
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
__LX155:				; __L155:
	ext	s1c17_cpu+0x24@h	; 	xld.w	%r11,s1c17_cpu+0x24
	ext	s1c17_cpu+0x24@m
	ld.w	%r11,s1c17_cpu+0x24@l
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_add_a_rd_imm7
s1c17_add_a_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_add_a@rm	; 	xcall	s1c17_add_a
	call	s1c17_add_a@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_add_a_sp_imm7
s1c17_add_a_sp_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x24@h	; 	xld.w	%r0,s1c17_cpu+0x24
	ext	s1c17_cpu+0x24@m
	ld.w	%r0,s1c17_cpu+0x24@l
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_add_a@rm	; 	xcall	s1c17_add_a
	call	s1c17_add_a@rl
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_adc_rd_rs
s1c17_adc_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX159		; 	xjrne	__L159
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX161		; 	xjp	__L161
__LX159:				; __L159:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX161:				; __L161:
	ext	s1c17_adc@rm	; 	xcall	s1c17_adc
	call	s1c17_adc@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_adc_c_rd_rs
s1c17_adc_c_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX163		; 	xjreq	__L163
	call	s1c17_adc_rd_rs	; 	xcall	s1c17_adc_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	or	%r10,0x8	; 	xoor	%r10,%r10,0x00000008
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX163:				; __L163:
	popn	%r0
	ret
	.align	1
	.global	s1c17_adc_nc_rd_rs
s1c17_adc_nc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX165		; 	xjrne	__L165
	call	s1c17_adc_rd_rs	; 	xcall	s1c17_adc_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX165:				; __L165:
	popn	%r0
	ret
	.align	1
	.global	s1c17_adc_rd_imm7
s1c17_adc_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm16@rm	; 	xcall	s1c17_imm7_imm16
	call	s1c17_imm7_imm16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_adc@rm	; 	xcall	s1c17_adc
	call	s1c17_adc@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sub_rd_rs
s1c17_sub_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX168		; 	xjrne	__L168
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX170		; 	xjp	__L170
__LX168:				; __L168:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX170:				; __L170:
	ext	s1c17_sub@rm	; 	xcall	s1c17_sub
	call	s1c17_sub@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_sub_c_rd_rs
s1c17_sub_c_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX172		; 	xjreq	__L172
	call	s1c17_sub_rd_rs	; 	xcall	s1c17_sub_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	or	%r10,0x8	; 	xoor	%r10,%r10,0x00000008
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX172:				; __L172:
	popn	%r0
	ret
	.align	1
	.global	s1c17_sub_nc_rd_rs
s1c17_sub_nc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX174		; 	xjrne	__L174
	call	s1c17_sub_rd_rs	; 	xcall	s1c17_sub_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX174:				; __L174:
	popn	%r0
	ret
	.align	1
	.global	s1c17_sub_rd_imm7
s1c17_sub_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm16@rm	; 	xcall	s1c17_imm7_imm16
	call	s1c17_imm7_imm16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sub@rm	; 	xcall	s1c17_sub
	call	s1c17_sub@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sub_a_rd_rs
s1c17_sub_a_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX177		; 	xjrne	__L177
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX179		; 	xjp	__L179
__LX177:				; __L177:
	ext	s1c17_0_imm13_imm24@rm	; 	xcall	s1c17_0_imm13_imm24
	call	s1c17_0_imm13_imm24@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX179:				; __L179:
	ext	s1c17_sub_a@rm	; 	xcall	s1c17_sub_a
	call	s1c17_sub_a@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_sub_a_c_rd_rs
s1c17_sub_a_c_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX181		; 	xjreq	__L181
	call	s1c17_sub_a_rd_rs	; 	xcall	s1c17_sub_a_rd_rs
__LX181:				; __L181:
	ret
	.align	1
	.global	s1c17_sub_a_nc_rd_rs
s1c17_sub_a_nc_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX183		; 	xjrne	__L183
	call	s1c17_sub_a_rd_rs	; 	xcall	s1c17_sub_a_rd_rs
__LX183:				; __L183:
	ret
	.align	1
	.global	s1c17_sub_a_sp_rs
s1c17_sub_a_sp_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ext	s1c17_cpu+0x2c@h	; 	xld.w	%r0,s1c17_cpu+0x2c
	ext	s1c17_cpu+0x2c@m
	ld.w	%r0,s1c17_cpu+0x2c@l
	ld.h	%r10,[%r0]	; 	xld.h	%r10,[%r0]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX185		; 	xjrne	__L185
	sub	%r0,0x8		; 	xsub	%r0,%r0,8
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	ext	s1c17_sub_a@rm	; 	xcall	s1c17_sub_a
	call	s1c17_sub_a@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	jp	__LX186		; 	xjp	__L186
__LX185:				; __L185:
	ext	s1c17_0_imm13_imm24@rm	; 	xcall	s1c17_0_imm13_imm24
	call	s1c17_0_imm13_imm24@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
	ext	s1c17_sub_a@rm	; 	xcall	s1c17_sub_a
	call	s1c17_sub_a@rl
	ext	0x8		; 	xsub	%r11,%r0,8
	sub	%r11,%r0
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
__LX186:				; __L186:
	ext	s1c17_cpu+0x24@h	; 	xld.w	%r11,s1c17_cpu+0x24
	ext	s1c17_cpu+0x24@m
	ld.w	%r11,s1c17_cpu+0x24@l
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_sub_a_rd_imm7
s1c17_sub_a_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sub_a@rm	; 	xcall	s1c17_sub_a
	call	s1c17_sub_a@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sub_a_sp_imm7
s1c17_sub_a_sp_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x24@h	; 	xld.w	%r0,s1c17_cpu+0x24
	ext	s1c17_cpu+0x24@m
	ld.w	%r0,s1c17_cpu+0x24@l
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sub_a@rm	; 	xcall	s1c17_sub_a
	call	s1c17_sub_a@rl
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sbc_rd_rs
s1c17_sbc_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX190		; 	xjrne	__L190
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX192		; 	xjp	__L192
__LX190:				; __L190:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX192:				; __L192:
	ext	s1c17_sbc@rm	; 	xcall	s1c17_sbc
	call	s1c17_sbc@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_sbc_c_rd_rs
s1c17_sbc_c_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX194		; 	xjreq	__L194
	call	s1c17_sbc_rd_rs	; 	xcall	s1c17_sbc_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	or	%r10,0x8	; 	xoor	%r10,%r10,0x00000008
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX194:				; __L194:
	popn	%r0
	ret
	.align	1
	.global	s1c17_sbc_nc_rd_rs
s1c17_sbc_nc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX196		; 	xjrne	__L196
	call	s1c17_sbc_rd_rs	; 	xcall	s1c17_sbc_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX196:				; __L196:
	popn	%r0
	ret
	.align	1
	.global	s1c17_sbc_rd_imm7
s1c17_sbc_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm16@rm	; 	xcall	s1c17_imm7_imm16
	call	s1c17_imm7_imm16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sbc@rm	; 	xcall	s1c17_sbc
	call	s1c17_sbc@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_rd_rs
s1c17_cmp_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX199		; 	xjrne	__L199
	ld.w	%r12,[%r12]	; 	xld.w	%r12,[%r12]
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	jp	__LX201		; 	xjp	__L201
__LX199:				; __L199:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
__LX201:				; __L201:
	ext	s1c17_sub@rm	; 	xcall	s1c17_sub
	call	s1c17_sub@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_c_rd_rs
s1c17_cmp_c_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX203		; 	xjreq	__L203
	call	s1c17_cmp_rd_rs	; 	xcall	s1c17_cmp_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	or	%r10,0x8	; 	xoor	%r10,%r10,0x00000008
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX203:				; __L203:
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_nc_rd_rs
s1c17_cmp_nc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX205		; 	xjrne	__L205
	call	s1c17_cmp_rd_rs	; 	xcall	s1c17_cmp_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX205:				; __L205:
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_rd_sign7
s1c17_cmp_rd_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign7_sign16@rm	; 	xcall	s1c17_sign7_sign16
	call	s1c17_sign7_sign16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sub@rm	; 	xcall	s1c17_sub
	call	s1c17_sub@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_a_rd_rs
s1c17_cmp_a_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX208		; 	xjrne	__L208
	ld.w	%r12,[%r12]	; 	xld.w	%r12,[%r12]
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	jp	__LX210		; 	xjp	__L210
__LX208:				; __L208:
	ext	s1c17_0_imm13_imm24@rm	; 	xcall	s1c17_0_imm13_imm24
	call	s1c17_0_imm13_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
__LX210:				; __L210:
	ext	s1c17_cmp_a@rm	; 	xcall	s1c17_cmp_a
	call	s1c17_cmp_a@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_a_c_rd_rs
s1c17_cmp_a_c_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX212		; 	xjreq	__L212
	call	s1c17_cmp_a_rd_rs	; 	xcall	s1c17_cmp_a_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	or	%r10,0x8	; 	xoor	%r10,%r10,0x00000008
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX212:				; __L212:
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_a_nc_rd_rs
s1c17_cmp_a_nc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX214		; 	xjrne	__L214
	call	s1c17_cmp_a_rd_rs	; 	xcall	s1c17_cmp_a_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX214:				; __L214:
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmp_a_rd_imm7
s1c17_cmp_a_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_cmp_a@rm	; 	xcall	s1c17_cmp_a
	call	s1c17_cmp_a@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmc_rd_rs
s1c17_cmc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX217		; 	xjrne	__L217
	ld.w	%r12,[%r12]	; 	xld.w	%r12,[%r12]
	ld.w	%r13,[%r0]	; 	xld.w	%r13,[%r0]
	jp	__LX219		; 	xjp	__L219
__LX217:				; __L217:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
__LX219:				; __L219:
	ext	s1c17_sbc@rm	; 	xcall	s1c17_sbc
	call	s1c17_sbc@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmc_c_rd_rs
s1c17_cmc_c_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX221		; 	xjreq	__L221
	call	s1c17_cmc_rd_rs	; 	xcall	s1c17_cmc_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	or	%r10,0x8	; 	xoor	%r10,%r10,0x00000008
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX221:				; __L221:
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmc_nc_rd_rs
s1c17_cmc_nc_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX223		; 	xjrne	__L223
	call	s1c17_cmc_rd_rs	; 	xcall	s1c17_cmc_rd_rs
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
__LX223:				; __L223:
	popn	%r0
	ret
	.align	1
	.global	s1c17_cmc_rd_sign7
s1c17_cmc_rd_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign7_sign16@rm	; 	xcall	s1c17_sign7_sign16
	call	s1c17_sign7_sign16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sbc@rm	; 	xcall	s1c17_sbc
	call	s1c17_sbc@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_and_rd_rs
s1c17_and_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX226		; 	xjrne	__L226
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX228		; 	xjp	__L228
__LX226:				; __L226:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX228:				; __L228:
	ext	s1c17_and@rm	; 	xcall	s1c17_and
	call	s1c17_and@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_and_c_rd_rs
s1c17_and_c_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX230		; 	xjreq	__L230
	call	s1c17_and_rd_rs	; 	xcall	s1c17_and_rd_rs
__LX230:				; __L230:
	ret
	.align	1
	.global	s1c17_and_nc_rd_rs
s1c17_and_nc_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX232		; 	xjrne	__L232
	call	s1c17_and_rd_rs	; 	xcall	s1c17_and_rd_rs
__LX232:				; __L232:
	ret
	.align	1
	.global	s1c17_and_rd_sign7
s1c17_and_rd_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign7_sign16@rm	; 	xcall	s1c17_sign7_sign16
	call	s1c17_sign7_sign16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_and@rm	; 	xcall	s1c17_and
	call	s1c17_and@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_or_rd_rs
s1c17_or_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX235		; 	xjrne	__L235
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX237		; 	xjp	__L237
__LX235:				; __L235:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX237:				; __L237:
	ext	s1c17_or@rm	; 	xcall	s1c17_or
	call	s1c17_or@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_or_c_rd_rs
s1c17_or_c_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX239		; 	xjreq	__L239
	call	s1c17_or_rd_rs	; 	xcall	s1c17_or_rd_rs
__LX239:				; __L239:
	ret
	.align	1
	.global	s1c17_or_nc_rd_rs
s1c17_or_nc_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX241		; 	xjrne	__L241
	call	s1c17_or_rd_rs	; 	xcall	s1c17_or_rd_rs
__LX241:				; __L241:
	ret
	.align	1
	.global	s1c17_or_rd_sign7
s1c17_or_rd_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign7_sign16@rm	; 	xcall	s1c17_sign7_sign16
	call	s1c17_sign7_sign16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_or@rm	; 	xcall	s1c17_or
	call	s1c17_or@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_xor_rd_rs
s1c17_xor_rd_rs:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX244		; 	xjrne	__L244
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	jp	__LX246		; 	xjp	__L246
__LX244:				; __L244:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,[%r1]	; 	xld.w	%r12,[%r1]
	ld.w	%r13,%r10
__LX246:				; __L246:
	ext	s1c17_xor@rm	; 	xcall	s1c17_xor
	call	s1c17_xor@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_xor_c_rd_rs
s1c17_xor_c_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX248		; 	xjreq	__L248
	call	s1c17_xor_rd_rs	; 	xcall	s1c17_xor_rd_rs
__LX248:				; __L248:
	ret
	.align	1
	.global	s1c17_xor_nc_rd_rs
s1c17_xor_nc_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX250		; 	xjrne	__L250
	call	s1c17_xor_rd_rs	; 	xcall	s1c17_xor_rd_rs
__LX250:				; __L250:
	ret
	.align	1
	.global	s1c17_xor_rd_sign7
s1c17_xor_rd_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign7_sign16@rm	; 	xcall	s1c17_sign7_sign16
	call	s1c17_sign7_sign16@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_xor@rm	; 	xcall	s1c17_xor
	call	s1c17_xor@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_not_rd_rs
s1c17_not_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	s1c17_cpu+0x2c@ah	; 	xld.h	%r10,[s1c17_cpu+0x2c]
	ext	s1c17_cpu+0x2c@al
	ld.h	%r10,[%r8]
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jrne	__LX253		; 	xjrne	__L253
	ld.w	%r12,[%r13]	; 	xld.w	%r12,[%r13]
	jp	__LX255		; 	xjp	__L255
__LX253:				; __L253:
	ext	s1c17_0_imm13_imm16@rm	; 	xcall	s1c17_0_imm13_imm16
	call	s1c17_0_imm13_imm16@rl
	ld.w	%r12,%r10
__LX255:				; __L255:
	ext	s1c17_not@rm	; 	xcall	s1c17_not
	call	s1c17_not@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_not_c_rd_rs
s1c17_not_c_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX257		; 	xjreq	__L257
	call	s1c17_not_rd_rs	; 	xcall	s1c17_not_rd_rs
__LX257:				; __L257:
	ret
	.align	1
	.global	s1c17_not_nc_rd_rs
s1c17_not_nc_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX259		; 	xjrne	__L259
	call	s1c17_not_rd_rs	; 	xcall	s1c17_not_rd_rs
__LX259:				; __L259:
	ret
	.align	1
	.global	s1c17_not_rd_sign7
s1c17_not_rd_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign7_sign16@rm	; 	xcall	s1c17_sign7_sign16
	call	s1c17_sign7_sign16@rl
	ld.w	%r12,%r10
	ext	s1c17_not@rm	; 	xcall	s1c17_not
	call	s1c17_not@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_jpr_sign10
s1c17_jpr_sign10:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign11_sign24@rm	; 	xcall	s1c17_sign11_sign24
	call	s1c17_sign11_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_jpr_rb
s1c17_jpr_rb:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,%r12
	ld.w	%r12,[%r13]	; 	xld.w	%r12,[%r13]
	ld.w	%r13,%r10
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
	ret
	.align	1
	.global	s1c17_jpa_imm7
s1c17_jpa_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpa@rm	; 	xcall	s1c17_jpa
	call	s1c17_jpa@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_jpa_rb
s1c17_jpa_rb:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,%r12
	ld.w	%r12,[%r13]	; 	xld.w	%r12,[%r13]
	ld.w	%r13,%r10
	ext	s1c17_jpa@rm	; 	xcall	s1c17_jpa
	call	s1c17_jpa@rl
	ret
	.align	1
	.global	s1c17_jrgt_sign7
s1c17_jrgt_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	ld.w	%r12,%r10
	srl	%r12,0x1	; 	xsrl	%r12,1
	and	%r12,0x1	; 	xand	%r12,%r12,0x00000001
	ld.w	%r11,%r10
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	srl	%r10,0x2	; 	xsrl	%r10,2
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	xor	%r11,%r10
	or	%r12,%r11
	jrne	__LX266		; 	xjrne	__L266
	ld.w	%r12,%r13
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX266:				; __L266:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jrge_sign7
s1c17_jrge_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	ld.w	%r11,%r10
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	srl	%r10,0x2	; 	xsrl	%r10,2
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	cmp	%r11,%r10
	jrne	__LX268		; 	xjrne	__L268
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX268:				; __L268:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jrlt_sign7
s1c17_jrlt_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	ld.w	%r11,%r10
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	srl	%r10,0x2	; 	xsrl	%r10,2
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	cmp	%r11,%r10
	jreq	__LX270		; 	xjreq	__L270
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX270:				; __L270:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jrle_sign7
s1c17_jrle_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	ld.w	%r12,%r10
	srl	%r12,0x1	; 	xsrl	%r12,1
	and	%r12,0x1	; 	xand	%r12,%r12,0x00000001
	ld.w	%r11,%r10
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	srl	%r10,0x2	; 	xsrl	%r10,2
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	xor	%r11,%r10
	or	%r12,%r11
	jreq	__LX272		; 	xjreq	__L272
	ld.w	%r12,%r13
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX272:				; __L272:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jrugt_sign7
s1c17_jrugt_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	ld.w	%r11,%r10
	srl	%r11,0x1	; 	xsrl	%r11,1
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	srl	%r10,0x3	; 	xsrl	%r10,3
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	or	%r11,%r10
	jrne	__LX274		; 	xjrne	__L274
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX274:				; __L274:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jruge_sign7
s1c17_jruge_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jrne	__LX276		; 	xjrne	__L276
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX276:				; __L276:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jrult_sign7
s1c17_jrult_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x8	; 	xand	%r10,%r10,0x00000008
	jreq	__LX278		; 	xjreq	__L278
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX278:				; __L278:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jrule_sign7
s1c17_jrule_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	ld.w	%r11,%r10
	srl	%r11,0x1	; 	xsrl	%r11,1
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	srl	%r10,0x3	; 	xsrl	%r10,3
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	or	%r11,%r10
	jreq	__LX280		; 	xjreq	__L280
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX280:				; __L280:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jreq_sign7
s1c17_jreq_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x2	; 	xand	%r10,%r10,0x00000002
	jreq	__LX282		; 	xjreq	__L282
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX282:				; __L282:
	popn	%r0
	ret
	.align	1
	.global	s1c17_jrne_sign7
s1c17_jrne_sign7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r10,[%r8]
	and	%r10,0x2	; 	xand	%r10,%r10,0x00000002
	jrne	__LX284		; 	xjrne	__L284
	ext	s1c17_sign8_sign21_sign24@rm	; 	xcall	s1c17_sign8_sign21_sign24
	call	s1c17_sign8_sign21_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_jpr@rm	; 	xcall	s1c17_jpr
	call	s1c17_jpr@rl
__LX284:				; __L284:
	popn	%r0
	ret
	.align	1
	.global	s1c17_call_sign10
s1c17_call_sign10:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_sign11_sign24@rm	; 	xcall	s1c17_sign11_sign24
	call	s1c17_sign11_sign24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_call@rm	; 	xcall	s1c17_call
	call	s1c17_call@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_call_rb
s1c17_call_rb:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,%r12
	ld.w	%r12,[%r13]	; 	xld.w	%r12,[%r13]
	ld.w	%r13,%r10
	ext	s1c17_call@rm	; 	xcall	s1c17_call
	call	s1c17_call@rl
	ret
	.align	1
	.global	s1c17_calla_imm7
s1c17_calla_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,%r10
	ld.w	%r13,%r0
	ext	s1c17_calla@rm	; 	xcall	s1c17_calla
	call	s1c17_calla@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_calla_rb
s1c17_calla_rb:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,%r12
	ld.w	%r12,[%r13]	; 	xld.w	%r12,[%r13]
	ld.w	%r13,%r10
	ext	s1c17_calla@rm	; 	xcall	s1c17_calla
	call	s1c17_calla@rl
	ret
	.align	1
	.global	s1c17_ret
s1c17_ret:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r0,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r0,s1c17_cpu+0x20@l
	ld.ub	%r1,[%r0]	; 	xld.ub	%r1,[%r0]
	call	s1c17_reti	; 	xcall	s1c17_reti
	ld.b	[%r0],%r1	; 	xld.b	[%r0],%r1
	popn	%r1
	ret
	.align	1
	.global	s1c17_int_imm5
s1c17_int_imm5:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_int@rm	; 	xcall	s1c17_int
	call	s1c17_int@rl
	ret
	.align	1
	.global	s1c17_intl_imm5_imm3
s1c17_intl_imm5_imm3:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_int@rm	; 	xcall	s1c17_int
	call	s1c17_int@rl
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r11,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r11,s1c17_cpu+0x20@l
	and	%r0,0x1		; 	xand	%r0,%r0,0x00000001
	sll	%r0,0x5		; 	xsll	%r0,5
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	ext	0x1fff		; 	xand	%r10,%r10,0xffffffdf
	and	%r10,0x1f
	or	%r10,%r0
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_reti
s1c17_reti:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r0,%r12
	ext	s1c17_cpu+0x24@h	; 	xld.w	%r1,s1c17_cpu+0x24
	ext	s1c17_cpu+0x24@m
	ld.w	%r1,s1c17_cpu+0x24@l
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	%r2,%r10
	ld.w	%r10,[%r1]	; 	xld.w	%r10,[%r1]
	add	%r10,0x4	; 	xadd	%r10,%r10,4
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	cmp	%r0,0x0
	jreq	__LX293		; 	xjreq	__L293
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
	ext	0xa		; 	xld.h	[%r1+0xa],%r10
	ld.h	[%r1],%r10
	ext	0x8		; 	xld.h	[%r1+0x8],%r10
	ld.h	[%r1],%r10
	ext	s1c17_cpu_exec@rm	; 	xcall	s1c17_cpu_exec
	call	s1c17_cpu_exec@rl
__LX293:				; __L293:
	ld.w	%r10,%r2
	ext	0x1f		; 	xand	%r10,%r10,0x00fffffe
	ext	0x1fff
	and	%r10,0x3e
	ext	0x4		; 	xld.w	[%r1+0x4],%r10
	ld.w	[%r1],%r10
	ext	0x4		; 	xsub	%r11,%r1,4
	sub	%r11,%r1
	ld.w	%r10,%r2
	sra	%r10,0x8	; 	xsra	%r10,24
	sra	%r10,0x8
	sra	%r10,0x8
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
	popn	%r2
	ret
	.align	1
	.global	s1c17_brk
s1c17_brk:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	0x1f		; 	xld.w	%r13,0x00ffff90		; 16777104
	ext	0x1ffe
	ld.w	%r13,0x10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	%r0,%r10
	ext	s1c17_cpu+0x28@h	; 	xld.w	%r1,s1c17_cpu+0x28
	ext	s1c17_cpu+0x28@m
	ld.w	%r1,s1c17_cpu+0x28@l
	ext	0x8		; 	xsub	%r2,%r1,8
	sub	%r2,%r1
	ld.ub	%r10,[%r2]	; 	xld.ub	%r10,[%r2]
	sll	%r10,0x8	; 	xsll	%r10,24
	sll	%r10,0x8
	sll	%r10,0x8
	ld.w	%r14,[%r1]	; 	xld.w	%r14,[%r1]
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r0
	or	%r14,%r10
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ext	0x28		; 	xsub	%r10,%r1,40
	sub	%r10,%r1
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	0x4		; 	xadd	%r13,%r0,4
	add	%r13,%r0
	ld.w	%r14,[%r10]	; 	xld.w	%r14,[%r10]
	ext	s1c17_bcu_write@rm	; 	xcall	s1c17_bcu_write
	call	s1c17_bcu_write@rl
	ld.w	%r12,0x2	; 	xld.w	%r12,0x00000002		; 2
	ext	0x14c		; 	xld.w	%r13,0x00005326		; 21286
	ld.w	%r13,0x26
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	0x4		; 	xand	%r10,%r10,0x00000100
	and	%r10,0x0
	ld.w	%r11,0x0
	jrne	__LX295		; 	xjrne	__L295
	ext	0x1f		; 	xld.w	%r11,0x00fffc00		; 16776192
	ext	0x1ff0
	ld.w	%r11,0x0
__LX295:				; __L295:
	ld.w	[%r1],%r11	; 	xld.w	[%r1],%r11
	ld.w	%r10,[%r2]	; 	xld.w	%r10,[%r2]
	and	%r10,0x2f	; 	xand	%r10,%r10,0xffffffef
	ld.w	[%r2],%r10	; 	xld.w	[%r2],%r10
	popn	%r2
	ret
	.align	1
	.global	s1c17_retd
s1c17_retd:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	0x1f		; 	xld.w	%r13,0x00ffff90		; 16777104
	ext	0x1ffe
	ld.w	%r13,0x10
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ld.w	%r1,%r10
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ld.w	%r13,%r1
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	s1c17_cpu+0x28@h	; 	xld.w	%r0,s1c17_cpu+0x28
	ext	s1c17_cpu+0x28@m
	ld.w	%r0,s1c17_cpu+0x28@l
	ld.w	%r11,%r10
	ext	0x1f		; 	xand	%r11,%r11,0x00fffffe
	ext	0x1fff
	and	%r11,0x3e
	ld.w	[%r0],%r11	; 	xld.w	[%r0],%r11
	ext	0x8		; 	xsub	%r11,%r0,8
	sub	%r11,%r0
	sra	%r10,0x8	; 	xsra	%r10,24
	sra	%r10,0x8
	sra	%r10,0x8
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	0x4		; 	xadd	%r13,%r1,4
	add	%r13,%r1
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	sub	%r0,0x28	; 	xsub	%r0,%r0,40
	ext	0x1f		; 	xand	%r10,%r10,0x00ffffff
	ext	0x1fff
	and	%r10,0x3f
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_ext_imm13
s1c17_ext_imm13:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ext	s1c17_cpu+0x2e@h	; 	xld.w	%r0,s1c17_cpu+0x2e
	ext	s1c17_cpu+0x2e@m
	ld.w	%r0,s1c17_cpu+0x2e@l
	ext	0x2		; 	xsub	%r1,%r0,2
	sub	%r1,%r0
	ld.uh	%r10,[%r1]	; 	xld.uh	%r10,[%r1]
	ld.h	[%r0],%r10	; 	xld.h	[%r0],%r10
	ld.h	[%r1],%r12	; 	xld.h	[%r1],%r12
	ext	s1c17_cpu_exec@rm	; 	xcall	s1c17_cpu_exec
	call	s1c17_cpu_exec@rl
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
	ld.h	[%r0],%r10	; 	xld.h	[%r0],%r10
	ld.h	[%r1],%r10	; 	xld.h	[%r1],%r10
	popn	%r1
	ret
	.align	1
	.global	s1c17_sr_rd_rs
s1c17_sr_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r13]	; 	xld.w	%r13,[%r13]
	ext	s1c17_sr@rm	; 	xcall	s1c17_sr
	call	s1c17_sr@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sr_rd_imm7
s1c17_sr_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sr@rm	; 	xcall	s1c17_sr
	call	s1c17_sr@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sa_rd_rs
s1c17_sa_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r13]	; 	xld.w	%r13,[%r13]
	ext	s1c17_sa@rm	; 	xcall	s1c17_sa
	call	s1c17_sa@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sa_rd_imm7
s1c17_sa_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sa@rm	; 	xcall	s1c17_sa
	call	s1c17_sa@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sl_rd_rs
s1c17_sl_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r13]	; 	xld.w	%r13,[%r13]
	ext	s1c17_sl@rm	; 	xcall	s1c17_sl
	call	s1c17_sl@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_sl_rd_imm7
s1c17_sl_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_sl@rm	; 	xcall	s1c17_sl
	call	s1c17_sl@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_swap_rd_rs
s1c17_swap_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.ub	%r10,[%r13]	; 	xld.ub	%r10,[%r13]
	sll	%r10,0x8	; 	xsll	%r10,8
	ext	0x1		; 	xld.ub	%r11,[%r13+0x1]
	ld.ub	%r11,[%r13]
	or	%r10,%r11
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_cv_ab_rd_rs
s1c17_cv_ab_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.b	%r10,[%r13]	; 	xld.b	%r10,[%r13]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_cv_as_rd_rs
s1c17_cv_as_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.h	%r10,[%r13]	; 	xld.h	%r10,[%r13]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_cv_al_rd_rs
s1c17_cv_al_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.uh	%r11,[%r12]	; 	xld.uh	%r11,[%r12]
	ld.w	%r10,[%r13]	; 	xld.w	%r10,[%r13]
	sll	%r10,0x8	; 	xsll	%r10,16
	sll	%r10,0x8
	or	%r11,%r10
	ld.w	[%r12],%r11	; 	xld.w	[%r12],%r11
	ret
	.align	1
	.global	s1c17_cv_la_rd_rs
s1c17_cv_la_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x2		; 	xld.h	%r10,[%r13+0x2]
	ld.h	%r10,[%r13]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_cv_ls_rd_rs
s1c17_cv_ls_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.h	%r10,[%r13]	; 	xld.h	%r10,[%r13]
	srl	%r10,0x8	; 	xsrl	%r10,16
	srl	%r10,0x8
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.align	1
	.global	s1c17_nop
s1c17_nop:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ret
	.align	1
	.global	s1c17_halt
s1c17_halt:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_mode+0x0@ah	; 	xld.ub	%r10,[s1c17_mode]
	ext	s1c17_mode+0x0@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX313		; 	xjrne	__L313
	ld.w	%r10,0x2	; 	xld.w	%r10,0x00000002		; 2
	ext	s1c17_mode+0x0@ah	; 	xld.b	[s1c17_mode],%r10
	ext	s1c17_mode+0x0@al
	ld.b	[%r8],%r10
__LX313:				; __L313:
	ret
	.align	1
	.global	s1c17_slp
s1c17_slp:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_mode+0x0@ah	; 	xld.ub	%r10,[s1c17_mode]
	ext	s1c17_mode+0x0@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX315		; 	xjrne	__L315
	ld.w	%r10,0x3	; 	xld.w	%r10,0x00000003		; 3
	ext	s1c17_mode+0x0@ah	; 	xld.b	[s1c17_mode],%r10
	ext	s1c17_mode+0x0@al
	ld.b	[%r8],%r10
__LX315:				; __L315:
	ret
	.align	1
	.global	s1c17_ei
s1c17_ei:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r11,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r11,s1c17_cpu+0x20@l
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	or	%r10,0x10	; 	xoor	%r10,%r10,0x00000010
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	ret
	.align	1
	.global	s1c17_di
s1c17_di:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r11,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r11,s1c17_cpu+0x20@l
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	and	%r10,0x2f	; 	xand	%r10,%r10,0xffffffef
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	ret
	.align	1
	.global	s1c17_ld_cw_rd_rs
s1c17_ld_cw_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r12,[%r12]	; 	xld.w	%r12,[%r12]
	ld.w	%r13,[%r13]	; 	xld.w	%r13,[%r13]
	call	s1c17_ld_cw	; 	xcall	s1c17_ld_cw
	ret
	.align	1
	.global	s1c17_ld_cw_rd_imm7
s1c17_ld_cw_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	call	s1c17_ld_cw	; 	xcall	s1c17_ld_cw
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_ca_rd_rs
s1c17_ld_ca_rd_rs:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r13]	; 	xld.w	%r13,[%r13]
	call	s1c17_ld_ca	; 	xcall	s1c17_ld_ca
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_ca_rd_imm7
s1c17_ld_ca_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	call	s1c17_ld_ca	; 	xcall	s1c17_ld_ca
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_cf_rd_rs
s1c17_ld_cf_rd_rs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r12,[%r12]	; 	xld.w	%r12,[%r12]
	ld.w	%r13,[%r13]	; 	xld.w	%r13,[%r13]
	ext	s1c17_ld_cf@rm	; 	xcall	s1c17_ld_cf
	call	s1c17_ld_cf@rl
	ret
	.align	1
	.global	s1c17_ld_cf_rd_imm7
s1c17_ld_cf_rd_imm7:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	s1c17_imm7_imm20_imm24@rm	; 	xcall	s1c17_imm7_imm20_imm24
	call	s1c17_imm7_imm20_imm24@rl
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r10
	ext	s1c17_ld_cf@rm	; 	xcall	s1c17_ld_cf
	call	s1c17_ld_cf@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_ld_cw
s1c17_ld_cw:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_coprocessor+0x0@h	; 	xld.w	%r11,s1c17_coprocessor
	ext	s1c17_coprocessor+0x0@m
	ld.w	%r11,s1c17_coprocessor+0x0@l
	ld.w	%r10,%r13
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	ld.b	[%r11],%r10	; 	xld.b	[%r11],%r10
	sra	%r13,0x4	; 	xsra	%r13,4
	and	%r13,0x7	; 	xand	%r13,%r13,0x00000007
	ext	0x1		; 	xld.b	[%r11+0x1],%r13
	ld.b	[%r11],%r13
	cmp	%r10,0x0
	jrne	__LX325		; 	xjrne	__L325
	ext	0x4		; 	xld.w	[%r11+0x4],%r10
	ld.w	[%r11],%r10
__LX325:				; __L325:
	ret
	.align	1
	.global	s1c17_ld_ca
s1c17_ld_ca:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r2,%r12
	ld.w	%r1,%r13
	ext	s1c17_coprocessor+0x0@h	; 	xld.w	%r11,s1c17_coprocessor
	ext	s1c17_coprocessor+0x0@m
	ld.w	%r11,s1c17_coprocessor+0x0@l
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	cmp	%r10,0x3	; 	xcmp	%r10,3
	jreq	__LX327		; 	xjreq	__L327
	ld.w	%r14,0x0
	ext	0x2		; 	xld.b	[%r11+0x2],%r14
	ld.b	[%r11],%r14
__LX327:				; __L327:
	btst	[%r11],0x0	; 	xbtst	[%r11],0x0
	jreq	__LX328		; 	xjreq	__L328
	ld.h	%r2,%r2
	ld.h	%r1,%r1
	jp	__LX329		; 	xjp	__L329
__LX328:				; __L328:
	ld.uh	%r2,%r2
	ld.uh	%r1,%r1
__LX329:				; __L329:
	ext	s1c17_coprocessor+0x0@ah	; 	xld.ub	%r10,[s1c17_coprocessor]
	ext	s1c17_coprocessor+0x0@al
	ld.ub	%r10,[%r8]
	sub	%r10,0x4	; 	xsub	%r10,%r10,4
	cmp	%r10,0x5	; 	xcmp	%r10,5
	jrugt	__L330		; 	xjrugt	__L330
	sll	%r10,0x2	; 	xsll	%r10,2
	ext	__L338+0x0@h	; 	xld.w	%r10,[%r10+__L338]
	ext	__L338+0x0@m
	ld.w	%r9,__L338+0x0@l
	add	%r9,%r10
	ld.w	%r10,[%r9]
	jp	%r10
	.code
	.align	2
__L338:
	.word	__L332
	.word	__L332
	.word	__L330
	.word	__L333
	.word	__L335
	.word	__L335
	.code
__L332:
	mlt.w	%r2,%r1
	ld.w	%r14,%alr
	ext	s1c17_coprocessor+0x4@ah	; 	xld.w	[s1c17_coprocessor+0x4],%r14
	ext	s1c17_coprocessor+0x4@al
	ld.w	[%r8],%r14
	jp	__L330		; 	xjp	__L330
__L333:
	mlt.w	%r2,%r1
	ld.w	%r2,%alr
	ext	s1c17_coprocessor+0x4@h	; 	xld.w	%r12,s1c17_coprocessor+0x4
	ext	s1c17_coprocessor+0x4@m
	ld.w	%r12,s1c17_coprocessor+0x4@l
	ld.w	%r1,[%r12]	; 	xld.w	%r1,[%r12]
	ld.w	%r11,%r1
	add	%r11,%r2
	ld.w	[%r12],%r11	; 	xld.w	[%r12],%r11
	sub	%r12,0x2	; 	xsub	%r12,%r12,2
	ld.w	%r10,%r2
	xor	%r10,%r1
	not	%r10,%r10
	xor	%r2,%r11
	ld.w	%r11,%r2
	and	%r10,%r11
	srl	%r10,0x8	; 	xsrl	%r10,31
	srl	%r10,0x8
	srl	%r10,0x8
	srl	%r10,0x7
	ld.b	[%r12],%r10	; 	xld.b	[%r12],%r10
	jp	__L330		; 	xjp	__L330
__L335:
	cmp	%r1,0x0
	jreq	__LX336		; 	xjreq	__L336
	ext	s1c17_coprocessor+0x4@h	; 	xld.w	%r0,s1c17_coprocessor+0x4
	ext	s1c17_coprocessor+0x4@m
	ld.w	%r0,s1c17_coprocessor+0x4@l
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.h	[%r0],%r10	; 	xld.h	[%r0],%r10
	add	%r0,0x2		; 	xadd	%r0,%r0,2
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	ext	__modsi3@rm	; 	xcall	__modsi3
	call	__modsi3@rl
	ld.h	[%r0],%r10	; 	xld.h	[%r0],%r10
	jp	__L330		; 	xjp	__L330
__LX336:				; __L336:
	ext	s1c17_coprocessor+0x4@h	; 	xld.w	%r11,s1c17_coprocessor+0x4
	ext	s1c17_coprocessor+0x4@m
	ld.w	%r11,s1c17_coprocessor+0x4@l
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
	ld.h	[%r11],%r10	; 	xld.h	[%r11],%r10
	ext	0x2		; 	xld.h	[%r11+0x2],%r2
	ld.h	[%r11],%r2
__L330:
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r12,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r12,s1c17_cpu+0x20@l
	ld.w	%r11,[%r12]	; 	xld.w	%r11,[%r12]
	ld.w	%r10,%r11
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	s1c17_coprocessor+0x2@h	; 	xld.w	%r13,s1c17_coprocessor+0x2
	ext	s1c17_coprocessor+0x2@m
	ld.w	%r13,s1c17_coprocessor+0x2@l
	ld.ub	%r10,[%r13]	; 	xld.ub	%r10,[%r13]
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	sll	%r10,0x2	; 	xsll	%r10,2
	and	%r11,0x38	; 	xand	%r11,%r11,0xfffffff8
	or	%r11,%r10
	and	%r11,0x37	; 	xand	%r11,%r11,0xfffffff7
	ld.w	[%r12],%r11	; 	xld.w	[%r12],%r11
	ext	0x1		; 	xsub	%r10,%r13,1
	sub	%r10,%r13
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r10,0x0
	jreq	__LX340		; 	xjreq	__L340
	ext	0x4		; 	xld.uh	%r10,[%r13+0x4]
	ld.uh	%r10,[%r13]
	jp	__LX342		; 	xjp	__L342
__LX340:				; __L340:
	ext	0x2		; 	xld.uh	%r10,[%r13+0x2]
	ld.uh	%r10,[%r13]
__LX342:				; __L342:
	popn	%r2
	ret
	.align	1
	.global	s1c17_ld_cf
s1c17_ld_cf:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_coprocessor+0x0@h	; 	xld.w	%r11,s1c17_coprocessor
	ext	s1c17_coprocessor+0x0@m
	ld.w	%r11,s1c17_coprocessor+0x0@l
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	cmp	%r10,0x3	; 	xcmp	%r10,3
	jreq	__LX344		; 	xjreq	__L344
	ld.w	%r14,0x0
	ext	0x2		; 	xld.b	[%r11+0x2],%r14
	ld.b	[%r11],%r14
__LX344:				; __L344:
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jreq	__LX346		; 	xjreq	__L346
	cmp	%r10,0x2	; 	xcmp	%r10,2
	jreq	__LX347		; 	xjreq	__L347
	jp	__LX345		; 	xjp	__L345
__LX346:				; __L346:
	ext	0x4		; 	xld.h	[%r11+0x4],%r13
	ld.h	[%r11],%r13
	ld.w	%r14,0x0
	ext	0x6		; 	xld.h	[%r11+0x6],%r14
	ld.h	[%r11],%r14
	jp	__LX345		; 	xjp	__L345
__LX347:				; __L347:
	ext	0x4		; 	xld.h	[%r11+0x4],%r13
	ld.h	[%r11],%r13
	ext	0x6		; 	xld.h	[%r11+0x6],%r12
	ld.h	[%r11],%r12
__LX345:				; __L345:
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r12,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r12,s1c17_cpu+0x20@l
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ld.w	%r11,%r10
	and	%r11,0x3c	; 	xand	%r11,%r11,0xfffffffc
	ld.w	[%r12],%r11	; 	xld.w	[%r12],%r11
	ext	s1c17_coprocessor+0x2@ah	; 	xld.ub	%r11,[s1c17_coprocessor+0x2]
	ext	s1c17_coprocessor+0x2@al
	ld.ub	%r11,[%r8]
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	sll	%r11,0x2	; 	xsll	%r11,2
	and	%r10,0x38	; 	xand	%r10,%r10,0xfffffff8
	or	%r10,%r11
	and	%r10,0x37	; 	xand	%r10,%r10,0xfffffff7
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ret
	.global	s1c17_device_tbl
	.data
	.align	2
s1c17_device_tbl:
	.word	0
	.word	12287
	.word	4
	.word	s1c17_iram_read
	.word	s1c17_iram_write
	.space	4
	.word	16928
	.word	16959
	.word	2
	.word	s1c17_t16_0_read
	.word	s1c17_t16_0_write
	.space	4
	.word	16960
	.word	16991
	.word	2
	.word	s1c17_t16_1_read
	.word	s1c17_t16_1_write
	.space	4
	.word	16992
	.word	17023
	.word	2
	.word	s1c17_t16_2_read
	.word	s1c17_t16_2_write
	.space	4
	.word	17152
	.word	17183
	.word	2
	.word	s1c17_itc_read
	.word	s1c17_itc_write
	.space	4
	.word	20576
	.word	20607
	.word	1
	.word	s1c17_osc_read
	.word	s1c17_osc_write
	.space	4
	.word	20640
	.word	20671
	.word	1
	.word	s1c17_lcd_read
	.word	s1c17_lcd_write
	.space	4
	.word	20992
	.word	21119
	.word	1
	.word	s1c17_p_read
	.word	s1c17_p_write
	.space	4
	.word	21280
	.word	21311
	.word	2
	.word	s1c17_misc_read
	.word	s1c17_misc_write
	.space	4
	.word	32768
	.word	163839
	.word	2
	.word	s1c17_flash_read
	.word	s1c17_flash_write
	.space	4
	.word	524288
	.word	525663
	.word	1
	.word	s1c17_sram_read
	.word	s1c17_sram_write
	.space	4
	.word	16777088
	.word	16777215
	.word	4
	.word	s1c17_dbg_read
	.word	s1c17_dbg_write
	.space	4
	.code
	.align	1
s1c17_dummy_read:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,0x0
	ret
	.align	1
s1c17_dummy_write:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ret
	.global	s1c17_device_dummy
	.data
	.align	2
s1c17_device_dummy:
	.word	0
	.word	0
	.word	4
	.word	s1c17_dummy_read
	.word	s1c17_dummy_write
	.space	4
	.code
	.align	1
	.global	s1c17_bcu_init
s1c17_bcu_init:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_device_tbl+0x0@h	; 	xld.w	%r10,s1c17_device_tbl
	ext	s1c17_device_tbl+0x0@m
	ld.w	%r10,s1c17_device_tbl+0x0@l
	ext	s1c17_device_root+0x0@ah	; 	xld.w	[s1c17_device_root],%r10
	ext	s1c17_device_root+0x0@al
	ld.w	[%r8],%r10
	ld.w	%r14,0x18	; 	xld.w	%r14,0x00000018		; 24
	ext	0x18		; 	xadd	%r13,%r10,24
	add	%r13,%r10
	ld.w	%r12,0xa	; 	xld.w	%r12,0x0000000a		; 10
__LX356:				; __L356:
	mlt.w	%r12,%r14
	ld.w	%r11,%alr
	ld.w	%r10,%r11
	add	%r10,%r13
	ext	s1c17_device_tbl+0x14@h	; 	xld.w	[%r11+s1c17_device_tbl+0x14],%r10
	ext	s1c17_device_tbl+0x14@m
	ld.w	%r9,s1c17_device_tbl+0x14@l
	add	%r9,%r11
	ld.w	[%r9],%r10
	sub	%r12,0x1	; 	xsub	%r12,%r12,1
	jrge	__LX356		; 	xjrge	__L356
	ld.w	%r15,0x0
	ext	s1c17_device_tbl+0x11c@ah	; 	xld.w	[s1c17_device_tbl+0x11c],%r15
	ext	s1c17_device_tbl+0x11c@al
	ld.w	[%r8],%r15
	ret
	.align	1
	.global	s1c17_iram_init
s1c17_iram_init:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_iram+0x0@h	; 	xld.w	%r12,s1c17_iram
	ext	s1c17_iram+0x0@m
	ld.w	%r12,s1c17_iram+0x0@l
	ld.w	%r13,0x0
	ext	0xc0		; 	xld.w	%r14,0x00003000		; 12288
	ld.w	%r14,0x0
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ret
; APP

		.code
		.align		1
		.global		s1c17_iram_read
		.global		s1c17_iram_write
		;//-------------------------------------;//
s1c17_iram_read:
	ext	s1c17_iram+0x0@h	; 		Xld.w		%r14, s1c17_iram
	ext	s1c17_iram+0x0@m
	ld.w	%r14,s1c17_iram+0x0@l
	ext	s1c17_memget@rm	; 		Xjp		s1c17_memget
	jp	s1c17_memget@rl
		;//-------------------------------------;//
s1c17_iram_write:
	ext	s1c17_iram+0x0@h	; 		Xld.w		%r15, s1c17_iram
	ext	s1c17_iram+0x0@m
	ld.w	%r15,s1c17_iram+0x0@l
	ext	s1c17_memput@rm	; 		Xjp		s1c17_memput
	jp	s1c17_memput@rl

; NO_APP
	.code
	.align	2
init.410:
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	255
	.byte	255
	.byte	0
	.byte	4
	.byte	0
	.byte	0
	.align	2
__LC0:
	.ascii	"clipc17.$\000"
	.code
	.align	1
	.global	s1c17_t16_init
s1c17_t16_init:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ext	s1c17_t16+0x0@h	; 	xld.w	%r1,s1c17_t16
	ext	s1c17_t16+0x0@m
	ld.w	%r1,s1c17_t16+0x0@l
	ld.w	%r12,%r1
	ld.w	%r13,0x0
	ld.w	%r14,0x1e	; 	xld.w	%r14,0x0000001e		; 30
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	init.410+0x0@h	; 	xld.w	%r0,init.410
	ext	init.410+0x0@m
	ld.w	%r0,init.410+0x0@l
	ld.w	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,0xa	; 	xld.w	%r14,0x0000000a		; 10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0xa		; 	xadd	%r12,%r1,10
	add	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,0xa	; 	xld.w	%r14,0x0000000a		; 10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0x14		; 	xadd	%r12,%r1,20
	add	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,0xa	; 	xld.w	%r14,0x0000000a		; 10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_t16_0_read
s1c17_t16_0_read:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r14,0x0
	call	s1c17_t16_read	; 	xcall	s1c17_t16_read
	ret
	.align	1
	.global	s1c17_t16_1_read
s1c17_t16_1_read:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r14,0x1	; 	xld.w	%r14,0x00000001		; 1
	call	s1c17_t16_read	; 	xcall	s1c17_t16_read
	ret
	.align	1
	.global	s1c17_t16_2_read
s1c17_t16_2_read:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r14,0x2	; 	xld.w	%r14,0x00000002		; 2
	call	s1c17_t16_read	; 	xcall	s1c17_t16_read
	ret
	.align	1
	.global	s1c17_t16_read
s1c17_t16_read:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r15,%r12
	ld.w	%r4,0x0
	ld.w	[%sp+0x0],%r4	; 	xld.w	[%sp],%r4
	cmp	%r13,0x9	; 	xcmp	%r13,9
	jrugt	__LX365		; 	xjrugt	__L365
	ext	s1c17_t16+0x0@h	; 	xld.w	%r11,s1c17_t16
	ext	s1c17_t16+0x0@m
	ld.w	%r11,s1c17_t16+0x0@l
	ld.w	%r10,0xa	; 	xld.w	%r10,0x0000000a		; 10
	mlt.w	%r14,%r10
	ld.w	%r4,%alr
	add	%r4,%r13
	ld.w	%r13,%r4
	ld.w	%r12,%sp
	add	%r13,%r11
	ld.w	%r14,%r15
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX365:				; __L365:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_t16_0_write
s1c17_t16_0_write:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r15,0x0
	call	s1c17_t16_write	; 	xcall	s1c17_t16_write
	ret
	.align	1
	.global	s1c17_t16_1_write
s1c17_t16_1_write:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r15,0x1	; 	xld.w	%r15,0x00000001		; 1
	call	s1c17_t16_write	; 	xcall	s1c17_t16_write
	ret
	.align	1
	.global	s1c17_t16_2_write
s1c17_t16_2_write:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r15,0x2	; 	xld.w	%r15,0x00000002		; 2
	call	s1c17_t16_write	; 	xcall	s1c17_t16_write
	ret
	.align	1
	.global	s1c17_t16_write
s1c17_t16_write:
;	.frame	%sp,16,$31		# vars= 4, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r4,%r12
	ld.w	%r1,%r13
	ld.w	[%sp+0x0],%r14	; 	xld.w	[%sp],%r14
	cmp	%r1,0x1d	; 	xcmp	%r1,29
	jrugt	__LX370		; 	xjrugt	__L370
	cmp	%r1,0x8		; 	xcmp	%r1,8
	jrne	__LX371		; 	xjrne	__L371
	ld.w	%r10,%r14
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX371		; 	xjreq	__L371
	ld.w	%r10,0xa	; 	xld.w	%r10,0x0000000a		; 10
	mlt.w	%r15,%r10
	ld.w	%r10,%alr
	ext	s1c17_t16+0x8@h	; 	xld.uh	%r11,[%r10+s1c17_t16+0x8]
	ext	s1c17_t16+0x8@m
	ld.w	%r9,s1c17_t16+0x8@l
	add	%r9,%r10
	ld.uh	%r11,[%r9]
	ext	0x3ff		; 	xand	%r11,%r11,0x0000fffe
	and	%r11,0x3e
	ext	s1c17_t16+0x8@h	; 	xld.h	[%r10+s1c17_t16+0x8],%r11
	ext	s1c17_t16+0x8@m
	ld.w	%r9,s1c17_t16+0x8@l
	add	%r9,%r10
	ld.h	[%r9],%r11
	ld.w	%r10,%r14
	and	%r10,0x3e	; 	xand	%r10,%r10,0xfffffffe
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
__LX371:				; __L371:
	ext	s1c17_t16+0x0@h	; 	xld.w	%r11,s1c17_t16
	ext	s1c17_t16+0x0@m
	ld.w	%r11,s1c17_t16+0x0@l
	ld.w	%r10,0xa	; 	xld.w	%r10,0x0000000a		; 10
	mlt.w	%r15,%r10
	ld.w	%r0,%alr
	ld.w	%r12,%r0
	add	%r12,%r1
	add	%r12,%r11
	ld.w	%r13,%sp
	ld.w	%r14,%r4
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ld.w	%r10,%r1
	and	%r10,0x3e	; 	xand	%r10,%r10,0xfffffffe
	cmp	%r10,0x6	; 	xcmp	%r10,6
	jrne	__LX370		; 	xjrne	__L370
	ext	s1c17_t16+0x6@h	; 	xld.uh	%r10,[%r0+s1c17_t16+0x6]
	ext	s1c17_t16+0x6@m
	ld.w	%r9,s1c17_t16+0x6@l
	add	%r9,%r0
	ld.uh	%r10,[%r9]
	srl	%r10,0x1	; 	xsrl	%r10,1
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX370		; 	xjreq	__L370
	ext	s1c17_t16+0x2@h	; 	xld.uh	%r10,[%r0+s1c17_t16+0x2]
	ext	s1c17_t16+0x2@m
	ld.w	%r9,s1c17_t16+0x2@l
	add	%r9,%r0
	ld.uh	%r10,[%r9]
	ext	s1c17_t16+0x4@h	; 	xld.h	[%r0+s1c17_t16+0x4],%r10
	ext	s1c17_t16+0x4@m
	ld.w	%r9,s1c17_t16+0x4@l
	add	%r9,%r0
	ld.h	[%r9],%r10
	ext	s1c17_t16+0x6@h	; 	xld.uh	%r10,[%r0+s1c17_t16+0x6]
	ext	s1c17_t16+0x6@m
	ld.w	%r9,s1c17_t16+0x6@l
	add	%r9,%r0
	ld.uh	%r10,[%r9]
	ext	0x3ff		; 	xand	%r10,%r10,0x0000fffd
	and	%r10,0x3d
	ext	s1c17_t16+0x6@h	; 	xld.h	[%r0+s1c17_t16+0x6],%r10
	ext	s1c17_t16+0x6@m
	ld.w	%r9,s1c17_t16+0x6@l
	add	%r9,%r0
	ld.h	[%r9],%r10
__LX370:				; __L370:
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r1
	ret
	.align	1
	.global	s1c17_t16_exec
s1c17_t16_exec:
;	.frame	%sp,36,$31		# vars= 16, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x4		; 	xsub	%sp,%sp,16
	ld.w	%r3,0x0
	ld.w	%r5,0xa		; 	xld.w	%r5,0x0000000a		; 10
	ext	s1c17_t16+0x8@h	; 	xld.w	%r1,s1c17_t16+0x8
	ext	s1c17_t16+0x8@m
	ld.w	%r1,s1c17_t16+0x8@l
	ld.w	%r4,%r3
	ext	0x4		; 	xsub	%r0,%r1,4
	sub	%r0,%r1
	ext	0x6		; 	xsub	%r15,%r1,6
	sub	%r15,%r1
	ext	0x2		; 	xsub	%r2,%r1,2
	sub	%r2,%r1
	ext	0x8		; 	xsub	%r6,%r1,8
	sub	%r6,%r1
__LX382:				; __L382:
	ld.uh	%r13,[%r2]	; 	xld.uh	%r13,[%r2]
	ld.w	%r10,%r13
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX383		; 	xjreq	__L383
	ld.uh	%r10,[%r6]	; 	xld.uh	%r10,[%r6]
	and	%r10,0xf	; 	xand	%r10,%r10,0x0000000f
	ext	0x100		; 	xld.w	%r11,0x00004000		; 16384
	ld.w	%r11,0x0
	ld.w	%r9,%r10	; 	xsra	%r11,%r10
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	sra	%r11,0x8
	jp.d	-3
	sub	%r9,0x8
	sra	%r11,%r9
	ld.uh	%r12,[%r0]	; 	xld.uh	%r12,[%r0]
	ld.uh	%r10,%r12
	cmp	%r10,%r11
	jrlt	__LX384		; 	xjrlt	__L384
	ld.w	%r10,%r12
	sub	%r10,%r11
	ld.h	[%r0],%r10	; 	xld.h	[%r0],%r10
	jp	__LX383		; 	xjp	__L383
__LX384:				; __L384:
	ld.w	%r10,%r13
	srl	%r10,0x4	; 	xsrl	%r10,4
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX386		; 	xjreq	__L386
	ld.uh	%r10,[%r15]	; 	xld.uh	%r10,[%r15]
	ld.h	[%r0],%r10	; 	xld.h	[%r0],%r10
	ld.uh	%r10,[%r2]	; 	xld.uh	%r10,[%r2]
	ext	0x3ff		; 	xand	%r10,%r10,0x0000fffe
	and	%r10,0x3e
	ld.h	[%r2],%r10	; 	xld.h	[%r2],%r10
	jp	__LX387		; 	xjp	__L387
__LX386:				; __L386:
	ld.w	%r12,%r4
	ld.uh	%r13,[%r15]	; 	xld.uh	%r13,[%r15]
	ld.uh	%r14,%r13
__LX388:				; __L388:
	sub	%r11,0x1	; 	xsub	%r11,%r11,1
	ext	s1c17_t16+0x4@h	; 	xld.uh	%r10,[%r12+s1c17_t16+0x4]
	ext	s1c17_t16+0x4@m
	ld.w	%r9,s1c17_t16+0x4@l
	add	%r9,%r12
	ld.uh	%r10,[%r9]
	sub	%r11,%r10
	ext	s1c17_t16+0x4@h	; 	xld.h	[%r12+s1c17_t16+0x4],%r13
	ext	s1c17_t16+0x4@m
	ld.w	%r9,s1c17_t16+0x4@l
	add	%r9,%r12
	ld.h	[%r9],%r13
	cmp	%r14,%r11
	jrlt	__LX388		; 	xjrlt	__L388
	ld.uh	%r10,[%r0]	; 	xld.uh	%r10,[%r0]
	sub	%r10,%r11
	ld.h	[%r0],%r10	; 	xld.h	[%r0],%r10
__LX387:				; __L387:
	ld.uh	%r11,[%r1]	; 	xld.uh	%r11,[%r1]
	ld.uh	%r10,%r11
	srl	%r10,0x8	; 	xsrl	%r10,8
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX383		; 	xjreq	__L383
	ld.w	%r10,%r11
	or	%r10,0x1	; 	xoor	%r10,%r10,0x00000001
	ext	s1c17_t16+0x8@h	; 	xld.h	[%r4+s1c17_t16+0x8],%r10
	ext	s1c17_t16+0x8@m
	ld.w	%r9,s1c17_t16+0x8@l
	add	%r9,%r4
	ld.h	[%r9],%r10
__LX383:				; __L383:
	ld.uh	%r10,[%r1]	; 	xld.uh	%r10,[%r1]
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX381		; 	xjreq	__L381
	ext	0xd		; 	xadd	%r12,%r3,13
	add	%r12,%r3
	ld.w	[%sp+0x0],%r15	; 	xld.w	[%sp],%r15
	ld.w	[%sp+0x1],%r4	; 	xld.w	[%sp+0x4],%r4
	ld.w	[%sp+0x2],%r5	; 	xld.w	[%sp+0x8],%r5
	ld.w	[%sp+0x3],%r6	; 	xld.w	[%sp+0xc],%r6
	call	s1c17_itc_irq	; 	xcall	s1c17_itc_irq
	ld.w	%r6,[%sp+0x3]	; 	xld.w	%r6,[%sp+0xc]
	ld.w	%r5,[%sp+0x2]	; 	xld.w	%r5,[%sp+0x8]
	ld.w	%r4,[%sp+0x1]	; 	xld.w	%r4,[%sp+0x4]
	ld.w	%r15,[%sp+0x0]	; 	xld.w	%r15,[%sp]
__LX381:				; __L381:
	add	%r1,%r5
	add	%r4,%r5
	add	%r0,%r5
	add	%r15,%r5
	add	%r2,%r5
	add	%r6,%r5
	add	%r3,0x1		; 	xadd	%r3,%r3,1
	cmp	%r3,0x2		; 	xcmp	%r3,2
	jrle	__LX382		; 	xjrle	__L382
	add	%sp,0x4		; 	xadd	%sp,%sp,16
	popn	%r3
	ret
	.code
	.align	2
init.431:
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.code
	.align	1
	.global	s1c17_itc_init
s1c17_itc_init:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_itc+0x0@h	; 	xld.w	%r0,s1c17_itc
	ext	s1c17_itc+0x0@m
	ld.w	%r0,s1c17_itc+0x0@l
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ld.w	%r14,0x12	; 	xld.w	%r14,0x00000012		; 18
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r12,%r0
	ext	init.431+0x0@h	; 	xld.w	%r13,init.431
	ext	init.431+0x0@m
	ld.w	%r13,init.431+0x0@l
	ld.w	%r14,0x12	; 	xld.w	%r14,0x00000012		; 18
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_itc_read
s1c17_itc_read:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r14,%r12
	ld.w	%r11,0x0
	ld.w	[%sp+0x0],%r11	; 	xld.w	[%sp],%r11
	ext	0x6		; 	xsub	%r10,%r13,6
	sub	%r10,%r13
	cmp	%r10,0x11	; 	xcmp	%r10,17
	jrugt	__LX398		; 	xjrugt	__L398
	ext	s1c17_itc+0x0@h	; 	xld.w	%r13,s1c17_itc
	ext	s1c17_itc+0x0@m
	ld.w	%r13,s1c17_itc+0x0@l
	ld.w	%r12,%sp
	add	%r10,%r13
	ld.w	%r13,%r10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX398:				; __L398:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_itc_write
s1c17_itc_write:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r10,%r12
	ld.w	[%sp+0x0],%r14	; 	xld.w	[%sp],%r14
	sub	%r13,0x6	; 	xsub	%r13,%r13,6
	cmp	%r13,0x11	; 	xcmp	%r13,17
	jrugt	__LX400		; 	xjrugt	__L400
	ext	s1c17_itc+0x0@h	; 	xld.w	%r12,s1c17_itc
	ext	s1c17_itc+0x0@m
	ld.w	%r12,s1c17_itc+0x0@l
	add	%r13,%r12
	ld.w	%r12,%r13
	ld.w	%r13,%sp
	ld.w	%r14,%r10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX400:				; __L400:
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_itc_irq
s1c17_itc_irq:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_mode+0x0@ah	; 	xld.ub	%r10,[s1c17_mode]
	ext	s1c17_mode+0x0@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jreq	__LX401		; 	xjreq	__L401
	ext	s1c17_cpu+0x20@ah	; 	xld.w	%r11,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.w	%r11,[%r8]
	ld.w	%r0,%r11
	srl	%r0,0x5		; 	xsrl	%r0,5
	and	%r0,0x1		; 	xand	%r0,%r0,0x00000001
	cmp	%r12,0x3	; 	xcmp	%r12,3
	jrle	__LX403		; 	xjrle	__L403
	cmp	%r12,0x15	; 	xcmp	%r12,21
	jrgt	__LX404		; 	xjrgt	__L404
	ext	s1c17_itc-0x4@h	; 	xld.ub	%r0,[%r12+s1c17_itc-0x4]
	ext	s1c17_itc-0x4@m
	ld.w	%r9,s1c17_itc-0x4@l
	add	%r9,%r12
	ld.ub	%r0,[%r9]
	and	%r0,0x7		; 	xand	%r0,%r0,0x00000007
	ld.w	%r13,0x0
	ext	s1c17_mode+0x0@ah	; 	xld.b	[s1c17_mode],%r13
	ext	s1c17_mode+0x0@al
	ld.b	[%r8],%r13
__LX404:				; __L404:
	ld.w	%r10,%r11
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	jreq	__LX401		; 	xjreq	__L401
	ld.w	%r10,%r11
	srl	%r10,0x5	; 	xsrl	%r10,5
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	cmp	%r0,%r10
	jrle	__LX401		; 	xjrle	__L401
__LX403:				; __L403:
	ext	s1c17_int@rm	; 	xcall	s1c17_int
	call	s1c17_int@rl
	ext	s1c17_cpu+0x20@h	; 	xld.w	%r12,s1c17_cpu+0x20
	ext	s1c17_cpu+0x20@m
	ld.w	%r12,s1c17_cpu+0x20@l
	ld.w	%r11,%r0
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	sll	%r11,0x5	; 	xsll	%r11,5
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ext	0x1fff		; 	xand	%r10,%r10,0xffffffdf
	and	%r10,0x1f
	or	%r10,%r11
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
__LX401:				; __L401:
	popn	%r0
	ret
	.code
	.align	2
init.440:
	.byte	0
	.byte	4
	.byte	2
	.byte	2
	.byte	0
	.byte	0
	.code
	.align	1
	.global	s1c17_osc_init
s1c17_osc_init:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_osc+0x0@h	; 	xld.w	%r0,s1c17_osc
	ext	s1c17_osc+0x0@m
	ld.w	%r0,s1c17_osc+0x0@l
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ld.w	%r14,0x6	; 	xld.w	%r14,0x00000006		; 6
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r12,%r0
	ext	init.440+0x0@h	; 	xld.w	%r13,init.440
	ext	init.440+0x0@m
	ld.w	%r13,init.440+0x0@l
	ld.w	%r14,0x6	; 	xld.w	%r14,0x00000006		; 6
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_osc_read
s1c17_osc_read:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r14,%r12
	ld.w	%r10,%r13
	ld.w	%r11,0x0
	ld.w	[%sp+0x0],%r11	; 	xld.w	[%sp],%r11
	cmp	%r10,0x5	; 	xcmp	%r10,5
	jrugt	__LX410		; 	xjrugt	__L410
	ext	s1c17_osc+0x0@h	; 	xld.w	%r13,s1c17_osc
	ext	s1c17_osc+0x0@m
	ld.w	%r13,s1c17_osc+0x0@l
	ld.w	%r12,%sp
	add	%r10,%r13
	ld.w	%r13,%r10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX410:				; __L410:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_osc_write
s1c17_osc_write:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r10,%r12
	ld.w	[%sp+0x0],%r14	; 	xld.w	[%sp],%r14
	cmp	%r13,0x5	; 	xcmp	%r13,5
	jrugt	__LX412		; 	xjrugt	__L412
	ext	s1c17_osc+0x0@h	; 	xld.w	%r12,s1c17_osc
	ext	s1c17_osc+0x0@m
	ld.w	%r12,s1c17_osc+0x0@l
	add	%r13,%r12
	ld.w	%r12,%r13
	ld.w	%r13,%sp
	ld.w	%r14,%r10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX412:				; __L412:
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.code
	.align	2
init.447:
	.byte	208
	.byte	0
	.byte	2
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.code
	.align	1
	.global	s1c17_lcd_init
s1c17_lcd_init:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_lcd+0x0@h	; 	xld.w	%r0,s1c17_lcd
	ext	s1c17_lcd+0x0@m
	ld.w	%r0,s1c17_lcd+0x0@l
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ld.w	%r14,0xc	; 	xld.w	%r14,0x0000000c		; 12
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	init.447+0x0@h	; 	xld.w	%r10,init.447
	ext	init.447+0x0@m
	ld.w	%r10,init.447+0x0@l
	ld.w	%r11,[%r10]+
	ld.h	%r12,[%r10]+
	ld.b	%r13,[%r10]+
	ld.w	[%r0]+,%r11
	ld.h	[%r0]+,%r12
	ld.b	[%r0]+,%r13
	popn	%r0
	ret
	.align	1
	.global	s1c17_lcd_read
s1c17_lcd_read:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r14,%r12
	ld.w	%r10,%r13
	ld.w	%r11,0x0
	ld.w	[%sp+0x0],%r11	; 	xld.w	[%sp],%r11
	cmp	%r10,0x6	; 	xcmp	%r10,6
	jrugt	__LX416		; 	xjrugt	__L416
	ext	s1c17_lcd+0x0@h	; 	xld.w	%r13,s1c17_lcd
	ext	s1c17_lcd+0x0@m
	ld.w	%r13,s1c17_lcd+0x0@l
	ld.w	%r12,%sp
	add	%r10,%r13
	ld.w	%r13,%r10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX416:				; __L416:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_lcd_write
s1c17_lcd_write:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r15,%r12
	ld.w	[%sp+0x0],%r14	; 	xld.w	[%sp],%r14
	cmp	%r13,0x6	; 	xcmp	%r13,6
	jrugt	__LX418		; 	xjrugt	__L418
	jrne	__LX419		; 	xjrne	__L419
	ld.w	%r10,%r14
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX419		; 	xjreq	__L419
	ext	s1c17_lcd+0x4@h	; 	xld.w	%r10,s1c17_lcd+0x4
	ext	s1c17_lcd+0x4@m
	ld.w	%r10,s1c17_lcd+0x4@l
	ld.w	%r11,[%r10]	; 	xld.w	%r11,[%r10]
	ext	0x1bff		; 	xand	%r11,%r11,0xfffeffff
	and	%r11,0x3f
	ld.w	[%r10],%r11	; 	xld.w	[%r10],%r11
	ld.w	%r10,%r14
	and	%r10,0x3e	; 	xand	%r10,%r10,0xfffffffe
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
__LX419:				; __L419:
	ext	s1c17_lcd+0x0@h	; 	xld.w	%r12,s1c17_lcd
	ext	s1c17_lcd+0x0@m
	ld.w	%r12,s1c17_lcd+0x0@l
	add	%r13,%r12
	ld.w	%r12,%r13
	ld.w	%r13,%sp
	ld.w	%r14,%r15
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX418:				; __L418:
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_lcd_exec
s1c17_lcd_exec:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_osc+0x3@ah	; 	xld.ub	%r11,[s1c17_osc+0x3]
	ext	s1c17_osc+0x3@al
	ld.ub	%r11,[%r8]
	ld.w	%r10,%r11
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	jreq	__LX422		; 	xjreq	__L422
	ext	s1c17_lcd+0x4@h	; 	xld.w	%r13,s1c17_lcd+0x4
	ext	s1c17_lcd+0x4@m
	ld.w	%r13,s1c17_lcd+0x4@l
	ld.w	%r10,[%r13]	; 	xld.w	%r10,[%r13]
	ext	0x4		; 	xand	%r10,%r10,0x00000100
	and	%r10,0x0
	jreq	__LX422		; 	xjreq	__L422
	ld.ub	%r10,%r11
	srl	%r10,0x2	; 	xsrl	%r10,2
	and	%r10,0x7	; 	xand	%r10,%r10,0x00000007
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
	ld.w	%r12,%r11
	ld.w	%r9,%r10	; 	xsll	%r12,%r10
	and	%r9,0x1f
	cmp	%r9,0x8
	jrle	4
	sll	%r12,0x8
	jp.d	-3
	sub	%r9,0x8
	sll	%r12,%r9
	ext	0x4		; 	xadd	%r11,%r13,4
	add	%r11,%r13
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	cmp	%r10,%r12
	jrlt	__LX422		; 	xjrlt	__L422
	ld.w	%r14,%r11
	ext	0x400		; 	xld.w	%r15,0x00010000		; 65536
	ld.w	%r15,0x0
__LX425:				; __L425:
	ld.w	%r11,[%r14]	; 	xld.w	%r11,[%r14]
	sub	%r11,%r12
	ld.w	[%r14],%r11	; 	xld.w	[%r14],%r11
	ld.w	%r10,[%r13]	; 	xld.w	%r10,[%r13]
	or	%r10,%r15
	ld.w	[%r13],%r10	; 	xld.w	[%r13],%r10
	cmp	%r11,%r12
	jrge	__LX425		; 	xjrge	__L425
__LX422:				; __L422:
	ext	s1c17_lcd+0x4@ah	; 	xld.w	%r10,[s1c17_lcd+0x4]
	ext	s1c17_lcd+0x4@al
	ld.w	%r10,[%r8]
	ext	0x400		; 	xand	%r10,%r10,0x00010000
	and	%r10,0x0
	jreq	__LX427		; 	xjreq	__L427
	ld.w	%r12,0xa	; 	xld.w	%r12,0x0000000a		; 10
	ext	s1c17_itc_irq@rm	; 	xcall	s1c17_itc_irq
	call	s1c17_itc_irq@rl
__LX427:				; __L427:
	ret
	.code
	.align	2
init.456:
	.byte	255
	.byte	0
	.byte	0
	.byte	255
	.byte	255
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	255
	.code
	.align	1
	.global	s1c17_p_init
s1c17_p_init:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ext	s1c17_p+0x0@h	; 	xld.w	%r1,s1c17_p
	ext	s1c17_p+0x0@m
	ld.w	%r1,s1c17_p+0x0@l
	ld.w	%r12,%r1
	ld.w	%r13,0x0
	ext	0x0		; 	xld.w	%r14,0x0000002c		; 44
	ld.w	%r14,0x2c
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	init.456+0x0@h	; 	xld.w	%r0,init.456
	ext	init.456+0x0@m
	ld.w	%r0,init.456+0x0@l
	ld.w	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,0xb	; 	xld.w	%r14,0x0000000b		; 11
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0xb		; 	xadd	%r12,%r1,11
	add	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,0xb	; 	xld.w	%r14,0x0000000b		; 11
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0x16		; 	xadd	%r12,%r1,22
	add	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,0xb	; 	xld.w	%r14,0x0000000b		; 11
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0x21		; 	xadd	%r12,%r1,33
	add	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,0xb	; 	xld.w	%r14,0x0000000b		; 11
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_p_read
s1c17_p_read:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,0x0
	ld.w	%r11,%r13
	sra	%r11,0x4	; 	xsra	%r11,4
	and	%r13,0xf	; 	xand	%r13,%r13,0x0000000f
	cmp	%r11,0x3	; 	xcmp	%r11,3
	jrgt	__LX431		; 	xjrgt	__L431
	cmp	%r13,0xa	; 	xcmp	%r13,10
	jrugt	__LX431		; 	xjrugt	__L431
	ld.w	%r10,0xb	; 	xld.w	%r10,0x0000000b		; 11
	mlt.w	%r11,%r10
	ld.w	%r10,%alr
	add	%r10,%r13
	ext	s1c17_p+0x0@h	; 	xld.ub	%r10,[%r10+s1c17_p]
	ext	s1c17_p+0x0@m
	ld.w	%r9,s1c17_p+0x0@l
	add	%r9,%r10
	ld.ub	%r10,[%r9]
__LX431:				; __L431:
	ret
	.align	1
	.global	s1c17_p_write
s1c17_p_write:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r12,%r13
	sra	%r12,0x4	; 	xsra	%r12,4
	and	%r13,0xf	; 	xand	%r13,%r13,0x0000000f
	cmp	%r12,0x3	; 	xcmp	%r12,3
	jrgt	__LX433		; 	xjrgt	__L433
	cmp	%r13,0xa	; 	xcmp	%r13,10
	jrugt	__LX433		; 	xjrugt	__L433
	cmp	%r13,0x7	; 	xcmp	%r13,7
	jrne	__LX434		; 	xjrne	__L434
	ld.w	%r10,0xb	; 	xld.w	%r10,0x0000000b		; 11
	mlt.w	%r12,%r10
	ld.w	%r10,%alr
	not	%r11,%r14
	ext	s1c17_p+0x7@h	; 	xld.ub	%r15,[%r10+s1c17_p+0x7]
	ext	s1c17_p+0x7@m
	ld.w	%r9,s1c17_p+0x7@l
	add	%r9,%r10
	ld.ub	%r15,[%r9]
	and	%r15,%r11
	ld.w	%r11,%r15
	ext	s1c17_p+0x7@h	; 	xld.b	[%r10+s1c17_p+0x7],%r11
	ext	s1c17_p+0x7@m
	ld.w	%r9,s1c17_p+0x7@l
	add	%r9,%r10
	ld.b	[%r9],%r11
	jp	__LX433		; 	xjp	__L433
__LX434:				; __L434:
	ld.w	%r10,0xb	; 	xld.w	%r10,0x0000000b		; 11
	mlt.w	%r12,%r10
	ld.w	%r10,%alr
	add	%r10,%r13
	ext	s1c17_p+0x0@h	; 	xld.b	[%r10+s1c17_p],%r14
	ext	s1c17_p+0x0@m
	ld.w	%r9,s1c17_p+0x0@l
	add	%r9,%r10
	ld.b	[%r9],%r14
__LX433:				; __L433:
	ret
	.align	1
	.global	s1c17_p_exec
s1c17_p_exec:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_p+0x7@h	; 	xld.w	%r0,s1c17_p+0x7
	ext	s1c17_p+0x7@m
	ld.w	%r0,s1c17_p+0x7@l
	ld.ub	%r10,[%r0]	; 	xld.ub	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX437		; 	xjreq	__L437
	ld.w	%r12,0x4	; 	xld.w	%r12,0x00000004		; 4
	ext	s1c17_itc_irq@rm	; 	xcall	s1c17_itc_irq
	call	s1c17_itc_irq@rl
__LX437:				; __L437:
	ext	0xb		; 	xld.ub	%r10,[%r0+0xb]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX438		; 	xjreq	__L438
	ld.w	%r12,0x5	; 	xld.w	%r12,0x00000005		; 5
	ext	s1c17_itc_irq@rm	; 	xcall	s1c17_itc_irq
	call	s1c17_itc_irq@rl
__LX438:				; __L438:
	popn	%r0
	ret
	.code
	.align	2
init.465:
	.byte	3
	.byte	3
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	128
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.code
	.align	1
	.global	s1c17_misc_init
s1c17_misc_init:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_misc+0x0@h	; 	xld.w	%r0,s1c17_misc
	ext	s1c17_misc+0x0@m
	ld.w	%r0,s1c17_misc+0x0@l
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ld.w	%r14,0xe	; 	xld.w	%r14,0x0000000e		; 14
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r12,%r0
	ext	init.465+0x0@h	; 	xld.w	%r13,init.465
	ext	init.465+0x0@m
	ld.w	%r13,init.465+0x0@l
	ld.w	%r14,0xe	; 	xld.w	%r14,0x0000000e		; 14
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_misc_read
s1c17_misc_read:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r14,%r12
	ld.w	%r11,%r13
	ld.w	%r15,0x0
	ld.w	[%sp+0x0],%r15	; 	xld.w	[%sp],%r15
	cmp	%r11,0xd	; 	xcmp	%r11,13
	jrugt	__LX442		; 	xjrugt	__L442
	ld.w	%r10,%r11
	and	%r10,0x3e	; 	xand	%r10,%r10,0xfffffffe
	cmp	%r10,0xc	; 	xcmp	%r10,12
	jrne	__LX443		; 	xjrne	__L443
	ext	s1c17_cpu+0x20@ah	; 	xld.ub	%r10,[s1c17_cpu+0x20]
	ext	s1c17_cpu+0x20@al
	ld.ub	%r10,[%r8]
	ext	s1c17_misc+0xc@ah	; 	xld.h	[s1c17_misc+0xc],%r10
	ext	s1c17_misc+0xc@al
	ld.h	[%r8],%r10
__LX443:				; __L443:
	ext	s1c17_misc+0x0@h	; 	xld.w	%r13,s1c17_misc
	ext	s1c17_misc+0x0@m
	ld.w	%r13,s1c17_misc+0x0@l
	ld.w	%r12,%sp
	add	%r11,%r13
	ld.w	%r13,%r11
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX442:				; __L442:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_misc_write
s1c17_misc_write:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r10,%r12
	ld.w	[%sp+0x0],%r14	; 	xld.w	[%sp],%r14
	cmp	%r13,0xd	; 	xcmp	%r13,13
	jrugt	__LX448		; 	xjrugt	__L448
	ext	s1c17_misc+0x0@h	; 	xld.w	%r12,s1c17_misc
	ext	s1c17_misc+0x0@m
	ld.w	%r12,s1c17_misc+0x0@l
	add	%r13,%r12
	ld.w	%r12,%r13
	ld.w	%r13,%sp
	ld.w	%r14,%r10
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX448:				; __L448:
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_flash_init
s1c17_flash_init:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ret
; APP

		.code
		.align		1
		.global		s1c17_flash_read
s1c17_flash_read:
	ext	s1c17_flash+0x0@h	; 		Xld.w		%r14, s1c17_flash
	ext	s1c17_flash+0x0@m
	ld.w	%r14,s1c17_flash+0x0@l
	ext	s1c17_memget@rm	; 		Xjp		s1c17_memget
	jp	s1c17_memget@rl

; NO_APP
	.align	1
	.global	s1c17_flash_write
s1c17_flash_write:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ret
	.align	1
	.global	s1c17_sram_init
s1c17_sram_init:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	s1c17_sram+0x0@h	; 	xld.w	%r12,s1c17_sram
	ext	s1c17_sram+0x0@m
	ld.w	%r12,s1c17_sram+0x0@l
	ld.w	%r13,0x0
	ext	0x9		; 	xld.w	%r14,0x00000240		; 576
	ld.w	%r14,0x0
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ret
; APP

		.code
		.align		1
		.global		s1c17_sram_read
		.global		s1c17_sram_write
		;//-------------------------------------;//
s1c17_sram_read:
		ld.ub		%r4, %r13			;// %r4  := (unsigned char)ofs
	ext	0x1		; 		Xld.w		%r5, 0x60			;// %r5  := 0x60
	ld.w	%r5,0x20
		cmp		%r4, %r5			;// if((unsigned char)ofs >= 0x60)
		jrge		s1c17_sram_read_RET_0		;//   return 0
		sra		%r13, 8				;// %r13 :=  ofs >> 8
		mlt.h		%r13, %r5			;// %alr := (ofs >> 8) * 0x60
		ld.w		%r13, %alr			;// %r13 := (ofs >> 8) * 0x60
		add		%r13, %r4			;// %r13 := (ofs >> 8) * 0x60 + (unsigned char)ofs
		ext		s1c17_sram@ah
		ext		s1c17_sram@al
		ld.b		%r10, [%r13]			;// %r10 := data = s1c17_sram.m[ofs >> 8][(unsigned char)ofs]
		ret						;// return data
s1c17_sram_read_RET_0:
		ret.d						;// return 0
		ld.w		%r10, 0				;// %r10 := 0	*delay*
		;//-------------------------------------;//
s1c17_sram_write:
		ld.ub		%r4, %r13			;// %r4  := (unsigned char)ofs
	ext	0x1		; 		Xld.w		%r5, 0x60			;// %r5  := 0x60
	ld.w	%r5,0x20
		cmp		%r4, %r5			;// if((unsigned char)ofs >= 0x60)
		jrge		s1c17_sram_write_RET		;//   return
		sra		%r13, 8				;// %r13 :=  ofs >> 8
		mlt.h		%r13, %r5			;// %alr := (ofs >> 8) * 0x60
		ld.w		%r13, %alr			;// %r13 := (ofs >> 8) * 0x60
		add		%r13, %r4			;// %r13 := (ofs >> 8) * 0x60 + (unsigned char)ofs
		ext		s1c17_sram@ah
		ext		s1c17_sram@al
		ld.b		[%r13], %r14			;// s1c17_sram.m[ofs >> 8][(unsigned char)ofs] := data
s1c17_sram_write_RET:
		ret

; NO_APP
	.code
	.align	2
init.478:
	.byte	0
	.byte	128
	.byte	0
	.byte	0
	.byte	16
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	192
	.byte	47
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	6
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.byte	0
	.code
	.align	1
	.global	s1c17_dbg_init
s1c17_dbg_init:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ext	s1c17_dbg+0x0@h	; 	xld.w	%r0,s1c17_dbg
	ext	s1c17_dbg+0x0@m
	ld.w	%r0,s1c17_dbg+0x0@l
	ext	0x1		; 	xld.w	%r1,0x00000054		; 84
	ld.w	%r1,0x14
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ld.w	%r14,%r1
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r12,%r0
	ext	init.478+0x0@h	; 	xld.w	%r13,init.478
	ext	init.478+0x0@m
	ld.w	%r13,init.478+0x0@l
	ld.w	%r14,%r1
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	popn	%r1
	ret
	.align	1
	.global	s1c17_dbg_read
s1c17_dbg_read:
;	.frame	%sp,16,$31		# vars= 4, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.w	%r11,0x0
	ld.w	[%sp+0x0],%r11	; 	xld.w	[%sp],%r11
	ext	0x1		; 	xcmp	%r0,83
	cmp	%r0,0x13
	jrugt	__LX455		; 	xjrugt	__L455
	ld.w	%r10,%r0
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	jreq	__LX457		; 	xjreq	__L457
	ext	0x0		; 	xcmp	%r10,32
	cmp	%r10,0x20
	jreq	__LX458		; 	xjreq	__L458
	jp	__LX456		; 	xjp	__L456
__LX457:				; __L457:
	ld.w	%r13,%r0
	and	%r13,0x3	; 	xand	%r13,%r13,0x00000003
	ld.w	%r12,%r1
	ext	0x14c		; 	xoor	%r13,%r13,0x00005328
	or	%r13,0x28
	ext	s1c17_bcu_read@rm	; 	xcall	s1c17_bcu_read
	call	s1c17_bcu_read@rl
	ext	s1c17_dbg+0x0@ah	; 	xld.w	[s1c17_dbg],%r10
	ext	s1c17_dbg+0x0@al
	ld.w	[%r8],%r10
	jp	__LX456		; 	xjp	__L456
__LX458:				; __L458:
	ext	s1c17_mode+0x0@ah	; 	xld.ub	%r10,[s1c17_mode]
	ext	s1c17_mode+0x0@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jrne	__LX459		; 	xjrne	__L459
	ld.w	%r11,%r10
__LX459:				; __L459:
	ext	s1c17_dbg+0x20@h	; 	xld.w	%r12,s1c17_dbg+0x20
	ext	s1c17_dbg+0x20@m
	ld.w	%r12,s1c17_dbg+0x20@l
	and	%r11,0x1	; 	xand	%r11,%r11,0x00000001
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	and	%r10,0x3e	; 	xand	%r10,%r10,0xfffffffe
	or	%r10,%r11
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
__LX456:				; __L456:
	ext	s1c17_dbg+0x0@h	; 	xld.w	%r13,s1c17_dbg
	ext	s1c17_dbg+0x0@m
	ld.w	%r13,s1c17_dbg+0x0@l
	ld.w	%r12,%sp
	add	%r0,%r13
	ld.w	%r13,%r0
	ld.w	%r14,%r1
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX455:				; __L455:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r1
	ret
	.align	1
	.global	s1c17_dbg_write
s1c17_dbg_write:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r15,%r12
	ld.w	[%sp+0x0],%r14	; 	xld.w	[%sp],%r14
	ext	0x1		; 	xcmp	%r13,83
	cmp	%r13,0x13
	jrugt	__LX463		; 	xjrugt	__L463
	ext	0x0		; 	xcmp	%r13,32
	cmp	%r13,0x20
	jrne	__LX464		; 	xjrne	__L464
	ld.w	%r10,%r14
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	jreq	__LX464		; 	xjreq	__L464
	ext	s1c17_dbg+0x20@h	; 	xld.w	%r10,s1c17_dbg+0x20
	ext	s1c17_dbg+0x20@m
	ld.w	%r10,s1c17_dbg+0x20@l
	ld.w	%r11,[%r10]	; 	xld.w	%r11,[%r10]
	and	%r11,0x2f	; 	xand	%r11,%r11,0xffffffef
	ld.w	[%r10],%r11	; 	xld.w	[%r10],%r11
	ld.w	%r10,%r14
	and	%r10,0x2f	; 	xand	%r10,%r10,0xffffffef
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
__LX464:				; __L464:
	ext	s1c17_dbg+0x0@h	; 	xld.w	%r12,s1c17_dbg
	ext	s1c17_dbg+0x0@m
	ld.w	%r12,s1c17_dbg+0x0@l
	add	%r13,%r12
	ld.w	%r12,%r13
	ld.w	%r13,%sp
	ld.w	%r14,%r15
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX463:				; __L463:
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	s1c17_flash_load
s1c17_flash_load:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,%r12
	ext	0x1ff		; 	xcmp	%r11,32767
	cmp	%r11,0x3f
	jrle	__LX468		; 	xjrle	__L468
	ld.w	%r10,%r11
	add	%r10,%r14
	ext	0xa00		; 	xcmp	%r10,163840
	cmp	%r10,0x0
	jrle	__LX467		; 	xjrle	__L467
__LX468:				; __L468:
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x1d		; 	xld.w	%r13,0x00000755		; 1877
	ld.w	%r13,0x15
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX467:				; __L467:
	ext	s1c17_flash-0x8000@h	; 	xld.w	%r12,s1c17_flash-0x8000
	ext	s1c17_flash-0x8000@m
	ld.w	%r12,s1c17_flash-0x8000@l
	add	%r11,%r12
	ld.w	%r12,%r11
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ret
	.align	1
	.global	s1c17_init
s1c17_init:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_init_tbl+0x0@h	; 	xld.w	%r0,s1c17_init_tbl
	ext	s1c17_init_tbl+0x0@m
	ld.w	%r0,s1c17_init_tbl+0x0@l
	ld.w	%r11,0x0
	ext	s1c17_mode+0x0@ah	; 	xld.b	[s1c17_mode],%r11
	ext	s1c17_mode+0x0@al
	ld.b	[%r8],%r11
	ld.w	%r11,0x0
	ext	s1c17_cycle+0x0@ah	; 	xld.w	[s1c17_cycle],%r11
	ext	s1c17_cycle+0x0@al
	ld.w	[%r8],%r11
	jp	__LX474		; 	xjp	__L474
__LX472:				; __L472:
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	add	%r0,0x4		; 	xadd	%r0,%r0,4
	call	%r10
__LX474:				; __L474:
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	cmp	%r10,0x0
	jrne	__LX472		; 	xjrne	__L472
	ext	s1c17_cpu_init@rm	; 	xcall	s1c17_cpu_init
	call	s1c17_cpu_init@rl
	popn	%r0
	ret
	.align	1
	.global	s1c17_exec
s1c17_exec:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_cycle+0x0@ah	; 	xld.w	%r10,[s1c17_cycle]
	ext	s1c17_cycle+0x0@al
	ld.w	%r10,[%r8]
	add	%r10,%r12
	jp	__LX491		; 	xjp	__L491
__LX477:				; __L477:
	ext	s1c17_exec_tbl+0x0@h	; 	xld.w	%r0,s1c17_exec_tbl
	ext	s1c17_exec_tbl+0x0@m
	ld.w	%r0,s1c17_exec_tbl+0x0@l
	jp	__LX492		; 	xjp	__L492
__LX482:				; __L482:
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	add	%r0,0x4		; 	xadd	%r0,%r0,4
	call	%r10
__LX492:				; __L492:
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	cmp	%r10,0x0
	jrne	__LX482		; 	xjrne	__L482
	ext	0x80		; 	xld.w	%r0,0x00002000		; 8192
	ld.w	%r0,0x0
	jp	__LX493		; 	xjp	__L493
__LX487:				; __L487:
	ext	s1c17_cpu_exec@rm	; 	xcall	s1c17_cpu_exec
	call	s1c17_cpu_exec@rl
	sub	%r0,0x1		; 	xsub	%r0,%r0,1
	jreq	__LX479		; 	xjreq	__L479
__LX493:				; __L493:
	ext	s1c17_mode+0x0@ah	; 	xld.ub	%r10,[s1c17_mode]
	ext	s1c17_mode+0x0@al
	ld.ub	%r10,[%r8]
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jrule	__LX487		; 	xjrule	__L487
__LX479:				; __L479:
	ext	s1c17_cycle+0x0@ah	; 	xld.w	%r10,[s1c17_cycle]
	ext	s1c17_cycle+0x0@al
	ld.w	%r10,[%r8]
	ext	0x100		; 	xsub	%r10,%r10,16384
	sub	%r10,0x0
__LX491:				; __L491:
	ext	s1c17_cycle+0x0@ah	; 	xld.w	[s1c17_cycle],%r10
	ext	s1c17_cycle+0x0@al
	ld.w	[%r8],%r10
	cmp	%r10,0x0
	jrge	__LX477		; 	xjrge	__L477
	popn	%r0
	ret
	.align	1
	.global	s1c17_port_get
s1c17_port_get:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,0xb	; 	xld.w	%r10,0x0000000b		; 11
	mlt.w	%r12,%r10
	ld.w	%r11,%alr
	ext	s1c17_p+0x1@h	; 	xld.ub	%r10,[%r11+s1c17_p+0x1]
	ext	s1c17_p+0x1@m
	ld.w	%r9,s1c17_p+0x1@l
	add	%r9,%r11
	ld.ub	%r10,[%r9]
	ret
	.align	1
	.global	s1c17_port_set
s1c17_port_set:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,0xb	; 	xld.w	%r10,0x0000000b		; 11
	mlt.w	%r12,%r10
	ld.w	%r14,%alr
	ext	s1c17_p+0x0@h	; 	xld.ub	%r10,[%r14+s1c17_p]
	ext	s1c17_p+0x0@m
	ld.w	%r9,s1c17_p+0x0@l
	add	%r9,%r14
	ld.ub	%r10,[%r9]
	ld.w	%r11,%r10
	xor	%r11,%r13
	ext	s1c17_p+0x0@h	; 	xld.b	[%r14+s1c17_p],%r13
	ext	s1c17_p+0x0@m
	ld.w	%r9,s1c17_p+0x0@l
	add	%r9,%r14
	ld.b	[%r9],%r13
	cmp	%r12,0x1	; 	xcmp	%r12,1
	jrgt	__LX496		; 	xjrgt	__L496
	ld.w	%r12,%r11
	and	%r12,%r13
	not	%r10,%r13
	and	%r11,%r10
	ext	s1c17_p+0x6@h	; 	xld.ub	%r13,[%r14+s1c17_p+0x6]
	ext	s1c17_p+0x6@m
	ld.w	%r9,s1c17_p+0x6@l
	add	%r9,%r14
	ld.ub	%r13,[%r9]
	not	%r10,%r13
	and	%r12,%r10
	and	%r11,%r13
	or	%r12,%r11
	ext	s1c17_p+0x5@h	; 	xld.ub	%r10,[%r14+s1c17_p+0x5]
	ext	s1c17_p+0x5@m
	ld.w	%r9,s1c17_p+0x5@l
	add	%r9,%r14
	ld.ub	%r10,[%r9]
	ld.w	%r11,%r12
	and	%r11,%r10
	ext	s1c17_p+0x7@h	; 	xld.ub	%r10,[%r14+s1c17_p+0x7]
	ext	s1c17_p+0x7@m
	ld.w	%r9,s1c17_p+0x7@l
	add	%r9,%r14
	ld.ub	%r10,[%r9]
	or	%r10,%r11
	ext	s1c17_p+0x7@h	; 	xld.b	[%r14+s1c17_p+0x7],%r10
	ext	s1c17_p+0x7@m
	ld.w	%r9,s1c17_p+0x7@l
	add	%r9,%r14
	ld.b	[%r9],%r10
__LX496:				; __L496:
	ret
	.align	1
	.global	s1c17_lcd_image_sub
s1c17_lcd_image_sub:
;	.frame	%sp,36,$31		# vars= 32, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x8		; 	xsub	%sp,%sp,32
	ext	s1c17_sram+0x0@h	; 	xld.w	%r5,s1c17_sram
	ext	s1c17_sram+0x0@m
	ld.w	%r5,s1c17_sram+0x0@l
	ld.w	%r7,0x4		; 	xld.w	%r7,0x00000004		; 4
__LX498:				; __L498:
	ld.w	%r6,0x9		; 	xld.w	%r6,0x00000009		; 9
__LX501:				; __L501:
	ld.w	%r4,0x0
	ld.w	%r11,%sp
__LX507:				; __L507:
	ld.ub	%r10,[%r5]	; 	xld.ub	%r10,[%r5]
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	add	%r5,0x1		; 	xadd	%r5,%r5,1
	add	%r11,0x4	; 	xadd	%r11,%r11,4
	add	%r4,0x1		; 	xadd	%r4,%r4,1
	cmp	%r4,0x7		; 	xcmp	%r4,7
	jrle	__LX507		; 	xjrle	__L507
	ld.w	%r4,0x0
__LX512:				; __L512:
	ld.w	%r13,0x0
	ld.w	%r15,%r13
	ld.w	%r14,%sp
__LX516:				; __L516:
	sll	%r13,0x1	; 	xsll	%r13,1
	ld.w	%r11,[%r14]	; 	xld.w	%r11,[%r14]
	ld.w	%r10,%r11
	and	%r10,0x1	; 	xand	%r10,%r10,0x00000001
	or	%r13,%r10
	sra	%r11,0x1	; 	xsra	%r11,1
	ld.w	[%r14],%r11	; 	xld.w	[%r14],%r11
	add	%r14,0x4	; 	xadd	%r14,%r14,4
	add	%r15,0x1	; 	xadd	%r15,%r15,1
	cmp	%r15,0x7	; 	xcmp	%r15,7
	jrle	__LX516		; 	xjrle	__L516
	ld.b	[%r12],%r13	; 	xld.b	[%r12],%r13
	add	%r12,0x9	; 	xadd	%r12,%r12,9
	add	%r4,0x1		; 	xadd	%r4,%r4,1
	cmp	%r4,0x7		; 	xcmp	%r4,7
	jrle	__LX512		; 	xjrle	__L512
	ext	0x1		; 	xsub	%r12,%r12,71
	sub	%r12,0x7
	sub	%r6,0x1		; 	xsub	%r6,%r6,1
	jrne	__LX501		; 	xjrne	__L501
	add	%r12,0x3f	; 	xadd	%r12,%r12,63
	add	%r5,0x18	; 	xadd	%r5,%r5,24
	sub	%r7,0x1		; 	xsub	%r7,%r7,1
	jrne	__LX498		; 	xjrne	__L498
	add	%sp,0x8		; 	xadd	%sp,%sp,32
	ret
	.align	1
	.global	s1c17_lcd_image
s1c17_lcd_image:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	s1c17_lcd+0x0@h	; 	xld.w	%r0,s1c17_lcd
	ext	s1c17_lcd+0x0@m
	ld.w	%r0,s1c17_lcd+0x0@l
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	ld.w	%r11,%r10
	and	%r11,0x3	; 	xand	%r11,%r11,0x00000003
	cmp	%r11,0x1	; 	xcmp	%r11,1
	jreq	__LX523		; 	xjreq	__L523
	cmp	%r11,0x2	; 	xcmp	%r11,2
	jreq	__LX526		; 	xjreq	__L526
	jp	__LX529		; 	xjp	__L529
__LX523:				; __L523:
	call	s1c17_lcd_image_sub	; 	xcall	s1c17_lcd_image_sub
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	ld.w	%r11,0x18	; 	xld.w	%r11,0x00000018		; 24
	jreq	__LX522		; 	xjreq	__L522
	ld.w	%r11,0x3	; 	xld.w	%r11,0x00000003		; 3
	jp	__LX522		; 	xjp	__L522
__LX526:				; __L526:
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	not	%r10,%r10
	add	%r10,1
	sra	%r10,0x8	; 	xsra	%r10,31
	sra	%r10,0x8
	sra	%r10,0x8
	sra	%r10,0x7
	ld.w	%r11,%r10
	and	%r11,0x1b	; 	xand	%r11,%r11,0x0000001b
	jp	__LX522		; 	xjp	__L522
__LX529:				; __L529:
	ld.w	%r11,0x0
__LX522:				; __L522:
	ext	s1c17_lcd+0x0@ah	; 	xld.w	%r12,[s1c17_lcd]
	ext	s1c17_lcd+0x0@al
	ld.w	%r12,[%r8]
	ext	0x2		; 	xld.w	%r13,0x00000080		; 128
	ld.w	%r13,0x0
	ld.w	%r10,%r12
	and	%r10,%r13
	jrne	__LX531		; 	xjrne	__L531
	or	%r11,%r13
__LX531:				; __L531:
	ext	0x1		; 	xld.w	%r13,0x00000040		; 64
	ld.w	%r13,0x0
	ld.w	%r10,%r12
	and	%r10,%r13
	jrne	__LX532		; 	xjrne	__L532
	or	%r11,%r13
__LX532:				; __L532:
	ld.w	%r10,%r11
	popn	%r0
	ret

	.comm	s1c17_mode 1

	.comm	s1c17_cycle 4

	.comm	s1c17_op_root 4

	.comm	s1c17_cpu 48

	.comm	s1c17_coprocessor 8

	.comm	s1c17_device_root 4

	.comm	s1c17_iram 12288

	.comm	s1c17_t16 30

	.comm	s1c17_itc 18

	.comm	s1c17_osc 6

	.comm	s1c17_lcd 12

	.comm	s1c17_p 44

	.comm	s1c17_misc 14

	.comm	s1c17_flash 131072

	.comm	s1c17_sram 576

	.comm	s1c17_dbg 84
