/*	
 *	clipay3.h
 *
 *	P/ECE AY-3-8910 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sat Feb 07 19:08:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_AY3_H__
#define __CLIP_AY3_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

#define AY38910BUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

typedef struct _AY38910 AY38910;

/*
 *	AY-3-8910|[go͊O֐̌^`
 */
typedef unsigned char AY38910INPROC (AY38910* ay, int port/*0:|[gA/1:|[gB*/);
typedef          void AY38910OUTPROC(AY38910* ay, int port/*0:|[gA/1:|[gB*/, unsigned char data);

/*
 *	AY-3-8910`l
 */
typedef struct _AY38910CHANNEL {
	int tone_enable;		/* g[ (0:Off/1:On) */
	int noise_enable;		/* mCY (0:Off/1:On) */
	int amplitude_mode;		/* ʃ[h (0:ʎw/1:Gx[v) */
	int amplitude_level;		/* ʎw (:0`15^2:) */
	int tone_period;		/* g[ (0x000`0xfff)~(162) */
	int tone_progress;		/* g[isJE^ */
	int tone_output;		/* g[o͒l (0:Lo/1:Hi) */
} AY38910CHANNEL;

/*
 *	AY-3-8910RA
 */
/*typedef*/ struct _AY38910 {
	unsigned char reg[16];		/* WX^l */
	int address;			/* WX^AhXI (0`15) */
	//
	AY38910CHANNEL channel[3];	/* `l (0:A/1:B/2:C) */
	//
	int noise_enable;		/* ꂩ̃`lmCYgpĂ? */
	int noise_period;		/* mCY (0x00`0x1f)~16 */
	int noise_progress;		/* mCYisJE^ */
	int noise_lfsr;			/* Linear Feedback Shift Register */
	int noise_output;		/* mCYo͒l (0:Lo/1:Hi) */
	//
	int envelope_enable;		/* ꂩ̃`lGx[vgpĂ? */
	int envelope_shape_cycle;	/* Gx[vp^[ (0`15) */
	int envelope_period;		/* Gx[v (0x00`0xffff)~16 */
	int envelope_progress;		/* Gx[visJE^ */
	unsigned envelope_counter;	/* Gx[vg`JE^ */
	int envelope_level;		/* Gx[vo͒l (0`15^2) */
	//
	AY38910INPROC* in;		/* |[g͊O֐ */
	AY38910OUTPROC* out;		/* |[go͊O֐ */
	//
	DDA clock_progress;		/* NbNisDDA */
} /*AY38910*/;

/****************************************************************************
 *	֐
 ****************************************************************************/

/* AY-3-8910Zbgɐݒ肳AAY-3-8910RÃ|[go͊O֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char ay38910_internal_in (AY38910* ay, int port);
         void ay38910_internal_out(AY38910* ay, int port, unsigned char data);

int ay38910_process(AY38910* ay, int cycle);
int ay38910_channel_process(AY38910* ay, AY38910CHANNEL* channel, int cycle);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* AY-3-8910RAZbg܂B
 * [in]
 *	ay		AY38910\́B
 *	clock		̓NbNB
 *	in		|[g͊O֐B
 *	out		|[go͊O֐B
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́AAY-3-8910ZbgsꍇɁAKvɉČĂяoĂB
 *	* in,outNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  EIN		-1Ԃ܂B
 *	  EOUT		܂B
 */
void ay38910_reset(AY38910* ay, int clock, AY38910INPROC* in, AY38910OUTPROC* out);

/* ̓ǂݏWX^I܂B
 * [in]
 *	ay		AY38910\́B
 *	address		WX^AhXB(0`15)
 */
void ay38910_address(AY38910* ay, int address);

/* WX^lǂݏo܂B
 * [in]
 *	ay		AY38910\́B
 * [out]
 *	߂l		WX^lB
 * [note]
 *	* ǂݏoWX^ԍ́A炩ay38910_address()ɂĐݒ肵ĂĂB
 */
unsigned char ay38910_read(AY38910* ay);

/* WX^l݂܂B
 * [in]
 *	ay		AY38910\́B
 *	data		WX^lB
 * [note]
 *	* ރWX^ԍ́A炩ay38910_address()ɂĐݒ肵ĂĂB
 */
void ay38910_write(AY38910* ay, unsigned char data);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁAw肳ꂽTṽ~LVOs܂B
 * [in]
 *	ay		AY38910\́B
 *	wbuff		o̓Tvobt@B
 *	count		o̓TvB
 */
void ay38910_mix(AY38910* ay, short wbuff[/*count*/], int count);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_AY3_H__*/
