/*
 *	clipafxs.c
 *
 *	AfterEffectsAj[VV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Fri Apr 22 21:42:56 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  /clip/tool/MkAfxSeqXml.jsxŏo͂ꂽAAfterEffectsAj[Vf[^ǂݍōĐ܂B
 *	* Mon Apr 25 22:45:55 JST 2016 Naoyuki Sawa
 *	- /clip/tool/MkAfxSeqXml.jsx<layer>^O<blendingMode>^Oo͂悤ɂȂɔAW[ɂuh[h̏ǉ܂B
 *	* Tue Apr 26 22:39:26 JST 2016 Naoyuki Sawa
 *	- /clip/tool/MkAfxSeqXml.jsx'footage'L[ɘAԃV[PXt@Ĉ߂̏i[悤ɂȂɔAW[ɂAԃV[PXt@Ĉ߂̏ǉ܂B
 *	* Wed Apr 27 21:14:58 JST 2016 Naoyuki Sawa
 *	- /clip/tool/MkAfxSeqXml.jsxAfނ悩AԃV[PXʂsequenceLengthɓK؂Ȓli[悤ɂȂɔAsɓ悩ǂ𔻒肵'footageData.sequenceLength=1'ɏĂ͕svɂȂ폜܂B
 *	- /clip/tool/MkAfxSeqXml.jsxA'frame'L[ɃR[i[s̏i[悤ɂȂɔAW[R[i[s̏QƂĕ`悷悤ɕύX܂B
 *	- /clip/tool/MkAfxSeqXml.jsxAvWFNgplőIĂ镡̃R|WV܂Ƃ߂ĈXMLɏo悤ɂȂɔAW[AfxSeq_Load()̊֐dlύX܂B
 *	  ύXO<AfxSeq>^Öڂ<comp>ǂݍŕԂĂ܂AύX<AfxSeq>^ȎSĂ<comp>ǂݍŁAĂяõAvP[Vɂ͌XɃR[obNŒʒm悤ɂ܂B
 *	* Thu May 05 21:24:20 JST 2016 Naoyuki Sawa
 *	- AfxSeq_Draw()̕`֐̑fID̈A܂ł͑fނ̃x[XIDɃV[PXlZlnĂ܂Afނ̃x[XIDƃV[PXlʂɓn悤ɕύX܂B
 *	  ύXŔAAfxBin_Draw()̕`֐̈̌`(悻)킹邽߂łB
 *	  AfxBin_Draw()̕`֐́Afނ𖼑Oœn̂ŁAV[PXlZ鎖oȂłB
 *	  AfxSeq_Draw()̕`֐ɂ̖͂͂Ȃ̂ŁA܂Œʂfނ̃x[XIDɃV[PXlZlnĂ\Ȃ̂łA`֐̈̌`(悻)킹ՂƎv̂ŁAAfxSeq_Draw()̕`֐̈̌`ύX鎖ɂ܂B
 *	- USE_AFXSEQ`Ȃ΁AAfxSeq_Load(),AfxSeq_Free(),AfxSeq_Draw()܂߂Ȃ悤ɂ܂B
 *	  P/ECEł̓ߖ̂߂ɁÅ֐܂߂Ȃ悤ɂ܂(܂߂鎖\ł͂܂)B
 *	* Mon May 23 22:46:16 JST 2016 Naoyuki Sawa
 *	- ST_AfxSeq\̂ST_AfxLyr\̂ɁAnametB[hǉ܂B
 *	  ǉŔAR|WV⃌C̍ւsꍇɁAsɖȌ񂪕KvɂȂƎvłB
 *	  _ł͂܂AǉnametB[h𗘗pĂ܂񂪁A㗘p\łB
 *	- L̕ύXɔAclipafxs.c,y,clipafxb.c̃R[hA啝ɕύX܂B
 *	  AvP[V̊ϓ_ŕς_́AfnLoad֐ւ̃R|WV̈nAʂ̊֐ł͂ȂApAfxSeq->nameoRŎQƂ悤ɂȂ_݂̂łB
 *	* Mon May 23 23:04:00 JST 2016 Naoyuki Sawa
 *	- ǉnametB[hAAvP[Vp邽߂̎dg݂ǉ܂B
 *	  1. W[̕`֐ɁAfnFilterǉ܂BAvP[V`̃tB^֐w肷鎖ŁAgo[XɊ荞ŃR|WVPʂ̍ւ\łB
 *	  2. AvP[V`fnDraw֐ɁAlayerDepth,layerPathǉ܂BAvP[V`fnDraw֐̒ł̏QƂāA`撼Oł̍ւ\łB
 *	- ܂AL̎dg݂̎gpĂ܂B	TODO:
 */
#include "clip.h"
//
//xNgEϊs
//
/****************************************************************************
 *	O[o萔
 ****************************************************************************/
const ST_AfxVec AfxVec_0 = {0.0,0.0};
const ST_AfxVec AfxVec_x = {1.0,0.0};
const ST_AfxVec AfxVec_y = {0.0,1.0};
/*--------------------------------------------------------------------------*/
const ST_AfxMat AfxMat_0 = {0.0,0.0,0.0,
                            0.0,0.0,0.0};
const ST_AfxMat AfxMat_1 = {1.0,0.0,0.0,
                            0.0,1.0,0.0};
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
void AfxVec_Transform(const ST_AfxMat* pAfxMat, ST_AfxVec* pAfxVec) {	//s|āAẼxNgϊB
	ST_AfxVec tmp = *pAfxVec;
	pAfxVec->x = (pAfxMat->a00 * tmp.x) + (pAfxMat->a01 * tmp.y) + pAfxMat->a02;
	pAfxVec->y = (pAfxMat->a10 * tmp.x) + (pAfxMat->a11 * tmp.y) + pAfxMat->a12;
}
/*--------------------------------------------------------------------------*/
void AfxMat_Transform(ST_AfxMat* pAfxMat1, const ST_AfxMat* pAfxMat2) {	//Es|āA̍sϊB
	ST_AfxMat tmp = *pAfxMat1;
	pAfxMat1->a00 = (tmp.a00 * pAfxMat2->a00) + (tmp.a01 * pAfxMat2->a10);
	pAfxMat1->a01 = (tmp.a00 * pAfxMat2->a01) + (tmp.a01 * pAfxMat2->a11);
	pAfxMat1->a02 = (tmp.a00 * pAfxMat2->a02) + (tmp.a01 * pAfxMat2->a12) + tmp.a02;
	pAfxMat1->a10 = (tmp.a10 * pAfxMat2->a00) + (tmp.a11 * pAfxMat2->a10);
	pAfxMat1->a11 = (tmp.a10 * pAfxMat2->a01) + (tmp.a11 * pAfxMat2->a11);
	pAfxMat1->a12 = (tmp.a10 * pAfxMat2->a02) + (tmp.a11 * pAfxMat2->a12) + tmp.a12;
}
/*--------------------------------------------------------------------------*/
void AfxMat_AnchorPoint(ST_AfxMat* pAfxMat, double x, double y) {	//Es|āA̍sϊB
	AfxMat_Position(pAfxMat, -x, -y);
}
/*--------------------------------------------------------------------------*/
void AfxMat_Position(ST_AfxMat* pAfxMat, double x, double y) {	//Es|āA̍sϊB
	ST_AfxMat tmp = {1.0,0.0,  x,
	                 0.0,1.0,  y};
	AfxMat_Transform(pAfxMat, &tmp);
}
/*--------------------------------------------------------------------------*/
void AfxMat_Scale(ST_AfxMat* pAfxMat, double x, double y) {	//Es|āA̍sϊB
	ST_AfxMat tmp = {  x,0.0,0.0,
	                 0.0,  y,0.0};
	AfxMat_Transform(pAfxMat, &tmp);
}
/*--------------------------------------------------------------------------*/
void AfxMat_Rotation(ST_AfxMat* pAfxMat, double z) {	//Es|āA̍sϊB
	double s = sin(z);
	double c = cos(z);
	ST_AfxMat tmp = {  c, -s,0.0,
	                   s,  c,0.0};
	AfxMat_Transform(pAfxMat, &tmp);
}
#ifdef  USE_AFXSEQ
//
//AfterEffectsAj[VV[PT
//
/****************************************************************************
 *	\
 ****************************************************************************/
typedef struct _AfxSeq_Draw_Param {
	void			(*fnDraw)(int layerDepth, const char* layerPath[], int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int footage, int sequence, double opacity, int blendingMode, void* user_data);	//
	const ST_AfxSeq*	(*fnFilter)(int layerDepth, const char* layerPath[], const ST_AfxSeq* pAfxSeq, void* user_data);													//AfxSeq_Draw()̈
	void*			user_data;																								//
	int			layerDepth;			//
	const char*		layerPath[16/**/];	//layerPath[0]`layerPath[layerDepth-1]=C,layerPath[layerDepth]=NULL	pAR|WVKw15ȉ(I[(NULL)܂߂16ȉ)ƍlď[낤Bsꍇ͑₹B
} AfxSeq_Draw_Param;
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static void AfxSeq_GetVal1(TiXmlNode* xmlNode, const char* tag, short val[/*1*/], int min, int max);
static void AfxSeq_GetVal2(TiXmlNode* xmlNode, const char* tag, short val[/*2*/], int min, int max);
static void AfxSeq_LoadFrame(TiXmlNode* xmlFrame, ST_AfxFra* pAfxFra);
static ST_AfxLyr* AfxSeq_LoadLayer(TiXmlNode* xmlLayer, int (*fnGetFootage)(const char* fileName, void* user_data), void* user_data);
static ST_AfxSeq* AfxSeq_LoadComp(TiXmlNode* xmlComp, int (*fnGetFootage)(const char* fileName, void* user_data), void* user_data);
static void AfxSeq_FreeLayer(ST_AfxLyr* pAfxLyr);
static void AfxSeq_FreeComp(ST_AfxSeq* pAfxSeq);
static void AfxSeq_DrawLayer(const ST_AfxLyr* pAfxLyr, int iFrame, int bLoop, const ST_AfxMat* pAfxMat, double opacity, int blendingMode, AfxSeq_Draw_Param* param);
static void AfxSeq_DrawComp(const ST_AfxSeq* pAfxSeq, int iFrame, int bLoop, const ST_AfxMat* pAfxMat, double opacity, int blendingMode, AfxSeq_Draw_Param* param);
/****************************************************************************
 *	[J֐
 ****************************************************************************/
//u<tag>[[:blank:]]*[[:digit:]]+[[:blank:]]*</tag>v`̒l擾B
static void AfxSeq_GetVal1(TiXmlNode* xmlNode, const char* tag, short val[/*1*/], int min, int max) {
	TiXmlElement* xmlElem;
	TiXmlText* xmlText;
	const char* text;
	int x, dummy;
	xmlElem = TiXmlNode_FirstChildElement(xmlNode, tag);
	if(!xmlElem) { DIE(); }
	xmlText = TiXmlNode_ToText(TiXmlNode_FirstChild(TiXmlElement_super(xmlElem), NULL));
	if(!xmlText) { DIE(); }
	text = TiXmlNode_Value(TiXmlText_super(xmlText));
	if(sscanf(text, "%d %c", &x, (char*)&dummy) != 1) { DIE(); }	//'(char*)'LXgGCCsscanf̏𗝉Čx\̂}邽߂łB
	//                 |++-------+++++++++++++--- '%*c'łȂ'%c'K{łB'%*c'ł͖߂lɐȂ̂ŕsłB_~[ϐɊi[KvL܂B
	//                 +------------------------- ̋󔒂͕KvłB'%c'͈ÖٓIɋ󔒂ǂݔ΂Ȃ̂ŁAɖIɋ󔒂ǂݔ΂Ă߂łB
	if((x < min) || (x > max)) { DIE(); }
	val[0] = x;
}
/*--------------------------------------------------------------------------*/
//u<tag>[[:blank:]]*[[:digit:]]+[[:blank:]]*,[[:blank:]]*[[:digit:]]+[[:blank:]]*</tag>v`̒l擾B
static void AfxSeq_GetVal2(TiXmlNode* xmlNode, const char* tag, short val[/*2*/], int min, int max) {
	TiXmlElement* xmlElem;
	TiXmlText* xmlText;
	const char* text;
	int x, y, dummy;
	xmlElem = TiXmlNode_FirstChildElement(xmlNode, tag);
	if(!xmlElem) { DIE(); }
	xmlText = TiXmlNode_ToText(TiXmlNode_FirstChild(TiXmlElement_super(xmlElem), NULL));
	if(!xmlText) { DIE(); }
	text = TiXmlNode_Value(TiXmlText_super(xmlText));
	if(sscanf(text, "%d,%d %c", &x, &y, (char*)&dummy) != 2) { DIE(); }	//'(char*)'LXgGCCsscanf̏𗝉Čx\̂}邽߂łB
	//                    |++-----------+++++++++++++--- '%*c'łȂ'%c'K{łB'%*c'ł͖߂lɐȂ̂ŕsłB_~[ϐɊi[KvL܂B
	//                    +----------------------------- ̋󔒂͕KvłB'%c'͈ÖٓIɋ󔒂ǂݔ΂Ȃ̂ŁAɖIɋ󔒂ǂݔ΂Ă߂łB
	if(((x < min) || (x > max)) ||
	   ((y < min) || (y > max))) { DIE(); }
	val[0] = x;
	val[1] = y;
}
/*--------------------------------------------------------------------------*/
//<frame>`</frame>ǂݍށB
static void AfxSeq_LoadFrame(TiXmlNode* xmlFrame, ST_AfxFra* pAfxFra) {
	AfxSeq_GetVal2(xmlFrame, "anchorPoint", pAfxFra->anchorPoint, SHRT_MIN,  SHRT_MAX);
	AfxSeq_GetVal2(xmlFrame, "position",    pAfxFra->position,    SHRT_MIN,  SHRT_MAX);
	AfxSeq_GetVal2(xmlFrame, "scale",       pAfxFra->scale,       SHRT_MIN,  SHRT_MAX);
	AfxSeq_GetVal1(xmlFrame, "rotation",   &pAfxFra->rotation,    SHRT_MIN,  SHRT_MAX);
	AfxSeq_GetVal1(xmlFrame, "opacity",    &pAfxFra->opacity,            0, USHRT_MAX);
	{//<cornerPin>
		TiXmlElement* xmlCornerPin = TiXmlNode_FirstChildElement(xmlFrame, "cornerPin");
		if(!xmlCornerPin) { DIE(); }
		AfxSeq_GetVal2(TiXmlElement_super(xmlCornerPin), "topLeft",     pAfxFra->cornerPin[0], SHRT_MIN, SHRT_MAX);
		AfxSeq_GetVal2(TiXmlElement_super(xmlCornerPin), "topRight",    pAfxFra->cornerPin[1], SHRT_MIN, SHRT_MAX);
		AfxSeq_GetVal2(TiXmlElement_super(xmlCornerPin), "bottomRight", pAfxFra->cornerPin[2], SHRT_MIN, SHRT_MAX);	//TriangleFan̕
		AfxSeq_GetVal2(TiXmlElement_super(xmlCornerPin), "bottomLeft",  pAfxFra->cornerPin[3], SHRT_MIN, SHRT_MAX);	//
	}//</frames>
}
/*--------------------------------------------------------------------------*/
//<layer>`</layer>ǂݍށB
static ST_AfxLyr* AfxSeq_LoadLayer(TiXmlNode* xmlLayer, int (*fnGetFootage)(const char* fileName, void* user_data), void* user_data) {
	ST_AfxLyr* pAfxLyr;
	TiXmlText* xmlText;
	const char* name = TiXmlElement_Attribute(TiXmlNode_ToElement(xmlLayer), "name");
	if(!name) { DIE(); }
#ifdef  _DEBUG
	syslog(LOG_DEBUG, "AfxSeq_LoadLayer: name='%s'", name);
#endif//_DEBUG
	{
		GArray* arFrame = g_array_new(0, 0, sizeof(ST_AfxFra));
		{//<frames>
			TiXmlElement* xmlFrames = TiXmlNode_FirstChildElement(xmlLayer, "frames");
			if(!xmlFrames) { DIE(); }
			{//<frame>
				TiXmlElement* xmlFrame;
				for(xmlFrame = TiXmlNode_FirstChildElement(TiXmlElement_super(xmlFrames), "frame");
				    xmlFrame;
				    xmlFrame = TiXmlNode_NextSiblingElement(TiXmlElement_super(xmlFrame), "frame")) {
					ST_AfxFra afxFra;
					AfxSeq_LoadFrame(TiXmlElement_super(xmlFrame), &afxFra);
					g_array_append_val(arFrame, afxFra);
				}
			}//</frame>
		}//</frames>
		if(!arFrame->len || (arFrame->len > USHRT_MAX)) { DIE(); }
		pAfxLyr = malloc(sizeof(ST_AfxLyr) +
		                (sizeof(ST_AfxFra) * arFrame->len) +
		                (strlen(name) + 1/*nul*/));				//ST_AfxLyr.nameẃAʂstrdup()̂ł͂ȂAST_AfxLyr.frames[nFrames]̌ɂ܂Ƃ߂Ċmۂ鎖ɂB
		memcpy(pAfxLyr->frames, arFrame->data, sizeof(ST_AfxFra) * arFrame->len);
		pAfxLyr->nFrames = arFrame->len;
		g_array_unref(arFrame);
	}
	pAfxLyr->name = strcpy((char*)&pAfxLyr->frames[pAfxLyr->nFrames], name);	//ST_AfxLyr.nameẃAʂstrdup()̂ł͂ȂAST_AfxLyr.frames[nFrames]̌ɂ܂Ƃ߂Ċmۂ鎖ɂB
	AfxSeq_GetVal1(xmlLayer, "startFrame", &pAfxLyr->startFrame, 0, USHRT_MAX);
	{//<blendingMode>
		TiXmlElement* xmlBlendingMode = TiXmlNode_FirstChildElement(xmlLayer, "blendingMode");
		if(!xmlBlendingMode) { DIE(); }
		xmlText = TiXmlNode_ToText(TiXmlNode_FirstChild(TiXmlElement_super(xmlBlendingMode), NULL));
		if(!xmlText) { DIE(); }
		name = TiXmlNode_Value(TiXmlText_super(xmlText));
		if(!strcasecmp(name, "NORMAL")) {
			pAfxLyr->blendingMode	= 0;	//0:NORMAL
		} else if(!strcasecmp(name, "ADD")) {
			pAfxLyr->blendingMode	= 1;	//1:ADD
    //TODO:	} else if(!strcasecmp(name, "...")) {			AAfterEffects̑̃uh[hɂΉAɃR[hǉĉB
    //TODO:		pAfxLyr->blendingMode	= ?;	//?:...		
		} else {
			DIE();
		}
	}//</blendingMode>
	{//<footage>
		TiXmlElement* xmlFootage = TiXmlNode_FirstChildElement(xmlLayer, "footage");
		//̃C<footage>`</footage>L΁c
		if(xmlFootage) {
			TiXmlElement* xmlFileName;
			const char* fileName;
			xmlFileName = TiXmlNode_FirstChildElement(TiXmlElement_super(xmlFootage), "fileName");
			if(!xmlFileName) { DIE(); }
			xmlText = TiXmlNode_ToText(TiXmlNode_FirstChild(TiXmlElement_super(xmlFileName), NULL));
			if(!xmlText) { DIE(); }
			fileName = TiXmlNode_Value(TiXmlText_super(xmlText));
			AfxSeq_GetVal1(TiXmlElement_super(xmlFootage), "sequenceLength", &pAfxLyr->sequenceLength, 1, USHRT_MAX);
#ifdef  _DEBUG
			syslog(LOG_DEBUG, "AfxSeq_LoadLayer: footage fileName='%s', sequenceLength = %d", fileName, pAfxLyr->sequenceLength);
#endif//_DEBUG
			pAfxLyr->footage = (*fnGetFootage)(fileName, user_data);
		//̃C<footage>`</footage>΁c
		} else {
			pAfxLyr->footage = -1;		//(sequenceLength=0)Ȃ(footage=sl)ō\Ȃ̂ł̍s͏ȗ\AfobOՂ̂߂(footage=-1)i[ĂɂB
			pAfxLyr->sequenceLength = 0;
		}
	}//</footage>
	{//<comp>
		TiXmlElement* xmlComp = TiXmlNode_FirstChildElement(xmlLayer, "comp");
		//̃C<comp>`</comp>L΁c
		if(xmlComp) {
			pAfxLyr->pAfxSeq = AfxSeq_LoadComp(TiXmlElement_super(xmlComp), fnGetFootage, user_data);
		//̃C<comp>`</comp>΁c
		} else {
			pAfxLyr->pAfxSeq = NULL;
		}
	}//</comp>
	return pAfxLyr;
}
/*--------------------------------------------------------------------------*/
//<comp>`</comp>ǂݍށB
static ST_AfxSeq* AfxSeq_LoadComp(TiXmlNode* xmlComp, int (*fnGetFootage)(const char* fileName, void* user_data), void* user_data) {
	ST_AfxSeq* pAfxSeq;
	const char* name = TiXmlElement_Attribute(TiXmlNode_ToElement(xmlComp), "name");
	if(!name) { DIE(); }
#ifdef  _DEBUG
	syslog(LOG_DEBUG, "AfxSeq_LoadComp: name='%s'", name);
#endif//_DEBUG
	{
		GPtrArray* arLayer = g_ptr_array_new();
		{//<layers>
			TiXmlElement* xmlLayers = TiXmlNode_FirstChildElement(xmlComp, "layers");
			if(!xmlLayers) { DIE(); }
			{//<layer>
				TiXmlElement* xmlLayer;
				for(xmlLayer = TiXmlNode_FirstChildElement(TiXmlElement_super(xmlLayers), "layer");
				    xmlLayer;
				    xmlLayer = TiXmlNode_NextSiblingElement(TiXmlElement_super(xmlLayer), "layer")) {
					ST_AfxLyr* pAfxLyr = AfxSeq_LoadLayer(TiXmlElement_super(xmlLayer), fnGetFootage, user_data);
					g_ptr_array_add(arLayer, pAfxLyr);
				}
			}//</layer>
		}//</layers>
		if(!arLayer->len || (arLayer->len > USHRT_MAX)) { DIE(); }
		pAfxSeq = malloc(sizeof(ST_AfxSeq) +
		                (sizeof(ST_AfxLyr*) * arLayer->len) +
		                (strlen(name) + 1/*nul*/));				//ST_AfxSeq.nameẃAʂstrdup()̂ł͂ȂAST_AfxSeq.layers[nLayers]̌ɂ܂Ƃ߂Ċmۂ鎖ɂB
		memcpy(pAfxSeq->layers, arLayer->pdata, sizeof(ST_AfxLyr*) * arLayer->len);
		pAfxSeq->nLayers = arLayer->len;
		g_ptr_array_unref(arLayer);
	}
	pAfxSeq->name = strcpy((char*)&pAfxSeq->layers[pAfxSeq->nLayers], name);	//ST_AfxSeq.nameẃAʂstrdup()̂ł͂ȂAST_AfxSeq.layers[nLayers]̌ɂ܂Ƃ߂Ċmۂ鎖ɂB
	AfxSeq_GetVal1(xmlComp, "totalFrame", &pAfxSeq->totalFrame, 1, USHRT_MAX);
	return pAfxSeq;
}
/*--------------------------------------------------------------------------*/
static void AfxSeq_FreeLayer(ST_AfxLyr* pAfxLyr) {
	if(pAfxLyr->pAfxSeq) {
		AfxSeq_FreeComp(pAfxLyr->pAfxSeq);
	}
	free(pAfxLyr);									//ST_AfxLyr.nameẃAST_AfxLyr.frames[nFrames]̌ɂ܂Ƃ߂ĊmۂĂ̂ŁAfree()ňꏏɊJoB
}
/*--------------------------------------------------------------------------*/
static void AfxSeq_FreeComp(ST_AfxSeq* pAfxSeq) {
	int iLayer;
	for(iLayer = 0; iLayer < pAfxSeq->nLayers; iLayer++) {
		AfxSeq_FreeLayer(pAfxSeq->layers[iLayer]);
	}
	free(pAfxSeq);									//ST_AfxSeq.nameẃAST_AfxSeq.layers[nLayers]̌ɂ܂Ƃ߂ĊmۂĂ̂ŁAfree()ňꏏɊJoB
}
/*--------------------------------------------------------------------------*/
static void AfxSeq_DrawLayer(const ST_AfxLyr* pAfxLyr, int iFrame, int bLoop, const ST_AfxMat* pAfxMat, double opacity, int blendingMode, AfxSeq_Draw_Param* param) {
	iFrame -= pAfxLyr->startFrame;
	if((unsigned)iFrame < pAfxLyr->nFrames) {
		const ST_AfxFra* pAfxFra = &pAfxLyr->frames[iFrame];
		ST_AfxMat tmp = *pAfxMat;
		AfxMat_Position(&tmp, pAfxFra->position[0], pAfxFra->position[1]);
		AfxMat_Rotation(&tmp, (pAfxFra->rotation * (M_PI / 180.0)));
		AfxMat_Scale(&tmp, (pAfxFra->scale[0] / 100.0), (pAfxFra->scale[1] / 100.0));
		AfxMat_AnchorPoint(&tmp, pAfxFra->anchorPoint[0], pAfxFra->anchorPoint[1]);
		opacity *= (pAfxFra->opacity / 100.0);
		if(pAfxLyr->blendingMode) { blendingMode = pAfxLyr->blendingMode; }
		if(pAfxLyr->sequenceLength) {
			ST_AfxVec v[4] = {{pAfxFra->cornerPin[0][0],pAfxFra->cornerPin[0][1]},	//topLeft
			                  {pAfxFra->cornerPin[1][0],pAfxFra->cornerPin[1][1]},	//topRight
			                  {pAfxFra->cornerPin[2][0],pAfxFra->cornerPin[2][1]},	//bottomRight	//TriangleFan̕
			                  {pAfxFra->cornerPin[3][0],pAfxFra->cornerPin[3][1]}};	//bottomLeft	//
			int i;
			for(i = 0; i < 4; i++) {
				AfxVec_Transform(&tmp, &v[i]);
			}
			(*param->fnDraw)(
				param->layerDepth,
				param->layerPath,
				v[0].x, v[0].y,	//topLeft
				v[1].x, v[1].y,	//topRight
				v[2].x, v[2].y,	//bottomRight	//TriangleFan̕
				v[3].x, v[3].y,	//bottomLeft	//
				pAfxLyr->footage,
				iFrame % pAfxLyr->sequenceLength,	//AԃV[PXt@CΉ
				opacity,
				blendingMode,
				param->user_data);
		}
		if(pAfxLyr->pAfxSeq) {
			AfxSeq_DrawComp(
				pAfxLyr->pAfxSeq,
				iFrame, bLoop,
				&tmp,
				opacity,
				blendingMode,
				param);
		}
	}
}
/*--------------------------------------------------------------------------*/
#undef  USE_CLAMP
#define USE_CLAMP	//̃V{`邩ȂɂāA(bLoop=0)w肳ꂽ̋ς܂BiFrame[0,totalFrame-1]͈̔͂ɃNvĕ`悷ꍇ́A̍sLɂĉBiFrame͈͊OȂ΂̃R|WV`悵Ȃꍇ́A̍sRgAEgĉB
static void AfxSeq_DrawComp(const ST_AfxSeq* pAfxSeq, int iFrame, int bLoop, const ST_AfxMat* pAfxMat, double opacity, int blendingMode, AfxSeq_Draw_Param* param) {
	pAfxSeq = (*param->fnFilter)(param->layerDepth, param->layerPath, pAfxSeq, param->user_data);
	if(pAfxSeq) {	//AvP[V`̃tB^֐NULLԂꍇ́ÃR|WVKwȉ̏sȂB
		int iLayer;
		if(bLoop) {
			iFrame %= pAfxSeq->totalFrame;
			if(iFrame < 0) { iFrame += pAfxSeq->totalFrame; }
#ifdef  USE_CLAMP
		} else {
			iFrame = clamp(iFrame, 0, (pAfxSeq->totalFrame - 1));
#endif//USE_CLAMP
		}
#ifndef USE_CLAMP
		if((unsigned)iFrame < pAfxSeq->totalFrame) {
#endif//USE_CLAMP
			if(++param->layerDepth >= ARRAY_SIZE(param->layerPath)) { DIE(); }	//Œ~AAfxSeq_Draw_Param.layerPath[]̗vf𑝂₵ĉB
			for(iLayer = pAfxSeq->nLayers - 1; iLayer >= 0; iLayer--) {	//AfterEffects̓^CCplŏɗL郌CقǎOɕ`悷悤łB܂vOł͕`揇tɂAfterEffectsƓɂȂ܂B
				ST_AfxLyr* pAfxLyr = pAfxSeq->layers[iLayer];
				param->layerPath[param->layerDepth - 1] = pAfxLyr->name;
			//sv	param->layerPath[param->layerDepth] = NULL;	//layerPath[]̏l͑SvfNULLłAAKw̏IɃ|C^NULLɖ߂Ă̂ŁAŏI[NULLi[Kv͗L܂B
				AfxSeq_DrawLayer(pAfxLyr, iFrame, bLoop, pAfxMat, opacity, blendingMode, param);	//     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			}												//				
			param->layerPath[--param->layerDepth] = NULL;	//Kv	//
#ifndef USE_CLAMP
		}
#endif//USE_CLAMP
	}
}
#undef  USE_CLAMP
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
void AfxSeq_Load(const char* path, void (*fnLoad)(ST_AfxSeq* pAfxSeq, void* user_data), int (*fnGetFootage)(const char* fileName, void* user_data), void* user_data) {
	TiXmlDocument* xmlDoc = TiXmlDocument_new(NULL);
	TiXmlDocument_LoadFile(xmlDoc, path);
	{//<AfxSeq>
		TiXmlElement* xmlAfxSeq = TiXmlNode_FirstChildElement(TiXmlDocument_super(xmlDoc), "AfxSeq");
		if(!xmlAfxSeq) { DIE(); }
		{//<comp>
			TiXmlElement* xmlComp;
			for(xmlComp = TiXmlNode_FirstChildElement(TiXmlElement_super(xmlAfxSeq), "comp");
			    xmlComp;
			    xmlComp = TiXmlNode_NextSiblingElement(TiXmlElement_super(xmlComp), "comp")) {
				ST_AfxSeq* pAfxSeq = AfxSeq_LoadComp(TiXmlElement_super(xmlComp), fnGetFootage, user_data);
				(*fnLoad)(pAfxSeq, user_data);
			}
		}//</comp>
	}//</AfxSeq>
	TiXmlDocument_delete(xmlDoc);
}
/*--------------------------------------------------------------------------*/
void AfxSeq_Free(ST_AfxSeq* pAfxSeq) {
	AfxSeq_FreeComp(pAfxSeq);
}
/*--------------------------------------------------------------------------*/
static void AfxSeq_Draw_fnDraw(int layerDepth, const char* layerPath[], int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int footage, int sequence, double opacity, int blendingMode, void* user_data) { /** no job **/ }
static const ST_AfxSeq* AfxSeq_Draw_fnFilter(int layerDepth, const char* layerPath[], const ST_AfxSeq* pAfxSeq, void* user_data) { return pAfxSeq; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void AfxSeq_Draw(const ST_AfxSeq* pAfxSeq, int iFrame, int bLoop, const ST_AfxMat* pAfxMat, double opacity, int blendingMode,
                 void (*fnDraw/*NULL*/)(int layerDepth, const char* layerPath[], int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int footage, int sequence, double opacity, int blendingMode, void* user_data),
                 const ST_AfxSeq* (*fnFilter/*NULL*/)(int layerDepth, const char* layerPath[], const ST_AfxSeq* pAfxSeq, void* user_data),
                 void* user_data) {
	AfxSeq_Draw_Param param;
	memset(&param, 0, sizeof param);	//layerDepth,y,layerPath̑SvfNULLƂ邽߂ɃNAKvBڍׂAfxSeq_DrawComp()̃RgQƂĉB
	param.fnDraw    = fnDraw   ? fnDraw   : AfxSeq_Draw_fnDraw;
	param.fnFilter  = fnFilter ? fnFilter : AfxSeq_Draw_fnFilter;
	param.user_data = user_data;
	AfxSeq_DrawComp(pAfxSeq, iFrame, bLoop, pAfxMat, opacity, blendingMode, &param);
}
#endif//USE_AFXSEQ
