/*	
 *	DxlibHelper_SpriteFont.cpp
 *
 *	DxLibwp[֐(DxLibp̃XvCgtHg`)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015-2016 Naoyuki Sawa
 *
 *	* Tue Aug 16 21:54:11 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- DxLibp̃XvCgtHg`ǉ܂B
 *	  ́ADxlibHelper_SpriteFont.cppɗL܂B
 */
#include "clip.h"
/****************************************************************************
 *	\
 ****************************************************************************/
/*typedef*/ struct _ST_SprFnt {
	ght_hash_table_t*	ht_Char;	//R[h(0x0000`0xFFFF)(ST_SprFnt_Char*)BR[h0x0000́AtH[obNp̕`ݒƌȂB`悵悤Ƃ̃XvCg`ĂȂꍇAtH[obNp̕`ݒ肪L΂`悷BtH[obNp̕`ݒ΁AG[~B
} /*ST_SprFnt*/;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
typedef struct _ST_SprFnt_Char {
	int			SprNo;		//XvCgԍBXvCgꍇ(-1)ƂBXvCgĂǂ̂́ApXy[X,,SpXy[X̏ꍇ݂̂łBpXy[X,,SpXy[X̏ꍇłAXvCgw肷鎖͉\łB
	int			DrawX;		//`ItZbgXBXvCg_XÄʒuɕ`悵܂B
	int			DrawY;		//`ItZbgYBXvCg_YÄʒuɕ`悵܂B
	int			NextX;		//XgChB̕`A̒l̕AE֐i݂܂B
	int			NextY;		//sXgChBsɕ`́A̒l̓Aő̒l̕Asɉ֐i݂܂B
} ST_SprFnt_Char;
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static ST_SprFnt* SprFnt_Load_Parse(yaml_document_t* d, const void* pEnmKey, int _RegKey_SprNo, const char* FontName);
static void SprFnt_Draw_subr1(ST_SprFnt* pSprFnt, int* p_size_x, int* p_size_y, const char* s);
static void SprFnt_Draw_subr2(ST_SprFnt* pSprFnt, double x, double y, double scale_x, double scale_y, int rgba, int mode, const char* s);
/****************************************************************************
 *	
 ****************************************************************************/
ST_SprFnt* SprFnt_Load(const char* fname, const void* pEnmKey, int _RegKey_SprNo, const char* FontName/* = "Font"*/) {
	yaml_document_t* d = yaml_document_load(fname);
	ST_SprFnt* pSprFnt = SprFnt_Load_Parse(d, pEnmKey, _RegKey_SprNo, FontName);
	yaml_document_free(d);
	return pSprFnt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
ST_SprFnt* SprFnt_Parse(const char* s, const void* pEnmKey, int _RegKey_SprNo, const char* FontName/* = "Font"*/) {
	yaml_document_t* d = yaml_document_parse(s);
	ST_SprFnt* pSprFnt = SprFnt_Load_Parse(d, pEnmKey, _RegKey_SprNo, FontName);
	yaml_document_free(d);
	return pSprFnt;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static ST_SprFnt* SprFnt_Load_Parse(yaml_document_t* d, const void* pEnmKey, int _RegKey_SprNo, const char* FontName) {
	ST_SprFnt* pSprFnt = (ST_SprFnt*)calloc(sizeof(ST_SprFnt), 1);
	if(!pSprFnt) { DIE(); }
	pSprFnt->ht_Char = ght_create(0);
	ght_set_rehash(pSprFnt->ht_Char, 1);
	{
		//XvCg̔r֐擾ĂB
		int (*compar)(const char*, const char*) = EnmDef_GetCanonicalNameCompar(pEnmKey, _RegKey_SprNo);
		if(!compar) { DIE(); }
		{
			//w肳ꂽtHg̃m[h擾B
			yaml_mapping_t* mFont = yaml_path_get_mapping(d, NULL, FontName);
			//tHg̊l擾B
			int Font_DrawX       = 0, Font_DrawY       = 0, Font_NextX       = 0, Font_NextY       = 0;	//tHg̊l`ĂȂ0.0̂܂܂ƂB
			int Font_DrawX_Valid = 0, Font_DrawY_Valid = 0, Font_NextX_Valid = 0, Font_NextY_Valid = 0;	//tHg̊l`ĂȂ  0̂܂܂ƂB
			SEH_try { Font_DrawX = yaml_mapping_get_number(d, mFont, "DrawX"); Font_DrawX_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//`ItZbgX
			SEH_try { Font_DrawY = yaml_mapping_get_number(d, mFont, "DrawY"); Font_DrawY_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//`ItZbgY
			SEH_try { Font_NextX = yaml_mapping_get_number(d, mFont, "NextX"); Font_NextX_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//XgCh
			SEH_try { Font_NextY = yaml_mapping_get_number(d, mFont, "NextY"); Font_NextY_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//sXgCh
			{
				//̃[gm[h擾B
				yaml_mapping_t* mCharRoot = yaml_mapping_get_mapping(d, mFont, "Char");
				//eɂāc
				int i, n = yaml_mapping_get_count(d, mCharRoot);
				for(i = 0; i < n; i++) {
					const char* CharName = yaml_mapping_get_key(d, mCharRoot, i);
					//R[h擾B
					int CharCode = mbsnextc(CharName);
					//󕶎Ȃ΁c
					if(!CharCode) {
						//tH[obNp̕`ݒƌȂāApB
						/** no job **/
					//󕶎łȂ΁c
					} else {
						//̃L[́AꕶłȂ΂ȂȂB
						if(*mbsinc(CharName)) { DIE(); }				//Œ~ꍇ́A炭AvP[V`Yamlt@C̊ԈႢłB
						//1oCgȂ΁A\\ȕłȂ΂ȂȂB
						if((CharCode <= UCHAR_MAX) && !isprint(CharCode)) { DIE(); }	//Œ~ꍇ́A炭AvP[V`Yamlt@C̊ԈႢłB
					}
					{
						//̃m[h擾B
						yaml_mapping_t* mChar = yaml_mapping_get_mapping(d, mCharRoot, CharName);
						//̐ݒl擾B
						const char* SprNo_Name;		//XvCg(񋓒l̖O)	K{BpXy[X,,SpXy[X̏ꍇ̂݋󕶎B
						int Char_DrawX       = 0, Char_DrawY       = 0, Char_NextX       = 0, Char_NextY       = 0;	//̐ݒl`ĂȂ0.0̂܂܂ƂB
						int Char_DrawX_Valid = 0, Char_DrawY_Valid = 0, Char_NextX_Valid = 0, Char_NextY_Valid = 0;	//̐ݒl`ĂȂ  0̂܂܂ƂB
						          SprNo_Name = yaml_mapping_get_string(d, mChar, "SprNo");								//XvCg(񋓒l̖O)	K{BpXy[X,,SpXy[X̏ꍇ̂݋󕶎B
						SEH_try { Char_DrawX = yaml_mapping_get_number(d, mChar, "DrawX"); Char_DrawX_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//`ItZbgX
						SEH_try { Char_DrawY = yaml_mapping_get_number(d, mChar, "DrawY"); Char_DrawY_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//`ItZbgY
						SEH_try { Char_NextX = yaml_mapping_get_number(d, mChar, "NextX"); Char_NextX_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//XgCh
						SEH_try { Char_NextY = yaml_mapping_get_number(d, mChar, "NextY"); Char_NextY_Valid = 1; } SEH_catch(YamlException) { } SEH_end	//sXgCh
						{
							int SprNo;		//XvCgԍ(񋓒l)	XvCg󕶎Ȃ-1ƂB
							ST_SprDef stSprDef;	//XvCg`
							//XvCg󕶎łȂ΁c
							if(*SprNo_Name) {
								//XvCgAXvCgԍ擾B
								SprNo = EnmDef_GetVal_UseCompar(pEnmKey, _RegKey_SprNo, SprNo_Name, compar);
								if(SprNo == -1) { DIE(); }	//SprNoL[Ŏw肳ꂽXvCgɈvXvCg݂Ȃ΁AG[~B炭AvP[V`Yamlt@C̊ԈႢłB
								//XvCg`擾B
								get_sprDef(SprNo, &stSprDef);
							//XvCg󕶎Ȃ΁c
							} else {
								//XvCg`ĂȂĂǂ̂́ApXy[X,,SpXy[X̏ꍇ݂̂łB
								if((CharCode != 0x20) && (CharCode != 0x8140)) { DIE(); }	//Œ~ꍇ́A炭AvP[V`Yamlt@C̊ԈႢłB
								SprNo = -1;
								//XvCg`NAB
								memset(&stSprDef, 0, sizeof stSprDef);
							}
							//̐ݒlɁA`ItZbgX`ĂȂ΁c
							if(!Char_DrawX_Valid) {
								//tHg̊lɁA`ItZbgX`Ăc
								if(Font_DrawX_Valid) {
									//tHg̊lA`ItZbgX擾B
									Char_DrawX = Font_DrawX;
								}
							}
							//̐ݒlɁA`ItZbgY`ĂȂ΁c
							if(!Char_DrawY_Valid) {
								//tHg̊lɁA`ItZbgY`Ăc
								if(Font_DrawY_Valid) {
									//tHg̊lA`ItZbgY擾B
									Char_DrawY = Font_DrawX;
								}
							}
							//̐ݒlɁAXgCh`ĂȂ΁c
							if(!Char_NextX_Valid) {
								//tHg̊lɁAXgCh`Ăc
								if(Font_NextX_Valid) {
									//tHg̊lAXgCh擾B
									Char_NextX = Font_NextX;
								//tHg̊lɂAXgCh`ĂȂ΁c
								} else {
									//XvCg̕AXgChƂB
									Char_NextX = stSprDef.w;
								}
							}
							//̐ݒlɁAsXgCh`ĂȂ΁c
							if(!Char_NextY_Valid) {
								//tHg̊lɁAsXgCh`Ăc
								if(Font_NextY_Valid) {
									//tHg̊lAsXgCh擾B
									Char_NextY = Font_NextY;
								//tHg̊lɂAsXgCh`ĂȂ΁c
								} else {
									//XvCg̍AsXgChƂB
									Char_NextY = stSprDef.h;
								}
							}
							{
								//o^B
								ST_SprFnt_Char* pChar = (ST_SprFnt_Char*)calloc(sizeof(ST_SprFnt_Char), 1);
								if(!pChar) { DIE(); }
								pChar->SprNo = SprNo;		//XvCgԍ
								pChar->DrawX = Char_DrawX;	//`ItZbgX
								pChar->DrawY = Char_DrawY;	//`ItZbgY
								pChar->NextX = Char_NextX;	//XgCh
								pChar->NextY = Char_NextY;	//sXgCh
								if(ght_insert(pSprFnt->ht_Char, pChar, sizeof CharCode, &CharCode)) { DIE(); }	//dĂB炭AvP[V`Yamlt@C̊ԈႢłB
#ifdef  _DEBUG
								syslog(LOG_DEBUG, "%s(%s): SprNo='%s' DrawX=%g DrawY=%g NextX=%g NextY=%g", FontName, CharName, SprNo_Name, Char_DrawX, Char_DrawY, Char_NextX, Char_NextY);
#endif//_DEBUG
							}
						}
					}
				}
			}
		}
	}
	return pSprFnt;
}
/*--------------------------------------------------------------------------*/
void SprFnt_Free(ST_SprFnt* pSprFnt) {
	ght_iterator_t it;
	ST_SprFnt_Char* pChar;
	for(pChar = (ST_SprFnt_Char*)ght_first(pSprFnt->ht_Char, &it, NULL);
	    pChar;
	    pChar = (ST_SprFnt_Char*)ght_next( pSprFnt->ht_Char, &it, NULL)) { free(pChar); }
	ght_finalize(pSprFnt->ht_Char);
	free(pSprFnt);
}
/*--------------------------------------------------------------------------*/
void SprFnt_Draw(ST_SprFnt* pSprFnt, int x, int y, double scale_x, double scale_y, double ax, double ay, int rgba, int mode, const char* s) {
	int size_x, size_y;
	SprFnt_Draw_subr1(pSprFnt, &size_x, &size_y, s);
	x -= (size_x * scale_x * ax);
	y -= (size_y * scale_y * ay);
	SprFnt_Draw_subr2(pSprFnt, x, y, scale_x, scale_y, rgba, mode, s);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void SprFnt_DrawV(ST_SprFnt* pSprFnt, int x, int y, double scale_x, double scale_y, double ax, double ay, int rgba, int mode, const char* fmt, va_list ap) {
	char* s = strdup_vprintf(fmt, ap);
	SprFnt_Draw(pSprFnt, x, y, scale_x, scale_y, ax, ay, rgba, mode, s);
	free(s);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void SprFnt_DrawF(ST_SprFnt* pSprFnt, int x, int y, double scale_x, double scale_y, double ax, double ay, int rgba, int mode, const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	SprFnt_DrawV(pSprFnt, x, y, scale_x, scale_y, ax, ay, rgba, mode, fmt, ap);
	va_end(ap);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void SprFnt_Draw_subr1(ST_SprFnt* pSprFnt, int* p_size_x, int* p_size_y, const char* s) {
	//ASY͊Tclippce.crender_string()ƓłB
	int x = 0, y = 0, size_x = 0, size_y = 0;
	int c, h = 0;
	while((c = mbsnextc(s))) {
		if(c == '\n') {
			x = 0;
			y += h;
			h = 0;
		} else {
			//̕̕`ݒ擾B
			ST_SprFnt_Char* pChar = (ST_SprFnt_Char*)ght_get(pSprFnt->ht_Char, sizeof c, &c);
			//̕̕`ݒ肪΁c
			if(!pChar) {
				//tH[obNp̕`ݒ擾B
				static const int c0;	//tH[obNp̕`ݒ̕R[h(0x0000)
				pChar = (ST_SprFnt_Char*)ght_get(pSprFnt->ht_Char, sizeof c0, &c0);
				if(!pChar) { DIE(); }	//tH[obNp̕`ݒ΁AG[~B
			}
			//XgCh̕A̕`ʒuE֐i߂B
			x += pChar->NextX;
			//݂̍sɕ`́AsXgCh̍őlXVB
			h = max(h, pChar->NextY);
			//TCYXVB
			if(x > size_x) { size_x = x; }
			if((y + h) > size_y) { size_y = (y + h); }
		}
		s = mbsinc(s);
	}
	*p_size_x = size_x;
	*p_size_y = size_y;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void SprFnt_Draw_subr2(ST_SprFnt* pSprFnt, double x, double y, double scale_x, double scale_y, int rgba, int mode, const char* s) {
	const double x0 = x;
	int c, h = 0;
	while((c = mbsnextc(s))) {
		if(c == '\n') {
			x = x0;
			y += h * scale_y;
			h = 0;
		} else {
			//̕̕`ݒ擾B
			ST_SprFnt_Char* pChar = (ST_SprFnt_Char*)ght_get(pSprFnt->ht_Char, sizeof c, &c);
			//̕̕`ݒ肪΁c
			if(!pChar) {
				//tH[obNp̕`ݒ擾B
				static const int c0;	//tH[obNp̕`ݒ̕R[h(0x0000)
				pChar = (ST_SprFnt_Char*)ght_get(pSprFnt->ht_Char, sizeof c0, &c0);
				if(!pChar) { DIE(); }	//tH[obNp̕`ݒ΁AG[~B
			}
			//XvCgԍL΁c
			if(pChar->SprNo != -1) {
				//XvCg`悷B
				draw_spr2(
					x + (pChar->DrawX * scale_x),
					y + (pChar->DrawY * scale_y),
					pChar->SprNo,
					scale_x,
					scale_y,
					0.0,
					rgba,
					mode);
			}
			//XgCh̕A̕`ʒuE֐i߂B
			x += pChar->NextX * scale_x;
			//݂̍sɕ`́AsXgCh̍őlXVB
			h = max(h, pChar->NextY);	//scale_y|鏈͉sɍŝłł͍sȂB
		}
		s = mbsinc(s);
	}
}
/****************************************************************************
 *	Dxt`
 ****************************************************************************/
#ifdef  __CLIP_CBKQ_H__
struct ST_CbkQue_SprFnt_DrawF {
	ST_SprFnt*	pSprFnt;
	int		x;
	int		y;
	double		scale_x;
	double		scale_y;
	double		ax;
	double		ay;
	int		rgba;
	int		mode;
	char		str[0];
};
static void fn_CbkQue_SprFnt_DrawF(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_SprFnt_DrawF* p = (struct ST_CbkQue_SprFnt_DrawF*)param;
	SprFnt_Draw(p->pSprFnt, p->x, p->y, p->scale_x, p->scale_y, p->ax, p->ay, p->rgba, p->mode, p->str);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//SprFnt_DrawF()̗Dxto[W
void CbkQue_SprFnt_DrawF(ST_CbkQue* pCbkQue, int pri, struct _ST_SprFnt* pSprFnt, int x, int y, double scale_x, double scale_y, double ax, double ay, int rgba, int mode, const char* fmt, ...) {
	struct ST_CbkQue_SprFnt_DrawF* p;
	va_list ap;
	va_start(ap, fmt);
	p = (struct ST_CbkQue_SprFnt_DrawF*)CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_SprFnt_DrawF, sizeof(struct ST_CbkQue_SprFnt_DrawF) + vscprintf(fmt, ap) + 1/*nul*/);
	va_end(ap);
	p->pSprFnt	= pSprFnt;
	p->x		= x;
	p->y		= y;
	p->scale_x	= scale_x;
	p->scale_y	= scale_y;
	p->ax		= ax;
	p->ay		= ay;
	p->rgba		= rgba;
	p->mode		= mode;
	va_start(ap, fmt);
	vsprintf(p->str, fmt, ap);
	va_end(ap);
}
#endif//__CLIP_CBKQ_H__
/****************************************************************************
 *	gp
 ****************************************************************************/
#if 0
/*--------------------------------------------------------------------------*/
#//SprFnt.yml
Font:
		NextX:						8
		NextY:						16
		Char:
				"":
						SprNo:		DUMMY		#//tH[obNp̕`ݒ
				" ":
						SprNo:				#//XvCg
				"@":
						SprNo:				#//XvCg
						NextX:		16
				"0":
						SprNo:		NUM_0
				"1":
						SprNo:		NUM_1
				"2":
						SprNo:		NUM_2
				"3":
						SprNo:		NUM_3
				"4":
						SprNo:		NUM_4
				"5":
						SprNo:		NUM_5
				"6":
						SprNo:		NUM_6
				"7":
						SprNo:		NUM_7
				"8":
						SprNo:		NUM_8
				"9":
						SprNo:		NUM_9
				".":
						SprNo:		DOT
						DrawX:		-2
						DrawY:		12
						NextX:		4
/*--------------------------------------------------------------------------*/
//cpp.cpp
int cpp_main(int argc, char* argv[]) {
	if(!setjmp(env_exit)) {
		ST_SprFnt* pSprFnt = SprFnt_Load("xxxxxxxxxxxxx.txt", pEnmKey, RegKey_SprNo);
		for(;;) {
			schedule();
			CbkQue_draw_line(pCbkQue, 0, DISP_X / 2, 0, DISP_X / 2, DISP_Y, 0, D3DRGBA(1.0, 0.0, 0.0, 1.0));
			CbkQue_draw_line(pCbkQue, 0, 0, DISP_Y / 2, DISP_X, DISP_Y / 2, 0, D3DRGBA(1.0, 0.0, 0.0, 1.0));
			CbkQue_SprFnt_DrawF(pCbkQue, 0, pSprFnt, DISP_X / 2, DISP_Y / 2, 2.0, 2.0, 1.0, 0.5, -1, DX_BLENDMODE_ALPHA, "0123 456.789\n0123.456 789");
		}
	}
	return EXIT_SUCCESS;
}
/*--------------------------------------------------------------------------*/
#endif
