/*
 *	app.c
 *
 *	dpavidot - AVI hbgoc[
 *	Copyright (C) 2013-2014 Naoyuki Sawa
 *
 *	* Sun Aug 25 23:30:33 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Mon Aug 26 23:11:10 JST 2013 Naoyuki Sawa
 *	- u-evIvVǉ܂B
 *	* Tue Aug 27 10:58:50 JST 2013 Naoyuki Sawa
 *	- Lua֐̃G[Adie()luaL_error()ɕύX܂B
 *	* Sat Sep 07 14:31:20 JST 2013 Naoyuki Sawa
 *	- ubiWanted.biCompression=BI_RGBv͖sv̂ō폜܂B
 *	* Mon Nov 24 17:31:02 JST 2014 Naoyuki Sawa
 *	- k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂B
 *	- CompressDrh,UncompressDrhǉ܂B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* Win32 */
#define STRICT
#include <windows.h>
#include <vfw.h>
#pragma comment(lib, "vfw32.lib")
/* Lua */
#include "../../liblua/lua.h"
#include "../../liblua/lauxlib.h"
#include "../../liblua/lualib.h"

/* dv
 * Lua C API̎s`FbNLɂ邽߂ɁAȉ̐ݒs܂B
 * mvWFNgn
 *   ˁmݒn
 *   ˁuݒ̑Ώہv = Win32 Debug, liblua
 *   ˁuC/C++v
 *   ˁuJeSv = 
 *   ˁuvvZbT̒`v = LUA_USE_APICHECK ǉ
 * mvWFNgn
 *   ˁmݒn
 *   ˁuݒ̑Ώہv = Win32 Release, liblua
 *   ˁuC/C++v
 *   ˁuJeSv = 
 *   ˁuvvZbT̒`v = LUA_USE_APICHECK ǉ, NDEBUG 폜
 * (ݒ̈Ӗ́A"../../liblua/Makefile"̃RgQƂĂB)
 */

/****************************************************************************
 *	
 ****************************************************************************/

#define VERSION "20141124"

/* IvV */
int opt_Silent;				/* 1Ȃ΁Ai\sȂ */

/* Lua */
lua_State* g_pL;			/* LuaXe[g */
int g_lBegin;				/* Lua֐BEGIN()̃X^bN̈ʒu */
int g_lFrame;				/* Lua֐FRAME()̃X^bN̈ʒu */
int g_lEnd;				/* Lua֐END()  ̃X^bN̈ʒu */

/* VFW */
const char* g_pAviFileName;		/* ǂݍݒAVIt@C */
PAVIFILE g_pAviFile;			/* VFWp */
PAVISTREAM g_pAviStream;		/* VFWp */
AVISTREAMINFO g_AviStreamInfo;		/* VFWp */
PGETFRAME g_pGetFrame;			/* VFWp */
BITMAPINFOHEADER* g_pBitmapInfoHeader;	/* VFWp */

int g_iFrameNumber;			/* fR[h̃t[ԍ(0`) */
int g_nLineBytes;			/* fR[hrbg}bv́A1C̃oCg */
const unsigned char* g_pPixelData;	/* fR[hrbg}bv́AsNZf[^B{gAbv`ŁA(x,y)=(0,0)w */
int g_fFrameValid;			/* 1Ȃ΁ALUA֐FRAME()sł邱Ƃ */

/*--------------------------------------------------------------------------*/

__declspec(noreturn) void usage();
__declspec(noreturn) void die(const char* fmt, ...);
#define DIE() die(__FILE__, __LINE__)
__declspec(noreturn) int atpanic(lua_State* L);

/* C֐BLuãO[oɓo^ */
int cGetPixel(lua_State* L);
//{{2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
//int cCompress(lua_State* L);
//int cUncompress(lua_State* L);
//2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
int cCompressTlz(lua_State* L);
int cUncompressTlz(lua_State* L);
int cCompressDrh(lua_State* L);
int cUncompressDrh(lua_State* L);
//}}2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
int cGetMD5(lua_State* L);
int cGetSHA1(lua_State* L);
const luaL_Reg TBL_Reg[] = {
	{ "GetPixel", cGetPixel },
    //{{2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
    //	{ "Compress", cCompress },
    //	{ "Uncompress", cUncompress },
    //2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
	{ "CompressTlz", cCompressTlz },
	{ "UncompressTlz", cUncompressTlz },
	{ "CompressDrh", cCompressDrh },
	{ "UncompressDrh", cUncompressDrh },
    //}}2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
	{ "GetMD5", cGetMD5 },
	{ "GetSHA1", cGetSHA1 },
	{ NULL, NULL },
};

#define __CLIP_H__
/* getopt */
#include "../../include/getopt.h"
#include "../../getopt.c"
/* kWJ */
#include "../../cliptlz.h"
#include "../../cliptlz.c"
//{{2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
void qsort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void *arg);
#include "../../clipsort.c"	//qsort_r()
#include "../../clipbary.h"	//bitarray_msb1st_get(),bitarray_msb1st_set()
#include "../../clipbary.c"
#include "../../frambary.c"
#include "../../cliphfm.h"
#include "../../cliphfm.c"
#include "../../framhfm.c"
#include "../../clipdrh.h"
#include "../../clipdrh.c"
#include "../../framdrh.c"
//}}2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
/* bZ[W_CWFXg */
#include "../../clipcode.h"
#include "../../clipcode.c"
#undef  __CLIP_H__

/****************************************************************************
 *	
 ****************************************************************************/

int main(int argc, char* argv[]) {
	HRESULT hr;
	int top, opt;
	/* VFW܂B */
	AVIFileInit();
/*{{Lua*/
	/* Lua܂B */
	g_pL = luaL_newstate();
	if(g_pL == NULL) { die("luaL_newstate s܂B"); }
	lua_atpanic(g_pL, atpanic);
	luaL_openlibs(g_pL);
	/* C֐o^܂B */
	top = lua_gettop(g_pL);
	  lua_pushglobaltable(g_pL);
	  luaL_setfuncs(g_pL, TBL_Reg, 0);
	lua_settop(g_pL, top);
/*}}Lua*/
	/* R}hC͂܂B */
	if(argc <= 1) { usage(); }
	while((opt = getopt(argc, argv, "f:e:hs")) != -1) {
		switch(opt) {
		case 'f':
			/* Luat@Cǂݍ݂܂B
			 * - u-f Luat@CvIvV́Aw\łB
			 *   u-f Luat@CvIvVw肳ꂽꍇASĂLuat@Cǂݍ݂܂B
			 */
		//{{
		//	top = lua_gettop(g_pL);
		//	  if(luaL_dofile(g_pL, optarg) != 0) { die("%s: luaL_dofile s܂B", optarg); }
		//	lua_settop(g_pL, top); /* luaL_dofile()̖߂l̐'LUA_MULTRET'BIɎ̂Ă鏈KvłB */
		//ł̓[hG[̃bZ[WĥŁÂ悤ɕύX܂B
			top = lua_gettop(g_pL);
			  if(luaL_loadfile(g_pL, optarg) != 0) { die("luaL_loadfile: %s", luaL_checkstring(g_pL, -1)); }
			  lua_call(g_pL, 0, 0);
			lua_settop(g_pL, top);
		//}}
			break;
		case 'e':
			/* LuaXNvgs܂B
			 * - u-e LuaXNvgvIvV́Aw\łB
			 *   u-f LuaXNvgvIvVw肳ꂽꍇASĂLuaXNvgs܂B
			 */
			top = lua_gettop(g_pL);
			  if(luaL_loadstring(g_pL, optarg) != 0) { die("luaL_loadstring: %s", luaL_checkstring(g_pL, -1)); }
			  lua_call(g_pL, 0, 0);
			lua_settop(g_pL, top);
			break;
		case 'h':
			usage();
			break;
		case 's':
			opt_Silent = 1;
			break;
		default:
			die("%c: IvV̎gsłB", optopt);
			break;
		}
	}
/*{{Lua*/
	/* Lua֐擾܂B */
	lua_getglobal(g_pL, "BEGIN");
	if(!lua_isfunction(g_pL, -1)) { die("%s `Ă܂B", "BEGIN"); }
	g_lBegin = lua_gettop(g_pL);
	lua_getglobal(g_pL, "FRAME");
	if(!lua_isfunction(g_pL, -1)) { die("%s `Ă܂B", "FRAME"); }
	g_lFrame = lua_gettop(g_pL);
	lua_getglobal(g_pL, "END");
	if(!lua_isfunction(g_pL, -1)) { die("%s `Ă܂B", "END"); }
	g_lEnd = lua_gettop(g_pL);
	/* BEGIN()s܂B */
	top = lua_gettop(g_pL);
	  lua_pushvalue(g_pL, g_lBegin);
	  lua_call(g_pL, 0, 0);
	lua_settop(g_pL, top);
/*}}Lua*/
	/* IvVȍ~Ac̃R}hĆAAVIt@CłB
	 * eAAVIt@Cɂāc
	 */
	while((g_pAviFileName = argv[optind++]) != NULL) {
		/*static const*/ BITMAPINFOHEADER biWanted = { /* AVIStreamGetFrameOpen()const|C^v̂Ŏdc */
			sizeof(BITMAPINFOHEADER),	/* biSize */
			0,	/* biWidth   w肵Ȃ */
			0,	/* biHeight  w肵Ȃ */
			1,	/* biPlanes */
			24,	/* biBitCount */
		//	BI_RGB,	/* biCompression */	//{{2013/09/07폜:BI_RGB=0Ȃ̂Ŗsv}}
		};
		int per1, per2;	/* i\p */
		/* AVIt@CJ܂B */
		hr = AVIFileOpen(&g_pAviFile, g_pAviFileName, OF_READ|OF_SHARE_DENY_WRITE, NULL);
		if(hr != 0) { die("%s: AVIFileOpen s܂B", g_pAviFileName); }
		hr = AVIFileGetStream(g_pAviFile, &g_pAviStream, streamtypeVIDEO, 0);
		if(hr != 0) { die("%s: AVIFileGetStream s܂B", g_pAviFileName); }
		hr = AVIStreamInfo(g_pAviStream, &g_AviStreamInfo, sizeof g_AviStreamInfo);
		if(hr != 0) { die("%s: AVIStreamInfo s܂B", g_pAviFileName); }
		g_pGetFrame = AVIStreamGetFrameOpen(g_pAviStream, &biWanted); /* &biWanted̑NULLw肵āAkRGBȊOɃfR[hꂽꍇ͎͂ŉ߂@L邪AȒP̂߂ɁAkRGBɃfR[hoȂꍇ̓G[Ƃ邱Ƃɂ */
		if(g_pGetFrame == NULL) { die("%s: AVIStreamGetFrameOpen s܂B", g_pAviFileName); }
		/* et[ɂāc */
		if(!opt_Silent) { per1 = -1; }	/* i\p */
		for(g_iFrameNumber = 0; g_iFrameNumber < (int)g_AviStreamInfo.dwLength; g_iFrameNumber++) {
			if(!opt_Silent) {										/* i\p */
				per2 = (g_iFrameNumber + 1) * 100 / g_AviStreamInfo.dwLength;				/* i\p */
				if(per1 != per2) { per1 = per2; fprintf(stderr, "%s: %3d%%\r", g_pAviFileName, per1); }	/* i\p */
			}												/* i\p */
			/* 1t[fR[h܂B */
			g_pBitmapInfoHeader = AVIStreamGetFrame(g_pGetFrame, g_iFrameNumber);
			if(g_pBitmapInfoHeader == NULL) { die("%s: AVIStreamGetFrame s܂B", g_pAviFileName); }
			/* 1C̃oCg߂܂B */
			g_nLineBytes = (g_pBitmapInfoHeader->biWidth * (g_pBitmapInfoHeader->biBitCount / 8) + 3) & ~3;
			/* sNZf[^ւ̃|C^߂܂B */
			g_pPixelData = (unsigned char*)g_pBitmapInfoHeader + g_pBitmapInfoHeader->biSize;
			g_pPixelData += g_nLineBytes * (g_pBitmapInfoHeader->biHeight - 1); /* {gAbv`ŁA(x,y)=(0,0)w */
/*{{Lua*/
			/* FRAME()s܂B */
			g_fFrameValid = 1; /* GetPixel()gp\ */
			top = lua_gettop(g_pL);
			  lua_pushvalue(g_pL, g_lFrame);
			  lua_call(g_pL, 0, 0);
			lua_settop(g_pL, top);
			g_fFrameValid = 0; /* ܂GetPixel()gp\ */
/*}}Lua*/
		}
		if(!opt_Silent) { fprintf(stderr, "\n"); }	/* i\p */
		/* AVIt@C܂B */
		hr = AVIStreamGetFrameClose(g_pGetFrame);
		if(hr != 0) { die("%s: AVIStreamGetFrameClose s܂B", g_pAviFileName); }
		hr = AVIStreamRelease(g_pAviStream);
		if(hr != 0) { die("%s: AVIStreamRelease s܂B", g_pAviFileName); }
		hr = AVIFileRelease(g_pAviFile);
		if(hr != 0) { die("%s: AVIFileRelease s܂B", g_pAviFileName); }
	}
/*{{Lua*/
	/* END()s܂B */
	top = lua_gettop(g_pL);
	  lua_pushvalue(g_pL, g_lEnd);
	  lua_call(g_pL, 0, 0);
	lua_settop(g_pL, top);
	/* LuaI܂B */
	lua_close(g_pL);
/*}}Lua*/
	/* VFWI܂B */
	AVIFileExit();
	return EXIT_SUCCESS;
}

/*--------------------------------------------------------------------------*/

/* g\AG[IB */
void usage() {
	fprintf(stderr, "dpavidot - AVI hbgoc[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2013-2014 Naoyuki Sawa All Rights Reserved.\n");
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "    dpavidot [-s] -f script.lua [-f script.lua ...] movie.avi [movie.avi ...]\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "    -h            g\܂B\n");
	fprintf(stderr, "    -s            i\܂B\n");
	fprintf(stderr, "    -f script.lua LuaXNvgt@Cǂݍ݂܂B\n");
	fprintf(stderr, "    -e lua-script LuaXNvg𒼐ڎs܂B\n");
	fprintf(stderr, "Summary:\n");
	fprintf(stderr, "  - AVIt@C̊et[ALuaXNvgŏ܂B\n");
	fprintf(stderr, "    LuaXNvg𕡐w肵ꍇASĘÂƂĈ܂B\n");
	fprintf(stderr, "    AVIt@C𕡐w肵ꍇASĘÂƂĈ܂B\n");
	fprintf(stderr, "  - LuaXNvgɂ́Aȉ̊֐`ĂȂ΂Ȃ܂B\n");
	fprintf(stderr, "    BEGIN         ŏɈxĂяo܂B\n");
	fprintf(stderr, "    FRAME         et[ɑ΂āAxÂĂяo܂B\n");
	fprintf(stderr, "    END           ŌɈxĂяo܂B\n");
	fprintf(stderr, "  - LuaXNvǵALC֐𗘗p邱Ƃł܂B\n");
	fprintf(stderr, "    GetPixel      ݂̃t[́Aw肵W̋Px擾܂B\n");
    //{{2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
    //	fprintf(stderr, "    Compress      8bitlvfƂAe[uk܂B\n");
    //	fprintf(stderr, "    Uncompress    8bitlvfƂAe[uWJ܂B\n");
    //2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
	fprintf(stderr, "    CompressTlz   8bitlvfƂAe[uk܂B(tlz)\n");
	fprintf(stderr, "    UncompressTlz 8bitlvfƂAe[uWJ܂B(tlz)\n");
	fprintf(stderr, "    CompressDrh   8bitlvfƂAe[uk܂B(drh)\n");
	fprintf(stderr, "    UncompressDrh 8bitlvfƂAe[uWJ܂B(drh)\n");
    //}}2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
	fprintf(stderr, "    GetMD5        8bitlvfƂe[úAMD5  擾܂B\n");
	fprintf(stderr, "    GetSHA1       8bitlvfƂe[úASHA-1擾܂B\n");
	fprintf(stderr, "  - o͏yяo͂f[^̓éALuaXNvgłB\n");
	fprintf(stderr, "    LuaXNvgύX邱ƂɂāAlXȉp\łB\n");
	fprintf(stderr, "Example:\n");
	fprintf(stderr, "    dpavidot.exe -e \"ERR_LOG=[[err.log]]\" -f Script1.lua -f Script2.lua Movie1.avi Movie2.avi\n");
	fprintf(stderr, "    o͏yяo͂f[^̓éALedDefine.lua,LedConfig.lua,LedScript.lua Œ`B\n");
	fprintf(stderr, "    dpavidot.exeśAAVI̊et[ɂāAK肳ꂽLua֐ĂяołB\n");
	exit(EXIT_FAILURE);
}

/*--------------------------------------------------------------------------*/

/* bZ[W\AG[IB */
void die(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
#ifdef  _DEBUG
	__asm int 3; /* fobOՂ悤ɁAfobO̓fobKŎ~߂ */
#endif/*_DEBUG*/
	exit(EXIT_FAILURE);
}

/*--------------------------------------------------------------------------*/

/* LuãpjbN֐ */
int atpanic(lua_State* L) {
	die("atpanic: %s", luaL_checkstring(L, -1));
}

/****************************************************************************
 *	
 ****************************************************************************/

/* r,g,b = GetPixel(x,y)
 * [in]
 *	x	XWB͈͂[0,w)B͈͊O̍Ww肷ƁAPx0ԂB
 *	y	YWB͈͂[0,h)B͈͊O̍Ww肷ƁAPx0ԂB
 * [out]
 *	r	RPxB͈͂[0,1]B
 *	g	GPxB͈͂[0,1]B
 *	b	BPxB͈͂[0,1]B
 */
int cGetPixel(lua_State* L) {
	int x, y;
	if(!g_fFrameValid) { luaL_error(L, "cGetPixel: t[łB"); }
	/* W擾܂B */
	x = luaL_checkinteger(L, 1);
	y = luaL_checkinteger(L, 2);
	/* Wt[Ȃ΁AF擾܂B */
	if(((unsigned)x < (unsigned)g_pBitmapInfoHeader->biWidth ) &&
	   ((unsigned)y < (unsigned)g_pBitmapInfoHeader->biHeight)) {
		const unsigned char* p = g_pPixelData; /* {gAbv`ŁA(x,y)=(0,0)w */
		p -= g_nLineBytes * y;
		p += 3 * x;
		lua_pushnumber(L, (double)p[2] / (double)UCHAR_MAX); /* R */
		lua_pushnumber(L, (double)p[1] / (double)UCHAR_MAX); /* G */
		lua_pushnumber(L, (double)p[0] / (double)UCHAR_MAX); /* B */
	/* Wt[OȂ΁AƌȂ܂B */
	} else {
		lua_pushnumber(L, 0.0); /* R */
		lua_pushnumber(L, 0.0); /* G */
		lua_pushnumber(L, 0.0); /* B */
	}
	return 3;
}

/*--------------------------------------------------------------------------*/

//{{2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
///* cCompress()cUncompress()̋ʏ܂Ƃ߂B */
//static int cCompress_cUncompress(lua_State* L, int (*pTinyLZ_func)(void*, int, const void*, int), const char* pFuncName) {
//2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
/* cCompressTlz()cUncompressTlz()̋ʏ܂Ƃ߂B */
static int cCompressTlz_cUncompressTlz(lua_State* L, int (*pTinyLZ_func)(void*, int, const void*, int), const char* pFuncName) {
//}}2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
	int i, v, nSrcLen, nDstLen;
	unsigned char *pSrcBuf, *pDstBuf;
	/* {k|WJ}Of[^Luae[uł邱ƂmF܂B */
	luaL_checktype(L, 1, LUA_TTABLE);
	/* {k|WJ}Of[^Cz쐬܂B */
	nSrcLen = lua_rawlen(L, 1);
	pSrcBuf = malloc(nSrcLen);
	if(!pSrcBuf) { luaL_error(L, "%s: malloc s܂B", pFuncName); }
	/* {k|WJ}Of[^Luae[uCzɕϊ܂B */
	for(i = 0; i < nSrcLen; i++) {
		lua_rawgeti(L, 1, i + 1); /* Lua1x[X */
		v = luaL_checkinteger(L, -1);
		if((unsigned)v > UCHAR_MAX) { luaL_error(L, "%s: f[^słB", pFuncName); }
		pSrcBuf[i] = v;
		lua_pop(L, 1); /* lua_rawgeti()̕ */
	}
	/* {k|WJ}Of[^Luae[u폜܂B */
	lua_settop(L, 0);
	/* {k|WJ}f[^Luae[u쐬܂B */
	lua_newtable(L);
	/* {k|WJ}f[^Cz쐬܂B */
	nDstLen = (*pTinyLZ_func)(NULL, 0, pSrcBuf, nSrcLen); /* {k|WJ}s */
	pDstBuf = malloc(nDstLen);
	if(!pDstBuf) { luaL_error(L, "%s: malloc s܂B", pFuncName); }
	(*pTinyLZ_func)(pDstBuf, nDstLen, pSrcBuf, nSrcLen);  /* {k|WJ}s */
	/* {k|WJ}f[^CzLuae[uɕϊ܂B */
	for(i = 0; i < nDstLen; i++) {
		lua_pushinteger(L, pDstBuf[i]);
		lua_rawseti(L, 1, i + 1); /* Lua1x[X */
	}
	/* Cz폜܂B */
	free(pSrcBuf);
	free(pDstBuf);
	/* {k|WJ}f[^Luae[uԂ܂B */
	return 1;
}

/*--------------------------------------------------------------------------*/

//{{2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
///* DstTbl = Compress(SrcTbl)
// * [in]
// *	SrcTbl	kOf[^̃e[uB[1]JnV[PXł邱ƁB
// * [out]
// *	DstTbl	kf[^̃e[uB[1]JnV[PXłB
// */
//int cCompress(lua_State* L) {
//	return cCompress_cUncompress(L, TinyLZ_compress, "cCompress");
//}
//2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
/* DstTbl = CompressTlz(SrcTbl)
 * [in]
 *	SrcTbl	kOf[^̃e[uB[1]JnV[PXł邱ƁB
 * [out]
 *	DstTbl	kf[^̃e[uB[1]JnV[PXłB
 */
int cCompressTlz(lua_State* L) {
	return cCompressTlz_cUncompressTlz(L, TinyLZ_compress, "cCompressTlz");
}
//}}2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B

/*--------------------------------------------------------------------------*/

//{{2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
///* DstTbl = Uncompress(SrcTbl)
// * [in]
// *	SrcTbl	WJOf[^̃e[uB[1]JnV[PXł邱ƁB
// * [out]
// *	DstTbl	WJf[^̃e[uB[1]JnV[PXłB
// */
//int cUncompress(lua_State* L) {
//	return cCompress_cUncompress(L, TinyLZ_uncompress, "cUncompress");
//}
//2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
/* DstTbl = UncompressTlz(SrcTbl)
 * [in]
 *	SrcTbl	WJOf[^̃e[uB[1]JnV[PXł邱ƁB
 * [out]
 *	DstTbl	WJf[^̃e[uB[1]JnV[PXłB
 */
int cUncompressTlz(lua_State* L) {
	return cCompressTlz_cUncompressTlz(L, TinyLZ_uncompress, "cUncompressTlz");
}
//}}2014/11/24ύX:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B

/*--------------------------------------------------------------------------*/

//{{2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
/* cCompressDrh()cUncompressDrh()̋ʏ܂Ƃ߂B */
static int cCompressDrh_cUncompressDrh(lua_State* L, int bCompressUncompress, const char* pFuncName) {
	int i, v, nSrcLen, nDstLen;
	unsigned char *pSrcBuf, *pDstBuf;
	/* {k|WJ}Of[^Luae[uł邱ƂmF܂B */
	luaL_checktype(L, 1, LUA_TTABLE);
	/* {k|WJ}Of[^Cz쐬܂B */
	nSrcLen = lua_rawlen(L, 1);
	pSrcBuf = malloc(nSrcLen);
	if(!pSrcBuf) { luaL_error(L, "%s: malloc s܂B", pFuncName); }
	/* {k|WJ}Of[^Luae[uCzɕϊ܂B */
	for(i = 0; i < nSrcLen; i++) {
		lua_rawgeti(L, 1, i + 1); /* Lua1x[X */
		v = luaL_checkinteger(L, -1);
		if((unsigned)v > UCHAR_MAX) { luaL_error(L, "%s: f[^słB", pFuncName); }
		pSrcBuf[i] = v;
		lua_pop(L, 1); /* lua_rawgeti()̕ */
	}
	/* {k|WJ}Of[^Luae[u폜܂B */
	lua_settop(L, 0);
	/* {k|WJ}f[^Luae[u쐬܂B */
	lua_newtable(L);
	/* {k|WJ}f[^Cz쐬܂B */
	if(bCompressUncompress == 0) {
		nDstLen = DeltaRunHuffmanEncoder_Encode(pSrcBuf, nSrcLen, NULL, 0);	/* ks */
		pDstBuf = malloc(nDstLen);
		if(!pDstBuf) { luaL_error(L, "%s: malloc s܂B", pFuncName); }
		DeltaRunHuffmanEncoder_Encode(pSrcBuf, nSrcLen, pDstBuf, nDstLen);	/* ks */
	} else {
		nDstLen = DeltaRunHuffmanDecoder_Decode(pSrcBuf, NULL, 0);		/* WJs */
		pDstBuf = malloc(nDstLen);
		if(!pDstBuf) { luaL_error(L, "%s: malloc s܂B", pFuncName); }
		DeltaRunHuffmanDecoder_Decode(pSrcBuf, pDstBuf, nDstLen);		/* WJs */
	}
	/* {k|WJ}f[^CzLuae[uɕϊ܂B */
	for(i = 0; i < nDstLen; i++) {
		lua_pushinteger(L, pDstBuf[i]);
		lua_rawseti(L, 1, i + 1); /* Lua1x[X */
	}
	/* Cz폜܂B */
	free(pSrcBuf);
	free(pDstBuf);
	/* {k|WJ}f[^Luae[uԂ܂B */
	return 1;
}
//}}2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B

/*--------------------------------------------------------------------------*/

//{{2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
/* DstTbl = CompressDrh(SrcTbl)
 * [in]
 *	SrcTbl	kOf[^̃e[uB[1]JnV[PXł邱ƁB
 * [out]
 *	DstTbl	kf[^̃e[uB[1]JnV[PXłB
 */
int cCompressDrh(lua_State* L) {
	return cCompressDrh_cUncompressDrh(L, 0, "cCompressDrh");
}
//}}2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B

/*--------------------------------------------------------------------------*/

//{{2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B
/* DstTbl = UncompressDrh(SrcTbl)
 * [in]
 *	SrcTbl	WJOf[^̃e[uB[1]JnV[PXł邱ƁB
 * [out]
 *	DstTbl	WJf[^̃e[uB[1]JnV[PXłB
 */
int cUncompressDrh(lua_State* L) {
	return cCompressDrh_cUncompressDrh(L, 1, "cUncompressDrh");
}
//}}2014/11/24ǉ:k̒ǉɔA֐CompressCompressTlz,UncompressUncompressTlzɕύX܂BCompressDrh,UncompressDrhǉ܂B

/*--------------------------------------------------------------------------*/

static int cGetMD5_cGetSHA1(lua_State* L, void (*pDigestFunc)(unsigned char*, const void*, int), int nDigestLen, const char* pFuncName) {
	luaL_Buffer b;
	int i, v, nSrcLen;
	unsigned char* pSrcBuf;
	unsigned char Digest[20/*nDigestLen*/];
	/* f[^Luae[uł邱ƂmF܂B */
	luaL_checktype(L, 1, LUA_TTABLE);
	/* f[^Cz쐬܂B */
	nSrcLen = lua_rawlen(L, 1);
	pSrcBuf = malloc(nSrcLen);
	if(!pSrcBuf) { luaL_error(L, "%s: malloc s܂B", pFuncName); }
	/* f[^Luae[uCzɕϊ܂B */
	for(i = 0; i < nSrcLen; i++) {
		lua_rawgeti(L, 1, i + 1); /* Lua1x[X */
		v = luaL_checkinteger(L, -1);
		if((unsigned)v > UCHAR_MAX) { luaL_error(L, "%s: f[^słB", pFuncName); }
		pSrcBuf[i] = v;
		lua_pop(L, 1); /* lua_rawgeti()̕ */
	}
	/* bZ[W_CWFXg߂܂B */
	(*pDigestFunc)(Digest, pSrcBuf, nSrcLen);
	/* Cz폜܂B */
	free(pSrcBuf);
	/* bZ[W_CWFXg𕶎ɕϊ܂B */
	luaL_buffinit(L, &b);
	for(i = 0; i < nDigestLen; i++) {
	//{{
	//	lua_pushfstring(L, "%02x", Digest[i]);
	//	luaL_addvalue(&b);
	//lua_pushfstring()͕ϊwqɐgȂB
		char s[2 + 1/*nul*/];
		sprintf(s, "%02x", Digest[i]);
		luaL_addstring(&b, s);
	//}}
	}
	luaL_pushresult(&b);
	/* bZ[W_CWFXgԂ܂B */
	return 1;
}

/*--------------------------------------------------------------------------*/

int cGetMD5(lua_State* L) {
	return cGetMD5_cGetSHA1(L, md5_digest, 16, "cGetMD5");
}

/*--------------------------------------------------------------------------*/

int cGetSHA1(lua_State* L) {
	return cGetMD5_cGetSHA1(L, sha1_digest, 20, "cGetSHA1");
}

