/*
 *	main.c
 *
 *	P/ECE CLiP Library Mesh Loader
 *
 *	ExportPieceClipWire - P/ECE CLiP Library 3D Object Exporter (Mesh)
 *	o̓t@CǂݍށACLiPp[`̎ړĨvWFNgłB
 *	̃c[P̂ŗp邱Ƃ͖Ǝv܂B
 *	2006/07/28prύX
 *	XML`̃bVf[^AC`ɕϊc[Ƃėp邱Ƃɂ܂B
 *
 *	* Tue Jun 27 18:59:35 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Jun 28 05:13:45 JST 2006 Naoyuki Sawa
 *	- ExpatADLLłȂAX^eBbNCug悤ύX܂B
 *	* Fri Jul 28 00:16:53 JST 2006 Naoyuki Sawa
 *	- ܂ł́AXML`̃bVf[^̓ǂݍ݃eXgsvOłA
 *	  ̕ύXɂAC`ɕϊc[Ƃėp邱Ƃɂ܂B
 *	  P/ECEŁAXML`̃bVf[^̂܂܈ƁAȉ̂悤Ȗ肪܂B
 *	  EXMLt@C͑傫āAtbV𑽂B
 *	  EXMLt@CǂݍނɂExpatNKvACRAM𑽂B
 *	  E݂mesh_load()̓t@C̓ǂݍ݂ɂΉĂȂ̂ŁA
 *	    pext@CŃAvP[V\邱ƂłȂB
 *	  ȏ̂悤Ȗ_邽߂ɁÁA{c[pXML`̃bVf[^
 *	  C`ɃRo[gApext@Cɒڊ܂߂邱Ƃɂ܂B
 *	  c[IȃvOł́Amesh_load()ɂXMLt@C̓ǂݍ݂s܂B
 *	  (Ƃ΁A3DIuWFNgr[AȂ)
 *	* Sun Aug 10 21:42:25 JST 2008 Naoyuki Sawa
 *	- tool/ExportPieceClipA<vector>vfŒ菬_łȂ_ŏo͂悤ύXƂɒǏ]A
 *	  mesh_load()wire_load()ɁA_̂܂ܓǂݍނAŒ菬_ɕϊ邩̑Iǉ܂B
 *	  {c[ɂA_̂܂ܓǂݍނ(-f)AŒ菬_ɕϊ邩(-x)̃IvVǉ܂B
 */
#include "app.h"

/*****************************************************************************
 *	
 *****************************************************************************/

static void
out_data(const char* prefix, const char* path, const unsigned char* data, int size)
{
	char fname[_MAX_FNAME];
	int i;

	_splitpath(path, NULL, NULL, fname, NULL);
	strupr(fname);
	printf("const unsigned char %s_%s[] = {", prefix, fname);

	for(i = 0; i < size; i++) {
		if(!(i & 15)) {
			printf("\n");
		}
		printf("0x%02X,", data[i]);
	}

	printf("\n};\n");
}

/*****************************************************************************
 *	
 *****************************************************************************/

static int
get_size(const MESH* m)
{
	int size = 0;
	//
	const vector* v;
	const TCOORD* c;
	const FACE* f;
	const FACEVERTEX* fv;
	//
	int nv;
	int nc;
	int nf;
	int nfv;
	//
	int iv;
	int ic;
	int _if;
	int ifv;

	size += sizeof(MESH);
	nv = m->nv;
	nc = m->nc;
	nf = m->nf;
	m++;

	v = (vector*)m;
	for(iv = 0; iv < nv; iv++) {
		size += sizeof(vector);
		v++;
	}

	c = (TCOORD*)v;
	for(ic = 0; ic < nc; ic++) {
		size += sizeof(TCOORD);
		c++;
	}

	f = (FACE*)c;
	for(_if = 0; _if < nf; _if++) {
		size += sizeof(FACE);
		nfv = f->nfv;
		f++;
		//
		fv = (FACEVERTEX*)f;
		for(ifv = 0; ifv < nfv; ifv++) {
			size += sizeof(FACEVERTEX);
			fv++;
		}
		//
		f = (FACE*)fv;
	}

	return size;
}

/*****************************************************************************
 *	
 *****************************************************************************/

int
main(int argc, char* argv[])
{
	MESH* m;
	const char* path;
	int convert_fixed;

	switch(argc) {
	case 1 + 1:
		path = argv[1];
		convert_fixed = 0/*float*/;
		break;
	case 1 + 2:
		path = argv[2];
		       if(!strcmp(argv[1], "-f")) {
			convert_fixed = 0/*float*/;
		} else if(!strcmp(argv[1], "-x")) {
			convert_fixed = 1/*fixed*/;
		} else {
			DIE();
		}
		break;
	default:
		DIE();
	}
	m = mesh_load(path, convert_fixed);
	if(!m) {
		DIE();
	}
	out_data("MESH", path, (unsigned char*)m, get_size(m));
	free(m);

	return 0;
}

