#include "app.h"
/****************************************************************************
 *	clippce.c
 ****************************************************************************/
static char* strstr_sub(const char* s1, const char* s2, int (*fn)(const char*, const char*, size_t));
char* strstr(const char* s1, const char* s2) {
	return strstr_sub(s1, s2, strncmp);
}
char* strcasestr(const char* s1, const char* s2) {
	return strstr_sub(s1, s2, strncasecmp);
}
static char* strstr_sub(const char* s1, const char* s2, int (*fn)(const char*, const char*, size_t)) {
	/* ̕߂B(s2="")ł\ȂB */
	int n = strlen(s2);
	/* ̐擪猟JnB
	 * - (s1="")̏ꍇAڂ̃[v͎sB
	 *   (s2="")̏ꍇ́As1̓eɂ炸((s1="")łĂȂĂ)Ɉv邩łB */
	do {
		/* ݈̌ʒuA̕rsAv猻݈ʒuԂB
		 * - (s2="")ꍇAs1̓eɂ炸((s1="")łĂȂĂ)AvB
		 * - (s1="")ꍇA(s2="")łȂ΁AvȂB */
		if(!(*fn)(s1, s2, n)) { return (char*)s1; }
	/* ̏I[łȂ΁Aʒu֐i߂B
	 * - (s1="")ꍇ́AڂŔ邱ƂɂȂB */
	} while(*s1++);
	/* ̏I[ɂrłvȂ΁ANULLԂB */
	return NULL;
}
/*--------------------------------------------------------------------------*/
//{{VC6.0++Ń[XrhƁuerror C2169: 'strlen' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
//size_t strlen(const char* string) {
//	return strnlen(string, SIZE_MAX);
//}
//}}VC6.0++Ń[XrhƁuerror C2169: 'strlen' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
/* strnlen()֐́Astringw̒AoCgŕԂB
 * ɂ́AI['\0'͊܂܂ȂB
 * ͍őŁAn܂łłB
 * strnlen()֐́Astring̍ŏnoCĝ݂Astring+n邱Ƃ͂ȂB
 */
size_t strnlen(const char* string, size_t n) {
	size_t len = 0;
	while((n--) && (*string++)) {
		len++;
	}
	return len;
}
/*--------------------------------------------------------------------------*/
//char* strdup(const char* string) {						//Boehm GC
//	return strndup(string, SIZE_MAX);
//}
///* strndup()֐́Astrdup()Ɠlł邪AőnoCg𕡐B
// * stringnꍇ́AnoCg𕡐AI['\0'ǉB
// */
//char* strndup(const char* string, size_t n) {					//Boehm GC
//	size_t len = strnlen(string, n);
//	char* p =  malloc(len + 1/*I['\0'̕AYꂸ!*/);
//	if(p != NULL) {
//		p[len] = '\0';
//		memcpy(p, string, len);
//	}
//	return p;
//}
/*--------------------------------------------------------------------------*/
int strcasecmp(const char* s1, const char* s2) {
	int c1, c2;
	do {
		c1 = tolower(*s1++ & 0xff);
		c2 = tolower(*s2++ & 0xff);
	} while(c1 != '\0' && c1 == c2);
	return c1 - c2;
}
int strncasecmp(const char* s1, const char* s2, size_t n) {
	int c1, c2;
	do {
		if(n-- == 0) return 0;
		c1 = tolower(*s1++ & 0xff);
		c2 = tolower(*s2++ & 0xff);
	} while(c1 != '\0' && c1 == c2);
	return c1 - c2;
}
/*--------------------------------------------------------------------------*/
char* strsep(char** stringp, const char* delim) {
	char* begin = *stringp;
	if(begin) {
		char* end = strpbrk(begin, delim);
		if(end) { *end++ = '\0'; }
		*stringp = end;
	}
	return begin;
}
char* strpbrk(const char* s, const char* accept) {
	const char* p;
	for(;;) {
		int c = *s++;
		if(!c) { return NULL; }
		p = accept;
		for(;;) {
			int t = *p++;
			if(!t) { break; }
			if(t == c) { return (char*)(s - 1); }
		}
	}
}
/*--------------------------------------------------------------------------*/
size_t strlcpy(char* dst, const char* src, size_t size) {
	size_t len = strlen(src);			//]̒̕߂B
	if(size--) {					//obt@TCY1炷B1炷Õobt@TCY0łȂ΁c
		if(size > len) { size = len; }		//]镶̒߂B
		memcpy(dst, src, size);			//]B
		dst[size] = '\0';			//kI[B
	}
	return len;					//]̒̕ԂB
}
size_t strlcat(char* dst, const char* src, size_t size) {
	size_t dlen = strlen(dst);			//]̒̕߂B
	size_t slen = strlen(src);			//]̒̕߂B
	size_t tlen = dlen + slen;			//̒̍v߂B
	if(size > dlen) {				//]̕񂪃obt@ŃkI[Ăc
		size -= dlen;				//(obt@ɒǉ\ȕ+1)߂B
		if(slen >= size) { slen = size - 1; }	//ǉ镶̒߂B
		dst += dlen;				//ǉʒu߂B
		memcpy(dst, src, slen);			//ǉB
		dst[slen] = '\0';			//kI[B
	}
	return tlen;					//̒̍vԂB
}
/*--------------------------------------------------------------------------*/
int isblank(int c) {
	return (c == ' ') || (c == '\t');
}
/*--------------------------------------------------------------------------*/
size_t malloc_usable_size(void* ptr) {
#ifndef GC_H
	return ptr ? _msize(ptr) : 0;
#else //GC_H
	//Boehm GCgpƁAmalloc()̓ubN̓r(=Ǘ̌)̃|C^ԂB
	//GC_size()́AubN̓rw肳ĂAubN̑Ŝ̃TCYԂB
	//malloc()Ԃ|C^ȍ~̃TCY𓾂ɂ́Aȉ̂悤ɌvZȂĂ͂ȂȂB(萄)
	return ptr ? (GC_size(ptr) - ((int)ptr - (int)GC_base(ptr))) : 0;
#endif//GC_H
}
