;	
;	framz80a.s
;
;	P/ECE Z80 Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2003 Naoyuki Sawa
;
;	* Sun Feb 22 10:45:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;	  ܂ŁÃ[`framz80.c̃CCAZuŒ`Ă܂B
;	  CPŨG~[VvOɍ킹āAPƂ.st@Cֈړ܂B
;
;#include "clipz80a.h"
;/	
;/	clipz80a.h
;/
;/	P/ECE Z80 Emulator
;/
;/	CLiP - Common Library for P/ECE
;/	Copyright (C) 2001-2003 Naoyuki Sawa
;/
;/	* Fri Nov 28 06:00:00 JST 2003 Naoyuki Sawa
;/	- 쐬JnB
;/

;/ ̃t@CC/AZu\[XQƂ܂B
;/ CL̒`܂߂Ă͂܂B

;/ ̃V{`ƁAAZuR[hgp܂B
;/ ̃V{`Ȃ΁AbR[hgp܂B
;#define Z80_ASM
;#ifdef Z80_ASM

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

;
;	Z80\ clipz80a.sɂ`Ă!!
;
;===== WX^ =====
;#define F		 0
;#define A		 1
;#define C		 2
;#define B		 3
;#define E		 4
;#define D		 5
;#define L		 6
;#define H		 7
;#define AF		 0
;#define BC		 2
;#define DE		 4
;#define HL		 6
;#define AF2		 8
;#define BC2		10
;#define DE2		12
;#define HL2		14
;#define IXL		16
;#define IXH		17
;#define IYL		18
;#define IYH		19
;#define IX		16
;#define IY		18
;#define SP		20
;#define PC		22
;=====  =====
;#define IFF1		32
;#define IFF2		33
;#define IM		34
;#define HALT		35
;#define CYCLE		36
;{{2005/01/07 INTvۗΉ̂߂ɒǉ
;#define PENDING		40
;#define PENDING_NO	41
;}}2005/01/07 INTvۗΉ̂߂ɒǉ
;===== O֐ =====
;#define READ		48
;#define WRITE		52
;#define IN		56
;#define OUT		60

;****************************************************************************
;	
;****************************************************************************

;
;	Z80G~[Vs܂B
;
;	* Fri Nov 28 06:00:00 JST 2003 Naoyuki Sawa
;	- argc̏o䗦uargc=0argc=1argc=2vƉ肵č܂B
;	  z80op_CB/ED/DD/FD/DDCB/FDCBɂĂlłB
;
	.global z80_run
z80_run:
	pushn %r3
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	ext	0x30		; 	xld.w %r3, [%r0+0x30]		; z80->read
	ld.w	%r3,[%r0]
	ext	0x24		; 	xld.w [%r0+0x24], %r13		; CYCLE
	ld.w	[%r0],%r13
	cmp	%r13,0x0	; 	xcmp %r13, 0			; if(CYCLE <= 0) break
	jrle	z80_run_L50	; 	xjrle z80_run_L50
	;
z80_run_L10:
	ext	0x23		; 	xld.ub %r10, [%r0+0x23]		; if(HALT) break
	ld.ub	%r10,[%r0]
	ext	0x16		; 	xld.uh %r1, [%r0+0x16]		; PC *anti-interlock*
	ld.uh	%r1,[%r0]
	cmp	%r10,0x0	; 	xcmp %r10, 0
	jrne	z80_run_L50	; 	xjrne z80_run_L50
	;
	ld.w %r12, %r0			; code = z80->read(z80, PC++)
	ld.uh %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	ext	z80_op_table+0x0@h	; 	xld.w %r2, z80_op_table		; op = &z80_op_table[code]
	ext	z80_op_table+0x0@m
	ld.w	%r2,z80_op_table+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 0 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x0	; 	xcmp %r10, 0	
	jreq	z80_run_L20	; 	xjreq z80_run_L20
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ld.w %r12, %r0			; arg1 = z80->read(z80, PC++)
	ld.uh %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.ub %r14, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 1 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x1	; 	xcmp %r10, 1	
	jreq	z80_run_L30	; 	xjreq z80_run_L30
	ld.b	[%sp+0x1],%r14	; 	xld.b [%sp+0x1], %r14		; (save arg1)
	;
	ld.w %r12, %r0			; arg2 = z80->read(z80, PC++)
	ld.w %r13, %r1
	call.d %r3
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
z80_run_L30:
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
z80_run_L20:
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(z80, code, arg1, arg2)
	ext	0x16		; 	xld.h [%r0+0x16], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	jrgt	z80_run_L10	; 	xjrgt z80_run_L10		; if(CYCLE <= 0) break
z80_run_L50:
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r3
	ret

;****************************************************************************

;
;	CB XX ߂̃e[uWvłB
;
	.global z80op_CB
z80op_CB:
	pushn %r2
	;
	ld.w %r0, %r12			; z80
	ext	0x16		; 	xld.uh %r1, [%r0+0x16]		; PC
	ld.uh	%r1,[%r0]
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; code = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	ext	z80_op_table_CB+0x0@h	; 	xld.w %r2, z80_op_table_CB	; op = &z80_op_table_CB[code]
	ext	z80_op_table_CB+0x0@m
	ld.w	%r2,z80_op_table_CB+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(z80, code, arg1, arg2)
	ext	0x16		; 	xld.h [%r0+0x16], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	popn %r2
	ret

;****************************************************************************

;
;	ED XX ߂̃e[uWvłB
;
	.global z80op_ED
z80op_ED:
	pushn %r2
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	ext	0x16		; 	xld.uh %r1, [%r0+0x16]		; PC
	ld.uh	%r1,[%r0]
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; code = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	ext	z80_op_table_ED+0x0@h	; 	xld.w %r2, z80_op_table_ED	; op = &z80_op_table_ED[code]
	ext	z80_op_table_ED+0x0@m
	ld.w	%r2,z80_op_table_ED+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 0 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x0	; 	xcmp %r10, 0	
	jreq	z80op_ED_L10	; 	xjreq z80op_ED_L10
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg1 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.b	[%sp+0x1],%r10	; 	xld.b [%sp+0x1], %r10		; (save arg1)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg2 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.w %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
z80op_ED_L10:
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(z80, code, arg1, arg2)
	ext	0x16		; 	xld.h [%r0+0x16], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	DD XX ߂̃e[uWvłB
;
	.global z80op_DD
z80op_DD:
	pushn %r2
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	ext	0x16		; 	xld.uh %r1, [%r0+0x16]		; PC
	ld.uh	%r1,[%r0]
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; code = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	ext	z80_op_table_DD+0x0@h	; 	xld.w %r2, z80_op_table_DD	; op = &z80_op_table_DD[code]
	ext	z80_op_table_DD+0x0@m
	ld.w	%r2,z80_op_table_DD+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 0 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x0	; 	xcmp %r10, 0	
	jreq	z80op_DD_L10	; 	xjreq z80op_DD_L10
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg1 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r14, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 1 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x1	; 	xcmp %r10, 1	
	jreq	z80op_DD_L20	; 	xjreq z80op_DD_L20
	ld.b	[%sp+0x1],%r14	; 	xld.b [%sp+0x1], %r14		; (save arg1)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg2 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.w %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
z80op_DD_L20:
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
z80op_DD_L10:
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(z80, code, arg1, arg2)
	ext	0x16		; 	xld.h [%r0+0x16], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	FD XX ߂̃e[uWvłB
;
	.global z80op_FD
z80op_FD:
	pushn %r2
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	ext	0x16		; 	xld.uh %r1, [%r0+0x16]		; PC
	ld.uh	%r1,[%r0]
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; code = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	ext	z80_op_table_FD+0x0@h	; 	xld.w %r2, z80_op_table_FD	; op = &z80_op_table_FD[code]
	ext	z80_op_table_FD+0x0@m
	ld.w	%r2,z80_op_table_FD+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 0 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x0	; 	xcmp %r10, 0	
	jreq	z80op_FD_L10	; 	xjreq z80op_FD_L10
	ld.b	[%sp+0x0],%r13	; 	xld.b [%sp+0x0], %r13		; (save code)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg1 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r14, %r10
	;
	ext	0x4		; 	xld.ub %r10, [%r2+0x4]		; argc == 1 ?
	ld.ub	%r10,[%r2]
	cmp	%r10,0x1	; 	xcmp %r10, 1	
	jreq	z80op_FD_L20	; 	xjreq z80op_FD_L20
	ld.b	[%sp+0x1],%r14	; 	xld.b [%sp+0x1], %r14		; (save arg1)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg2 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.w %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r15, %r10
	;
	ld.ub	%r14,[%sp+0x1]	; 	xld.ub %r14, [%sp+0x1]		; (restore arg1)
z80op_FD_L20:
	ld.ub	%r13,[%sp+0x0]	; 	xld.ub %r13, [%sp+0x0]		; (restore code)
z80op_FD_L10:
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(z80, code, arg1, arg2)
	ext	0x16		; 	xld.h [%r0+0x16], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	DD CB d XX ߂̃e[uWvłB
;
	.global z80op_DDCB
z80op_DDCB:
	pushn %r2
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	ext	0x16		; 	xld.uh %r1, [%r0+0x16]		; PC
	ld.uh	%r1,[%r0]
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg1 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.b	[%sp+0x0],%r10	; 	xld.b [%sp+0x0], %r10		; (save arg1)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; code = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	ext	z80_op_table_DDCB+0x0@h	; 	xld.w %r2, z80_op_table_DDCB	; op = &z80_op_table_DDCB[code]
	ext	z80_op_table_DDCB+0x0@m
	ld.w	%r2,z80_op_table_DDCB+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ld.ub	%r14,[%sp+0x0]	; 	xld.ub %r14, [%sp+0x0]		; (restore arg1)
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(z80, code, arg1, arg2)
	ext	0x16		; 	xld.h [%r0+0x16], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************

;
;	FD CB d XX ߂̃e[uWvłB
;
	.global z80op_FDCB
z80op_FDCB:
	pushn %r2
	sub	%sp,0x1		; 	xsub %sp, %sp, 4
	;
	ld.w %r0, %r12			; z80
	ext	0x16		; 	xld.uh %r1, [%r0+0x16]		; PC
	ld.uh	%r1,[%r0]
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; arg1 = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.b	[%sp+0x0],%r10	; 	xld.b [%sp+0x0], %r10		; (save arg1)
	;
	ext	0x30		; 	xld.w %r11, [%r0+0x30]		; code = z80->read(z80, PC++)
	ld.w	%r11,[%r0]
	ld.w %r12, %r0
	ld.uh %r13, %r1
	call.d %r11
	add %r1, 1			; *delay*
	ld.ub %r13, %r10
	;
	ext	z80_op_table_FDCB+0x0@h	; 	xld.w %r2, z80_op_table_FDCB	; op = &z80_op_table_FDCB[code]
	ext	z80_op_table_FDCB+0x0@m
	ld.w	%r2,z80_op_table_FDCB+0x0@l
	sll	%r10,0x3	; 	xsll %r10, 3
	add %r2, %r10
	;
	ld.ub	%r14,[%sp+0x0]	; 	xld.ub %r14, [%sp+0x0]		; (restore arg1)
	;
	ld.w	%r10,[%r2]	; 	xld.w %r10, [%r2+0x0]		; op->proc(z80, code, arg1, arg2)
	ext	0x16		; 	xld.h [%r0+0x16], %r1		; PC *anti-interlock*
	ld.h	[%r0],%r1
	call.d %r10
	ld.w %r12, %r0			; *delay*
	;
	ext	0x24		; 	xld.w %r10, [%r0+0x24]		; CYCLE -= op->cycle
	ld.w	%r10,[%r0]
	ext	0x5		; 	xld.ub %r11, [%r2+0x5]
	ld.ub	%r11,[%r2]
	sub %r10, %r11
	ext	0x24		; 	xld.w [%r0+0x24], %r10
	ld.w	[%r0],%r10
	;
	add	%sp,0x1		; 	xadd %sp, %sp, 4
	popn %r2
	ret

;****************************************************************************
;	General-Purpose Arithmetic and CPU Control Group
;****************************************************************************

;
;	8rbgZs܂B
;
	.global z80_ADD8
z80_ADD8:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A
	ld.ub	%r14,[%r12]
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	add %r10, %r11
	;
	ld.w %r11, %psr				; F(S,Z,V,C)
	and	%r11,0xf	; 	xand %r11, %r11, 0xf
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	ext	0x0		; 	xand %r10, %r10, 0x28			; F(Y,X)
	and	%r10,0x28
	or %r11, %r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	add %r14, %r13
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbgZ(L[)s܂B
;
;	* {A,n,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	  ڂƓڂ̉Z̃I[o[t[tOAr_aōƂ낪|Cg!
;
	.global z80_ADC8
z80_ADC8:
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A *anti-interlock*
	ld.ub	%r14,[%r12]
	and	%r15,0x1	; 	xand %r15, %r15, 1
	;
	swap %r10, %r14				; A + n
	swap %r11, %r13
	add %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	and	%r11,0xc	; 	xand %r11, %r11, 0xc
	;
	swap %r4, %r15				; A + n + c
	add %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r5, %r4, 0x4
	and	%r5,%r4
	xor %r11, %r5
	and	%r4,0xb		; 	xand %r4, %r4, 0xb
	or %r11, %r4
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	ext	0x0		; 	xand %r10, %r10, 0x28			; F(Y,X)
	and	%r10,0x28
	or %r11, %r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	add %r14, %r13
	add %r14, %r15
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbgZs܂B
;
	.global z80_SUB8
z80_SUB8:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A
	ld.ub	%r14,[%r12]
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	sub %r10, %r11
	;
	ld.w %r11, %psr				; F(S,Z,V,C)
	and	%r11,0xf	; 	xand %r11, %r11, 0xf
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	ext	0x0		; 	xand %r10, %r10, 0x28			; F(Y,X)
	and	%r10,0x28
	or %r11, %r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	sub %r14, %r13
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	or	%r11,0x2	; 	xoor %r11, %r11, 2			; F(N)
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbgZ({[)s܂B
;
;	{A,n,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	ڂƓڂ̉Z̃I[o[t[tOAr_aōƂ낪|Cg!
;
	.global z80_SBC8
z80_SBC8:
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A *anti-interlock*
	ld.ub	%r14,[%r12]
	and	%r15,0x1	; 	xand %r15, %r15, 1
	;
	swap %r10, %r14				; A - n
	swap %r11, %r13
	sub %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	and	%r11,0xc	; 	xand %r11, %r11, 0xc
	;
	swap %r4, %r15				; A - n - c
	sub %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r5, %r4, 0x4
	and	%r5,%r4
	xor %r11, %r5
	and	%r4,0xb		; 	xand %r4, %r4, 0xb
	or %r11, %r4
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; A
	ext	0x1		; 	xld.b [%r12+0x1], %r10
	ld.b	[%r12],%r10
	;
	ext	0x0		; 	xand %r10, %r10, 0x28			; F(Y,X)
	and	%r10,0x28
	or %r11, %r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	sub %r14, %r13
	sub %r14, %r15
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	or	%r11,0x2	; 	xoor %r11, %r11, 2			; F(N)
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	_ς߂܂B
;
	.global z80_AND
z80_AND:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]		; A
	ld.ub	%r10,[%r12]
	and %r10, %r13			; A & n !INTERLOCK!
	jrne.d	z80_AND_L10	; 	xjrne.d z80_AND_L10
	ld.w %r11, 0x10			; F(H) *delay*
	ext	0x1		; 	xoor %r11, %r11, 0x40		; F(Z)
	or	%r11,0x0
z80_AND_L10:
	ext	0x1		; 	xld.b [%r12+0x1], %r10		; A
	ld.b	[%r12],%r10
	ext	z80_PARITY+0x0@h	; 	xld.ub %r13, [%r10+z80_PARITY]	; F(P)
	ext	z80_PARITY+0x0@m
	ld.w	%r9,z80_PARITY+0x0@l
	add	%r9,%r10
	ld.ub	%r13,[%r9]
	ext	0x2		; 	xand %r10, %r10, 0xa8		; F(S,Y,X) *anti-interlock*
	and	%r10,0x28
	or %r11, %r13
	or %r11, %r10
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11		; F
	ret

;****************************************************************************

;
;	_a߂܂B
;
	.global z80_OR
z80_OR:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]		; A
	ld.ub	%r10,[%r12]
	or %r10, %r13			; A | n !INTERLOCK!
	jrne.d	z80_OR_L10	; 	xjrne.d z80_OR_L10
	ld.w %r11, 0			; *delay*
	ext	0x1		; 	xoor %r11, %r11, 0x40		; F(Z)
	or	%r11,0x0
z80_OR_L10:
	ext	0x1		; 	xld.b [%r12+0x1], %r10		; A
	ld.b	[%r12],%r10
	ext	z80_PARITY+0x0@h	; 	xld.ub %r13, [%r10+z80_PARITY]	; F(P)
	ext	z80_PARITY+0x0@m
	ld.w	%r9,z80_PARITY+0x0@l
	add	%r9,%r10
	ld.ub	%r13,[%r9]
	ext	0x2		; 	xand %r10, %r10, 0xa8		; F(S,Y,X) *anti-interlock*
	and	%r10,0x28
	or %r11, %r13
	or %r11, %r10
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11		; F
	ret

;****************************************************************************

;
;	r_a߂܂B
;
	.global z80_XOR
z80_XOR:
	ext	0x1		; 	xld.ub %r10, [%r12+0x1]		; A
	ld.ub	%r10,[%r12]
	xor %r10, %r13			; A ^ n !INTERLOCK!
	jrne.d	z80_XOR_L10	; 	xjrne.d z80_XOR_L10
	ld.w %r11, 0			; *delay*
	ext	0x1		; 	xoor %r11, %r11, 0x40		; F(Z)
	or	%r11,0x0
z80_XOR_L10:
	ext	0x1		; 	xld.b [%r12+0x1], %r10		; A
	ld.b	[%r12],%r10
	ext	z80_PARITY+0x0@h	; 	xld.ub %r13, [%r10+z80_PARITY]	; F(P)
	ext	z80_PARITY+0x0@m
	ld.w	%r9,z80_PARITY+0x0@l
	add	%r9,%r10
	ld.ub	%r13,[%r9]
	ext	0x2		; 	xand %r10, %r10, 0xa8		; F(S,Y,X) *anti-interlock*
	and	%r10,0x28
	or %r11, %r13
	or %r11, %r10
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11		; F
	ret

;****************************************************************************

;
;	rs܂B
;
	.global z80_CP
z80_CP:
	ext	0x1		; 	xld.ub %r14, [%r12+0x1]			; A
	ld.ub	%r14,[%r12]
	swap %r11, %r13				; *anti-interlock*
	swap %r10, %r14
	cmp %r10, %r11
	;
	ld.w %r11, %psr				; F(S,Z,V,C)
	and	%r11,0xf	; 	xand %r11, %r11, 0xf
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	ext	0x28		; 	xand %r10, %r13, 0x28			; F(Y,X) *anti-interlock*
	and	%r10,%r13
	or %r11, %r10
	;
	and	%r14,0xf	; 	xand %r14, %r14, 0xf			; F(H)
	and	%r13,0xf	; 	xand %r13, %r13, 0xf
	sub %r14, %r13
	and	%r14,0x10	; 	xand %r14, %r14, 0x10
	or %r11, %r14
	;
	or	%r11,0x2	; 	xoor %r11, %r11, 2			; F(N)
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbglCNg܂B
;
;	{r,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	CłɊrׂăTCY͏ǁA1%炢xȂĂ܂܂EEE
;
	.global z80_INC8
z80_INC8:
	swap %r10, %r13				; r + 1
	ext	0x20		; 	xadd %r10, %r10, 0x01000000
	ext	0x0
	add	%r10,0x0
	;
	ld.w %r11, %psr				; %psr(V,N,Z)
	and	%r11,0x7	; 	xand %r11, %r11, 0x7
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V)
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; r
	;
	ext	0x28		; 	xand %r14, %r10, 0x28			; F(Y,X)
	and	%r14,%r10
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	or %r11, %r14				; *anti-interlock*
	and	%r15,0x1	; 	xand %r15, %r15, 1
	or %r11, %r15
	;
	and	%r13,0xf	; 	xand %r13, %r13, 0xf			; F(H)
	add	%r13,0x1	; 	xadd %r13, %r13, 1
	and	%r13,0x10	; 	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	8rbglfNg܂B
;
;	{r,F(C)}̑S̓p^[ɑ΂āACłƓʂɂȂ邱ƂmFς݂łB
;	CłɊrׂăTCY͏ǁA1%炢xȂĂ܂܂EEE
;
	.global z80_DEC8
z80_DEC8:
	swap %r10, %r13				; r - 1
	ext	0x20		; 	xsub %r10, %r10, 0x01000000
	ext	0x0
	sub	%r10,0x0
	;
	ld.w %r11, %psr				; %psr(V,N,Z)
	and	%r11,0x7	; 	xand %r11, %r11, 0x7
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V)
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	swap %r10, %r10				; r
	;
	ext	0x28		; 	xand %r14, %r10, 0x28			; F(Y,X)
	and	%r14,%r10
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	or %r11, %r14				; *anti-interlock*
	and	%r15,0x1	; 	xand %r15, %r15, 1
	or %r11, %r15
	;
	and	%r13,0xf	; 	xand %r13, %r13, 0xf			; F(H)
	sub	%r13,0x1	; 	xsub %r13, %r13, 1
	and	%r13,0x10	; 	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	or	%r11,0x2	; 	xoor %r11, %r11, 2			; F(N)
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************
;	16-Bit Arithmetic Group
;****************************************************************************

;
;	16rbgZs܂B
;
	.global z80_ADD16
z80_ADD16:
	ld.ub	%r11,[%r12]	; 	xld.ub %r11, [%r12+0x0]			; F(S,Z,V)
	ld.w %r10, %r13				; rr + nn *anti-interlock*
	ext	0x3		; 	xand %r11, %r11, 0xc4
	and	%r11,0x4
	add %r10, %r14
	ld.w	%r15,%r10	; 	xand %r15, %r10, 0xffff0000
	ext	0x1c00
	and	%r15,0x0
	jreq	z80_ADD16_L10	; 	xjreq z80_ADD16_L10
	sub %r10, %r15
	or	%r11,0x1	; 	xoor %r11, %r11, 1			; F(C)
z80_ADD16_L10:
	;
	ld.w %r15, %r10				; F(Y,X)
	srl	%r15,0x8	; 	xsrl %r15, 8
	ext	0x0		; 	xand %r15, %r15, 0x28
	and	%r15,0x28
	or %r11, %r15
	;
	ext	0x3f		; 	xand %r13, %r13, 0xfff			; F(H)
	and	%r13,0x3f
	ext	0x3f		; 	xand %r14, %r14, 0xfff
	and	%r14,0x3f
	add %r13, %r14
	srl	%r13,0x8	; 	xsrl %r13, 8
	and	%r13,0x10	; 	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	16rbgZ(L[)s܂B
;
	.global z80_ADC16
z80_ADC16:
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	ld.w %r10, %r13
	ld.w %r11, %r14
	and	%r15,0x1	; 	xand %r15, %r15, 1
	;
	sll	%r10,0x8	; 	xsll %r10, 16				; rr + nn
	sll	%r10,0x8
	sll	%r11,0x8	; 	xsll %r11, 16
	sll	%r11,0x8
	add %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	and	%r11,0xc	; 	xand %r11, %r11, 0xc
	;
	ld.w %r4, %r15				; rr + nn + c
	sll	%r4,0x8		; 	xsll %r4, 16
	sll	%r4,0x8
	add %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r5, %r4, 0x4
	and	%r5,%r4
	xor %r11, %r5
	and	%r4,0xb		; 	xand %r4, %r4, 0xb
	or %r11, %r4
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	srl	%r10,0x8	; 	xsrl %r10, 16				; rr
	srl	%r10,0x8
	;
	ld.w %r4, %r10				; F(Y,X)
	srl	%r4,0x8		; 	xsrl %r4, 8
	ext	0x0		; 	xand %r4, %r4, 0x28
	and	%r4,0x28
	or %r11, %r4
	;
	ext	0x3f		; 	xand %r13, %r13, 0xfff			; F(H)
	and	%r13,0x3f
	ext	0x3f		; 	xand %r14, %r14, 0xfff
	and	%r14,0x3f
	add %r13, %r14
	add %r13, %r15
	srl	%r13,0x8	; 	xsrl %r13, 8
	and	%r13,0x10	; 	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************

;
;	16rbgZ({[)s܂B
;
	.global z80_SBC16
z80_SBC16:
	ld.ub	%r15,[%r12]	; 	xld.ub %r15, [%r12+0x0]			; F(C)
	ld.w %r10, %r13
	ld.w %r11, %r14
	and	%r15,0x1	; 	xand %r15, %r15, 1
	;
	sll	%r10,0x8	; 	xsll %r10, 16				; rr - nn
	sll	%r10,0x8
	sll	%r11,0x8	; 	xsll %r11, 16
	sll	%r11,0x8
	sub %r10, %r11
	;
	ld.w %r11, %psr				; %psr(C1,V1)
	and	%r11,0xc	; 	xand %r11, %r11, 0xc
	;
	ld.w %r4, %r15				; rr - nn - c
	sll	%r4,0x8		; 	xsll %r4, 16
	sll	%r4,0x8
	sub %r10, %r4
	;
	ld.w %r4, %psr				; %psr(C1|C2,V1^V2,Z2,N2)
	ext	0x4		; 	xand %r5, %r4, 0x4
	and	%r5,%r4
	xor %r11, %r5
	and	%r4,0xb		; 	xand %r4, %r4, 0xb
	or %r11, %r4
	ext	z80_FLAG_CONV+0x0@h	; 	xld.ub %r11, [%r11+z80_FLAG_CONV]	; F(S,Z,V,C)
	ext	z80_FLAG_CONV+0x0@m
	ld.w	%r9,z80_FLAG_CONV+0x0@l
	add	%r9,%r11
	ld.ub	%r11,[%r9]
	;
	srl	%r10,0x8	; 	xsrl %r10, 16				; rr
	srl	%r10,0x8
	;
	ld.w %r4, %r10				; F(Y,X)
	srl	%r4,0x8		; 	xsrl %r4, 8
	ext	0x0		; 	xand %r4, %r4, 0x28
	and	%r4,0x28
	or %r11, %r4
	;
	ext	0x3f		; 	xand %r13, %r13, 0xfff			; F(H)
	and	%r13,0x3f
	ext	0x3f		; 	xand %r14, %r14, 0xfff
	and	%r14,0x3f
	sub %r13, %r14
	sub %r13, %r15
	srl	%r13,0x8	; 	xsrl %r13, 8
	and	%r13,0x10	; 	xand %r13, %r13, 0x10
	or %r11, %r13
	;
	or	%r11,0x2	; 	xoor %r11, %r11, 2			; F(N)
	;
	ld.b	[%r12],%r11	; 	xld.b [%r12+0x0], %r11			; F
	;
	ret

;****************************************************************************
;	
;****************************************************************************

;#endif /*Z80_ASM*/
