/*	
 *	util.c
 *
 *	WDMfoCXhCoėp[`
 *	Copyright (C) 2005 Naoyuki Sawa
 *
 *	* Wed Aug 03 21:57:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 */
#include "util.h"

//-----------------------------------------------------------------------------------------------------------------------------
// * Win32AvP[VɁACOM|[gƂĔFɂ́Aȉ̃WXgL[o^܂B
//
//	HKEY_LOCAL_MACHINE\HARDWARE\DEVICEMAP\SERIALCOMM
//
//	[-]}CRs[^
//	   [-]HKEY_LOCAL_MACHINE
//	      [-]HARDWARE
//	         [-]DEVICEMAP
//	            [-]SERIALCOMM [ab](W)          REG_SZ (l̐ݒȂ)
//	                          [ab]\Device\Serial0 REG_SZ COM1
//	                          [ab]\Device\PceCom  REG_SZ COM? <=ǉ܂!!
//	                              ~~~~~~~~~~~~~~         ~~~~
//	                              ɂ́A̓foCXłKv͂܂B
//	                              ̃foCX̓o^Ƃ̏dh߂ɁA
//	                              foCXgKɂȂĂ̂Ǝv܂B
//
// - RtlWriteRegistryValue()gƁAWXgL[̃tpXw肵ȂĂA
//   񂽂ɂ̃WXgL[ɃANZX邱Ƃł܂B
//
// - ̃WXgL[́APCċN邽тɎIɃNA܂B
//   ]āAhCoAddDeviceɂāAo^Kv܂B
//   AfoCXOꂽƂɁAIɃNA͂܂B
//   ]āAhCoRemoveDeviceɂāAIɓo^Kv܂B
//-----------------------------------------------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------------------------------------------
// * sȃfoCXhCogȂǂɁAWindowsVXe̎COM|[g蓖ĂYĂ܂ꍇ܂B
//   ʏAŏCOM1ACOM2݂AǉꂽCOM|[gCOM3ACOM4A...ƂȂ͂łA
//   COM3΂COM4ɂȂAsȃfoCXhCogтCOM5ACOM6A...ƌփYčs肵܂B
//
// - ̏Ǐɂ́Aȉ̃WXgL[ƂŏC܂B
//
//	HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\COM Name Arbiter
//
//	[-]}CRs[^
//	   [-]HKEY_LOCAL_MACHINE
//	      [-]HARDWARE
//	         [-]DEVICEMAP
//	            [-]SERIALCOMM [01]ComDB REG_BINARY 03 00 00 00 00 00 00 00
//	                                               00 00 00 00 00 00 00 00
//	                                               00 00 00 00 00 00 00 00
//	                                               00 00 00 00 00 00 00 00
//
//   ̃WXgL[́A\񂳂ĂCOM|[ǵArbg}XNzƂȂĂ܂B
//   COM1ACOM2݂ꍇAŏ̃oCgbit0bit1OnAc̃f[^ׂ͂0łB
//   Ȃ킿AWXgL[̓éA{03,00,00,...,00} (S32oCg) ƂȂĂ܂B
//
// - sȃfoCXhCõA[hɎsꍇȂǂɁA\rbgĂꍇ܂B
//   Ă܂\rbgƂŃ[ɖ߂ƂɂACOM|[g蓖ẴYɖ߂Ƃł܂B
//   C̍ۂɁAāAoCg(32oCg)𑝂₵茸炵肵Ȃ悤AӂĂ!!
//-----------------------------------------------------------------------------------------------------------------------------

//-----------------------------------------------------------------------------------------------------------------------------
// * ҂sȂIoCallDriver()̒OɁAIoMarkIrpPending()sŔÂƂłB
//   ʂIoCallDriver()STATUS_PENDINGԂꍇ́ÃxłIoMarkIrpPending()ĂԕKv悤łB
//   AIoCallDriver()Ă񂾏uԂɁAirp͖ɂȂĂƍlȂ΂܂B
//   (ɂȂȂP[X́A[`ZbgAbvAA[`STATUS_MORE_PROCESSING_REQUIREDԂꍇ݂̂łB)
//   ̂悤ȃR[h͌łB
//
//	[̗]
//
//	status = IoCallDriver(device_extension->next_device_object, irp);
//	if(status == STATUS_PENDING) {
//		/* <<̃^C~OŊ荞݂AirpAirp̎̂邩Ȃ>> */
//		IoMarkIrpPending(irp); /* ݂ȂȂirpɃANZX!! */
//	}
//
//   ]āA炩ߔÔ߂IoMarkIrpPending(irp)ĂłAƂ@̂܂B(DDKbulkusbTv)
//   PendingȂIRPɑ΂IoMarkIrpPending(irp)ĂԂƂ́Aɖ肠܂B
//   炩ɃVOiԂɂȂĂ銮CxgAVXeIɑ҂A킸ɐ\ቺ邾łB
//-----------------------------------------------------------------------------------------------------------------------------

/*****************************************************************************
 *	
 *****************************************************************************/

/* ΃^CAEgl1~bPʂŎw肵܂B
 * [note]
 *	* KeWaitForSingleObject()̃^CAEgw蓙ɗpLONG_INTEGER\̂́A
 *	  100imbPʂ̕lŁAݎ̑ΎԂ܂B(l͐Ύ)
 *	  vOł1~bPʂ̕킩Ղ̂ŁAϊ֐pӂ܂B
 */
LARGE_INTEGER*
relative_timeout(LARGE_INTEGER* timeout, int msec)
{
	timeout->QuadPart = -(10000i64 * msec);
	//                  | ++++++++------------- 1~b100imbPʕϊ
	//                  +---------------------- ΎԂ͕lŎw肵܂
	return timeout;
}

/*****************************************************************************
 *	
 *****************************************************************************/

typedef struct _NAME_TABLE {
	int code;
	const char* name;
} NAME_TABLE;

static const char*
_lookup_name_table(int code, const NAME_TABLE* name_table, int table_size)
{
	static char tmp[16];
	//
	int i;
	const char* name;

	for(i = 0; i < table_size; i++) {
		if(name_table[i].code == code) {
			return name_table[i].name;
		}
	}

	_snprintf(tmp, sizeof tmp, "$%x", code);
	return tmp;
}

#define lookup_name_table(code, name_table) \
	_lookup_name_table((code), (name_table), sizeof (name_table) / sizeof *(name_table))

/*---------------------------------------------------------------------------*/

static const NAME_TABLE pnp_minor_function_name_table[] = {
{IRP_MN_START_DEVICE,                "IRP_MN_START_DEVICE"                },
{IRP_MN_QUERY_REMOVE_DEVICE,         "IRP_MN_QUERY_REMOVE_DEVICE"         },
{IRP_MN_REMOVE_DEVICE,               "IRP_MN_REMOVE_DEVICE"               },
{IRP_MN_CANCEL_REMOVE_DEVICE,        "IRP_MN_CANCEL_REMOVE_DEVICE"        },
{IRP_MN_STOP_DEVICE,                 "IRP_MN_STOP_DEVICE"                 },
{IRP_MN_QUERY_STOP_DEVICE,           "IRP_MN_QUERY_STOP_DEVICE"           },
{IRP_MN_CANCEL_STOP_DEVICE,          "IRP_MN_CANCEL_STOP_DEVICE"          },
{IRP_MN_QUERY_DEVICE_RELATIONS,      "IRP_MN_QUERY_DEVICE_RELATIONS"      },
{IRP_MN_QUERY_INTERFACE,             "IRP_MN_QUERY_INTERFACE"             },
{IRP_MN_QUERY_CAPABILITIES,          "IRP_MN_QUERY_CAPABILITIES"          },
{IRP_MN_QUERY_RESOURCES,             "IRP_MN_QUERY_RESOURCES"             },
{IRP_MN_QUERY_RESOURCE_REQUIREMENTS, "IRP_MN_QUERY_RESOURCE_REQUIREMENTS" },
{IRP_MN_QUERY_DEVICE_TEXT,           "IRP_MN_QUERY_DEVICE_TEXT"           },
{IRP_MN_FILTER_RESOURCE_REQUIREMENTS,"IRP_MN_FILTER_RESOURCE_REQUIREMENTS"},
{IRP_MN_READ_CONFIG,                 "IRP_MN_READ_CONFIG"                 },
{IRP_MN_WRITE_CONFIG,                "IRP_MN_WRITE_CONFIG"                },
{IRP_MN_EJECT,                       "IRP_MN_EJECT"                       },
{IRP_MN_SET_LOCK,                    "IRP_MN_SET_LOCK"                    },
{IRP_MN_QUERY_ID,                    "IRP_MN_QUERY_ID"                    },
{IRP_MN_QUERY_PNP_DEVICE_STATE,      "IRP_MN_QUERY_PNP_DEVICE_STATE"      },
{IRP_MN_QUERY_BUS_INFORMATION,       "IRP_MN_QUERY_BUS_INFORMATION"       },
{IRP_MN_DEVICE_USAGE_NOTIFICATION,   "IRP_MN_DEVICE_USAGE_NOTIFICATION"   },
{IRP_MN_SURPRISE_REMOVAL,            "IRP_MN_SURPRISE_REMOVAL"            },
};

const char*
pnp_minor_function_name(int code)
{
	return lookup_name_table(code, pnp_minor_function_name_table);
}

/*---------------------------------------------------------------------------*/

static const NAME_TABLE serial_ioctl_name_table[] = {
{IOCTL_SERIAL_SET_BAUD_RATE,    "IOCTL_SERIAL_SET_BAUD_RATE"    },
{IOCTL_SERIAL_SET_QUEUE_SIZE,   "IOCTL_SERIAL_SET_QUEUE_SIZE"   },
{IOCTL_SERIAL_SET_LINE_CONTROL, "IOCTL_SERIAL_SET_LINE_CONTROL" },
{IOCTL_SERIAL_SET_BREAK_ON,     "IOCTL_SERIAL_SET_BREAK_ON"     },
{IOCTL_SERIAL_SET_BREAK_OFF,    "IOCTL_SERIAL_SET_BREAK_OFF"    },
{IOCTL_SERIAL_IMMEDIATE_CHAR,   "IOCTL_SERIAL_IMMEDIATE_CHAR"   },
{IOCTL_SERIAL_SET_TIMEOUTS,     "IOCTL_SERIAL_SET_TIMEOUTS"     },
{IOCTL_SERIAL_GET_TIMEOUTS,     "IOCTL_SERIAL_GET_TIMEOUTS"     },
{IOCTL_SERIAL_SET_DTR,          "IOCTL_SERIAL_SET_DTR"          },
{IOCTL_SERIAL_CLR_DTR,          "IOCTL_SERIAL_CLR_DTR"          },
{IOCTL_SERIAL_RESET_DEVICE,     "IOCTL_SERIAL_RESET_DEVICE"     },
{IOCTL_SERIAL_SET_RTS,          "IOCTL_SERIAL_SET_RTS"          },
{IOCTL_SERIAL_CLR_RTS,          "IOCTL_SERIAL_CLR_RTS"          },
{IOCTL_SERIAL_SET_XOFF,         "IOCTL_SERIAL_SET_XOFF"         },
{IOCTL_SERIAL_SET_XON,          "IOCTL_SERIAL_SET_XON"          },
{IOCTL_SERIAL_GET_WAIT_MASK,    "IOCTL_SERIAL_GET_WAIT_MASK"    },
{IOCTL_SERIAL_SET_WAIT_MASK,    "IOCTL_SERIAL_SET_WAIT_MASK"    },
{IOCTL_SERIAL_WAIT_ON_MASK,     "IOCTL_SERIAL_WAIT_ON_MASK"     },
{IOCTL_SERIAL_PURGE,            "IOCTL_SERIAL_PURGE"            },
{IOCTL_SERIAL_GET_BAUD_RATE,    "IOCTL_SERIAL_GET_BAUD_RATE"    },
{IOCTL_SERIAL_GET_LINE_CONTROL, "IOCTL_SERIAL_GET_LINE_CONTROL" },
{IOCTL_SERIAL_GET_CHARS,        "IOCTL_SERIAL_GET_CHARS"        },
{IOCTL_SERIAL_SET_CHARS,        "IOCTL_SERIAL_SET_CHARS"        },
{IOCTL_SERIAL_GET_HANDFLOW,     "IOCTL_SERIAL_GET_HANDFLOW"     },
{IOCTL_SERIAL_SET_HANDFLOW,     "IOCTL_SERIAL_SET_HANDFLOW"     },
{IOCTL_SERIAL_GET_MODEMSTATUS,  "IOCTL_SERIAL_GET_MODEMSTATUS"  },
{IOCTL_SERIAL_GET_COMMSTATUS,   "IOCTL_SERIAL_GET_COMMSTATUS"   },
{IOCTL_SERIAL_XOFF_COUNTER,     "IOCTL_SERIAL_XOFF_COUNTER"     },
{IOCTL_SERIAL_GET_PROPERTIES,   "IOCTL_SERIAL_GET_PROPERTIES"   },
{IOCTL_SERIAL_GET_DTRRTS,       "IOCTL_SERIAL_GET_DTRRTS"       },
{IOCTL_SERIAL_LSRMST_INSERT,    "IOCTL_SERIAL_LSRMST_INSERT"    },
{IOCTL_SERIAL_CONFIG_SIZE,      "IOCTL_SERIAL_CONFIG_SIZE"      },
{IOCTL_SERIAL_GET_COMMCONFIG,   "IOCTL_SERIAL_GET_COMMCONFIG"   },
{IOCTL_SERIAL_SET_COMMCONFIG,   "IOCTL_SERIAL_SET_COMMCONFIG"   },
{IOCTL_SERIAL_GET_STATS,        "IOCTL_SERIAL_GET_STATS"        },
{IOCTL_SERIAL_CLEAR_STATS,      "IOCTL_SERIAL_CLEAR_STATS"      },
{IOCTL_SERIAL_GET_MODEM_CONTROL,"IOCTL_SERIAL_GET_MODEM_CONTROL"},
{IOCTL_SERIAL_SET_MODEM_CONTROL,"IOCTL_SERIAL_SET_MODEM_CONTROL"},
{IOCTL_SERIAL_SET_FIFO_CONTROL, "IOCTL_SERIAL_SET_FIFO_CONTROL" },
};

const char*
serial_ioctl_name(int code)
{
	return lookup_name_table(code, serial_ioctl_name_table);
}

/*****************************************************************************
 *	
 *****************************************************************************/

/* IONGXg܂B
 */
NTSTATUS
complete_request(IRP* irp, NTSTATUS status, int information)
{
	/* IRP\̂Ɍʂi[܂B */
	irp->IoStatus.Status = status;
	irp->IoStatus.Information = information;

	/* IONGXg̊}[N܂B */
	IoCompleteRequest(irp, IO_NO_INCREMENT);

	return status;
}

/*****************************************************************************
 *	
 *****************************************************************************/

/* IONGXgɌĂяoR[obN֐łB
 */
static NTSTATUS
call_driver_completion_routine(DEVICE_OBJECT* device_object, IRP* irp, void* context)
{
	KEVENT* event = context;

	//if(irp->PendingReturned) {
	//	IoMarkIrpPending(irp);
	//}
	//STATUS_MORE_PROCESSING_REQUIREDԂ[`ł͕svłB

	/* CxgVOiԂɂāAʒm܂B */
	KeSetEvent(event, IO_NO_INCREMENT, FALSE);

	return STATUS_MORE_PROCESSING_REQUIRED; /* K{!! */
}

/* IONGXg𔭍sāA҂܂B
 * [note]
 *	* [`ݒ肷̂ŁAIoSkipCurrentIrpStackLocation()Ƃ̕p͕słB
 *
 *		IoSkipCurrentIrpStackLocation(irp);       // !!
 *		status = call_driver(device_object, irp);
 *
 *	  ɁAIoCopyCurrentIrpStackLocationToNext()gĂB
 *
 *		IoCopyCurrentIrpStackLocationToNext(irp); // 
 *		status = call_driver(device_object, irp);
 *
 *	* ʃhCoIoCompleteRequest()ASTATUS_MORE_PROCESSING_REQUIREDɂĒfԂŏԂ܂B
 *	  IRP͊ĂȂ̂ŁAcall_driver()ĂяoɂĂxAIoCompleteRequest()sKv܂B
 *
 *		call_driver(device_object, irp);
 *			E
 *			E
 *			E
 *		complete_request(irp, irp->IoStatus.Status, irp->IoStatus.Information);
 */
NTSTATUS
call_driver(DEVICE_OBJECT* device_object, IRP* irp)
{
	NTSTATUS status;
	KEVENT event;

	/* KeWaitForSingleObject()ɂăubN邽߁APASSIVE_LEVELK{łB */
	ASSERT(KeGetCurrentIrql() == PASSIVE_LEVEL);

	/* ҂߂̃Cxg܂B */
	KeInitializeEvent(&event, SynchronizationEvent, FALSE);

	/* ɌĂяoR[obN֐o^܂B */
	IoSetCompletionRoutine(irp, call_driver_completion_routine, &event, TRUE, TRUE, TRUE);

	/* IONGXg𔭍sA҂܂B
	 * * Ǝ̊[`񋟂ꍇ́AIoCallDriver()̖߂lSTATUS_PENDINGۂɂ炸A
	 *   K[`ĂяôŁAKeWaitForSingleObject()sč\܂B(ȒP̂)
	 */
	status = IoCallDriver(device_object, irp);
	//if(status == STATUS_PENDING) { /*ĂȂĂOK*/
		KeWaitForSingleObject(&event, Executive, KernelMode, FALSE, NULL);
	//}                              /*ĂȂĂOK*/

	/* * ʏ́AIoCallDriver()ĂяoAIRPɐGĂ͂܂B
	 *   (ʃhCoIIoCompleteRequest()ĂяoAIRPjĂ邩mȂ)
	 * * ł́AƎ̊[`STATUS_MORE_PROCESSING_REQUIREDԂĂ̂ŁA
	 *   X^bNP[V̊߂ŒfA܂IRPjĂȂƂۏ؂ł܂B
	 *   ]āAȉ̃R[hIRPɐGĂ肠܂B
	 */
	return irp->IoStatus.Status;
}

/*****************************************************************************
 *	
 *****************************************************************************/

NTSTATUS
call_usbd(DEVICE_OBJECT* usbd, URB* urb)
{
	NTSTATUS status;
	KEVENT event;
	IRP* irp;
	IO_STACK_LOCATION* stack_location;
	IO_STATUS_BLOCK status_block;

	/* ҂߂̃Cxg܂B */
	KeInitializeEvent(&event, SynchronizationEvent, FALSE);

	/* VIRP쐬܂B
	 * I/O}l[WIRP̂ŁAhCoIɉKv͂܂B
	 */
	irp = IoBuildDeviceIoControlRequest(
		IOCTL_INTERNAL_USB_SUBMIT_URB,	/* IoControlCode */
		usbd,				/* DeviceObject */
		NULL,				/* InputBuffer */
		0,				/* InputBufferLength */
		NULL,				/* OutputBuffer */
		0,				/* OutputBufferLength */
		TRUE,				/* InternalDeviceIoControl */
		&event,				/* Event */
		&status_block);			/* IoStatusBlock */
	if(!irp) {
		return STATUS_UNSUCCESSFUL;
	}

	/* IRP̃p[^ƂāAURBi[܂B */
	stack_location = IoGetNextIrpStackLocation(irp); /* IoGetCurrentIrpStackLocation()ł͂Ȃ!! */
	stack_location->Parameters.Others.Argument1 = urb;

	/* IONGXg𔭍sAKvɉĊ҂܂B
	 * * call_driver()ƈāAʃhCoSTATUS_PENDINGԂꍇ̂݁ACxg҂܂B
	 *   Ǝ̊[`񋟂ĂȂ̂ŁA銮ViII/O}l[WCxgVOiԂ
	 *   邩ǂɂāAmMƂ͂łȂłB(wMicrosoft WDM vO~Oxp.566)
	 */
	status = IoCallDriver(usbd, irp);
	if(status == STATUS_PENDING) {
		KeWaitForSingleObject(&event, Executive, KernelMode, FALSE, NULL);
	}

	/* IRṔAI/O}l[WɂāAƓɂjĂ܂B
	 * ʂ́AIRPIO_STATUS_BLOCKł͂ȂAĂяo񋟂IO_STATUS_BLOCKɊi[Ă܂B
	 */
	return status_block.Status; /* "return status""return irp->IoStatus.Status"ł͂Ȃ!! */
}

/*****************************************************************************
 *	
 *****************************************************************************/

NTSTATUS
wait_for_terminate_thread(HANDLE thread_handle)
{
	NTSTATUS status;
	PKTHREAD thread_object;

	/* XbhnhAXbhIuWFNg擾܂B
	 * * KeWaitForSingleObject()găXbh̏I҂ɂ́AXbhIuWFNgw肷Kv܂B
	 *   KeWaitForSingleObject()̈ɒځAXbhnhw肵āAXbh̏I҂Ƃ͂ł܂B
	 */
	status = ObReferenceObjectByHandle(
		thread_handle,
		THREAD_ALL_ACCESS,
		NULL,
		KernelMode,
		&thread_object,
		NULL);
	if(NT_SUCCESS(status)) {

		/* Xbh̏I҂܂B */
		status = KeWaitForSingleObject(thread_object, Executive, KernelMode, FALSE, NULL);

		/* Ŏ擾XbhIuWFNǵAQƂJ܂B
		 * * XbhnhsvȂ΁AĂяoɂZwClose()gĊJĂB
		 */
		ObDereferenceObject(thread_object);
	}

	return status;
}

/*****************************************************************************
 *	
 *****************************************************************************/

// [gp]
//
//	NTSTATUS status;
//	HANDLE key_handle;
//	KEY_VALUE_FULL_INFORMATION* key_value_information;
//	UNICODE_STRING data;
//
//	status = IoOpenDeviceRegistryKey(
//		device_extension->physical_device_object,
//		PLUGPLAY_REGKEY_DEVICE,
//		STANDARD_RIGHTS_ALL,
//		&key_handle);
//	if(NT_SUCCESS(status)) {
//		key_value_information = query_value_key(key_handle, L"PortName");
//		if(key_value_information) {
//			if(key_value_information->Type == REG_SZ) {
//				RtlInitUnicodeString(&data, (PCWSTR)((int)key_value_information + key_value_information->DataOffset));
//				/** use data **/
//			}
//			ExFreePool(key_value_information);
//		}
//		ZwClose(key_handle);
//	}
//
KEY_VALUE_FULL_INFORMATION*
query_value_key(HANDLE key_handle, PCWSTR value_name)
{
	NTSTATUS status;
	UNICODE_STRING _value_name;
	int length;
	KEY_VALUE_FULL_INFORMATION* key_value_information;

	RtlInitUnicodeString(&_value_name, value_name);

	length = 0;
	status = ZwQueryValueKey(
		key_handle,
		&_value_name,
		KeyValueFullInformation,
		NULL,
		length,
		&length);
	//if(status != STATUS_BUFFER_TOO_SMALL) {
	//	return NULL;
	//}
	//length=0w肵ꍇɁAZwQueryValueKey()STATUS_BUFFER_TOO_SMALLȊOԂꍇ邻łB
	//(wMicrosoft WDM vO~Oxp.130B茳Win2K SP4ł́ASTATUS_BUFFER_TOO_SMALLԂĂ܂c)
	//ZwQueryValueKey()͎slengthύXȂ̂ŁAlengthύXĂ邩ۂŔf邱Ƃɂ܂B
	if(!length) {
		return NULL;
	}

	key_value_information = ExAllocatePool(NonPagedPool, length);
	if(!key_value_information) {
		return NULL;
	}

	status = ZwQueryValueKey(
		key_handle,
		&_value_name,
		KeyValueFullInformation,
		key_value_information,
		length,
		&length);
	if(!NT_SUCCESS(status)) {
		ExFreePool(key_value_information);
		return NULL;
	}

	return key_value_information;
}

/*****************************************************************************
 *	
 *****************************************************************************/

NTSTATUS
set_value_key(HANDLE key_handle, PCWSTR value_name, int type, const void* data, int data_size)
{
	NTSTATUS status;
	UNICODE_STRING _value_name;

	RtlInitUnicodeString(&_value_name, value_name);

	status = ZwSetValueKey(
		key_handle,
		&_value_name,
		0,
		type,
		(void*)data,
		data_size);

	return status;
}

/*****************************************************************************
 *	
 *****************************************************************************/

PKTHREAD
create_thread(void (*start_routine)(void*), void* start_context)
{
	HANDLE thread_handle = NULL;
	PKTHREAD thread_object = NULL;
	//
	NTSTATUS status;

	/* Xbh쐬AXbhnh擾܂B
	 * * PsCreateSystemThread()ꍇAXbhnhXbĥւ̎QƂێĂ܂B
	 */
	status = PsCreateSystemThread(
		&thread_handle,		/* ThreadHandle */
		THREAD_ALL_ACCESS,	/* DesiredAccess */
		NULL,			/* ObjectAttributes */
		NULL,			/* ProcessHandle */
		NULL,			/* ClientId */
		start_routine,		/* StartRoutine */
		start_context);		/* StartContext */
	if(!NT_SUCCESS(status)) {
		KdPrint(("PsCreateSystemThread failed\n"));
		goto L_EXIT;
	}

	/* XbhnhAXbhIuWFNg擾܂B
	 * * ObReferenceObjectByHandle()ꍇAXbhnhƃXbhIuWFNgXbĥւ̎QƂێĂ܂B
	 */
	status = ObReferenceObjectByHandle(
		thread_handle,		/* Handle */
		THREAD_ALL_ACCESS,	/* DesiredAccess */
		NULL,			/* ObjectType */
		KernelMode,		/* AccessMode */
		(void*)&thread_object,	/* Object */
		NULL);			/* HandleInformation */
	if(!NT_SUCCESS(status)) {
		KdPrint(("ObReferenceObjectByHandle failed\n"));
		goto L_EXIT;
	}

L_EXIT:

	/* PsCreateSystemThread()ĂAObReferenceObjectByHandle()̐ۂɂ炸AXbhnhJ܂B
	 * * ObReferenceObjectByHandle()ĂꍇAXbhIuWFNgXbĥւ̎QƂێĂ܂B
	 *   ꂪAʏ̓łB
	 * * ObReferenceObjectByHandle()sĂꍇAXbĥւ̎QƂAXbh͒ɕԂɂȂĂ܂B
	 *   ߂āAXbhIƂłAJ[l[hɂ̓XbhIAPI߁As\łB
	 *   Xbh삵܂܁AhCoA[hƁA炭یG[ŃVXe~ł傤B
	 *   ۂɂ́AObReferenceObjectByHandle()s邱Ƃ͂܂͂Ȃ̂ŁÂ悤Ȗ͔Ȃm܂B
	 *   AObReferenceObjectByHandle()sꍇAq̖肪邱Ƃ𗯈ӂĂĂB()
	 */
	if(thread_handle) {
		ZwClose(thread_handle);
	}

	return thread_object;
}

/*****************************************************************************
 *	
 *****************************************************************************/

void
delete_thread(PKTHREAD thread_object)
{
	NTSTATUS status;

	/* mɃXbh~̂҂܂B
	 * 炩ߌĂяoɂāAXbhւ̒~v𔭍sĂĂB
	 */
	status = KeWaitForSingleObject(thread_object, Executive, KernelMode, FALSE, NULL);
	if(!NT_SUCCESS(status)) {
		KdPrint(("KeWaitForSingleObject failed\n"));
		/* s(^^; */
	}

	/* XbhIuWFNgJ܂B */
	ObDereferenceObject(thread_object);
}

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _SERIALCOMM {
	UNICODE_STRING device_name;
	UNICODE_STRING port_name;
	UNICODE_STRING symbolic_link_name;
	//
	wchar_t _device_name[64];
	wchar_t _port_name[64];
	wchar_t _symbolic_link_name[64];
} SERIALCOMM;

/* COM|[go^܂B
 */
void*
register_serialcomm(DEVICE_OBJECT* physical_device_object, const wchar_t* device_name)
{
	SERIALCOMM* serialcomm = NULL;
	//
	HANDLE key_handle = NULL;
	KEY_VALUE_FULL_INFORMATION* key_value_information = NULL;
	//
	NTSTATUS status;

	KdPrint(("register_serialcomm\n"));

	/* SERIALCOMM\̂mۂA܂B */
	serialcomm = ExAllocatePool(NonPagedPool, sizeof(SERIALCOMM));
	if(!serialcomm) {
		KdPrint(("ExAllocatePool failed\n"));
		return NULL;
	}
	memset(serialcomm, 0, sizeof(SERIALCOMM));
	RtlInitEmptyUnicodeString(&serialcomm->device_name,
		serialcomm->_device_name, sizeof serialcomm->_device_name);
	RtlInitEmptyUnicodeString(&serialcomm->port_name,
		serialcomm->_port_name, sizeof serialcomm->_port_name);
	RtlInitEmptyUnicodeString(&serialcomm->symbolic_link_name,
		serialcomm->_symbolic_link_name, sizeof serialcomm->_symbolic_link_name);

	/* foCXi[܂B */
	status = RtlAppendUnicodeToString(&serialcomm->device_name, device_name);
	if(!NT_SUCCESS(status)) {
		KdPrint(("RtlAppendUnicodeToString failed\n"));
		goto L_EXIT;
	}
	KdPrint(("Device name = %wZ\n", &serialcomm->device_name));

	/* VXeɂĎIɊ蓖Ăꂽ|[g擾܂B */
	status = IoOpenDeviceRegistryKey(
		physical_device_object,
		PLUGPLAY_REGKEY_DEVICE,
		STANDARD_RIGHTS_ALL,
		&key_handle/*v*/);
	if(!NT_SUCCESS(status)) {
		KdPrint(("IoOpenDeviceRegistryKey failed\n"));
		goto L_EXIT;
	}
	key_value_information/*v*/ = query_value_key(key_handle, L"PortName");
	if(!key_value_information) {
		KdPrint(("query_value_key failed\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}
	if(key_value_information->Type != REG_SZ) {
		KdPrint(("Key type error\n"));
		status = STATUS_UNSUCCESSFUL;
		goto L_EXIT;
	}
	status = RtlAppendUnicodeToString(&serialcomm->port_name,
		(wchar_t*)((int)key_value_information + key_value_information->DataOffset));
	if(!NT_SUCCESS(status)) {
		KdPrint(("RtlAppendUnicodeToString failed\n"));
		goto L_EXIT;
	}
	KdPrint(("Port name = %wZ\n", &serialcomm->port_name));

	/* VA|[gfoCXւ̃V{bNN쐬܂B */
	status = RtlAppendUnicodeToString(&serialcomm->symbolic_link_name, L"\\??\\");
	if(!NT_SUCCESS(status)) {
		KdPrint(("RtlAppendUnicodeToString failed\n"));
		goto L_EXIT;
	}
	status = RtlAppendUnicodeStringToString(&serialcomm->symbolic_link_name, &serialcomm->port_name);
	if(!NT_SUCCESS(status)) {
		KdPrint(("RtlAppendUnicodeToString failed\n"));
		goto L_EXIT;
	}
	KdPrint(("Symbolic link name = %wZ\n", &serialcomm->symbolic_link_name));

	/* V{bNN쐬܂B */
	status = IoCreateSymbolicLink(&serialcomm->symbolic_link_name, &serialcomm->device_name);
	if(!NT_SUCCESS(status)) {
		KdPrint(("IoCreateSymbolicLink failed\n"));
		goto L_EXIT;
	}

	/* WXgCOM|[gꗗɓo^܂B */
	status = RtlWriteRegistryValue(
		RTL_REGISTRY_DEVICEMAP,
		L"SERIALCOMM",
		serialcomm->device_name.Buffer,
		REG_SZ,
		serialcomm->port_name.Buffer,
		serialcomm->port_name.Length + sizeof(wchar_t));
	if(!NT_SUCCESS(status)) {
		KdPrint(("RtlWriteRegistryValue failed\n"));
		goto L_EXIT;
	}

L_EXIT:

	if(!NT_SUCCESS(status)) {
		if(serialcomm) {
			ExFreePool(serialcomm);
			serialcomm = NULL; /* YȂ!! */
		}
	}
	if(key_value_information) {
		ExFreePool(key_value_information);
	}
	if(key_handle) {
		ZwClose(key_handle);
	}

	return serialcomm;
}

/* COM|[go^܂B
 */
void
unregister_serialcomm(void* _serialcomm)
{
	SERIALCOMM* serialcomm = _serialcomm;

	KdPrint(("unregister_serialcomm\n"));

	if(serialcomm) {

		KdPrint(("Device name = %wZ\n", &serialcomm->device_name));
		KdPrint(("Port name = %wZ\n", &serialcomm->port_name));
		KdPrint(("Symbolic link name = %wZ\n", &serialcomm->symbolic_link_name));

		/* WXgCOM|[gꗗo^܂B */
		if(serialcomm->device_name.Buffer) {
			RtlDeleteRegistryValue(
				RTL_REGISTRY_DEVICEMAP,
				L"SERIALCOMM",
				serialcomm->device_name.Buffer);
		}

		/* V{bNN폜܂B */
		if(serialcomm->symbolic_link_name.Buffer) {
			IoDeleteSymbolicLink(&serialcomm->symbolic_link_name);
		}

		/* SERIALCOMM\̂܂B */
		ExFreePool(serialcomm);
	}
}

/*****************************************************************************
 *	
 *****************************************************************************/

USB_CONFIGURATION_DESCRIPTOR*
get_configuration_descriptor(DEVICE_OBJECT* usbd, int i_configuration)
{
	NTSTATUS status;
	URB urb;
	int configuration_descriptor_size;
	USB_CONFIGURATION_DESCRIPTOR* configuration_descriptor;

	/* RtBM[VAC^[tFCXAGh|CgfBXNv^Ŝ̃TCY擾邽߂ɁA
	 * ܂ARtBM[VfBXNv^݂̂擾܂B
	 */
	configuration_descriptor_size = sizeof(USB_CONFIGURATION_DESCRIPTOR);
	/*{{R[h*/
	configuration_descriptor = ExAllocatePool(NonPagedPool, configuration_descriptor_size);
	if(!configuration_descriptor) {
		KdPrint(("ExAllocatePool failed\n"));
		return NULL;
	}
	UsbBuildGetDescriptorRequest(
		&urb,						/* Urb */
		sizeof(struct _URB_CONTROL_DESCRIPTOR_REQUEST),	/* Length */
		USB_CONFIGURATION_DESCRIPTOR_TYPE,		/* DescriptorType */
		(unsigned char)i_configuration,			/* Index */
		0,						/* LanguageId */
		configuration_descriptor,			/* TransferBuffer */
		NULL,						/* TransferBufferMDL */
		configuration_descriptor_size,			/* TransferBufferLength */
		NULL);						/* Link */
	status = call_usbd(usbd, &urb);
	if(!NT_SUCCESS(status)) {
		KdPrint(("call_usbd failed\n"));
		ExFreePool(configuration_descriptor);
		return NULL;
	}
	/*}}R[h*/
	configuration_descriptor_size = configuration_descriptor->wTotalLength;
	ExFreePool(configuration_descriptor);

	/* RtBM[VAC^[tFCXAGh|CgfBXNv^Ŝ擾܂B */
	/*{{R[h*/
	configuration_descriptor = ExAllocatePool(NonPagedPool, configuration_descriptor_size);
	if(!configuration_descriptor) {
		KdPrint(("ExAllocatePool failed\n"));
		return NULL;
	}
	UsbBuildGetDescriptorRequest(
		&urb,						/* Urb */
		sizeof(struct _URB_CONTROL_DESCRIPTOR_REQUEST),	/* Length */
		USB_CONFIGURATION_DESCRIPTOR_TYPE,		/* DescriptorType */
		(unsigned char)i_configuration,			/* Index */
		0,						/* LanguageId */
		configuration_descriptor,			/* TransferBuffer */
		NULL,						/* TransferBufferMDL */
		configuration_descriptor_size,			/* TransferBufferLength */
		NULL);						/* Link */
	status = call_usbd(usbd, &urb);
	if(!NT_SUCCESS(status)) {
		KdPrint(("call_usbd failed\n"));
		ExFreePool(configuration_descriptor);
		return NULL;
	}
	/*}}R[h*/

	return configuration_descriptor;
}

/****************************************************************************
 *
 ****************************************************************************/

/* RtBM[VI܂B
 */
int
set_configuration(DEVICE_OBJECT* usbd, USBD_PIPE_INFORMATION pipes[/*max_pipes*/], int max_pipes)
{
	int num_pipes = 0;
	//
	URB* urb = NULL;
	USB_CONFIGURATION_DESCRIPTOR* configuration_descriptor = NULL;
	//
	NTSTATUS status;
	USBD_INTERFACE_LIST_ENTRY interface_list[1 + 1/*I[*/];
	USB_INTERFACE_DESCRIPTOR* interface_descriptor;
	USBD_INTERFACE_INFORMATION* interface_information;

	KdPrint(("set_configuration\n"));

	/* RtBM[VfBXNv^擾܂B */
	configuration_descriptor = get_configuration_descriptor(usbd, 0);
	if(!configuration_descriptor) {
		KdPrint(("get_configuration_descriptor failed\n"));
		goto L_EXIT;
	}

	/* SET_CONFIGURATION̏B */
	memset(interface_list, 0, sizeof interface_list); /* Kv!! */
	interface_list[0].InterfaceDescriptor = USBD_ParseConfigurationDescriptorEx(
		configuration_descriptor,	/* ConfigurationDescriptor */
		configuration_descriptor,	/* StartPosition */
		-1,				/* InterfaceNumber */
		-1,				/* AlternateSetting */
		-1,				/* InterfaceClass */
		-1,				/* InterfaceSubClass */
		-1);				/* InterfaceProtocol */
	if(!interface_list[0].InterfaceDescriptor) {
		KdPrint(("USBD_ParseConfigurationDescriptorEx failed\n"));
		goto L_EXIT;
	}
	urb = USBD_CreateConfigurationRequestEx(configuration_descriptor, interface_list);
	if(!urb) {
		KdPrint(("USBD_CreateConfigurationRequestEx failed\n"));
		goto L_EXIT;
	}

	/* SET_CONFIGURATION𔭍s܂B */
	status = call_usbd(usbd, urb);
	if(!NT_SUCCESS(status)) {
		KdPrint(("call_usbd failed\n"));
		goto L_EXIT;
	}
	interface_information = interface_list[0].Interface;

	/* oNIN/OUTpCv擾܂B */
	if((int)interface_information->NumberOfPipes > max_pipes) {
		KdPrint(("Number of pipes error\n"));
		goto L_EXIT;
	}
	while(num_pipes < (int)interface_information->NumberOfPipes) {
		pipes[num_pipes] = interface_information->Pipes[num_pipes];
		num_pipes++;
	}

L_EXIT:

	if(urb) {
		ExFreePool(urb);
	}
	if(configuration_descriptor) {
		ExFreePool(configuration_descriptor);
	}

	return num_pipes;
}

/****************************************************************************
 *
 ****************************************************************************/

/* RtBM[V𖢑Iɖ߂܂B
 */
void
unset_configuration(DEVICE_OBJECT* usbd)
{
	URB urb;

	UsbBuildSelectConfigurationRequest(
		&urb,						/* Urb */
		sizeof(struct _URB_SELECT_CONFIGURATION),	/* Length */
		NULL);						/* ConfigurationDescriptor */
	call_usbd(usbd, &urb);
}

