/*	
 *	clipstr.h
 *
 *	[eBeBF񑀍
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sat Oct 11 12:29:17 JST 2014 Naoyuki Sawa
 *	- 쐬JnB
 *	- strtrim(),strescape(),strcompress()Aclipmisc.h,cclipstr.h,cֈړ܂B
 *	- strfreev(),strv_length(),strdup_printf(),strdup_vprintf(),strjoin(),strjoinv(),strsplit(),strsplit_set()ǉ܂B
 *	* Mon Oct 13 02:54:55 JST 2014 Naoyuki Sawa
 *	- str_has_prefix(),str_has_suffix()ǉ܂B
 *	* Sat Oct 18 18:55:59 JST 2014 Naoyuki Sawa
 *	- string_match()ǉ܂B
 *	* Thu Nov 06 00:58:25 JST 2014 Naoyuki Sawa
 *	- strreverse()ǉ܂B
 *	* Sat Nov 08 16:50:24 JST 2014 Naoyuki Sawa
 *	- strdupv()ǉ܂B
 *	* Tue Nov 11 23:26:40 JST 2014 Naoyuki Sawa
 *	- strconcat()ǉ܂B
 *	* Sat Nov 15 20:39:46 JST 2014 Naoyuki Sawa
 *	- str_has_prefix_suffix̃oOC܂B
 *	  str_has_prefix_suffix̒%r3gpĂ̂ɁA%r0`%r2ޔĂȂoOłB
 *	  ̂߂ɁAstr_has_prefix_suffixĂяoW[AsȓNĂ܂B
 *	  ̓Iɂ́Acliptcl.cTcl_GetIndex()AAhXG[ŕsIĂ܂Ă܂B
 */
#ifndef __CLIP_STR_H__
#define __CLIP_STR_H__

/*****************************************************************************
 *	g
 *****************************************************************************/

/* w肵菜B
 * [in]
 *	s		̕
 *	mode		ʒu̎w	0 [ɂw蕶
 *						1 [ɂw蕶
 *						2 E[ɂw蕶
 *						3 ɂSĂ̎w蕶
 *	reject		镶		NULLw肵ꍇ́A󔒕
 * [out]
 *	߂l		ʂ̕		ĂяoɂāAfree()ŊJĂ
 * [note]
 *	- HSPstrtrim֐̎dlɕ킢܂B
 * [gp]
 *	const char src[] = "   - - - Sample  String - - -   ";
 *	char* dst;
 *	dst = strtrim(src, 0, NULL); puts(dst); free(dst); //   "- - - Sample  String - - -"
 *	dst = strtrim(src, 1, NULL); puts(dst); free(dst); //   "- - - Sample  String - - -   "
 *	dst = strtrim(src, 2, NULL); puts(dst); free(dst); //"   - - - Sample  String - - -"
 *	dst = strtrim(src, 3, NULL); puts(dst); free(dst); //       "---SampleString---"
 *	dst = strtrim(src, 0, " -"); puts(dst); free(dst); //         "Sample  String"
 *	dst = strtrim(src, 1, " -"); puts(dst); free(dst); //         "Sample  String - - -   "
 *	dst = strtrim(src, 2, " -"); puts(dst); free(dst); //"   - - - Sample  String"
 *	dst = strtrim(src, 3, " -"); puts(dst); free(dst); //          "SampleString"
 */
char* strtrim(const char* s, int mode, const char* reject);

/*****************************************************************************
 *	GXP[v
 *****************************************************************************/

/* ̃oCif[^A󎚉\ȕɃGXP[v܂B
 * [in]
 *	s		̃oCif[^
 *	need_escape	AvP[V`̃GXP[vKvȕ	(NULL=)
 *			
 * [out]
 *	߂l		GXP[vꂽ	ĂяoɂāAfree()ŊJĂB
 * [note]
 *	- ֐̖ÓAGLibg_strescape܂B
 *	  ֐dlg_strescapeƊS݊ł͂܂B(need_escapeƎgłB)
 *	- ֐́Aȉ̏s܂B
 *	  1. C̃GXP[vV[PXɑ镶AGXP[vV[PXɕϊB
 *	  2. AvP[V`̃GXP[vKvȕ̑OɁA'\'ǉB
 *	  3. 󎚉\łȂA'\'+8i\L3ɕϊB
 *	  4. ȊÓ̕Â܂܏o͂B
 * [gp]
 *	- C̕GXP[v
 *	  dst=strescape(src,NULL);
 *	- Tcl̕GXP[v(Tcl̃\[XTcl_ConvertElement()ɑ)
 *	  dst=strescape(src," $;[]{}");
 *	- Tcl̃Xg쐬(Tcl̃\[XTcl_Merge()ɑ)
 *	  *dst='\0';
 *	  for(i=0;i<argc;i++){
 *	    char*tmp=strescape(argv[i]," $;[]{}");
 *	    if(i){strcat(dst," ");}
 *	    strcat(dst,(*tmp)?tmp:"{}");//vf{}ɒuĖIɊi[
 *	    free(tmp);
 *	  }
 */
char* strescape(const char* s, const char* need_escape);

/* GXP[vꂽÃoCif[^ɕ܂B
 * [in]
 *	s		GXP[vꂽ
 *	delim		s̏I镶Zbgw肵܂B	NULLw肳ꂽꍇ͕s̏I[܂ŏs܂B
 *									endptrƑgݍ킹Ďgp邱Ƃz肵Ă܂Aendptrw肹delim ̂ݎw肷邱Ƃ\łB
 *	endptr		s̏Iʒui[܂B	NULLw肳ꂽꍇ͊i[܂B
 *									delim Ƒgݍ킹Ďgp邱Ƃz肵Ă܂Adelim w肹endptr̂ݎw肷邱Ƃ\łB
 * [out]
 *	߂l		̃oCif[^
 * [note]
 *	- ֐̖ÓAGLibg_strcompress܂B
 *	  ֐dlg_strcompressƊS݊ł͂܂B(endptr,delimƎgłB)
 *	- ֐́Aȉ̏s܂B
 *	  1. sꕶ擾AcƂBcɂĈȉ2.`4.̂ꂩ̏sB
 *	  2. c'\0',,delim(w肳Ă)̕ZbgɈvꍇ:
 *	    2-1. endptr(w肳Ă)ɕc̈ʒui[B
 *	    2-2. o͕'\0'ŏI[B
 *	    2-3. IB
 *	  3. c'\'łꍇAc̎̕擾Aȉ3-1.`3-5.̂ꂩ̏sB
 *	    3-1. '\'nulꍇA'\'jď2.sIB('\'nul̂'GXP[vꂽ'ƂĕsȀI[𒴂Ȃ悤ɍŒ̑΍sƂɂ)
 *	    3-2. '\'ɑC̃GXP[vV[PXA1ɕϊďo͂B
 *	    3-3. '\'ɑ8i\L(1`3)A1ɕϊďo͂B
 *	    3-4. '\'ɑ16i\L(1`)A1ɕϊďo͂B
 *	    3-5. '\'ɑsA'\'ƍ폜B(CvvZbT,Python,Tcl,sed,awk,bash,c̍špɑ)
 *	    3-6. '\'ɑȊO̕A'\'폜ĕ݂̂ɕϊďo͂B('AvP[V`̃GXP[vKvȕ'܂)
 *	  4. c2.`3.ȊOłꍇAȉ4-1.̏sB
 *	    4-1. ĉ܂܏o͂B
 *	- endptr,deliḿAuGXP[vĂȂ̕𕪊ƌȂXgAvf𕜌Ď擾v߂Ɏgp܂B
 *	  Ƃ΁ATcl̃Xgvf𕜌Ď擾ꍇɎgp܂B
 *	  C\[X̒Pȕ̏ꍇ͍lKv͂܂̂ŁAendptr,delimNULLw肵ĂB
 * [gp]
 *	- C̕GXP[v
 *	  dst=strcompress(src,NULL,NULL);
 *	- Tcl̃XgB(ɂTclł{}ł̃GXP[vlKv邪AȒPɂ邽߈ȉ̗ł͏ȗB)
 *	  for(;;){
 *	    src+=strspn(src,"\t\n\v\f\r ");                  //sf~^΂B
 *	    if(!*src){break;}                                //XgI[ȂΏIB
 *	    argv[argc++]=strcompress(src,&src,"\t\n\v\f\r ");//vf𕜌Ď擾B
 *	  }
 */
char* strcompress(const char* s, char** endptr, const char* delim);

/*****************************************************************************
 *	|C^z
 *****************************************************************************/

/* |C^źAJB
 * [in]
 *	str_array		|C^zB	zNULL|C^vfŏI[Ă邱ƁB(main()֐argv[]ƓlłB)
 *							str_arraŷNULL|C^w肵ꍇ́A֐͉ɏԂB
 * [note]
 *	- GLibg_strfreev()Ɍ݊łB
 */
void strfreev(char** str_array);

/* |C^źAvf擾B
 * [in]
 *	str_array		|C^zB	zNULL|C^vfŏI[Ă邱ƁB(main()֐argv[]ƓlłB)
 * [out]
 *	߂l			vfB		I[NULL|C^vf́AvfɊ܂߂ȂB
 * [note]
 *	- GLibg_strv_length()Ɍ݊łB
 */
size_t strv_length(char** str_array);

/* |C^źA'['쐬B
 * [in]
 *	str_array		A|C^zB	zNULL|C^vfŏI[Ă邱ƁB(main()֐argv[]ƓlłB)
 * [out]
 *	߂l			A|C^zB	ĂяoɂāAstrfreev()gĊJB
 * [note]
 *	- GLibg_strdupv()Ɍ݊łBAȉ̈_ɂāA݊łB
 *	- GLibg_strdupv()́Astr_arrayNULL|C^w肷邱ƂłAg_strdupv()͉NULL|C^Ԃ܂B
 *	  ɑ΂́Astr_arrayNULL|C^w肷邱Ƃł܂Bw肵ꍇ́AsȓƂȂ܂B
 *	  GLibg_strdupv()́AƎg_strdup()NULL|C^wł邱ƂɕāAg_strdupv()NULL|C^wƂĂ̂Ǝv܂A
 *	  g_strdup()g_strdupv()̈NULL|C^wł邱Ƃ́AăoOhȂ肪悤Ɏv܂B
 *	  ]ēł́AWIstrdup()ƓlɁANULL|C^wsƂ邱Ƃɂ܂B
 */
char** strdupv(char** str_array);

/****************************************************************************
 *	
 ****************************************************************************/

/* asprintf()ƓlA߂lƂ_قȂB
 * [in]
 *	fmt			B
 *	...			ψB
 * [out]
 *	߂l			B		ĂяoɂāAgpIɁAfree()ŊJ邱ƁB
 * [note]
 *	- GLibg_strdup_printf()Ɍ݊łB
 */
char* strdup_printf(const char* fmt, ...);

/* vasprintf()ƓlA߂lƂ_قȂB
 * [in]
 *	fmt			B
 *	ap			ψB
 * [out]
 *	߂l			B		ĂяoɂāAgpIɁAfree()ŊJ邱ƁB
 * [note]
 *	- GLibg_strdup_vprintf() Ɍ݊łB
 */
char* strdup_vprintf(const char* fmt, va_list ap);

/*****************************************************************************
 *	A
 *****************************************************************************/

/* ̕A̕ɘAB
 * [in]
 *	s, ...			̕B		NULL|C^ŏI[邱ƁB
 * [out]
 *	߂l			B		ĂяoɂāAgpIɁAfree()ŊJ邱ƁB
 * [note]
 *	- GLibg_strconcat()Ɍ݊łB
 *	- g_strconcat()̎dlł́Aŏ̕śuthe first string to add, which must not be NULLvƂȂĂ邪A
 *	  ֐́Aŏ̕sNULLƂȀꍇA֐͋󕶎("")Ԃ悤ɂB
 *	  ̕Astrjoin()strjoinv()ƑΏېLA֗ł邵AՂƎvłB
 */
char* strconcat(const char* s, ...);

/* ̕A̕ɘAB
 * [in]
 *	separator		Zp[^B		NULL|C^w肷ƁA""w肵̂ƓƌȂB
 *	...			̕B		NULL|C^ŏI[邱ƁB
 * [out]
 *	߂l			B		ĂяoɂāAgpIɁAfree()ŊJ邱ƁB
 * [note]
 *	- GLibg_strjoin()Ɍ݊łB
 */
char* strjoin(const char* separator, ...);

/* |C^zA̕ɘAB
 * [in]
 *	separator		Zp[^B		NULL|C^w肷ƁA""w肵̂ƓƌȂB
 *	str_array		|C^z	zNULL|C^vfŏI[Ă邱ƁB(main()֐argv[]ƓlłB)
 * [out]
 *	߂l			B		ĂяoɂāAgpIɁAfree()ŊJ邱ƁB
 * [note]
 *	- GLibg_strjoinv()Ɍ݊łB
 */
char* strjoinv(const char* separator, char** str_array);

/****************************************************************************
 *	
 ****************************************************************************/

/* Af~^pĕB
 * [in]
 *	s			镶B
 *	delimiter		f~^B	""͎wsB
 *	max_tokens		ő啪B		1̒lw肷ƁAƌȂB
 * [out]
 *	߂l			|C^zB	ĂяoɂāAgpIɁAstrfreev()ŊJ邱ƁB
 * [note]
 *	- GLibg_strsplit()Ɍ݊łB
 */
char** strsplit(const char* s, const char* delimiter, int max_tokens);

/* Af~^ZbgpĕB
 * [in]
 *	s			镶B
 *	delimiters		f~^ZbgB	""w\B
 *	max_tokens		ő啪B		1̒lw肷ƁAƌȂB
 * [out]
 *	߂l			|C^zB	ĂяoɂāAgpIɁAstrfreev()ŊJ邱ƁB
 * [note]
 *	- GLibg_strsplit_set()Ɍ݊łB
 */
char** strsplit_set(const char* s, const char* delimiters, int max_tokens);

/*****************************************************************************
 *	r
 *****************************************************************************/

/* s1̃vtBNXAs2Ɉv邩ׂB
 * [in]
 *	s1			B
 *	s2			vtBNXB		""w\B
 * [out]
 *	߂l			vȂ0ԂB
 *				v0ȊOԂB
 * [note]
 *	- GLibg_str_has_prefix()Ɍ݊łB
 */
int str_has_prefix(const char* s1, const char* s2);

/* s1̃TtBbNXAs2Ɉv邩ׂB
 * [in]
 *	s1			B
 *	s2			TtBbNXB		""w\B
 * [out]
 *	߂l			vȂ0ԂB
 *				v0ȊOԂB
 * [note]
 *	- GLibg_str_has_suffix()Ɍ݊łB
 */
int str_has_suffix(const char* s1, const char* s2);

/* Tcl6.7́ustring matchvɏAp^[rs܂B
 * [in,out]
 *	patstrɃ}b`邩ǂm߂܂B}b`Ȃ1AȂȂ0Ԃ܂B
 *	2̏̕ƍł́ApatɎ̎gʂȃV[PXāA}b`e͓łȂ΂Ȃ܂B
 *	*       󕶎܂str̂镶V[PXɃ}b`܂B
 *	?       str̂PƂ̕Ƀ}b`܂B
 *	[chars] charɗ^ꂽZbĝǂꂩ̕Ƀ}b`܂B
 *	        x-y`̃V[PXcharsɌƁAxy܂܂xẙԂ̂ꂩ̕Ƀ}b`܂B
 *	        [A-z]'_'Ƀ}b`܂B('_''Z''a'̊Ԃɂ̂)
 *	\x      P̕xɃ}b`܂Bpat̕*?[]\̓ʂȉ߂h~@񋟂܂B
 * [note]
 *	- Tcl6.7́ustring matchvƁAʓIȐK\̑_ƂāAȉɒӂĂ:
 *	  ʓIȐK\ł́A'['̒']'͕NXANẌꕶƌȂ邪ATcl6.7string matchɂ͂̓ᏈB
 *	  ʓIȐK\ł́ANX̒ł'\'ɂꕶ̃GXP[vGXP[vV[PXg邪ATcl6.7string matchł͎gȂB
 *	  s'^',s'$',NX'^',O[v'(',')',I'|'Ȃǂ͗L܂BK\ƂVBALikeɋ߂łB
 */
int string_match(const char* pat, const char* str);

/*****************************************************************************
 *	]
 *****************************************************************************/

/* 𔽓]B
 * [in]
 *	s		]镶B
 * [out]
 *	߂l		ŝ܂ܕԂB
 * [note]
 *	- GLibg_strreverse()Ɍ݊łB
 */
char* strreverse(char* s);

#endif/*__CLIP_STR_H__*/
