
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		rnd8
		.global		rnd16
		.global		rnd32
		.global		rnd8_range
		.global		rnd16_range
		.global		rnd32_range
		;//-------------------------------------;//
rnd8:
		call		rnd16			;// %r10 := y = rnd32(seed) >> 12
		sra		%r10, 4			;//           = rnd16(seed) >> 4
		ret.d
		ld.ub		%r10, %r10		;// return (unsigned char)y		*delay*
		;//-------------------------------------;//
rnd16:
		call		rnd32			;// %r10 := y = rnd32(seed) >> 8
		sra		%r10, 8
		ret.d
		ld.uh		%r10, %r10		;// return (unsigned short)y		*delay*
		;//-------------------------------------;//
rnd32:
		ld.w		%r10, [%r12]		;// %r10 := y = *seed
	ext	0x125a		; 		xld.w		%r11, 2463534242	;// %r11 := MAGIC_NUMBER		*anti-interlock*
	ext	0x1a32
	ld.w	%r11,0x22
		cmp		%r10, 0			;// if(y == 0) {
		jrne		2			;//    y  = MAGIC_NUMBER
		 ld.w		%r10, %r11		;// }
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
	sll	%r9,0x8		; 		xsll		%r9, 13			;// %r9  :=      (y << 13)
	sll	%r9,0x5
		xor		%r10, %r9		;// %r10 := y ^= (y << 13)
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
	srl	%r9,0x8		; 		xsrl		%r9, 17			;// %r9  :=      (y >> 17)
	srl	%r9,0x8
	srl	%r9,0x1
		xor		%r10, %r9		;// %r10 := y ^= (y >> 17)
		;//
		ld.w		%r9, %r10		;// %r9  :=       y
	sll	%r9,0x5		; 		xsll		%r9, 5			;// %r9  :=      (y <<  5)
		xor		%r10, %r9		;// %r10 := y ^= (y <<  5)
		;//
		cmp		%r10, %r11		;// if(y == MAGIC_NUMBER) {
		jrne		2			;//    y  = 0
		 ld.w		%r10, 0			;// }
		;//
		ld.w		[%r12], %r10		;// *seed = y
		ret					;// return  y
		;//-------------------------------------;//
rnd8_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd8			;// %r10 :=            rnd8(seed)				AZuł rnd8 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
	ext	__modsi3@rm	; 		xcall.d		__modsi3		;// %r10 :=            rnd8(seed) %           (b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
	call.d	__modsi3@rl
		ld.w		%r12, %r10		;// %r12 :=            rnd8(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 :=            rnd8(seed) %           (b - a) + a	*delay*
		;//-------------------------------------;//
rnd16_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd16			;// %r10 :=           rnd16(seed)				AZułrnd16 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
	ext	__modsi3@rm	; 		xcall.d		__modsi3		;// %r10 :=           rnd16(seed) %           (b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
	call.d	__modsi3@rl
		ld.w		%r12, %r10		;// %r12 :=           rnd16(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 :=           rnd16(seed) %           (b - a) + a	*delay*
		;//-------------------------------------;//
rnd32_range:
		ld.w		%r15, %r13		;// %r15 :=                                             a
		ld.w		%r13, %r14		;// %r13 :=                                    b
		call.d		rnd32			;// %r10 :=           rnd32(seed)				AZułrnd32 %r9,%r10,%r11,%psr ȊOj󂵂܂B
		sub		%r13, %r15		;// %r13 :=                                   (b - a)		*delay*
		;//
	ext	__umodsi3@rm	; 		xcall.d		__umodsi3		;// %r10 := (unsigned)rnd32(seed) % (unsigned)(b - a)		CLiPł__modsi3 %r9,%r10,%alr,%ahr,%psr ȊOj󂵂܂B(clipidiv.s Q)
	call.d	__umodsi3@rl
		ld.w		%r12, %r10		;// %r12 :=           rnd32(seed)				*delay*
		;//
		ret.d
		add		%r10, %r15		;// %r10 := (unsigned)rnd32(seed) % (unsigned)(b - a) + a	*delay*

; NO_APP
	.code
	.align	1
	.global	shuffle
shuffle:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r1,%r13
	ld.w	%r2,%r14
	ld.w	%r3,%r15
	ld.w	%r0,%r12
	cmp	%r1,0x1		; 	xcmp	%r1,1
	jrle	__LX72		; 	xjrle	__L72
__LX73:				; __L73:
	ld.w	%r12,%r3
	call	rnd32		; 	xcall	rnd32
	ld.w	%r12,%r10
	ld.w	%r13,%r1
	ext	__umodsi3@rm	; 	xcall	__umodsi3
	call	__umodsi3@rl
	mlt.w	%r10,%r2
	ld.w	%r12,%r0
	ld.w	%r4,%alr
	add	%r12,%r4
	ld.w	%r13,0x0
	cmp	%r13,%r2
	jrge	__LX75		; 	xjrge	__L75
__LX77:				; __L77:
	ld.ub	%r11,[%r0]	; 	xld.ub	%r11,[%r0]
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	ld.b	[%r0],%r10	; 	xld.b	[%r0],%r10
	ld.b	[%r12],%r11	; 	xld.b	[%r12],%r11
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	add	%r12,0x1	; 	xadd	%r12,%r12,1
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	cmp	%r13,%r2
	jrlt	__LX77		; 	xjrlt	__L77
__LX75:				; __L75:
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
	cmp	%r1,0x1		; 	xcmp	%r1,1
	jrgt	__LX73		; 	xjrgt	__L73
__LX72:				; __L72:
	popn	%r3
	ret
; APP
	
	.code
	.align	1
	.global	die
die:
	; as33AZúA`V{externƌȂ̂ŁA
	; Iextern錾͕Kv܂B(_def_vbuff̂)
	;//xcall pceLCDDispStop		; pceLCDDispStop(); {{2005/12/13 Naoyuki Sawa svȂ̂ō폜܂}}
	ext	_def_vbuff+0x0@h	; 	xld.w %r12, _def_vbuff		; pceLCDSetBuffer(_def_vbuff);
	ext	_def_vbuff+0x0@m
	ld.w	%r12,_def_vbuff+0x0@l
	ext	pceLCDSetBuffer@rm	; 	xcall pceLCDSetBuffer
	call	pceLCDSetBuffer@rl
	ext	pceLCDDispStart@rm	; 	xcall pceLCDDispStart		; pceLCDDispStart();
	call	pceLCDDispStart@rl
;//{{2014/12/10ύX:die()gptHg؂ւ悤ɂ܂Bڍׂ́Aclip.mk'Wed Dec 10 00:39:11 JST 2014'̃RgQƂĂB
;//{{	xld.w %r12, 0			; pceFontSetType(0);
;//2014/12/10ύX:die()gptHg؂ւ悤ɂ܂Bڍׂ́Aclip.mk'Wed Dec 10 00:39:11 JST 2014'̃RgQƂĂB
	ext	_diefont+0x0@h	; 	xld.w %r12, _diefont		; pceFontSetType(_diefont);
	ext	_diefont+0x0@m
	ld.w	%r12,_diefont+0x0@l
;//}}2014/12/10ύX:die()gptHg؂ւ悤ɂ܂Bڍׂ́Aclip.mk'Wed Dec 10 00:39:11 JST 2014'̃RgQƂĂB
	ext	pceFontSetType@rm	; 	xcall pceFontSetType
	call	pceFontSetType@rl
	ld.w	%r12,0x3	; 	xld.w %r12, 3			; pceFontSetTxColor(3);
	ext	pceFontSetTxColor@rm	; 	xcall pceFontSetTxColor
	call	pceFontSetTxColor@rl
	ld.w	%r12,0x0	; 	xld.w %r12, 0			; pceFontSetBkColor(0);
	ext	pceFontSetBkColor@rm	; 	xcall pceFontSetBkColor
	call	pceFontSetBkColor@rl
	ld.w	%r12,0x0	; 	xld.w %r12, 0			; pceFontSetPos(0, 0);
	ld.w	%r13,0x0	; 	xld.w %r13, 0
	ext	pceFontSetPos@rm	; 	xcall pceFontSetPos
	call	pceFontSetPos@rl
	ext	die_L10+0x0@h	; 	xld.w %r4, die_L10		; pceFontPrintf(fmt, ...);
	ext	die_L10+0x0@m
	ld.w	%r4,die_L10+0x0@l
	ld.w	[%sp+0x0],%r4	; 	xld.w [%sp], %r4
	ext	pceFontPrintf@rm	; 	xjp pceFontPrintf
	jp	pceFontPrintf@rl
die_L10:
	ext	pceLCDTrans@rm	; 	xcall pceLCDTrans		; pceLCDTrans();
	call	pceLCDTrans@rl
die_L20:				; for(;;) {
	ext	yield@rm	; 	xcall yield			;	yield();
	call	yield@rl
	ext	pcePadGet@rm	; 	xcall pcePadGet			;	if(pcePadGet() & TRG_SELECT) {
	call	pcePadGet@rl
	ext	0x100		; 	xand %r10, %r10, 0x4000		;
	and	%r10,0x0
	jreq	die_L30		; 	xjreq die_L30			;
	ld.w	%r12,0x1	; 	xld.w %r12, 1			;		pceAppReqExit(1);
	ext	pceAppReqExit@rm	; 	xcall pceAppReqExit		;
	call	pceAppReqExit@rl
die_L30:				;	}
	jp	die_L20		; 	xjp die_L20			; }

	.code
	.align	2
__LC0:
	.ascii	"%s(%d)\000"
; NO_APP
	.code
	.align	1
	.global	die2
die2:
;	.frame	%sp,16,$31		# vars= 0, regs= 1/0, args= 12, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x3		; 	xsub	%sp,%sp,12
	ext	__LC0+0x0@h	; 	xld.w	%r10,__LC0
	ext	__LC0+0x0@m
	ld.w	%r10,__LC0+0x0@l
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r12	; 	xld.w	[%sp+4],%r12
	ld.w	[%sp+0x2],%r13	; 	xld.w	[%sp+8],%r13
	call	die		; 	xcall	die
	add	%sp,0x3		; 	xadd	%sp,%sp,12
	ret
	.code
	.align	2
__LC1:
	.ascii	"%s(%d): %s\000"
	.code
	.align	1
	.global	die3
die3:
;	.frame	%sp,20,$31		# vars= 0, regs= 1/0, args= 16, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x4		; 	xsub	%sp,%sp,16
	ext	__LC1+0x0@h	; 	xld.w	%r10,__LC1
	ext	__LC1+0x0@m
	ld.w	%r10,__LC1+0x0@l
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r12	; 	xld.w	[%sp+4],%r12
	ld.w	[%sp+0x2],%r13	; 	xld.w	[%sp+8],%r13
	ld.w	[%sp+0x3],%r14	; 	xld.w	[%sp+12],%r14
	call	die		; 	xcall	die
	add	%sp,0x4		; 	xadd	%sp,%sp,16
	ret
	.align	1
	.global	trace
trace:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	stderr+0x0@ah	; 	xld.w	%r12,[stderr]
	ext	stderr+0x0@al
	ld.w	%r12,[%r8]
	ld.w	%r13,[%sp+0x1]	; 	xld.w	%r13,[%sp+4]
	ld.w	%r14,%sp	; 	xadd	%r14,%sp,8
	add	%r14,0x8
	ext	vfprintf@rm	; 	xcall	vfprintf
	call	vfprintf@rl
	ret
	.code
	.align	2
__LC2:
	.ascii	"clipmisc.$\000"
	.code
	.align	1
	.global	create_queue
create_queue:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	cmp	%r0,0x0
	jrge	__LX84		; 	xjrge	__L84
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x7		; 	xld.w	%r13,0x000001f7		; 503
	ld.w	%r13,0x37
	call	die2		; 	xcall	die2
__LX84:				; __L84:
	add	%r0,0x4		; 	xadd	%r0,%r0,4
	ext	0x8		; 	xadd	%r12,%r0,8
	add	%r12,%r0
	ext	malloc@rm	; 	xcall	malloc
	call	malloc@rl
	cmp	%r10,0x0
	jrne	__LX85		; 	xjrne	__L85
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x8		; 	xld.w	%r13,0x00000202		; 514
	ld.w	%r13,0x2
	call	die2		; 	xcall	die2
__LX85:				; __L85:
	ld.w	[%r10],%r0	; 	xld.w	[%r10],%r0
	ld.w	%r11,0x0
	ext	0x4		; 	xld.w	[%r10+4],%r11
	ld.w	[%r10],%r11
	popn	%r0
	ret
	.align	1
	.global	delete_queue
delete_queue:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	free@rm		; 	xcall	free
	call	free@rl
	ret
	.align	1
	.global	clear_queue
clear_queue:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,0x0
	ext	0x4		; 	xld.w	[%r12+4],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
	.global	write_queue
write_queue:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r14
	ext	0x8		; 	xadd	%r14,%r1,8
	add	%r14,%r1
	cmp	%r0,0x0
	jrge	__LX89		; 	xjrge	__L89
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x8		; 	xld.w	%r13,0x0000021f		; 543
	ld.w	%r13,0x1f
	call	die2		; 	xcall	die2
__LX89:				; __L89:
	ext	0x4		; 	xld.w	%r12,[%r1+4]
	ld.w	%r12,[%r1]
	ext	0x4		; 	xadd	%r10,%r12,4
	add	%r10,%r12
	add	%r10,%r0
	ld.w	%r11,[%r1]	; 	xld.w	%r11,[%r1]
	cmp	%r10,%r11
	jrgt	__LX90		; 	xjrgt	__L90
	ld.w	%r10,%r14
	add	%r10,%r12
	ld.b	[%r10],%r0	; 	xld.b	[%r10],%r0
	ext	0x4		; 	xld.w	%r10,[%r1+4]
	ld.w	%r10,[%r1]
	ld.w	%r15,%r14
	add	%r15,%r10
	ld.w	%r10,%r15
	ld.w	%r11,%r0
	sra	%r11,0x8	; 	xsra	%r11,8
	ext	0x1		; 	xld.b	[%r10+1],%r11
	ld.b	[%r10],%r11
	ext	0x4		; 	xld.w	%r10,[%r1+4]
	ld.w	%r10,[%r1]
	ld.w	%r15,%r14
	add	%r15,%r10
	ld.w	%r10,%r15
	ld.w	%r11,%r0
	sra	%r11,0x8	; 	xsra	%r11,16
	sra	%r11,0x8
	ext	0x2		; 	xld.b	[%r10+2],%r11
	ld.b	[%r10],%r11
	ext	0x4		; 	xld.w	%r10,[%r1+4]
	ld.w	%r10,[%r1]
	ld.w	%r15,%r14
	add	%r15,%r10
	ld.w	%r10,%r15
	ld.w	%r11,%r0
	sra	%r11,0x8	; 	xsra	%r11,24
	sra	%r11,0x8
	sra	%r11,0x8
	ext	0x3		; 	xld.b	[%r10+3],%r11
	ld.b	[%r10],%r11
	ext	0x4		; 	xld.w	%r12,[%r1+4]
	ld.w	%r12,[%r1]
	add	%r14,%r12
	ld.w	%r12,%r14
	add	%r12,0x4	; 	xadd	%r12,%r12,4
	ld.w	%r14,%r0
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0x4		; 	xld.w	%r10,[%r1+4]
	ld.w	%r10,[%r1]
	add	%r10,0x4	; 	xadd	%r10,%r10,4
	add	%r10,%r0
	ext	0x4		; 	xld.w	[%r1+4],%r10
	ld.w	[%r1],%r10
	ld.w	%r10,%r0
	jp	__LX95		; 	xjp	__L95
__LX90:				; __L90:
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
__LX95:				; __L95:
	popn	%r1
	ret
	.align	1
	.global	read_queue
read_queue:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r0,%r12
	ld.w	%r12,%r13
	ext	0x8		; 	xadd	%r3,%r0,8
	add	%r3,%r0
	cmp	%r14,0x0
	jrge	__LX97		; 	xjrge	__L97
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x8		; 	xld.w	%r13,0x00000236		; 566
	ld.w	%r13,0x36
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX97:				; __L97:
	ext	0x4		; 	xld.w	%r15,[%r0+4]
	ld.w	%r15,[%r0]
	cmp	%r15,0x0
	jreq	__LX105		; 	xjreq	__L105
	cmp	%r15,0x3	; 	xcmp	%r15,3
	jrugt	__LX99		; 	xjrugt	__L99
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x9		; 	xld.w	%r13,0x00000240		; 576
	ld.w	%r13,0x0
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX99:				; __L99:
	ld.ub	%r11,[%r3]	; 	xld.ub	%r11,[%r3]
	ext	0x9		; 	xld.ub	%r10,[%r0+9]
	ld.ub	%r10,[%r0]
	sll	%r10,0x8	; 	xsll	%r10,8
	or	%r11,%r10
	ext	0xa		; 	xld.ub	%r10,[%r0+10]
	ld.ub	%r10,[%r0]
	sll	%r10,0x8	; 	xsll	%r10,16
	sll	%r10,0x8
	or	%r11,%r10
	ext	0xb		; 	xld.ub	%r10,[%r0+11]
	ld.ub	%r10,[%r0]
	sll	%r10,0x8	; 	xsll	%r10,24
	sll	%r10,0x8
	sll	%r10,0x8
	ld.w	%r1,%r11
	or	%r1,%r10
	jrlt	__LX101		; 	xjrlt	__L101
	ext	0x4		; 	xadd	%r2,%r1,4
	add	%r2,%r1
	cmp	%r2,%r15
	jrle	__LX100		; 	xjrle	__L100
__LX101:				; __L101:
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x9		; 	xld.w	%r13,0x00000244		; 580
	ld.w	%r13,0x4
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX100:				; __L100:
	cmp	%r1,%r14
	jrle	__LX102		; 	xjrle	__L102
__LX105:				; __L105:
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
	jp	__LX104		; 	xjp	__L104
__LX102:				; __L102:
	cmp	%r12,0x0
	jreq	__LX103		; 	xjreq	__L103
	ext	0xc		; 	xadd	%r13,%r0,12
	add	%r13,%r0
	ld.w	%r14,%r1
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX103:				; __L103:
	ext	0x4		; 	xld.w	%r14,[%r0+4]
	ld.w	%r14,[%r0]
	sub	%r14,0x4	; 	xsub	%r14,%r14,4
	sub	%r14,%r1
	ext	0x4		; 	xld.w	[%r0+4],%r14
	ld.w	[%r0],%r14
	ld.w	%r12,%r3
	ld.w	%r13,%r12
	add	%r13,%r2
	ext	memmove@rm	; 	xcall	memmove
	call	memmove@rl
	ld.w	%r10,%r1
__LX104:				; __L104:
	popn	%r3
	ret
	.align	1
	.global	peek_queue
peek_queue:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x8		; 	xadd	%r10,%r12,8
	add	%r10,%r12
	ext	0x4		; 	xld.w	%r14,[%r12+4]
	ld.w	%r14,[%r12]
	cmp	%r14,0x0
	jrne	__LX107		; 	xjrne	__L107
	ld.w	%r10,%r14
	jp	__LX112		; 	xjp	__L112
__LX107:				; __L107:
	cmp	%r14,0x3	; 	xcmp	%r14,3
	jrugt	__LX108		; 	xjrugt	__L108
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x9		; 	xld.w	%r13,0x00000267		; 615
	ld.w	%r13,0x27
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX108:				; __L108:
	ld.ub	%r11,[%r10]	; 	xld.ub	%r11,[%r10]
	ext	0x9		; 	xld.ub	%r10,[%r12+9]
	ld.ub	%r10,[%r12]
	sll	%r10,0x8	; 	xsll	%r10,8
	or	%r11,%r10
	ext	0xa		; 	xld.ub	%r10,[%r12+10]
	ld.ub	%r10,[%r12]
	sll	%r10,0x8	; 	xsll	%r10,16
	sll	%r10,0x8
	or	%r11,%r10
	ext	0xb		; 	xld.ub	%r10,[%r12+11]
	ld.ub	%r10,[%r12]
	sll	%r10,0x8	; 	xsll	%r10,24
	sll	%r10,0x8
	sll	%r10,0x8
	or	%r11,%r10
	jrlt	__LX110		; 	xjrlt	__L110
	ext	0x4		; 	xadd	%r10,%r11,4
	add	%r10,%r11
	cmp	%r10,%r14
	jrle	__LX109		; 	xjrle	__L109
__LX110:				; __L110:
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0x9		; 	xld.w	%r13,0x0000026b		; 619
	ld.w	%r13,0x2b
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX109:				; __L109:
	cmp	%r13,0x0
	jreq	__LX111		; 	xjreq	__L111
	ld.w	[%r13],%r11	; 	xld.w	[%r13],%r11
__LX111:				; __L111:
	ext	0xc		; 	xadd	%r10,%r12,12
	add	%r10,%r12
__LX112:				; __L112:
	ret
	.align	1
	.global	queue_space
queue_space:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ext	0x4		; 	xld.w	%r11,[%r12+4]
	ld.w	%r11,[%r12]
	sub	%r10,%r11
	sub	%r10,0x4	; 	xsub	%r10,%r10,4
	jrge	__LX114		; 	xjrge	__L114
	ld.w	%r10,0x0
__LX114:				; __L114:
	ret
	.align	1
	.global	create_buffer
create_buffer:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	cmp	%r0,0x0
	jrge	__LX116		; 	xjrge	__L116
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0xa		; 	xld.w	%r13,0x0000028b		; 651
	ld.w	%r13,0xb
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX116:				; __L116:
	ext	0x8		; 	xadd	%r12,%r0,8
	add	%r12,%r0
	ext	malloc@rm	; 	xcall	malloc
	call	malloc@rl
	cmp	%r10,0x0
	jrne	__LX117		; 	xjrne	__L117
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0xa		; 	xld.w	%r13,0x00000291		; 657
	ld.w	%r13,0x11
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX117:				; __L117:
	ld.w	[%r10],%r0	; 	xld.w	[%r10],%r0
	ld.w	%r11,0x0
	ext	0x4		; 	xld.w	[%r10+4],%r11
	ld.w	[%r10],%r11
	popn	%r0
	ret
	.align	1
	.global	delete_buffer
delete_buffer:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	free@rm		; 	xcall	free
	call	free@rl
	ret
	.align	1
	.global	clear_buffer
clear_buffer:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,0x0
	ext	0x4		; 	xld.w	[%r12+4],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
	.global	write_buffer
write_buffer:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r14
	ext	0x8		; 	xadd	%r12,%r1,8
	add	%r12,%r1
	cmp	%r0,0x0
	jrge	__LX121		; 	xjrge	__L121
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0xa		; 	xld.w	%r13,0x000002ae		; 686
	ld.w	%r13,0x2e
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX121:				; __L121:
	ld.w	%r10,[%r1]	; 	xld.w	%r10,[%r1]
	ext	0x4		; 	xld.w	%r11,[%r1+4]
	ld.w	%r11,[%r1]
	sub	%r10,%r11
	cmp	%r0,%r10
	jrle	__LX122		; 	xjrle	__L122
	ld.w	%r0,%r10
__LX122:				; __L122:
	add	%r12,%r11
	ld.w	%r14,%r0
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0x4		; 	xld.w	%r10,[%r1+4]
	ld.w	%r10,[%r1]
	add	%r10,%r0
	ext	0x4		; 	xld.w	[%r1+4],%r10
	ld.w	[%r1],%r10
	ld.w	%r10,%r0
	popn	%r1
	ret
	.align	1
	.global	read_buffer
read_buffer:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r1,%r12
	ld.w	%r12,%r13
	ld.w	%r10,%r14
	ext	0x8		; 	xadd	%r2,%r1,8
	add	%r2,%r1
	cmp	%r10,0x0
	jrge	__LX124		; 	xjrge	__L124
	ext	__LC2+0x0@h	; 	xld.w	%r12,__LC2
	ext	__LC2+0x0@m
	ld.w	%r12,__LC2+0x0@l
	ext	0xb		; 	xld.w	%r13,0x000002c5		; 709
	ld.w	%r13,0x5
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX124:				; __L124:
	ld.w	%r0,%r10
	ext	0x4		; 	xld.w	%r10,[%r1+4]
	ld.w	%r10,[%r1]
	cmp	%r0,%r10
	jrle	__LX125		; 	xjrle	__L125
	ld.w	%r0,%r10
__LX125:				; __L125:
	cmp	%r12,0x0
	jreq	__LX126		; 	xjreq	__L126
	ld.w	%r13,%r2
	ld.w	%r14,%r0
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
__LX126:				; __L126:
	ext	0x4		; 	xld.w	%r14,[%r1+4]
	ld.w	%r14,[%r1]
	sub	%r14,%r0
	ext	0x4		; 	xld.w	[%r1+4],%r14
	ld.w	[%r1],%r14
	ld.w	%r12,%r2
	ld.w	%r13,%r12
	add	%r13,%r0
	ext	memmove@rm	; 	xcall	memmove
	call	memmove@rl
	ld.w	%r10,%r0
	popn	%r2
	ret
	.align	1
	.global	peek_buffer
peek_buffer:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	cmp	%r13,0x0
	jreq	__LX128		; 	xjreq	__L128
	ext	0x4		; 	xld.w	%r10,[%r12+4]
	ld.w	%r10,[%r12]
	ld.w	[%r13],%r10	; 	xld.w	[%r13],%r10
__LX128:				; __L128:
	ext	0x8		; 	xadd	%r10,%r12,8
	add	%r10,%r12
	ret
	.align	1
	.global	buffer_space
buffer_space:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,[%r12]	; 	xld.w	%r11,[%r12]
	ext	0x4		; 	xld.w	%r10,[%r12+4]
	ld.w	%r10,[%r12]
	sub	%r11,%r10
	ld.w	%r10,%r11
	ret
	.align	1
	.global	InitializeListHead
InitializeListHead:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x4		; 	xld.w	[%r12+4],%r12
	ld.w	[%r12],%r12
	ld.w	[%r12],%r12	; 	xld.w	[%r12],%r12
	ret
	.align	1
	.global	IsListEmpty
IsListEmpty:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,0x0
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	cmp	%r10,%r12
	jrne	__LX132		; 	xjrne	__L132
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
__LX132:				; __L132:
	ld.w	%r10,%r11
	ret
	.align	1
	.global	RemoveHeadList
RemoveHeadList:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,[%r12]	; 	xld.w	%r0,[%r12]
	ld.w	%r12,%r0
	call	RemoveEntryList	; 	xcall	RemoveEntryList
	ld.w	%r10,%r0
	popn	%r0
	ret
	.align	1
	.global	RemoveTailList
RemoveTailList:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ext	0x4		; 	xld.w	%r0,[%r12+4]
	ld.w	%r0,[%r12]
	ld.w	%r12,%r0
	call	RemoveEntryList	; 	xcall	RemoveEntryList
	ld.w	%r10,%r0
	popn	%r0
	ret
	.align	1
	.global	RemoveEntryList
RemoveEntryList:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,[%r12]	; 	xld.w	%r11,[%r12]
	ext	0x4		; 	xld.w	%r10,[%r12+4]
	ld.w	%r10,[%r12]
	ld.w	[%r10],%r11	; 	xld.w	[%r10],%r11
	ext	0x4		; 	xld.w	[%r11+4],%r10
	ld.w	[%r11],%r10
	ret
	.align	1
	.global	InsertHeadList
InsertHeadList:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ld.w	[%r13],%r10	; 	xld.w	[%r13],%r10
	ext	0x4		; 	xld.w	[%r13+4],%r12
	ld.w	[%r13],%r12
	ext	0x4		; 	xld.w	[%r10+4],%r13
	ld.w	[%r10],%r13
	ld.w	[%r12],%r13	; 	xld.w	[%r12],%r13
	ret
	.align	1
	.global	InsertTailList
InsertTailList:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x4		; 	xld.w	%r10,[%r12+4]
	ld.w	%r10,[%r12]
	ld.w	[%r13],%r12	; 	xld.w	[%r13],%r12
	ext	0x4		; 	xld.w	[%r13+4],%r10
	ld.w	[%r13],%r10
	ext	0x4		; 	xld.w	[%r12+4],%r13
	ld.w	[%r12],%r13
	ld.w	[%r10],%r13	; 	xld.w	[%r10],%r13
	ret
; APP
	
		.code
		.align		1
		.global		quick_search
quick_search:
	sub	%sp,0x100	; 		xsub		%sp, %sp, 1024			;// %sp  := tbl
		ld.w		%r4, %sp			;// %r4  := tbl
		;//---------------------------------------------;//
		cmp		%r15, 0				;// if(!len2)
		jreq		quick_search_RET0		;//   return NULL
		;//---------------------------------------------;//
		sub		%r13, %r15			;// %r13 := len1 -= len2
		jrlt		quick_search_RET0		;// if(len1 < 0) return NULL
		add		%r13, %r12			;// %r13 := lim1 = mem1 + len1
		;//---------------------------------------------;//
		ld.w		%r5, %sp			;// %r5  := ptr = tbl
		ld.w		%r6, -1				;// %r6  := -1
	ext	0x4		; 		xld.w		%r7, 256			;// %r7  := cnt = 256
	ld.w	%r7,0x0
		 ld.w		[%r5]+, %r6			;// do { *ptr++ = -1
		 sub		%r7, 1				;//      %r7  := cnt--
		jrne		-2				;// } while(cnt)
		;//---------------------------------------------;//
		ld.w		%r5, %r14			;// %r5  := ptr = mem2
		ld.w		%r6, 0				;// %r6  := i = 0
		 ld.ub		%r7, [%r5]+			;// do { %r7  :=      *ptr++
		 sla		%r7, 2				;//      %r7  :=      *ptr++ * sizeof(int)
		 add		%r7, %r4			;//      %r7  := &tbl[*ptr++]
		 ld.w		[%r7], %r6			;//               tbl[*ptr++] = i
		 add		%r6, 1				;//      %r6  := i++
		 cmp		%r6, %r15			;//
		jrne		-6				;// } while(i != len2)
		;//---------------------------------------------;//
quick_search_LOOP:						;// do {
		ld.w		%r5, %r12			;//   %r5  := tmp1 = mem1
		ld.w		%r6, %r14			;//   %r6  := tmp2 = mem2
		ld.w		%r7, %r15			;//   %r7  := i    = len2
		 ld.ub		%r10, [%r5]+			;//   do { %r10 := *tmp1++
		 ld.ub		%r11, [%r6]+			;//        %r11 := *tmp2++
		 cmp		%r10, %r11			;//        if(*tmp1++ != *tmp2++)
		 jrne		quick_search_NEXT		;//          goto NEXT
		 sub		%r7, 1				;//        %r7  := i--
		jrne		-5				;//   } while(i)
		jp.d		quick_search_RET		;//   return mem1
		ld.w		%r10, %r12			;//   %r10 := mem1				*delay*
quick_search_NEXT:						;//
		cmp		%r12, %r13			;//   if(mem1 == lim1)
		jreq		quick_search_RET0		;//     return NULL
		add		%r12, %r15			;//   %r12 :=              mem1 += len2
		ld.ub		%r5, [%r12]			;//   %r5  :=             *mem1
		sla		%r5, 2				;//   %r5  :=             *mem1 * sizeof(int)	!INTERLOCK!
		add		%r5, %r4			;//   %r5  :=        &tbl[*mem1]
		ld.w		%r5, [%r5]			;//   %r5  :=         tbl[*mem1]
		sub		%r12, %r5			;//   %r12 := mem1 -= tbl[*mem1]		!INTERLOCK!
		cmp		%r12, %r13			;//
		jrle		quick_search_LOOP		;// } while(mem1 <= lim1)
		;//---------------------------------------------;//
quick_search_RET0:
		ld.w		%r10, 0
quick_search_RET:
	add	%sp,0x100	; 		xadd		%sp, %sp, 1024
		ret

; NO_APP
	.align	1
	.global	VERY_simple_RegEx_matching
VERY_simple_RegEx_matching:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r1,%r12
	ld.w	%r0,%r13
	ld.b	%r10,[%r1]	; 	xld.b	%r10,[%r1]
	ext	0x1		; 	xcmp	%r10,94
	cmp	%r10,0x1e
	jrne	__LX140		; 	xjrne	__L140
	ext	0x1		; 	xadd	%r12,%r1,1
	add	%r12,%r1
	call	matchhere	; 	xcall	matchhere
	jp	__LX145		; 	xjp	__L145
__LX140:				; __L140:
	ld.w	%r12,%r1
	ld.w	%r13,%r0
	call	matchhere	; 	xcall	matchhere
	cmp	%r10,0x0
	jrne	__LX142		; 	xjrne	__L142
	ld.b	%r10,[%r0]	; 	xld.b	%r10,[%r0]
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	cmp	%r10,0x0
	jrne	__LX140		; 	xjrne	__L140
	jp	__LX145		; 	xjp	__L145
__LX142:				; __L142:
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
__LX145:				; __L145:
	popn	%r1
	ret
	.align	1
matchhere:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,%r12
	ld.w	%r14,%r13
__LX153:				; __L153:
	ld.b	%r12,[%r11]	; 	xld.b	%r12,[%r11]
	cmp	%r12,0x0
	jrne	__LX147		; 	xjrne	__L147
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	jp	__LX154		; 	xjp	__L154
__LX147:				; __L147:
	ext	0x1		; 	xld.b	%r10,[%r11+1]
	ld.b	%r10,[%r11]
	ext	0x0		; 	xcmp	%r10,42
	cmp	%r10,0x2a
	jrne	__LX148		; 	xjrne	__L148
	ext	0x2		; 	xadd	%r13,%r11,2
	add	%r13,%r11
	call	matchstar	; 	xcall	matchstar
	jp	__LX154		; 	xjp	__L154
__LX148:				; __L148:
	ext	0x0		; 	xcmp	%r12,36
	cmp	%r12,0x24
	jrne	__LX149		; 	xjrne	__L149
	cmp	%r10,0x0
	jrne	__LX149		; 	xjrne	__L149
	ld.w	%r11,%r10
	ld.b	%r10,[%r14]	; 	xld.b	%r10,[%r14]
	cmp	%r10,0x0
	jrne	__LX150		; 	xjrne	__L150
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
__LX150:				; __L150:
	ld.w	%r10,%r11
	jp	__LX154		; 	xjp	__L154
__LX149:				; __L149:
	ld.b	%r12,[%r14]	; 	xld.b	%r12,[%r14]
	cmp	%r12,0x0
	jreq	__LX151		; 	xjreq	__L151
	ld.b	%r10,[%r11]	; 	xld.b	%r10,[%r11]
	ext	0x0		; 	xcmp	%r10,46
	cmp	%r10,0x2e
	jreq	__LX152		; 	xjreq	__L152
	cmp	%r10,%r12
	jrne	__LX151		; 	xjrne	__L151
__LX152:				; __L152:
	add	%r11,0x1	; 	xadd	%r11,%r11,1
	add	%r14,0x1	; 	xadd	%r14,%r14,1
	jp	__LX153		; 	xjp	__L153
__LX151:				; __L151:
	ld.w	%r10,0x0
__LX154:				; __L154:
	ret
	.align	1
matchstar:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r1,%r12
	ld.w	%r2,%r13
	ld.w	%r0,%r14
__LX156:				; __L156:
	ld.w	%r12,%r2
	ld.w	%r13,%r0
	call	matchhere	; 	xcall	matchhere
	cmp	%r10,0x0
	jreq	__LX158		; 	xjreq	__L158
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	jp	__LX162		; 	xjp	__L162
__LX158:				; __L158:
	ld.b	%r11,[%r0]	; 	xld.b	%r11,[%r0]
	cmp	%r11,0x0
	jreq	__LX157		; 	xjreq	__L157
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	cmp	%r11,%r1
	jreq	__LX156		; 	xjreq	__L156
	ext	0x0		; 	xcmp	%r1,46
	cmp	%r1,0x2e
	jreq	__LX156		; 	xjreq	__L156
__LX157:				; __L157:
__LX162:				; __L162:
	popn	%r2
	ret
; APP
	
		.align		1
		.global		minimum_mask_greater_than_or_equal_to
		.global		random_value_less_than_or_equal_to
		;//-----------------------------------------------------;//
minimum_mask_greater_than_or_equal_to:
		;//							;// %r12  := x     
		ld.w		%r10, 0					;// %r10  := y = 0             
		;//							;// do {                                       
		cmp		%r10, %r12				;//     %psr[C] := c = (y < x) ? 1 : 0             
		jrult.d		-1					;//                                
		adc		%r10, %r10				;//     %psr[C] := y[31], %r10 := (y[30:0]<<1) | c 		*delay*
		;//							;// } while(c == 1)  
		adc		%r10, %r8				;// %r10 := (y[30:0]<<1) | y[31] 
		ret.d							;// return   y[31:0]
		rr		%r10, 1					;// %r10 :=  y[31:0]						*delay*
		;//-----------------------------------------------------;//
random_value_less_than_or_equal_to:
		pushn		%r3
		ld.w		%r0, %r12				;// %r0  := x
		ld.w		%r1, %r13				;// %r1  := generator
		call.d		minimum_mask_greater_than_or_equal_to	;// %r10 := mask = minimum_mask_greater_than_or_equal_to(x)
		ld.w		%r2, %r14				;// %r2  := param						*delay*
		ld.w		%r3, %r10				;// %r3  := mask
		;//							;// do {
		call.d		%r1					;//   %r10 := y = (*generator)(param)
		 ld.w		%r12, %r2				;//   %r12 :=                  param				*delay*
		 and		%r10, %r3				;//   %r10 := y &= mask
		 cmp		%r10, %r0				;// } while(y > x)
		jrugt		-4
		popn		%r3
		ret
		;//-----------------------------------------------------;//


