/*	
 *	clipcp8.h
 *
 *	P/ECE CHIP-8 Interpreter
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Mar 18 21:17:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_CP8_H__
#define __CLIP_CP8_H__

/****************************************************************************
 *
 ****************************************************************************/

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define CHIP8_TRACE

/********** ȍ~͏Ȃł **********/

#ifdef CHIP8_TRACE
#define CHIP8TRACE	TRACE
#else /*CHIP8_TRACE*/
#define CHIP8TRACE	1 ? ((void)0) : TRACE
#endif /*CHIP8_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	    RCA COSMAC VIP FrontView    
 *	
 *	@@@@@@@@@@@@@@
 *	@@@@@@@@@@@@@
 *	@@@@@@@@ qb` @
 *	@@@@@
 *	@@@@@PQRb
 *	@@@@@STUc
 *	@@@@@VWXd
 *	@@@@@`Oae
 *	@@@@@
 *	
 */

#define CHIP8_MEM_SIZE		(1 << 12)		/* CTCY */
#define CHIP8_MEM_MASK		(CHIP8_MEM_SIZE - 1)	/* CAhX}XN */

/* tHgf[^zuAhX́ACHIP-8̎dlɋK肳Ă܂B
 * tHgf[^́A0x000`0x1ff͈̔͂ŁACӂ̃AhXɔzu\łB
 * zuAhXmĂ̂́AuFX29: LD LF,VXvuFX30: LD HF,VXv߂łB
 */
#define CHIP8_FONT4x5_ADDRESS	0x100			/* 0x100`0x14f: 4x5sNZtHg]AhX  ( 5*16= 80oCg) */
#define CHIP8_FONT8x10_ADDRESS	0x150			/* 0x150`0x1ef: 8x10sNZtHg]AhX (10*16=160oCg) */

#define CHIP8_RESET_VECTOR	0x200			/* ZbgxN^ */

#define CHIP8_PROGRAM_ADDRESS	CHIP8_RESET_VECTOR			/* vO[hAhX */
#define CHIP8_PROGRAM_SIZE	(CHIP8_MEM_SIZE - CHIP8_PROGRAM_ADDRESS)/* vOőTCY */

/* CHIP8.mode=0(CHIP-8݊OtBbN[h) */
#define CHIP8_SCRLO_W		64			/* sNZ */
#define CHIP8_SCRLO_X_MASK	(CHIP8_SCRLO_W - 1)	/* W}XN */
#define CHIP8_SCRLO_H		32			/* csNZ */
#define CHIP8_SCRLO_Y_MASK	(CHIP8_SCRLO_H - 1)	/* cW}XN */

/* CHIP8.mode=1(SCHIPgOtBbN[h) */
#define CHIP8_SCRHI_W		128			/* sNZ */
#define CHIP8_SCRHI_X_MASK	(CHIP8_SCRHI_W - 1)	/* W}XN */
#define CHIP8_SCRHI_H		64			/* csNZ */
#define CHIP8_SCRHI_Y_MASK	(CHIP8_SCRHI_H - 1)	/* cW}XN */

#define CHIP8_SCR_W		CHIP8_SCRHI_W		/* ʃobt@sNZ */
#define CHIP8_SCR_H		CHIP8_SCRHI_H		/* ʃobt@csNZ */
#define CHIP8_SCR_SIZE		(CHIP8_SCR_W * CHIP8_SCR_H)	/* ʃobt@TCY */

/*
 *	CHIP-8RA
 */
typedef struct _CHIP8 {
	/*===== WX^ =====*/
	unsigned char v[16];				/* +0x0000,0x0010: f[^WX^  : V0`VF */
	unsigned short i;				/* +0x0010,0x0002: AhXWX^: I */
	unsigned char dt;				/* +0x0012,0x0001: fBC^C} */
	unsigned char st;				/* +0x0013,0x0001: TEh^C} */
	/*=====  =====*/
	unsigned char stat;				/* +0x0014,0x0001: etO (CHIP8_*) */
	unsigned char s;				/* +0x0015,0x0001: X^bN|C^ */
	unsigned short p;				/* +0x0016,0x0002: vOJE^ */
	unsigned short key;				/* +0x0018,0x0002: L[ [0]:key0`[F]:keyF */
	unsigned short seed;				/* +0x001a,0x0002: V[h */
	unsigned char _resv1[4];			/* +0x001c,0x0004: (\) */
	unsigned short stack[16];			/* +0x0020,0x0020: X^bN */
	/*=====  =====*/
	unsigned char mem[CHIP8_MEM_SIZE];		/* +0x0040,0x1000: C */
	unsigned char scr[CHIP8_SCR_H][CHIP8_SCR_W];	/* +0x1040,0x2000: ʃobt@ */
} CHIP8;						/* =0x3040 */
#define CHIP8_SIZE					    0x3040

/* CHIP8.stat */
#define CHIP8_SCHIP	(1 << 0)	/* 0:CHIP-8mode(64x32) / 1:SCHIPmode(128x64) */
#define CHIP8_EXIT	(1 << 1)	/* EXIT߂sꂽ1ɂȂ܂ */
#define CHIP8_ILL	(1 << 2)	/* s߂sꂽ1ɂȂ܂ */

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	CXgNV֐CfNX
 */
#define CHIP8FN_(CODE, DESC)	CHIP8OP_##CODE,
enum {
#include "chip8/list.h"
};
#undef CHIP8FN_

/*
 *	CXgNV֐錾/`
 */
#define CHIP8FN_(CODE, DESC)	void chip8op_##CODE(CHIP8* chip8, unsigned short code);	/* 錾p */
#include "chip8/list.h"
#undef CHIP8FN_
#define CHIP8FN_(CODE, DESC)	void chip8op_##CODE(CHIP8* chip8, unsigned short code)	/* `p */

/*
 *	CXgNV֐/̃e[u
 */
typedef void (*CHIP8OP)(CHIP8* chip8, unsigned short code);
extern const CHIP8OP chip8_op_table[/*CHIP8OP_????*/];
extern const char* const chip8_op_name_table[/*CHIP8OP_????*/];

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* CHIP-8Zbg܂B
 * [in]
 *	chip8		CHIP8\́B
 * [note]
 *	* chip8_reset()֐́Aȉ̏s܂B
 *	- vOJE^ȊÕWX^Să[NA܂B
 *	- CƉʃobt@[NA܂B
 *	- vOJE^0x200Ԓnɏ܂B
 *	* AvP[VvȌ́A̎菇ɏ]ĂB
 *	- chip8_reset()Ăт܂B
 *	- CHIP8\̂̃C0x200Ԓn`ɃvO[h܂B
 *	- KvɉāAchip8_run()Achip8_tick()Ăт܂B
 *	  ܂AK؂ȃ^C~OŁAʃobt@ʂɔf܂B
 */
void chip8_reset(CHIP8* chip8);

/* CHIP-8s܂B
 * [in]
 *	chip8		CHIP8\́B
 *	cycle		sTCNB
 * [note]
 *	* CHIP-8߂́AS11TCNƉ肵܂B
 *	  Ȃ킿AcycleɎw肵̖߂s܂B
 *	* EXIT߂sꂽACHIP8.stat[CHIP8_EXIT]1ɃZbgAɏԂ܂B
 *	  ̌ACHIP8.stat[CHIP8_EXIT]=1̏Ԃchip8_run()ĂłAɏԂ܂B
 *	  ĊJɂ́ACHIP8.stat[CHIP8_EXIT]0ɃNAĂchip8_run()ĂłB
 *	* s߂sꂽACHIP8.stat[CHIP8_ILL]1ɃZbgAɏԂ܂B
 *	  ̌ACHIP8.stat[CHIP8_ILL]=1̏Ԃchip8_run()ĂłAɏԂ܂B
 *	  ĊJɂ́ACHIP8.stat[CHIP8_ILL]0ɃNAĂchip8_run()ĂłB
 */
void chip8_run(CHIP8* chip8, int cycle);

/* CHIP-8̓^C}JEg_E܂B
 * [in]
 *	chip8		CHIP8\́B
 *	count		JEg_EB
 * [note]
 *	* AvP[VvOAb(60/count)̕pxł̊֐ĂяoĂB
 *	  CHIP-8̃fBC^C}ƃTEh^C}́Å֐ɂĂ̂݃JEg_E܂B
 */
void chip8_tick(CHIP8* chip8, int count);

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	chip8		CHIP8\́B
 */
void chip8_dump(CHIP8* chip8);

/* CHIP-8vOt@C[h܂B
 * [in]
 *	chip8		CHIP8\́B
 *	fname		t@CB
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* chip8_load()֐̐́A̒ʂłB
 *	- t@CJ邱ƁB
 *	- t@CTCY2oCg(=1)ȏł邱ƁB
 *	- t@CTCYCHIP8_PROGRAM_SIZEoCgȉł邱ƁB
 *	- t@Cǂݍ߂邱ƁB
 *	* t@CeCHIP-8vOۂ̓eXg܂B
 *	  t@CẽeXgKvȏꍇ́Achip8_test()֐gĂB
 */
int chip8_load(CHIP8* chip8, const char* fname);

/* w肳ꂽt@CALCHIP-8vOǂׂ܂B
 * [in]
 *	fname		t@CB
 *	cycle		eXgTCNB
 *			傫Ȓlw肷قǁAmȌʂ܂B
 *			0w肷ƁAlƂȂ܂B
 * [out]
 *	߂l		LCHIP-8vOȂ΁A0Ԃ܂B
 *			Ȃ΁A̒lԂ܂B
 * [note]
 *	* chip8_test()֐̐́A̒ʂłB
 *	- chip8_load()֐̐SĖĂ邱ƁB
 *	- cycle̖߂sĂ݂āAs߂ɏoȂƁB
 *	  (cycle0w肵ꍇ̖ߎs񐔂́Alp܂B)
 *	* LCHIP-8vOłȂĂAȏ̏𖞂Ă܂ƁA
 *	  LCHIP-8vOƌȂāA0ԂĂ܂ꍇ܂B
 *	* cyclew肪傫قǁAeXgߐȂAʂ҂ł܂B
 */
int chip8_test(const char* fname, int cycle);

#ifdef PIECE
/* CHIP8s܂B(X^bNؑցE)
 * [in]
 *	chip8		CHIP8\́B
 *	cycle		sTCNB
 * [note]
 *	* chip8_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- chip8_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  chip8_run2()̓X^bN0x1000ɈڂAchip8_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAchip8_run2()̎gpɂ͏܂B
 *	  Echip8_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Echip8_run()Ă΂O֐(READ/WRITE)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Echip8_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAchip8_run2()̎gpɂ͏[ȒӂKvłB
 *	  chip8_run()gꍇɊrׂāAchip8_run2()gꍇ̌ʂ́A20%̍ƂȂ܂B
 */
void chip8_run2(CHIP8* chip8, int cycle);
#endif /*PIECE*/

#endif /*__CLIP_CP8_H__*/
