/*	
 *	clip65c.h
 *
 *	P/ECE MOS6502 Emulator ()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Jan 28 03:55:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sat Mar 12 20:02:00 JST 2005 Naoyuki Sawa
 *	- M6502CPU.spɁA&mem[0x100|SP]ێ̂łȂASP̂܂ܕێ悤ύX܂B
 *	  t@~RpQ[\tgł́ASPWraparoundɈˑvO͂قƂǂȂ̂ŁA
 *	  ̂߂ɁAM6502CPU.sp&mem[0x100|SP]ێ悤݌vĂ̂łA
 *	  ATARI VCSp̑̃Q[\tgASPWraparoundɈˑĂ܂B
 *	  dȂ̂ŁAOq̂悤ɎdlύX܂B
 *	  萳mȃG~[V̂߂̕ύXȂ̂ŁA܂œ삵Ăt@~RQ[
 *	  삵ȂȂ邱Ƃ͍l܂񂪁A쑬x͂ɒxȂ\͂܂B
 */
#ifndef __CLIP_65C_H__
#define __CLIP_65C_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* spM6502 CPU\̂łB
 *
 * [note]
 *	* nztB[h́APSR(N,Z)\܂B
 *	- nz[7:0]0ȂPSR(Z)=1AȂPSR(Z)=0łB
 *	- nz[15]܂nz[7]1ȂPSR(N)=1AȂPSR(N)=0łB
 *	* ̂悤ȎdlɂŔABIT߂̃tOωɑΉ邽߂łB
 *	- M6502 CPÛقƂǂ̖߂́A߂̎sʂPSR(N,Z)ɔf܂B
 *	  ̏邽߂ɂ́APSR(N,Z)\1bytetB[hpӂA
 *	  ߂̎sʂ̃tB[hɊi[悤ɂ΂̂łB
 *	  1bytetB[hŜ0ۂPSR(Z)𔻒肵Abit7PSR(N)𔻒肵܂B
 *	  ̕@ł́APSR(Z)=1PSR(N)=1AƂԂ\Ƃ͂ł܂B
 *	  1bytetB[hŜ0ɂ܂܁Abit71ɂ邱Ƃ͂łȂłB
 *	- قƂǂ̖߂͂łȂ̂łABIT߂ɂȂ܂B
 *	  BIT߂AWX^ƃlAndʂPSR(Z)ɔfA
 *	  l̂܂܂̒lPSR(N)ɔf܂B
 *	  ƂAWX^̒l$00Ńl$FF肷ƁA
 *	  PSR(Z)=1PSR(N)=1ƂʂL蓾̂łB
 *	  BIT߂ɑΉɂ́APSR(N,Z)\1bytetB[hł͕s[łB
 *	  ȂBIT߂̂߂ɁȂ̂قƂǂ̖߂PSR(N,Z)
 *	  xȂ͔̂ƂłB
 *	- ŁA2bytetB[hgA݂̕@l܂B
 *	  bit7:00ۂPSR(Z)𔻒f̂́AOo̕@ƓłB
 *	  ܂Abit70ۂPSR(N)𔻒f̂AOo̕@ƓłB
 *	  ɉāAbit70łĂAbit151ȂPSR(N)=1Ɣf܂B
 *	  PSR(Z)=1PSR(N)=1\ɂ́A$8000(bit14:8͔C)ŕ\ł܂B
 *	  ƂAWX^̒l$00Ńl$FFBIT߂sꍇ́A
 *	  2bytetB[h̒l$FF00ƂȂAPSR(Z)=1APSR(N)=1Ӗ܂B
 *	- bit15ɂPSR(N)=1\ĝ́ABIT߂ƁA1byte PSRlunpack݂̂łB
 *	  ȊȌꍇ́Abit7:0gAbit15:8NA܂B
 *	  1bytetB[hgꍇɊrׂāAbit15:8NA菇̒ǉ͕svłB
 *	  ߂̎sʂ̒l͕1bytelɂȂĂ͂A
 *	  Pɓ]邾bit15:8NAł邩łB
 *		ld.w %A, %data
 *		ret.d
 *		ld.w %NZ, %A		; bit7:0PSR(N,Z)ݒ肵Abit15:8NA
 *	  %NZ1bytetB[hƂĂꍇƁAS萔ōς݂܂B
 *	  ʂ1bytełȂꍇ́Ald.ubg1߂bit15:8NAł܂B
 *		ld.w [%CPU+X], %data
 *		ld.ub %NZ, %data	; bit7:0PSR(N,Z)ݒ肵Abit15:8NA
 *		ret.d
 *	  ld.ub͒xXbgɓȂ̂ŁAld.wɊrׂĂ킸ɒxȂ܂B
 *	  (2005/03/12ǋL)
 *	  }jAɂƕsłAɂld.ubxXbgɓ܂B
 */
typedef struct _M6502CPU {
	unsigned short ca;		/* + 0,2 -------C AAAAAAAA */
	unsigned short nz;		/* + 2,2 N------- NZZZZZZZ */
	unsigned char bdi;		/* + 4,1          001BDI00 */
	unsigned char v;		/* + 5,1          V------- */
	unsigned char x;		/* + 6,1          XXXXXXXX */
	unsigned char y;		/* + 7,1          YYYYYYYY */
	unsigned char* pc;		/* + 8,4 &mem[PC]          */
	unsigned char sp;		/* +12,1          SPSPSPSP */
	//				/* +13,3 (pfBO)      */
	int flags;			/* +16,4          ------IW */
	int cycle;			/* +20,4 cCycle         */
	void* read;			/* +24,4 ǂݏo[` */
	void* write;			/* +28,4 ݃[` */
} M6502CPU;				/* =32   */

/* M6502CPU.flags */
#define M6502CPU_WAI	(1 << 0)	/* WAI 0=ʏ,1=~ */
#define M6502CPU_IRQ	(1 << 1)	/* IRQۗ 0=,1=L */

/* WX^ݒEQƗp̍\̂łB
 * [note]
 *	* M6502CPU\̂́A6502̃WX^Zbĝ܂܂̍\ł͂Ȃ̂ŁA
 *	  vO烌WX^ݒE擾ꍇɁA∵Â炢łB
 *	  ̂܂܂̒lŐݒE擾ł悤AM6502REG\̂pӂ܂B
 *	  m6502reg_put()gāAWX^lݒ肵܂B
 *	  m6502reg_get()gāAWX^l擾܂B
 */
typedef struct _M6502REG {
	unsigned char  a;		/* +0, 1 */
	unsigned char  x;		/* +1, 1 */
	unsigned char  y;		/* +2, 1 */
	/* ( padding ) */		/* +3, 1 */
	unsigned short pc;		/* +4, 2 */
	unsigned char  sp;		/* +6, 1 */
	unsigned char  psr;		/* +7, 1 */
} M6502REG;				/* =8 */

extern M6502CPU m6502cpu;		/* RAMɔzu */
extern unsigned char m6502mem[0x10000];	/*    SRAMɔzu */

/****************************************************************************
 *	֐
 ****************************************************************************/

int/*%data*/ m6502mem_read(/*%addr*/);	/* Pȃǂݏo[` */
void  m6502mem_write(/*%addr,%data*/);	/* Pȃ݃[` */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* CPUZbg܂B
 * [in]
 *	read		Read O֐ (NULL)
 *	write		WriteO֐ (NULL)
 * [note]
 *	* ReadO֐NULLw肷ƁAm6502mem_read()ݒ肳܂B
 *	  m6502mem_read()́APm6502mem[]ǂݏõRead֐łB
 *	* WriteO֐NULLw肷ƁAm6502mem_write()ݒ肳܂B
 *	  m6502mem_write()́APm6502mem[]֏ނ̃Write֐łB
 *	* O`̃Read/Write֐̍́A̕QƂĂB
 */
void m6502cpu_reset(void* read, void* write);

/* CPUs܂B
 * [in]
 *	cycle		sTCNB
 */
void m6502cpu_run(int cycle);

/* IRQv܂B
 * [note]
 *	* 荞݂Ăꍇ(PSR(I)=0)́AIRQ𔭍s܂B
 *	* 荞݂֎~Ăꍇ(PSR(I)=1)́AIRQv͕ۗ܂B
 *	  āA荞݂ꂽƂ(PSR(I)=0)ɁAIRQ𔭍s܂B
 */
void m6502cpu_irq();

/* NMIv܂B
 *	* NMÍAɒɔs܂B
 */
void m6502cpu_nmi();

/* 6502WX^Zbg\ɂāAeWX^̒lݒ肵܂B
 * [in]
 *	reg		ݒ肷郌WX^l̍\́B
 * [note]
 *	* M6502REG\̂̃RgQƂĂB
 */
void m6502reg_put(const M6502REG* reg);

/* 6502WX^Zbg\ɂāAeWX^̒l擾܂B
 * [in]
 *	reg		WX^l擾\́B
 * [note]
 *	* M6502REG\̂̃RgQƂĂB
 */
void m6502reg_get(M6502REG* reg);

/****************************************************************************
 *	O`̃Read/Write֐̍ɂ
 ****************************************************************************/
#if 0

O`̃Read/WritěĂяoḰAS1C33CĂяoKƌ݊ł͂܂B
O`̃Read/Writeɂ́AȂƂꕔAZuŋLqKv܂B
# ̂悤ȎdlɂȂŔÂ߂łB
# CĂяoKɏ]ƁAWX^̑ޔEA񐔂āA\傫ቺ܂B

/*--------------------------------------------------------------------------*/

O`̃Read֐̌ĂяoḰA̒ʂłB

	[in]
		%r0		ǂݏoAhX ($0000..$FFFF)
	[out]
		%r1		ǂݏof[^ ($00-$FF)
				dv
				$00-$FFȊO̒lԂĂ͂܂!!
				Ƃ΁A%r1=$FF Ԃ $r1=-1($FFFFFFFF)ԂƁA듮̌ɂȂ܂B
				̂߂ɁAWrite֐Ԃꂽl𕄍1byteɃ}XNÂ܂܎gĂ邩łB
	[use]
		%r0		js	nꂽAhXl̂܂܈ێĂB
		%r1		߂l		߂li[܂ł́A[NWX^ƂĎgp\łB
		%r2		js
		%r3		js
		%r4		js
		%r5		js
		%r6		js
		%r7		js
		%r8		js	S1C33K̃x[XWX^łB
		%r9		j		[NWX^ƂĎgp\łBext33̃XNb`WX^ł邱ƂɒӂĂB
		%r10		js
		%r11		js
		%r12		j		[NWX^ƂĎgp\łB
		%r13		j		[NWX^ƂĎgp\łB
		%r14		js
		%r15		js

/*--------------------------------------------------------------------------*/

O`̃Write֐̌ĂяoḰA̒ʂłB

	[in]
		%r0		ރAhX ($0000..$FFFF)
		%r1		ރf[^   ($00-$FF)
	[use]
		%r0		js	nꂽAhXl̂܂܈ێĂB
		%r1		js	nꂽf[^l̂܂܈ێĂB
		%r2		js
		%r3		js
		%r4		js
		%r5		js
		%r6		js
		%r7		js
		%r8		js	S1C33K̃x[XWX^łB
		%r9		j		[NWX^ƂĎgp\łBext33̃XNb`WX^ł邱ƂɒӂĂB
		%r10		js
		%r11		js
		%r12		j		[NWX^ƂĎgp\łB
		%r13		j		[NWX^ƂĎgp\łB
		%r14		js
		%r15		js

/*--------------------------------------------------------------------------*/

m6502cpu_enterĂŎsReLXg甲ƂAWX^%r4..%r15̂KvȒlm6502cpu\̂ɕۑ܂B
]āAm6502cpu_enterĂ񂾂Ƃ́A%r4..%r15͒ʏCĂяoKƓlɁAj󂵂č\܂B(%r8͏)

m6502cpu_leaveĂŎsReLXg֓ƂAWX^%r4..%r15m6502cpu\̂K؂ɃZbgAbv܂B
m6502cpu_leaveĂ񂾂Ƃ́AO`̃Read/Write֐̎dlɏ]āAWX^j󂵂Ȃ悤CĂB

/*--------------------------------------------------------------------------*/

Read/Write֐O`ꍇAׂĂAZuŋLqĂ\܂񂪁A
xƎ̊ȒPlƁAAZuC̐ܒŋLq̂ǂƎv܂B

Read/Write֐́A6502G~[V[`̎sReLXgĂ΂܂B
sReLXgł́ACyclelȂǂWX^ɕێĂ邽߁A
m6502cpu.cycleȂǂ̒lĂA6502G~[V[`ɔf܂B
ʂɁAOI/ORead/Writeł́AEFCĝ߂Cycle炷KvƎv܂B
ŁAOI/OANZXCꃋ[`֕򂷂OɁAsReLXg𔲂ĂB
Cꃋ[`ԂAĂюsReLXg֓ĂB
ڂ́Aȉ̗QƂĂB

ȉɁARead/Write֐̊O`܂B
̂悤ȃ}bvdlz肵łB

	$0000..$1FFF:	RAM
	$2000..$7FFF:	I/OWX^̈
			$2000..$3FFF: Video
			$4000..$5FFF: Audio
			$6000..$7FFF: gp
	$8000..$FFFF:	ROM

/*--------------------------------------------------------------------------*/

asm("
	.code
	.align	1
	.global	my_read
my_read:
	xcmp	%r0, 0x2000		; if(addr < 0x2000)
	xjrlt	m6502mem_read		;   read RAM
	xcmp	%r0, 0x7fff		; if(addr > 0x7fff)
	xjrgt	m6502mem_read		;   read ROM
	;-----------------------------------------------------------------------܂ł́A%r1,9,12,13ȊOjs
	xcall	m6502cpu_leave		; sReLXg𔲂܂B
	xcall.d	my_read_io		; read I/O
	ld.w	%r12, %r0		; %r12(C̑1) <- %addr *delay*
	xjp.d	m6502cpu_enter		; sReLXg֓܂B
	ld.w	%r1, %r10		; %r10(C̖߂l ) -> %data *delay*
");

int
my_read_io(int addr)
{
	int data
	if(addr <= 0x3fff) {
		data = video_read(addr);
	} else if(addr <= 0x5fff) {
		data = audio_read(addr);
	} else {
		/* I/Oڑ̈Ȃ̂ŁA$FFԂƂɂ܂B
		 * "data = -1" ƂĂ͂܂!! ߂l͕K$00..$FFłKv܂B
		 * (߂lꎟi[邽߂dataϐAunsigned charɂĂ̂ł)
		 */
		data = 0xff;
	}
	return data;
}

/*--------------------------------------------------------------------------*/

asm("
	.code
	.align	1
	.global	my_write
my_write:
	xcmp	%r0, 0x2000		; if(addr < 0x2000)
	xjrlt	m6502mem_write		;   write RAM
	;-----------------------------------------------------------------------܂ł́A%r9,12,13ȊOjs
	xcall.d	m6502cpu_leave		; sReLXg𔲂܂B
	ld.w	%r12, %r0		; %r12(C̑1) <- %addr *delay*
	xcall.d	famicom_write_io	; write I/O
	ld.w	%r13, %r1		; %r13(C̑2) <- %data *delay*
	xjp	m6502cpu_enter		; sReLXg֓܂B
");

void
my_write_io(int addr, int data)
{
	if(addr <= 0x3fff) {
		video_write(addr, data);
	} else if(addr <= 0x5fff) {
		audio_write(addr, data);
	} else {
		/** no job **/
	}
}

/*--------------------------------------------------------------------------*/

ȏ̂悤ɒ`Read/Write֐ACPUZbgɎw肵ĂB

	m6502cpu_reset(my_read, my_write);

#endif
/****************************************************************************
 *	
 ****************************************************************************/

#endif /*__CLIP_65C_H__*/
