/* P/ECE MOD Driver 쐬̂߂ɁA܂Windowsœ̂Ă݂܂B
 * ɁAP/ECEɃRo[gĂ܂B
 * 2002/11/16 00:12:00 Naoyuki Sawa
 */

#define STRICT
#include <windows.h>
#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>

/*****************************************************************************
 *	P/ECE MOD Driver
 *****************************************************************************/

#define MODBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

/* 32rbgl̃oCgXbv */
#define SWAPW(a) \
	(((a) >> 24 & 0x000000ff) | \
	 ((a) >>  8 & 0x0000ff00) | \
	 ((a) <<  8 & 0x00ff0000) | \
	 ((a) << 24 & 0xff000000))

/* 16rbgl̃oCgXbv */
#define SWAPH(a) \
	(((a) >> 8 & 0x00ff) | \
	 ((a) << 8 & 0xff00))

/************************* MODt@C` *************************/

/* MODt@Cwb_̃Tv */
typedef struct _MODSAMPLE {
	char name[22];			/* + 0,22 */
	unsigned short length;		/* +22, 2 */
	unsigned char finetune;		/* +24, 1 */
	unsigned char volume;		/* +25, 1 */
	unsigned short repofs;		/* +26, 2 */
	unsigned short replen;		/* +28, 2 */
					/* =30    */
} MODSAMPLE;

/* p^[̃[ */
typedef struct _MODROW {
	unsigned int note[4];		/* + 0,16 */
					/* =16   */
} MODROW;

/* MODt@Cwb_̃p^[ */
typedef struct _MODPATTERN {
	MODROW row[64];			/* +   0,1024 */
					/* =1024      */
} MODPATTERN;

/* MODt@ČŒ蕔iwb_j */
typedef struct _MODHEADER {
	char title[20];			/* +   0, 20 */
	MODSAMPLE sample[31];		/* +  20,930 */
	unsigned char seqlen;		/* + 950,  1 */
	unsigned char seqrep;		/* + 951,  1 */
	unsigned char sequence[128];	/* + 952,128 */
	char tag[4];			/* +1080,  4 */
					/* =1084     */
	/* MODPATTERN pattern[1`64]                 */
	/* unsigned char smpdat[1`31][2B`128KB]    */
} MODHEADER;

/************************* hCo` *************************/

typedef struct _MODCHANNEL {
	int smpno;	/* Tvԍ                */
	int period;	/* sIhl                  */
	int volume;	/* {[                  */
	int effect;	/* GtFNg                  */
	int offset;	/* TvItZbg(24.8bit) */
	int loop;	/* [vH                  */
} MODCHANNEL;

typedef struct _MODDRIVER {
	MODHEADER* header;		/* t@Cwb_AhX */
	MODPATTERN* pattern[64];	/* p^[AhX       */
	unsigned char* smpdat[31];	/* Tvf[^AhX */
	MODCHANNEL channel[4];		/* `l               */
	int speed;			/* Xs[hݒl         */
	int tick;			/* `bN(JEgAbv) */
	int seqno;			/* V[PXԍ         */
	int rowno;			/* [ԍ               */
} MODDRIVER;

/************************* ֐ *************************/

int mod_init(MODDRIVER* driver, void* data);
int mod_tick(MODDRIVER* driver, short wbuff[MODBUFLEN]);
int mod_free(MODDRIVER* driver);
static int mod_seq(MODDRIVER* driver);
static int mod_mix(MODDRIVER* driver, short wbuff[MODBUFLEN]);

int
mod_init(MODDRIVER* driver, void* data)
{
	MODHEADER* header = (MODHEADER*)data;
	int i, patno_max;
	MODSAMPLE* sample;
	MODPATTERN* pattern;
	unsigned char* smpdat;

	/* ܂[NAB */
	memset(driver, 0, sizeof(MODDRIVER));

	/* wb_AhXi[܂B */
	driver->header = header;

	/* őp^[ԍ𒲂ׂ܂B */
	patno_max = -1;
	for(i = 0; i < header->seqlen; i++) {
		if(header->sequence[i] > patno_max) {
			patno_max = header->sequence[i];
		}
	}

	/* p^[AhXi[܂B */
	pattern = (MODPATTERN*)(header + 1);
	for(i = 0; i <= patno_max; i++) {
		driver->pattern[i] = pattern;
		pattern++;
	}

	/* Tvf[^AhXi[܂B */
	smpdat = (unsigned char*)pattern;
	for(i = 0, sample = header->sample; i < 31; i++, sample++) {
		driver->smpdat[i] = smpdat;
		smpdat += SWAPH(sample->length) * 2;
	}

	/* lݒB */
	driver->speed = 6;
	driver->tick = driver->speed - 1; /* ^CAEg悤 */

	return 0;
}

int
mod_tick(MODDRIVER* driver, short wbuff[MODBUFLEN])
{
	int retval;

	/* V[PXB */
	retval = mod_seq(driver);
	if(retval != 0) return retval;

	/* ~LVOB */
	retval = mod_mix(driver, wbuff);
	if(retval != 0) return retval;

	return 0;
}

static int
mod_seq(MODDRIVER* driver)
{
	MODHEADER* header = driver->header;
	int chno, *pnote, note, smpno, period, effect;
	MODSAMPLE* sample;
	MODROW* row;
	MODCHANNEL* channel;

	/* `bNi߂܂B */
	driver->tick++;
	if(driver->tick >= driver->speed) {
		driver->tick = 0;

		/* [擾܂B
		 * * [V[PXԍ́AGtFNgɂĕύX\̂ŁA
		 *   [V[PXԍւ̌JグÍA[擾Oɍs܂B
		 */
		if(driver->rowno >= 64) {
			driver->rowno = 0;
			driver->seqno++;
		}
		if(driver->seqno >= header->seqlen) {
			if(header->seqrep < 127) { /* CR[127̏ꍇtIłI */
				driver->seqno = header->seqrep;
			} else {
				return 1; /* V[PXI */
			}
		}
		row = &driver->pattern[header->sequence[driver->seqno]]->row[driver->rowno];
		driver->rowno++; /* ̂߂Ƀ[i߂Ă܂ */

		/* e`l̃m[g܂B */
		for(chno = 0, channel = driver->channel, pnote = row->note; chno < 4; chno++, channel++, pnote++) {
			note = SWAPW(*pnote);

			/* TvԍύX܂B */
			smpno = (note >> 24 & 0xf0) | (note >> 12 & 0xf);
			if(smpno) {
				smpno--; /* m[g̃Tvԍ#1x[XȂ̂ŁA#0x[Xɕ␳ */
				sample = &header->sample[smpno];
				channel->smpno = smpno;
				channel->volume = sample->volume;
			}

			/* sIhlύX܂B */
			period = note >> 16 & 0xfff;
			if(period) {
				channel->period = period; /* Jn */
				channel->offset = 0;
				channel->loop = 0;
			}

			/* GtFNgi[܂B */
			effect = note & 0xfff;
			channel->effect = effect;
		}
	}

	/* e`l̃GtFNg܂B */
	for(chno = 0, channel = driver->channel; chno < 4; chno++, channel++) {
		effect = channel->effect;
		if(effect) {
			switch(effect & 0xf00) {
			/*---------- ɊւGtFNg ----------*/
			case 0x100: /* Slide Up */
				channel->period -= effect & 0xff;
				if(channel->period < 0) channel->period = 0;
				/* GtFNgp */
				break;
			case 0x200: /* Slide Down */
				channel->period += effect & 0xff;
				if(channel->period > 0xfff) channel->period = 0xfff;
				/* GtFNgp */
				break;
			/*---------- ʂɊւGtFNg ----------*/
			case 0x500: /* Tone Portamento + Volume Slide */
			case 0x600: /* Vibrato + Volume Slide */
			case 0xa00: /* Volume Slide */
				/* g[|^gEru[g͖ΉłB */
				if(effect & 0xf) {
					channel->volume -= effect & 0xf;
					if(channel->volume < 0) channel->volume = 0;
				} else {
					channel->volume += effect >> 4 & 0xf;
					if(channel->volume > 64) channel->volume = 64;
				}
				/* GtFNgp */
				break;
			case 0xc00: /* Set Volume */
				channel->volume = effect & 0xff;
				channel->effect = 0; /* GtFNg */
				break;
			/*---------- tʒuɊւGtFNg ----------*/
			case 0x900: /* Set Sample Offset */
				channel->offset = (effect & 0xff) << (8/*MODdl*/ + 8/*Œ菬*/);
				channel->effect = 0; /* GtFNg */
				break;
			case 0xb00: /* Position Jump */
				driver->seqno = effect & 0xff;
				driver->rowno = 0;
				channel->effect = 0; /* GtFNg */
				break;
			case 0xd00: /* Pattern Break */
				driver->seqno++;
				driver->rowno = effect & 0xff;
				channel->effect = 0; /* GtFNg */
				break;
			case 0xf00: /* Set Speed */
				if((effect & 0xff) <= 31) {
					driver->speed = effect & 0xff;
				} else {
					/* BPM(e|)ݒ͖ΉłB */
					/**/#ifdef WIN32
					/**/fprintf(stderr, "IGN-BPM\n");
					/**/#endif /*WIN32*/
				}
				channel->effect = 0; /* GtFNg */
				break;
			/*{{ΉGtFNg*/
			//case 0x000: /* Arpeggio */
			//case 0x300: /* Tone Portamento */
			//case 0x400: /* Vibrato */
			//case 0x700: /* Tremolo */
			//case 0x800: /* Set Panning Position */
			/**/#ifdef WIN32
			/**/default:
			/**/	fprintf(stderr, "IGN-EFF: %03x\n", effect);
			/**/	break;
			/**/#endif /*WIN32*/
			/*}}ΉGtFNg*/
			case 0xe00: /* Extended Effects */
				switch(effect & 0xf0) {
				/*---------- ɊւgGtFNg ----------*/
				case 0x10: /* Fine Slide Up */
					channel->period -= effect & 0xf;
					if(channel->period < 0) channel->period = 0;
					channel->effect = 0; /* GtFNg */
					break;
				case 0x20: /* Fine Slide Down */
					channel->period += effect & 0xf;
					if(channel->period > 0xfff) channel->period = 0xfff;
					channel->effect = 0; /* GtFNg */
					break;
				/*---------- ʂɊւgGtFNg ----------*/
				case 0xa0: /* Fine Volume Slide Up */
					channel->volume += effect & 0xf;
					if(channel->volume > 64) channel->volume = 64;
					channel->effect = 0; /* GtFNg */
					break;
				case 0xb0: /* Fine Volume Slide Down */
					channel->volume -= effect & 0xf;
					if(channel->volume < 0) channel->volume = 0;
					channel->effect = 0; /* GtFNg */
					break;
				/*{{ΉgGtFNg*/
				//case 0x00: /* Set Filter */
				//case 0x30: /* Glissando Control */
				//case 0x40: /* Set Vibrato Waveform */
				//case 0x50: /* Set Fine Tune */
				//case 0x60: /* Set/Jump to Loop */
				//case 0x70: /* Set Tremolo Waveform */
				//case 0x80: /* NOT USED */
				//case 0x90: /* Retrig Note */
				//case 0xc0: /* Note Cut */
				//case 0xd0: /* Note Delay */
				//case 0xe0: /* Pattern Delay */
				//case 0xf0: /* Invert Loop */
				/**/#ifdef WIN32
				/**/default:
				/**/	fprintf(stderr, "IGN-EFF: %03x\n", effect);
				/**/	break;
				/**/#endif /*WIN32*/
				/*}}ΉgGtFNg*/
				}
				break;
			}
		}
	}

	return 0;
}

static int
mod_mix(MODDRIVER* driver, short wbuff[MODBUFLEN])
{
	MODHEADER* header = driver->header;
	int i, chno, period, length, repofs, replen, volume, offset, step;
	short* dst;
	char* smpdat;
	MODSAMPLE* sample;
	MODCHANNEL* channel;

	/* ܂~LVOobt@NA܂B */
	//memset(wbuff, 0, sizeof wbuff); Ȃ悤ӁI
	memset(wbuff, 0, sizeof(short) * MODBUFLEN);

	/* ̊e`lɂ... */
	for(chno = 0, channel = driver->channel; chno < 4; chno++, channel++) {
		if(!(period = channel->period)) continue;

		/* TvȂǂoĂ܂B */
		sample = &header->sample[channel->smpno];
		smpdat = driver->smpdat[channel->smpno];
		length = SWAPH(sample->length) * 2 << 8; /* 24.8bit */
		repofs = SWAPH(sample->repofs) * 2 << 8; /* 24.8bit */
		replen = SWAPH(sample->replen) * 2 << 8; /* 24.8bit */
		volume = channel->volume;
		offset = channel->offset;

		/* sIhlTvItZbg߂܂B
		 * * 萔̗RF
		 *	AmigaPAL{NbN(?) = 7093789.2[Hz]  񕪎ăTEhHɋH
		 *	P/ECẼTEho͎g =   16000  [Hz]
		 * * TvItZbgF
		 *	Đ[g    = 7093789.2 / (period * 2)
		 *	[24.8bit] = (Đ[g / 16000) * 256
		 *	              = ((7093789.2 / (period * 2)) / 16000) * 256
		 *	              = (((7093789.2 / 2) / period) / 16000) * 256
		 *	              = ((7093789.2 / (2 * 16000)) / period) * 256
		 *	              = ((7093789.2 * 256) / (2 * 16000)) / period
		 *	              = 56750.3136 / period
		 */
		step = 56750 / period;

		for(i = 0, dst = wbuff; i < MODBUFLEN; i++, dst++) {
LOOP:
			/* TvItZbgTvf[^ɃNsO܂B */
			if(!channel->loop) { /*  */
				if(offset >= length) {
					if(!replen) { /* [vȂ */
						channel->period = 0; /* ~ */
						goto NO_LOOP;
					}
					offset -= length - repofs;
					channel->loop = 1;
					goto LOOP;
				}
			} else { /* ڈȍ~ */
				if(offset >= repofs + replen) {
					offset -= replen;
					goto LOOP;
				}
			}

			/* ~LVOobt@ɃTvl~{[Z܂B */
			*dst += smpdat[offset >> 8] * volume;

			/* TvItZbgi߂܂B */
			offset += step;
		}
NO_LOOP:
		/* TvItZbg߂܂B */
		channel->offset = offset;
	}

	/* 4`lÚA傤Ǖt16rbg̐UɈv܂B
	 *	}128(őTvl) ~ 64(ő{[) ~ 4(`l)  }32768
	 * ʑ̕Kv͂܂񂪁A2{x܂łȂ瑝Ă݂ĂłB
	 * xƂ̌ˍŁAD݂ɂāAǂB
	 */
	//for(i = 0, dst = wbuff; i < MODBUFLEN; i++, dst++) {
	//	volume = *dst << 1/**/;
	//	if(volume < -32767) {
	//		volume = -32767;
	//	} else if(volume > 32767) {
	//		volume = 32767;
	//	}
	//	*dst = volume;
	//}

	return 0;
}

int
mod_free(MODDRIVER* driver)
{
	/* ̂ƂA邱Ƃ͂܂B */
	return 0;
}

/*****************************************************************************
 *	eXgvO
 *****************************************************************************/

#define N	8	/* ȏ㑝₷waveOutWriteŃG[ɂȂ݂ */

unsigned char* base;
MODDRIVER driver;

HWAVEOUT wo;
WAVEFORMATEX fmt;
WAVEHDR hdr[N];
short wbuff[N][MODBUFLEN];

void CALLBACK
waveOutProc(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2)
{
	static int i;
	int retval;

	if(uMsg != WOM_DONE) return;

	mod_tick(&driver, wbuff[i]);
	retval = waveOutWrite(hwo, &hdr[i], sizeof hdr[i]);
	assert(retval == 0);

	i = (i + 1) % N;
}

int
main(int argc, char* argv[])
{
	int retval, len, i;
	FILE* fp;

	/* MODB */
	fp = fopen(argv[1], "rb");
	assert(fp != NULL);
	fseek(fp, 0, SEEK_END);
	len = ftell(fp);
	rewind(fp);
	base = (unsigned char*)malloc(len);
	assert(base != NULL);
	retval = fread(base, 1, len, fp);
	assert(retval == len);
	fclose(fp);
	retval = mod_init(&driver, base);
	assert(retval == 0);

	/* TEhB */
	memset(&fmt, 0, sizeof fmt);
	fmt.wFormatTag = WAVE_FORMAT_PCM;
	fmt.nChannels = 1;
	fmt.nSamplesPerSec = 16000;
	fmt.nAvgBytesPerSec = 16000 * 2;
	fmt.nBlockAlign = 2;
	fmt.wBitsPerSample = 16;
	retval = waveOutOpen(&wo, WAVE_MAPPER, &fmt, (DWORD)waveOutProc, 0, CALLBACK_FUNCTION);
	assert(retval == 0);
	for(i = 0; i < N; i++) {
		memset(&hdr[i], 0, sizeof hdr[i]);
		hdr[i].lpData = (char*)wbuff[i];
		hdr[i].dwBufferLength = sizeof wbuff[i];
		retval = waveOutPrepareHeader(wo, &hdr[i], sizeof hdr[i]);
		assert(retval == 0);
	}

	/* tJnB */
	for(i = 0; i < N; i++) {
		mod_tick(&driver, wbuff[i]);
		retval = waveOutWrite(wo, &hdr[i], sizeof hdr[i]);
		assert(retval == 0);
	}
	Sleep(INFINITE);

	/* TEhN[AbvB */
	for(i = 0; i < N; i++) {
		retval = waveOutUnprepareHeader(wo, &hdr[i], sizeof hdr[i]);
		assert(retval == 0);
	}
	waveOutClose(wo);

	/* MODN[AbvB */
	mod_free(&driver);

	return 0;
}
