/*
 *	app.c
 *
 *	QRR[hǂݎAv
 *
 *	* Mon Sep 21 19:36:48 JST 2015 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	main
 ****************************************************************************/

int
main()
{
	/* ߑȂO߂邽߂́AOt[܂B */
	SEH_init();

	/* AvP[V܂B */
	app_init();

	/* C[vs܂B */
	app_main();

	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
static const uint16_t TBL_TapMxrChMask[8/*nLogCh*/]={
BIN16(00000111,00000001),	//_0ɓKpзقޯϽ
BIN16(00000110,00000010),	//_1ɓKpзقޯϽ
BIN16(00000110,00000100),	//_2ɓKpзقޯϽ
BIN16(00000110,00001000),	//_3ɓKpзقޯϽ
BIN16(00000110,00010000),	//_4ɓKpзقޯϽ
BIN16(00000110,00100000),	//_5ɓKpзقޯϽ
BIN16(00000110,01000000),	//_6ɓKpзقޯϽ
BIN16(00000100,10000000)};	//_7ɓKpзقޯϽ
//         ||| ||||||||
//         ||| ++++++++-- TAPз0~7:_ٌʂ̌ʡTAPݻfnCtrlŐݒ肷
//         ||+----------- TAPз  8:oBGMĐΏ	:ðBGM
//         |+------------ TAPз  9:װĐΏ	:ðBGM,oBGM,SE
//         +------------- TAPз 10:İح		:S
static void TapMxr_TimerProc(void* iTime) {	//TAPзpϊ
	int iDevCh,iLogCh;
	if(TapSeq_GetLogCh(pTapSeq,1)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,(8+0),64, 0,  0);}	//_1ŉoBGMĐȂΤðBGM𑦏		
	else                                            {TapMxrCh_SetAtt(pTapMxr,(8+0), 0,64,500);}	//_1ŉoBGM~ȂΤðBGM0.5bŕA		{{TODO:عݒ}}
	if(TapSeq_GetLogCh(pTapSeq,7)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,(8+1),64, 0,  0);}	//_7ŴװĐȂΤðBGM,oBGM,SE𑦏	
	else                                            {TapMxrCh_SetAtt(pTapMxr,(8+1), 0, 0,  0);}	//_7Ŵװ~ȂΤðBGM,oBGM,SE𑦕A	
	TapMxr_Exec(pTapMxr,(int)iTime);	//TAPзs
	for(iDevCh=0;iDevCh<pTapSeq->pInfo->nDevCh;iDevCh++){	//޲ق̌ʂݒ肷
		iLogCh=TapSeq_GetDevCh(pTapSeq,iDevCh)->iLogCh;
		if(iLogCh!=UINT8_MAX){sound_att(iDevCh,TapMxr_GetAtt(pTapMxr,TBL_TapMxrChMask[iLogCh]));}
	}
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static void TapSeq_fnPlay(int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	TapMxrCh_SetAtt(pTapMxr,iLogCh,pLogCh->iAtt,0,0);
	sound_att(pLogCh->iDevCh,TapMxr_GetAtt(pTapMxr,TBL_TapMxrChMask[iLogCh]));
	sound_play(pLogCh->iDevCh,sound_table[pLogCh->iPhr],pLogCh->iLoop?pLogCh->iLoop:-1);
}
static void TapSeq_fnStop(int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	sound_stop(pLogCh->iDevCh);
}
static void TapSeq_fnLoop(int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnEnd(int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnCtrl(int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	TapMxrCh_SetAtt(pTapMxr,iLogCh,pLogCh->iAtt,0,0);
	sound_att(pLogCh->iDevCh,TapMxr_GetAtt(pTapMxr,TBL_TapMxrChMask[iLogCh]));
}
static int TapSeq_fnGetPhrTime(int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int TapSeq_fnGetPhrNext(int iPhr) {
	return (iPhr==SND_BGM_1G)||(iPhr==SND_BGM_ST)?iPhr:-1;
}
static void TapSeq_TimerProc(void* iTime) {
	TapSeq_Exec(pTapSeq,(int)iTime);
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	TRACE("%d:%d:%d\n", now/FPS, iEvtTmrCh, iEvent);
}
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_LOG_BUFFER
static int LogBuf_fnDraw(int x, int y, const char* Str) { //عݒ`̕`֐
	render_reduced_string(&render, x, y, Str, 3);
	return 10;
}
#endif/*USE_LOG_BUFFER*/

#ifdef  USE_TCL
//srand seed
static int Tcl_SrandCmd(Tcl_Interp* iPtr) {
	if((iPtr->argc < 1) || (iPtr->argc > 2)) { DIE(); }
	srand((iPtr->argc == 2) ? atoi(iPtr->argv[1]) : time(NULL));
	return TCL_OK;
}
//rand
static int Tcl_RandCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	iPtr->result = strdup_printf("%d", rand());
	return TCL_OK;
}
//log string
static int Tcl_LogCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 2) { DIE(); }
#ifdef  USE_LOG_BUFFER
	LogBuf_Print(pLogBuf, iPtr->argv[1]);
	update();
#else //USE_LOG_BUFFER
	TRACE("%s\n", iPtr->argv[1]);
#endif//USE_LOG_BUFFER
	return TCL_OK;
}
//schedule
static int Tcl_ScheduleCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	schedule();
	return TCL_OK;
}
#endif//USE_TCL

void
app_init()
{
#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈ݒ肵܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_init();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND

	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Init(BITMAP_GC_UNIT);
#endif /*BITMAP_GC_UNIT*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	InitMusic();
#if defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)
	/* - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * //{{2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B
	 * //- music_wchύX鏈́AInitMusic()ōsKv܂B
	 * //  InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * //- Amusic_loudness()̋@\music_wchQƂĂ܂A
	 * //  Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 * //}}2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B */
	music_wch = 3; /* `l0=2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

#ifdef USE_TRUESPEECH
	/* DSP Group TrueSpeech DecoderN܂B */
	TrueSpeech_Init(SOUND_MAXCH);
#endif /*USE_TRUESPEECH*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* TAPз܂ */
#ifdef  USE_SOUND_MIXER
	{
		pTapMxr=TapMxr_New((8+3)/*nMxrCh*/);
		timer_start(100,TapMxr_TimerProc,(void*)100);	//TAPзpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TAPݻ܂ */
#ifdef  USE_SOUND_SEQUENCER
	{
		static struct {
			ST_TapSeqInfo stTapSeqInfo;
			const uint8_t* TBL_TapSet[8/*nLogCh*/];
		} stTapSeqInfo = {{
			SOUND_COUNT,	//nPhr
			SOUND_MAXCH,	//nDevCh
			8,		//nLogCh
			4,		//nSeqCh
			1000/FPS,	//iCont
			TapSeq_fnPlay,
			TapSeq_fnStop,
			TapSeq_fnLoop,
			TapSeq_fnEnd,
			TapSeq_fnCtrl,
			TapSeq_fnGetPhrTime,
			TapSeq_fnGetPhrNext,
		},{
			(uint8_t[]){0  ,-1},
			(uint8_t[]){1,2,-1},
			(uint8_t[]){1,2,-1},
			(uint8_t[]){1,2,-1},
			(uint8_t[]){1,2,-1},
			(uint8_t[]){1,2,-1},
			(uint8_t[]){1,2,-1},
			(uint8_t[]){3  ,-1},
		}};
		pTapSeq=TapSeq_New(&stTapSeqInfo.stTapSeqInfo);
		timer_start(10,TapSeq_TimerProc,(void*)10);	//޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* LEDV[PT܂B */
#ifdef  USE_LED
	pLedSeq = LedSeq_Init(LedCh_Max + 1, LedSeqCh_Max + 1);
#endif//USE_LED

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static ST_EvtTmrFunc stEvtTmrFunc = { EvtTmr_onEvent };
		pEvtTmr = EvtTmr_Init(EvtTmrNo_Max+1);	//ς
		EvtTmr_AddFunc(pEvtTmr, &stEvtTmrFunc);	//ď֐o^
	}
#endif/*USE_EVENT_TIMER*/

	/* ėpJE^Ǘ܂B */
#ifdef  USE_COUNTER_MANAGER
	pCntMgr = CntMgr_Init(COUNTER_MAXCH);
#endif/*USE_COUNTER_MANAGER*/

	/* Oobt@܂B */
#ifdef  USE_LOG_BUFFER
	pLogBuf = LogBuf_Init((DISP_Y+9)/10, LogBuf_fnDraw);
#endif/*USE_LOG_BUFFER*/

#ifdef  USE_TCL
	//TclC^v^邽߂ɁAIɃK[x[WRNVsB
#if     defined(GC_LEVEL)
/*K{*/timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBʏGCTclC^v^gpꍇ́A̍ssȂƋɒ[ɒxȂB
#elif   defined(BITMAP_GC_UNIT)
//C	timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBBitmap GCgpꍇ͋ɒ[ɒx͂ȂA̍ssł͂B
#else //defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	#error TclC^v^̓K[x[WRN^[̕pK{łB
#endif//defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	//TclC^v^쐬B
	iPtr = Tcl_CreateInterp();
	//ėpIȃAvP[V`̃R}ho^B
	Tcl_CreateCommand(iPtr, "srand",    Tcl_SrandCmd,    NULL);
	Tcl_CreateCommand(iPtr, "rand",     Tcl_RandCmd,     NULL);
	Tcl_CreateCommand(iPtr, "log",      Tcl_LogCmd,      NULL);
	Tcl_CreateCommand(iPtr, "schedule", Tcl_ScheduleCmd, NULL);
#endif//USE_TCL

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

#ifdef  USE_TASK
	/* ^XNXPW[܂B
	 * - AChXbhƕpꍇ́Aidle_proc()̒ŏĂB
	 *   AChXbhƕp@́Atask_yield()[note]QƂĂB */
	task_init(INT_MIN);//{{TODO:ѱ̎sDxͱعݒ}}
#endif/*USE_TASK*/

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Free();
#endif /*BITMAP_GC_UNIT*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/

#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_free();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 * * Thu Dec 21 21:17:56 JST 2014 Naoyuki Sawa
 * - Oobt@`A܂łschedule()ōsĂ܂Aupdate()ōs悤ɕύX܂B
 *   ɉāAOobt@`OŁAzVRAMۑ悤ɂ܂B
 *   ̕ύXɂāAAvP[V́AOobt@`̉e𖳎āAI[o[CƌȂ悤ɂȂ܂B
 *   ȉ̂悤ȏ\ƂȂ܂B
 *   1
 *   void app_main(){
 *     surface_clear(&surface,0);
 *     render_ellipse(&render,0,0,DISP_X,DISP_Y,3);//~`悷
 *     for(;;){
 *       schedule();//~j󂹂۸ޯ̧`݂̂۰قł
 *       LogBuf_Printf(pLogBuf,"%d",now);
 *   } }
 *   2
 *   void test(){
 *     //``
 *     LogBuf_Printf(pLogBuf,"some message");
 *     update();//۸ޯ̧`݂̂XV
 *     //``
 *   } }
 * - ̕ύXɔAOobt@`悪A^ƁAPC̉ʃLv`Ɋ܂܂ȂȂƂɁAӂĂB
 *   ^schedule()̒vidrec()ŁCLv`schedule()̒yield()ōs鏈łB
 *   vidrec()yield()Ă΂鎞_ł́AzVRAM͕ĂAOobt@`͎cĂȂłB
 *   Oobt@`́AɃeXĝ߂̕\ł̂ŁA^Lv`Ɋ܂܂ĂȂĂ肪Ǝv܂A
 *   Kvłꍇ́A֐̍ṒAzVRAM𕜌鏈폜΁AύXOƓlɊ܂܂悤ɂł܂B
 */
void
update()
{
#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɉzVRAMޔB */
    #ifdef  V_SCREEN
	static unsigned char tmpbuf[sizeof vbuff];	//Oobt@Əcʂ𕹗pꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgȂBrotate_screen()_def_vbuffj󂷂邩łBtmpbuf[]̕gpʂ邱ƂɒӂB
	memcpy(tmpbuf, vbuff, sizeof vbuff);
    #else //V_SCREEN
	memcpy(_def_vbuff, vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgB
    #endif//V_SCREEN
	/* Oobt@`B */
	LogBuf_Draw(pLogBuf, 0, 0);
#endif/*USE_LOG_BUFFER*/

#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();

#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɑޔzVRAM𕜌B */
    #ifdef  V_SCREEN
	memcpy(vbuff, tmpbuf, sizeof vbuff);		//Oobt@Əcʂ𕹗pꍇ
    #else //V_SCREEN
	memcpy(vbuff, _def_vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ
    #endif//V_SCREEN
#endif/*USE_LOG_BUFFER*/
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void
vidrec()
{
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void
schedule()
{
#ifdef  USE_EVENT_TIMER
	/* Cxg^C}B */
	EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
	/* ėpJE^ǗB */
	CntMgr_Exec(pCntMgr);
#endif/*USE_COUNTER_MANAGER*/

#ifdef  USE_LED
	/* LEDV[PTB */
	{
		unsigned char Buffer[LedCh_Max + 1];
		memset(Buffer, 1/**/, sizeof Buffer);
		LedSeq_Exec(pLedSeq, Buffer);
		//{{TODO:Buffer[]ʂɕ`悵Ă}}
	}
#endif//USE_LED

#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

	now++;	/* O[o^C}XV */
}

/****************************************************************************
 *	delay
 ****************************************************************************/

void
delay(int frame)
{
	while(frame > 0) {
		schedule();
		frame--;
	}
}

/****************************************************************************
 *	
 ****************************************************************************/
#define MAX_DISP	13			//Sɕ\łACe
typedef struct _ITEM {
	char	name[(8 + 1 + 3) + 1/*nul*/];	//t@C
	int	size;				//t@CTCY
} ITEM;
static ITEM*	TBL_Item/*[nItem]*/;		//ACeXg
static int	nItem;				//ACe̐
static int	cursel;				//݂̑IACeCfNX
static int	curtop;				//ŏi\ACeCfNX
static int	oldsel = -1;			//ȎIACeCfNX
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int scandir_filter(const struct dirent* e) {
	return !fnmatch("*.jpg", e->d_name, 0) ||
	       !fnmatch("*.jpe", e->d_name, 0);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void init_sel() {
	struct dirent** e;
	int i;
	nItem = scandir(".", &e, scandir_filter, versionsort);
	if(!nItem) { die("jpgt@CL܂BSELECT{^ƁAI܂B"); }
	TBL_Item = calloc(nItem, sizeof(ITEM));
	for(i = 0; i < nItem; i++) {
		struct stat st;
		strlcpy(TBL_Item[i].name, e[i]->d_name, sizeof TBL_Item[i].name);
		if(stat(TBL_Item[i].name, &st)) { DIE(); }
		TBL_Item[i].size = st.st_size;
	}
	free(e);
}
/*--------------------------------------------------------------------------*/
static const void*	jpeg;
#define SIZE		48			//EyCɕ\摜̍őTCY
static uint8_t		img[SIZE*SIZE];
static int		srcW, srcH;
static int		dstW, dstH;
static const char*	msg;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void size_proc(int w, int h, void* user_data) {
	srcW = w;
	srcH = h;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void draw_proc(int x, int y, int c, void* user_data) {
	x = x * dstW / srcW;
	y = y * dstH / srcH;
	if((unsigned)x >= dstW) { DIE(); }
	if((unsigned)y >= dstH) { DIE(); }
	img[(dstW * y) + x] = ~c;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int _idle_proc() {
	char* data;
	int c, t, x, y;
	memset(img, 0, sizeof img);
	srcW = srcH = 0;
	dstW = dstH = 0;
//{{͈̔͂̏̓Av̉EyCQRR[h̉摜\邽߂ɍsĂ܂Bۂɂ́AQr_decode_jpeg()̒ɂ摜ǂݍݏL̂ŁAsĂ鎖ɂȂ܂BقڈuȂ̂ő쐫ɂ͉e͖Ǝv܂B
	//--- 摜ǂݍ ---
	msg = "޿޳  к Ͻ...";
	jpeg_decode(jpeg, 0, size_proc, NULL, NULL, NULL);
	if(((unsigned)srcW > 160/**/) ||
	   ((unsigned)srcH > 160/**/)) {
		msg = "޿޳  Ͻ";
		return 0;
	}
ENTER_CS;
	dstW = srcW;
	dstH = srcH;
	if(srcW >= srcH) {
		if(srcW > SIZE) {
			dstW = SIZE;
			dstH = SIZE * srcH / srcW;
		}
	} else {
		if(srcH > SIZE) {
			dstH = SIZE;
			dstW = SIZE * srcW / srcH;
		}
	}
LEAVE_CS;
	jpeg_decode(jpeg, 0, NULL, draw_proc, NULL, NULL);
	t = discriminant_analysis(img, dstW * dstH);
	for(y = 0; y < dstH; y++) {
		for(x = 0; x < dstW; x++) {
			c = img[(dstW * y) + x];
			img[(dstW * y) + x] = (c > t);
		}
	}
//}}͈̔͂̏̓Av̉EyCQRR[h̉摜\邽߂ɍsĂ܂Bۂɂ́AQr_decode_jpeg()̒ɂ摜ǂݍݏL̂ŁAsĂ鎖ɂȂ܂BقڈuȂ̂ő쐫ɂ͉e͖Ǝv܂B
	//--- QRR[hǂݎ ---
	msg = "QR  į Ͻ...";
	data = Qr_decode_jpeg(jpeg);
	msg = data ? data : "QR    ߲ ϼ";
	return 0;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static int idle_proc(void* param) {
	//CXbhRAMɗpӂX^bN֐؂ւĎsB
	return stack_switch(param, _idle_proc, 0, 0);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void app_main() {
	uint8_t stack[2560];	//idle_proc()pRAMX^bN
	int c, i, x, y;
	init_sel();
	memset(stack, 0x77, sizeof stack);
	for(;;) {
		schedule();
		if(stack[0] != 0x77) { DIE(); } //idle_proc()pRAMX^bNꂽBstack[]𑝂₹B
		surface_clear(&surface, 0);
		//XgI
		if(joy & TRG_UP) { cursel--; }
		if(joy & TRG_DN) { cursel++; }
		if(joy & TRG_LF) { cursel -= MAX_DISP; }
		if(joy & TRG_RI) { cursel += MAX_DISP; }
		if(cursel < 0                      ) { cursel = 0; }
		if(cursel > nItem - 1              ) { cursel = nItem - 1; }
		if(cursel < curtop                 ) { curtop = cursel; }
		if(cursel > curtop + (MAX_DISP - 1)) { curtop = cursel - (MAX_DISP - 1); }
		if(cursel != oldsel) {
			oldsel = cursel;
			idle_free();
			memset(stack, 0x77, sizeof stack);		//mɃJł悤ɁB
			gc_run();					//
			jpeg = file_defrag(TBL_Item[cursel].name, NULL);
			idle_init(idle_proc, stack + sizeof stack, 256/*FRAM֐؂ւ̂ōŏŗǂ*/);
		}
		//Xg\
		y = 8;
		for(i = curtop; i < curtop + MAX_DISP + 1; i++) {
			if(i > nItem - 1) { break; }
			if(i == cursel) {
				render_rectangle_fill(&render,
					0,
					y - 1,
					4 * 18 + 1,
					6 + 1,
					2);
				c = 0;
			} else {
				c = 2;
			}
			render_printf(&render,
				1,
				y,
				2,
				c,
				"%-12s%6d",
				TBL_Item[i].name,
				TBL_Item[i].size);
			y += 6;
		}
		//^Cg\
		render_rectangle_fill(&render,
			0,
			0,
			DISP_X,
			6 + 1,
			3);
		render_string(&render,
			0,
			1,
		//       01234567890123456789012345678901
			"======= QR   =======",
			2,
			0);
		//--- QRR[h\̈ ---
		{
			render_line(&render,
				4 * 18 + 1,
				6 + 1,
				4 * 18 + 1,
				DISP_Y,
				2);
			render_rectangle(&render,
				4 * 19,
				6 + 4 - 1,
				48 + 2,
				48 + 2,
				2);
			for(y = 0; y < dstH; y++) {
				for(x = 0; x < dstW; x++) {
					if(img[(dstW * y) + x]) {
						render_point(&render,
							4 * 19 + 1 + x,
							6 + 4 + y,
							3);
					}
				}
			}
			if(msg) {
				const char* str = msg;
				int len = strlen(str);
				c = 3;
				if(idle_stat()) {	//͓_ŕ\ɂB
					c = UPDOWN_MOTION((unsigned)now/SEC(0.1), 4);
				}
				x = 4 * 19 + 1;
				y = 8 + 6 * 9;
				for(i = 0; i < 4; i++) {
					render_printf(&render,
						x,
						y,
						2,
						c,
						"%-12.12s",
						str);
					str += 12;
					len -= 12;
					if(len <= 0) { break; }
					y += 6;
				}
			}
		}
	}
}
