#include "clip.h"

const void* ym_ptr;
int ym_len;

void
init()
{
	static unsigned char packed[1024 * 1024];
	static unsigned char unpacked[1024 * 1024];

	int retval;
	FILE* fp;
	LZH lzh;
	LZHDIR dir;

	fp = fopen("Bubble Bobble 1.ym", "rb");
	if(!fp) DIE();
	retval = fread(packed, 1, sizeof packed, fp);
	fclose(fp);

	retval = lzh_init(&lzh, packed, retval);
	if(retval < 0) DIE();
	retval = lzh_dir(&lzh, &dir);
	if(retval < 0) DIE();
	retval = lzh_uncompress(&lzh, dir.pathname, unpacked, sizeof unpacked);
	if(retval < 0) DIE();

	ym_ptr = unpacked;
	ym_len = retval;
}

int
main(int argc, char* argv[])
{
	int retval;
	YMDRIVER ym;
	short wbuff[YMBUFLEN];

	init();
	retval = ym_init(&ym, ym_ptr, ym_len);
	if(retval != 0) DIE();

	for(;;) {
		ym_stream_callback(wbuff, (int)&ym);
	}
}

