#define STRICT
#include <windows.h>

#include <setupapi.h>
#pragma comment(lib, "setupapi.lib")

HANDLE
OpenDeviceInterface(const GUID* InterfaceClassGuid, int MemberIndex)
{
	HANDLE DeviceInterfaceHandle = INVALID_HANDLE_VALUE;
	HDEVINFO DeviceInfoSet = INVALID_HANDLE_VALUE;
	SP_DEVICE_INTERFACE_DETAIL_DATA* DeviceInterfaceDetailData = NULL;
	//
	SP_DEVICE_INTERFACE_DATA DeviceInterfaceData;
	DWORD RequiredSize;

	/* SetupDiGetClassDevsւWin32ĂяoɂāAw肵GUIDfoCXɊւufoCXZbgvJ܂B
	 * DIGCF_PRESENTtODIGCF_INTERFACEDEVICEtOɂāA݂foCX悤ɂĂ܂B
	 */
	DeviceInfoSet = SetupDiGetClassDevs(
		(GUID*)InterfaceClassGuid,
		NULL,
		NULL,
		DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
	if(DeviceInfoSet == INVALID_HANDLE_VALUE) {
		goto L_EXIT;
	}

	/* ɁAړĨfoCXCX^XɊւSP_DEVICE_INTERFACE_DATAReLXg\̂擾邽߂ɁA
	 * SetupDiEnumDeviceInterfacesĂяoĂ܂B
	 * OpenDeviceInterface1̃CX^XɊւ񂾂擾悤Ƃ܂A
	 * MemberIndexp[^0OpenDeviceInterfaces܂łGetLastErrorERROR_NO_MORE_ITEMSԂ܂łɑ₷ƂɂāA
	 * ׂẴCX^X邱Ƃł܂B
	 */
	DeviceInterfaceData.cbSize = sizeof DeviceInterfaceData;
	if(!SetupDiEnumDeviceInterfaces(
		DeviceInfoSet,
		NULL,
		(GUID*)InterfaceClassGuid,
		MemberIndex,
		&DeviceInterfaceData)) {
		goto L_EXIT;
	}

	/* ̏́ACX^X̃V{bNN擾邱ƂłB
	 * ́̕ASetupDiGetDeviceInterfaceDetailւ̌ĂяoɂĕԂSP_DEVICE_INTERFACE_DETAIL_DATA\̂̒ɂ܂B
	 * SetupDiGetDeviceInterfaceDetail2ĂяoKv܂B
	 * ŏ̌ĂяoSP_DEVICE_INTERFACE_DETAIL_DATA\̂ɕKvȃTCY擾A2ڂ̌ĂяoŎۂɍ\̂擾܂B
	 */
	SetupDiGetDeviceInterfaceDetail(
		DeviceInfoSet,
		&DeviceInterfaceData,
		NULL,
		0,
		&RequiredSize,
		NULL);
	if(GetLastError() != ERROR_INSUFFICIENT_BUFFER) {
		goto L_EXIT;
	}
	DeviceInterfaceDetailData = malloc(RequiredSize);
	if(!DeviceInterfaceDetailData) {
		goto L_EXIT;
	}
	DeviceInterfaceDetailData->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
	if(!SetupDiGetDeviceInterfaceDetail(
		DeviceInfoSet,
		&DeviceInterfaceData,
		DeviceInterfaceDetailData,
		RequiredSize,
		NULL,
		NULL)) {
		goto L_EXIT;
	}

	/* ŏIIɁAK؂ȃfoCXւ̃nhJ߂̃t@CSP_DEVICE_INTERFACE_DETAIL_DATA.DevicePathɓ܂B
	 * ̃t@CCreateFileɓnāASP_DEVICE_INTERFACE_DETAIL_DATA\͍̂폜܂B
	 * ׂẴpXɑ΂SetupDiDestroyDeviceInfoListĂяoāAfoCXZbgYꂸɕĂB
	 */
	DeviceInterfaceHandle = CreateFile(
		DeviceInterfaceDetailData->DevicePath,
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL);

L_EXIT:
	if(DeviceInterfaceDetailData) {
		free(DeviceInterfaceDetailData);
	}
	if(DeviceInfoSet != INVALID_HANDLE_VALUE) {
		SetupDiDestroyDeviceInfoList(DeviceInfoSet);
	}
	return DeviceInterfaceHandle;
}
