/*
 *	utop - toalo摜Ro[^
 *	Copyright (C) 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *
 *	* Sun May 26 21:10:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- 1st release.
 *	* Fri May 31 05:04:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- x̃CfNXItZbg(ofs)̃Rg\ǉB
 *	- SLN^(N_CHRS)̒`ǉB
 *	* Sat Jun 01 07:01:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- uACe=xv`̎wɑΉB
 *	* Sat Jun 01 08:33:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- (even)A(odd)ΉBB
 *	* Sat Jun 01 11:42:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- őC[WTCY(MAX_IMAGE_SIZE)1024->4096ɕύXB
 *	* Sat Jul 23 20:45:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- 摜pbNȂ[h(-u[u])ǉB
 *	- 32rbgꖇG(egbg.ãCxgGȂ)ɑΉB
 *	  WrbgꖇG(퓬}bvȂ)ɂ͖ΉłB
 *	* Mon Jul 24 00:05:00 JST 2002 Naoyuki Sawa <nsawa@north.hokkai.net>
 *	- 32rbgꖇG̈ꕔ́AȂ640x480ł͂Ȃ644x480ɂȂĂ܂B
 *	  644x480ł͎gÂ炢Ƃ̂ŁA640x480ɐ؂l߂悤ɂ܂B
 *	  644x480̂܂܂̕悯΁Ablock()֐̊Y̏RgAEgĂB
 */
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <malloc.h>

#define PCKSIG		((short)0xAF1E)
typedef struct _PCKHDR {
	short sig;	/* VOl` */
	short cnt;	/* vf     */
} PCKHDR;

typedef struct _PCKENT {
	char name[24];	/* O       */
	int len;	/* TCY     */
	int ofs;	/* ItZbg */
} PCKENT;

typedef struct _BLKHDR {
	int w, h;	/* ubNTCY[sNZ] */
	int x, y;	/* ubN_  [sNZ] */
	int fmt;	/* tH[}bg             */
	int unk1;	/* (s:wƓ?)          */
	int unk2;	/* (s:hƓ?)          */
	int unk3;	/* (s:pfBO?)       */
} BLKHDR;

typedef struct _CELHDR9 {
	int y   : 8;	/* XLbv */
	int cnt : 8;	/* sNZ   */
	int unk1: 3;	/* gp       */
	int run : 1;	/* ؂ւ */
	int unk2: 1;	/* gp       */
	int x   :11;	/* XLbv */
} CELHDR9;

typedef struct _CELHDR32 {
	int y:16;	/* XLbv */
	int x:16;	/* XLbv */
} CELHDR32;

char uta_dir[_MAX_DIR]; /* úvtH_ */

/***************************************************************************/

void
err(const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);

	abort();
}

/***************************************************************************/

#define MAX_IMAGE_SIZE	4096
#define ALPHA_CUTOFF	1

int palette[256];
int back_color = 0x00FF00;
const int DITHER[8][8] = {
         0,32, 8,40, 2,34,10,42,
        48,16,56,24,50,18,58,26,
        12,44, 4,36,14,46, 6,38,
        60,28,52,20,62,30,54,22,
         3,35,11,43, 1,33, 9,41,
        51,19,59,27,49,17,57,25,
        15,47, 7,39,13,45, 5,37,
        63,31,55,23,61,29,53,21,
};

class Image {
public:
	Image(int w, int h);
	virtual ~Image();

	int w, h;
	int* bits;

	int get(int x, int y) const;
	void set(int x, int y, int c);
	int save24(const char* path);
	int save8a(const char* path);
	int save8(const char* path);
	void put(int x, int y, Image* img);
	void resize(int w, int h);
	void reduce(int s);
	void merge(int& x, int& y, Image* img, int rect[4]);
};

Image::Image(int w, int h)
{
	this->w = 0;
	this->h = 0;
	bits = NULL;
	resize(w, h);
}

Image::~Image()
{
	free(bits);
}

int
Image::get(int x, int y) const
{
	if(x < 0 || w - 1 < x) abort();
	if(y < 0 || h - 1 < y) abort();
	return bits[w * y + x];
}

void
Image::set(int x, int y, int c)
{
	if(x < 0 || w - 1 < x) abort();
	if(y < 0 || h - 1 < y) abort();
	bits[w * y + x] = c;
}

int
Image::save24(const char* path)
{
	int retval;
	int x, y, c;
	int line_bytes;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;

	FILE* fp;
	char* line_buffer;

	/* G[̂߁B */
	fp = NULL;
	line_buffer = NULL;

	/* t@CJB */
	fp = fopen(path, "wb");
	if(fp == NULL) goto ERR;

	/* Cobt@mہB */
	line_bytes = (3 * w) + 3 & ~3;
	line_buffer = (char*)malloc(line_bytes);
	if(line_buffer == NULL) abort();
	memset(line_buffer + 3 * w, 0, line_bytes - 3 * w); /* pfBONA */

	/* t@Cwb_óB */
	memset(&bf, 0, sizeof bf);
	bf.bfType = 'MB';
	bf.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + line_bytes * h;
	bf.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	retval = fwrite(&bf, 1, sizeof bf, fp);
	if(retval != sizeof bf) goto ERR;

	/* rbg}bvwb_óB */
	memset(&bi, 0, sizeof bi);
	bi.biSize = sizeof bi;
	bi.biWidth = w;
	bi.biHeight = h;
	bi.biPlanes = 1;
	bi.biBitCount = 24;
	retval = fwrite(&bi, 1, sizeof bi, fp);
	if(retval != sizeof bi) goto ERR;

	/* f[^óB */
	for(y = h - 1; y >= 0; y--) {
		for(x = 0; x < w; x++) {
			c = get(x, y);
			memcpy(line_buffer + 3 * x, &c, 3);
		}
		retval = fwrite(line_buffer, 1, line_bytes, fp);
		if(retval != line_bytes) goto ERR;
	}

	/* t@CB */
	fclose(fp);
	free(line_buffer);

	return 0;
ERR:
	if(fp != NULL) fclose(fp);
	if(line_buffer != NULL) free(line_buffer);

	return -1;
}

int
Image::save8a(const char* path)
{
	int retval;
	int x, y, c;
	int line_bytes;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;
	RGBQUAD rgb[256];

	FILE* fp;
	char* line_buffer;

	/* G[̂߁B */
	fp = NULL;
	line_buffer = NULL;

	/* t@CJB */
	fp = fopen(path, "wb");
	if(fp == NULL) goto ERR;

	/* Cobt@mہB */
	line_bytes = w + 3 & ~3;
	line_buffer = (char*)malloc(line_bytes);
	if(line_buffer == NULL) abort();
	memset(line_buffer + w, 0, line_bytes - w); /* pfBONA */

	/* t@Cwb_óB */
	memset(&bf, 0, sizeof bf);
	bf.bfType = 'MB';
	bf.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 + line_bytes * h;
	bf.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;
	retval = fwrite(&bf, 1, sizeof bf, fp);
	if(retval != sizeof bf) goto ERR;

	/* rbg}bvwb_óB */
	memset(&bi, 0, sizeof bi);
	bi.biSize = sizeof bi;
	bi.biWidth = w;
	bi.biHeight = h;
	bi.biPlanes = 1;
	bi.biBitCount = 8;
	retval = fwrite(&bi, 1, sizeof bi, fp);
	if(retval != sizeof bi) goto ERR;

	/* pbgóB */
	for(c = 0; c < 256; c++) {
		rgb[c].rgbRed       = c;
		rgb[c].rgbGreen     = c;
		rgb[c].rgbBlue      = c;
		rgb[c].rgbReserved  = 0;
	}
	retval = fwrite(rgb, 1, sizeof rgb, fp);
	if(retval != sizeof rgb) goto ERR;

	/* f[^óB */
	for(y = h - 1; y >= 0; y--) {
		for(x = 0; x < w; x++) {
			c = get(x, y);
			line_buffer[x] = c >> 24;
		}
		retval = fwrite(line_buffer, 1, line_bytes, fp);
		if(retval != line_bytes) goto ERR;
	}

	/* t@CB */
	fclose(fp);
	free(line_buffer);

	return 0;
ERR:
	if(fp != NULL) fclose(fp);
	if(line_buffer != NULL) free(line_buffer);

	return -1;
}

int
Image::save8(const char* path)
{
	int retval;
	int x, y, c, a, r, g, b;
	int line_bytes;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;
	RGBQUAD rgb[256];

	FILE* fp;
	char* line_buffer;

	/* G[̂߁B */
	fp = NULL;
	line_buffer = NULL;

	/* t@CJB */
	fp = fopen(path, "wb");
	if(fp == NULL) goto ERR;

	/* Cobt@mہB */
	line_bytes = w + 3 & ~3;
	line_buffer = (char*)malloc(line_bytes);
	if(line_buffer == NULL) abort();
	memset(line_buffer + w, 0, line_bytes - w); /* pfBONA */

	/* t@Cwb_óB */
	memset(&bf, 0, sizeof bf);
	bf.bfType = 'MB';
	bf.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 + line_bytes * h;
	bf.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;
	retval = fwrite(&bf, 1, sizeof bf, fp);
	if(retval != sizeof bf) goto ERR;

	/* rbg}bvwb_óB */
	memset(&bi, 0, sizeof bi);
	bi.biSize = sizeof bi;
	bi.biWidth = w;
	bi.biHeight = h;
	bi.biPlanes = 1;
	bi.biBitCount = 8;
	retval = fwrite(&bi, 1, sizeof bi, fp);
	if(retval != sizeof bi) goto ERR;

	/* pbgóB */
	for(c = 0; c < 4; c++) {
		rgb[c].rgbRed       = 85 * (3 - c);
		rgb[c].rgbGreen     = 85 * (3 - c);
		rgb[c].rgbBlue      = 85 * (3 - c);
		rgb[c].rgbReserved  = 0;
	}
	for(c = 4; c < 256; c++) {
		rgb[c].rgbRed       = 0;
		rgb[c].rgbGreen     = 255;
		rgb[c].rgbBlue      = 0;
		rgb[c].rgbReserved  = 0;
	}
	retval = fwrite(rgb, 1, sizeof rgb, fp);
	if(retval != sizeof rgb) goto ERR;

	/* f[^óB */
	for(y = h - 1; y >= 0; y--) {
		for(x = 0; x < w; x++) {
			c = get(x, y);
			a = c >> 24 & 0xFF;
			r = c >> 16 & 0xFF;
			g = c >>  8 & 0xFF;
			b = c >>  0 & 0xFF;
			if(a >= ALPHA_CUTOFF) {
				c = (r * 3 + g * 5 + b * 2) / 10;
				c = (c + DITHER[y & 7][x & 7] + (85 - 63) / 2) / 85;
				if(c > 3) c = 3;
				c = 3 - c;
			} else {
				c = 4;
			}
			line_buffer[x] = c;
		}
		retval = fwrite(line_buffer, 1, line_bytes, fp);
		if(retval != line_bytes) goto ERR;
	}

	/* t@CB */
	fclose(fp);
	free(line_buffer);

	return 0;
ERR:
	if(fp != NULL) fclose(fp);
	if(line_buffer != NULL) free(line_buffer);

	return -1;
}

void
Image::put(int x, int y, Image* img)
{
	int sx, sy, c;

	for(sy = 0; sy < img->h; sy++) {
		for(sx = 0; sx < img->w; sx++) {
			c = img->get(sx, sy);
			set(x + sx, y + sy, c);
		}
	}
}

void
Image::resize(int w, int h)
{
	int x, y, old_w, old_h, *old_bits;

	old_w = this->w;
	old_h = this->h;
	old_bits = bits;

	if(w < 0 || MAX_IMAGE_SIZE < w) abort();
	if(h < 0 || MAX_IMAGE_SIZE < h) abort();
	this->w = w;
	this->h = h;
	bits = (int*)malloc(sizeof(int) * w * h);
	if(bits == NULL) abort();

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			bits[w * y + x] = x < old_w && y < old_h ? old_bits[old_w * y + x] : back_color;
		}
	}
}

void
Image::reduce(int s)
{
	int dx, dy, sx, sy, w, h, c, a, r, g, b, n;

	w = (this->w + (s - 1)) / s;
	h = (this->h + (s - 1)) / s;

	for(dy = 0; dy < h; dy++) {
		for(dx = 0; dx < w; dx++) {
			a = 0;
			r = 0;
			g = 0;
			b = 0;
			n = 0;
			for(sy = dy * s; sy < (dy + 1) * s; sy++) {
				if(sy >= this->h) continue;
				for(sx = dx * s; sx < (dx + 1) * s; sx++) {
					if(sx >= this->w) continue;
					c = get(sx, sy);
					a += c >> 24 & 0xFF;
					r += c >> 16 & 0xFF;
					g += c >>  8 & 0xFF;
					b += c >>  0 & 0xFF;
					n++;
				}
			}
			a /= n;
			r /= n;
			g /= n;
			b /= n;
			c = a << 24 | r << 16 | g << 8 | b << 0;
			set(dx, dy, c);
		}
	}

	resize(w, h);
}

void
Image::merge(int& x, int& y, Image* img, int rect[4])
{
	if(img->w > w) abort();

	if(x + img->w > w) {
		x = 0;
		y = h;
		resize(w, h + img->h);
	} else if(y + img->h > h) {
		resize(w, y + img->h);
	}
	put(x, y, img);

	if(rect != NULL) {
		rect[0] = x;
		rect[1] = y;
		rect[2] = img->w;
		rect[3] = img->h;
	}

	x += img->w;
}

/***************************************************************************/

int
block9(BLKHDR* bh, Image* img, int x_min, int y_min)
{
	unsigned char* p;
	int run, x, y, n, c, a;
	CELHDR9* ch;

	p = (unsigned char*)(bh + 1);
	run = 0;
	x = 0;
	y = 0;
	for(;;) {
		if(*(int*)p == -1) break; /* I */

		ch = (CELHDR9*)p;
		p = (unsigned char*)(ch + 1);

		/* ̃sNZ̊JnʒuB */
		x += ch->x;
		if(x < 0 || img->w - 1 < x) abort();
		y += ch->y;
		if(y < 0 || img->h - 1 < y) abort();

		/* ؑցB */
		if(ch->run) run = !run;

		/* sNZf[^B */
		if(ch->cnt & 1) abort();
		n = ch->cnt / 2;
		while(n-- != 0) {
			if(run) {
				a = 0xFF;
				c = *p++;
			} else {
				a = *p++;
				c = *p++;
				if(a > 0x7F) abort();
				a *= 2;
			}
			c = palette[c] | a << 24;
			img->set(bh->x + x - x_min, bh->y + y - y_min, c);
			x++;
		}
	}

	return 0;
}

/***************************************************************************/

int
block32(BLKHDR* bh, Image* img, int x_min, int y_min)
{
	int* p;
	int run, x, y, n, c, a;
	CELHDR32* ch;

	p = (int*)(bh + 1);
	run = 0;
	x = 0;
	y = 0;
	for(;;) {
		c = *p++;
		if(c == -1) { /* I */
			break;
		} else if(c == -2) { /* ؑ */
			run = !run;
			continue;
		}

		ch = (CELHDR32*)p;
		p = (int*)(ch + 1);

		/* ̃sNZ̊JnʒuB */
		x += ch->x;
		if(x < 0 || img->w - 1 < x) abort();
		y += ch->y;
		if(y < 0 || img->h - 1 < y) abort();

		/* sNZf[^B */
		n = *p++;
		while(n-- != 0) {
			c = *p++;
			a = c >> 24 & 0xFF;
			c &= 0xFFFFFF;
			if(run) {
				/* s̃́AA=0A255ɒuB */
				if(a != 0) abort();
				a = 0xFF;
			} else {
				/* ̃́AA=0`127Ȃ̂ŁA{B */
				if(a > 0x7F) abort();
				a *= 2;
			}
			c |= a << 24;
			img->set(bh->x + x - x_min, bh->y + y - y_min, c);
			x++;
		}
	}

	return 0;
}

/***************************************************************************/

Image*
block(BLKHDR* bh)
{
	int retval;
	int i, x, y, cnt, *ofs, init, x_min, y_min, x_max, y_max;
	int* rgba;
	char* base;
	BLKHDR* bh_pos;

	Image* img;

	/* G[̂߁B */
	img = NULL;

	if(bh->fmt == 0x00200001) { /* wi */
		img = new Image(bh->w, bh->h);

		/* wb_̌ 1sNZ32rbg~~ ̃x^f[^܂B */
		rgba = (int*)(bh + 1);
		for(y = 0; y < bh->h; y++) {
			for(x = 0; x < bh->w; x++) {
				img->set(x, y, 0xFF000000 | *rgba++);
			}
		}

		/* Ȃ640x480̊G̈ꕔ644x480ɂȂĂ̂ŁAE4sNZ폜܂B
		 * 644x480ł悯΁Ȁ̓RgAEgĂ\܂B
		 */
		if(bh->w == 644 && bh->h == 480) img->resize(640, 480);

	} else { /* `bvEJbgC */
		cnt = bh->w;
		ofs = (int*)(bh + 1);
		base = (char*)(ofs + cnt);

		/* Ŝ̃C[WTCYB */
		init = 0;
		for(i = 0; i < cnt; i++) {
			bh_pos = (BLKHDR*)(base + ofs[i]);
			switch(bh_pos->fmt) {
			case 0x00200000: /* `bṽpbg */
				if(bh_pos->w != 256) goto ERR;
				break;
			case 0x00090004: /* `bv */
			case 0x00200004: /* JbgC */
				if(!init || bh_pos->x             < x_min) x_min = bh_pos->x            ;
				if(!init || bh_pos->y             < y_min) y_min = bh_pos->y            ;
				if(!init || bh_pos->x + bh_pos->w > x_max) x_max = bh_pos->x + bh_pos->w;
				if(!init || bh_pos->y + bh_pos->h > y_max) y_max = bh_pos->y + bh_pos->h;
				init = 1;
				break;
			default:
				goto ERR;
			}
		}
		if(!init) goto ERR;

		/* S̃C[W쐬B */
		img = new Image(x_max - x_min, y_max - y_min);

		/* eubNWJB */
		for(i = 0; i < cnt; i++) {
			bh_pos = (BLKHDR*)(base + ofs[i]);
			switch(bh_pos->fmt) {
			case 0x00200000: /* `bṽpbg */
				memcpy(palette, bh_pos + 1, sizeof(int) * 256);
				break;
			case 0x00090004: /* `bv */
				retval = block9(bh_pos, img, x_min, y_min);
				if(retval != 0) goto ERR;
				break;
			case 0x00200004: /* JbgC */
				retval = block32(bh_pos, img, x_min, y_min);
				if(retval != 0) goto ERR;
				break;
			default:
				goto ERR;
			}
		}
	}

	return img;
ERR:
	if(img != NULL) delete img;

	return NULL;
}

/***************************************************************************/

Image*
extract(const char* path, const char* name, int index)
{
	int retval;
	int i, cnt, *ofs;
	PCKHDR ph;
	char* base;
	BLKHDR* bh_pos;

	FILE* fp;
	PCKENT* pe;
	BLKHDR* bh;
	Image* img;

	/* G[̂߁B */
	fp = NULL;
	pe = NULL;
	bh = NULL;
	img = NULL;

	/* t@CJ܂B */
	fp = fopen(path, "rb");
	if(fp == NULL) goto ERR;

	/* pbNwb_ǂ݂܂B */
	retval = fread(&ph, 1, sizeof ph, fp);
	if(retval != sizeof ph) goto ERR;
	if(ph.sig != PCKSIG) goto ERR;
	pe = (PCKENT*)malloc(sizeof(PCKENT) * ph.cnt);
	if(pe == NULL) goto ERR;
	retval = fread(pe, 1, sizeof(PCKENT) * ph.cnt, fp);
	if(retval != (int)(sizeof(PCKENT) * ph.cnt)) goto ERR;

	/* ACeT܂B */
	for(i = 0; i < ph.cnt; i++) {
		if(strcmpi(pe[i].name, name) == 0) break;
	}
	if(i == ph.cnt) goto ERR;

	/* ACe[h܂B
	 * Ƀt@Cʒu̓e[u̒(x[Xʒu)ɂ̂ŁA
	 * ݈ʒȗ΂ŃV[N܂B
	 */
	retval = fseek(fp, pe[i].ofs, SEEK_CUR);
	if(retval != 0) goto ERR;
	bh = (BLKHDR*)malloc(pe[i].len);
	if(bh == NULL) goto ERR;
	retval = fread(bh, 1, pe[i].len, fp);
	if(retval != pe[i].len) goto ERR;

	if(bh->fmt == 0x00200001) { /* wi */
		if(index != 0) goto ERR;
		img = block(bh);
	} else if(bh->fmt == 0x00000040) { /* JbgC */
		if(index != 0) goto ERR;
		img = block(bh);
	} else if(bh->fmt == 0x00000084) { /* `bv */
		cnt = bh->w;
		ofs = (int*)(bh + 1);
		base = (char*)(ofs + cnt);
		if(index < 0 || cnt - 1 <index) goto ERR;
		bh_pos = (BLKHDR*)(base + ofs[index]);
		img = block(bh_pos);
	} else {
		goto ERR;
	}

	/* t@C܂B */
	fclose(fp);
	free(pe);
	free(bh);

	return img;
ERR:
	if(fp != NULL) fclose(fp);
	if(pe != NULL) free(pe);
	if(bh != NULL) free(bh);
	if(img != NULL) delete img;

	return NULL;
}

/***************************************************************************/

int
getcnt(const char* path, const char* name)
{
	int retval;
	int i, cnt;
	PCKHDR ph;

	FILE* fp;
	PCKENT* pe;
	BLKHDR* bh;

	/* G[̂߁B */
	fp = NULL;
	pe = NULL;
	bh = NULL;

	/* t@CJ܂B */
	fp = fopen(path, "rb");
	if(fp == NULL) goto ERR;

	/* pbNwb_ǂ݂܂B */
	retval = fread(&ph, 1, sizeof ph, fp);
	if(retval != sizeof ph) goto ERR;
	if(ph.sig != PCKSIG) goto ERR;
	pe = (PCKENT*)malloc(sizeof(PCKENT) * ph.cnt);
	if(pe == NULL) goto ERR;
	retval = fread(pe, 1, sizeof(PCKENT) * ph.cnt, fp);
	if(retval != (int)(sizeof(PCKENT) * ph.cnt)) goto ERR;

	/* ACeT܂B */
	for(i = 0; i < ph.cnt; i++) {
		if(strcmpi(pe[i].name, name) == 0) break;
	}
	if(i == ph.cnt) goto ERR;

	/* ACe[h܂B
	 * Ƀt@Cʒu̓e[u̒(x[Xʒu)ɂ̂ŁA
	 * ݈ʒȗ΂ŃV[N܂B
	 */
	retval = fseek(fp, pe[i].ofs, SEEK_CUR);
	if(retval != 0) goto ERR;
	bh = (BLKHDR*)malloc(pe[i].len);
	if(bh == NULL) goto ERR;
	retval = fread(bh, 1, pe[i].len, fp);
	if(retval != pe[i].len) goto ERR;

	if(bh->fmt == 0x00200001) {        /* wi */
		cnt = 1;
	} else if(bh->fmt == 0x00000040) { /* JbgC */
		cnt = 1;
	} else if(bh->fmt == 0x00000084) { /* `bv */
		cnt = bh->w;
	} else {
		goto ERR;
	}

	/* t@C܂B */
	fclose(fp);
	free(pe);
	free(bh);

	return cnt;
ERR:
	if(fp != NULL) fclose(fp);
	if(pe != NULL) free(pe);
	if(bh != NULL) free(bh);

	return -1;
}

/***************************************************************************/

#define BMP_WIDTH	256
#define MAX_REDUCE	16
#define DELIM		" \t\r\n,"
#define SCR_EXT		".scr"
#define ARC_EXT		".a"
#define ITEM_EXT	".px"
#define BMP_EXT		".bmp"

char scr_path[_MAX_PATH];
char scr_drive[_MAX_DRIVE];
char scr_dir[_MAX_DIR];
char scr_fname[_MAX_FNAME];
char scr_ext[_MAX_EXT];
char arc_path[_MAX_PATH];
char arc_fname[_MAX_FNAME];
char item_path[MAX_PATH];
char item_fname[_MAX_FNAME];
char bmp_path[_MAX_PATH];
char bmp_fname[_MAX_FNAME];
char label_name[_MAX_FNAME];

int c_out;			/* -cIvVw肳ꂽ1           */
int bmp_width = BMP_WIDTH;	/* -wIvVɂwl              */
int u_pack;			/* -uIvVw肳ꂽ1A-uuȂ2 */

/* g\āAI܂B */
void
usage()
{
	fprintf(stderr, "gF\n");
	fprintf(stderr, "  utop [options] <script-filename[.scr]>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "IvVF\n");
	fprintf(stderr, "  -c        Wo͂ɍW`o\n");
	fprintf(stderr, "  -d<path>  úvtH_ ilWXg擾j\n");
	fprintf(stderr, "  -w<width> 摜t@C̕   il%dj\n", BMP_WIDTH);
	fprintf(stderr, "  -u[u]     摜pbN܂       i-c-wƂ̕p͂ł܂j\n");
	fprintf(stderr, "            u-uuvƎw肷ƁAt@CɃA[JCu܂߂܂\n");
	exit(1);
}

int
main(int argc, char* argv[])
{
	int retval;
	int i, n, no, x, y, line, reduce, index, step, cnt, ofs;
	int rect[4];
	HKEY hkey;
	FILE* fp_scr;
	char *p;
	char str[1024];
	char label[32];
	char cmd[1024];
	Image* img;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		p = argv[i];
		if(p[0] == '-') { /* IvV */
			switch(p[1]) {
			case 'c': /* Wo͂ɍW`o */
				if(c_out) usage(); /* dw */
				c_out = 1;
				break;
			case 'd': /* úvtH_w */
				if(strlen(uta_dir) != 0) usage(); /* dw */
				strncpy(uta_dir, &p[2], sizeof uta_dir);
				break;
			case 'w': /* 摜t@C̕w */
				bmp_width = atoi(&p[2]);
				if(bmp_width == 0) usage(); /* lȂ */
				break;
			case 'u': /* 摜pbNȂ */
				if(u_pack) usage(); /* dw */
				switch(p[2]) {
				case '\0': /* -u */
					u_pack = 1;
					break;
				case 'u': /* -uu */
					u_pack = 2;
					break;
				default:
					usage();
				}
				break;
			default:
				usage();
			}
		} else { /* XNvgt@Cw */
			if(strlen(scr_path) != 0) usage(); /* dw */
			strncpy(scr_path, p, sizeof scr_path);
		}
	}

	/* 摜pbNȂƂ́AW`o͂摜TCY̎w͂ł܂B */
	if(u_pack) {
		if(c_out) usage();
		if(bmp_width != BMP_WIDTH) usage();
	}

	/* fBNg擾B */
	if(strlen(uta_dir) == 0) {
		retval = RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\Leaf\\utaware", 0, KEY_QUERY_VALUE, &hkey);
		if(retval == 0) {
			n = sizeof uta_dir;
			retval = RegQueryValueEx(hkey, "InstallDir", 0, NULL, (unsigned char*)uta_dir, (unsigned long*)&n);
			RegCloseKey(hkey);
		}
		if(retval != 0) err("úvCXg[ĂȂ悤łB");
	}

	/* XNvgt@CJ܂B */
	if(strlen(scr_path) == 0) usage(); /* XNvgt@CwY */
	_splitpath(scr_path, scr_drive, scr_dir, scr_fname, scr_ext);
	if(strlen(scr_ext) == 0) {
		strcpy(scr_ext, SCR_EXT);
		_makepath(scr_path, scr_drive, scr_dir, scr_fname, scr_ext);
	}
	fp_scr = fopen(scr_path, "rt");
	if(fp_scr == NULL) err("%sJ܂B", scr_path);

	/* XNvgt@C̊esɂ... */
	if(bmp_width <= 0 || bmp_width % 4 != 0) err("摜t@Ć̕AS̔{łȂ΂܂B");
	Image bmp(bmp_width, 0); /* u-u[u]vw莞͎g܂ */
	no = 0;
	x = 0;
	y = 0;
	line = 0;
	reduce = 1;
	while(fgets(str, sizeof str, fp_scr) != NULL) {
		line++;

		/* u#vȍ~RgƂĐ؂̂āB */
		p = strchr(str, '#');
		if(p != NULL) *p = '\0';

		/* ŏ̃g[Nɂ... */
		p = strtok(str, DELIM);
		if(p == NULL) continue; /* s */
		if(strcmp(p, "REDUCE") == 0) { /* kύX */
			p = strtok(NULL, DELIM);
			if(p == NULL) err("%s:%d: k擾ł܂B", scr_path, line);
			reduce = atoi(p);
			if(reduce < 0 || MAX_REDUCE < reduce) err("%s:%d: ksłB", scr_path, line);
			p = strtok(NULL, DELIM);
			if(p != NULL) err("%s:%d: G[", scr_path, line);

		} else if(strcmp(p, "ARCHIVE") == 0) { /* ɕύX */
			p = strtok(NULL, DELIM);
			if(p == NULL) err("%s:%d: ɖ擾ł܂B", scr_path, line);
			strncpy(arc_fname, p, sizeof arc_fname);
			p = strtok(NULL, DELIM);
			if(p != NULL) err("%s:%d: G[", scr_path, line);

		} else if(strcmp(p, "NEWLINE") == 0) { /* sAu-u[u]vw莞͖Ӗł */
			p = strtok(NULL, DELIM);
			if(p != NULL) err("%s:%d: G[", scr_path, line);
			x = 0;
			y = bmp.h;

		} else { /* ؂o */
			strncpy(item_fname, p, sizeof item_fname);
			{
				/* 2002/06/01 uACe=xvǉ
				 * strtok()[v̒Ȃ̂ŁAłstrtok()͎gȂB
				 */
				char* p2;
				p2 = strchr(item_fname, '=');
				if(p2 == NULL) {
					/* name 0,1,2,3... ȂA
					 * namexACeƂ݂ȂB
					 */
					strcpy(label_name, item_fname);
				} else {
					/* name1=name2 0,1,2,3,... ȂA
					 * name1ACeAname2x݂ȂB
					 */
					strcpy(label_name, p2 + 1);
					*p2 = '\0';
				}
			}
			_makepath(arc_path, NULL, uta_dir, arc_fname, ARC_EXT);
			_makepath(item_path, NULL, NULL, item_fname, ITEM_EXT);

			/* 擪CfNXɑ΂郉x𐶐B */
			if(c_out) {
				sprintf(label, "%s_%s", arc_fname, /*item_fname->06/01ύX->*/label_name);
				printf("#ifndef CHRDEF\n");
				printf("#define %-*s %d\n", sizeof label, strupr(label), no);
				printf("#else /*CHRDEF*/\n");
			}

			/* eCfNXɂ... */
			cnt = getcnt(arc_path, item_path);
			if(cnt <= 0) err("%s:%d: vf擾G[ (%s, %s)", scr_path, line, arc_path, item_path);
			p = strtok(NULL, DELIM);
			if(p == NULL) {
				index = 0;
				step = 1;
			} else if(strcmpi(p, "even") == 0) {
				index = 0;
				step = 2;
				p = strtok(NULL, DELIM); /* "even"̌ɂ̓CfNXw肵Ă͂Ȃ */
				if(p != NULL) err("%s:%d: G[", scr_path, line);
			} else if(strcmpi(p, "odd") == 0) {
				index = 1; /* vf1ƂȂG[ɂȂ邪A܂肦Ȃ낤 */
				step = 2;
				p = strtok(NULL, DELIM); /* "odd"̌ɂ̓CfNXw肵Ă͂Ȃ */
				if(p != NULL) err("%s:%d: G[", scr_path, line);
			} 
			ofs = 0;
			for(;;) {
				if(p != NULL) index = atoi(p);

				/* C[W𒊏oB */
				img = extract(arc_path, item_path, index);
				if(img == NULL) err("%s:%d: oG[ (%s, %s, %d)", scr_path, line, arc_path, item_path, index);

				/* C[WkB */
				img->reduce(reduce);
				if(!u_pack) { /* ʏ̉摜pbN[h */
					/* ꖇ̃rbg}bvɃpbNB */
					bmp.merge(x, y, img, rect);
				} else { /* u-u[u]vw莞ipbNȂj */
					/* rbg}bv쐬B */
					if(cnt == 1) { /* JbgCFuCHAR_ERU01v܂́uERU01v̂悤ȃt@C */
						if(u_pack == 1) {
							sprintf(bmp_fname, "%s_%s", arc_fname, label_name);
						} else { /* u_pack == 2 */
							sprintf(bmp_fname, "%s", label_name);
						}
					} else { /* `bvFuCHIP_HAK_1v܂́uHAK_1v̂悤ȃt@C */
						if(u_pack == 1) {
							sprintf(bmp_fname, "%s_%s_%d", arc_fname, label_name, index);
						} else { /* u_pack == 2 */
							sprintf(bmp_fname, "%s_%d", label_name, index);
						}
					}
					_makepath(bmp_path, scr_drive, scr_dir, bmp_fname, BMP_EXT);
					retval = img->save8(bmp_path);
					if(retval != 0) err("%s쐬ł܂B", bmp_path);
					/* P/ECEpf[^ɕϊB */
					sprintf(cmd, "dpbmpcnv -q -b -f2m \"%s\"", bmp_path); /* -qKv! */
					retval = system(cmd);
					if(retval != 0) err("P/ECEpf[^ւ̕ϊɎs܂B");
				}

				/* LN^`B */
				if(c_out) {
					printf("{ %4d,%4d,%4d,%4d }, /* %2d */\n", rect[0], rect[1], rect[2], rect[3], ofs);
					no++;
					ofs++;
				}

				/* C[WJB */
				delete img;

				if(p != NULL) {
					p = strtok(NULL, DELIM);
					if(p == NULL) break;
				} else {
					index += step;
					if(index >= cnt) break;
				}
			}
			if(c_out) {
				printf("#endif /*CHRDEF*/\n");
			}
		}
	}
	/* SLN^̒`𐶐B */
	if(c_out) {
		printf("#ifndef CHRDEF\n");
		printf("#define %-*s %d\n", sizeof label, "N_CHRS", no);
		printf("#endif /*CHRDEF*/\n");
	}

	/* ʏ̉摜pbN[hȂ... */
	if(!u_pack) {
		/* rbg}bv쐬B */
		_makepath(bmp_path, scr_drive, scr_dir, scr_fname, BMP_EXT);
		retval = bmp.save8(bmp_path);
		if(retval != 0) err("%s쐬ł܂B", bmp_path);
		/* P/ECEpf[^ɕϊB */
		sprintf(cmd, "dpbmpcnv -q -b -f2m \"%s\"", bmp_path); /* -qKv! */
		retval = system(cmd);
		if(retval != 0) err("P/ECEpf[^ւ̕ϊɎs܂B");
	}

	return 0;
}
