/*
 *	proutes.c
 *
 *	uRoutesvPGDRo[^
 *	Copyright (C) 2003 Naoyuki Sawa
 *
 *	* Sun Mar 2 16:43:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Mar 3 05:40:00 JST 2003 Naoyuki Sawa
 *	- BMPڏo(-b1)́Arbg}bv\̂̃tB[hĂo͂悤ύXB
 */
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

/****************************************************************************
 *	}NE萔
 ****************************************************************************/

#define VERSION		"20030303"

#define REG_KEY		"Software\\Leaf\\Routes"
#define REG_VALUE	"InstallDir"

#define SIGNATURE	'PACK'
#define FNAME_LEN	24

typedef struct _PACK_INFO {	/* pbN */
	unsigned long head;	/* VOl` */
	long famount;		/* t@C */
} PACK_INFO;

typedef struct _FILE_INFO {	/* t@C                         */
	unsigned long type;	/* 0:kȂ/1:k/ȊO:s  */
	char fname[FNAME_LEN];	/* t@C                           */
	unsigned long offset;	/* ItZbg(pakt@C擪0Ƃ) */
	unsigned long size;	/* t@CTCY                       */
} FILE_INFO;

/* BMPGg܂܂ĂpbNt@CXg */
const char* const pack_list[] = {
	"grp.pak",
	"bak.pak",
};
#define PACK_LIST_COUNT	(sizeof pack_list / sizeof *pack_list)

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

char app_dir[_MAX_DIR];		/* uRoutesṽtH_ */
char item_name[_MAX_PATH];	/* oACeibak0000aȂǁj */

int opt_bmp;			/* BMPóieXgpj */
int opt_chr;			/* G[hi؂j */

/****************************************************************************
 *	֐錾
 ****************************************************************************/

void err(const char* fmt, ...);
void usage();
void extract(const char* item_name);
void decode(unsigned char* dst, unsigned char* src);
unsigned char* bmp8to32(unsigned char* in_buf);
unsigned char* bmp24to32(unsigned char* in_buf);
unsigned char* bmp32to8(unsigned char* in_buf);
unsigned char* reduce(unsigned char* in_buf);

/****************************************************************************
 *	err
 ****************************************************************************/

void
err(const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);

	exit(1);
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "proutes - uRoutesiLeaf/AQUAPLUSjvPGDRo[^i%sj\n", VERSION);
	fprintf(stderr, "Copyright (C) 2003 Naoyuki Sawa\n");
	fprintf(stderr, "gF\n");
	fprintf(stderr, "  proutes [options] <item-name>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "  ACeɁu*vƎw肷ƁAo\ȑSẴACe𒊏o܂B\n");
	fprintf(stderr, "  ၄ proutes -b *\n");
	fprintf(stderr, "         SẴt@CBMPt@CƂĒo܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "IvVF\n");
	fprintf(stderr, "  -b        -b2ƓłB\n");
	fprintf(stderr, "  -b1       rbg}bvt@Ĉ܂܏o͂܂B\n");
	fprintf(stderr, "  -b2       rbg}bvt@Ckďo͂܂B\n");
	fprintf(stderr, "  -b3       rbg}bvt@CkEFďo͂܂B\n");
	fprintf(stderr, "  -b/-b1/-b2/-b3̂ǂw肵Ȃ΁APGDt@Co͂܂B\n");
	fprintf(stderr, "  -c        kAcɂ͂ݏoꍇ́A؂܂B\n");
	fprintf(stderr, "  -d<path>  RoutestH_w ilWXg擾j\n");
	exit(1);
}

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int retval, i, n;
	char* p;
	HKEY hKey;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		p = argv[i];
		if(p[0] == '-') { /* IvV */
			switch(p[1]) {
			case 'b': /* BMPo */
				if(opt_bmp) usage(); /* dw */
				if(p[2]) {
					opt_bmp = p[2] - '0';
				} else {
					opt_bmp = 2; /* -b݂̂Ȃ2 */
				}
				if(opt_bmp < 1 || 3 < opt_bmp) usage();
				break;
			case 'c': /* G[h */
				if(opt_chr) usage(); /* dw */
				opt_chr = 1;
				break;
			case 'd': /* uRoutesvCXg[tH_w */
				if(strlen(app_dir) != 0) usage(); /* dw */
				strncpy(app_dir, &p[2], sizeof app_dir);
				break;
			default:
				usage();
			}
		} else {
			/* oACe */
			if(strlen(item_name) != 0) usage(); /* dw */
			strncpy(item_name, p, sizeof item_name);
		}
	}

	/* uRoutesvCXg[tH_𒲂ׂ܂B */
	if(strlen(app_dir) == 0) {
		retval = RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY, 0, KEY_QUERY_VALUE, &hKey);
		if(retval == 0) {
			n = sizeof app_dir;
			retval = RegQueryValueEx(hKey, REG_VALUE, 0, NULL, (unsigned char*)app_dir, (unsigned long*)&n);
			RegCloseKey(hKey);
		}
		if(retval != 0) err("uRoutesvCXg[ĂȂ悤łB");
	}

	/* ACew肳ꂽPƓWJAw肳ĂȂΑSWJցB */
	if(strlen(item_name) == 0) usage();
	if(strcmp(item_name, "*") == 0) {
		extract(NULL);
	} else {
		extract(item_name);
	}

	return 0;
}

/****************************************************************************
 *	extract_all
 ****************************************************************************/

void
extract(const char* item_name)
{
	int retval, done, alpha, i_pack, i_file;
	FILE *fp_in, *fp_out;
	PACK_INFO pack_info;
	FILE_INFO *file_info, *fi;
	char pack_path[_MAX_PATH];
	char bmp_path[_MAX_PATH];
	char fname[_MAX_PATH];
	unsigned char *in_buf, *out_buf;
	int in_size, out_size;
	BITMAPFILEHEADER* bf;
	BITMAPINFOHEADER* bi;
	char cmd[_MAX_PATH];

	done = 0;	/* PƓWJAwGgWJ1ɂȂ܂B */

	/* epbNt@Cɂ... */
	for(i_pack = 0; !done && i_pack < PACK_LIST_COUNT; i_pack++) {
		/* pbNt@CJ܂B */
		_makepath(pack_path, NULL, app_dir, pack_list[i_pack], NULL);
		fp_in = fopen(pack_path, "rb");
		if(fp_in == NULL) err("%s: t@CJ܂B", pack_list[i_pack]);

		/* pbNǂݍ݂܂B */
		retval = fread(&pack_info, 1, sizeof(PACK_INFO), fp_in);
		if(retval != sizeof(PACK_INFO)) err("%s: pbN񂪓ǂݍ߂܂B", pack_list[i_pack]);

		/* t@Cǂݍ݂܂B */
		file_info = (FILE_INFO*)calloc(pack_info.famount, sizeof(FILE_INFO));
		if(file_info == NULL) err("%s: t@Cǂݍނ߂̃mۂł܂B", pack_list[i_pack]);
		retval = fread(file_info, sizeof(FILE_INFO), pack_info.famount, fp_in);
		if(retval != pack_info.famount) err("%s: t@C񂪓ǂݍ߂܂B", pack_list[i_pack]);

		/* et@Cɂ... */
		for(i_file = 0; !done && i_file < pack_info.famount; i_file++/**, printf("\n")**/) {
			fi = &file_info[i_file];
			/**printf("%s(%d): %s(%d) ", pack_list[i_pack], i_file, fi->fname, fi->type);**/

			/* 0:k/1:k̂ꂩ̌`łȂΔ΂܂B */
			if(fi->type != 0 && fi->type != 1) { /**printf("** SKIP **");**/ continue; }

			/* SWJA܂͎wGgɈv... */
			_splitpath(fi->fname, NULL, NULL, fname, NULL);
			if(item_name == NULL || _strcmpi(fname, item_name) == 0) {
				/* SWJȂÃt@C\B */
				if(item_name == NULL) printf("%s(%4d): %-24s(%d)\n", pack_list[i_pack], i_file, fi->fname, fi->type);

				/* ̓obt@mۂ܂B */
				in_size = fi->size;
				in_buf = (unsigned char*)malloc(in_size);
				if(in_buf == NULL) err("̓obt@mۂł܂B");

				/* f[^ǂݍ݂܂B */
				retval = fseek(fp_in, fi->offset, SEEK_SET);
				if(retval != 0) err("V[NG[łB");
				retval = fread(in_buf, 1, in_size, fp_in);
				if(retval != in_size) err("f[^ǂݍ߂܂B");

				/* 0:k */
				if(!fi->type) {
					out_size = in_size;
					out_buf = (unsigned char*)malloc(out_size);
					if(out_buf == NULL) err("o̓obt@mۂł܂B");
					memcpy(out_buf, in_buf, out_size);

				/* 1:k */
				} else {
					out_size = *(int*)(in_buf + 4);
					out_buf = (unsigned char*)malloc(out_size);
					if(out_buf == NULL) err("o̓obt@mۂł܂B");
					decode(out_buf, in_buf + 4);
				}

				/* rbg}bvłȂΔ΂܂B */
				if(out_buf[0] != 'B' || out_buf[1] != 'M') continue;

				if(opt_bmp == 1) goto L10;	/* BMPo͂ */

				/*{{̃t@C(BJR)͈ÍĂH*/
				bf = (BITMAPFILEHEADER*)(out_buf);
				bi = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
				if(bi->biHeight < 0) continue;
				/*}}*/

				/* rbg}bv`ɂ... */
				bf = (BITMAPFILEHEADER*)(out_buf);
				bi = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
				alpha = 0; /* x} */
				switch(bi->biBitCount) {
				case 8:
					/* 832rbgϊB */
					out_buf = bmp8to32(out_buf);
					bf = (BITMAPFILEHEADER*)(out_buf);
					bi = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
					out_size = bf->bfSize;
					//alpha = 1;	/* ߂ */
					alpha = 0;	/* p[c͓߂AOtBbN͓߂ȂBƂ肠ȂƂĂ */
					break;
				case 24:
					/* 2432rbgϊB */
					out_buf = bmp24to32(out_buf);
					bf = (BITMAPFILEHEADER*)(out_buf);
					bi = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
					out_size = bf->bfSize;
					alpha = 0;	/* ߂Ȃ */
					break;
				case 32:
					alpha = 1;	/* ߂ */
					break;
				default:
					err("Ή̃rbg}bv`łB");
				}

				/* kB */
				out_buf = reduce(out_buf);
				bf = (BITMAPFILEHEADER*)(out_buf);
				bi = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
				out_size = bf->bfSize;

				if(opt_bmp == 2) goto L10;	/* BMPo͂ */

				/* OCXP[ϊB */
				out_buf = bmp32to8(out_buf);
				bf = (BITMAPFILEHEADER*)(out_buf);
				bi = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
				out_size = bf->bfSize;
L10:
				/* rbg}bvo͂܂B */
				_splitpath(fi->fname, NULL, NULL, fname, NULL);
				_makepath(bmp_path, NULL, NULL, fname, ".bmp");
				fp_out = fopen(bmp_path, "wb");
				retval = fwrite(out_buf, 1, out_size, fp_out);
				if(retval != out_size) err("rbg}bvo͂Ɏs܂B");
				fclose(fp_out);

				/* PGDϊB */
				if(opt_bmp == 0) {
					if(alpha) {	/* 2bit}XNt */
						sprintf(cmd, "dpbmpcnv -q -b -f2m \"%s\"", bmp_path); /* -qKv! */
					} else {	/* 2bit}XNȂ */
						sprintf(cmd, "dpbmpcnv -q -b -f2  \"%s\"", bmp_path); /* -qKv! */
					}
					if(system(cmd) != 0) err("PGDϊɎs܂B");
					remove(fi->fname);	/* BMP͂Ȃ̂ō폜 */
				}

				/* PƓWJȂA}[NB */
				if(item_name != NULL) done = 1;

				/* obt@J܂B */
				free(out_buf);
				free(in_buf);
			}
		}

		/* t@CJ܂B */
		free(file_info);

		/* pbNt@C܂B */
		fclose(fp_in);
	}

	/* PƓWJŁAw肳ꂽGgȂ΁AG[B */
	if(item_name && !done) err("%s܂B", item_name);
}

/****************************************************************************
 *	decode
 ****************************************************************************/

#define		N	4096
#define		F	18

static unsigned char tmp_buf[N + F];

void decode(unsigned char* dst, unsigned char* src)
{
	int i, j, k, r;
	int size, flags, pos, len;

	/* XChobt@B */
	memset(tmp_buf, 0, sizeof tmp_buf);
	r = N - F; /* ʒu͌̕H */

	/* o̓TCY擾B */
	size = *(unsigned int*)src;
	src += 4;

	/* JE^o̓TCYɒB܂... */
	i = 0;
	while(i < size) {
		/* `N1oCgڂ̓tOB */
		flags = *(src++);
		for(j = 0; j < 8; j++) { /* tObit0`70:k/1:kɑΉ */
			if(i >= size) break;
			if(flags & 1) { /* Ń}Ƃ͈ႤI */
				/* 0:k */
				*(tmp_buf + r++) = *(dst++) = *(src++);
				r &= (N - 1);
				i++;
			} else {
				/* 1:k */
				pos = *(src++);	/* pppp_pppp: p=XChʒubit 7`0           */
				len = *(src++);	/* pppp_llll: p=XChʒubit11`8Al=-2 */
				pos |= ((len & 0xf0) << 4);
				len = (len & 0x0f) + 2;
				for(k = 0; k <= len; k++) {
					if(i >= size) break;
					*(tmp_buf + r++) = *(dst++) = *(tmp_buf + ((pos + k) & (N - 1)));
					r &= (N - 1);
					i++;
				}
			}
			flags >>= 1; /* Ń}Ƃ͈ႤI */
		}
	}
}

/****************************************************************************
 *	bmp8to32
 ****************************************************************************/

unsigned char*
bmp8to32(unsigned char* in_buf)
{
	int w, h, x, y, c;
	RGBQUAD* rgb;

	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	RGBQUAD* rgb_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	rgb_in  = (RGBQUAD         *)(in_buf + sizeof(BITMAPFILEHEADER) + bi_in->biSize);
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w = bi_in->biWidth;
	h = bi_in->biHeight;
	stride_in = (w + 3) & ~3;

	/* o̓rbg}bv쐬B */
	stride_out = 4 * w;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + stride_out * h;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w;
	bi_out->biHeight = h;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 32;

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			pin  = bits_in  + stride_in  * (h - 1 - y) + 1 * x;
			pout = bits_out + stride_out * (h - 1 - y) + 4 * x;
			;
			c = *pin;
			rgb = &rgb_in[c];
			;
			*pout++ = rgb->rgbBlue;
			*pout++ = rgb->rgbGreen;
			*pout++ = rgb->rgbRed;
			//*pout++ = c == 0 ? 0 : 255;	/* J[#0𓧉߂Ɖ */
			*pout++ = 255;			/* p[c͓߂AOtBbN͓߂ȂBƂ肠ȂƂĂ */
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	bmp24to32
 ****************************************************************************/

unsigned char*
bmp24to32(unsigned char* in_buf)
{
	int w, h, x, y;

	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w = bi_in->biWidth;
	h = bi_in->biHeight;
	stride_in = (3 * w + 3) & ~3;

	/* o̓rbg}bv쐬B */
	stride_out = 4 * w;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + stride_out * h;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w;
	bi_out->biHeight = h;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 32;

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			pin  = bits_in  + stride_in  * (h - 1 - y) + 3 * x;
			pout = bits_out + stride_out * (h - 1 - y) + 4 * x;
			;
			*pout++ = *pin++;
			*pout++ = *pin++;
			*pout++ = *pin++;
			*pout++ = 255;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	bmp8to32
 ****************************************************************************/

const int DITHER[8][8] = {
         0,32, 8,40, 2,34,10,42,
        48,16,56,24,50,18,58,26,
        12,44, 4,36,14,46, 6,38,
        60,28,52,20,62,30,54,22,
         3,35,11,43, 1,33, 9,41,
        51,19,59,27,49,17,57,25,
        15,47, 7,39,13,45, 5,37,
        63,31,55,23,61,29,53,21,
};

unsigned char*
bmp32to8(unsigned char* in_buf)
{
	int w, h, x, y, r, g, b, a, c;

	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	RGBQUAD* rgb_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w = bi_in->biWidth;
	h = bi_in->biHeight;
	stride_in = 4 * w;

	/* o̓rbg}bv쐬B */
	stride_out = (w + 3) & ~3;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 + stride_out * h;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	rgb_out  = (RGBQUAD         *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256);

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w;
	bi_out->biHeight = h;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 8;

	for(c = 0; c < 4; c++) {
		rgb_out[c].rgbRed       = 85 * (3 - c);
		rgb_out[c].rgbGreen     = 85 * (3 - c);
		rgb_out[c].rgbBlue      = 85 * (3 - c);
		rgb_out[c].rgbReserved  = 0;
	}
	for(c = 4; c < 256; c++) {
		rgb_out[c].rgbRed       = 0;
		rgb_out[c].rgbGreen     = 255;
		rgb_out[c].rgbBlue      = 0;
		rgb_out[c].rgbReserved  = 0;
	}

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			pin  = bits_in  + stride_in  * (h - 1 - y) + 4 * x;
			pout = bits_out + stride_out * (h - 1 - y) + 1 * x;
			;
			b = *pin++;
			g = *pin++;
			r = *pin++;
			a = *pin++;
			;
			if(a) {
				c = (r * 3 + g * 5 + b * 2) / 10;
				c = (c + DITHER[y & 7][x & 7] + (85 - 63) / 2) / 85;
				if(c > 3) c = 3;
				c = 3 - c;
			} else {
				c = 4;
			}
			;
			*pout++ = c;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	reduce
 ****************************************************************************/

#define WIDTH_LIMIT	128
#define HEIGHT_LIMIT	 88

unsigned char*
reduce(unsigned char* in_buf)
{
	int x_in, y_in, x_out, y_out, r, g, b, a, n, x_base, y_base;
	double REDUCE_LEVEL;

	int w_in;
	int h_in;
	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	int w_out;
	int h_out;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w_in = bi_in->biWidth;
	h_in = bi_in->biHeight;
	stride_in = 4 * w_in;

	/* G[h͔䗦ŒB */
	if(opt_chr) {
		REDUCE_LEVEL = 800.0 / WIDTH_LIMIT;
	/* wi[h͔䗦ρB */
	} else {
		double rl1 = w_in / WIDTH_LIMIT;
		double rl2 = h_in / HEIGHT_LIMIT;
		REDUCE_LEVEL = rl1 <= rl2 ? rl1 : rl2; /* ʂςɂȂ悤 */
	}

	/* o̓rbg}bv쐬B */
	w_out = (int)(w_in / REDUCE_LEVEL);
	h_out = (int)(h_in / REDUCE_LEVEL);
	x_base = 0;
	y_base = 0;
	if(w_out > WIDTH_LIMIT) {
		x_base = (int)((w_out - WIDTH_LIMIT) / 2 * REDUCE_LEVEL);
		w_out = WIDTH_LIMIT;
	}
	if(h_out > HEIGHT_LIMIT) {
		if(!opt_chr) y_base = (int)((h_out - HEIGHT_LIMIT) / 2 * REDUCE_LEVEL);
		h_out = HEIGHT_LIMIT;
	}
	stride_out = 4 * w_out;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + stride_out * h_out;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w_out;
	bi_out->biHeight = h_out;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 32;

	/* kB */
	for(y_out = 0; y_out < h_out; y_out++) {
		for(x_out = 0; x_out < w_out; x_out++) {
			/* k̃sNZZB */
			r = 0;
			g = 0;
			b = 0;
			a = 0;
			n = 0;
			for(y_in = y_base + (int)(y_out * REDUCE_LEVEL); y_in < y_base + (int)((y_out + 1) * REDUCE_LEVEL); y_in++) {
				if(y_in < 0 || h_in - 1 < y_in) continue;
				for(x_in = x_base + (int)(x_out * REDUCE_LEVEL); x_in < x_base + (int)((x_out + 1) * REDUCE_LEVEL); x_in++) {
					if(x_in < 0 || w_in - 1 < x_in) continue;
					pin  = bits_in  + stride_in  * (h_in - 1 - y_in) + 4 * x_in;
					b += *pin++;
					g += *pin++;
					r += *pin++;
					a += *pin++;
					n++;
				}
			}
			/* ςďk̃sNZցB */
			pout  = bits_out + stride_out  * (h_out - 1 - y_out) + 4 * x_out;
			if(n != 0) {
				r = (r + n / 2) / n;
				g = (g + n / 2) / n;
				b = (b + n / 2) / n;
				a = (a + n / 2) / n;
			}
			*pout++ = b;
			*pout++ = g;
			*pout++ = r;
			*pout++ = a;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}
