/*
 *	pkkrnv - main.c
 *
 *	uirvPGDRo[^
 *	Copyright (C) 2004 Naoyuki Sawa
 *
 *	* Sat Jul 12 06:03:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "app.h"

/****************************************************************************
 *	}NE萔
 ****************************************************************************/

#define VERSION		"20040612"

#define REG_KEY		"Software\\Q-X\\ir"
#define REG_VALUE	"install"
#define EPK_NAME	"cg.epk"

#define ORIGINAL_WIDTH	640

/***** A[JCu` (*.epk) *****/

typedef struct _EPKHEAD {
	char signature[4];	/* "EPK " */
	int data_offset;	/* ŏ̃f[^Jnʒuւ̃ItZbg(A[JCu擪̐Έʒu) */
	int file_count;		/* t@C */
	int _reserved1;
} EPKHEAD;
/* ̌ EPKFILE files[file_count] ܂ */

typedef struct _EPKFILE {
	int name_offset;	/* t@Cւ̃ItZbg(A[JCu擪̐Έʒu) */
	int data_offset;	/* f[^{̂ւ̃ItZbg(A[JCu擪̐Έʒu) */
	int data_size;		/* f[^{̂̃TCY */
	int _reserved1;
} EPKFILE;

/***** t@C` ("EZip") *****/

/* EPKA[JCuɊi[Ăet@CłB
 * EZIPHEAD̑OɁAVOl`"EGD "ɑ݂܂B
 */
typedef struct _EZIPHEAD {
	char signature[4];	/* "EZip" */
	int compressed_size;	/* kf[^TCY */
	int uncompressed_size;	/* WJf[^TCY */
	int _reserved1;
} EZIPHEAD;
/* ̌Zlibkf[^܂B */

/***** t@C` ("EDib") *****/

/* EZipt@CWJƂłARGBArbg}bvłB
 */
typedef struct _EDIBHEAD {
	char signature[4];	/* "EDib" */
	int width;		/*   [sNZ] */
	int height;		/* [sNZ] */
	int _reserved1;
} EDIBHEAD;
/* ̌ unsigned char pixel[4 * width * head] ܂B */

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

char app_dir[_MAX_PATH];	/* uirṽCXg[tH_ */
char extract_name[_MAX_PATH];	/* ot@C("S001"Ȃ)A܂͑SWJ("*") */

int opt_bmp;			/* BMPo(eXgp) */
int opt_chr;			/* G[h(؂) */
int opt_all;			/* ot@C"*"w肳ꂽ1ɂȂ܂ */

/****************************************************************************
 *	֐錾
 ****************************************************************************/

void err(const char* fmt, ...);
void usage();
void extract();
BITMAPFILEHEADER* make_bitmap(const char* data);
unsigned char* bmp32to8(unsigned char* in_buf);
unsigned char* reduce(unsigned char* in_buf);

/****************************************************************************
 *	err
 ****************************************************************************/

void
err(const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);

	exit(1);
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "pkkrnv - uir(Q-X)vPGDRo[^(%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2004 Naoyuki Sawa\n");
	fprintf(stderr, "gF\n");
	fprintf(stderr, "  pkkrnv [options] <file-name>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "  t@CɁu*vƎw肷ƁAo\ȑSẴt@C𒊏o܂B\n");
	fprintf(stderr, "  <> pkkrnv -b *\n");
	fprintf(stderr, "       SẴt@CBMPt@CƂĒo܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "IvVF\n");
	fprintf(stderr, "  -b        -b2ƓłB\n");
	fprintf(stderr, "  -b1       rbg}bvt@Ĉ܂܏o͂܂B\n");
	fprintf(stderr, "  -b2       rbg}bvt@Ckďo͂܂B\n");
	fprintf(stderr, "  -b3       rbg}bvt@CkEFďo͂܂B\n");
	fprintf(stderr, "  -b/-b1/-b2/-b3̂ǂw肵Ȃ΁APGDt@Co͂܂B\n");
	fprintf(stderr, "  -c        kAcɂ͂ݏoꍇ́A؂܂B\n");
	fprintf(stderr, "  -d<path>  uirvtH_w(l=WXg擾)\n");
	exit(1);
}

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int retval, i, n;
	char* p;
	HKEY hKey;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		p = argv[i];
		if(p[0] == '-') { /* IvV */
			switch(p[1]) {
			case 'b': /* BMPo */
				if(opt_bmp) usage(); /* dw */
				if(p[2]) {
					opt_bmp = p[2] - '0';
				} else {
					opt_bmp = 2; /* -b݂̂Ȃ2 */
				}
				if(opt_bmp < 1 || 3 < opt_bmp) usage();
				break;
			case 'c': /* G[h */
				if(opt_chr) usage(); /* dw */
				opt_chr = 1;
				break;
			case 'd': /* uirvCXg[tH_w */
				if(strlen(app_dir) != 0) usage(); /* dw */
				strncpy(app_dir, &p[2], sizeof app_dir);
				break;
			default:
				usage();
			}
		} else {
			/* ot@C */
			if(strlen(extract_name) != 0) usage(); /* dw */
			strncpy(extract_name, p, sizeof extract_name);
		}
	}

	/* ot@CB */
	if(strlen(extract_name) == 0) usage();
	if(strcmp(extract_name, "*") == 0) opt_all = 1; /* SWJ? */

	/* uirvCXg[tH_𒲂ׂ܂B */
	if(strlen(app_dir) == 0) {
		retval = RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY, 0, KEY_QUERY_VALUE, &hKey);
		if(retval == 0) {
			n = sizeof app_dir;
			retval = RegQueryValueEx(hKey, REG_VALUE, 0, NULL, (unsigned char*)app_dir, (unsigned long*)&n);
			RegCloseKey(hKey);
		}
		if(retval != 0) err("uirvCXg[ĂȂ悤łB");
	}

	/* t@CWJB */
	extract();

	return 0;
}

/****************************************************************************
 *	extract
 ****************************************************************************/

void
extract()
{
	int retval;
	int done;
	int i_file;
	FILE* fp_in;
	FILE* fp_out;
	char* file_path;
	char epk_path[_MAX_PATH];
	char bmp_path[_MAX_PATH];
	char file_fname[_MAX_FNAME];
	char cmd[_MAX_PATH];
	unsigned char* head_buffer;
	unsigned char* data_buffer;
	EPKHEAD head;
	EPKFILE file;
	BITMAPFILEHEADER* bf;

	done = 0; /* PƓWJAwt@CWJ1ɂȂ܂ */

	/* A[JCut@CJ܂B */
	_makepath(epk_path, NULL, app_dir, EPK_NAME, NULL);
	fp_in = fopen(epk_path, "rb");
	if(!fp_in) err("%s: t@CJ܂B", epk_path);

	/* ܂AA[JCuwb_ǂݍł݂܂B */
	retval = fread(&head, sizeof(EPKHEAD), 1, fp_in);
	if(retval != 1) err("%s: A[JCuwb_ǂݍ߂܂B", epk_path);

	/* VOl`܂B */
	if(memcmp(head.signature, "EPK ", 4) != 0) err("%s: VOl`słB", epk_path);

	/* A[JCuwb_ƃt@CSēǂݍނ߂́Amۂ܂B */
	head_buffer = (unsigned char*)calloc(head.data_offset, 1);
	if(!head_buffer) err("%s: słB", epk_path);

	/* A[JCuwb_ƃt@CSēǂݍ݂܂B */
	rewind(fp_in); /* A[JCuwb_xǂ!! */
	retval = fread(head_buffer, 1, head.data_offset, fp_in);
	if(retval != head.data_offset) err("%s: A[JCuwb_ƃt@C񂪓ǂݍ߂܂B", epk_path);

	/* et@Cɂ... */
	for(i_file = 0; !done && i_file < head.file_count; i_file++) {
		memcpy(&file, &head_buffer[sizeof(EPKHEAD) + sizeof(EPKFILE) * i_file], sizeof(EPKFILE));
		file_path = (char*)&head_buffer[file.name_offset];

		/* t@C͑΃pX()ƊgqtȂ̂ŁAx[X𒊏o܂B */
		_splitpath(file_path, NULL, NULL, file_fname, NULL);

		/* SWJA܂͎wt@CɈv... */
		if(opt_all || strcmpi(file_fname, extract_name) == 0) {

			/* SWJȂÃt@C\܂B */
			if(opt_all) printf("%4d: %s\n", i_file, file_path);

			/* f[^{̂ǂݍނ߂̃obt@mۂ܂B */
			data_buffer = (unsigned char*)calloc(file.data_size, 1);
			if(!data_buffer) err("%s: słB", file_path);

			/* f[^{̈ʒuփV[N܂B */
			retval = fseek(fp_in, file.data_offset, SEEK_SET);
			if(retval != 0) err("%s: V[NG[łB", file_path);

			/* f[^{̂ǂݍ݂܂B */
			retval = fread(data_buffer, 1, file.data_size, fp_in);
			if(retval != file.data_size) err("%s: f[^{̂ǂݍ߂܂B", file_path);

			/* sVOl`܂B */
			if(memcmp(data_buffer, "EGD ", 4) != 0) err("%s: VOl`słB", file_path);

			/* rbg}bvWJ܂B */
			bf = make_bitmap(&data_buffer[4]);
			if(!bf) err("%s: rbg}bvWJɎs܂B", file_path);

			if(opt_bmp == 1) goto L10;	/* BMPo͂ */

			/* kB */
			bf = (BITMAPFILEHEADER*)reduce((unsigned char*)bf);

			if(opt_bmp == 2) goto L10;	/* BMPo͂ */

			/* OCXP[ϊB */
			bf = (BITMAPFILEHEADER*)bmp32to8((unsigned char*)bf);
L10:
			/* rbg}bvo͂܂B */
			_makepath(bmp_path, NULL, NULL, file_fname, ".bmp");
			fp_out = fopen(bmp_path, "wb");
			retval = fwrite(bf, 1, bf->bfSize, fp_out);
			if(retval != (int)bf->bfSize) err("%s: rbg}bvo͂Ɏs܂B", bmp_path);
			fclose(fp_out);

			/* PGDϊB */
			if(opt_bmp == 0) {
				if(opt_chr) {	/* G: 2bit}XNt */
					sprintf(cmd, "dpbmpcnv -q -b -f2m \"%s\"", bmp_path); /* -qKv! */
				} else {	/* wi: 2bit}XN */
					sprintf(cmd, "dpbmpcnv -q -b -f2  \"%s\"", bmp_path); /* -qKv! */
				}
				if(system(cmd) != 0) err("%s: PGDϊɎs܂B", bmp_path);
				remove(bmp_path); /* BMP͂Ȃ̂ō폜 */
			}

			/* rbg}bvJ܂B */
			free(bf);

			/* f[^{̂ǂݍ񂾃obt@J܂B */
			free(data_buffer);

			/* PƓWJȂA}[NB */
			if(!opt_all) done = 1;
		}
	}

	/* A[JCuwb_ƃt@Cǂݍ񂾃obt@J܂B */
	free(head_buffer);

	/* PƓWJŁAw肳ꂽGgȂ΁AG[B */
	if(!opt_all && !done) err("%s܂B", extract_name);
}

/****************************************************************************
 *	make_bitmap
 ****************************************************************************/

BITMAPFILEHEADER*
make_bitmap(const char* data)
{
	unsigned char* uncompress_buffer = NULL;
	BITMAPFILEHEADER* bf = NULL;
	//
	int retval;
	int size;
	int x;
	int y;
	int b;
	int g;
	int r;
	int a;
	EZIPHEAD* ezip_head;
	EDIBHEAD* edib_head;
	BITMAPINFOHEADER* bi;
	unsigned char* pixel_in;
	unsigned char* pixel_out;

	/***** EZipWJ *****/

	ezip_head = (EZIPHEAD*)data;   /* wb_... */
	data += sizeof(EZIPHEAD); /* ̒Ɉkf[^{̂܂ */

	/* VOl`܂B */
	if(memcmp(ezip_head->signature, "EZip", 4) != 0) goto L_ERR;

	/* WJobt@mۂ܂B */
	uncompress_buffer = (unsigned char*)calloc(ezip_head->uncompressed_size, 1);
	if(!uncompress_buffer) goto L_ERR;

	/* WJ܂B */
	retval = pzlib_uncompress(uncompress_buffer, ezip_head->uncompressed_size, data, ezip_head->compressed_size);
	if(retval != ezip_head->uncompressed_size) goto L_ERR;

	/***** EDibWJ *****/

	edib_head = (EDIBHEAD*)uncompress_buffer;
	pixel_in = uncompress_buffer + sizeof(EDIBHEAD);

	/* VOl`܂B */
	if(memcmp(edib_head->signature, "EDib", 4) != 0) goto L_ERR;

	/* rbg}bvpmۂ܂B */
	size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + 4 * edib_head->width * edib_head->height;
	bf = (BITMAPFILEHEADER*)calloc(size, 1);
	if(!bf) goto L_ERR;
	bi = (BITMAPINFOHEADER*)(bf + 1);
	pixel_out = (unsigned char*)(bi + 1);

	/* rbg}bvt@Cwb_쐬܂B */
	bf->bfType = 'MB';
	bf->bfSize = size;
	bf->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	/* rbg}bvwb_쐬܂B */
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = edib_head->width;
	bi->biHeight = edib_head->height;
	bi->biPlanes = 1;
	bi->biBitCount = 32;

	/* sNZf[^i[܂B */
	for(y = 0; y < edib_head->height; y++) {
		for(x = 0; x < edib_head->width; x++) {
			/* NOTE: LG̓ߕ͕KOł͂ȂA\S~cĂ܂B
			 *   ̒lɏ̂ŁAQ[ʏł͋CtȂ̂Ǝv܂B
			 *   /񓧉߂2lϊꍇ̓̂l16xɂKv邩m܂B
			 */
			b = *pixel_in++;
			g = *pixel_in++;
			r = *pixel_in++;
			a = *pixel_in++;
			*pixel_out++ = b;
			*pixel_out++ = g;
			*pixel_out++ = r;
			*pixel_out++ = a;
		}
	}

	return bf;
L_ERR:
	free(bf);
	free(uncompress_buffer);
	return NULL;
}

/****************************************************************************
 *	bmp32to8
 ****************************************************************************/

const int DITHER[8][8] = {
         0,32, 8,40, 2,34,10,42,
        48,16,56,24,50,18,58,26,
        12,44, 4,36,14,46, 6,38,
        60,28,52,20,62,30,54,22,
         3,35,11,43, 1,33, 9,41,
        51,19,59,27,49,17,57,25,
        15,47, 7,39,13,45, 5,37,
        63,31,55,23,61,29,53,21,
};

unsigned char*
bmp32to8(unsigned char* in_buf)
{
	int w, h, x, y, r, g, b, a, c;

	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	RGBQUAD* rgb_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w = bi_in->biWidth;
	h = bi_in->biHeight;
	stride_in = 4 * w;

	/* o̓rbg}bv쐬B */
	stride_out = (w + 3) & ~3;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 + stride_out * h;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	rgb_out  = (RGBQUAD         *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256);

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w;
	bi_out->biHeight = h;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 8;

	for(c = 0; c < 4; c++) {
		rgb_out[c].rgbRed       = 85 * (3 - c);
		rgb_out[c].rgbGreen     = 85 * (3 - c);
		rgb_out[c].rgbBlue      = 85 * (3 - c);
		rgb_out[c].rgbReserved  = 0;
	}
	for(c = 4; c < 256; c++) {
		rgb_out[c].rgbRed       = 0;
		rgb_out[c].rgbGreen     = 255;
		rgb_out[c].rgbBlue      = 0;
		rgb_out[c].rgbReserved  = 0;
	}

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			pin  = bits_in  + stride_in  * (h - 1 - y) + 4 * x;
			pout = bits_out + stride_out * (h - 1 - y) + 1 * x;
			;
			b = *pin++;
			g = *pin++;
			r = *pin++;
			a = *pin++;
			;
			if(a >= 16/*uirvł́ALG̓ߕɃS~̂ŁAl߂ɂKv*/) {
				c = (r * 3 + g * 5 + b * 2) / 10;
				c = (c + DITHER[y & 7][x & 7] + (85 - 63) / 2) / 85;
				if(c > 3) c = 3;
				c = 3 - c;
			} else {
				c = 4;
			}
			;
			*pout++ = c;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	reduce
 ****************************************************************************/

#define WIDTH_LIMIT	128
#define HEIGHT_LIMIT	 88

unsigned char*
reduce(unsigned char* in_buf)
{
	int x_in, y_in, x_out, y_out, r, g, b, a, n, x_base, y_base;
	double REDUCE_LEVEL;

	int w_in;
	int h_in;
	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	int w_out;
	int h_out;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w_in = bi_in->biWidth;
	h_in = bi_in->biHeight;
	stride_in = 4 * w_in;

	/* G[h͔䗦ŒB */
	if(opt_chr) {
		REDUCE_LEVEL = (float)ORIGINAL_WIDTH / WIDTH_LIMIT;
	/* wi[h͔䗦ρB */
	} else {
		double rl1 = (double)w_in / WIDTH_LIMIT;
		double rl2 = (double)h_in / HEIGHT_LIMIT;
		REDUCE_LEVEL = rl1 <= rl2 ? rl1 : rl2; /* ʂςɂȂ悤 */
	}

	/* o̓rbg}bv쐬B */
	w_out = (int)(w_in / REDUCE_LEVEL);
	h_out = (int)(h_in / REDUCE_LEVEL);
	x_base = 0;
	y_base = 0;
	if(w_out > WIDTH_LIMIT) {
		x_base = (int)((w_out - WIDTH_LIMIT) / 2 * REDUCE_LEVEL);
		w_out = WIDTH_LIMIT;
	}
	if(h_out > HEIGHT_LIMIT) {
		if(!opt_chr) y_base = (int)((h_out - HEIGHT_LIMIT) / 2 * REDUCE_LEVEL);
		h_out = HEIGHT_LIMIT;
	}
	stride_out = 4 * w_out;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + stride_out * h_out;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w_out;
	bi_out->biHeight = h_out;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 32;

	/* kB */
	for(y_out = 0; y_out < h_out; y_out++) {
		for(x_out = 0; x_out < w_out; x_out++) {
			/* k̃sNZZB */
			r = 0;
			g = 0;
			b = 0;
			a = 0;
			n = 0;
			for(y_in = y_base + (int)(y_out * REDUCE_LEVEL); y_in < y_base + (int)((y_out + 1) * REDUCE_LEVEL); y_in++) {
				if(y_in < 0 || h_in - 1 < y_in) continue;
				for(x_in = x_base + (int)(x_out * REDUCE_LEVEL); x_in < x_base + (int)((x_out + 1) * REDUCE_LEVEL); x_in++) {
					if(x_in < 0 || w_in - 1 < x_in) continue;
					pin  = bits_in  + stride_in  * (h_in - 1 - y_in) + 4 * x_in;
					b += *pin++;
					g += *pin++;
					r += *pin++;
					a += *pin++;
					n++;
				}
			}
			/* ςďk̃sNZցB */
			pout  = bits_out + stride_out  * (h_out - 1 - y_out) + 4 * x_out;
			if(n != 0) {
				r = (r + n / 2) / n;
				g = (g + n / 2) / n;
				b = (b + n / 2) / n;
				a = (a + n / 2) / n;
			}
			*pout++ = b;
			*pout++ = g;
			*pout++ = r;
			*pout++ = a;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

