/*
 *	main.c
 *
 *	modsmpl - Mod Plug Tracker Tvgϊc[
 *	Copyright (C) 2003 Naoyuki Sawa <nsawa@north.hokkai.net>
 *
 *	* Sun Feb 02 19:41:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Feb 02 22:17:00 JST 2003 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Feb 03 05:31:00 JST 2003 Naoyuki Sawa
 *	- o̓t@CȗɁAy햼o̓t@CƂ@\ǉB
 *	* Sun Feb 03 12:30:00 JST 2003 Naoyuki Sawa
 *	- o͎gϓ̃IvVǉB
 *	* Sun Feb 03 20:00:00 JST 2003 Naoyuki Sawa
 *	- y햼t@CƂAu.vȂǂu_vɒu悤CB
 *	* Sun Feb 03 21:00:00 JST 2003 Naoyuki Sawa
 *	- GNXehIN^[u(c-0`b-0Ac-4`b-4)ɑΉ܂B
 */
#define STRICT
#include <windows.h>
#include <mmreg.h>
#include <msacm.h>
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "msacm32.lib")

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <conio.h>

#define VERSION	"20030203c"

/****************************************************************************
 *
 ****************************************************************************/

#if 0 //̏͂ÂłBt@CwȂǁAς܂B
gF
PDMod Plug TrackerN܂B
QD[File][New][IT]ŋITt@C쐬܂B
RDuSamplesv^uNbNāASamplesʂɂ܂B
SDyĆuGM.DLSvAFSamplesɃhbv܂B
@@܂́ACӂ̉Ft@CJ܂B
TDSamplesʂ̍ɂۑACRŁAFWAVt@Cɕۑ܂B
UDMod Plug TrackerI܂B
VD̎_ł́AWAVt@C̎g͂܂܂ŁA
@@̂܂MODt@C̉FƂĎgƁAĂ܂܂B
WDŁÃc[gāAWAVt@CC-2̎gɕϊ܂B
XDR}hCA

@@@@modsmpl قǕۑt@C.wav [ϊ̃t@C.wav]

@@̂悤Ƀ^CvĂB
@@iϊ̃t@CȗƁAWAVt@C̊y햼gp܂j
10DMod Plug TrackerN܂B
11D[File][New][MOD]ŋMODt@C쐬܂B
@@܂́AMODt@CJ܂B
12DuSamplesv^uNbNāASamplesʂɂ܂B
13DقǕϊt@CASampleʂɃhbv܂B

ȏłB̉F[v܂łȂA[v܂B
#endif

/****************************************************************************
 *
 ****************************************************************************/

#if 0
Mod Plug TrackerŃTvWAVۑƂɁA
WAVt@Cɐsmpl`N̓ełB
̃`N΁ATrackerWAVt@C烋[v𕜌܂B

-----------------------------------------------------------------------------
[vȂsapl`NeF
`NTCÝA0x24oCgłB

0   0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
1  00 00 00 00 00 00 00 00 E9 EE 02 00 3C 00 00 00  ... (sA0NAĂȂ悤ł)
2  00 00 00 00 00 00 00 00 00 00 00 00[00 00 00 00]  ... [vȂ
3  00 00 00 00

-----------------------------------------------------------------------------
[v莞sapl`NeF
`NTCÝA0x3coCgłB

    0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
0  00 00 00 00 00 00 00 00 D5 DE 00 00 3C 00 00 00  ... (sA0NAĂȂ悤ł)
1  00 00 00 00 00 00 00 00 00 00 00 00[01 00 00 00] ... [v
2  00 00 00 00 00 00 00 00 00 00 00 00[33 00 00 00] ... [vJnʒu
3 [76 00 00 00]00 00 00 00 00 00 00 00              ... [vIʒu

-----------------------------------------------------------------------------
#endif

/****************************************************************************
 *
 ****************************************************************************/

/* smpl`N̍\ */
typedef struct _SMPL {
	int unk1[7];
	int loop;	/* 0:[vȂ/1:[v */
	int unk2[3];	/* [vȂunk2[0]܂łŏI */
	int start;	/* [vJnʒu */
	int end;	/* [vIʒu */
	int unk3[2];
} SMPL;

typedef struct _WAV {
	/* --- RIFF.WAVE --- */
	/* fmt */
	int c_fmt;
	WAVEFORMATEX* fmt;
	/* data */
	int c_data;
	unsigned char* data;
	/* smpl */
	int c_smpl;
	SMPL* smpl;
	/* --- LIST.INFO --- */
	/* INAM */
	int c_inam;
	char* inam;	/* y햼 */
	/* ISFT */	/* \tg(ModPlugTracker) */
	/* xtra */	/* HHH */
} WAV;

/* ƑΉsIhl */
char* note_name_tbl[] = {
"c-0","c#0","d-0","d#0","e-0","f-0","f#0","g-0","g#0","a-0","a#0","b-0",
"c-1","c#1","d-1","d#1","e-1","f-1","f#1","g-1","g#1","a-1","a#1","b-1",
"c-2","c#2","d-2","d#2","e-2","f-2","f#2","g-2","g#2","a-2","a#2","b-2",
"c-3","c#3","d-3","d#3","e-3","f-3","f#3","g-3","g#3","a-3","a#3","b-3",
"c-4","c#4","d-4","d#4","e-4","f-4","f#4","g-4","g#4","a-4","a#4","b-4",
NULL
};
int period_tbl[] = {
1712,1616,1524,1440,1356,1280,1208,1140,1076,1016,960,906,
 856, 808, 762, 720, 678, 640, 604, 570, 538, 508,480,453,
 428, 404, 381, 360, 339, 320, 302, 285, 269, 254,240,226,
 214, 202, 190, 180, 170, 160, 151, 143, 135, 127,120,113,
 107, 101,  95,  90,  85,  80,  75,  71,  67,  63, 60, 56,
0
};

/* AmigaPAL{NbN = 7093789.2
 * C-2̃sIhl = 428 (MODdl)
 * o͎g = {NbN / (sIhl * 2)
 *            = 7093789.2 / (428 * 2)
 * o͉C-2Ƃꍇ̗łB
 */
#define AMIGA_FREQ	7093789.2
#define MOD_BITS	8
#define MOD_CHANS	1

void die(const char* fmt, ...);
WAV* load_wav(const unsigned char* fname);
void save_wav(const WAV* wav, const unsigned char* fname);
void wav_to_wav(WAV* wav1, WAV* wav2);

WAV* wav1;
WAV* wav2;
int mod_period;	/* snote_namevZ */
int mod_freq;	/* smod_periodvZ */

/* R}hCw\ȃp[^̏l */
char in_path[_MAX_PATH];	/* ̓t@C */
char out_path[_MAX_PATH];	/* o̓t@C */
char note_name[256] = "c-2";	/* o͉ */
FILE* msg = stdout;		/* bZ[Wo͐ */
int overwrite = 0;		/* ₢킹Ȃŏ㏑ */

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr,
"modsmpl - Mod Plug Tracker Tvgϊc[ ("VERSION")\n"
"Copyright (C) 2003 Naoyuki Sawa <nsawa@north.hokkai.net>\n"
"\n"
"USAGE:\n"
"    modsmpl [options] <filename[.wav]>\n"
"\n"
"OPTIONS:\n"
"    -o<fname>  o̓t@C\n"
"               o̓t@Cw肵Ȃ΁Auy햼.wavvƂȂ܂B\n"
"    -n<note>   o͉ic-0,c#0,d-0,...b-4j\n"
"               o͉w肵Ȃ΁Auc-2vƂȂ܂B\n"
"               Trackerł̉ŔẢƓɂȂ܂B\n"
"               o͉ႭقǁATrackerł͍ɑΉł܂B\n"
"               o͉قǁATrackerł͒ႢɑΉł܂B\n"
"    -f         o͐t@C݂ĂA₢킹Ȃŏ㏑܂B\n"
"    -q         bZ[W}\n"
	);
	exit(1);
}

/****************************************************************************
 *	cmdline
 ****************************************************************************/

void
cmdline(int argc, char* argv[])
{
	int i;
	char* opt;
	char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

	for(i = 1; i < argc; i++) {
		opt = argv[i];
		if(opt[0] != '-') {
			/* ̓t@C */
			if(strlen(in_path) != 0) usage(); /* dw */
			strcpy(in_path, opt);
		} else {
			switch(opt[1]) {
			/* o̓t@C */
			case 'o':
				if(strlen(out_path) != 0) usage(); /* dw */
				strcpy(out_path, &opt[2]);
				break;
			/* o͉ */
			case 'n':
				strcpy(note_name, &opt[2]);
				break;
			/* ₢킹Ȃŏ㏑ */
			case 'f':
				overwrite = 1;
				break;
			/* bZ[W} */
			case 'q':
				msg = fopen("NUL", "wt");
				break;
			default:
				usage();
			}
		}
	}

	/* ̓t@C͕K{łB */
	if(strlen(in_path) == 0) usage();

	/* ̓t@C̊gqȗĂAu.wavvƂ܂B */
	_splitpath(in_path, drive, dir, fname, ext);
	if(strlen(ext) == 0) {
		_makepath(in_path, drive, dir, fname, ".wav");
	}
}

/****************************************************************************
 *
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int len, i;
	char* p;
	char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
	struct _stat st;

	/* R}hĆB */
	cmdline(argc, argv);

	/* o͉sIhl߂܂B */
	i = 0;
	for(;;) {
		if(note_name_tbl[i] == NULL) die("o͉słB");
		if(strcmpi(note_name_tbl[i], note_name) == 0) {
			mod_period = period_tbl[i];
			break;
		}
		i++;
	}
	/* sIhlo͎g߂܂B */
	mod_freq = (int)(AMIGA_FREQ / (mod_period * 2));

	/* WAVt@Cǂݍ݁B */
	/*      OPQRSTUV */
	wav1 = load_wav(in_path);

	/* ϊ̃tH[}bg쐬܂B
	 * iMod Plug Trackeȑo͌`͕KjAPCM`Ȃ̂ŁAiKϊ͍l܂j
	 */
	if(wav1->fmt->wFormatTag != WAVE_FORMAT_PCM) die("͌`WAVE_FORMAT_PCMł܂B");
	wav2 = (WAV*)calloc(sizeof(WAV), 1);
	if(wav2 == NULL) die("słB");
	wav2->c_fmt = wav1->c_fmt;
	wav2->fmt = (WAVEFORMATEX*)calloc(1, wav2->c_fmt);
	if(wav2->fmt == NULL) die("słB");
	memcpy(wav2->fmt, wav1->fmt, wav2->c_fmt);
	wav2->fmt->nChannels = MOD_CHANS;
	wav2->fmt->nSamplesPerSec = mod_freq;
	wav2->fmt->nAvgBytesPerSec = mod_freq * (MOD_BITS / 8);
	wav2->fmt->nBlockAlign = (MOD_BITS / 8) * MOD_CHANS;
	wav2->fmt->wBitsPerSample = MOD_BITS;

	/* ϊsB */
	wav_to_wav(wav1, wav2);

	/* mmioAPIgWAVt@C쐬ƁAe`NoCg̏ꍇAɃ[pfBO悤łB
	 * mmioAPIgēǂݍ߂΁Ã[͂Ɠǂݔ΂̂łAMod Plug TrackermmioAPIgĂȂ悤ŁA
	 * pfBǑ̃`Nǂݍ܂܂B
	 * ꂪɂȂ̂́Ao̓Tv̏ꍇAdata`NTCYɂȂāǍsmpl`NƂ̊Ԃ
	 * 1oCg̃pfBOĂ܂ꍇłB
	 * Mod Plug Tracker̓pfBǑ̃`NFłAsmpl`NȂ̂Ƃ݂ȂA[v񂪎Ă܂܂B
	 * ̖邽߁Ao̓Tv̏ꍇ͋ɐ؂̂ĂāAdata`NTCYɕۂ悤ɂ܂B
	 */
	wav2->c_data &= ~1;

	/* ϊ̃Tv쐬܂B */
	if(wav1->c_smpl >= sizeof(SMPL) && wav1->smpl->loop) { /* ̓t@C[v̏ꍇ̂݁Asmpl`No */
		wav2->c_smpl = wav1->c_smpl;
		wav2->smpl = (SMPL*)calloc(1, wav2->c_smpl);
		if(wav2->smpl == NULL) die("słB");
		memcpy(wav2->smpl, wav1->smpl, wav2->c_smpl);
		wav2->smpl->start = wav1->smpl->start * wav2->fmt->nSamplesPerSec / wav1->fmt->nSamplesPerSec;
		wav2->smpl->end   = wav1->smpl->end   * wav2->fmt->nSamplesPerSec / wav1->fmt->nSamplesPerSec;
		len = wav2->c_data / ((MOD_BITS / 8) * MOD_CHANS);
		if(wav2->smpl->start > len) wav2->smpl->start = len; /* [vʒuI[𒴂Ȃ悤 */
		if(wav2->smpl->end   > len) wav2->smpl->end   = len;
	}

	/* o̓t@CȗĂAy햼g܂B */
	if(strlen(out_path) == 0) {
		if(wav1->c_inam == 0) die("y햼܂Bo̓t@Cw肵ĂB");
		memset(fname, 0, sizeof fname);
		strncpy(fname, wav1->inam, wav1->c_inam);
		p = fname;
		while(isspace(*p)) p++; /* g */
		i = strlen(p) - 1;      /* Eg */
		while(i >= 0) {
			if(!isspace(p[i])) break;
			p[i--] = '\0';
		}
		if(i < 0) die("y햼łBo̓t@Cw肵ĂB");
		strncpy(out_path, p, sizeof out_path);
		/* y햼ɃAt@xbgƐȊO܂܂ĂAu_vɒu܂B */
		for(p = out_path; *p != '\0'; p++) {
			if(!isalnum(*p)) *p = '_';
		}
	}
	/* o̓t@C̊gqȗĂAu.wavvƂ܂B */
	_splitpath(out_path, drive, dir, fname, ext);
	if(strlen(ext) == 0) {
		_makepath(out_path, drive, dir, fname, ".wav");
	}

	/* \B */
	fprintf(msg, "̓t@C@@F%s\n", in_path);
	fprintf(msg, "͎g@@@F%d\n", wav1->fmt->nSamplesPerSec);
	if(wav1->c_inam != 0) {
	fprintf(msg, "y햼F@@@@Fu%sv\n", wav1->inam);
	} else {
	fprintf(msg, "y햼F@@@@FȂ\n");
	}
	if(wav1->c_smpl >= sizeof(SMPL) && wav1->smpl->loop) {
	fprintf(msg, "̓[vʒu@F(%d,%d)\n", wav1->smpl->start, wav1->smpl->end);
	} else {
	fprintf(msg, "̓[vʒu@FȂ\n");
	}
	fprintf(msg, "\n");
	fprintf(msg, "o̓t@C@@F%s\n", out_path);
	fprintf(msg, "o͉@@@@F%s\n", note_name);
	fprintf(msg, "sIhl@@@F%d\n", mod_period);
	fprintf(msg, "o͎g@@@F%d\n", mod_freq);
	if(wav2->c_smpl >= sizeof(SMPL) && wav2->smpl->loop) {
	fprintf(msg, "o̓[vʒu@F(%d,%d)\n", wav2->smpl->start, wav2->smpl->end);
	} else {
	fprintf(msg, "o̓[vʒu@FȂ\n");
	}
	fprintf(msg, "\n");

	/* ㏑B */
	if(!overwrite && _stat(out_path, &st) == 0) {
		fprintf(stderr, "o͐̃t@Cɑ݂܂B㏑܂H[y/N] ");
		/* vӁIu_tolower()vgƁA_tolower('y')'y'ɂȂ܂BȂIH
		 *           utolower()vgƁI
		 */
		if(tolower(getche()) != 'y') die("f܂B");
		fprintf(stderr, "\n");
	}

	/* WAVt@C݁B */
	save_wav(wav2, out_path);

	printf("I܂B\n");
	return 0;
}

/****************************************************************************
 *	die
 ****************************************************************************/

void
die(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
	exit(1);
}

/****************************************************************************
 *
 ****************************************************************************/

WAV*
load_wav(const unsigned char* fname)
{
	int retval;
	WAV* wav;
	HMMIO mmio;
	MMCKINFO ck1, ck2, ck3;

	/* WAV\̂쐬܂B */
	wav = (WAV*)calloc(sizeof(WAV), 1);
	if(wav == NULL) die("słB");

	/* WAVt@CJ܂B */
	mmio = mmioOpen((char*)fname, NULL, MMIO_READ);
	if(mmio == NULL) die("%sJ܂B", fname);

	/* RIFF:WAVE`Nɓ܂B */
	memset(&ck1, 0, sizeof(MMCKINFO));
	ck1.ckid    = mmioStringToFOURCC("RIFF", 0); /* MMIO_FINDRIFF́Ackif̎w͏ȗ\ */
	ck1.fccType = mmioStringToFOURCC("WAVE", 0);
	retval = mmioDescend(mmio, &ck1, NULL, MMIO_FINDRIFF);
	if(retval != 0) die("RIFF`N܂B");

	/* fmt`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("fmt", 0);
	retval = mmioDescend(mmio, &ck2, &ck1, MMIO_FINDCHUNK);
	if(retval != 0) die("fmt`N܂B");

	/* tH[}bgǂݍ݂܂B */
	wav->c_fmt = ck2.cksize;
	wav->fmt = (WAVEFORMATEX*)calloc(wav->c_fmt, 1);
	if(wav->fmt == NULL) die("słB");
	retval = mmioRead(mmio, (char*)wav->fmt, wav->c_fmt);
	if(retval != (int)wav->c_fmt) die("tH[}bgǂݍ߂܂B");

	/* fmt`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* data`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("data", 0);
	retval = mmioDescend(mmio, &ck2, &ck1, MMIO_FINDCHUNK);
	if(retval != 0) die("data`N܂B");

	/* f[^ǂݍ݂܂B */
	wav->c_data = ck2.cksize;
	wav->data = (char*)calloc(wav->c_data, 1);
	if(wav->data == NULL) die("słB");
	retval = mmioRead(mmio, wav->data, wav->c_data);
	if(retval != wav->c_data) die("f[^ǂݍ߂܂B");

	/* data`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* smpl`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("smpl", 0);
	retval = mmioDescend(mmio, &ck2, &ck1, MMIO_FINDCHUNK);
	if(retval == 0) { /* ȂΓǂ܂Ȃ */
		/* Tvǂݍ݂܂B */
		wav->c_smpl = ck2.cksize;
		wav->smpl = (SMPL*)calloc(wav->c_smpl, 1);
		if(wav->smpl == NULL) die("słB");
		retval = mmioRead(mmio, (char*)wav->smpl, wav->c_smpl);
		if(retval != wav->c_smpl) die("Tv񂪓ǂݍ߂܂B");

		/* smpl`N𔲂܂B */
		retval = mmioAscend(mmio, &ck2, 0);
		if(retval != 0) die("mmioAscend()s܂B");
	}

	/* LIST:INFO`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid    = mmioStringToFOURCC("LIST", 0); /* MMIO_FINDLIST́Ackif̎w͏ȗ\ */
	ck2.fccType = mmioStringToFOURCC("INFO", 0);
	retval = mmioDescend(mmio, &ck2, NULL, MMIO_FINDLIST);
	if(retval == 0) { /* ȂΓǂ܂Ȃ */
		/* INAM`Nɓ܂B */
		memset(&ck3, 0, sizeof(MMCKINFO));
		ck3.ckid = mmioStringToFOURCC("INAM", 0);
		retval = mmioDescend(mmio, &ck3, &ck1, MMIO_FINDCHUNK);
		if(retval == 0) { /* ȂΓǂ܂Ȃ */
			/* y햼ǂݍ݂܂B */
			wav->c_inam = ck3.cksize;
			wav->inam = (char*)calloc(wav->c_inam, 1);
			if(wav->inam == NULL) die("słB");
			retval = mmioRead(mmio, wav->inam, wav->c_inam);
			if(retval != wav->c_inam) die("y햼ǂݍ߂܂B");

			/* INAM`N𔲂܂B */
			retval = mmioAscend(mmio, &ck3, 0);
			if(retval != 0) die("mmioAscend()s܂B");
		}
		/* LIST`N𔲂܂B */
		retval = mmioAscend(mmio, &ck2, 0);
		if(retval != 0) die("mmioAscend()s܂B");
	}

	/* RIFF`N𔲂܂B */
	retval = mmioAscend(mmio, &ck1, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* WAVt@C܂B */
	retval = mmioClose(mmio, 0);
	if(retval != 0) die("mmioClose()s܂B");

	return wav;
}

/****************************************************************************
 *
 ****************************************************************************/

void
save_wav(const WAV* wav, const unsigned char* fname)
{
	int retval;
	HMMIO mmio;
	MMCKINFO ck1, ck2;

	/* WAVt@C쐬܂B */
	mmio = mmioOpen((char*)fname, NULL, MMIO_CREATE | MMIO_WRITE); /* MMIO_WRITEK{IMMIO_CREATEł̓`N쐬ɃG[ɂȂ܂ */
	if(mmio == NULL) die("%s쐬ł܂B", fname);

	/* RIFF:WAVE`N쐬܂B */
	memset(&ck1, 0, sizeof(MMCKINFO));
	ck1.ckid    = mmioStringToFOURCC("RIFF", 0);
	ck1.fccType = mmioStringToFOURCC("WAVE", 0);
	retval = mmioCreateChunk(mmio, &ck1, MMIO_CREATERIFF);
	if(retval != 0) die("RIFF`N쐬ł܂B");

	/* fmt`N쐬܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("fmt", 0);
	retval = mmioCreateChunk(mmio, &ck2, 0);
	if(retval != 0) die("fmt`N쐬ł܂B");

	/* tH[}bg݂܂B */
	retval = mmioWrite(mmio, (char*)wav->fmt, wav->c_fmt);
	if(retval != (int)wav->c_fmt) die("tH[}bg߂܂B");

	/* fmt`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* data`N쐬܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("data", 0);
	retval = mmioCreateChunk(mmio, &ck2, 0);
	if(retval != 0) die("data`N쐬ł܂B");

	/* f[^݂܂B */
	retval = mmioWrite(mmio, (char*)wav->data, wav->c_data);
	if(retval != (int)wav->c_data) die("f[^߂܂B");

	/* data`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* [v̏ꍇ̂݁Asmpl`N쐬܂B */
	if(wav->c_smpl != 0) {
		/* smpl`N쐬܂B */
		memset(&ck2, 0, sizeof(MMCKINFO));
		ck2.ckid = mmioStringToFOURCC("smpl", 0);
		retval = mmioCreateChunk(mmio, &ck2, 0);
		if(retval != 0) die("smpl`N쐬ł܂B");

		/* Tv݂܂B */
		retval = mmioWrite(mmio, (char*)wav->smpl, wav->c_smpl);
		if(retval != (int)wav->c_smpl) die("Tv񂪏߂܂B");

		/* smpl`N𔲂܂B */
		retval = mmioAscend(mmio, &ck2, 0);
		if(retval != 0) die("mmioAscend()s܂B");
	}

	/* RIFF`N𔲂܂B */
	retval = mmioAscend(mmio, &ck1, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* WAVt@C܂B */
	retval = mmioClose(mmio, 0);
	if(retval != 0) die("mmioClose()s܂B");
}

/****************************************************************************
 *	wav_to_wav
 ****************************************************************************/

#define CONVERT_UNIT	65536	/* oCgÂϊ邩H */

void
wav_to_wav(WAV* wav1, WAV* wav2)
{
	int retval, unit1, unit2, flag, ofs, len, cap;
	HACMSTREAM acm;
	ACMSTREAMHEADER stream;

	/* ACMXg[J܂B */
	retval = acmStreamOpen(&acm, NULL, wav1->fmt, wav2->fmt, NULL, 0, 0, ACM_STREAMOPENF_NONREALTIME);
	if(retval != 0) die("WAVt@C͕ϊł܂B");

	/* Xg[obt@쐬܂B */
	unit1 = (CONVERT_UNIT + (wav1->fmt->nBlockAlign - 1)) / wav1->fmt->nBlockAlign * wav1->fmt->nBlockAlign;
	retval = acmStreamSize(acm, unit1, &unit2, ACM_STREAMSIZEF_SOURCE);
	if(retval != 0) die("acmStreamSize()s܂B");
	memset(&stream, 0, sizeof stream);
	stream.cbStruct = sizeof stream;
	stream.pbSrc = (unsigned char*)calloc(unit1, 1);
	stream.cbSrcLength = unit1;
	stream.pbDst = (unsigned char*)calloc(unit2, 1);
	stream.cbDstLength = unit2;
	if(stream.pbSrc == NULL || stream.pbDst == NULL) die("słB");
	retval = acmStreamPrepareHeader(acm, &stream, 0);
	if(retval != 0) die("acmStreamPrepareHeader()s܂B");

	/* ϊ[vB */
	ofs = 0;
	cap = 0;
	while(ofs < wav1->c_data) {
		/* ϊ̃f[^ǂݍ݂܂B */
		len = wav1->c_data - ofs;
		if(len > unit1) len = unit1;
		memcpy(stream.pbSrc, wav1->data + ofs, len);
		stream.cbSrcLength = len;
		/* ϊ̃f[^SďƂ͌Ȃ̂ŁA܂ofs͐i߂܂B */

		/* ϊ܂B */
		flag = 0;
		if(ofs       == 0           ) flag |= ACM_STREAMCONVERTF_START;
		if(ofs + len == wav1->c_data) flag |= ACM_STREAMCONVERTF_END  ; /* Yƃf[^̍Ōオ؂鋰ꂪ܂I */
		retval = acmStreamConvert(acm, &stream, flag);
		if(retval != 0) die("acmStreamConvert()s܂B");
		/* ϊ̃f[^ꂽAofsi߂܂B */
		ofs += stream.cbSrcLengthUsed;

		/* ϊ̃f[^݂܂B */
		len = stream.cbDstLengthUsed;
		if(cap < (int)(wav2->c_data + len)) {
			do {
				cap = cap == 0 ? 1 : cap << 1;
				wav2->data = (char*)realloc(wav2->data, cap);
				if(wav2->data == NULL) die("słB");
			} while(cap < (int)(wav2->c_data + len));
		}
		memcpy(wav2->data + wav2->c_data, stream.pbDst, len);
		wav2->c_data += len;
	}

	/* Xg[obt@폜܂B
	 * * acmStreamUnprepareHeader()ĂԑOɁA
	 *   cbSrcLengthacmStreamPrepareHeader()Ɠlɖ߂ĂȂƁA
	 *   acmStreamUnprepareHeader()G[Ԃ悤łB
	 * * Ō̕ϊł́AcbSrcLengthunit1ȒlɂȂĂ̂ŁA
	 *   ̂܂acmStreamUnprepareHeader()Ăł܂ƁAs܂B
	 */
	stream.cbSrcLength = unit1; /* Kv!! */
	retval = acmStreamUnprepareHeader(acm, &stream, 0);
	if(retval != 0) die("acmStreamUnprepareHeader()s܂B");
	free(stream.pbSrc);
	free(stream.pbDst);

	/* ACMXg[܂B */
	retval = acmStreamClose(acm, 0);
	if(retval != 0) die("acmStreamClose()s܂B");
}
