/*
 *	main.c
 *
 *	dwav2gsm - WAV to GSM Ro[^
 *	Copyright (C) 2002 Naoyuki Sawa
 *
 *	* Mon Jun 22 22:44:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnBił̂ĂĊSɍ蒼j
 *	* Sun Jul 21 09:58:00 JST 2002 Naoyuki Sawa
 *	- acmStreamConvert()ւACM_STREAMCONVERTF_START/ENDwǉB
 */
#define STRICT
#include <windows.h>
#include <mmreg.h>
#include <msacm.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "msacm32.lib")
/* R}hCWJ邽߂ɁA
 * [vWFNg̐ݒ]->[N]->[]->[IuWFNg/CuW[]
 * ŁAsetargv.objNĂ
 */
#include "gsm/gsm.h"

#define VERSION		"20020721"

#define DEFAULT_RATE	8000	/* GSMW̕ϊ[g      */
#define CONVERT_UNIT	65536	/* oCgÂϊ邩H */
#define PROGRESS	'.'	/* vOX */

int rate = DEFAULT_RATE;	/* ϊ[g     */

/****************************************************************************
 *	die
 ****************************************************************************/

void
die(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
	exit(1);
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "dwav2gsm - WAV to GSM Ro[^ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2002 Naoyuki Sawa <nsawa@north.hokkai.net>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE  F wav2gsm [options] [filename[.wav] [filename[.wav] [...]]]\n");
	fprintf(stderr, "OPTIONSF -r<rate> ... ϊ[gw肵܂B(wȂ=%d[Hz])\n", DEFAULT_RATE);
	exit(1);
}

/****************************************************************************
 *	WAV
 ****************************************************************************/

typedef struct WAV {
	WAVEFORMATEX* fmt;	/* tH[}bg */
	int c_data;		/* f[^TCY */
	char* data;		/* f[^       */
} WAV;

WAV*
wav_new()
{
	WAV* wav;
	wav = (WAV*)calloc(1, sizeof(WAV));
	if(wav == NULL) die("słB");
	return wav;
}

void
wav_free(WAV* wav)
{
	if(wav == NULL) return;
	if(wav->fmt != NULL) free(wav->fmt);
	if(wav->data != NULL) free(wav->data);
}

WAV*
wav_load(const char* path)
{
	int retval;
	WAV* wav;
	HMMIO mmio;
	MMCKINFO ck1, ck2;

	/* WAV\̂쐬܂B */
	wav = wav_new();

	/* WAVt@CJ܂B */
	mmio = mmioOpen((char*)path, NULL, MMIO_READ);
	if(mmio == NULL) die("%sJ܂B", path);

	/* RIFF:WAVE`Nɓ܂B */
	memset(&ck1, 0, sizeof(MMCKINFO));
	ck1.ckid    = mmioStringToFOURCC("RIFF", 0); /* MMIO_FINDRIFF́Ackif̎w͏ȗ\ */
	ck1.fccType = mmioStringToFOURCC("WAVE", 0);
	retval = mmioDescend(mmio, &ck1, NULL, MMIO_FINDRIFF);
	if(retval != 0) die("RIFF`N܂B");

	/* fmt`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("fmt", 0);
	retval = mmioDescend(mmio, &ck2, &ck1, MMIO_FINDCHUNK);
	if(retval != 0) die("fmt`N܂B");

	/* tH[}bgǂݍ݂܂B */
	wav->fmt = (WAVEFORMATEX*)malloc(ck2.cksize);
	if(wav->fmt == NULL) die("słB");
	retval = mmioRead(mmio, (char*)wav->fmt, ck2.cksize);
	if(retval != (int)ck2.cksize) die("tH[}bgǂݍ߂܂B");

	/* fmt`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* data`Nɓ܂B */
	memset(&ck2, 0, sizeof(MMCKINFO));
	ck2.ckid = mmioStringToFOURCC("data", 0);
	retval = mmioDescend(mmio, &ck2, &ck1, MMIO_FINDCHUNK);
	if(retval != 0) die("data`N܂B");

	/* f[^ǂݍ݂܂B */
	wav->c_data = ck2.cksize;
	wav->data = (char*)malloc(wav->c_data);
	if(wav->data == NULL) die("słB");
	retval = mmioRead(mmio, wav->data, wav->c_data);
	if(retval != wav->c_data) die("f[^ǂݍ߂܂B");

	/* data`N𔲂܂B */
	retval = mmioAscend(mmio, &ck2, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* RIFF`N𔲂܂B */
	retval = mmioAscend(mmio, &ck1, 0);
	if(retval != 0) die("mmioAscend()s܂B");

	/* WAVt@C܂B */
	retval = mmioClose(mmio, 0);
	if(retval != 0) die("mmioClose()s܂B");

	return wav;
}

/****************************************************************************
 *	wav2wav
 ****************************************************************************/

void
wav2wav(WAV* wav1, WAV* wav2)
{
	int retval, unit1, unit2, flag, ofs, len, cap;
	HACMSTREAM acm;
	ACMSTREAMHEADER stream;

	wav2->c_data = 0; /* Ô */
	free(wav2->data); /* Ô */

	/* ACMXg[J܂B */
	retval = acmStreamOpen(&acm, NULL, wav1->fmt, wav2->fmt, NULL, 0, 0, ACM_STREAMOPENF_NONREALTIME);
	if(retval != 0) die("WAVt@C͕ϊł܂B");

	/* Xg[obt@쐬܂B */
	unit1 = (CONVERT_UNIT + (wav1->fmt->nBlockAlign - 1)) / wav1->fmt->nBlockAlign * wav1->fmt->nBlockAlign;
	retval = acmStreamSize(acm, unit1, &unit2, ACM_STREAMSIZEF_SOURCE);
	if(retval != 0) die("acmStreamSize()s܂B");
	memset(&stream, 0, sizeof stream);
	stream.cbStruct = sizeof stream;
	stream.pbSrc = (unsigned char*)malloc(unit1);
	stream.cbSrcLength = unit1;
	stream.pbDst = (unsigned char*)malloc(unit2);
	stream.cbDstLength = unit2;
	if(stream.pbSrc == NULL || stream.pbDst == NULL) die("słB");
	retval = acmStreamPrepareHeader(acm, &stream, 0);
	if(retval != 0) die("acmStreamPrepareHeader()s܂B");

	/* ϊ[vB */
	ofs = 0;
	cap = 0;
	while(ofs < wav1->c_data) {
		/* ϊ̃f[^ǂݍ݂܂B */
		len = wav1->c_data - ofs;
		if(len > unit1) len = unit1;
		memcpy(stream.pbSrc, wav1->data + ofs, len);
		stream.cbSrcLength = len;
		/* ϊ̃f[^SďƂ͌Ȃ̂ŁA܂ofs͐i߂܂B */

		/* ϊ܂B */
		flag = 0;
		if(ofs       == 0           ) flag |= ACM_STREAMCONVERTF_START;
		if(ofs + len == wav1->c_data) flag |= ACM_STREAMCONVERTF_END  ; /* Yƃf[^̍Ōオ؂鋰ꂪ܂I */
		retval = acmStreamConvert(acm, &stream, flag);
		if(retval != 0) die("acmStreamConvert()s܂B");
		/* ϊ̃f[^ꂽAofsi߂܂B */
		ofs += stream.cbSrcLengthUsed;

		/* ϊ̃f[^݂܂B */
		len = stream.cbDstLengthUsed;
		if(cap < (int)(wav2->c_data + len)) {
			putc(PROGRESS, stderr); /* vOX\ */
			do {
				cap = cap == 0 ? 1 : cap << 1;
				wav2->data = (char*)realloc(wav2->data, cap);
				if(wav2->data == NULL) die("słB");
			} while(cap < (int)(wav2->c_data + len));
		}
		memcpy(wav2->data + wav2->c_data, stream.pbDst, len);
		wav2->c_data += len;
	}

	/* Xg[obt@폜܂B
	 * * acmStreamUnprepareHeader()ĂԑOɁA
	 *   cbSrcLengthacmStreamPrepareHeader()Ɠlɖ߂ĂȂƁA
	 *   acmStreamUnprepareHeader()G[Ԃ悤łB
	 * * Ō̕ϊł́AcbSrcLengthunit1ȒlɂȂĂ̂ŁA
	 *   ̂܂acmStreamUnprepareHeader()Ăł܂ƁAs܂B
	 */
	stream.cbSrcLength = unit1; /* Kv!! */
	retval = acmStreamUnprepareHeader(acm, &stream, 0);
	if(retval != 0) die("acmStreamUnprepareHeader()s܂B");
	free(stream.pbSrc);
	free(stream.pbDst);

	/* ACMXg[܂B */
	retval = acmStreamClose(acm, 0);
	if(retval != 0) die("acmStreamClose()s܂B");
}

/****************************************************************************
 *	wav2gsm
 ****************************************************************************/

/* wav2->fmt͎g܂ */
void
wav2gsm(WAV* wav1, WAV* wav2)
{
	int ofs, len, cap;
	gsm g;
	gsm_frame f;
	gsm_signal s[160];

	wav2->c_data = 0; /* Ô */
	free(wav2->data); /* Ô */

	/* GSMXg[쐬܂B */
	g = gsm_create();
	if(g == NULL) die("gsm_create()s܂B");

	/* ϊ[vB */
	ofs = 0;
	cap = 0;
	while(ofs < wav1->c_data) {
		/* ϊ̃f[^ǂݍ݂܂B */
		len = wav1->c_data - ofs;
		if(len > sizeof s) len = sizeof s;
		memcpy((char*)s      , wav1->data + ofs,            len);
		memset((char*)s + len, 0               , sizeof s - len);
		ofs += len;

		/* ϊ܂B */
		gsm_encode(g, s, f);

		/* ϊ̃f[^݂܂B */
		if(cap < (int)(wav2->c_data + sizeof f)) {
			putc(PROGRESS, stderr); /* vOX\ */
			do {
				cap = cap == 0 ? 1 : cap << 1;
				wav2->data = (char*)realloc(wav2->data, cap);
				if(wav2->data == NULL) die("słB");
			} while(cap < (int)(wav2->c_data + sizeof f));
		}
		memcpy(wav2->data + wav2->c_data, f, sizeof f);
		wav2->c_data += sizeof f;
	}

	/* GSMXg[폜܂B */
	gsm_destroy(g);
}

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int retval, i, c_fmt;
	char* p;
	char wav_path[_MAX_PATH];
	char wav_drive[_MAX_PATH];
	char wav_dir[_MAX_PATH];
	char wav_fname[_MAX_PATH];
	char wav_ext[_MAX_PATH];
	char gsm_path[_MAX_PATH];
	WAV *wav1, *wav2;
	FILE* fp;

	/* Ȃ΁Ag\܂B */
	if(argc == 1) usage();
	i = 1;

	/* R}hCIvV͂܂B */
	while(i < argc) {
		p = argv[i];
		if(p[0] != '-') break; /* IvVI */
		switch(p[1]) {
		case 'r': /* ϊ[g */
			rate = atoi(&p[2]);
			if(rate == 0) usage();
			break;
		}
		i++;
	}

	/* tH[}bg̍őTCY擾Ă܂B */
	retval = acmMetrics(NULL, ACM_METRIC_MAX_SIZE_FORMAT, &c_fmt);
	if(retval != 0) die("acmMetrics()s܂B");

	/* Ɏw肳ꂽSt@C܂B */
	while(i < argc) {
		p = argv[i];

		/* WAVt@ĆB */
		strcpy(wav_path, p);
		_splitpath(wav_path, wav_drive, wav_dir, wav_fname, wav_ext);
		if(wav_ext[0] == '\0') { /* gqȂ".wav"t */
			strcpy(wav_ext, ".wav");
			_makepath(wav_path, wav_drive, wav_dir, wav_fname, wav_ext);
		}
		fprintf(stderr, "%s ", wav_path); /* WAVt@C\ */

		/* GSMt@C쐬B */
		_makepath(gsm_path, wav_drive, wav_dir, wav_fname, ".gsm");

		/* WAVt@Cǂݍ݂܂B */
		wav1 = wav_load(wav_path);

		/* ꎞIPCM`ɕϊ܂B
		 * ӁI
		 *   ϊWAVE_FORMAT_PCM̏ꍇA
		 *   WAVE_FORMAT_PCMWAVE_FORMAT_PCMւ̕ϊiӖjw肵acmFormatSuggest()ĂԂƁA
		 *   acmFormatSuggest()̒ŗ悤łBiWin2K+SP2ŊmFj
		 *   h߂ɁAϊWAVE_FORMAT_PCMłȂꍇ̂݁A
		 *   ꎞIPCM`ւ̕ϊsƂɂ܂B
		 */
		if(wav1->fmt->wFormatTag != WAVE_FORMAT_PCM) {
			wav2 = wav_new();
			wav2->fmt = (WAVEFORMATEX*)calloc(1, c_fmt);
			if(wav2->fmt == NULL) die("słB");
			wav2->fmt->wFormatTag = WAVE_FORMAT_PCM; /* jAPCM */
			retval = acmFormatSuggest(NULL, wav1->fmt, wav2->fmt, c_fmt, ACM_FORMATSUGGESTF_WFORMATTAG);
			if(retval != 0) die("acmFormatSuggest()s܂B");
			wav2wav(wav1, wav2);
			wav_free(wav1); /* ϊWAVJ             */
			wav1 = wav2;    /* ϊWAV̕ϊɐݒ */
			fprintf(stderr, " ");
		}

		/* ŏIIPCM`ɕϊ܂B */
		wav2 = wav_new();
		wav2->fmt = (WAVEFORMATEX*)calloc(1, c_fmt);
		if(wav2->fmt == NULL) die("słB");
		wav2->fmt->wFormatTag = WAVE_FORMAT_PCM;	/* jAPCM             */
		wav2->fmt->nChannels = 1;			/* m              */
		wav2->fmt->nSamplesPerSec = rate;		/* (8KHz)                */
		wav2->fmt->nAvgBytesPerSec = rate * 2 * 1;	/* (8KHz),16bit,m */
		wav2->fmt->nBlockAlign = 2 * 1;			/* 16bit,m        */
		wav2->fmt->wBitsPerSample = 16;			/* 16bit                 */
		wav2wav(wav1, wav2);
		wav_free(wav1); /* ϊWAVJ             */
		wav1 = wav2;    /* ϊWAV̕ϊɐݒ */
		fprintf(stderr, " ");

		/* GSM`ɕϊ܂B */
		wav2 = wav_new();
		wav2gsm(wav1, wav2);

		/* GSMt@C݂܂B */
		fp = fopen(gsm_path, "wb");
		if(fp == NULL) die("%s쐬ł܂B", gsm_path);
		retval = fwrite(wav2->data, 1, wav2->c_data, fp);
		if(retval != wav2->c_data) die("fwrite()s܂B");
		retval = fclose(fp);
		if(retval != 0) die("fclose()s܂B");

		/* WAV\̂J܂B */
		wav_free(wav1);
		wav_free(wav2);

		fprintf(stderr, " OK\n");

		i++;
	}

	return 0;
}

