/*
 *	durlenc - URL encode/decode tool
 *	Copyright (C) 2008 Naoyuki Sawa
 *
 *	* Mon Nov 17 13:25:08 JST 2008 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Nov 18 02:09:30 JST 2008 Naoyuki Sawa
 *	- udbase64enc.exev̓Xg[̉s󔒂𖳎悤ɕύXƂɔA{c[́AsƂ̏ɕύX܂B
 *	  ܂ł́Audbase64enc.exevr̉sG[ƂĂ߁ApCvŘAĎg߂ɁA{c[sőSf[^܂Ƃ߂ĈꊇϊĂ܂B
 *	  ̕ύXɂAsƂ̏̕AgՂȂƎv܂B
 *	- <> data.binBase64GR[hAURLGR[hāAencoded.txt𐶐Bǂ݈Ղ̂߂ɁABase64GR[h80ƂƖŉsB
 *		dbase64enc -c80 data.bin | durlenc > encoded.txt
 *	- <> LGR[h̋t́AfR[hsB
 *		durlenc -d < encoded.txt | dbase64enc -d data.bin
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#define DIE() abort()
#define __CLIP_H__
#include "../../clipcode.h"
#include "../../clipcode.c"

#define VERSION "20081118"

/////////////////////////////////////////////////////////////////////////////

void
usage()
{
	printf("durlenc - URL encode/decode tool (%s) Naoyuki Sawa\n", VERSION);
	printf("Usage: [-d/-e] < input-text-stream > output-text-stream\n");
	printf("Options:\n");
	printf("  -e : encode input text (default)\n");
	printf("  -d : decode input text\n");
	exit(1);
}

int mode; /* 'd' or 'e' */

#define BUFFER_SIZE	(16 * 1024 * 1024)	/*  */
unsigned char srcbuf[BUFFER_SIZE];
unsigned char dstbuf[BUFFER_SIZE];

int
main(int argc, char* argv[])
{
	int i;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		switch(argv[i][0]) {
		case '-':
		case '/':
			switch(tolower(argv[i][1])) {
			case 'd':
			case 'e':
				if(!mode) {
					mode = tolower(argv[i][1]);
					break;
				}
				usage();
				break;
			default:
				usage();
				break;
			}
			break;
		default:
			usage();
			break;
		}
	}
	/* "-d""-e"w肳ĂȂ΁A"-e"Ƃ܂B */
	if(!mode) {
		mode = 'e';
	}

	/* sǂݍ݂܂B */
	while(gets(srcbuf)) {
		switch(mode) {
		case 'e':
			/* GR[h܂B */
			url_encode(dstbuf, BUFFER_SIZE, srcbuf);
			break;
		case 'd':
			/* fR[h܂B */
			url_decode(dstbuf, BUFFER_SIZE, srcbuf);
			break;
		default:
			DIE();
		}
		/* so͂܂B */
		puts(dstbuf);
	}

	return 0;
}
