/*	
 *	srf33.h
 *
 *	srf33IuWFNgt@C̍\
 *
 *	* Sat Sep 13 20:22:00 JST 2003 Naoyuki Sawa
 *	- VK쐬B
 */
#ifndef __SRF33_H__
#define __SRF33_H__

/****************************************************************************
 *	/usr/PIECE/docs/datasheet/EPSON/S5U1C33000C_J.pdf
 *	wS5U1C33000C Manual (S1C33 Family CRpCpbP[W) (Ver.4)x
 *	475y[W`uAppendix srf33t@C̍\v
 ****************************************************************************/

/* ӁFetB[hl̓rbOGfBAŊi[Ă܂II */
/*         80x86S1C33ňꍇ́AoCgI[_[ϊKvłB */
#define SRF33_HALF(v)					\
	(((const unsigned char*)&(v))[0] <<  8 |	\
	 ((const unsigned char*)&(v))[1] <<  0)
#define SRF33_WORD(v)					\
	(((const unsigned char*)&(v))[0] << 24 |	\
	 ((const unsigned char*)&(v))[1] << 16 |	\
	 ((const unsigned char*)&(v))[2] <<  8 |	\
	 ((const unsigned char*)&(v))[3] <<  0)

/* srf33wb_ */
#ifdef _WIN32
#   pragma pack(1)
#endif /*_WIN32*/
struct _SRF33_CONTROL_HEADER {
	unsigned short c_fatt;		/* t@CtO */
	unsigned short c_pentry;	/* Gg[AhX */
	unsigned short c_ver;		/* srf33o[W */
	unsigned short c_scncnt;	/* ZNV */
	unsigned int c_scnptr;		/* ZNV`F[ */
	unsigned int c_debptr;		/* fobO`F[ */
}
#ifdef _WIN32
#   pragma pack()
#else /*_WIN32*/
    __attribute__((packed))
#endif /*_WIN32*/
;
typedef struct _SRF33_CONTROL_HEADER SRF33_CONTROL_HEADER;
#define SIZEOF_SRF33_CONTROL_HEADER 16

/* ZNV */
#ifdef _WIN32
#   pragma pack(1)
#endif /*_WIN32*/
struct _SRF33_SECTION_INFORMATION {
	unsigned int s_nxptr;		/* ̃ZNVւ̃`F[ */
	unsigned short s_scntyp;	/* ZNV^Cv */
	unsigned short s_lnktyp;	/* N@ */
	unsigned short s_scnatt;	/* ZNV */
	unsigned int s_off;		/* ZNṼX^[gAhX */
	unsigned int s_rcptr;		/* P[V`F[ */
	unsigned int s_rcsiz;		/* P[VoCgTCY */
	unsigned int s_exptr;		/* GNX^[`F[ */
	unsigned int s_exsiz;		/* GNX^[oCgTCY */
	unsigned int s_excnt;		/* GNX^[̌ */
	unsigned int s_rdptr;		/* f[^ւ̃`F[ */
	unsigned int s_dsiz;		/* f[^oCgTCY */
	unsigned short s_scnndx;	/* ZNVID */
}
#ifdef _WIN32
#   pragma pack()
#else /*_WIN32*/
    __attribute__((packed))
#endif /*_WIN32*/
;
typedef struct _SRF33_SECTION_INFORMATION SRF33_SECTION_INFORMATION;
#define SIZEOF_SRF33_SECTION_INFORMATION 44

/* ̑̍\̂͂܂gȂ̂Œ`Ă܂B */
/* KvɉĒǉĂB                     */

#endif /*__SRF33_H__*/
