/*
 *	app.c
 *
 *	dpstrcnv - ϊ[eBeB[
 *	Copyright (C) 2013 Naoyuki Sawa
 *
 *	* Sat Sep 28 20:39:33 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* Win32 */
#define STRICT
#include <windows.h>

/* [NOTE]
 * * R}hC̃ChJ[hWJ邽߂ɁA
 *   [vWFNg̐ݒ]->[N]->[IuWFNg/CuW[]
 *   usetargv.objvǉ܂B
 */

#define VERSION "20130928"

/****************************************************************************
 *	
 ****************************************************************************/

__declspec(noreturn) void usage();
__declspec(noreturn) void die(const char* fmt, ...);
#define DIE() die(__FILE__, __LINE__)

/* getopt */
#define __CLIP_H__
#include "../../include/getopt.h"
#include "../../getopt.c"
#undef  __CLIP_H__

/****************************************************************************
 *	
 ****************************************************************************/

int main(int argc, char* argv[]) {
	int opt;
	int flag;	/* ϊtO */
	FILE* fp;	/* ̓Xg[ */
	char* srcBuf;	/* ̓obt@ */
	char* dstBuf;	/* o̓obt@ */
	int srcCap;	/* ̓obt@̃LpVeB */
	int dstCap;	/* o̓obt@̃LpVeB */
	int dstReq;	/* o̓obt@ɕKvȃTCY */

	/* R}hC͂B */
	flag = 0;
	while((opt = getopt(argc, argv, "ulwnkh")) != -1) {
		switch(opt) {
		case 'u': flag |= LCMAP_UPPERCASE; break; /* 啶 */
		case 'l': flag |= LCMAP_LOWERCASE; break; /*  */
		case 'w': flag |= LCMAP_FULLWIDTH; break; /* Sp */
		case 'n': flag |= LCMAP_HALFWIDTH; break; /* p */
		case 'k': flag |= LCMAP_KATAKANA;  break; /* J^Ji */
		case 'h': flag |= LCMAP_HIRAGANA;  break; /* Ђ炪 */
		default:  die("%c: IvV̎gsłB", optopt);
		}
	}
	/* ϊtOw肳ĂȂ΁Ag\ďIB
	 * ̂܂܋sĂALCMapStringŝŁAʂłB
	 */
	if(!flag) { usage(); }
	/* sǂݍނ̂ɏ[ȑ傫́A̓obt@mۂB
	 * ͍s̓e𔻒fāA̓obt@TCY邱Ƃ͂łȂ̂ŁA\ߏ[ȑ傫̓̓obt@mۂĂKvB
	 * A̓obt@̑傫sŁAfgets()s𕪊Ă܂ƁALCMapString APIϊsȂꂪB
	 * Ƃ΁ApJ^Jȋ_𕪊Ă܂ꍇȂǁB("޷޸޹޺\n""޷޸޹","޺\n""KMOP","JS")
	 */
	srcCap = 1<<20;	/* 1MB */	//
	srcBuf = malloc(srcCap);
	if(!srcBuf) { die("mallocs܂B\n"); }
	/* o̓obt@𖢊蓖ĂɂĂB
	 * es̕ϊɕKvȃTCYsx擾ATCY߂xɊgčsB
	 */
	dstBuf = NULL;
	dstCap = 0;
	/* ̓t@Cw肳ĂȂ΁AW͂񏈗B */
	fp = stdin;
	do {
		/* ̓t@Cw肳Ă΁A̓t@CJB */
		if(optind < argc) {
			fp = fopen(argv[optind], "r");
			if(!fp) { die("%sJ܂B\n", argv[optind]); }
		}
		/* sǂݍށBt@CI[łȂ΁c */
		while(fgets(srcBuf, srcCap, fp)) {
			/* ̍s̕ϊɕKvȃTCY擾B
			 * - ϊɕKvȃTCY擾ꍇ́AŌ̈0w肷KvB
			 *   ݂̏o̓obt@TCYw肵āAȂΈxōς܂悤ƂƁAG[(0)ԂAKvȃTCY擾łȂB
			 */
			dstReq = LCMapString(GetSystemDefaultLCID(), flag, srcBuf, -1, NULL, 0);
			if(!dstReq) { die("LCMapStrings܂B\n"); }
			/* ̍s̕ϊɕKvȃTCYȀ݂o̓obt@TCY𒴉߂Ao̓obt@TCYgB
			 * - LCMapString APIԂAϊɕKvȃTCÝAI[nul܂łB
			 *   AvP[VvOŁA蓖ăTCY(+1)Kv͖B
			 */
			if(dstReq > dstCap) {
				dstCap = dstReq;
				dstBuf = realloc(dstBuf, dstCap);
				if(!dstBuf) { die("reallocs܂B\n"); }
			}
			/* ̍sϊB */
			dstReq = LCMapString(GetSystemDefaultLCID(), flag, srcBuf, -1, dstBuf, dstCap);
			if(!dstReq) { die("LCMapStrings܂B\n"); }
			/* Wo͂ɏo͂B */
			if(fputs(dstBuf, stdout) < 0) { die("fputss܂B\n"); }
		}
		/* ̓t@Cw肳Ă΁A̓t@CB */
		if(optind < argc) {
			if(fclose(fp)) { die("fcloses܂B\n"); }
			optind++; /* ̓̓t@C֐i߂ */
		}
	} while(optind < argc);
	return EXIT_SUCCESS;
}

/****************************************************************************
 *	
 ****************************************************************************/

/* g\AG[IB */
void usage() {
	fprintf(stderr, "dpstrcnv - ϊ[eBeB[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2013 Naoyuki Sawa All Rights Reserved.\n");
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "    dpstrcnv [options] [filename ...]\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "    -u StrConv֐vbUpperCase,,LCMapString APILCMAP_UPPERCASEɑ܂B\n");
	fprintf(stderr, "    -l StrConv֐vbLowerCase,,LCMapString APILCMAP_LOWERCASEɑ܂B\n");
	fprintf(stderr, "    -w StrConv֐vbWide     ,,LCMapString APILCMAP_FULLWIDTHɑ܂B\n");
	fprintf(stderr, "    -n StrConv֐vbNarrow   ,,LCMapString APILCMAP_HALFWIDTHɑ܂B\n");
	fprintf(stderr, "    -k StrConv֐vbKatakana   ,,LCMapString APILCMAP_KATAKANA ɑ܂B\n");
	fprintf(stderr, "    -h StrConv֐vbHiragana   ,,LCMapString APILCMAP_HIRAGANA ɑ܂B\n");
	fprintf(stderr, "Summary:\n");
	fprintf(stderr, "  - 啶/,Sp/p,J^Ji/Ђ炪,y,𕡍ϊs܂B\n");
	fprintf(stderr, "  - LCMapString API̓ɂAȉ̐񂪂܂:\n");
	fprintf(stderr, "    EȂƂȏ̕ϊtOw肵ĂB\n");
	fprintf(stderr, "    E-u-l𓯎Ɏw肵Ă͂܂B\n");
	fprintf(stderr, "    E-w-n𓯎Ɏw肵Ă͂܂B\n");
	fprintf(stderr, "    E-k-h𓯎Ɏw肵Ă͂܂B\n");
	fprintf(stderr, "  - pJ^JiSpЂ炪Ȃɕϊꍇ̒ӓ_:\n");
	fprintf(stderr, "    EpJ^JiSpЂ炪Ȃɕϊꍇ́A-whw肵ĂB\n");
	fprintf(stderr, "    @-h̎wł́ApJ^JiϊΏۂɂȂ܂B(LCMapString API̓)\n");
	fprintf(stderr, "    E-w̌ʂ̂߁ApJ^JiȊO̔pSp܂B\n");
	fprintf(stderr, "    @pJ^Jî݂SpЂ炪Ȃɕϊ@͗L܂B\n");
	fprintf(stderr, "Example:\n");
	fprintf(stderr, "  - dpstrcnv.exe -u sample1.txt sample2.txt sample3.txt\n");
	fprintf(stderr, "    sample1`3.txtǂݎeLXg啶ɕϊāAWo͂֏o͂܂B\n");
	fprintf(stderr, "    ̃t@Cw肷@́AChJ[hɂw\łB(:*.txt)\n");
	fprintf(stderr, "  - dpstrcnv.exe -nk\n");
	fprintf(stderr, "    W͂ǂݎeLXg𔼊pJ^JiɕϊāAWo͂֏o͂܂B\n");
	exit(EXIT_FAILURE);
}

/****************************************************************************
 *	
 ****************************************************************************/

/* bZ[W\AG[IB */
void die(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
#ifdef  _DEBUG
	__asm int 3; /* fobOՂ悤ɁAfobO̓fobKŎ~߂ */
#endif/*_DEBUG*/
	exit(EXIT_FAILURE);
}

