/*
 *	dprc - Range Coder compression tool
 *	Copyright (C) 2014 Naoyuki Sawa
 *
 *	* Wed Dec 03 21:01:59 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- u/clip/tool/dphfmvɂč쐬܂B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <assert.h>
#define DIE() abort()
#define __CLIP_H__
#include "../../include/stdint.h"	//uint64_t
#include "../../cliprc.h"
#include "../../cliprc.c"
#include "../../framrc.c"

#define VERSION "20141203"

/////////////////////////////////////////////////////////////////////////////

void usage() {
	printf("dprc - Range Coder compression tool (%s)\n", VERSION);
	printf("Copyright (C) 2014 Naoyuki Sawa All Rights Reserved.\n");
	printf("Usage: [-d/-e] <source file name> [<destination file name>]\n");
	printf("Options:\n");
	printf("  -e : encode source file(default)\n");
	printf("  -d : decode source file\n");
	exit(1);
}

int mode; /* 'd' or 'e' */
char srcname[_MAX_PATH];
char dstname[_MAX_PATH];

int srclen;
unsigned char* srcbuf;
int dstlen;
unsigned char* dstbuf;
int verlen;
unsigned char* verbuf;

int main(int argc, char* argv[]) {
	int i;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	FILE* fp;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		switch(argv[i][0]) {
		case '-':
		case '/':
			switch(tolower(argv[i][1])) {
			case 'd':
			case 'e':
				if(!mode) {
					mode = tolower(argv[i][1]);
					break;
				}
				usage();
				break;
			default:
				usage();
				break;
			}
			break;
		default:
			if(!srcname[0]) {
				strcpy(srcname, argv[i]);
				break;
			}
			if(!dstname[0]) {
				strcpy(dstname, argv[i]);
				break;
			}
			usage();
			break;
		}
	}
	/* "-d""-e"w肳ĂȂ΁A"-e"Ƃ܂B */
	if(!mode) {
		mode = 'e';
	}
	/* ̓t@C͕K{łB */
	if(!srcname[0]) {
		usage();
	}
	if(mode == 'd') {
		/* ̓t@C̊gqȗĂA".rc"Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname -> ̓t@C D:\path\fname.rc
		 */
		_splitpath(srcname, drive, dir, fname, ext);
		if(!ext[0]) {
			_makepath(srcname, drive, dir, fname, ".rc");
		}
		/* o̓t@CȗĂꍇA
		 * - ̓t@C̊gq".rc"Ȃ΁A".rc"菜̂Ƃ܂B
		 * - ̓t@C̊gq".rc"łȂ΁Ao̓t@C𐄑łȂ̂ŁAG[Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname.ext.rc -> o̓t@C D:\path\fname.ext
		 *	̓t@C D:\path\fname.ext    -> G[
		 */
		if(!dstname[0]) {
			_splitpath(srcname, drive, dir, fname, ext);
			if(!stricmp(ext, ".rc")) {
				_makepath(dstname, drive, dir, fname, NULL);
			} else {
				fprintf(stderr, "Error: Destination file could not be supposed.\n");
				exit(1);
			}
		}
	}
	if(mode == 'e') {
		/* o̓t@CȗĂA̓t@CɊgq".rc"ǉ̂Ƃ܂B
		 * - ̓t@CgqĂꍇǍɂ̊gq".rc"ǉ܂B
		 *   ̏ꍇAǉgq".rc"{̊gqɂȂāÅgq̓t@CƂȂ܂B
		 *   <>
		 *	̓t@C D:\path\fname.ext -> o̓t@C D:\path\fname.ext.rc
		 */
		if(!dstname[0]) {
			_makepath(dstname, NULL, NULL, srcname, ".rc");
		}
		/* o̓t@C̊gqȗĂA".rc"Ƃ܂B
		 * - <>
		 *	o̓t@C D:\path\fname -> o̓t@C D:\path\fname.rc
		 */
		_splitpath(dstname, drive, dir, fname, ext);
		if(!ext[0]) {
			_makepath(dstname, drive, dir, fname, ".rc");
		}
	}
	/* ̓t@CƏo̓t@CłĂ͂܂B */
	if(!stricmp(srcname, dstname)) {
		fprintf(stderr, "Error: Source file should not be same as destination file.\n");
		exit(1);
	}

	/* ̓t@Cǂݍ݂܂B */
	fp = fopen(srcname, "rb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to open file %s.\n", srcname);
		exit(1);
	}
	fseek(fp, 0, SEEK_END);
	srclen = ftell(fp);
	if(!srclen && (mode == 'd')) {	//WJ('d')Ȃ΁A0oCg̈kf[^͗L蓾Ȃ߁AG[Ƃ܂Bkf[^́A8oCgȏł͂łBRangeCoderEncoder_Encode()́u0oCg̃f[^ɑ΂ᏈvQƂĂBAk('e')Ȃ΁A0oCg̃t@Ck邱Ƃ\Ȃ̂ŁAG[Ƃ͂܂B
		fprintf(stderr, "Error: Source file should not be empty.");
		exit(1);
	}
	rewind(fp);
	srcbuf = malloc(srclen);
	if(!srcbuf) {
		fprintf(stderr, "Error: Failed to allocate source buffer.\n");
		exit(1);
	}
	fread(srcbuf, 1, srclen, fp);
	fclose(fp);

	if(mode == 'e') {
		/* kB */
		dstlen = RangeCoderEncoder_Encode(srcbuf, srclen, NULL, 0);
		dstbuf = malloc(dstlen);
		if(!dstbuf) {
			fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
			exit(1);
		}
		RangeCoderEncoder_Encode(srcbuf, srclen, dstbuf, dstlen);
		/* xt@CB */
		verbuf = malloc(srclen);
		if(!verbuf) {
			fprintf(stderr, "Error: Failed to allocate verify buffer.\n");
			exit(1);
		}
		verlen = RangeCoderDecoder_Decode(dstbuf, verbuf, srclen);
		if((verlen != srclen) || memcmp(verbuf, srcbuf, srclen)) {
			fprintf(stderr, "Internal error: Verify failed.n");
			exit(1);
		}
	}
	if(mode == 'd') {
		/* WJB */
		dstlen = RangeCoderDecoder_Decode(srcbuf, NULL, 0);
		dstbuf = malloc(dstlen);
		if(!dstbuf) {
			fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
			exit(1);
		}
		RangeCoderDecoder_Decode(srcbuf, dstbuf, dstlen);
	}

	/* o̓t@C݂܂B */
	fp = fopen(dstname, "wb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to create file %s.\n", dstname);
		exit(1);
	}
	fwrite(dstbuf, 1, dstlen, fp);
	fclose(fp);

	/* |[g\B */
	printf("%s (%d) => %s (%d) : %d%%\n",
		srcname, srclen,
		dstname, dstlen,
		(int)ceil((double)dstlen * 100.0 / (double)srclen));

	return 0;
}
