/*
 *	dpexres - PEX\[XǗc[
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Mon Jul 17 18:26:13 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Jul 17 21:12:19 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#define VERSION		"20060717"

/*{{/usr/PIECE/include/piece.h*/
typedef struct _pffsFileHEADER {
	unsigned char mark;		// + 0 }[N ('X'Œ)
	unsigned char type;		// + 1 t@CE^Cv
	unsigned short ofs_data;	// + 2 f[^ւ̃ItZbg
	unsigned short ofs_name;	// + 4 LvVւ̃ItZbg
	unsigned short ofs_icon;	// + 6 ACRւ̃ItZbg
	unsigned long resv2;		// + 8 \
	unsigned long top_adrs;		// +12 擪̃AhX
	unsigned long length;		// +16 
	unsigned long crc32;		// +20 CRC32
} pffsFileHEADER;
/*}}/usr/PIECE/include/piece.h*/

char cmd;			/* R}h (a/d/e/t) */
char pex_path[_MAX_PATH];	/* PEXt@C */
char res_path[_MAX_PATH];	/* \[Xt@C */

#define MAX_SIZE	(2 * 1024 * 1024)		/* t@CTCY (2MBP/ECEz) */
unsigned char pex_data[MAX_SIZE + 1/*ߌop*/];	/* PEXt@C̓e */
int pex_size;						/* PEXt@CTCY */
unsigned char res_data[MAX_SIZE + 1/*ߌop*/];	/* \[Xt@C̓e */
int res_size;						/* \[Xt@CTCY */

pffsFileHEADER* const hdr = (pffsFileHEADER*)pex_data;

/* G[Z[W\ďI܂B
 */
void
err(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
	abort();
}

/* g\ďI܂B
 */
void
usage()
{
	fprintf(stderr, "dpexres - PEX\[XǗc[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2006 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "g@FPEXt@CɃ\[XYt\n");
	fprintf(stderr, "@@@@@dpexres a (pex filename[.pex]) (resource filename)\n");
	fprintf(stderr, "@@@@@Ƀ\[XYtĂꍇAu܂B\n");
	fprintf(stderr, "gAFPEXt@C̃\[X폜\n");
	fprintf(stderr, "@@@@@dpexres d (pex filename[.pex])\n");
	fprintf(stderr, "@@@@@\[XYtĂȂꍇAs܂B\n");
	fprintf(stderr, "gBFPEXt@C̃\[X𒊏o\n");
	fprintf(stderr, "@@@@@dpexres e (pex filename[.pex]) (output filename)\n");
	fprintf(stderr, "@@@@@\[XYtĂȂꍇAG[Ƃ܂B\n");
	fprintf(stderr, "gCFPEXt@C̃\[X\\n");
	fprintf(stderr, "@@@@@dpexres t (pex filename[.pex])\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "@|PFdpexres a game music.fpk\n");
	fprintf(stderr, "@@@@@game.pex̖ɁAmusic.fpkYt܂B\n");
	fprintf(stderr, "B@@Fdpexres e game unknown.dat\n");
	fprintf(stderr, "@@@@@game.pexɓYtĂAmusic.fpk̓eAunknown.datƂOŕۑ܂B\n");
	fprintf(stderr, "@|QFdpexres a game movie.fpk\n");
	fprintf(stderr, "@@@@@game.pexAœYtmusic.fpk̓e폜Amovie.fpkYt܂B\n");
	fprintf(stderr, "C@@Fdpexres t game\n");
	fprintf(stderr, "@@@@@game.pexɓYtĂAmovie.fpk̏\܂B\n");
	fprintf(stderr, "A@@Fdpexres d game\n");
	fprintf(stderr, "@@@@@game.pexAœYtmovie.fpk̓e폜܂B\n");
	abort();
}

/* PEXt@Cǂݍ݂܂B
 * [in]
 *	pex_path	t@CB
 * [out]
 *	pex_data	t@C̓eB
 *	pex_size	t@CTCYB
 */
void
load_pex()
{
	FILE* fp;

	if(!strlen(pex_path)) {
		err("PEXt@Cw肳Ă܂B");
	}

	fp = fopen(pex_path, "rb");
	if(!fp) {
		err("%sJ܂B", pex_path);
	}

	pex_size = fread(pex_data, 1, sizeof pex_data, fp);
	if(pex_size > MAX_SIZE) {
		err("%s̃TCY傫߂܂B", pex_path);
	}

	if((hdr->mark != 'X') ||
	   (pex_size < (int)(hdr->ofs_data + hdr->length))) {
		err("%s͕sPEXt@CłB", pex_path);
	}

	fclose(fp);
}

/* \[Xt@Cǂݍ݂܂B
 * [in]
 *	res_path	t@CB
 * [out]
 *	res_data	t@C̓eB
 *	res_size	t@CTCYB
 */
void
load_res()
{
	FILE* fp;

	if(!strlen(res_path)) {
		err("\[Xt@Cw肳Ă܂B");
	}

	fp = fopen(res_path, "rb");
	if(!fp) {
		err("%sJ܂B", res_path);
	}

	res_size = fread(res_data, 1, sizeof res_data, fp);
	if(res_size > MAX_SIZE) {
		err("%s̃TCY傫߂܂B", res_path);
	}

	fclose(fp);
}

/* PEXt@C݂܂B
 * [in]
 *	pex_path	t@CB
 *	pex_data	t@C̓eB
 *	pex_size	t@CTCYB
 */
void
save_pex()
{
	FILE* fp;

	if(!strlen(pex_path)) {
		err("PEXt@Cw肳Ă܂B");
	}

	fp = fopen(pex_path, "wb");
	if(!fp) {
		err("%s쐬ł܂B", pex_path);
	}

	fwrite(pex_data, 1, pex_size, fp);

	fclose(fp);
}

/* \[Xt@C݂܂B
 * [in]
 *	res_path	t@CB
 *	res_data	t@C̓eB
 *	res_size	t@CTCYB
 */
void
save_res()
{
	FILE* fp;

	if(!strlen(res_path)) {
		err("\[Xt@Cw肳Ă܂B");
	}

	fp = fopen(res_path, "wb");
	if(!fp) {
		err("%s쐬ł܂B", res_path);
	}

	fwrite(res_data, 1, res_size, fp);

	fclose(fp);
}

int
main(int argc, char* argv[])
{
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	int ofs_res;

	/* ŋNꂽAg\܂B */
	if(argc <= 1 + 0) {
		usage();
	}

	/* R}h擾܂B */
	if(argc >= 1 + 1) {
		cmd = tolower(argv[1][0]);
	}

	/* PEXt@C擾܂B */
	if(argc >= 1 + 2) {
		_splitpath(argv[2], drive, dir, fname, ext);
		if(!strlen(ext)) {
			strcpy(ext, ".pex");
		}
		_makepath(pex_path, drive, dir, fname, ext);
	}

	/* \[Xt@C擾܂B */
	if(argc >= 1 + 3) {
		_splitpath(argv[3], drive, dir, fname, ext);
		if(!strlen(ext)) {
			/** no job **/
		}
		_makepath(res_path, drive, dir, fname, ext);
	}

	/* PEXt@Cǂݍ݂܂B */
	load_pex();

	/* R}hɂ... */
	switch(cmd) {
	case 'a':
		/* \[Xt@Cǂݍ݂܂B */
		load_res();

		/* PEXt@C̓eA\[X폜܂B */
		pex_size = hdr->ofs_data + hdr->length;

		/* \[X[hEɔzu邽߁ApfBOs܂B */
		while(pex_size & 3) {
			pex_data[pex_size++] = 0; /* uÕS~cƕ킵̂ */
		}

		/* PEXt@C̓eɁA\[XYt܂B */
		if(pex_size + res_size > MAX_SIZE) {
			err("%s%s̍vTCY傫߂܂B", pex_path, res_path);
		}
		memcpy(pex_data + pex_size, res_data, res_size);
		pex_size += res_size;

		/* PEXt@C݂܂B */
		save_pex();

		break;
	case 'd':
		/* PEXt@C̓eA\[X폜܂B */
		pex_size = hdr->ofs_data + hdr->length;

		/* PEXt@C݂܂B */
		save_pex();

		break;
	case 'e':
		/* \[X̐擪ItZbg߂܂B */
		ofs_res = (hdr->ofs_data + hdr->length + 3) & ~3;

		/* \[X擾܂B */
		res_size = pex_size - ofs_res;
		if(res_size <= 0) {
			err("%sɂ̓\[XYtĂ܂B", pex_path);
		}
		memcpy(res_data, pex_data + ofs_res, res_size);

		/* \[Xt@C݂܂B */
		save_res();

		break;
	case 't':
		/* \[X̐擪ItZbg߂܂B */
		ofs_res = (hdr->ofs_data + hdr->length + 3) & ~3;

		/* \[X̏\܂B */
		res_size = pex_size - ofs_res;
		if(res_size <= 0) {
			printf("%sɂ̓\[XYtĂ܂B\n", pex_path);
		} else {
			printf("%sɂ%doCg̃\[XYtĂ܂B\n", pex_path, res_size);
		}

		break;
	default:
		err("R}hsłB");
	}

	return 0;
}

