/*
 *	dpdrh - Canonical Huffman Code compression tool
 *	Copyright (C) 2014 Naoyuki Sawa
 *
 *	* Mon Nov 24 13:19:05 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- u/clip/tool/dtinylzvu/clip/tool/dphfmvɂč쐬܂B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <assert.h>
#define DIE() abort()
#define __CLIP_H__
#include "../../clipsort.c"	//qsort_r()
#include "../../clipbary.h"	//bitarray_msb1st_get(),bitarray_msb1st_set()
#include "../../clipbary.c"
#include "../../frambary.c"
#include "../../cliphfm.h"
#include "../../cliphfm.c"
#include "../../framhfm.c"
#include "../../clipdrh.h"
#include "../../clipdrh.c"
#include "../../framdrh.c"

#define VERSION "20141124"

/////////////////////////////////////////////////////////////////////////////

void usage() {
	printf("dpdrh - k˘Ak˃nt}kc[ (%s)\n", VERSION);
	printf("Copyright (C) 2014 Naoyuki Sawa All Rights Reserved.\n");
	printf("Usage: [-d/-e] [-bN] <source file name> [<destination file name>]\n");
	printf("Options:\n");
	printf("  -e  : encode source file(default)\n");
	printf("  -d  : decode source file\n");
	printf("  -bN : data bits. N=1...8(default)\n");
	printf(":\n");
	printf("  16MBȏ̧ق𤈳kWJ邱Ƃ͂ł܂\n");
	printf("  clipdrh.cӼޭقcliphfm.cӼޭق𗘗pĂ\n");
	printf("  cliphfm.cӼޭقclipbary.cӼޭق𗘗pĂ\n");
	printf("  clipbary.cޯĈʒu32bitŊǗĂ邽߂ł\n");
	printf("  ڍׂͤclipbary.c̎QƂĂ\n");
	printf("ްޯĐɂ:\n");
	printf("  k'-bN'߼݂w肷ƤkOɤް(8-N)ޯčĂ܂\n");
	printf("  WJ'-bN'߼݂w肷ƤWJɤް(8-N)ޯĉEĂ܂\n");
	printf("  ƂΤް0`31͈̔͂ł邱Ƃ炩ߔĂꍇͤ\n");
	printf("  '-b5'߼݂w肷邱ƂɂĤkシ邱Ƃł܂\n");
	printf("ްޯĐw肵ꍇɌoװɂ:\n");
	printf("  kƓWJɤ߼݂w肷KvL鎖ɒӂĂ\n");
	printf("  ߼݂w肵ȂƤL̴װoĤI邱Ƃ܂\n");
	printf("  k'-bN'߼݂w肳ꂽıĂޯĂɤ\n");
	printf("  '1'ޯĂ݂Ăꍇͤװ\ďI܂\n");
	printf("  WJ'-bN'߼݂w肳ꂽıĂ鉺ޯĂɤ\n");
	printf("  '1'ޯĂ݂Ăꍇͤװ\ďI܂\n");
	exit(1);
}

int mode; /* 'd' or 'e' */
int bits; /* 1,2,3,`,8 */
char srcname[_MAX_PATH];
char dstname[_MAX_PATH];

int srclen;
unsigned char* srcbuf;
int dstlen;
unsigned char* dstbuf;
int verlen;
unsigned char* verbuf;

int main(int argc, char* argv[]) {
	int i;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	FILE* fp;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		switch(argv[i][0]) {
		case '-':
		case '/':
			switch(tolower(argv[i][1])) {
			case 'd':
			case 'e':
				if(!mode) {
					mode = tolower(argv[i][1]);
					break;
				}
				usage();
				break;
			case 'b':
				if(!bits) {
					bits = atoi(&argv[i][2]);
					if((bits >= 1) && (bits <= 8)) {
						break;
					}
				}
				usage();
				break;
			default:
				usage();
				break;
			}
			break;
		default:
			if(!srcname[0]) {
				strcpy(srcname, argv[i]);
				break;
			}
			if(!dstname[0]) {
				strcpy(dstname, argv[i]);
				break;
			}
			usage();
			break;
		}
	}
	/* "-d""-e"w肳ĂȂ΁A"-e"Ƃ܂B */
	if(!mode) {
		mode = 'e';
	}
	/* "-bN"w肳ĂȂ΁A"-b8"Ƃ܂B */
	if(!bits) {
		bits = 8;
	}
	/* ̓t@C͕K{łB */
	if(!srcname[0]) {
		usage();
	}
	if(mode == 'd') {
		/* ̓t@C̊gqȗĂA".drh"Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname -> ̓t@C D:\path\fname.drh
		 */
		_splitpath(srcname, drive, dir, fname, ext);
		if(!ext[0]) {
			_makepath(srcname, drive, dir, fname, ".drh");
		}
		/* o̓t@CȗĂꍇA
		 * - ̓t@C̊gq".drh"Ȃ΁A".drh"菜̂Ƃ܂B
		 * - ̓t@C̊gq".drh"łȂ΁Ao̓t@C𐄑łȂ̂ŁAG[Ƃ܂B
		 * - <>
		 *	̓t@C D:\path\fname.ext.drh -> o̓t@C D:\path\fname.ext
		 *	̓t@C D:\path\fname.ext     -> G[
		 */
		if(!dstname[0]) {
			_splitpath(srcname, drive, dir, fname, ext);
			if(!stricmp(ext, ".drh")) {
				_makepath(dstname, drive, dir, fname, NULL);
			} else {
				fprintf(stderr, "Error: Destination file could not be supposed.\n");
				exit(1);
			}
		}
	}
	if(mode == 'e') {
		/* o̓t@CȗĂA̓t@CɊgq".drh"ǉ̂Ƃ܂B
		 * - ̓t@CgqĂꍇǍɂ̊gq".drh"ǉ܂B
		 *   ̏ꍇAǉgq".drh"{̊gqɂȂāÅgq̓t@CƂȂ܂B
		 *   <>
		 *	̓t@C D:\path\fname.ext -> o̓t@C D:\path\fname.ext.drh
		 */
		if(!dstname[0]) {
			_makepath(dstname, NULL, NULL, srcname, ".drh");
		}
		/* o̓t@C̊gqȗĂA".drh"Ƃ܂B
		 * - <>
		 *	o̓t@C D:\path\fname -> o̓t@C D:\path\fname.drh
		 */
		_splitpath(dstname, drive, dir, fname, ext);
		if(!ext[0]) {
			_makepath(dstname, drive, dir, fname, ".drh");
		}
	}
	/* ̓t@CƏo̓t@CłĂ͂܂B */
	if(!stricmp(srcname, dstname)) {
		fprintf(stderr, "Error: Source file should not be same as destination file.\n");
		exit(1);
	}

	/* ̓t@Cǂݍ݂܂B */
	fp = fopen(srcname, "rb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to open file %s.\n", srcname);
		exit(1);
	}
	fseek(fp, 0, SEEK_END);
	srclen = ftell(fp);
	if(!srclen && (mode == 'd')) {	//WJ('d')Ȃ΁A0oCg̈kf[^͗L蓾Ȃ߁AG[Ƃ܂Bkf[^́A12oCgȏł͂łB
		fprintf(stderr, "Error: Source file should not be empty.");
		exit(1);
	}
	rewind(fp);
	srcbuf = malloc(srclen);
	if(!srcbuf) {
		fprintf(stderr, "Error: Failed to allocate source buffer.\n");
		exit(1);
	}
	fread(srcbuf, 1, srclen, fp);
	fclose(fp);

	if(mode == 'e') {
		/* VtgB */
		for(i = 0; i < srclen; i++) {
			if((((unsigned char)(srcbuf[i] << (8 - bits))) >> (8 - bits)) != srcbuf[i]) {
				fprintf(stderr, "Error: Encoding value (%d) at [%d] is out of range.\n", srcbuf[i], i);
				exit(1);
			}
			srcbuf[i] <<= (8 - bits);
		}
		/* kB */
		dstlen = DeltaRunHuffmanEncoder_Encode(srcbuf, srclen, NULL, 0);
		dstbuf = malloc(dstlen);
		if(!dstbuf) {
			fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
			exit(1);
		}
		DeltaRunHuffmanEncoder_Encode(srcbuf, srclen, dstbuf, dstlen);
		/* xt@CB */
		verbuf = malloc(srclen);
		if(!verbuf) {
			fprintf(stderr, "Error: Failed to allocate verify buffer.\n");
			exit(1);
		}
		verlen = DeltaRunHuffmanDecoder_Decode(dstbuf, verbuf, srclen);
		if((verlen != srclen) || memcmp(verbuf, srcbuf, srclen)) {
			fprintf(stderr, "Internal error: Verify failed.n");
			exit(1);
		}
	}
	if(mode == 'd') {
		/* WJB */
		dstlen = DeltaRunHuffmanDecoder_Decode(srcbuf, NULL, 0);
		dstbuf = malloc(dstlen);
		if(!dstbuf) {
			fprintf(stderr, "Error: Failed to allocate destination buffer.\n");
			exit(1);
		}
		DeltaRunHuffmanDecoder_Decode(srcbuf, dstbuf, dstlen);
		/* VtgB */
		for(i = 0; i < dstlen; i++) {
			if((((unsigned char)(dstbuf[i] >> (8 - bits))) << (8 - bits)) != dstbuf[i]) {
				fprintf(stderr, "Error: Decoded value (%d) at [%d] is out of range.\n", dstbuf[i], i);
				exit(1);
			}
			dstbuf[i] >>= (8 - bits);
		}
	}

	/* o̓t@C݂܂B */
	fp = fopen(dstname, "wb");
	if(!fp) {
		fprintf(stderr, "Error: Failed to create file %s.\n", dstname);
		exit(1);
	}
	fwrite(dstbuf, 1, dstlen, fp);
	fclose(fp);

	/* |[g\B */
	printf("%s (%d) => %s (%d) : %d%%\n",
		srcname, srclen,
		dstname, dstlen,
		(int)ceil((double)dstlen * 100.0 / (double)srclen));

	return 0;
}
