/*
 *	dpbmppp - rbg}bvvvZbT
 *	Copyright (C) 2007 Naoyuki Sawa
 *
 *	* Thu Jan 11 21:03:55 JST 2007 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jan 13 19:45:45 JST 2007 Naoyuki Sawa
 *	- 3sNŽ摜"-s50%"2sNZ摜ɏk悤ȏꍇ̏ύX܂B
 *	- ܂ł́AP3sNZ2sNZɏkĂ܂B
 *	  Ał66%kƂȂAɂ̓[U[̊҂錋ʂƈقȂ܂B
 *	- ŁAo͉摜̃LoXTCY2sNZłA3sNZ1.5sNZƍlďk悤AύX܂B
 *	  摜4sNZƍlāA4sNZ2sNZ50%kƌ邱Ƃł܂B
 *	  {A摜ɂ͊܂܂ĂȂ4sNZڂJ[擾ۂɂ͂́Aƍlď܂B
 *	  Ȃ킿A"-b"w肷΂̃J[ƍlĉdςA"-b"w肵ȂΉdςɊ܂߂܂B
 *	- ȏ̕ύXɂA9x9sNZtHg摜50%k悤ȏꍇɁA܂ł50%ǩʂ҂ł܂B
 *	  o͉摜TCY5x5sNZł܂łƓłA摜̓e4.5x4.5sNZւ̃TvƂȂ邩łB
 *	- "-w??%","-h??%","-s??%"g킸A"-w??","-h??","-s??"ŒڃsNZw肵ꍇ́A܂łƓʂƂȂ܂B
 *	* Sun Jan 14 00:01:23 JST 2007 Naoyuki Sawa
 *	- 摜̕\ǉ܂B
 *	- 摜\ȂA"-q"IvVǉ܂B
 *	* Thu Jan 18 01:34:05 JST 2007 Naoyuki Sawa
 *	 - resample()֐̃ASY`FbNR[ĥĂ̂ŁA`FbNR[h폜܂B
 *	   Oo[Wł́Aɑ΂ĂAT[gĂ܂ƂsĂ܂B
 *	   ̃`FbNR[h폜ɂApȃAT[g܂B
 *	* Mon Feb 05 12:44:07 JST 2007 Naoyuki Sawa
 *	- -w,-h,-sIvVɁAwǉ܂B
 *	  wǉŔAȉ̂ƂłB
 *	- ܂ŁAVGA𑜓x͉̓摜AP/ECE𑜓xɕϊꍇAsNZw%wł͍؂ꂸAɐmȎw肪ł܂łB
 *	  Ƃ΁A256x256sNZ͉̓摜ɏq̕ϊsꍇA100~88/480=46.933ƂȂAsNZwł͌ɐmȎw肪ł܂B
 *	  ܂A88/480=0.18333ƂȂAp[ZgwłɐmȎw肪ł܂B
 *	- ǉwg΁A"-h88/480"Ǝw肷邱ƂɂAɐmȎw肪\ƂȂ܂B
 */
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>

#define VERSION	"20070205"

/****************************************************************************
 *	
 ****************************************************************************/

char src_path[_MAX_PATH];	/* ̓t@C */
char dst_path[_MAX_PATH];	/* o̓t@C */
int opt_w1;	/* w                                            */
int opt_w2;	/*   w薳      w1=0         , w2=0               */
		/*   sNZw  w1=sNZ, w2=0               */
		/*   %w         w1=%         , w2=100             */
		/*   w      w1=q      , w2=            */
		/*   (ǂ̏ꍇA͌ɕq/ɐݒ肵܂) */
int opt_h1;	/* w                                          */
int opt_h2;	/*   (opt_w1,w2ƓlBRgQƂĂ) */
int opt_b;	/* J[0Ɩݒʂ邽߂ɁA+1Ă܂ */
int opt_c;	/* sFB256ȂΓFł */
int opt_q;	/* 摜\܂ */

#define MAX_SIZE	4096
unsigned char src_bits[MAX_SIZE][MAX_SIZE];	/* ͉摜 */
unsigned char dst_bits[MAX_SIZE][MAX_SIZE];	/* o͉摜 */
RGBQUAD pal[256];				/* pbg */
int trans;					/* ȏ̐F́AFƌȂ܂ */

int src_w;	/* ̓LoX̕   (sNZP) */
int src_h;	/* ̓LoX̍ (sNZP) */
int dst_w;	/* o̓LoX̕   (sNZP) */
int dst_h;	/* o̓LoX̍ (sNZP) */

void err(const char* fmt, ...);
void usage();
void cmdline(int argc, char* argv[]);
void loadbmp();
void resample();
void savebmp();

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	/* R}hC͂܂B */
	cmdline(argc, argv);

	/* ͉摜[h܂B */
	loadbmp();

	/* o͉摜TCY肵܂B */
	if(!opt_w2) { /* w薳 or sNZw */
		opt_w2 = src_w;
		if(!opt_w1) { /* w薳 */
			opt_w1 = src_w;
		}
	}
	dst_w = (src_w * opt_w1 + (opt_w2 - 1)) / opt_w2;
	if(dst_w > MAX_SIZE) err("o͉摜傫܂");
	//
	if(!opt_h2) { /* w薳 or sNZw */
		opt_h2 = src_h;
		if(!opt_h1) { /* w薳 */
			opt_h1 = src_h;
		}
	}
	dst_h = (src_h * opt_h1 + (opt_h2 - 1)) / opt_h2;
	if(dst_h > MAX_SIZE) err("o͉摜傫܂");

	/* 摜\܂B */
	if(!opt_q) {
		printf("͉摜\n");
		printf("@̧ٖ    : %s\n", src_path);
		printf("@޽: %d x %d\n", src_w, src_h);
		printf("@Ұ : %f x %f\n", (double)src_w * opt_w2 / opt_w2,
						  (double)src_h * opt_h2 / opt_h2);
		printf("o͉摜\n");
		printf("@̧ٖ    : %s\n", dst_path);
		printf("@޽: %d x %d\n", dst_w, dst_h);
		printf("@Ұ : %f x %f\n", (double)src_w * opt_w1 / opt_w2,
						  (double)src_h * opt_h1 / opt_h2);
	}

	/* Tvs܂B */
	resample();

	/* o͉摜Z[u܂B */
	savebmp();

	return 0;
}

/****************************************************************************
 *	err
 ****************************************************************************/

void
err(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
	abort();
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "dpbmppp - ޯϯ۾ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2007 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "g:\n");
	fprintf(stderr, "    dpbmppp [߼] ̧ٖ[.bmp] o̧ٖ[.bmp]\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "߼:\n");
	fprintf(stderr, "    -w߸ِ   <> -w128  ނ128߸قػق܂\n");
	fprintf(stderr, "    -wg嗦%%   <> -w200%% ނ͉摜200%%ػق܂\n");
	fprintf(stderr, "    -wq/   <> -w128/640 ނ128/640̊ػق܂\n");
	fprintf(stderr, "    -hc߸ِ   <> -h88   cނ88߸قػق܂\n");
	fprintf(stderr, "    -hcg嗦%%   <> -h75%%  cނ͉摜75%%ػق܂\n");
	fprintf(stderr, "    -hq/   <> -w88/480 cނ88/480̊ػق܂\n");
	fprintf(stderr, "    -sc߸ِ <> -s256  cނ256߸قػق܂\n");
	fprintf(stderr, "    -scg嗦%% <> -s50%%  cނ͉摜50%%ػق܂\n");
	fprintf(stderr, "    -sq/   <> -s2/3  cނ2/3̊ػق܂\n");
	fprintf(stderr, "    -bEwiF  <> -b0    ػَɓ߸قƕs߸قꍇ\n");
	fprintf(stderr, "                              s߸ق̐FƉ肵ĉdς܂\n");
	fprintf(stderr, "                              wiɍFŕ`÷ĉ摜kꍇ\n");
	fprintf(stderr, "                              Ȃǂɂ̵߼݂gďkƤs邢\n");
	fprintf(stderr, "                              wi摜ɂ܂n÷ĉ摜쐬ł܂\n");
	fprintf(stderr, "                              ̵߼݂w肵ȂΤ߸ق͉d0ł\n");
	fprintf(stderr, "                       -b3    F÷ĉ摜ƈÂwiF̑g̏ꍇ͂\n");
	fprintf(stderr, "                       -b15   ̑gŤ16Kp̔÷ĉ摜̏ꍇͤ\n");
	fprintf(stderr, "    -csF  <> -c2    װ2Ƃȍ~𓧖FƌȂ܂(1bitϽ`)\n");
	fprintf(stderr, "                       -c4    װ4Ƃȍ~𓧖FƌȂ܂(2bitϽ`)\n");
	fprintf(stderr, "                       -c16   װ16Ƃȍ~𓧖FƌȂ܂(4bitϽ`)\n");
	fprintf(stderr, "                       -c256  FƌȂ܂B(1bit2bit4bit`)\n");
	fprintf(stderr, "                              ̵߼݂w肵ȂΤڰقłȂŏ\n");
	fprintf(stderr, "                              FƂȍ~𓧖FƌȂĤo܂\n");
	fprintf(stderr, "                              ʏ̵ͤ߼݂w肷Kv͂܂\n");
	fprintf(stderr, "                              炩̗RŤsFɉɸڰوȊO̐F\n");
	fprintf(stderr, "                              ݒ肵Ă悤ȤȏꍇɎw肵Ă\n");
	fprintf(stderr, "    -q            <> -q     摜\܂\n");
	exit(1);
}

/****************************************************************************
 *	cmdline
 ****************************************************************************/

static void
cmdline_whs(char* arg, int* p1, int* p2)
{
	if(*p1 || *p2) usage();
	*p1 = strtol(arg, &arg, 10);
	if(*p1 <= 0) usage();
	if(*arg) {
		switch(*arg) {
		case '%':
			arg++;
			*p2 = 100;
			break;
		case '/':
			arg++;
			*p2 = strtol(arg, &arg, 10);
			if(*p2 <= 0) usage();
			break;
		//default:
		//	//ł܂Ƃ߂ăG[
		}
		if(*arg) usage(); /* ]Ȍ㑱 */
	}
}

void
cmdline(int argc, char* argv[])
{
	int i;
	char opt;
	char* arg;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];

	for(i = 1; i < argc; i++) {
		arg = argv[i];
		if(*arg == '-' ||
		   *arg == '/') {
			arg++;
			opt = *arg++;
			switch(opt) {
			case 'w':
				cmdline_whs(arg, &opt_w1, &opt_w2);
				break;
			case 'h':
				cmdline_whs(arg, &opt_h1, &opt_h2);
				break;
			case 's':
				cmdline_whs(arg, &opt_w1, &opt_w2);
				cmdline_whs(arg, &opt_h1, &opt_h2);
				break;
			case 'b':
				if(opt_b) usage();
				opt_b = strtol(arg, &arg, 10) + 1;	/* J[0Ɩݒʂ邽߂ɁA+1Ă܂ */
				if((opt_b <= 0) || *arg) usage();
				break;
			case 'c':
				if(opt_c) usage();
				opt_c = strtol(arg, &arg, 10);
				if((opt_c <= 0) || *arg) usage();
				break;
			case 'q':
				if(opt_q) usage();
				opt_q = 1;
				if(*arg) usage();
				break;
			default:
				usage();	/* sȃIvV */
			}
		} else {
			_splitpath(arg, drive, dir, fname, ext);
			if(!*src_path) {							/* ̓t@CݒȂ... */
				_makepath(src_path, drive, dir, fname, *ext ? ext : ".bmp");	/* ̓t@CɊi[܂B */
			} else if(!*dst_path) {							/* o̓t@CݒȂ... */
				_makepath(dst_path, drive, dir, fname, *ext ? ext : ".bmp");	/* o̓t@CɊi[܂B */
			} else {
				usage();	/* t@COȏw肳Ă܂BsȃR}hCłB */
			}
		}
	}
	if(!*src_path || !*dst_path) usage();	/* ̓t@CA܂́Ao̓t@Cw肳Ă܂B */
	if(!strcmpi(src_path, dst_path)) err("̧ٖƏo̧ٖɓ̧ٖw肵Ȃł");
}

/****************************************************************************
 *	loadbmp
 ****************************************************************************/

void
loadbmp()
{
	FILE* fp;

	int retval;
	int i;
	int y;
	int pitch;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;

	/* ̓t@CJ܂B */
	fp = fopen(src_path, "rb");
	if(!fp) err("̧قJ܂");

	/* t@Cwb_ǂݍ݂܂B */
	retval = fread(&bf, 1, sizeof(BITMAPFILEHEADER), fp);
	if(retval != sizeof(BITMAPFILEHEADER)) err("̧ͯނsł");
	if(memcmp(&bf.bfType, "BM", 2)) err("̧ͯނsł");

	/* rbg}bvwb_ǂݍ݂܂B */
	retval = fread(&bi, 1, sizeof(BITMAPINFOHEADER), fp);
	if(retval != sizeof(BITMAPINFOHEADER)) err("ޯϯͯނsł");
	if(bi.biSize < sizeof(BITMAPINFOHEADER)) err("ޯϯͯނsł");
	if(bi.biPlanes != 1) err("256FBMP`ȊO͖Ήł");
	if(bi.biBitCount != 8) err("256FBMP`ȊO͖Ήł");
	if(bi.biCompression != BI_RGB) err("256FBMP`ȊO͖Ήł");

	/* pbgǂݍ݂܂B */
	i = bi.biClrUsed != 0 ? bi.biClrUsed
	                      : bi.biPlanes << bi.biBitCount;
	if(i < 0 || 256 < i) err("گĂsł");
	retval = fread(pal, sizeof(RGBQUAD), i, fp);
	if(retval != i) err("گĂsł");

	/* OCXP[łȂŏ̐FƂȍ~AFƌȂ܂B */
	if(opt_c) {
		trans = opt_c;
	} else {
		for(i = 0; i < 256; i++) {
			if(pal[i].rgbRed != pal[i].rgbGreen ||
			   pal[i].rgbRed != pal[i].rgbBlue) {
				break;
			}
		}
		trans = i; /* FȂ256ɂȂ܂ */
	}

	/* ͉摜TCY߂܂B */
	src_w = bi.biWidth;
	src_h = bi.biHeight;
	if((src_w > MAX_SIZE) || (src_h > MAX_SIZE)) err("͉摜傫܂");

	/* sb`߂܂B */
	pitch = (src_w + 3) & ~3; /* dl */

	/* ͉摜ǂݍ݂܂B */
	retval = fseek(fp, bf.bfOffBits, SEEK_SET);
	if(retval) err("װł");
	for(y = src_h - 1; y >= 0; y--) { /* {gAbv */
		retval = fread(&src_bits[y][0], 1, pitch, fp);
		if(retval != pitch) err("ǂݍݴװł");
	}

	/* ̓t@C܂B */
	fclose(fp);
}

/****************************************************************************
 *	resample
 ****************************************************************************/

/* LkASÝACLiPCusurface_stretch()֐ƓłB
 * surface_stretch()֐̃RgQƂĂB
 * Sat Jan 13 19:45:45 JST 2007 Naoyuki Sawa
 * 3sNZ50%1.5sNZk̂悤ȁATusNZPʂ̏ɕύX߁A
 * surface_stretch()֐Ƃ́AAASYقȂ悤ɂȂ܂B
 */
void
resample()
{
	unsigned __int64 dx;
	unsigned __int64 dy;
	unsigned __int64 sx;
	unsigned __int64 sy;
	unsigned __int64 x1;
	unsigned __int64 x2;
	unsigned __int64 x3;
	unsigned __int64 y1;
	unsigned __int64 y2;
	unsigned __int64 y3;
	unsigned __int64 xy;
	unsigned __int64 c1;
	unsigned __int64 c2;
	unsigned __int64 save_sx;
	unsigned __int64 save_sy;
	unsigned __int64 save_x1;
	unsigned __int64 save_y1;
	int opaque;
	int c;

	/*{{]̐[v(]1sNZÂ)*/
	sy = 0;
	y1 = opt_h1;
	for(dy = 0; dy < dst_h; dy++) {
		/*{{]̐[v(]1sNZÂ)*/
		sx = 0;
		x1 = opt_w1;
		save_sy = sy;
		save_y1 = y1;
		for(dx = 0; dx < dst_w; dx++) {
			sy = save_sy;
			y1 = save_y1;
			opaque = 0;
			c1 = 0;
			c2 = 0;
			/*{{]̐[v(]1sNZɂ͈͂̓]sNZ̕)*/
			y2 = opt_h2;
			save_sx = sx;
			save_x1 = x1;
			for(;;) {
				sx = save_sx;
				x1 = save_x1;
				y3 = y1 < y2 ? y1 : y2;
				/*{{]̐[v(]1sNZɂ͈͂̓]sNZ̕)*/
				x2 = opt_w2;
				for(;;) {
					x3 = x1 < x2 ? x1 : x2;
					xy = x3 * y3;
					if((sx < src_w) && (sy < src_h)) {
						c = src_bits[sy][sx];
					} else {
						//{{2007/01/18폜
						///* Ƃ΁A3sNZ摜"-s50%"2sNZɏkꍇɁA
						// * 摜4sNZڂQƂ̂ŁAƌȂ܂B
						// * 摜5sNZڈȍ~QƂ邱Ƃ͗L蓾܂B
						// * ȂAASYĂ܂B
						// */
						//if(((int)sx > src_w) || ((int)sy > src_h)) err("resample()֐̓װł");
						//}}2007/01/18폜
						// * Thu Jan 18 01:34:05 JST 2007 Naoyuki Sawa
						// - resample()֐̃ASY`FbNR[ĥĂ̂ŁA`FbNR[h폜܂B
						//   Oo[Wł́Aɑ΂ĂAT[gĂ܂ƂsĂ܂B
						//   ̃`FbNR[h폜ɂApȃAT[g܂B
						// - ̓Iɂ́Aq̃ASYɊւl@ԈĂ܂B
						//   2sNZȏOQƂ邱ƂA[ɗL蓾܂B
						//   Ƃ΁A32sNZ20%k̏ꍇALC[W6.4sNZɑ΂7sNZ̃LoXƂȂ܂A
						//   32~(76.4)=35AȂ킿A摜35sNZڂ܂ŎQƂ܂B(͐ł)
						// - Ȃ킯ŁÃ`FbNR[ĥłAɑ΂ăAT[gĂ܂Ƃ܂B
						//   āA`FbNR[h폜܂B
						c = trans;
					}
					if(c < trans) {
						opaque = 1;
						c1 += xy;
						c2 += xy * c;
					} else {
						if(opt_b) {
							c1 += xy;
							c2 += xy * (opt_b - 1);
						}
					}
					if(!(x1 -= x3)) {
						x1 += opt_w1;
						sx++;
					}
					if(!(x2 -= x3)) {
						break;
					}
				}
				/*}}]̐[v(]1sNZɂ͈͂̓]sNZ̕)*/
				if(!(y1 -= y3)) {
					y1 += opt_h1;
					sy++;
				}
				if(!(y2 -= y3)) {
					break;
				}
			}
			/*}}]̐[v(]1sNZɂ͈͂̓]sNZ̕)*/
			if(opaque) {
				c = (int)((c2 + (c1 / 2)) / c1);
			} else {
				c = trans;
			}
			dst_bits[dy][dx] = c;
		}
		/*}}]̐[v(]1sNZÂ)*/
	}
	/*}}]̐[v(]1sNZÂ)*/
}

/****************************************************************************
 *	savebmp
 ****************************************************************************/

void
savebmp()
{
	FILE* fp;

	int retval;
	int y;
	int pitch;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;

	/* o̓t@C쐬܂B */
	fp = fopen(dst_path, "wb");
	if(!fp) err("o̧ق쐬ł܂");

	/* sb`߂܂B */
	pitch = (dst_w + 3) & ~3; /* dl */

	/* t@Cwb_݂܂B */
	memset(&bf, 0, sizeof(BITMAPFILEHEADER));
	memcpy(&bf.bfType, "BM", 2);
	bf.bfSize = sizeof(BITMAPFILEHEADER)
		  + sizeof(BITMAPINFOHEADER)
		  + sizeof(RGBQUAD) * 256
		  + pitch * dst_h;
	bf.bfOffBits = sizeof(BITMAPFILEHEADER)
		     + sizeof(BITMAPINFOHEADER)
		     + sizeof(RGBQUAD) * 256;
	retval = fwrite(&bf, 1, sizeof(BITMAPFILEHEADER), fp);
	if(retval != sizeof(BITMAPFILEHEADER)) err("ݴװł");

	/* rbg}bvwb_݂܂B */
	memset(&bi, 0, sizeof(BITMAPINFOHEADER));
	bi.biSize = sizeof(BITMAPINFOHEADER);
	bi.biWidth = dst_w;
	bi.biHeight = dst_h;
	bi.biPlanes = 1;
	bi.biBitCount = 8;
	retval = fwrite(&bi, 1, sizeof(BITMAPINFOHEADER), fp);
	if(retval != sizeof(BITMAPINFOHEADER)) err("ݴװł");

	/* pbg݂܂B */
	retval = fwrite(pal, sizeof(RGBQUAD), 256, fp);
	if(retval != 256) err("ݴװł");

	/* o͉摜݂܂B */
	for(y = dst_h - 1; y >= 0; y--) { /* {gAbv */
		retval = fwrite(&dst_bits[y][0], 1, pitch, fp);
		if(retval != pitch) err("ݴװł");
	}

	/* o̓t@C܂B */
	fclose(fp);
}

