/*
 *	dmsgdig - bZ[W_CWFXgvZc[
 *	Copyright (C) 2009 Naoyuki Sawa
 *
 *	* Sat Jan 10 20:05:27 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#define DIE() abort()
#define __CLIP_H__
#include "../../clipcode.h"
#include "../../clipcode.c"

#define VERSION "20090110"

/////////////////////////////////////////////////////////////////////////////

int
main(int argc, char* argv[])
{
	int retval;
	int i;
	int j;
	FILE* fp;
	int len;
	unsigned char digest[20];
	//
	int digest_len = 16; /* 16 = MD5, 20 = SHA-1 */
	int with_filename = 1;
	//
	unsigned char* buf = NULL;
	int buflen = 0;

	if(argc == 1) {
		printf("dmsgdig - bZ[W_CWFXgvZc[ (%s) Naoyuki Sawa\n", VERSION);
		printf("\n");
		printf("g: dmsgdig [[IvV] t@C [[IvV] t@C [...]]]\n");
		printf("\n");
		printf("ASYIIvV:\n");
		printf("   -m   MD5ASYgp܂B    (ݒ)\n");
		printf("   -s   SHA-1ASYgp܂B\n");
		printf("t@Co̓IvV:\n");
		printf("   -H   t@Co͂܂B         (ݒ)\n");
		printf("   -h   t@Co͂܂B\n");
		printf("\n");
		printf("t@C̎wɂ́AChJ[hpł܂B\n");
		exit(1);
	}

	for(i = 1; i < argc; i++) {
		if(argv[i][0] == '-') {
			switch(argv[i][1]) {
			case 'm':
				digest_len = 16;
				break;
			case 's':
				digest_len = 20;
				break;
			case 'h':
				with_filename = 0;
				break;
			case 'H':
				with_filename = 1;
				break;
			default:
				fprintf(stderr, "### %s: IvVsłB\n", argv[i]);
				exit(1);
			}
			continue;
		}

		/* t@CJ܂B */
		fp = fopen(argv[i], "rb");
		if(!fp) {
			fprintf(stderr, "### %s: fopen s܂B\n", argv[i]);
			exit(1);
		}

		/* t@CTCY擾܂B */
		retval = fseek(fp, 0, SEEK_END);
		if(retval) {
			fprintf(stderr, "### %s: fseek s܂B\n", argv[i]);
			exit(1);
		}
		len = ftell(fp);
		if(len < 0) {
			fprintf(stderr, "### %s: ftell s܂B\n", argv[i]);
			exit(1);
		}
		rewind(fp);

		/* KvɉāAobt@g܂B */
		if(len > buflen) {
			buflen = len;
			buf = realloc(buf, buflen);
			if(!buf) {
				fprintf(stderr, "### %s: realloc s܂B\n", argv[i]);
				exit(1);
			}
		}

		/* t@Cǂݍ݁A܂B */
		retval = fread(buf, 1, len, fp);
		if(retval != len) {
			fprintf(stderr, "### %s: fread s܂B\n", argv[i]);
			exit(1);
		}
		fclose(fp);

		/* bZ[W_CWFXgvZAo͂܂B */
		switch(digest_len) {
		case 16:
			md5_digest(digest, buf, len);
			break;
		case 20:
			sha1_digest(digest, buf, len);
			break;
		default:
			abort(); /* L蓾Ȃ */
		}
		for(j = 0; j < digest_len; j++) {
			printf("%02x", digest[j]);
		}
		if(with_filename) {
			printf(" %s", argv[i]);
		}
		printf("\n");
	}

	return 0;
}
