#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#define LZSS_DEBUG	/* ̃V{`ƁATdɌȂs܂BvÕoOopłBvO肵ARgAEgĂB */
//{{
typedef const unsigned char LZSS_CHAR;		/* t[Y\镶P */
#define LZSS_MATCH_LEN_MAX	(15 + 2)	/* t[YɃ}b`ő咷Bŏ0Av2̈v̏ꍇAʏ͖kƂďo͂ */
#define LZSS_MATCH_DIST_MAX	(15 + 1)	/* EChETCYB݂͈̓ʒuA}b`\ȉߋ̃t[Y܂ł̍ő勗Bŏ1 */
//}}
#include "lzss.h"

/****************************************************************************
 *	LZSSp[`
 ****************************************************************************/

#pragma warning(disable: 4100)	/* ͊֐̖{̕1xQƂ܂B */
#pragma warning(disable: 4127)	/* 萔łB */
#pragma warning(disable: 4244)	/* '?''?'ɕϊ܂Bf[^Ă邩܂B */

/* oCgPʂŁALZSSksȂ܂B
 * [in]
 *	dst_data	o̓obt@
 *	dst_lim		o̓obt@̃TCY(oCgP)
 *	src_data	̓f[^
 *	src_len		̓f[^̒(oCgP)
 * [out]
 *	߂l		kf[^̒(oCgP)
 * [note]
 *	* o̓obt@̃TCYAkf[^̒ꍇA߂͊i[܂B
 *	  ̏ꍇAkf[^̒́A{̈kf[^̒Ԃ܂B
 */
int
LZSS_compress1(unsigned char* dst_data/*[dst_lim]*/, int dst_lim, const unsigned char* src_data/*[src_len]*/, int src_len)
{
	int flag_mask = 0;
	int flag_pos = 0;
	int dst_len = 0;
	int src_pos;
	int match_len;
	int match_dist;
	int hdr;
	int i;

	/* c[ */
	src_pos = LZSS_init(src_data, src_len);
	while(src_pos < src_len) {
		/* tÖmۂ */
		if(!flag_mask) {
			flag_mask = 1 << 7;
			flag_pos = dst_len++;
			if(flag_pos < dst_lim) {
				dst_data[flag_pos] = 0;
			}
		}
		/* Œvt[Y */
		match_len = LZSS_search(&match_dist);
		/* v2ȏȂ΁AkR[hƂďo͂ */
		if(match_len >= 2) {
			/* kR[hƂ {(match_dist-1),(match_len-2)} o͂ */
			hdr = (match_len - 2) | ((match_dist - 1) << 4);
			if(dst_len < dst_lim) {
				dst_data[dst_len] = hdr;
			}
			dst_len++;
			/* @̕A͈ʒui߂ */
			src_pos = LZSS_advance();
			/* 1ڈȍ~́Av͈͈͂̓ʒuXLbv */
			for(i = 1; i < match_len; i++) {
				/* XLbv͈͂̃f[^Ac[ɔf邱ƂYꂸ */
				LZSS_search(NULL); /* A */
				/* A̕A͈ʒui߂ */
				src_pos = LZSS_advance();
			}
		/* v2Ȃ΁AkR[hƂďo͂ */
		} else {
			/* kR[hł邱Ƃ߁AtOZbg */
			if(flag_pos < dst_lim) {
				dst_data[flag_pos] |= flag_mask;
			}
			/* kR[ho͂ */
			if(dst_len < dst_lim) {
				dst_data[dst_len] = src_data[src_pos];
			}
			dst_len++;
			/* @̕A͈ʒui߂ */
			src_pos = LZSS_advance();
		}
		/* tOrbgʒui߂ */
		flag_mask >>= 1;
	}

	return dst_len;
}

/*---------------------------------------------------------------------------*/

/* oCgPʂLZSSkꂽf[^AWJ܂B
 * [in]
 *	dst_data	o̓obt@
 *	dst_lim		o̓obt@̃TCY(oCgP)
 *	src_data	̓f[^
 *	src_len		̓f[^̒(oCgP)
 * [out]
 *	߂l		WJf[^̒(oCgP)
 * [note]
 *	* o̓obt@̃TCYAWJf[^̒ꍇA߂͊i[܂B
 *	  ̏ꍇAWJf[^̒́A{̓WJf[^̒Ԃ܂B
 */
int
LZSS_uncompress1(unsigned char* dst_data/*[dst_lim]*/, int dst_lim, const unsigned char* src_data/*[src_len]*/, int src_len)
{
	int flag_mask = 0;
	int flag = 0;
	int dst_len = 0;
	int src_pos = 0;
	int hdr;
	int len;
	int dist;
	int pos;

	while(src_pos < src_len) {
		/* tO擾 */
		if(!flag_mask) {
			flag_mask = 1 << 7;
			flag = src_data[src_pos++];
		}
		/* kR[h̏ꍇ */
		if(!(flag & flag_mask)) {
			/* kR[h {(match_dist-1),(match_len-2)} 擾 */
			hdr = src_data[src_pos++];
			len = (hdr & 15) + 2;
			dist = (hdr >> 4) + 1;
			/* kR[hWJ */
			pos = dst_len - dist;
			do {
				if(dst_len < dst_lim) {
					dst_data[dst_len] = dst_data[pos];
				}
				dst_len++;
				pos++;
			} while(--len);
		/* kR[h̏ꍇ */
		} else {
			/* kR[ho͂ */
			if(dst_len < dst_lim) {
				dst_data[dst_len] = src_data[src_pos];
			}
			dst_len++;
			src_pos++;
		}
		/* tOrbgʒui߂ */
		flag_mask >>= 1;
	}

	return dst_len;
}

