/*
 *	dlib33 - lib33Cut@C\[eBeB
 *	Copyright(C) 2006 Naoyuki Sawa
 *
 *	* Sun Jun 04 13:01:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Jun 05 05:45:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#define VERSION		"20060604"

#define BEWORD(p)	((unsigned int)(((unsigned char*)(p))[0]<<24|((unsigned char*)(p))[1]<<16|((unsigned char*)(p))[2]<<8|((unsigned char*)(p))[3]<<0))

const char sig_lib33[] = { '!', '<', 'l', 'i', 'b', '3', '3', '>', '\0' };	/* Cuwb_VOl` */
const char sig_symdef[] = { '\x06', 'S', 'Y', 'M', 'D', 'E', 'F' };		/* V{e[uVOl` */

/* G[bZ[W\āAI܂B
 */
void
die(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
	exit(-1);
}

/* g\āAI܂B
 */
void
usage()
{
	fprintf(stderr, "dlib33 - lib33Cut@C\[eBeB (%s)\n", VERSION);
	fprintf(stderr, "Copyright(C) 2006 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE: dlib33 filename[.lib]\n");
	exit(-1);
}

int
main(int argc, char* argv[])
{
	int retval;
	//
	char path[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	//
	FILE* fp;
	//
	unsigned char* lib;	/* Cut@Cǂݍރobt@ */
	int lib_size;		/* Cut@CTCY */
	//
	int pos;		/* p */
	//
	int symdef_start;	/* V{e[u̐擪ʒu */
	int symdef_end;		/* V{e[ȕI[ʒu */
	int symdef_size;	/* V{e[uTCY */
	//
	int syminfo_start;	/* V{e[u̐擪ʒu */
	int syminfo_end;	/* V{e[ȕI[ʒu */
	int syminfo_size;	/* V{e[uTCY */
	//
	int symname_start;	/* V{̃e[u̐擪ʒu */
	int symname_end;	/* V{̃e[ȕI[ʒu */
	int symname_size;	/* V{̃e[uTCY */
	//
	int module_start;	/* W[e[u̐擪ʒu */
	int module_end;		/* W[e[ȕI[ʒu */
	int modbody_size;	/* W[{̃TCY */
	int modname_size;	/* W[̃TCY */
	//
	int i_symbol;		/* V{CfNX */
	int modname_pos;	/* W[̈ʒu */
	int symname_pos;	/* V{̈ʒu */
	//
	int i;			/* Ɨp */
	int tmp_pos;		/* Ɨp */
	int i_symbol_width;	/* V{CfNX̏o͕ */
	int symname_width;	/* V{̂̏o͕ */

	/*--------------------------------------------------------------------------------------------------------------*/
	/*	ǂݍ												*/
	/*--------------------------------------------------------------------------------------------------------------*/

	/* Cut@CJ܂B */
	if(argc != 1 + 1) {
		usage();
	}
	_splitpath(argv[1], drive, dir, fname, ext);
	if(!strlen(ext)) {
		strcpy(ext, ".lib");
	}
	_makepath(path, drive, dir, fname, ext);
	fp = fopen(path, "rb");
	if(!fp) {
		die("%sJ܂B", path);
	}

	/* Cut@CTCY擾܂B */
	retval = fseek(fp, 0, SEEK_END);
	if(retval < 0) {
		die("Cut@CTCY̎擾s܂B");
	}
	lib_size = ftell(fp);
	if(lib_size < 0) {
		die("Cut@CTCY̎擾s܂B");
	}
	rewind(fp); /* YȂ!! */

	/* Cut@Cǂݍރobt@mۂ܂B */
	lib = malloc(lib_size);
	if(!lib) {
		die("Cut@Cǂݍރobt@mۂł܂B");
	}

	/* Cut@Cǂݍ݂܂B */
	retval = fread(lib, 1, lib_size, fp);
	if(retval != lib_size) {
		die("Cut@C̓ǂݍ݂s܂B");
	}

	/* Cut@C܂B */
	fclose(fp);

	/*--------------------------------------------------------------------------------------------------------------*/
	/*	\mF												*/
	/*--------------------------------------------------------------------------------------------------------------*/

	pos = 0;

	/* Cuwb_VOl`mF܂B */
	if((pos + (int)sizeof sig_lib33 > lib_size) ||
	   (memcmp(lib + pos, sig_lib33, sizeof sig_lib33) != 0)) {
		die("Cuwb_VOl`słB");
	}
	pos += sizeof sig_lib33;

	/* V{e[uTCY擾܂B */
	if(pos + 4 > lib_size) {
		die("V{e[uTCY擾ł܂B");
	}
	symdef_size = BEWORD(lib + pos);
	if(symdef_size < 0) {
		die("V{e[uTCYsłB");
	}
	pos += 4;

	/* V{e[uVOl`mF܂B */
	if((pos + (int)sizeof sig_symdef > lib_size) ||
	   (memcmp(lib + pos, sig_symdef, sizeof sig_symdef) != 0)) {
		die("V{e[uVOl`słB");
	}
	pos += sizeof sig_symdef;

	/* V{e[u̐擪擾܂B */
	symdef_start = pos;

	/* V{e[ȕI[擾܂B */
	symdef_end = pos + symdef_size;
	if(symdef_end > lib_size) {
		die("V{e[uTCYsłB");
	}

	/* V{e[uTCY擾܂B */
	if(pos + 4 > symdef_end) {
		die("V{e[uTCY擾ł܂B");
	}
	syminfo_size = BEWORD(lib + pos);
	if(syminfo_size < 0) {
		die("V{e[uTCYsłB");
	}
	pos += 4;

	/* V{e[u̐擪擾܂B */
	syminfo_start = pos;

	/* V{e[uXLbv܂B */
	pos += syminfo_size;

	/* V{e[ȕI[擾܂B */
	syminfo_end = pos;
	if(syminfo_end > symdef_end) {
		die("V{e[uTCYsłB");
	}

	/* V{̃e[uTCY擾܂B */
	if(pos + 4 > symdef_end) {
		die("V{̃e[uTCY擾ł܂B");
	}
	symname_size = BEWORD(lib + pos);
	if(symname_size < 0) {
		die("V{̃e[uTCYsłB");
	}
	pos += 4;

	/* V{̃e[u̐擪擾܂B */
	symname_start = pos;

	/* V{̃e[uXLbv܂B */
	pos += symname_size;

	/* V{̃e[ȕI[擾܂B */
	symname_end = pos;
	if(symname_end > symdef_end) {
		die("V{̃e[uTCYsłB");
	}

	/* V{e[ȕI[AV{̃e[ȕI[Ɉv邱ƂmF܂B */
	if(symdef_end != symname_end) {
		die("V{e[ȕI[słB");
	}

	/* W[e[u̐擪擾܂B */
	module_start = pos;

	/* eW[ɂ... */
	while(pos < lib_size) {
		/* W[{̃TCY擾܂B */
		if(pos + 4 > lib_size) {
			die("W[{̃TCY擾ł܂B");
		}
		modbody_size = BEWORD(lib + pos);
		if(modbody_size < 0) {
			die("W[{̃TCYsłB");
		}
		pos += 4;

		/* W[̃TCY擾܂B */
		if(pos + 1 > lib_size) {
			die("W[̃TCY擾ł܂B");
		}
		modname_size = lib[pos++];
		if(modname_size < 0) {
			die("W[̃TCYsłB");
		}

		/* W[̂ƃW[{̂XLbv܂B */
		pos += modname_size + modbody_size;
		if(pos > lib_size) {
			die("W[̃TCYA܂́AW[{̃TCYsłB");
		}
	}

	/* W[e[ȕI[擾܂B */
	module_end = pos;

	/* W[e[ȕI[ACut@C̏I[Ɉv邱ƂmF܂B */
	if(module_end != lib_size) {
		die("W[e[ȕI[słB");
	}

	/*--------------------------------------------------------------------------------------------------------------*/
	/*	\												*/
	/*--------------------------------------------------------------------------------------------------------------*/

	i_symbol_width = 1;
	symname_width = 1;

	/* ڂŏo͕肵Aڂŏo͂܂B */
	for(i = 0; i < 2; i++) {

		/* eV{ɂ... */
		for(i_symbol = 0, pos = syminfo_start; pos < syminfo_end; i_symbol++) {

			/* W[ʒu擾܂B */
			if(pos + 4 > syminfo_end) {
				die("W[ʒu擾ł܂B");
			}
			tmp_pos = BEWORD(lib + pos); /* t@C擪̐ΈʒuŊi[Ă܂ */
			pos += 4;

			/* W[̃TCYƃW[̈ʒu擾܂B */
			tmp_pos += 4/*W[{̃TCY*/;
			if(tmp_pos < module_start) {
				die("W[ʒusłB");
			}
			if(tmp_pos + 1/*W[̃TCY*/ > module_end) {
				die("W[ʒusłB");
			}
			modname_size = lib[tmp_pos++];
			if(modname_size < 0) {
				die("W[ʒusłB");
			}
			modname_pos = tmp_pos;
			if(modname_pos + modname_size > module_end) {
				die("W[ʒusłB");
			}

			/* V{̃ItZbg擾܂B */
			if(pos + 4 > syminfo_end) {
				die("V{̈ʒu擾ł܂B");
			}
			tmp_pos = BEWORD(lib + pos); /* V{̃e[u擪̑ΈʒuŊi[Ă܂ */
			pos += 4;

			/* V{̈ʒu擾܂B */
			symname_pos = symname_start + tmp_pos;
			if((symname_pos < symname_start) ||
			   (symname_pos > symname_end - 1)) {
				die("V{̈ʒusłB");
			}

			if(!i) { /*  */
				/* V{̂̏o͕߂܂B */
				int len = strlen(lib + symname_pos);
				if(len > symname_width) {
					symname_width = len;
				}
			} else { /*  */
				/* V{CfNXAV{́AW[̂\܂B */
				printf("%*d: %-*s %.*s\n",
					i_symbol_width, i_symbol,
					symname_width, lib + symname_pos,
					modname_size, lib + modname_pos);
			}
		}

		if(!i) { /*  */
			/* V{CfNX̏o͕߂܂B */
			for(;;) {
				i_symbol /= 10;
				if(!i_symbol) {
					break;
				}
				i_symbol_width++;
			}
		}
	}

	return 0;
}
