/*
 *	dbase64enc - Base64 encode/decode tool
 *	Copyright (C) 2008 Naoyuki Sawa
 *
 *	* Mon Nov 17 13:25:55 JST 2008 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Nov 18 02:02:06 JST 2008 Naoyuki Sawa
 *	- fR[hɁA̓Xg[̉s󔒕ǂݔ΂悤ύX܂B
 *	  {ABase64GR[hꂽeLXg̒ɉs󔒕LĂ͂Ȃ̂łA
 *	  GۃGfB^ŔɒsȂAǂ݈Ղ̂߂ɁAs󔒕܂߂ƕ֗łB
 *	  ŁA̓Xg[̉s󔒕́Aǂݔ΂Ƃɂ܂B
 *	- LύXɕāAGR[hɂšw肵ĉso͂悤A"-c<cols>"IvVǉ܂B
 *	  "-c<cols>"IvVw肷ƁAšƂƁAŏIs̖ɉso͂܂B
 *	  "-c<cols>"IvVw肵Ȃ΁A܂łǂSĂsŏo͂Aɂso͂܂B
 *	- udbase64enc.exevƁudurlenc.exevpCvŘAĎg@ɂāAudurlencṽRgQƂĂB
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#define DIE() abort()
#define __CLIP_H__
#include "../../clipcode.h"
#include "../../clipcode.c"

#define VERSION "20081118"

/////////////////////////////////////////////////////////////////////////////

void
usage()
{
	printf("dbase64enc - Base64 encode/decode tool (%s) Naoyuki Sawa\n", VERSION);
	printf("Usage: [-e] [-c<cols>] input-file-name(binary data) > output-text-stream(encoded text)\n");
	printf("        -d             output-file-name(binary data) <  input-text-stream(encoded text)\n");
	printf("Options:\n");
	printf("  -e       : encode input file (default)\n");
	printf("  -d       : decode input text\n");
	printf("Encode options:\n");
	printf("  -c<cols> : output text columns\n");
	exit(1);
}

int mode; /* 'd' or 'e' */
int cols;
char filename[_MAX_PATH];

#define BUFFER_SIZE	(16 * 1024 * 1024)	/*  */
int srclen;
unsigned char srcbuf[BUFFER_SIZE];
int dstlen;
unsigned char dstbuf[BUFFER_SIZE];

int
main(int argc, char* argv[])
{
	int c;
	int i;
	FILE* fp;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		switch(argv[i][0]) {
		case '-':
		case '/':
			switch(tolower(argv[i][1])) {
			case 'd':
			case 'e':
				if(!mode) {
					mode = tolower(argv[i][1]);
					break;
				}
				usage();
				break;
			case 'c':
				if(!cols) {
					cols = atoi(&argv[i][2]);
					if(cols <= 0) {
						usage();
					}
					break;
				}
				usage();
				break;
			default:
				usage();
				break;
			}
			break;
		default:
			if(!filename[0]) {
				strcpy(filename, argv[i]);
				break;
			}
			usage();
			break;
		}
	}
	/* "-d""-e"w肳ĂȂ΁A"-e"Ƃ܂B */
	if(!mode) {
		mode = 'e';
	}
	/* fR[h́A"-c<cols>"IvVwsłB */
	if((mode == 'd') && cols) {
		usage();
	}
	/* t@C͕K{łB */
	if(!filename[0]) {
		usage();
	}

	switch(mode) {
	case 'e':
		/* ̓t@C(oCi)ǂݍ݂܂B */
		fp = fopen(filename, "rb");
		if(!fp) {
			fprintf(stderr, "Error: Failed to open file %s.\n", filename);
			exit(1);
		}
		srclen = fread(srcbuf, 1, BUFFER_SIZE, fp);
		fclose(fp);
		/* GR[h܂B */
		dstlen = base64_encode(dstbuf, BUFFER_SIZE, srcbuf, srclen);
		/* o̓Xg[(eLXg)֏o܂B */
		for(i = 0; i < dstlen; i++) {
			c = dstbuf[i];
			fputc(c, stdout);
			if(cols) { /* "-c<cols>"IvVw肳ĂAKɉso͂܂ */
				if(((i % cols) == (cols - 1)) || (i == (dstlen - 1))) {
					fputc('\n', stdout);
				}
			}
		}
		break;
	case 'd':
		/* ̓Xg[(eLXg)Sǂݍ݂܂B */
		for(;;) {
			c = fgetc(stdin);
			if(c == EOF) {
				break;
			}
			if(isspace(c)) { /* ̓Xg[́As󔒕͓ǂݔ΂܂ */
				continue;
			}
			if(srclen >= (BUFFER_SIZE - 1/*nulI[̕*/)) { /* fR[h̏ꍇnulI[lāABUFFER_SIZE1oCgȂTCY܂łƂ܂ */
				fprintf(stderr, "Error: Input text is too large.\n");
				exit(1);
			}
			srcbuf[srclen++] = c;
		}
		/* fR[h܂B */
		dstlen = base64_decode(dstbuf, BUFFER_SIZE, srcbuf); /* srcbuf[]̏l0Ȃ̂ŊnulI[Ă܂ */
		/* o̓t@C(oCi)֏o܂B */
		fp = fopen(filename, "wb");
		if(!fp) {
			fprintf(stderr, "Error: Failed to create file %s.\n", filename);
			exit(1);
		}
		fwrite(dstbuf, 1, dstlen, fp);
		fclose(fp);
		break;
	default:
		DIE();
	}

	return 0;
}
