#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
__declspec(noreturn) static void usage();
static void dumpLotTbl(int indent, const int* TBL_LotTblNo/*[LotTblNo_Max+1]*/);
/****************************************************************************
 *	
 ****************************************************************************/
int main(int argc, char* argv[]) {
	FILE* fp;
	void* buf;
	int opt, len;
	//R}hCIvVB
	opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
	while((opt = getopt(argc, argv, "h")) != -1) {
		switch(opt) {
		case 'h':
		default:
			usage();
		}
	}
	//Ie[ũoCif[^ǂݍށB
	if(optind != (argc - 1)) { usage(); }	//̐s
	fp = fopen(argv[optind], "rb");
	fseek(fp, 0, SEEK_END);
	len = ftell(fp);
	rewind(fp);
	buf = malloc(len);
	if(!buf) { DIE(); }	//s
	fread(buf, 1, len, fp);
	fclose(fp);
	//Ie[u_vB
	dumpLotTbl(0, buf);
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dLotTblD - Ie[utRpC (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2015 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dLotTblD [option] LotTbl.bin\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -h g\܂B\n");
	exit(EXIT_FAILURE);
}
/*--------------------------------------------------------------------------*/
static void dumpLotTbl(int indent, const int* TBL_LotTblNo/*[LotTblNo_Max+1]*/) {
	const int nLotTblNo = TBL_LotTblNo[0];								//(I\ԍ̍ől+1)擾B
	int iLotTblNo;
	for(iLotTblNo = 1; iLotTblNo < nLotTblNo; iLotTblNo++) {
		ST_Worksheet* wsHead = Worksheet_new();
		ST_Worksheet* wsBody = Worksheet_new();
		ST_Worksheet_Iterator it;
		const unsigned short* pLotTbl = (const unsigned short*)&TBL_LotTblNo[nLotTblNo];	//I\f[^ւ̃|C^߂B(I\AhXe[u̒ɒI\f[^zuO)
		const unsigned short* table = &pLotTbl[TBL_LotTblNo[iLotTblNo]];			//I\ւ̃|C^߂B
		const int table_size = *table++;							//I\̗
		const int id_size    = *table++;							//Iids
		int column_size, i_column, i_row, i_id, id, hitval, weight;
		printf(":`%05u\n", iLotTblNo);								//o:I\id		RpCɁAiLotTblNȍŌ̒I\idɈv悤A0߂5ɑĂBȂƁAf[^̒IlƂĒI\idăNĂ镔ARpCɂĂ܂B
		for(i_column = 0; i_column < table_size; i_column++) {
			for(i_id = 0; i_id < id_size; i_id++) {
				id = *table++;
				Worksheet_set_l(wsHead, id, i_id, i_column, -1);			//(Iidsԍ,ԍ)˒Iid
			}
			column_size = *table++;								//I̗vf
			for(i_row = 0; i_row < column_size; i_row++) {
				hitval = *table++;							//Il
				weight = *table++ + 1;							//Il
				Worksheet_set_l(wsBody, weight, hitval, i_column, -1);			//(Il,ԍ)˒Il
			}
		}
		Worksheet_sort(wsHead);
		Worksheet_sort(wsBody);
		for(i_id = 0; i_id < id_size; i_id++) {
			printf("id", hitval);								//o:'id'
			for(i_column = 0; i_column < table_size; i_column++) {
				id = Worksheet_get_l(wsHead, i_id, i_column, -1);			//(Iidsԍ,ԍ)
				printf("\t,%u", id);							//o:Iid
			}
			printf("\n");
		}
		for(hitval = Worksheet_first_l(wsBody, &it, -1);
		    hitval != -1;
		    hitval = Worksheet_next(&it)) {
			printf("%u", hitval);								//o:Il
			for(i_column = 0; i_column < table_size; i_column++) {
				weight = Worksheet_get_l(wsBody, hitval, i_column, -1);			//(Il,ԍ)
				printf("\t,%u", weight);						//o:Il
			}
			printf("\n");
		}
		printf("\n");
	}
}
