/*
 *	beatangl.c
 *
 *	uVVgGXJC[vPGDRo[^
 *	Copyright (C) 2002 Naoyuki Sawa
 *
 *	@@@@@@@@@@@@@@mnshbd
 *	uSystem 3.5 for X Window System Version 1.5 (J)ṽ\[XR[hA
 *	уhLg𗘗pEQlĒ܂B
 *	uSystem 3.5 for X Window SystemvɊւẮAȉURLQƂB
 *	http://www.aist-nara.ac.jp/~masaki-c/private/unitbase/xsys35/index.html
 *	uSystem 3.5 for X Window System Version 1.5 (J)vGPLCZXłB
 *	]܂āA{vOGPLCZXƂȂ܂B
 *	GPLCZXɊւẮAYtCOPYINGt@CQƂB
 *
 *	* Sun Oct 1 03:30:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 */
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "zlib/zlib.h"
#pragma comment(lib, "zlibstat.lib")

#define REDUCE_LEVEL	(640 / 128)	/* 摜kiꗥj */
#define HEIGHT_LIMIT	88		/* kɂ荂A؂̂Ă܂ */
#define ALPHA_CUTOFF	1		/* JbgItx */
const int DITHER[8][8] = {
         0,32, 8,40, 2,34,10,42,
        48,16,56,24,50,18,58,26,
        12,44, 4,36,14,46, 6,38,
        60,28,52,20,62,30,54,22,
         3,35,11,43, 1,33, 9,41,
        51,19,59,27,49,17,57,25,
        15,47, 7,39,13,45, 5,37,
        63,31,55,23,61,29,53,21,
};

#define KEY_ESC		"Software\\AliceSoft\\VVgGXJC[" /* CXg[tH_̃WXgL[ */
#define ALD_QNT		"DOKI_GA.ALD"	/* QNTA[JCut@C */

#define ZLIBBUF_MARGIN	(16 * 1024)	/* qnt.cł5KBłAŜ߂16KBĂ݂܂ */

/****************************************************************************/

typedef struct _ALDENT {
	int	prt;		/* f[^ւ̃ItZbg */
	int	size;		/* f[^TCY */
	int	time_l;		/* 쐬 */
	int	time_h;		/* 쐬 */
	char	name[16];	/* t@C */
} ALDENT;

#define QNTHDR_SIG	"QNT\0"
typedef struct _QNTHDR {
	char	sig[4];		/* 'QNT\0' */
	int	ver;		/* GXJC[ł2 */
	int	header_size;	/* wb_TCY() */
	int	x0;		/* ʏł̕\ʒuX */
	int	y0;		/* ʏł̕\ʒuY */
	int	width;		/* CG̕[sNZ] */
	int	height;		/* CG̍[sNZ] */
	int	bpp;		/* 24Œ */
	int	rsv;		/* s(݂1H) */
	int	pixel_size;	/* ksNZf[^TCY */
	int	alpha_size;	/* kAt@f[^TCY */
} QNTHDR;

typedef struct _CG {
	int w;			/* [sNZ] */
	int h;			/* [sNZ] */
	unsigned char* pixel;	/* sNZv[(NULL:Ȃ) */
	unsigned char* alpha;	/* At@v[(NULL:Ȃ) */
} CG;

/****************************************************************************/

/****************************************************************************/

void
err(const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);

	abort();
}

/****************************************************************************/

/* GXJC[̃tH_擾 */
int
get_esc_path(char* path)
{
	int retval, n;
	HKEY hkey;

	retval = RegOpenKeyEx(HKEY_CURRENT_USER, KEY_ESC, 0, KEY_QUERY_VALUE, &hkey);
	if(retval == 0) {
		n = _MAX_PATH;
		retval = RegQueryValueEx(hkey, NULL, 0, NULL, (unsigned char*)path, (unsigned long*)&n);
		RegCloseKey(hkey);
	}

	return retval;
}

/****************************************************************************/

int
find_entry(FILE* fp, char* name)
{
	int i, size;
	int ptr;
	ALDENT ae;

	/* w肳ꂽÕGgT܂B */
	for(i = 1/*ŏ1header2ւ̃|C^ł*/; ; i++) {
		/* f[^|C^փV[NB */
		if(fseek(fp, i * 3, SEEK_SET) != 0) return 0;
		/* f[^|C^擾B */
		if(fread(&ptr, 1, 3, fp) != 3) return 0;
		ptr = (ptr & 0xffffff) << 8;
		/* f[^wb_փV[NB */
		if(fseek(fp, ptr, SEEK_SET) != 0) return 0;
		/* f[^wb_擾B */
		if(fread(&ae, 1, sizeof ae, fp) != sizeof ae) return 0;
		/* Ov... */
		if(_strcmpi(ae.name, name) == 0) { /* 啶I */
			/* f[^TCY擾B */
			size = ae.size;
			/* f[^{̂փV[NB */
			if(fseek(fp, ae.prt - sizeof ae, SEEK_CUR)) return 0;
			/* f[^{̂̃TCYԂB */
			return size;
		}
	}
	return 0;
}

/****************************************************************************/

/* sNZ`͂܂܂藝łĂ܂Bqnt.c̃\[Xقڂ̂܂܎g킹Ē܂B */
int
extract_pixel(QNTHDR* qnt, unsigned char* pixel, unsigned char* data)
{
	int i, j, x, y, w, h, ucbuf;
	unsigned char* raw;

	w = qnt->width;
	h = qnt->height;
	ucbuf = w * h * 3 + ZLIBBUF_MARGIN;
	raw = (unsigned char*)malloc(ucbuf);
	if(uncompress(raw, &ucbuf, data, qnt->pixel_size) != Z_OK) err("sNZWJsB");

	j = 0;
	for(i = 2; i >= 0; i--) {
		for(y = 0; y < (h-1); y+=2) {
			for(x = 0; x < (w-1); x+=2) {
				pixel[( y   *w+x)  *3 +i] = raw[j  ];
				pixel[((y+1)*w+x)  *3 +i] = raw[j+1];
				pixel[( y   *w+x+1)*3 +i] = raw[j+2];
				pixel[((y+1)*w+x+1)*3 +i] = raw[j+3];
				j+=4;
			}
			if(x != w) {
				pixel[( y   *w+x)*3 +i] = raw[j  ];
				pixel[((y+1)*w+x)*3 +i] = raw[j+1];
				j+=4;
			}
		}
		if(y != h) {
			for(x = 0; x < (w-1); x+=2) {
				pixel[(y*w+x  )*3+i] = raw[j  ];
				pixel[(y*w+x+1)*3+i] = raw[j+2];
				j+=4;
			}
		}
	}

	if(w > 1) {
		for(x = 1; x < w; x++) {
			pixel[x*3  ] = pixel[(x-1)*3  ] - pixel[x*3  ];
			pixel[x*3+1] = pixel[(x-1)*3+1] - pixel[x*3+1];
			pixel[x*3+2] = pixel[(x-1)*3+2] - pixel[x*3+2];
		}
	}

	if(h > 1) {
		for(y = 1; y < h; y++) {
			pixel[(y*w)*3  ] = pixel[((y-1)*w)*3  ] - pixel[(y*w)*3  ];
			pixel[(y*w)*3+1] = pixel[((y-1)*w)*3+1] - pixel[(y*w)*3+1];
			pixel[(y*w)*3+2] = pixel[((y-1)*w)*3+2] - pixel[(y*w)*3+2];
			
			for(x = 1; x < w; x++) {
				int px, py;
				py = pixel[((y-1)*w+x  )*3];
				px = pixel[( y   *w+x-1)*3];
				pixel[(y*w+x)*3  ] = ((py+px)>>1) - pixel[(y*w+x)*3  ];
				py = pixel[((y-1)*w+x  )*3+1];
				px = pixel[( y   *w+x-1)*3+1];
				pixel[(y*w+x)*3+1] = ((py+px)>>1) - pixel[(y*w+x)*3+1];
				py = pixel[((y-1)*w+x  )*3+2];
				px = pixel[( y   *w+x-1)*3+2];
				pixel[(y*w+x)*3+2] = ((py+px)>>1) - pixel[(y*w+x)*3+2];
			}
		}
	}

	free(raw);

	return 0;
}

/****************************************************************************/

/* At@`͂܂܂藝łĂ܂Bqnt.c̃\[Xقڂ̂܂܎g킹Ē܂B */
int
extract_alpha(QNTHDR* qnt, unsigned char* alpha, unsigned char* data)
{
	int i, x, y, w, h, ucbuf;
	unsigned char* raw;
	
	w = qnt->width;
	h = qnt->height;
	ucbuf = w * h + ZLIBBUF_MARGIN;
	raw = (unsigned char*)malloc(ucbuf);
	if(uncompress(raw, &ucbuf, data, qnt->alpha_size) != Z_OK) err("At@WJsB");

	i = 1;
	if(w > 1) {
		alpha[0] = raw[0];
		for(x = 1; x < w; x++) {
			alpha[x] = alpha[x-1] - raw[i];
			i++;
		}
	}

	if(h > 1) {
		for(y = 1; y < h; y++) {
			alpha[y*w] = alpha[(y-1) *w] - raw[i]; i++;
			for(x = 1; x < w; x++) {
				int pax, pay;
				pax = alpha[ y   * w + x -1];
				pay = alpha[(y-1)* w + x   ];
				alpha[y*w+x] = ((pax+pay) >> 1) - raw[i];
				i++;
			}
		}
	}

	free(raw);

	return 0;
}

/****************************************************************************/


CG*
qnt_extract(unsigned char* data)
{
	QNTHDR* qnt = (QNTHDR*)data;
	CG* cg;

	/* CG\̂mۂ܂B */
	cg = (CG*)calloc(1, sizeof(CG));
	if(cg == NULL) err("słB");

	/* VOl`ETCYErbg[xB */
	if(memcmp(qnt->sig, QNTHDR_SIG, 4) != 0) err("VOl`słB");
	cg->w = qnt->width;
	cg->h = qnt->height;
	if(qnt->bpp != 24) err("rbg[xsłB");

	/* sNZEAt@B */
	data += qnt->header_size;
	if(qnt->pixel_size != 0) {
		cg->pixel = (unsigned char*)malloc((cg->w+10) * (cg->h+10) * 3); /* +10͕KvȂ̂ȁHKvB+10ȂƂȂGPFŗ邱Ƃ܂ */
		if(cg->pixel == NULL) err("słB");
		if(extract_pixel(qnt, cg->pixel, data) != 0) err("sNZf[^̓WJɎs܂B");
		data += qnt->pixel_size;
	}
	if(qnt->alpha_size != 0) {
		cg->alpha = (unsigned char*)malloc(cg->w * cg->h * 1);
		if(cg->alpha == NULL) err("słB");
		if(extract_alpha(qnt, cg->alpha, data) != 0) err("At@f[^̓WJɎs܂B");
		data += qnt->alpha_size;
	}

	return cg;
}

/****************************************************************************/

int
reduce(CG* cg, int s)
{
	int dx, dy, sx, sy, dw, dh, sw, sh, r, g, b, a, n;
	unsigned char *pixel, *alpha;

	/* kOEk̃TCY߂܂B */
	sw = cg->w;
	sh = cg->h;
	dw = (sw + (s - 1)) / s;
	dh = (sh + (s - 1)) / s;

	/* k̃obt@mۂ܂B */
	if(cg->pixel != NULL) {
		pixel = (unsigned char*)malloc(dw * dh * 3);
		if(pixel == NULL) err("słB");
	} else {
		pixel = NULL;
	}
	if(cg->alpha != NULL) {
		alpha = (unsigned char*)malloc(dw * dh * 1);
		if(alpha == NULL) err("słB");
	} else {
		alpha = NULL;
	}

	/* kB */
	for(dy = 0; dy < dh; dy++) {
		for(dx = 0; dx < dw; dx++) {
			/* k̃sNZZB */
			r = 0;
			g = 0;
			b = 0;
			a = 0;
			n = 0;
			for(sy = dy * s; sy < (dy + 1) * s; sy++) {
				if(sy > sh) continue;
				for(sx = dx * s; sx < (dx + 1) * s; sx++) {
					if(sx > sw) continue;
					if(cg->pixel != NULL) {
						r += cg->pixel[(sw * sy + sx) * 3 + 0];
						g += cg->pixel[(sw * sy + sx) * 3 + 1];
						b += cg->pixel[(sw * sy + sx) * 3 + 2];
					}
					if(cg->alpha != NULL) {
						a += cg->alpha[(sw * sy + sx) * 1 + 0];
					}
					n++;
				}
			}
			/* ςďk̃sNZցB */
			r /= n;
			g /= n;
			b /= n;
			a /= n;
			if(pixel != NULL) {
				pixel[(dw * dy + dx) * 3 + 0] = r;
				pixel[(dw * dy + dx) * 3 + 1] = g;
				pixel[(dw * dy + dx) * 3 + 2] = b;
			}
			if(alpha != NULL) {
				alpha[(dw * dy + dx) * 1 + 0] = a;
			}
		}
	}

	/* CGk̃f[^ɒu܂B */
	cg->w = dw;
	cg->h = dh;
	free(cg->pixel); /* free(NULL)͈S */
	cg->pixel = pixel;
	free(cg->alpha); /* free(NULL)͈S */
	cg->alpha = alpha;

	return 0;
}

/****************************************************************************/

int
export_bmp24(FILE* fp, CG* cg)
{
//#define ALPHA /* `ƃsNZ̑ɃAt@o͂܂ */

	int x, y, w, h, line_bytes;
	unsigned char *line_buffer, *src, *dst;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;

	w = cg->w;
	h = cg->h;

	/* 4oCgAĈ߂̃Cobt@mۂ܂B */
	line_bytes = w * 3 + 3 & ~3;
	line_buffer = (unsigned char*)malloc(line_bytes);
	if(line_buffer == NULL) err("słB");
	memset(line_buffer, 0, line_bytes); /* pfBOmɃNA */

	/* t@Cwb_óB */
	memset(&bf, 0, sizeof bf);
	bf.bfType = 'MB';
	bf.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + line_bytes * h;
	bf.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	if(fwrite(&bf, 1, sizeof bf, fp) != sizeof bf) err("t@Cwb_o͎sB");

	/* rbg}bvwb_óB */
	memset(&bi, 0, sizeof bi);
	bi.biSize = sizeof bi;
	bi.biWidth = w;
	bi.biHeight = h;
	bi.biPlanes = 1;
	bi.biBitCount = 24;
	if(fwrite(&bi, 1, sizeof bi, fp) != sizeof bi) err("rbg}bvwb_o͎sB");

	/* f[^óB */
	for(y = h - 1; y >= 0; y--) {
#ifdef ALPHA
		dst = line_buffer;
		src = cg->alpha + w * 1 * y;
		for(x = 0; x < w; x++) {
			dst[0] = src[0];
			dst[1] = src[0];
			dst[2] = src[0];
			dst += 3;
			src += 1;
		}
#else /*ALPHA*/
		dst = line_buffer;
		src = cg->pixel + w * 3 * y;
		for(x = 0; x < w; x++) {
			dst[0] = src[2];
			dst[1] = src[1];
			dst[2] = src[0];
			dst += 3;
			src += 3;
		}
#endif /*ALPHA*/
		if(fwrite(line_buffer, 1, line_bytes, fp) != (unsigned)line_bytes) err("f[^o͎sB");
	}

	/* Cobt@J܂B */
	free(line_buffer);

	return 0;

#undef ALPHA
}

/****************************************************************************/

int
export_bmp8(FILE* fp, CG* cg)
{
	int x, y, w, h, line_bytes;
	int c, r, g, b, a;
	unsigned char *line_buffer, *src, *dst, *alp;
	BITMAPFILEHEADER bf;
	BITMAPINFOHEADER bi;
	RGBQUAD rgb[256];

	w = cg->w;
	h = cg->h;

	/* 4oCgAĈ߂̃Cobt@mۂ܂B */
	line_bytes = w + 3 & ~3;
	line_buffer = (unsigned char*)malloc(line_bytes);
	if(line_buffer == NULL) err("słB");
	memset(line_buffer, 0, line_bytes); /* pfBOmɃNA */

	/* t@Cwb_óB */
	memset(&bf, 0, sizeof bf);
	bf.bfType = 'MB';
	bf.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 + line_bytes * h;
	bf.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;
	if(fwrite(&bf, 1, sizeof bf, fp) != sizeof bf) err("t@Cwb_o͎sB");

	/* rbg}bvwb_óB */
	memset(&bi, 0, sizeof bi);
	bi.biSize = sizeof bi;
	bi.biWidth = w;
	bi.biHeight = h;
	bi.biPlanes = 1;
	bi.biBitCount = 8;
	if(fwrite(&bi, 1, sizeof bi, fp) != sizeof bi) err("rbg}bvwb_o͎sB");

	/* pbgóB */
	for(c = 0; c < 4; c++) {
		rgb[c].rgbRed       = 85 * (3 - c);
		rgb[c].rgbGreen     = 85 * (3 - c);
		rgb[c].rgbBlue      = 85 * (3 - c);
		rgb[c].rgbReserved  = 0;
	}
	for(c = 4; c < 256; c++) {
		rgb[c].rgbRed       = 0;
		rgb[c].rgbGreen     = 255;
		rgb[c].rgbBlue      = 0;
		rgb[c].rgbReserved  = 0;
	}
	if(fwrite(rgb, 1, sizeof rgb, fp) != sizeof rgb) err("pbgo͎sB");

	/* f[^óB */
	for(y = h - 1; y >= 0; y--) {
		dst = line_buffer;
		src = cg->pixel + w * 3 * y;
		alp = cg->alpha != NULL ? cg->alpha + w * 1 * y : NULL;
		for(x = 0; x < w; x++) {
			r = src[0];
			g = src[1];
			b = src[2];
			a = alp != NULL ? alp[0] : 0xff;
			if(a >= ALPHA_CUTOFF) {
				c = (r * 3 + g * 5 + b * 2) / 10;
				c = (c + DITHER[y & 7][x & 7] + (85 - 63) / 2) / 85;
				if(c > 3) c = 3;
				c = 3 - c;
			} else {
				c = 4;
			}
			dst[0] = c;
			dst += 1;
			src += 3;
			if(alp != NULL) alp += 1;
		}
		if(fwrite(line_buffer, 1, line_bytes, fp) != (unsigned)line_bytes) err("f[^o͎sB");
	}

	/* Cobt@J܂B */
	free(line_buffer);

	return 0;
}

/****************************************************************************/

void
usage()
{
	fprintf(stderr, "gF\n");
	fprintf(stderr, "  beatangl [options] <qnt-entry-name[.qnt]>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "IvVF\n");
	fprintf(stderr, "  -b        24rbgBMPt@Co  ilPGDt@Co j\n");
	fprintf(stderr, "  -d<path>  GXJC[tH_w ilWXg擾j\n");
	exit(1);
}

/****************************************************************************/

char esc_path[_MAX_PATH];	/* GXJC[̃tH_ */
char ald_path[_MAX_PATH];	/* ALDt@C̃tpX */
char qnt_path[_MAX_PATH];	/* oQNT̃Gg(CG0002.QNTȂ) */
char qnt_fname[_MAX_FNAME];	/* QNT̃t@C(CG0002Ȃ) */
char qnt_ext[_MAX_EXT];		/* QNT̊gq(.QNTȂ) */
char bmp_path[_MAX_PATH];	/* BMPo̓t@C */

int opt_bmp24;			/* 24rbgBMPo(eXgp) */

int
main(int argc, char* argv[])
{
	int retval, i, size;
	char *p, cmd[256];
	unsigned char* data;
	FILE* fp;
	CG* cg;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		p = argv[i];
		if(p[0] == '-') { /* IvV */
			switch(p[1]) {
			case 'b': /* 24rbgBMPo */
				if(opt_bmp24) usage(); /* dw */
				opt_bmp24 = 1;
				break;
			case 'd': /* uGXJC[vtH_w */
				if(strlen(esc_path) != 0) usage(); /* dw */
				strncpy(esc_path, &p[2], sizeof esc_path);
				break;
			default:
				usage();
			}
		} else {
			/* oQNTGg */
			if(strlen(qnt_path) != 0) usage(); /* dw */
			strncpy(qnt_path, p, sizeof qnt_path);
		}
	}

	/* QNTGg擾܂B */
	if(strlen(qnt_path) == 0) usage(); /* oGgw */
	_splitpath(qnt_path, NULL, NULL, qnt_fname, qnt_ext);
	if(strlen(qnt_ext) == 0) strcpy(qnt_ext, ".qnt");
	_makepath(qnt_path, NULL, NULL, qnt_fname, qnt_ext);

	/* ALDt@C擾܂B */
	if(strlen(esc_path) == 0) { /* tH_ĂȂ΃WXg擾 */
		retval = get_esc_path(esc_path);
		if(retval != 0) err("uVVgGXJC[vCXg[ĂȂ悤łB");
	}
	_makepath(ald_path, NULL, esc_path, ALD_QNT, NULL);

	/* ALDt@CJ܂B */
	fp = fopen(ald_path, "rb");
	if(fp == NULL) err("%sJ܂B", ald_path);

	/* ړIQNTGgT܂B */
	size = find_entry(fp, qnt_path);
	if(size == 0) err("%s܂B", qnt_path);

	/* QNTf[^ǂݍ݂܂B */
	data = (unsigned char*)malloc(size);
	if(data == NULL) err("%sǂݍނ߂̃܂B", qnt_path);
	if(fread(data, 1, size, fp) != (unsigned)size) err("%sǂݍ߂܂B", qnt_path);

	/* QNTf[^WJ܂B */
	fprintf(stderr, "%sWJ...", qnt_path);
	cg = qnt_extract(data);
	if(cg == NULL) err("ERR");
	fprintf(stderr, "OK\n");

	/* QNTf[^J܂B */
	free(data);

	/* ALDt@C܂B */
	fclose(fp);

	/* kB */
	if(reduce(cg, REDUCE_LEVEL) != 0) err("%s̏kɎs܂B", qnt_path);
	if(cg->h > HEIGHT_LIMIT) cg->h = HEIGHT_LIMIT; /* P/VNS͉Bオ؂艺؂B */

	if(opt_bmp24) {
		/* 24rbgBMPóB */
		_makepath(bmp_path, NULL, NULL, qnt_fname, ".bmp");
		fp = fopen(bmp_path, "wb");
		if(fp == NULL) err("%s쐬ł܂B");
		fprintf(stderr, "%so͒...", bmp_path);
		if(export_bmp24(fp, cg) != 0) err("ERR");
		fprintf(stderr, "OK\n");
		fclose(fp);
	} else {
		/* 8rbgBMPóB */
		_makepath(bmp_path, NULL, NULL, qnt_fname, ".bmp");
		fp = fopen(bmp_path, "wb");
		if(fp == NULL) err("%s쐬ł܂B");
		fprintf(stderr, "%so͒...", bmp_path);
		if(export_bmp8(fp, cg) != 0) err("ERR");
		fprintf(stderr, "OK\n");
		fclose(fp);
		/* PGDɕϊB */
		if(cg->alpha != NULL) { /* 2bit}XNt */
			sprintf(cmd, "dpbmpcnv -q -b -f2m \"%s\"", bmp_path); /* -qKv! */
		} else { /* 2bit}XNȂ */
			sprintf(cmd, "dpbmpcnv -q -b -f2  \"%s\"", bmp_path); /* -qKv! */
		}
		if(system(cmd) != 0) err("PGDϊɎs܂B");
		remove(bmp_path); /* BMP͂Ȃ̂ō폜 */
	}

	return 0;
}
