/*
 *	XmpPifCnv - as-XMP-1 PatternInformationFile CoNVerter
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Mon Sep 14 00:28:41 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 */
#define VERSION "20150914"	//o[W`
//==============================================================================
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
//Win32
#define STRICT
#include <windows.h>
//GC
//#include "gc.h"
#include "leak_detector.h"
#pragma comment(lib,"gc.lib")
#ifdef  _DEBUG
#pragma comment(linker,"/NODEFAULTLIB:LIBC")
#endif//_DEBUG
#include "Xmp1.h"
//==============================================================================
__declspec(noreturn) void die(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
#ifdef  _DEBUG
	__asm int 3; //ޯނՂ悤ɤޯގޯނŎ~߂
#endif/*_DEBUG*/
	exit(EXIT_FAILURE);
}
#define DIE() die("%s(%d)",__FILE__,__LINE__)
#define ARRAY_SIZE(a) ((int)(sizeof(a)/sizeof((a)[0])))
//==============================================================================
int       n_line;		//s(s͔΂)
int*      n_unit/*[n_line]*/;	//esƯĐ
char*** TBL_unit/*[n_line]*/;	//esƯĔz
//==============================================================================
//ݐ̧قǂݍݤeseƯĂɕ
//s͔΂
//==============================================================================
void load_lines() {
	char** TBL_line = NULL;	//ԂŤsðقɂĂ̌㤐reallocĊg
	char* p;
	int i;
	//1sǂݍނ̂ɏ\Ȼނޯ̧mۂ
	//ݐ̧قͤe݂1sɏo͂̂Ť傫݂݂ꍇ1sɒ[ɒȂꍇ
	//ɤحт݂̽ײނsƤ傫݂\
	//Ƃ͂16Ҷ޲ĂΏ\ł낤
	p = malloc(1<<24);	//2^24=16Ҷ
	if(!p) { die("load_lines:malloc()s"); }
	//esǂݍ݁c
	while(gets(p)) {
		//s͔΂
		if(!strlen(p)) { continue; }
		//sðقg
		TBL_line = realloc(TBL_line, sizeof(char*) * (n_line + 1));
		if(!TBL_line) { die("load_lines:realloc()s"); }
		//s߰Ċi[
		TBL_line[n_line] = strdup(p);
		if(!TBL_line[n_line]) { die("load_lines:strdup()s"); }
		//s𑝂₷
		n_line++;
	}
	//ƯĐðقmۂƯĐðقƂͤesƯĐi[zł
	n_unit = calloc(n_line, sizeof(int));
	if(!n_unit) { die("load_lines:calloc()s"); }
	//ƯðقmۂƯðقƂͤesƯĔzi[zł
	TBL_unit = calloc(n_line, sizeof(char**));
	if(!TBL_unit) { die("load_lines:calloc()s"); }
	//esɂāc
	for(i = 0; i < n_line; i++) {
		//ŏƯĂ擾顗\ߋs΂Ă̂ŤɤŏƯĂ݂͂ł
		if(!(p = strtok(TBL_line[i], ","))) { die("load_lines:ŏƯĂołȂ"); }
		do {
			//ݐ̧ق̏łͤƯĂ݂͑Ȃ͂ł顖ꤑ݂ƂĂstrtok()͋ƯĂoȂ
			if(!strlen(p)) { die("load_lines:ƯĂ݂"); }
			//ƯĔzg
			TBL_unit[i] = realloc(TBL_unit[i], sizeof(char*) * (n_unit[i] + 1));
			if(!TBL_unit[i]) { die("load_lines:realloc()s"); }
			//ƯĂi[
			TBL_unit[i][n_unit[i]] = strdup(p);
			if(!TBL_unit[i][n_unit[i]]) { die("load_lines:strdup()s"); }
			//ƯĐ𑝂₷
			n_unit[i]++;
		} while((p = strtok(NULL, ",")) != NULL);	//İ݂擾
	}
}
//==============================================================================
//ST_TRK.stat
#define TRK_STAT_STOP		0			//~
#define TRK_STAT_PLAY_M		1			//Đ()
#define TRK_STAT_PLAY_L		2			//Đ(ڵ)
#define TRK_STAT_PLAY_R		3			//Đ(ڵE)
//ׯ
typedef struct _ST_TRK {
	int			trig;			//statύXض		//ڰт{Đ˒~ˍĐ}ƑJڂꍇ̌ô߂ɕKvɂȂ
	int			stat;			//TRK_STAT_*
	int			pn;			//0-8191=ڰޔԍ
	int			p0;			//0-255=E
	int			v2;			//0-255=2ح
	int			loop;			//0-255=ٰ߉	0=1,1=2,...,254=255,255=
} ST_TRK;
//ݏ
typedef struct _ST_PTN {
	int			no;			//ݔԍ
	char*			name;			//ݖ
	int			time;			//ݎ
	unsigned char		reg[0x6FF+1];		//ڼ޽ݒl		//0x6FF=IC{ݸxڼ޽}͈̔͡ݸ0-6xeݸڼ޽00-FF
	ST_TRK			trk_now[127+1];		//݂ׯ
	ST_TRK			trk_old[127+1];		//Oׯ
	unsigned		wait;			//ۗĂ҂	//ݐ̧قɳĐ䂪ĂकϊɖʂȐ͔΂Ĥ̳Ăɂ܂Ƃ߂顂̂߂ɤω炷ɳĺނo͂̂łȂۗĂ鳪ĂLԂŕʂ̐o͂钼Oɤۂɳĺނo͂悤ɂ
	unsigned char		use_trk[(127+1)/8];	//݂gpׯޯϽ
	//
	char			buf[(1<<24)];		//1݂o͂̂ɏ\Ȼނ̕ޯ̧ނ͒
	int			len;			//buf[]ɏo͂
} ST_PTN;
ST_PTN stPtn;	//ݕϊݏ
//==============================================================================
//1݂o͂ޯ̧ݸނ
//ͯނɎgpׯo͂邽߂ɤްo͂łȂ
//==============================================================================
void addbuf(const char* fmt, ...) {
	int len;
	va_list ap;
	va_start(ap, fmt);
	if(stPtn.len >= sizeof stPtn.buf) { DIE(); }
	len = vsprintf(&stPtn.buf[stPtn.len], fmt, ap);
	if(len < 0) { DIE(); }
	stPtn.len += len;
	if(stPtn.len >= sizeof stPtn.buf) { DIE(); }
}
//==============================================================================
//ۗĂ鳪ĂLΤĺނo͂
//ۗĂ鳪Ăر
//==============================================================================
void make_wait() {
	//ۗĂ鳪ĂΤȂ
	if(!stPtn.wait) { return; }
	//Ăo͂
	addbuf("	wait	%u\n",
		stPtn.wait);
	//Ăo͂̂ŤۗĎԂر
	stPtn.wait = 0;
}
//==============================================================================
//ׯނ쐬
//==============================================================================
void make_trk() {
	ST_TRK *pTrkNow, *pTrkOld;
	int iTrk;
	//eׯɂāc
	for(iTrk = 0; iTrk <= 127; iTrk++) {
		//݂ׯƤOׯւ߲擾
		pTrkNow = &stPtn.trk_now[iTrk];
		pTrkOld = &stPtn.trk_old[iTrk];
		//statωضނL΁c
		if(pTrkNow->trig) {
			switch(pTrkOld->stat) {
			default:DIE();//޸
			case TRK_STAT_STOP:
				switch(pTrkNow->stat) {
				default:DIE();//޸
				//~˒~
				case TRK_STAT_STOP:
					die("make_trk:ڰт (Đ)[c]˒~ Ƃް͐Ȃ͂");
				//~ˍĐ()
				case TRK_STAT_PLAY_M:
					make_wait();	//ۗĂΏo
					addbuf("	play	%d,%d,%d,%d,%d\n",
						iTrk,
						pTrkNow->pn,
						(pTrkNow->loop+1)&255,	//(0=1,1=2,...,254=255,255=)(1=1,2=2,...,255=255,0=)
						128-pTrkNow->v2,	//(=0~128)(=128~0)
						pTrkNow->p0-64);	//(0~128)(-64~64)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[iTrk/8] |= (1<<(iTrk&7));//
					break;
				//~ˍĐ(ڵ)
				case TRK_STAT_PLAY_L:
					make_wait();	//ۗĂΏo
					addbuf("	play	%d,%d,%d,%d\n",
						iTrk,
						pTrkNow->pn,
						(pTrkNow->loop+1)&255,	//(0=1,1=2,...,254=255,255=)(1=1,2=2,...,255=255,0=)
						128-pTrkNow->v2);	//(=0~128)(=128~0)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[(iTrk+0)/8] |= (1<<((iTrk+0)&7));//ڵ()
					stPtn.use_trk[(iTrk+1)/8] |= (1<<((iTrk+1)&7));//ڵ(E)
					break;
				//~ˍĐ(ڵE)
				case TRK_STAT_PLAY_R:
					/** no job **/	//s۸тɂĤڵقɘAĐ䂷
					break;
				}
				break;
			case TRK_STAT_PLAY_M:
				switch(pTrkNow->stat) {
				default:DIE();//޸
				//Đ()˒~
				case TRK_STAT_STOP:
					make_wait();	//ۗĂΏo
					addbuf("	stop	%d\n",
						iTrk);
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[iTrk/8] |= (1<<(iTrk&7));//
					break;
				//Đ()ˍĐ()
				case TRK_STAT_PLAY_M:
					make_wait();	//ۗĂΏo
					addbuf("	play	%d,%d,%d,%d,%d\n",
						iTrk,
						pTrkNow->pn,
						(pTrkNow->loop+1)&255,	//(0=1,1=2,...,254=255,255=)(1=1,2=2,...,255=255,0=)
						128-pTrkNow->v2,	//(=0~128)(=128~0)
						pTrkNow->p0-64);	//(0~128)(-64~64)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[iTrk/8] |= (1<<(iTrk&7));//
					break;
				//Đ()ˍĐ(ڵ)
				case TRK_STAT_PLAY_L:
					die("make_trk:Đ()ˍĐ(ڵ) projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
				//Đ()ˍĐ(ڵE)
				case TRK_STAT_PLAY_R:
					die("make_trk:Đ()ˍĐ(ڵE) projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
				}
				break;
			case TRK_STAT_PLAY_L:
				switch(pTrkNow->stat) {
				default:DIE();//޸
				//Đ(ڵ)˒~
				case TRK_STAT_STOP:
					make_wait();	//ۗĂΏo
					addbuf("	stop	%d\n",
						iTrk);
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[(iTrk+0)/8] |= (1<<((iTrk+0)&7));//ڵ()
					stPtn.use_trk[(iTrk+1)/8] |= (1<<((iTrk+1)&7));//ڵ(E)
					break;
				//Đ(ڵ)ˍĐ()
				case TRK_STAT_PLAY_M:
					die("make_trk:Đ(ڵ)ˍĐ() projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
				//Đ(ڵ)ˍĐ(ڵ)
				case TRK_STAT_PLAY_L:
					make_wait();	//ۗĂΏo
					addbuf("	play	%d,%d,%d,%d\n",
						iTrk,
						pTrkNow->pn,
						(pTrkNow->loop+1)&255,	//(0=1,1=2,...,254=255,255=)(1=1,2=2,...,255=255,0=)
						128-pTrkNow->v2);	//(=0~128)(=128~0)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[(iTrk+0)/8] |= (1<<((iTrk+0)&7));//ڵ()
					stPtn.use_trk[(iTrk+1)/8] |= (1<<((iTrk+1)&7));//ڵ(E)
					break;
				//Đ(ڵ)ˍĐ(ڵE)
				case TRK_STAT_PLAY_R:
					die("make_trk:Đ(ڵ)ˍĐ(ڵE) projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
				}
				break;
			case TRK_STAT_PLAY_R:
				switch(pTrkNow->stat) {
				default:DIE();//޸
				//Đ(ڵE)˒~
				case TRK_STAT_STOP:
					/** no job **/	//s۸тɂĤڵقɘAĐ䂷
					break;
				//Đ(ڵE)ˍĐ()
				case TRK_STAT_PLAY_M:
					die("make_trk:Đ(ڵE)ˍĐ() projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
				//Đ(ڵE)ˍĐ(ڵ)
				case TRK_STAT_PLAY_L:
					die("make_trk:Đ(ڵE)ˍĐ(ڵ) projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
				//Đ(ڵE)ˍĐ(ڵE)
				case TRK_STAT_PLAY_R:
					/** no job **/	//s۸тɂĤڵقɘAĐ䂷
					break;
				}
				break;
			}
		//statωضނ΁c
		} else {
			//ωضނ̂ɏԂωĂ邱Ƃ͖͂Ȃ礕ωضނĂ̂YĂ޸ނł낤
			if(pTrkNow->stat != pTrkOld->stat) { DIE(); }	//޸
			switch(pTrkNow->stat) {
			default:DIE();//޸
			//~˒~
			case TRK_STAT_STOP:
				/** no job **/
				break;
			//Đ()ˍĐ()
			case TRK_STAT_PLAY_M:
				//حт݂ωc
				if((pTrkNow->v2 != pTrkOld->v2) &&
				   (pTrkNow->p0 != pTrkOld->p0)) {
					make_wait();	//ۗĂΏo
					addbuf("	ctrl	%d,%d,%d\n",
						iTrk,
						128-pTrkNow->v2,	//(=0~128)(=128~0)
						pTrkNow->p0-64);	//(0~128)(-64~64)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[iTrk/8] |= (1<<(iTrk&7));//
				//حтωc
				} else if(pTrkNow->v2 != pTrkOld->v2) {
					make_wait();	//ۗĂΏo
					addbuf("	ctrl	%d,%d\n",
						iTrk,
						128-pTrkNow->v2);	//(=0~128)(=128~0)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[iTrk/8] |= (1<<(iTrk&7));//
				//݂ωc
				} else if(pTrkNow->p0 != pTrkOld->p0) {
					make_wait();	//ۗĂΏo
					addbuf("	ctrl	%d,,%d\n",
						iTrk,
						pTrkNow->p0-64);	//(0~128)(-64~64)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[iTrk/8] |= (1<<(iTrk&7));//
				}
				break;
			//Đ(ڵ)ˍĐ(ڵ)
			case TRK_STAT_PLAY_L:
				if(pTrkNow->p0 != pTrkOld->p0) { die("make_trk:ڵق̍E݂͐Ȃ͂"); }
				//حтωc
				if(pTrkNow->v2 != pTrkOld->v2) {
					make_wait();	//ۗĂΏo
					addbuf("	ctrl	%d,%d\n",
						iTrk,
						128-pTrkNow->v2);	//(=0~128)(=128~0)
					//݂gpׯޯϽɒǉ
					stPtn.use_trk[(iTrk+0)/8] |= (1<<((iTrk+0)&7));//ڵ()
					stPtn.use_trk[(iTrk+1)/8] |= (1<<((iTrk+1)&7));//ڵ(E)
				}
				break;
			//Đ(ڵE)ˍĐ(ڵE)
			case TRK_STAT_PLAY_R:
				/** no job **/	//s۸тɂĤڵقɘAĐ䂷
				break;
			}
		}
		//ڰт̂߂ɤstatωضނرĂ
		pTrkNow->trig = 0;
		//݂ׯOׯƂĺ߰
		//pTrkOld->trig͎gpȂ̂Ťstatωضނرź߰č\Ȃ(ǂłǂ)
		memcpy(pTrkOld, pTrkNow, sizeof(ST_TRK));
	}
}
//==============================================================================
//ڼ޽ׯԂɔf
//==============================================================================
void proc_reg(int reg) {
	ST_TRK* pTrkNow;
	//pɂɎglڼ޽ݒl擾Ă
	const int PN_x0_7_0	= (stPtn.reg[XMP1_PN_x0_7_0]					>>0)	&((1<<8)-1);	//PN
	const int PN_x0_12_8	= (stPtn.reg[XMP1_PL_x0_2_0_PN_x0_12_8]				>>0)	&((1<<5)-1);	//PN
	const int PTRK_6_0	= (stPtn.reg[XMP1_PVUP_x_PTRK_6_0]				>>0)	&((1<<7)-1);	//PTRK
	const int PVUP_x	= (stPtn.reg[XMP1_PVUP_x_PTRK_6_0]				>>7)	&((1<<1)-1);	//PVUP
	const int PPLAY_x_1_0	= (stPtn.reg[XMP1_PPLAY_x_1_0_PPLAY_PRI_PNRCL_PNUM_x_2_0]	>>6)	&((1<<2)-1);	//PPLAY
	const int PNRCL		= (stPtn.reg[XMP1_PPLAY_x_1_0_PPLAY_PRI_PNRCL_PNUM_x_2_0]	>>3)	&((1<<1)-1);	//PNRCL
	//ꂽڼ޽ɂāc
	switch(reg) {
    //	case XMP1_PN_x0_7_0:		/** no job **/	//PN=ĐJnɎQƂ顊i[͉Ȃ
    //	case XMP1_PL_x0_2_0_PN_x0_12_8:	/** no job **/	//PN=ĐJnɎQƂ顊i[͉Ȃ
    //	case XMP1_P0_x_7_0:		/** no job **/	//P0=حѱްĎɎQƂ顊i[͉Ȃ
    //	case XMP1_V2_x_7_0:		/** no job **/	//V2=حѱްĎɎQƂ顊i[͉Ȃ
	case XMP1_PVUP_x_PTRK_6_0:
		//ׯ(ݒl)ւ߲擾
		if(PTRK_6_0 > 127) { die("proc_reg:PTRK_6_0͈͊O127߂̒lo͂ĂYAMAHA°قݴިċ@\ɂĂͤۂɂ105ȉ̒lo͂Ȃ͂"); }
		pTrkNow = &stPtn.trk_now[PTRK_6_0];
		//ްĂȂ΁c
		if(PVUP_x) {
		//sv	pTrkNow->pn	= (stPtn.reg[XMP1_PL_x0_2_0_PN_x0_12_8] << 8) | stPtn.reg[XMP1_PN_x0_7_0];	PṈްĂ͍ĐJn݂̂ł(IC̎dl)
			pTrkNow->p0	= stPtn.reg[XMP1_P0_x_7_0];
			pTrkNow->v2	= stPtn.reg[XMP1_V2_x_7_0];
			pTrkNow->loop	= stPtn.reg[XMP1_LOOP_x_7_0];
		}
		return;	//܂
	case XMP1_PPLAY_x_1_0_PPLAY_PRI_PNRCL_PNUM_x_2_0:
		//ׯ(ݒl)ւ߲擾
		if(PTRK_6_0 > 127) { die("proc_reg:PTRK_6_0͈͊O127߂̒lo͂ĂYAMAHA°قݴިċ@\ɂĂͤۂɂ105ȉ̒lo͂Ȃ͂"); }
		pTrkNow = &stPtn.trk_now[PTRK_6_0];
		//غقȂ΁c
		if(PNRCL) {
			stPtn.reg[XMP1_PN_x0_7_0]		= pTrkNow->pn;		//°قɂĂ͕svIC̋ɍ킹ĈꉞغّΏۂƂ題_ł͖ʏł
			stPtn.reg[XMP1_PL_x0_2_0_PN_x0_12_8]	= pTrkNow->pn >> 8;	//°قɂĂ͕svIC̋ɍ킹ĈꉞغّΏۂƂ題_ł͖ʏł
			stPtn.reg[XMP1_P0_x_7_0]		= pTrkNow->p0;
			stPtn.reg[XMP1_V2_x_7_0]		= pTrkNow->v2;
			stPtn.reg[XMP1_LOOP_x_7_0]		= pTrkNow->loop;	//°قɂĂ͕svIC̋ɍ킹ĈꉞغّΏۂƂ題_ł͖ʏł
		//غقłȂ΁c
		} else {
			switch(PPLAY_x_1_0) {
			default:DIE();//޸
			case 0:	//ڰޒ~
				switch(pTrkNow->stat) {
				default:DIE();//޸
				case TRK_STAT_STOP:	//~
					die("proc_reg:YAMAHA°قݴިċ@\ɂĤ~ׯɑ΂Ĥ~邱Ƃ͖͂");
				case TRK_STAT_PLAY_M:	//Đ()
					pTrkNow->trig = 1;
					pTrkNow->stat = TRK_STAT_STOP;		//ׯ~
					break;
				case TRK_STAT_PLAY_L:	//Đ(ڵ)
					//if((PTRK_6_0 == 15) || (PTRK_6_0 == 31)) { die("proc_reg:IC̎dlɂׯ15-16,,31-0ŽڵĐ邱Ƃ͂łȂYAMAHA°قݴިċ@\ɂĤ̂悤ް͐Ȃ͂"); }		TAPӰނł͎sɔf̂°ُł͖͂̐
					if((pTrkNow + 1)->stat != TRK_STAT_PLAY_R) { die("proc_reg:+1ׯͤĐ(ڵE)ł͂"); }
					(pTrkNow + 0)->trig = 1;
					(pTrkNow + 0)->stat = TRK_STAT_STOP;	//ڵׯ~
					(pTrkNow + 1)->trig = 1;
					(pTrkNow + 1)->stat = TRK_STAT_STOP;	//ڵEׯ~
					break;
				case TRK_STAT_PLAY_R:	//Đ(ڵE)
					die("proc_reg:YAMAHA°قݴިċ@\ɂĤĐ(ڵE)ׯɑ΂Ĥ~邱Ƃ͖͂");
				}
				return;	//܂
			case 1:	//ڰލĐJn
				switch(pTrkNow->stat) {
				default:DIE();//޸
				case TRK_STAT_STOP:	//~
					//E݂QƂĤĐނ𔻒f邱Ƃɂ
					       if(pTrkNow->p0 <= 0x80) {
						pTrkNow->trig = 1;
						pTrkNow->stat = TRK_STAT_PLAY_M;	//Đ()
					} else if(pTrkNow->p0 == 0x81) {
						//if((PTRK_6_0 == 15) || (PTRK_6_0 == 31)) { die("proc_reg:IC̎dlɂׯ15-16,,31-0ŽڵĐ邱Ƃ͂łȂYAMAHA°قݴިċ@\ɂĤ̂悤ް͐Ȃ͂"); }		TAPӰނł͎sɔf̂°ُł͖͂̐
						if((pTrkNow + 1)->stat != TRK_STAT_STOP) { die("proc_reg:1ׯͤ~ł͂"); }
						(pTrkNow + 0)->trig = 1;
						(pTrkNow + 0)->stat = TRK_STAT_PLAY_L;	//Đ(ڵ)
						(pTrkNow + 1)->trig = 1;
						(pTrkNow + 1)->stat = TRK_STAT_PLAY_R;	//Đ(ڵE)
					} else if(pTrkNow->p0 == 0x82) {
						die("proc_reg:YAMAHA°قݴިċ@\ɂĤڵEׯ(E=0x82)ɑ΂ĖIڰލĐJn邱Ƃ͖͂");
					} else {
						die("proc_reg:YAMAHA°قݴިċ@\ɂĤ0x83ȏ̍E݂邱Ƃ͖͂");
					}
					//PṈްĂ͍ĐJn݂̂ł(IC̎dl)
					pTrkNow->pn = (PN_x0_12_8 << 8) | PN_x0_7_0;
					if(pTrkNow->pn >= 8192) { die("proc_reg:YAMAHA°قݴިċ@\ɂĤPN8192ōĐJn邱Ƃ͖͂"); }
					break;
				case TRK_STAT_PLAY_M:	//Đ()
					die("proc_reg:YAMAHA°قݴިċ@\ɂĤĐ()ׯɑ΂ĤĐ邱Ƃ͖͂");
				case TRK_STAT_PLAY_L:	//Đ(ڵ)
					die("proc_reg:YAMAHA°قݴިċ@\ɂĤĐ(ڵ)ׯɑ΂ĤĐ邱Ƃ͖͂");
				case TRK_STAT_PLAY_R:	//Đ(ڵE)
					die("proc_reg:YAMAHA°قݴިċ@\ɂĤĐ(ڵE)ׯɑ΂ĤĐ邱Ƃ͖͂");
				}
				return;	//܂
			case 2:	//ڰވꎞ~
				die("proc_reg:ڰވꎞ~ projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
			case 3:	//ڰލĐĊJ
				die("proc_reg:ڰލĐĊJ projł͋֎~ (#%d:%s)", stPtn.no, stPtn.name);
			}
		}
		return;	//܂
	}
}
//==============================================================================
//݂
//==============================================================================
//{{i\
int newMsgLen, oldMsgLen = 0;
//}}i\
void process_pattern(int n_unit, char** TBL_unit/*[n_unit]*/) {
	int event_time;
	int event_type;
	int event_data;
	int i;
	char* p;
	//ݏر
	memset(&stPtn, 0, sizeof stPtn);
	//--- ޯ̧ւ̏o ---
	//ݔԍݖ擾
	if(n_unit < 2) { die("process_pattern:ݔԍݖ擾łȂ"); }
	stPtn.no = strtol(TBL_unit[0], &p, 10);
	if(*p || ((unsigned)stPtn.no > USHRT_MAX)) { die("process_pattern:ݔԍs"); }
	stPtn.name = TBL_unit[1];
	//ݔԍݖ΂
	n_unit   -= 2;
	TBL_unit += 2;
	//݂ȂΤɋA
	if(!n_unit) { return; }
//{{i\
	newMsgLen = fprintf(stderr, "\r%s", stPtn.name);
	if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } oldMsgLen = newMsgLen;
//}}i\
	//݊Jnق쐬
	addbuf("`%05u\n",
		stPtn.no);
	//eďɂāc
	if(n_unit % 3) { DIE(); }
	for(i = 0; i < n_unit; i += 3) {
		event_time = strtol(TBL_unit[i + 0], &p, 10); if(*p || (event_time < stPtn.time)) { die("process_pattern:ԏ񂪏łȂ"); }
		event_type = strtol(TBL_unit[i + 1], &p, 16); if(*p || (event_type >= ARRAY_SIZE(stPtn.reg))) { die("process_pattern:Ďʂڼ޽ԍ͈͓̔(=ݸ0~6)łȂ"); }
		event_data = strtol(TBL_unit[i + 2], &p, 16); if(*p || ((unsigned)event_data > 0xFF)) { die("process_pattern:Ұڼ޽ް(=1޲)ȉłȂ"); }
		//ԏ񂪕ωc
		if(event_time != stPtn.time) {
			//ׯނ쐬
			make_trk();
			//ԑ҂ǉ
			stPtn.wait += (event_time - stPtn.time);
			if(stPtn.wait < 0) { die("process_pattern:ԑ҂ް۰"); }
			//ԏXV
			stPtn.time = event_time;
		}
		//ڼ޽ްi[
		stPtn.reg[event_type] = event_data;
		//ڼ޽ݒ菈s
		proc_reg(event_type);
	}
	//ׯނ쐬
	make_trk();
	//ݏIނ쐬
	make_wait();	//ۗĂΏo
	addbuf("end\n");
	//--- ۂ̏o ---
	//݊JnĂo͂顊O°قɂĂ̍ş͂ͯق޸ðق𐶐邱ƂɂȂ̂Ť͂Ղ悤ɒ
	//#ݔԍ:gpׯ:ݖ
	printf("//%05u:", stPtn.no);
	for(i = 0; i <= 127; i++) { printf("%c", (stPtn.use_trk[i/8]&(1<<(i&7))) ? '*' : '-'); }
	printf(":%s\n%s", stPtn.name, stPtn.buf);
}
//==============================================================================
int main(int argc, char* argv[]) {
	int i;
	//ŌĂяoꂽƂmF顓°قͤW͂͂Wo͂֏o͂顏ɈŋN
	if(argc != 1) {
		fprintf(stderr, "XmpPifCnv - as-XMP-1 PatternInformationFile CoNVerter (%s)\n", VERSION);
		fprintf(stderr, "Copyright (C) 2015 Naoyuki Sawa\n");
		fprintf(stderr, "\n");
		fprintf(stderr, "USAGE:\n");
		fprintf(stderr, "  XmpPifCnv.exe < ݐ̧ٖ.csv > TAPݻ.txt\n");
		fprintf(stderr, "\n");
		fprintf(stderr, "NOTE:\n");
		fprintf(stderr, "  - ݐ̧قͤYAMAHAAS-XMP-1 Version 5.6.0gĤĂ\n");
		fprintf(stderr, "    LȊOްޮ݂°قŐݐ̧قw肷ƤװɂȂ܂\n");
		return EXIT_FAILURE;
	}
	//ݐ̧قǂݍ
	load_lines();
	//ͯޕQƂĤݐ̧قł邱ƂmF
	if(n_line < 3) { die("main:ͯޕQƂĤݐ̧قł邱ƂmFłȂ"); }
	if((n_unit[0] != 1) || strcmp(TBL_unit[0][0], "Pattern Information File AS-XMP-1 Version 5.6.0")) { die("main:ްޮݍss"); }
	if((n_unit[1] != 2) || strcmp(TBL_unit[1][0], "Project File") /*|| strcmp(TBL_unit[1][1], "`.prj")*/) { die("main:ۼުٍ̧ss"); }
	if((n_unit[2] != 3) || strcmp(TBL_unit[2][0], "No.") || strcmp(TBL_unit[2][1], "Name") || strcmp(TBL_unit[2][2], "Event Data...")) { die("main:ͯލss"); }
	//ͯޕ΂
	n_line   -= 3;
	n_unit   += 3;
	TBL_unit += 3;
	//e݂
	for(i = 0; i < n_line; i++) { process_pattern(n_unit[i], TBL_unit[i]); }
//{{i\
	newMsgLen = fprintf(stderr, "\rok");
	if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } putc('\n', stderr); oldMsgLen = 0;
//}}i\
	return EXIT_SUCCESS;
}
