#module CRS

#include "hspmath.as"

/****************************************************************************
 *	O[o֐
 ****************************************************************************/

#defcfunc ferguson_coons_interpolate double p0, double p1, double v0, double v1, double t, \
	local a, local b, local c
	a = p0 - p1
	b = a + v0
	c = a + b + v1
	return ((c * t - b - c) * t + v0) * t + p0

#defcfunc CRS_interpolate array p, int n, double t, \
	local i, local pN, local p0, local p1, local p2, local v0, local v1, local u
	i = floor(t)
	u = t - i
	pN = get_p@CRS(p, n, i - 1)
	p0 = get_p@CRS(p, n, i    )
	p1 = get_p@CRS(p, n, i + 1)
	p2 = get_p@CRS(p, n, i + 2)
	v0 = (p1 - pN) * 0.5
	v1 = (p2 - p0) * 0.5
	return ferguson_coons_interpolate(p0, p1, v0, v1, u)

/****************************************************************************
 *	[J֐
 ****************************************************************************/

#defcfunc local get_p array p, int n, int i, \
	local a, local b, local c, local d, local j
	assert n >= 1
	if n == 1 {
		return p(0)
	}
	if i < 0 {
		j = -i
		if n == 2 {
			return p(0) + (p(0) - p(1)) * j
		}
		a = p(2)
		b = p(1)
		c = p(0)
		repeat
			d = a + (c - b) * 3.0
			j--
			if j == 0 {
				break
			}
			a = b
			b = c
			c = d
		loop
		return d
	}
	if i > n - 1 {
		j = i - (n - 1)
		if n == 2 {
			return p(n - 1) + (p(n - 1) - p(n - 2)) * j
		}
		a = p(n - 3)
		b = p(n - 2)
		c = p(n - 1)
		repeat
			d = a + (c - b) * 3.0
			j--
			if j == 0 {
				break
			}
			a = b
			b = c
			c = d
		loop
		return d
	}
	return p(i)

#global

