/*
 *	OptionDialog.cpp
 *
 *	P/ECE CLiP Library 3D Object Exporter
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Wed Jul 26 08:43:17 JST 2006 Naoyuki Sawa
 *	- IvV_CAOǉ܂B
 */
#include "app.h"

#define SCALE_FMT	"%6.4f"
#define SCALE_MIN	0.0001
#define SCALE_MAX	9.9999
#define SCALE_UNIT	0.0010

#define EXP_FMT		"%d"
#define EXP_MIN		-99
#define EXP_MAX		 99

static OPTION* option;
static HBITMAP hBmpAxisX;
static HBITMAP hBmpAxisY;
static HBITMAP hBmpAxisZ;

static BOOL CALLBACK
DialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HWND hWndScale = GetDlgItem(hWndDlg, IDC_SCALE);
	HWND hWndScaleSpin = GetDlgItem(hWndDlg, IDC_SCALE_SPIN);
	HWND hWndExp = GetDlgItem(hWndDlg, IDC_EXP);
	HWND hWndExpSpin = GetDlgItem(hWndDlg, IDC_EXP_SPIN);
	HWND hWndAxis = GetDlgItem(hWndDlg, IDC_AXIS);
	HWND hWndAxisX = GetDlgItem(hWndDlg, IDC_AXIS_X);
	HWND hWndAxisY = GetDlgItem(hWndDlg, IDC_AXIS_Y);
	HWND hWndAxisZ = GetDlgItem(hWndDlg, IDC_AXIS_Z);
	//
	char str[256];
	double d;
	int e;

	switch(uMsg) {
	case WM_INITDIALOG:
		{
			d = option->scale;
			if(d < SCALE_MIN) d = SCALE_MIN;
			if(d > SCALE_MAX) d = SCALE_MAX;
			_snprintf(str, sizeof str, SCALE_FMT, d);
			SetWindowText(hWndScale, str);
			SendMessage(hWndScaleSpin, UDM_SETRANGE32, 0, 1); /* ŵ݁Bl̓_~[ */

			e = option->exp;
			if(e < EXP_MIN) e = EXP_MIN;
			if(e > EXP_MAX) e = EXP_MAX;
			_snprintf(str, sizeof str, EXP_FMT, e);
			SetWindowText(hWndExp, str);
			SendMessage(hWndExpSpin, UDM_SETRANGE32, EXP_MIN, EXP_MAX);

			switch(option->axis) {
			case 0:
				SendMessage(hWndAxisX, BM_SETCHECK, BST_CHECKED, 0);
				SendMessage(hWndAxis, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpAxisX);
				break;
			case 1:
				SendMessage(hWndAxisY, BM_SETCHECK, BST_CHECKED, 0);
				SendMessage(hWndAxis, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpAxisY);
				break;
			default:
				SendMessage(hWndAxisZ, BM_SETCHECK, BST_CHECKED, 0);
				SendMessage(hWndAxis, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpAxisZ);
				break;
			}

			return TRUE;
		}
	case WM_COMMAND:
		{
			int id = LOWORD(wParam);
			int notifyCode = HIWORD(wParam);
			HWND hWndCtl = (HWND)lParam;

			switch(id) {
			case IDOK:
				{
					GetWindowText(hWndScale, str, sizeof str);
					d = atof(str);
					if(d < SCALE_MIN) d = SCALE_MIN;
					if(d > SCALE_MAX) d = SCALE_MAX;
					option->scale = d;

					GetWindowText(hWndExp, str, sizeof str);
					e = atoi(str);
					if(e < EXP_MIN) e = EXP_MIN;
					if(e > EXP_MAX) e = EXP_MAX;
					option->exp = e;

					if(SendMessage(hWndAxisX, BM_GETCHECK, 0, 0) == BST_CHECKED) {
						option->axis = 0;
					} else if(SendMessage(hWndAxisY, BM_GETCHECK, 0, 0) == BST_CHECKED) {
						option->axis = 1;
					} else {
						option->axis = 2;
					}

					/* FALLTHRU */
				}
			case IDCANCEL:
				{
					EndDialog(hWndDlg, id);
					return TRUE;
				}
			case IDC_AXIS_X:
				{
					SendMessage(hWndAxis, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpAxisX);
					return TRUE;
				}
			case IDC_AXIS_Y:
				{
					SendMessage(hWndAxis, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpAxisY);
					return TRUE;
				}
			case IDC_AXIS_Z:
				{
					SendMessage(hWndAxis, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpAxisZ);
					return TRUE;
				}
			}
			break;
		}
	case WM_NOTIFY:
		{
			int id = wParam; 
			LPNMHDR pnmh = (LPNMHDR)lParam; 

			switch(id) {
			case IDC_SCALE_SPIN:
				{
					switch(pnmh->code) {
					case UDN_DELTAPOS:
						{
							LPNMUPDOWN pnmud = (LPNMUPDOWN)lParam;

							GetWindowText(hWndScale, str, sizeof str);
							d = atof(str);
							d += SCALE_UNIT * pnmud->iDelta;
							if(d < SCALE_MIN) d = SCALE_MIN;
							if(d > SCALE_MAX) d = SCALE_MAX;
							_snprintf(str, sizeof str, SCALE_FMT, d);
							SetWindowText(hWndScale, str);

							return TRUE;
						}
					}
					break;
				}
			}
			break;
		}
	}

	return FALSE;
}

int
DoOptionDialog(HINSTANCE hInstance, HWND hWndParent, OPTION* _option)
{
	int retval;

	option = _option;

	hBmpAxisX = LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_AXIS_X));
	hBmpAxisY = LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_AXIS_Y));
	hBmpAxisZ = LoadBitmap(hInstance, MAKEINTRESOURCE(IDB_AXIS_Z));
	
	retval = DialogBox(hInstance, MAKEINTRESOURCE(IDD_OPTION), hWndParent, DialogProc);

	DeleteObject(hBmpAxisX);
	DeleteObject(hBmpAxisY);
	DeleteObject(hBmpAxisZ);

	return retval == IDOK; /* 1 = OK, 0 = Cancel */
}
