//---------------------------------------------------------------------------
//
//   MQ3DLib.h      Copyright(C) 1999-2000, O.Mizno
//
//    @ƕ֗Ȋ֐WB
//
//---------------------------------------------------------------------------

#ifndef MQ3DLIB_H
#define MQ3DLIB_H

#include <math.h>

// float^_Z֐ɑΉĂȂC++Builder5p΍
#ifdef __BORLANDC__
#define sqrtf sqrt
#endif



// ~
#ifndef PI
	#define PI 3.1415926536f
#endif

// ʓx(0360)烉WA(02)֕ϊ
#ifndef RAD
	#define RAD(_x) ((_x)/180.0f*PI)
#endif

// WA(02)ʓx(0360)֕ϊ
#ifndef DEG
	#define DEG(_x) ((_x)/PI*180.0f)
#endif

// xNg̃TCŶQ
inline float GetNorm(const MQPoint& p)
{
	return p.x*p.x + p.y*p.y + p.z*p.z;
}

// xNg̃TCY
inline float GetSize(const MQPoint& p)
{
	return sqrtf(p.x*p.x + p.y*p.y + p.z*p.z);
}

// xNg̐K
inline MQPoint Normalize(const MQPoint& p) 
{
	float s = GetSize(p);
	if(s == 0.0f)
		return MQPoint(0,0,0);
	return p / s;
}

// ς̒l𓾂
inline float GetInnerProduct(const MQPoint& pa, const MQPoint& pb)
{
	return pa.x * pb.x + pa.y * pb.y + pa.z * pb.z; 
}

// OσxNg𓾂
inline MQPoint GetCrossProduct(const MQPoint& v1, const MQPoint& v2)
{
	return MQPoint(
		v1.y * v2.z - v1.z * v2.y,
		v1.z * v2.x - v1.x * v2.z,
		v1.x * v2.y - v1.y * v2.x);
}

inline MQPoint GetExteriorProduct(const MQPoint& v1, const MQPoint& v2)
{
	return GetCrossProduct(v1, v2); 
}

// 3_Ȃʂ̖@𓾂
MQPoint GetNormal(const MQPoint& p0, const MQPoint& p1, const MQPoint& p2);

// 4_Ȃʂ̖@𓾂
MQPoint GetQuadNormal(const MQPoint& p0, const MQPoint& p1, const MQPoint& p2, const MQPoint& p3);

// 2xNǧpxWAPʂ0΂܂ł̒lœ
float GetCrossingAngle(const MQPoint& v1, const MQPoint& v2);

// Ό̖ʂ݂邩ǂ𒲂ׂ
// ݂Ă΂̖ʂ̃CfbNXAȂ-1Ԃ
int SearchInvertedFace(MQObject obj, int faceindex, int start=-1, int end=-1);


// IuWFNg̖@vZNX
class MQObjNormal
{
protected:
	MQPoint *normal;
public:
	MQObjNormal(MQObject obj);
	virtual ~MQObjNormal();

	inline MQPoint& Get(int face_index, int pt_index) {
		return normal[face_index*4 + pt_index];
	}
};


// MQObjEdgeNXŎgpGbWΏ
class MQObjEdgePair
{
public:
	int face;
	int line;

	inline MQObjEdgePair() { face = line = -1; }
	inline MQObjEdgePair(int f, int l) { face = f; line = l; }
	inline MQObjEdgePair& operator = (const MQObjEdgePair& r)
		{ face=r.face; line=r.line; return *this; }
};

typedef MQObjEdgePair MQObjEdgePairFace[4];


// IuWFNg̃GbWΊǗNX
class MQObjEdge
{
protected:
	int m_face;
	MQObject m_obj;
	MQObjEdgePairFace *m_pair;
public:
	MQObjEdge(MQObject obj);
	virtual ~MQObjEdge();

	bool getPair(int face_index, int line_index, int& pair_face, int& pair_line);
};


#endif //MQ3DLIB_H