/*
 *	tcpip.c
 *
 *	TCP/IPvgRXC[g
 *
 *	* Sat Sep 24 22:17:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Oct 01 18:26:00 JST 2005 Naoyuki Sawa
 *	- tcpip_start()ɂāAJn0.5bԂ̑҂Ԃǉ܂B
 */
#include "app.h"

#ifdef USE_TCPIP

/****************************************************************************
 *	
 ****************************************************************************/

#define TCPIP_CONFIG_FNAME	"tcpip.cfg"	/* ݒt@C */

/* TCP/IPݒt@C */
typedef struct _TCPIPCONFIG {
	IPCONFIG ip_config;	/* IPݒ */
	int dns_server;		/* DNSݒ */
} TCPIPCONFIG;

/*--------------------------------------------------------------------------*/

static int tcpip_garp_timer;	/* Gratuitous ARP쓮^C} (0:~) */

/*--------------------------------------------------------------------------*/

static int tcpip_load_config(TCPIPCONFIG* config);
static int tcpip_save_config(const TCPIPCONFIG* config);

static void tcpip_get_config(TCPIPCONFIG* config);
static void tcpip_set_config(const TCPIPCONFIG* config);

static int tcpip_do_config(TCPIPCONFIG* config, int cancelable);

/****************************************************************************
 *	
 ****************************************************************************/

void
tcpip_start(int txbuf_capacity)
{
	TCPIPCONFIG config;

	if(tcpip_garp_timer) {
		DIE(); /* dN͋֎~ł */
	}

	/* TCP/IPݒ[h܂B */
	if(tcpip_load_config(&config) != 0) {

		/* ǂݍݎsȂ΁Ȁݒli[Ă܂B */
		config.ip_config.ip_address      = IP_ADDRESS(192,168,255,  1);
		config.ip_config.subnet_mask     = IP_ADDRESS(255,255,255,  0);
		config.ip_config.default_gateway = IP_ADDRESS(192,168,255,254);
		config.dns_server                = IP_ADDRESS(202,234,232,  6); /* vC}DNS */
		//config.dns_server                = IP_ADDRESS(221,113,139,250); /* ZJ_DNS */

		/* TCP/IPݒs܂B */
		tcpip_do_config(&config, 0/*LZs*/);
	}

	/* AvP[VJnAŒ0.1bԂ͏x点܂B
	 * R}hvvgrunŎsꍇɁAUSBCOMs߂łB
	 */
	while(now < SEC(0.1)) {
		schedule();
	}

	/* EthernethCoJn܂B */
	ethernet_start(txbuf_capacity);

	/* IPhCoJn܂B */
	ip_start();

	/* UDPhCoJn܂B */
	udp_start();

	/* TCPhCoJn܂B */
	tcp_start();

	/* Gratuitous ARPJn܂B(ΏǗÖ@) */
	tcpip_garp_timer = timer_start(5000, (void(*)())arp_gratuitous, NULL);

	/* TCP/IPݒ𔽉f܂B */
	tcpip_set_config(&config);

	/* * Windows̃foCXhCoƁAvgRoCfBO܂ŁAʐMł܂B
	 *   vԂsȂ̂(PCƐڑĂs)A0.5bx҂Ƃɂ܂B
	 * - Ał̑҂ԂĂȂĂAۂ̒ʐMJn܂łɏ[ȎԂLΖ肠܂B
	 *   ܂AʐMJnɑ҂ԂĂȂĂAŏ̒̕ʐMs邾ŁA񕜂͂łB
	 */
	delay(SEC(0.5));
}

void
tcpip_stop()
{
	TCPIPCONFIG config;

	if(!tcpip_garp_timer) {
		return; /* NĂȂ΁A܂ */
	}

	/* TCP/IPݒ擾܂B */
	tcpip_get_config(&config);

	/* Gratuitous ARP~܂B(ΏǗÖ@) */
	timer_stop(tcpip_garp_timer);
	tcpip_garp_timer = 0; /* YȂ!! */

	/* TCPhCo~܂B */
	tcp_stop();

	/* UDPhCo~܂B */
	udp_stop();

	/* IPhCo~܂B */
	ip_stop();

	/* EthernethCo~܂B */
	ethernet_stop();

	/* TCP/IPݒZ[u܂B */
	tcpip_save_config(&config);
}

void
tcpip_config()
{
	TCPIPCONFIG config;

	if(!tcpip_garp_timer) {
		DIE(); /* NłȂ΁Aݒł܂ */
	}

	/* SẴ{^܂ŁAҋ@܂B */
	while(joy & PAD_MASK) {
		schedule();
	}

	/* TCP/IPݒ擾܂B */
	tcpip_get_config(&config);

	/* TCP/IPݒsAOKȂ΁Af܂B */
	if(tcpip_do_config(&config, 1/*LZ\*/) == 0) {
		tcpip_set_config(&config);
	}

	/* SẴ{^܂ŁAҋ@܂B */
	while(joy & PAD_MASK) {
		schedule();
	}
}

/*--------------------------------------------------------------------------*/

/* 荞݋֎~̗ŔApceFileWriteSct()ƁA荞ݒmalloc()/free()Փ˂̂h߂łB */

static int
tcpip_load_config(TCPIPCONFIG* config)
{
	int result = -1;
	//
	FILEACC fa;

ENTER_CS;

	/* ݒt@CI[vAǂݍ݁AN[Y܂B */
	if(pceFileOpen(&fa, TCPIP_CONFIG_FNAME, FOMD_RD) == 0) {
		if(fa.fsize == sizeof(TCPIPCONFIG)) {
			if(pceFileReadSct(&fa, config, 0, sizeof(TCPIPCONFIG)) == sizeof(TCPIPCONFIG)) {
				result = 0; /*  */
			}
		}
		pceFileClose(&fa);
	}

LEAVE_CS;

	return result;
}

static int
tcpip_save_config(const TCPIPCONFIG* config)
{
	int result = -1;
	//
	FILEACC fa;
	int old_turbo;
	TCPIPCONFIG old_config;

ENTER_CS;

	/* pceFileCreate()ApceFileWriteSct()̂߂ɁAm24MHzɖ߂܂B */
	old_turbo = turbo(0);

	/* ݒt@Cǂݍ݂܂B */
	if(tcpip_load_config(&old_config) == 0) {

		/* V̐ݒt@CȂ΁AɏԂ܂B */
		if(memcmp(config, &old_config, sizeof(TCPIPCONFIG)) == 0) {
			result = 0; /*  */
			goto L_EXIT;
		}
	}

	/* Vݒt@C()쐬AI[vA݁AN[Y܂B */
	if(pceFileCreate(TCPIP_CONFIG_FNAME, sizeof(TCPIPCONFIG)) == 0) {
		if(pceFileOpen(&fa, TCPIP_CONFIG_FNAME, FOMD_WR) == 0) {
			if(pceFileWriteSct(&fa, config, 0, sizeof(TCPIPCONFIG)) == sizeof(TCPIPCONFIG)) {
				result = 0; /*  */
			}
			pceFileClose(&fa);
		}
	}

L_EXIT:	/*------------------------------------------------------------------*/

	/* KvɉāA48MHz𕜌܂B */
	turbo(old_turbo);

LEAVE_CS;

	return result;
}

/*--------------------------------------------------------------------------*/

static void
tcpip_get_config(TCPIPCONFIG* config)
{
	if(!tcpip_garp_timer) {
		DIE(); /* TCP/IP~́Aݒ擾ł܂ */
	}

	/* IPݒ擾܂B */
	ip_get_config(&config->ip_config);

	/* DNSݒ擾܂B */
	config->dns_server = dns_get_server();
}

static void
tcpip_set_config(const TCPIPCONFIG* config)
{
	if(!tcpip_garp_timer) {
		DIE(); /* TCP/IP~́Aݒ𔽉fł܂ */
	}

	/* IPݒ𔽉f܂B */
	ip_set_config(&config->ip_config);

	/* DNSݒ𔽉f܂B */
	dns_set_server(config->dns_server);
}

/*--------------------------------------------------------------------------*/

static int
tcpip_do_config(TCPIPCONFIG* config, int cancelable)
{
	int T0  = pceTimerGetCount();
	int col = 11;
	int row =  0;
	int ok  =  1;
	//
	int a;
	int b;
	int c;
	int d;
	int i;
	int j;
	int x;
	int y;
	int fore;
	int back;
	int ip_address_changed;
	unsigned char digit[4][12];

	/* ݒlWJ܂B */
	for(i = 0; i < 4; i++) {
		switch(i) {
		case 0: a = config->ip_config.ip_address;      break;
		case 1: a = config->ip_config.subnet_mask;     break;
		case 2: a = config->ip_config.default_gateway; break;
		case 3: a = config->dns_server;                break;
		default: DIE();
		}
		for(j = 0; j < 12; j += 3) {
			b = (a >> 24) & 255;
			digit[i][j + 0] = (b / 100) % 10;
			digit[i][j + 1] = (b /  10) % 10;
			digit[i][j + 2] = (b /   1) % 10;
			a <<= 8;
		}
	}

	for(;;) {
		schedule();

		/* {^ĂԁAJ[\_ł~܂B */
		if(joy & PAD_MASK) {
			T0 = pceTimerGetCount();
		}

		/* SELECT{^ꂽAɃLZ܂B */
		if(cancelable) {
			if(joy & TRG_SELECT) {
				ok = 0;
				break;
			}
		}

		/* {^ꂽAڂI܂B */
		if(joy & TRG_LF) {
			if(row == 4) {
				if(cancelable) {
					ok = !ok;
				}
			} else {
				if(col == 0) {
					col = 11;
				} else {
					col--;
				}
			}
		}
		if(joy & TRG_RI) {
			if(row == 4) {
				if(cancelable) {
					ok = !ok;
				}
			} else {
				if(col == 11) {
					col = 0;
				} else {
					col++;
				}
			}
		}
		if(joy & TRG_UP) {
			if(row == 0) {
				row = 4;
			} else {
				row--;
			}
		}
		if(joy & TRG_DN) {
			if(row == 4) {
				row = 0;
			} else {
				row++;
			}
		}

		ip_address_changed = 0;

		/* A{^ꂽ... */
		if(joy & TRG_A) {

			/* OKA܂́ALZIĂA܂B */
			if(row == 4) {
				break;

			/* lڂIĂ... */
			} else {

				/* IĂ錅𑝂₵܂B */
				if(digit[row][col] == 9) {
					digit[row][col] = 0;
				} else {
					digit[row][col]++;
				}

				/* 255𒴂A荞݂܂B */
				switch(col % 3) {
				case 0: /* 100̈ */
					if(digit[row][col + 0] * 100 +
					   digit[row][col + 1] *  10 +
					   digit[row][col + 2] *   1 > 255) {
						digit[row][col] = 0;
					}
					break;
				case 1: /*  10̈ */
					if(digit[row][col - 1] * 100 +
					   digit[row][col + 0] *  10 +
					   digit[row][col + 1] *   1 > 255) {
						digit[row][col] = 0;
					}
					break;
				case 2: /*   1̈ */
					if(digit[row][col - 2] * 100 +
					   digit[row][col - 1] *  10 +
					   digit[row][col + 0] *   1 > 255) {
						digit[row][col] = 0;
					}
					break;
				default:
					DIE();
				}

				/* IPAhXύXꂽƂ}[N܂B */
				if(row == 0) {
					ip_address_changed = 1;
				}
			}
		}

		/* B{^ꂽ... */
		if(joy & TRG_B) {

			/* OKA܂́ALZIĂA܂B */
			if(row == 4) {
				break;

			/* lڂIĂ... */
			} else {

				/* IĂ錅炵܂B */
				if(digit[row][col] == 0) {
					digit[row][col] = 9;
				} else {
					digit[row][col]--;
				}

				/* 255𒴂A荞݂܂B */
				switch(col % 3) {
				case 0: /* 100̈ */
					if(digit[row][col + 0] * 100 +
					   digit[row][col + 1] *  10 +
					   digit[row][col + 2] *   1 > 255) {
						digit[row][col] = 2;
					}
					break;
				case 1: /*  10̈ */
					if(digit[row][col - 1] * 100 +
					   digit[row][col + 0] *  10 +
					   digit[row][col + 1] *   1 > 255) {
						digit[row][col] = 5;
					}
					break;
				case 2: /*   1̈ */
					if(digit[row][col - 2] * 100 +
					   digit[row][col - 1] *  10 +
					   digit[row][col + 0] *   1 > 255) {
						digit[row][col] = 5;
					}
					break;
				default:
					DIE();
				}

				/* IPAhXύXꂽƂ}[N܂B */
				if(row == 0) {
					ip_address_changed = 1;
				}
			}
		}

		/* ʂNA܂B */
		surface_clear(&surface, 0);

		/* ^Cg\܂B */
		render_rectangle_fill(&render, 0, 0, 128, 10, 3);
		render_printf(&render, 0, 0, 0x80, 0, "TCP/IPݒ");

		/* lڂ\܂B */
		y = 11;
		for(i = 0; i < 4; i++) {
			x = 5;

			switch(i) {
			case 0: render_printf(&render, x, y, 0x80, 3, "IPڽ  "); break;
			case 1: render_printf(&render, x, y, 0x80, 3, "ȯϽ"); break;
			case 2: render_printf(&render, x, y, 0x80, 3, "ްĳ  "); break;
			case 3: render_printf(&render, x, y, 0x80, 3, "DNS  "); break;
			default: DIE();
			}

			x += 5 * 9;

			render_line(&render, x + 2, y + 2, x + 4, y + 2, 3);
			render_line(&render, x + 2, y + 6, x + 4, y + 6, 3);

			x += 5;

			for(j = 0; j < 12; j++) {
				if((i == row) && (j == col) && ((pceTimerGetCount() - T0) % 500 < 300)) {
					fore =  0;
					back =  2;
				} else {
					fore =  3;
					back = -1;
				}
				if(back >= 0) {
					render_rectangle_fill(&render, x, y, 6, 9, back);
				}

				switch(j % 3) {
				case 0: /* 100̈ */
					if(!digit[i][j]) {
						fore = 1;
					}
					break;
				case 1: /*  10̈ */
					if(!digit[i][j] && !digit[i][j - 1]) {
						fore = 1;
					}
					break;
				}
				render_printf(&render, x, y, 0x80, fore, "%d", digit[i][j]);

				x += 5;

				if((j == 2) || (j == 5) || (j == 8)) {
					render_point(&render, x + 1, y + 7, 3);
					x += 2;
				}
			}

			y += 10;
		}

		/* IPAhXύXꂽ... */
		if(ip_address_changed) {

			/* ύXIPAhX擾܂B */
			a = 0;
			for(i = 0; i < 12; i += 3) {
				x = digit[0][i + 0] * 100
				  + digit[0][i + 1] *  10
				  + digit[0][i + 2] *   1;
				a = a << 8 | x;
			}

			/* ύXÕTulbg}XN擾܂B */
			b = 0;
			for(i = 0; i < 12; i += 3) {
				x = digit[1][i + 0] * 100
				  + digit[1][i + 1] *  10
				  + digit[1][i + 2] *   1;
				b = b << 8 | x;
			}

			/* ύXÕftHgQ[gEFC擾܂B */
			c = 0;
			for(i = 0; i < 12; i += 3) {
				x = digit[2][i + 0] * 100
				  + digit[2][i + 1] *  10
				  + digit[2][i + 2] *   1;
				c = c << 8 | x;
			}

			/* ύX̃Tulbg}XN쐬܂B */
			d = ip_address_class_mask(a);

			/* Tulbg}XNωAݒ肵܂B */
			if(b != d) {
				x = d;
				for(i = 0; i < 12; i += 3) {
					y = (x >> 24) & 255;
					digit[1][i + 0] = (y / 100) % 10;
					digit[1][i + 1] = (y /  10) % 10;
					digit[1][i + 2] = (y /   1) % 10;
					x <<= 8;
				}
			}

			/* ύXIPAhX̃lbg[NƁAύXÕftHgQ[gEFC̃lbg[NĂA
			 * ftHgQ[gEFC̃lbg[NAύXIPAhX̃lbg[Nɍ킹܂B
			 */
			if((a & d) != (c & d)) {
				x = (a & d) | (c & ~d);
				for(i = 0; i < 12; i += 3) {
					y = (x >> 24) & 255;
					digit[2][i + 0] = (y / 100) % 10;
					digit[2][i + 1] = (y /  10) % 10;
					digit[2][i + 2] = (y /   1) % 10;
					x <<= 8;
				}
			}
		}

		/* OKALZ\܂B */
		y =  77;
		x = 100;

		if(cancelable) {
			if((row == 4) && !ok && ((pceTimerGetCount() - T0) % 500 < 300)) {
				fore =  0;
				back =  2;
			} else {
				fore =  3;
				back = -1;
			}
			if(back >= 0) {
				render_rectangle_fill(&render, x, y, 26, 9, back);
			}
			render_rectangle(&render, x - 1, y - 1, 28, 11, 1);
			render_printf(&render, x, y, 0x80, fore, "ݾ");

			x -= 14;
		} else {
			x += 15;
		}

		if((row == 4) && ok && ((pceTimerGetCount() - T0) % 500 < 300)) {
			fore =  0;
			back =  2;
		} else {
			fore =  3;
			back = -1;
		}
		if(back >= 0) {
			render_rectangle_fill(&render, x, y, 11, 9, back);
		}
		render_rectangle(&render, x - 1, y - 1, 13, 11, 1);
		render_printf(&render, x, y, 0x80, fore, "OK");

	}

	/* ݒli[܂B */
	if(ok) {
		for(i = 0; i < 4; i++) {
			a = 0;
			for(j = 0; j < 12; j += 3) {
				b = digit[i][j + 0] * 100
				  + digit[i][j + 1] *  10
				  + digit[i][j + 2] *   1;
				a = a << 8 | b;
			}
			switch(i) {
			case 0: config->ip_config.ip_address      = a; break;
			case 1: config->ip_config.subnet_mask     = a; break;
			case 2: config->ip_config.default_gateway = a; break;
			case 3: config->dns_server                = a; break;
			default: DIE();
			}
		}
	}

	return ok ? 0/*OK*/ : -1/*LZ*/;
}

/****************************************************************************
 *	
 ****************************************************************************/

#endif /*USE_TCPIP*/
